UNIT GRILLES;

   {------------------------------------------------------------------------}
   {      GEOCEAN                                                           }
   {                       Lecture Grilles                                  }
   {                                                            30/01/93    }
   {------------------------------------------------------------------------}

   (*
   GRILLES,                  { ARX     - lecture des grilles                }
   *)

INTERFACE
{$O+,F+}

USES
   Dos,
   Objects,                 { TP 70   - units standard                    }
   Fichiers                 { ARX     - Gestion des fichiers et erreurs    }
   ;

CONST
 (*  NbMaxCol             = 150;     { Nombre limite de colonnes }
   NbMaxLig             = 90;      { Nombre limite de lignes   }
                                   { 140*110 possible
                                      mais 150*100 col --> err exec  201} *)
   NbMaxCol             = 121;     { Nombre limite de colonnes }
   NbMaxLig             = 121;     { Nombre limite de lignes   }


   ValIndef             = 32767;   { Valeur entire indfinie  }
   INDEFINI             = 1.7e+38; { Valeur relle indfinie   }

TYPE
   UneLigne             = array [1..NbMaxCol] of real;
   SurLigne             = ^UneLigne;
   UneGrille            = array [1..NbMaxLig] of SurLigne;

   PGrille              = ^TGrille;
   TGrille              = Object (TObject)
      Grille            : UneGrille;
      NbLignes,         { Nombre de lignes charges }
      NbLigI, NbCogI,   { Nb lignes et colonnes initiaux }
      NbLig, NbCog      : Integer;
      MaxXG, MinXG,
      MaxYG, MinYG,
      MinZG, MaxZG,
      PasXgrille,
      PasYgrille        : real;
      Signature         : string;

      Constructor init;

      Function  absx     (i : integer)       : real;
         { calcule l'abscisse de la colonne I dans le repre de la carte }

      Function  ordy     (j : integer)       : real;
         { calcule l'ordonne de la ligne J dans le repre de la carte }

      Function  rangx    (x : real)          : integer;
         { calcule le rang de la colonne la plus proche de x }

      Function  rangy    (y : real)          : integer;
         { calcule le rang de la ligne la plus proche de y }

      Function  Valeur   (i, j : integer)    : real;
         { renvoie la valeur (nouveau repre) de la station (x,y) }

      Procedure Affecter (a, b : integer;
                          z    : real);
         { Met  jour une valeur dans la grille }

      Procedure Charger  (nomf : pathstr;
                          var debx, finx, deby, finy : real);
         { La grille utilise est un fichier ascii muni d'une en-tte :
           signature DSAA (compatible SURFER),  ou autre ... (INRP ou GEOC),
           nombre de colonnes et de lignes de la grille,
           valeurs mini et maxi en X, Y et Z.
           Valeurs indfinies suprieures au maxi en Z.
           La totalit de la grille est charge en mmoire si les valeurs
           limites dbordent celles de l'entte. }

      Procedure Remplacer (v1, v2 : real);
         { }

      Procedure Sauver    (nomf   : pathstr;
                           debx, finx, deby, finy : real);
         { Gnre un fichier grille }

      Procedure Liberer;
         { }

      Destructor done; virtual;
         { }
   end;

VAR
   lagrille,
   lagrill2             : TGrille;
   v_indef              : real;        { valeur indfinie                   }

   {------------------------------------------------------------------------}

IMPLEMENTATION

constructor TGrille.init;
   var
      i                 : integer;

   begin
      TObject.init;
      NbLignes := 0;
      for i := 1 to NbMaxLig
      do
         grille [i] := NIL;
   end;

procedure TGrille.Liberer;
   var
      i                 : integer;

   begin
      if NbLignes <> 0
      then
         for i := 1 to NbLignes
         do
            if grille [i] <> NIL
            then
               dispose (grille [i]);
      NbLignes := 0;
      for i := 1 to NbMaxLig
      do
         grille [i] := NIL;
   end;

destructor TGrille.done;
   begin
      Liberer;
      TObject.done;
   end;

function TGrille.absx (i : integer) : real;
   { calcule l'abscisse de la colonne I dans le repre de la carte }
   begin
      absx := minxg + (i-1) * pasxgrille;
   end;

function TGrille.ordy (j : integer) : real;
   { calcule l'ordonne de la ligne J dans le repre de la carte }
   begin
      ordy := minyg + (j-1) * pasygrille;
   end;

function  TGrille.rangx (x : real) : integer;
{ calcule le rang de la colonne la plus proche de x }
   begin
      rangx := trunc (round ((x-minxg)/PasXGrille));
   end;

function  TGrille.rangy (y : real) : integer;
{ calcule le rang de la ligne la plus proche de y }
   begin
      rangy := trunc (round ((y-minyg)/PasYGrille));
   end;

function  TGrille.Valeur (i, j : integer) : real;
   begin
      if j > nblig then j := nblig;
      if i > nbcog then i := nbcog;
      if i < 1 then i := 1;
      if j < 1 then j := 1;
      Valeur := Grille [j]^[i];
   end;

procedure TGrille.Affecter (a, b : integer; z : real);
   begin
      Grille [b]^[a] := z;
   end;

{****************************************************************************}
procedure TGrille.Charger (nomf : pathstr; var debx, finx, deby, finy : real);
   var
      i, j,
      dx, fx, dy, fy    : integer;
      n_minx, n_miny    : real;
      fentree           : text;
      ok                : boolean;

   procedure allouerLigne (li : integer);
      begin
         if grille [li] = NIL
         then begin
            new ( grille [li] );
            if li > NbLignes then NbLignes := li;
         end;
      end;

   procedure lire  (a, b : integer);
      var
         z              : real;

      begin                            { procedure lire }
         read (fentree, z);            { nombres rels  }
         if (a >= dx) and (a <= fx) and (b >= dy) and (b <= fy)
         then
            Grille [b-dy+1]^[a-dx+1] := z;
      end;

   begin                               { lire_grille }
      assign (fentree, nomf);
      resetTxtErr  (fentree, nomf, ok);
      Liberer;                         { initialisations pointeurs }
                                       { lecture en-tte fichier   }
      readln (fentree);                            { signature SURFER : DSAA}
      readln (fentree, NbCoG, NbLiG);
      readln (fentree, MinXG, MaxXG);
      readln (fentree, MinYG, MaxYG);
      readln (fentree, minZG, maxZG);
      pasxgrille := (maxXg - minXg) / (nbcog - 1);
      pasygrille := (maxYg - minYg) / (nblig - 1);

      nbligI := nblig;
      nbcogI := nbcog;
      if Nblig > nbmaxlig    { troncature bas gauche }
      then begin
         Nblig := nbmaxlig;
         maxYg := minYg+ (Nblig-1) * pasYgrille;
      end;
      if Nbcog > nbmaxcol
      then begin
         Nbcog := nbmaxcol;
         maxXg := minXg+ (Nbcog-1) * pasXgrille;
      end;

      { si coord. non ou mal initialises alors on prend le tout }
      if (debx>=finx)
      then begin
         debx := MinXg;
         finx := MaxXg
      end;
      if (deby>=finy)
      then begin
         deby := MinYg;
         finy := MaxYg
      end;

      if debx < minXg then debx := minXg;          { troncature sous-grille }
      if finx > maxXg then finx := maxXg;
      if deby < minYg then deby := minYg;
      if finy > maxYg then finy := maxYg;

      dx := trunc ((debx-minXg) / pasxgrille)+1;   { rech. col. dbut et fin }
      dy := trunc ((deby-minYg) / pasygrille)+1;

      fx := round ((finx-minXg) / pasxgrille)+1;   { rech. lig. dbut et fin }
      fy := round ((finy-minYg) / pasygrille)+1;

      for j := 1 to nblig
         { mthode ignore la fin du fichier }
         { mais indispensable si on veut prendre 1 pt /2 par  exemple }
      do begin
         if j >= dy
         then
            AllouerLigne (j-dy+1);
         for i := 1 to nbcogI
         do begin
            lire (i, j);                           { chaque valeur }
         end;
      end;
      close (fentree);
      NbCog  := fx - dx + 1;
      NbLig  := fy - dy + 1;

      n_MinX := absx (dx);                         { temp }
      MaxXg  := absx (fx);                         { nouveau Maxxg }
      Minxg  := n_Minx;
      n_MinY := ordy (dy);
      MaxYg  := ordy (fy);
      Minyg  := n_Miny;
   end;

procedure TGrille.Remplacer;
   var
      i, j              : integer;

   begin
      for j := 1 to nblig
      do
         for i := 1 to nbcog
         do
            if Valeur (i, j) = v1
            then
               Affecter (i, j, v2);
   end;

procedure TGrille.Sauver (nomf : pathstr; debx, finx, deby, finy : real);
   begin
   end;

(*   A REFAIRE si utile !
procedure sauver_grille (nomf : string; debx, finx, deby, finy : real);
   var
      f                       : text;
      i, j, k, nbl, nbc       : integer;
      z                       : real;

   begin
      assign  (f, nomf);
      rewrite (f);
     { rechercher min/max dans la zone }
     { recalculer limites }
      sign_inrp := 'INRP';
      writeln (f, sign_inrp);
      writeln (f, nbc:6, nbl:6);
      writeln (f, debX:6:0, finX:6:0);
      writeln (f, debY:6:0, finY:6:0);
      writeln (f, debZ:6:0, finZ:6:0);
      for j := 1 to nblig
      do begin
         for k := 1 to nbcog div 10
         do begin
            for i := 1 to 10 do
               write (f, Grille (10*(k-1), j):6:0 );
            writeln (f);
         end;
         for i := 1 to nbc mod 10
         do
            write (f, Grille (10* (nbc div 10 - 1)+i , j):6:0);
         writeln (f);
      end;
      close   (f);
   end;                         *)


END.

{--- GEOCEAN - GRILLES ---------------------- R.C.- INRP - TOULOUSE - 1993 }
