Unit MathH;

                   { ****************************
                     * Procedures mathmatiques *
                     *          et              *
                     *   constantes courantes   *
                     **************************** }

INTERFACE

Uses UtilDivs;

Const {pi    =    3.141592654;}
      pis2  =    1.570796327; { = Pi / 2 }
      pi2   =    6.283185308; { = Pi * 2 }
      rad   =    0.017453292; { facteur mult. pour conversion degr->radian }
      deg   =   57.29578    ; {   "      "      "      "      radian->degr }
      epsil = 1.0e-6;

Function OuiNon (Message1,Message2 : String):Boolean;

Function EntierChaine(i : Integer):String;

Function ReelChaine(x : real;car,deci : Byte):String;

function TAN (x:real): real;
{ Retourne la tangente de l'argument (en radians) }

function ARCOS (x: real): real;
{ Retourne l'arc cosinus en radians de l'argument
  Ecrit un message d'erreur et stoppe l'excution en cas d'erreur }

function ARSIN (x: real): real;
{ Retourne l'arc sinus en radians de l'argument
  Ecrit un message d'eerreur et stoppe l'excution en cas d'erreur }

function ATan2 (x,y: real): real;
{ Retourne l'arc yangente en radians de x/y }

function MIN (i, j : integer) : integer;
{ Retourne le minimum de deux entiers }

function MAX (i, j : integer) : integer;
{ Retourne le maximum de deux entiers }

function AMIN (x, y : real) : real;
{ Retourne le minimum de deux rels }

function AMAX (x, y : real) : real;
{ Retourne le maximum de deux rels }

function MODULO (i,j : integer): integer;
{ Retourne i modulo j (entiers) }

function RMODULO (x,y: real) : real;
{ Retourne x modulo y (rels) }

procedure ECHANGE (var x,y; T : Word);
{ Echange deux zones de taille T en octets }

procedure ECHANGER (var x,y: real);
{ Echange deux rels x et y }

procedure ECHANGEI (var x,y: Integer);
{ Echange deux entiers x et y }

Function Exp0(x : Real):Real;
{ Exponentielle sans dpassement de capacit }

Function IPuissance(x:real;p:Integer):Real;
{ calcule la p-ime puissance entiere de x}

IMPLEMENTATION

Function OuiNon (Message1,Message2 : String):Boolean;
Var Oui : Boolean;
Begin question (Message1,Message2,Oui );
      OuiNon := Oui;
end;

Function EntierChaine(i : Integer):String;
Var s : String;
Begin Str(i,s);EntierChaine :=s end;

Function ReelChaine(x : real;car,deci : Byte):String;
Var s : String;
Begin Str(x:car:deci,s);ReelChaine :=s end;

function TAN (x:real): real;
begin
  tan := sin(x) / cos (x);
end;

function ARCOS (x: real): real;
begin
  if Abs(x) > 1.0 then begin
    writeln(' ***arcos***  arg =',x,' greater than 1.0'); halt(1); end;
  if x = 0 then arCos := Pi/2
           else arcos := Arctan (Sqrt(1.0-x*x)/x);
end;

function ARSIN (x: real): real;
begin
  if Abs(x) > 1.0 then begin
    writeln(' ***arsin***  arg =',x,' greater than 1.0'); halt(1); end;
  if x = 1 then arSin := Pi/2
           else arsin := Arctan (x/Sqrt(1.0-x*x));
end;

function ATan2 (x,y: real): real;
{ Retourne l'arc yangente en radians de x/y }
Begin If y<>0 then ATan2 := ArcTan(x/y)
              else if x>0 then ATan2 := PiS2
                          else ATan2 := -Pis2;
end;

function MIN (i, j : integer) : integer;
begin
  if (i < j ) then MIN := i else MIN := j;
end;

function MAX (i, j : integer) : integer;
begin
  if (i > j ) then MAX := i else MAX := j;
end;

function AMIN (x, y : real) : real;
begin
  if (x < y ) then AMIN := x else AMIN := y;
end;

function AMAX (x, y : real) : real;
begin
  if (x > y ) then AMAX := x else AMAX := y;
end;

function MODULO (i,j : integer): integer;
begin
  MODULO := i - j * (i div j);
end;

function RMODULO (x,y: real) : real;
begin
  RMODULO := x - y * trunc (x/y);
end;

procedure ECHANGE (var x,y; T : Word);
{ Echange deux zones de taille T en octets }
Type Octets=Array[0..MaxInt] of byte;
Var P : Byte ;i : Word;
begin For i:=0 to T-1 do begin P:=Octets(X)[i];
                               Octets(X)[i]:=Octets(y)[i];
                               Octets(y)[i]:=P end;
end;

procedure ECHANGER (var x,y: real);
var z : real;
begin
  z := x;
  x := y;
  y := z;
end;

procedure ECHANGEI (var x,y: Integer);
var z : Integer;
begin
  z := x;
  x := y;
  y := z;
end;

Function Exp0(x : Real):Real;
Begin If x>88     then Exp0:=1.7E38 else
      If x>-11357 then Exp0:=exp(x) else Exp0 := 0 end;

Function IPuissance(x:real;p:Integer):Real;
{ calcule la p-ime puissance entiere de x}
Var i : Integer; T : Real;
Begin t:=1; For i:=1 to p do t:=t*x; IPuissance:=t end;

end.