UNIT NUAG_DES;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                procdures graphiques du module NUAGES                  }
   {                                             version 1.0 du  22/01/95   }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES

   crt,
   Graph,                    { TP 70   - units  standard Borland           }
   Souris,                   { arx     - gestion de la  souris              }
   Clavier,                  { arx     - gestion du clavier                 }
   Graphism,                 { ARx     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }

   Edition,                  { arX     - saisie/dition paramtres          }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { aRX     - Gestion des fichiers et erreurs    }
   Graphplt,                 { aRX     - graphisme 2D cran/traceur         }
   Graph3D,                  { arX     - procdures graphiques 3D           }
   Graphsg,                  { aRx     - symboles et graduations            }
   Menus,                    { arX     - interface menus                    }
   Icones,                   { arX     - gestion de icnes                  }
   Csi,                      { aRX     - Clavier, Souris, Icnes            }
   Curseurs,                 { ARx     - Potentiomtres simples et doubles  }
   Symboles,                 { aRx     - Affichage des valeurs ponctuelles  }
   Fctmath,                  { Arx     - Fonctions mathmatiques diverses   }
   Math3d_c,                 { Arx     - fonctions math 3d                  }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   NUAG_var;                 { NUAG    - variables globales du module       }

{---------------------------------------------------------------------------}
Procedure init_m_depart;
Procedure init_v_sortie;
   { affecte les valeurs de la matrice de rotation  enregitrer }

Procedure aff_min_max;
   { }

Procedure defrotations (n :integer) ;
   { }

Procedure termine_points;
   { }

Procedure dessine_triedre ;
   { }

Procedure tourne (a : byte);
   { }

Procedure lecture_fichier (var ok : boolean);
   { }

Procedure modif_org;
   { }

Procedure definit_reference;
   { }

Procedure Affiche;
   { }

Procedure dess_axes;
   { }

Procedure affiche_angles;
   { !! Hauteur et Azimut de l'observateur                                     }

Procedure edi_min_max;
   { Modifie les valeurs extrmes pour afficher les points   (4ime donne) }

Procedure init_cadre;
   { }

Procedure fond_boite ;
   { }

Procedure efftout;
   { efface la carte                                                        }
   { et libre les pointeurs sur la griile                                  }

Procedure def_icones;
   { affecte les zones sensibles                                            }

Procedure dess_icones;
   { affiche les icnes                                                     }

Procedure IniFondEcran;
   { affecte couleur                                                        }

Procedure iniecran;
   { initialise l'tat de l'cran en fonction du fichier param par dfaut   }

Procedure finir;
   { sort en rtablissant l'cran texte                                     }

Procedure Effacer_Commentaires;
   { Efface tout l'cran de travail et redessine en l'tat sauf commentaires}

{---------------------------------------------------------------------------}
Procedure repere;
   { change de repre }

Procedure centrer;
   { changer de centre de rotation }

Procedure visu_bloc;
   { bascule : visualise ou efface le prisme qui limite la rgion           }

Procedure visu_contours;
   { bascule : visualise ou efface les contours                             }

Procedure visu_commentaires;
   { bascule : visualise ou efface les textes                               }

Procedure CALCULER;
   { redessine tout avec les paramtres en cour  }

Procedure commentaires;
   { dfinit les textes  afficher                                          }

Procedure couleurs_xyz;
   { modifie couleur                                                        }

Procedure redess_tout;
   { raffiche  aprs  inversion couleurs                                   }

Procedure effacer_tout_redessiner;
   {}

{---------------------------------------------------------------------------}

IMPLEMENTATION

CONST
{$I croix.cur}

procedure cadrer;
   { SI cc2<= cc1 ou cc4<=cc3 ou hors limites...
     calcule cc2 et cc4 en fonction
         de la position du coin bas-gauche ( cc1, cc3 dans .PAR)
         et de l'extension maxi clture (maxC2, maxC4 dans .CFG)            }
   var
      coeff, coefc      : real;

   begin
      xxg    :=  maxc1;
      xxd    :=  maxc2;
      yyh    :=  maxy-maxc4;
      yyb    :=  maxy-maxc3;

      xxm    :=  (xxg+xxd) div 2;
      yym    :=  (yyh+yyb) div 2;
   end;

procedure fond_boite ;
   begin
      coulbar (1, coulboite);
      bar (maxc1, maxy-maxc4, maxc2, maxy-maxc3);
   end;

procedure efftout;
   begin
      fond_boite;
      params.fini;
      parsymbd.fini;
      liberer_commentaires;
      termine_points;
   end;

procedure ini_par_ecr;
   begin
      maxc1        := 1;           { extension maxi clture }
      maxc2        := posxbtn-4;
      maxc3        := 2*ty+4;
      maxc4        := maxy - hauteurmenu - 1 { ty div 3 };
   end;

procedure def_icones;
   var
      px, py            : integer;

    begin
      px  := posxbtn;
      py  := maxy - (30 + ty);
      bouton_icone (Aidico1,      1, px,    py,    96, 30);

      bouton_icone (Aidico2,      2, px+94, py-2,   2,  2);

      bouton_icone (Aidico3,      3, px,    py-53, 96, 50);

      py  :=  hauteurmenu+6;
      bouton_icone (Aidico4,      4, px,    py,    96, 30);

      py  := py+30+6+30+6;
      bouton_icone (Aidico5,      5, px+33, py,    30, 30);
      bouton_icone (Aidico6,      6, px+66, py,    30, 30);

      bouton_icone (Aidico7,      7, px   , py+33, 30, 30);
      bouton_icone (Aidico8,      8, px+33, py+33, 30, 30);
      bouton_icone (Aidico9,      9, px+66, py+33, 30, 30);

      bouton_icone (Aidico10,    10, px+33, py+66, 30, 30);
      bouton_icone (Aidico11,    11, px+66, py+66, 30, 30);

      py  :=  py+99;
      bouton_icone (Aidico12,    12, px,    py   , 30, 30);
      bouton_icone (Aidico13,    13, px+33, py   , 30, 30);
      bouton_icone (Aidico14,    14, px,    py+33, 30, 30);
      bouton_icone (Aidico15,    15, px+33, py+33, 30, 30);

      py  := py+66;
      bouton_icone (Aidico16,    16, px+33, py,    30, 30);
      bouton_icone (Aidico17,    17, px+66, py,    30, 30);
      bouton_icone (Aidico18,    18, px,    py   , 30, 30);

      py  := py+33+12+5;
      bouton_icone (Aidico100,  100, px , py, 96 , 3*ty);

      py  := maxy - (30 + ty);
      py  := hauteurmenu+6;
      py  := py+30+6+30+6;
      bouton_icone (Aidico19,    19, px,    py+66, 30, 30);

      icone_etat;
   end;

procedure affiche_pas (n : integer) ;
   var
      px, py            : integer;
      ch                : t12;

   begin
      px  := posxbtn+1+33;
      py  := hauteurmenu+40+39+99+66+33;
      str    (n, ch) ;
      coulbar         (1, coulecran) ;
      setusercharsize (1, 1, 1, 1);
      bar             (px,    py, px+30, py+12) ;
      fixecoul        (c_titr) ;
      settextjustify  (1, 2);
      outtextxy       (px+15, py, '1/'+ch) ;
      settextjustify  (0, 2);
      setusercharsize (3, 2, 3, 2);
   end;

procedure affiche_zooms;
   var
      px, py            : integer;
      ch                : t12;

   begin
      px  := posxbtn+66+16;
      py  := hauteurmenu+40+35+99+16;

      { afficher valeur ZOOM z }
      coulbar          (1, coulecran) ;
      setusercharsize  (1, 1, 1, 1);
      fixecoul         (c_titr) ;
      bar              (px-16, py-16, px+16, py+16) ;
      settextjustify   (1, 1);
      str              (zoom_z :3 :1, ch) ;
      outtextxy        (px, py, 'x '+ch) ;

      { afficher valeur zoom XY }
      py  := hauteurmenu+40+35+99+33+16;
      bar              (px-16, py-16, px+16, py+16);
      settextjustify   (1, 1);
      str (zoom :3 :1, ch) ;
      outtextxy        (px, py, 'x '+ch) ;

      settextjustify   (0, 2);
      setusercharsize  (3, 2, 3, 2);
   end;

procedure aff_min_max;
   begin
      if not fils_seuls
      then begin
         if rang_v > 2
         then begin
            active_icone (100);
            dess_curseur_2 (nomfvs, libcol_4+' '+unitval4, format_4d, 100,
                            c_icone, c_est, c_bord, c_est,
                            xgicone (100), yhicone (100), 96, 3*ty,
                            pasc4, min_v, max_v, borne_inf, borne_sup);
         end
      end;
   end;

procedure dess_icones;
   var
      i                 : integer;

   begin
      for i := 1 to 19
      do
         active_dess_icone (i);
   end;

procedure init_cadre;
   begin
      fixecoul (c_bord) ;
      rectangle  (xxg,  yyh,  xxd,  yyb ) ;
   end;

procedure dess_axes;
   var
      px, py            : integer;

   begin
      px  := posxbtn;
      py  := hauteurmenu + 45 ;
      setusercharsize (4, 3, 4, 3);

      fixecoul  (c_est);
      outtextxy (px+60, py+13, n_est) ;

      fixecoul  (c_nord);
      outtextxy (px+ 3, py+13, n_nord) ;

      fixecoul  (c_ciel);
      outtextxy (px+30, py,    n_ciel) ;

      setusercharsize (3, 2, 3, 2);
   end;

procedure dessine_triedre ;
   begin
      fixecoul (c_est);
      line ( xxm,  yym, xxm+round (ray*mr [x, x] ),
                        yym-round (ray*mr [x, z] )) ;
      fixecoul (c_nord);
      line ( xxm,  yym, xxm+round (ray*mr [y, x] ),
                        yym-round (ray*mr [y, z] )) ;
      fixecoul (c_ciel);
      line ( xxm,  yym, xxm+round (ray*mr [z, x] ),
                        yym-round (ray*mr [z, z] )) ;
   end;

procedure efface_triedre ;
   begin
      fixecoul (coulboite);
      line ( xxm,  yym, xxm+round (ray*mr [x, x] ),
                        yym-round (ray*mr [x, z] ));
      line ( xxm,  yym, xxm+round (ray*mr [y, x] ),
                        yym-round (ray*mr [y, z] ));
      line ( xxm,  yym, xxm+round (ray*mr [z, x] ),
                        yym-round (ray*mr [z, z] ));
   end;

procedure defrotations_axes (n :integer) ;
   var
      nul               : boolean;

   begin
      mrotation (mr [x] , 2*pi/n, mx) ;
      mrotation (mr [y] , 2*pi/n, my) ;
      mrotation (mr [z] , 2*pi/n, mz) ;
      nul  :=  inversion (mx, mx1) ;
      nul  :=  inversion (my, my1) ;
      nul  :=  inversion (mz, mz1) ;
   end;

procedure defrotations (n : integer) ;
   var
      nul               : boolean;

   begin
      mrotation (vux, 2*pi/n, mx) ;
      mrotation (vuy, 2*pi/n, my) ;
      mrotation (vuz, 2*pi/n, mz) ;
      nul  :=  inversion (mx, mx1) ;
      nul  :=  inversion (my, my1) ;
      nul  :=  inversion (mz, mz1) ;
   end;

procedure calcule_zooms_maxs;
   begin
      zoom_z_max :=
         4095 * sqrt (1/sqr (zoom) - 1 / sqr (zoom_max_abs)) / (zlmax*echelle_z);
      if zoom_z_max > 9.99
      then
         zoom_z_max :=  9.99;

      if zoom_z > zoom_z_max
      then
         zoom_z     :=  zoom_z_max;

      zoom_max  :=
         4095 / sqrt (sqr (diametre*echelle) + sqr (zlmax*echelle_z*zoom_z));
      if zoom_max > 9.99
      then
         zoom_max   :=  9.99;
   end;

procedure definit_reference;
   var
      i                 : integer;

   begin
      for i  :=  0 to nbpoints
      do begin
         reference.pts^[i].x :=
            round ((seismes_x^ [i] -org [x]) * 8 * echelle   * zoom);

         reference.pts^[i].y :=
            round ((seismes_y^ [i] -org [y]) * 8 * echelle   * zoom);

         reference.pts^[i].z :=
            round ((seismes_z^ [i] -org [z]) * 8 * echelle_z * zoom * zoom_z);
      end;
   end;

procedure select_donnee;
   begin
      debut  :=  0;
      while quatrieme_donnee^[debut] < borne_inf do inc (debut) ;

      fin    :=  nbseismes;
      while quatrieme_donnee^[fin]   > borne_sup do dec (fin) ;
   end;

procedure tri_par_quatrieme_donnee;

   procedure trier (g, d :integer) ;
      var
         gch, drt       : integer;
         critere,
         tampon         : real;

      begin
         gch  :=  g;
         drt  :=  d;
         critere := quatrieme_donnee^ [(g+d) div 2] ;

         repeat
            while quatrieme_donnee^ [gch] < critere do inc (gch) ;
            while quatrieme_donnee^ [drt] > critere do dec (drt) ;

            if gch <= drt
            then begin
               tampon            :=  seismes_x^[drt] ;
               seismes_x^[drt]   :=  seismes_x^[gch] ;
               seismes_x^[gch]   :=  tampon;
               tampon            :=  seismes_y^[drt] ;
               seismes_y^[drt]   :=  seismes_y^[gch] ;
               seismes_y^[gch]   :=  tampon;
               tampon            :=  seismes_z^[drt] ;
               seismes_z^[drt]   :=  seismes_z^[gch] ;
               seismes_z^[gch]   :=  tampon;
               tampon            :=  quatrieme_donnee^[drt] ;
               quatrieme_donnee^ [drt]  :=  quatrieme_donnee^[gch] ;
               quatrieme_donnee^ [gch]  :=  tampon;
               inc (gch) ;
               dec (drt) ;
            end;
         until gch > drt;

         if g < drt then trier (g, drt) ;
         if gch < d then trier (gch, d) ;
      end;

   begin
      trier (0, nbseismes) ;
      min_v  :=  quatrieme_donnee^ [0] ;
      max_v  :=  quatrieme_donnee^ [nbseismes] ;

      borne_inf := min_v;
      borne_sup := max_v;
      select_donnee;
   end;

procedure init_points;
   var
      dim_min_fen       : integer;

   begin
      { origine,  facteur d'echelle }
      if not fils_seuls
      then begin
         tri_par_quatrieme_donnee;
         aff_min_max;
      end;

      fixevect ((xmin+xmax) /2, (ymin+ymax) /2, (zmin+zmax) /2,  org) ;

      xlmax   :=   xmax-xmin;
      ylmax   :=   ymax-ymin;
      zlmax   :=   zmax-zmin;

      dim_min_fen  :=  xxd-xxg;
      if  (yyb-yyh)  < dim_min_fen
      then
         dim_min_fen  :=  yyb-yyh;

      demi_dim  :=  dim_min_fen div 2;

      if ech_z_init < 0
      then begin
         diametre  :=  sqrt (sqr (xlmax) +sqr (ylmax) ) ;
         echelle   :=  dim_min_fen/diametre;
         if zlmax = 0
         then
            zlmax     :=  diametre;
         echelle_z :=  dim_min_fen/zlmax
      end else begin
         echelle_z := ech_z_init/degkm;
         diametre  := sqrt (sqr (xlmax) +sqr (ylmax) +sqr (zlmax*echelle_z));
         echelle   := dim_min_fen/diametre;
         echelle_z := echelle_z*echelle;
      end;

      zoom_max_abs := 4095/dim_min_fen;
      zoom         :=  1;
      zoom_z       :=  1;

      calcule_zooms_maxs;
      { affiche_zooms;}
   end;

procedure IniFondEcran;
   begin
      ini_par_ecr;
      ini_format (formatpapier) ;   { initialise format de papier / traceur }
      inicoul_cfg;
      fond_ecran (coulecran);
      affichemenu;
      fond_boite ;
      dess_icones;
      ini_titre;                                     { affiche titre rgion }
   end;

(*procedure redessine_tout;
   begin
      inifondecran;
      iniecran;
   end; *)

procedure Effacer_Commentaires;
   begin
      visucomm := false;
    {  fond_ecran (coulecran);
      fond_boite ;
      affichemenu;
      dess_icones;}

      redess_tout;
   end;

function hauteur : real;  { en radians }
   var
      h1                : real;
   { h1 : 0 = horizontale; pi/2 = znith; pi = envers; 3*pi/2 = dessous }
   { h  : 0 = horizontale; pi/2 = znith; 0  = envers; -pi/2  = dessous }
   begin
      if (mr [z, y] = 0) and (mr [z, z] = 0)
      then
         hauteur := 0
      else begin
         h1 := arctangente (-mr [z, y],
                            sqrt (sqr(mr [z, z]) + sqr (mr [z, x]) ) );
         if h1 >  pi/2
         then
            h1 :=  pi - h1;
         if h1 < -pi/2
         then
            h1 := -pi - h1;
         hauteur := h1
      end;
   end;

function or_ecran (ht  :  real) : real;
   { d'abord calculer la hauteur }
   begin
      if (ht = 90) or (hauteur = -90)
      then
         or_ecran := 0
      else
         or_ecran := arctangente (mr [z, x], mr [z, z]);
   end;

function orientation : real;  { en radians [0 .. 2 pi]           }
   { 0 = Est; pi/2 = Nord; ... }
   var
      mrm1              : mat;

   begin
      if hauteur = 90
      then
         orientation := arctangente ( mr[y, x], mr[y, z]);

      if hauteur =-90
      then
         orientation := arctangente (-mr[y, x], mr[y, z])
      else
         if inversion (mr, mrm1)
         then
            orientation := arctangente (-mrm1[y, x], mrm1[y, y]);

(*
      if inversion (mr, mrm1)
      then
         { 0 = Nord;  pi/2 = est; ... }
         if (abs (mrm1 [y, x]) < 1e-4) and (abs (mrm1 [y, z]) < 1e-4)
         then  { cas particulier }
            orientation := 0
         else
            orientation := arctangente (-mr [y, x], mr [y, z]);
*)
   end;

procedure lecture_fichier (var ok : boolean);
   var
      ch                : t12;
      nsmaxi,                 { nombre de points maxi en fonction mmoire   }
      i, j              : integer;
      a, b, c, d        : real;
      nul               : boolean;
      memdisp           : longint;

   procedure d_blocs;         { bloc avec gdes artes segmentes en 2 }
      var
         mx, my         : real;

      begin
         mx := (xmin+xmax) /2;
         my := (ymin+ymax) /2;

         {12 pts = face sud verticale   }
         quatrieme_donnee^ [j+1] :=   2+c_carte/1000;     {1}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymin;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {2}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymin;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {3}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  ymin;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {4}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymin;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {5}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymin;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {6}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  xmin;
         seismes_y^ [j+2]   :=  ymin;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         { 12pts = face nord verticale   }
         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {7}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {8}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {9}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;       {10}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;        {11}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  mx;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;        {12}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  xmin;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         { 8 pts = artes ouest  }
         quatrieme_donnee^ [j+1] := 2+c_carte/1000;         {13}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  xmin;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;          {14}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  xmin;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;          {15}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  xmin;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;          {16}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  xmin;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         { 8 pts = artes est  }
         quatrieme_donnee^ [j+1] := 2+c_carte/1000;          {17}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;          {18}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmax;
         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmax;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;           {19}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;

         quatrieme_donnee^ [j+1] := 2+c_carte/1000;           {20}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmin;
         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  my;
         seismes_z^ [j+2]   :=  zmin;
         j := j+2;
      end;

   procedure d_blocss;         { bloc avec gdes artes segmentes en 6 }
      begin
        d_blocs;
      end;

   procedure d_bloc;
      begin
         { ajouter ici les points du bloc }
         { 4 pts = face sud verticale   }
         quatrieme_donnee^[j+1] :=   5+c_carte/1000;              {1}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;

         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  ymin;
         seismes_z^ [j+2]   :=  zmax;

         seismes_x^ [j+3]   :=  xmax;
         seismes_y^ [j+3]   :=  ymin;
         seismes_z^ [j+3]   :=  zmin;

         seismes_x^ [j+4]   :=  xmin;
         seismes_y^ [j+4]   :=  ymin;
         seismes_z^ [j+4]   :=  zmin;

         seismes_x^ [j+5]   :=  xmin;
         seismes_y^ [j+5]   :=  ymin;
         seismes_z^ [j+5]   :=  zmax;

         j := j+5;
         { 4 pts = face nord verticale   }
         quatrieme_donnee^[j+1] :=   5+c_carte/1000;            {2}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymax;
         seismes_z^ [j+1]   :=  zmax;

         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmax;

         seismes_x^ [j+3]   :=  xmax;
         seismes_y^ [j+3]   :=  ymax;
         seismes_z^ [j+3]   :=  zmin;

         seismes_x^ [j+4]   :=  xmin;
         seismes_y^ [j+4]   :=  ymax;
         seismes_z^ [j+4]   :=  zmin;

         seismes_x^ [j+5]   :=  xmin;
         seismes_y^ [j+5]   :=  ymax;
         seismes_z^ [j+5]   :=  zmax;

         j := j+5;
         { 4 pts = artes ouest  }
         quatrieme_donnee^ [j+1] :=   2+c_carte/1000;          {3}
         seismes_x^ [j+1]   :=  xmin;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;

         seismes_x^ [j+2]   :=  xmin;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmax;

         quatrieme_donnee^ [j+3] :=   2+c_carte/1000;           {4}
         seismes_x^ [j+3]   :=  xmin;
         seismes_y^ [j+3]   :=  ymin;
         seismes_z^ [j+3]   :=  zmin;

         seismes_x^ [j+4]   :=  xmin;
         seismes_y^ [j+4]   :=  ymax;
         seismes_z^ [j+4]   :=  zmin;

         j := j+4;
         { 4 pts = artes est  }
         quatrieme_donnee^ [j+1] :=   2+c_carte/1000;           {5}
         seismes_x^ [j+1]   :=  xmax;
         seismes_y^ [j+1]   :=  ymin;
         seismes_z^ [j+1]   :=  zmax;

         seismes_x^ [j+2]   :=  xmax;
         seismes_y^ [j+2]   :=  ymax;
         seismes_z^ [j+2]   :=  zmax;

         quatrieme_donnee^ [j+3] :=   2+c_carte/1000;           {6}
         seismes_x^ [j+3]   :=  xmax;
         seismes_y^ [j+3]   :=  ymin;
         seismes_z^ [j+3]   :=  zmin;

         seismes_x^ [j+4]   :=  xmax;
         seismes_y^ [j+4]   :=  ymax;
         seismes_z^ [j+4]   :=  zmin;
         j := j+4;
      end;

   begin
      { test du fichier de points et recherche du nombre de points  charger }
      ok        := true;
      nbseismes :=  0;
      nbpoints  :=  0;

      if not fils_seuls
      then begin
         assign (fichier, chemindonnees+nomfvs+extvs) ;
         reset  (fichier) ;
         repeat
            readln (fichier, ch) ;
            inc    (nbseismes) ;
         until eof (fichier) ;
         if ch = ''
         then
            dec (nbseismes) ;
         close (fichier) ;
      end;

      { test du fichier de contours }
      if ftxt_present (chemindonnees+nomfcart+extcart)
      then begin
         assign (fichier, chemindonnees+nomfcart+extcart) ;
         reset  (fichier) ;
         repeat
            readln (fichier, a, ch) ;
            for i  :=  1 to round (a)
            do
               readln (fichier, ch) ;
            nbpoints  :=  nbpoints+round (a) ;
         until eof (fichier) ;
         close (fichier) ;
      end;

      { initialisations maxi }
      memdisp := memavail * 2 div 3;
      {if memdisp > 65520 then memdisp := 65520;}
      nsmaxi := round (memdisp div (sizeof (real)* 4+ sizeof (points)*3));
                                                        { 3 : trop juste }
      if nsmaxi > nsmax
      then
         nsmaxi := nsmax;

      nbpoints  := nbpoints+nsbloc;
      if nbseismes > nsmaxi -nsbloc
      then
         nbseismes  :=  nsmaxi - nbpoints;

      nbpoints  :=  nbpoints+nbseismes;

      getmem (seismes_x,        nbpoints * sizeof (real));
      getmem (seismes_y,        nbpoints * sizeof (real));
      getmem (seismes_z,        nbpoints * sizeof (real));
      getmem (quatrieme_donnee, nbpoints * sizeof (real));

      getmem (reference.pts,    nbpoints * sizeof (points));
      getmem (vue1.pts,         nbpoints * sizeof (points));
      getmem (vue2.pts,         nbpoints * sizeof (points));

      nbseismes  :=  nbseismes-1;
      nbpoints   :=  nbpoints -1;

      xmin  :=  infini; xmax  :=  -infini;
      ymin  :=  infini; ymax  :=  -infini;
      zmin  :=  infini; zmax  :=  -infini;

      { lecture des points }
      if not fils_seuls
      then begin
         assign (fichier, chemindonnees+nomfvs+extvs) ;
         reset  (fichier) ;

         for i := 0 to nbseismes
         do begin
            readln (fichier, a, b, c, d) ;

            if inversion_z then c  :=  -c;
            if coefvs <> 1 then c  :=  c * abs (coefvs);

            if a < xmin then xmin := a else if a > xmax then xmax := a;
            if b < ymin then ymin := b else if b > ymax then ymax := b;
            if c < zmin then zmin := c else if c > zmax then zmax := c;

            seismes_x^ [i]        := a;
            seismes_y^ [i]        := b;
            seismes_z^ [i]        := c;
            quatrieme_donnee^ [i] := d;
         end;

         close (fichier) ;
      end;

      { lecture des contours }
      j  :=  nbseismes;
      if ftxt_present (chemindonnees+nomfcart+extcart)
      then begin
         assign  (fichier,  chemindonnees+nomfcart+extcart) ;
         reset   (fichier) ;
         repeat
            readln (fichier,  a,  ch) ;
            quatrieme_donnee^ [j+1]      :=   a+c_carte/1000;
            for i  :=  1 to round (a)
            do begin
               if bln
               then begin
                  readln  (fichier, b, c) ;
                  d  :=  0
               end else begin
                  readln  (fichier, b, c, d) ;
                  d := d * coefblz;
               end;

               if  (j+i)   <  (nbpoints+1)
               then begin
                  if b < xmin
                     then
                        xmin  :=  b
                     else
                        if b  > xmax then  xmax  :=  b;
                  if c < ymin
                     then
                        ymin  :=  c
                     else
                        if c  > ymax then  ymax  :=  c;
                  if d < zmin
                     then
                        zmin  :=  d
                     else
                        if d  > zmax then  zmax  :=  d;

                  seismes_x^ [j+i]   :=  b;
                  seismes_y^ [j+i]   :=  c;
                  seismes_z^ [j+i]   :=  d;
               end else begin
                  i    :=  round  (a) ;
                  nul  :=  seekeof  (fichier) ;
               end;
            end;
            j  :=  j+round (a) ;
         until eof (fichier) ;
         close (fichier) ;
      end;

      case nsbloc of
         nsbloc1 : d_bloc;
         nsbloc2 : d_blocs;
         nsbloc4 : d_blocss;  { 40 sommets }
      end;
   end;

procedure calcule;
   var
      i                 : integer;
      mrs               : array [crdn, crdn]  of longint;

   begin
      mrs [x, x]   :=  round (mr [x, x] *8192) ;
      mrs [y, x]   :=  round (mr [y, x] *8192) ;
      mrs [z, x]   :=  round (mr [z, x] *8192) ;
      mrs [x, y]   :=  round (mr [x, y] *8192) ;
      mrs [y, y]   :=  round (mr [y, y] *8192) ;
      mrs [z, y]   :=  round (mr [z, y] *8192) ;
      mrs [x, z]   :=  round (mr [x, z] *8192) ;
      mrs [y, z]   :=  round (mr [y, z] *8192) ;
      mrs [z, z]   :=  round (mr [z, z] *8192) ;

      if not fils_seuls
      then begin
         vue1.debut     :=  debut;
         vue1.fin       :=  fin;
         vue1.contours  :=  visucontours;
         vue1.bloc      :=  visubloc;
         minzvue        := 32000;
         maxzvue        := -minzvue;
         for i := vue1.debut to vue1.fin
         do begin
            vue1.pts^[i] .x := (reference.pts^[i] .x*mrs [x, x] +
                                reference.pts^[i] .y*mrs [y, x] +
                                reference.pts^[i] .z*mrs [z, x] )  shr 16;
            vue1.pts^[i] .y := (reference.pts^[i] .x*mrs [x, y] +
                                reference.pts^[i] .y*mrs [y, y] +
                                reference.pts^[i] .z*mrs [z, y] )  shr 16;
            vue1.pts^[i] .z := (reference.pts^[i] .x*mrs [x, z] +
                                reference.pts^[i] .y*mrs [y, z] +
                                reference.pts^[i] .z*mrs [z, z] )  shr 16;
           { mmoriser minzvue et maxzvue }
           if vue1.pts^[i].z < minzvue then minzvue := vue1.pts^[i].z;
           if vue1.pts^[i].z > maxzvue then maxzvue := vue1.pts^[i].z;
         end;
      end;

      if (vue1.contours or vue1.bloc) and (nbpoints > nbseismes)
      then begin
         for i := nbseismes+1 to nbpoints
         do begin
            vue1.pts^[i] .x := (reference.pts^[i] .x*mrs [x, x] +
                                reference.pts^[i] .y*mrs [y, x] +
                                reference.pts^[i] .z*mrs [z, x] )  shr 16;
            vue1.pts^[i] .y := (reference.pts^[i] .x*mrs [x, y] +
                                reference.pts^[i] .y*mrs [y, y] +
                                reference.pts^[i] .z*mrs [z, y] )  shr 16;
            vue1.pts^[i] .z := (reference.pts^[i] .x*mrs [x, z] +
                                reference.pts^[i] .y*mrs [y, z] +
                                reference.pts^[i] .z*mrs [z, z] )  shr 16;
         end;
      end;
      site    := hauteur;
      azimut  := orientation;
     { variable    fonction }
   end;

procedure debut_points;
   begin
      init_points;
      definit_reference;
      calcule;
      affiche;
      affiche_angles;
      dessine_triedre;
   end;

procedure dessin (t : boolean ; vue : liste_pts);
   { t affiche }
   var
      debpts,
      nsommets,
      i,  j,  jm,
      a,  b,  c,
      x1, y1,
      x2, y2            : integer;

   begin
      if not fils_seuls
      then
         for i := vue.debut to vue.fin
         do begin
            a := xxm + vue.pts^[i] .x;
            if (a > xxg) and (a < xxd)
            then begin
               b  :=  yym - vue.pts^[i] .z;
               if (b > yyh) and (b < yyb)
               then begin
                {  c := 8+ round ((15 - 8)
                              * (vue.pts^[i].y - minzvue)
                              / (maxzvue - minzvue));}
                  c  :=  round (11.5-vue.pts^[i] .y*4/demi_dim) ;
                  if c <  8 then c :=  8;
                  if c > 14 then c := 14;
                  if (c > 7) and (c < 15)
                  then
                     if t
                     then
                        putpixel (a, b, c)
                     else
                        putpixel (a, b, coulboite) ;
               end;
            end;
         end;

      if vue.bloc
      then begin
         if vue.contours
         then
            debpts := nbseismes
         else
            debpts := nbpoints - nsbloc;
         nsommets := 0;
      end else begin
         debpts   := nbseismes;
         nsommets := nsbloc;
      end;

      if (vue.contours or vue.bloc) and  (nbpoints-nsommets > nbseismes)
      then begin
         i  :=  debpts {nbseismes}+1;
         j  :=  1;
         setviewport (xxg+1, yyh+1, xxd-1, yyb-1, true) ;
         repeat
            x2  :=  x1;
            y2  :=  y1;
            x1  :=  xxm + vue.pts^[i] .x -xxg-1;
            y1  :=  yym - vue.pts^[i] .z -yyh-1;

            if j = 1
            then begin
               jm := round (quatrieme_donnee^[i] ) ;
               if t
               then begin
                  if unicolore
                  then
                     c := c_carte
                  else begin
                     c  :=  round (11.5-vue.pts^[i] .y*4/demi_dim) ;
                     if c <  8 then c := 8;
                     if c > 14 then c := 14;
                     if not (c > 7) and (c < 15)
                     then
                        c:= c_carte;
                  end;
(*                 fixecoul (c{_carte})*)
                   setcolor (c);
                         {(round (1000*frac (quatrieme_donnee^[i])))}
                  {   else
                        fixecoul (c_carte);}
               end else
                  setcolor (coulboite)
            end else begin
               { dessin de la ligne }
               line (x1, y1, x2, y2) ;
            end;

            if j = jm
            then j := 1
            else inc (j) ;

            inc (i) ;
         until i = nbpoints+1-nsommets;

         setviewport (0, 0, maxx, maxy, true) ;
      end;
   end;

procedure affiche;
   begin
      dessin (true, vue1) ;
   end;

procedure efface;
   begin
      dessin (false, vue2) ;
   end;

procedure edi_min_max;
   begin
      vue0  :=  vue1;
      vue1  :=  vue2;
      vue2  :=  vue0;
      if not fils_seuls
      then begin
         modif_donnee  (100,
                        c_icone, c_est, c_bord, c_est,
                        '5:1',
                        pasc4,
                        min_v,     max_v,
                        borne_inf, borne_sup);
         select_donnee;
         aff_min_max;
         calcule;
         efface;
         affiche;
         affiche_angles;
      end;
   end;

procedure termine_points;
   begin
      if nbpoints>0
      then begin
         efface;
         nbpoints   :=   nbpoints + 1;

         freemem (seismes_x,        nbpoints * sizeof (real));
         freemem (seismes_y,        nbpoints * sizeof (real));
         freemem (seismes_z,        nbpoints * sizeof (real));
         freemem (quatrieme_donnee, nbpoints * sizeof (real));

         freemem (reference.pts,    nbpoints * sizeof (points));
         freemem (vue1.pts,         nbpoints * sizeof (points));
         freemem (vue2.pts,         nbpoints * sizeof (points));
      end
   end;

procedure libere_mem;
   begin
      termine_points;
      liberer_jeu_symb (1);
      liberer_jeu_symb (3);
      liberericones;
      params.fini;
      parini.fini;
      liberer_commentaires;
   end;

procedure affiche_angles;
   var
      a,   s            : integer;
      cha, chs          : string;

   begin
      a := (round (azimut/coefpi) + 180) mod 360 ;
      s := round (site  /coefpi);
      str (a, cha);
      str (s, chs);
      if (a = 0) and (s = 0)
      then
         cha := '?';
      cha := n_azimut  + cha;
      chs := n_hauteur + chs;
      setusercharsize (1, 1, 1, 1);
      coulbar (1, coulboite);
      bar       (xxg+3, yyb-15, xxg+3+textwidth (chs+' '), yyb-3);
      fixecoul  (c_ciel);
      settextjustify  (0, 0);
      outtextxy (xxg+3, yyb-3, chs);
      settextjustify  (2, 0);
      bar       (xxd-3- textwidth (cha+' '), yyb-15, xxd-3, yyb-3);
      fixecoul  (c_nord);
      outtextxy (xxd-3, yyb-3, cha);
      settextjustify  (0, 2);
      setusercharsize (3, 2, 3, 2);
   end;

procedure modif_org;
   var
      mrm1              : mat;
      v                 : vect;

   begin
      if inversion (mr, mrm1)
      then begin
         fixevect (csi.xs-xxm, 0, yym-csi.ys, v) ;
         mmultv (mrm1, v, v) ;
         v [x]   :=  v [x]  /  (echelle  * zoom) ;
         v [y]   :=  v [y]  /  (echelle  * zoom) ;
         v [z]   :=  v [z]  /  (echelle_z* zoom * zoom_z) ;
         sommev (org, v, org) ;
         if org [x]  > xmax then org [x]   :=  xmax;
         if org [x]  < xmin then org [x]   :=  xmin;
         if org [y]  > ymax then org [y]   :=  ymax;
         if org [y]  < ymin then org [y]   :=  ymin;
         if org [z]  > zmax then org [z]   :=  zmax;
         if org [z]  < zmin then org [z]   :=  zmin;
      end;
   end;

procedure init_m_depart;
   begin
      mr [x, x]   :=  mxx ;
      mr [y, x]   :=  myx ;
      mr [z, x]   :=  mzx ;
      mr [x, y]   :=  mxy ;
      mr [y, y]   :=  myy ;
      mr [z, y]   :=  mzy ;
      mr [x, z]   :=  mxz ;
      mr [y, z]   :=  myz ;
      mr [z, z]   :=  mzz ;
   end;

procedure init_v_sortie;
   begin
      mxx    :=  mr [x, x];
      myx    :=  mr [y, x];
      mzx    :=  mr [z, x];
      mxy    :=  mr [x, y];
      myy    :=  mr [y, y];
      mzy    :=  mr [z, y];
      mxz    :=  mr [x, z];
      myz    :=  mr [y, z];
      mzz    :=  mr [z, z];
   end;

procedure tourne (a : byte);
   begin
      repeat
         vue0  :=  vue1;
         vue1  :=  vue2;
         vue2  :=  vue0;

         efface_triedre ;
         if not axes_ecran
         then
            defrotations_axes (pas_r) ;

         case a of
             7  : { rotation par rapport  l'axe vertical,  avant vers la gauche }
                  produitm (mz1, mr, mr) ;

             9  : { rotation par rapport  l'axe vertical,  avant vers la droite }
                  produitm (mz,  mr, mr) ;

             5  : { rotation par rapport  l'axe horizontal,  avant vers le haut }
                  produitm (mx1, mr, mr) ;

            10  : { rotation par rapport  l'axe horizontal,  avant vers le bas  }
                  produitm (mx,  mr, mr) ;

             6  : { rotation plane,  sens trigonometrique }
                  produitm (my1, mr, mr) ;

            11  : { rotation plane,  sens des aiguilles d'une montre }
                  produitm (my,  mr, mr) ;

             1  : { raz tout }
                  begin
                     mr      :=  mr0;
                     zoom    :=  1;
                     zoom_z  :=  1;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

             8  : { raz init }
                  begin
                     init_m_depart;
                     zoom    :=  1;
                     zoom_z  :=  1;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            14  : { zoom + }
                  begin
                     zoom    :=  zoom*1.1;
                     if zoom > zoom_max
                     then
                        zoom  :=  zoom_max;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            15  : { zoom - }
                  begin
                     zoom    :=  zoom*0.9;
                     if zoom < 0.7
                     then
                        zoom  :=  0.7;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            12  : { zoom z + }
                  begin
                     zoom_z  :=  zoom_z*1.1;
                     if zoom_z > zoom_z_max
                     then
                        zoom_z  :=  zoom_z_max;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            13  : { zoom z - }
                  begin
                     zoom_z  :=  zoom_z*0.9;
                     if zoom_z < 0.1
                     then
                        zoom_z  :=  0.1;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            16  : { pas }
                  begin
                     if pas_r = 256
                     then
                        pas_r  :=   64
                     else
                        if pas_r =  64
                        then
                           pas_r  :=   16
                        else
                           if pas_r =  16
                           then
                              pas_r  :=  256;

                     if axes_ecran
                     then
                        defrotations (pas_r)
                     else
                        defrotations_axes (pas_r) ;
                     affiche_pas (pas_r) ;
                     delay (200) ;
                  end;

         end;
         dessine_triedre ;
         calcule;
         efface;
         affiche;
         affiche_angles;
      until not unboutonsourisenfonce;
      modipar  := true;
   end;

procedure IniEcran;
   begin
      cadrer;
      dess_axes;

     { initialisation des rotations }
      pas_r  :=  256;
      defrotations (pas_r) ;
      affiche_pas  (pas_r) ;
      mrotation (vux, pi/2, mr0) ;
     { mr  :=  mr0;}
      init_m_depart;
      init_cadre;
      inietat ;                           { crit infos sur la ligne d'tat }
      debut_points;
     { tourne (8);}
   end;

procedure finir;
   begin
      libere_mem;
      restorecrtmode;
      ecrantexte;
   end;

procedure placer_centre;
   begin
      vue0  :=  vue1;
      vue1  :=  vue2;
      vue2  :=  vue0;
      efface_triedre ;
      if not axes_ecran
      then
         defrotations_axes (pas_r) ;
      modif_org;
      definit_reference;
      dessine_triedre ;
      calcule;
      efface;
      affiche;
      affiche_angles;
   end;

procedure Centrer;
   begin
      ChangerCurseur (croix);
      MontrerSouris;
      repeat
         until not UnBoutonSourisEnfonce;
      repeat
         until BoutonSourisEnfonce (BoutonGauche);
      cachersouris;
      ChangerCurseur (fleche);
      LirePositionSouris (xs, ys);
      placer_centre;
      repeat
         until not UnBoutonSourisEnfonce;
   end;

procedure repere;
   begin
      vue0  :=  vue1;
      vue1  :=  vue2;
      vue2  :=  vue0;

      axes_ecran  :=  not axes_ecran;
      if axes_ecran
      then
         defrotations (pas_r) ;
      affiche_pas (pas_r) ;
      modipar  := true;

      calcule;
      efface;
      affiche;
      affiche_angles;

      if axes_ecran
      then begin
         modi_aide_bouton (aidico5,   5);
         modi_aide_bouton (aidico6,   6);

         modi_aide_bouton (aidico7,   7);
         modi_aide_bouton (aidico9,   9);

         modi_aide_bouton (aidico10, 10);
         modi_aide_bouton (aidico11, 11);
      end else begin
         modi_aide_bouton (aidico5e,   5);
         modi_aide_bouton (aidico6e,   6);

         modi_aide_bouton (aidico7e,   7);
         modi_aide_bouton (aidico9e,   9);

         modi_aide_bouton (aidico10e, 10);
         modi_aide_bouton (aidico11e, 11);
      end;
   end;

procedure visu_bloc;
   begin
      vue0  :=  vue1;
      vue1  :=  vue2;
      vue2  :=  vue0;

      visubloc := not visubloc;
      modipar  := true;
      dessine_triedre ;
      calcule;
      efface;
      affiche;
      affiche_angles;
   end;

procedure visu_contours;
   begin
      vue0  :=  vue1;
      vue1  :=  vue2;
      vue2  :=  vue0;

      visucontours := not visucontours;
      modipar  := true;
      dessine_triedre ;
      calcule;
      efface;
      affiche;
      affiche_angles;
   end;

procedure visu_commentaires;
   begin
      visucomm := not visucomm;
      modicomm := true;
      if visucomm
      then
         Dessiner_Commentaires (false, true, false)
      else
         effacer_commentaires;
      modipar  := true;
   end;

procedure CALCULER;
   begin
      laide (la_calcul);

      tourne (1);

      if modicomm
      then
         Effacer_tout_redessiner
      else
         if visucomm
         then
            dessiner_commentaires (false, true, false);
      laide ('');
   end;

procedure commentaires;
   begin
      Ajouter_COMMENTAIRES (false);                                       { geo_des }
      visucomm := true;
      Dessiner_commentaires (false, true, false);
      modipar := true;
   end;

procedure choix_couleurs (var cc1, cc2, cc3 : byte);
   var
      touche, poscur    : integer;
      co1, co2, co3     : byte;
      zc1, zc2, zc3     : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      co1    := cc1;
      co2    := cc2;
      co3    := cc3;

      Zc1    := new (PZoneCouleur,
                init ( 0, 0,         @cc1,
                b_est, '', pal));

      Zc2    := new (PZoneCouleur,
                init ( 0, 0,         @cc2,
                b_nord, '', pal));

      Zc3    := new (PZoneCouleur,
                init ( 0, 0,         @cc3,
                b_ciel, '', pal));

      { dition du tout }
      poscur := 1;
      boite  := new (PBoiteSaisie,
                     init (milieu, milieu, 15,     fondnorm, txtnorm,
                            t_couleurs));

      boite^.ajoute (zc1);
      boite^.ajoute (zc2);
      boite^.ajoute (zc3);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');

      boite^.vider;
      dispose (boite, fini);

      if (touche = ESC) {or (touche = 0)}
      then begin
         cc1     := co1;
         cc2     := co2;
         cc3     := co3;
      end;                                 { rtablir les valeurs initiales }
   end;

procedure couleurs_xyz;
   var
      cc1, cc2, cc3
                        : byte;

   begin
      cc1          := byte (c_est);
      cc2          := byte (c_nord);
      cc3          := byte (c_ciel);

      choix_couleurs (cc1, cc2, cc3);

      c_est        := cc1;
      c_nord       := cc2;
      c_ciel       := cc3;

      dess_axes;
      dessine_triedre;
      modipar      := true;
   end;

procedure redess_tout;
   begin
      fond_ecran    (coulecran);
      if not copie_en_cours
      then begin
         affichemenu;
         dess_icones;
      end;
      fond_boite;
      init_cadre;
      ini_titre;
      dess_axes;
      aff_min_max;
      inietat;
      affiche;
      dessine_triedre;
      affiche_angles;
      if visucomm
      then
         dessiner_commentaires (false, true, false);
   end;

procedure effacer_tout_redessiner;
   begin
      copie_en_cours := false;
      fond_ecran  (coulecran);
      redess_tout;
      modicomm := false;
   end;

END.

{--- GEOCEAN - NUAG_DES ---------------------- R.C.- INRP - TOULOUSE - 1995 }

