UNIT CursExOc;

{---------------------------------------------------------------------------}
{         ARX                                                               }
{                          Unite CURSEURS                                   }
{                                                               30/05/93    }
{---------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   clavier,
   crt, graph,                     { TP      - units standard              }
   souris,                         { ARX     - Souris seule                 }
   csi,                            { ARX     - Clavier Souris Ecran         }
   Graphism,
   Graphplt,                       { ARX     - initialisations graphiques   }
   icones;                         { ARX     - Icnes                       }
                                   { utile ici seulement pour recalc coord  }

Procedure initformat (f_d : string ; var f_dt, f_dp : byte);
   { initialise le format des affichages                                    }

Procedure formater   (x   : real ; t,  p  : integer ; var s  : string;
                      ValeurAbsolue: Boolean) ;
   { Transtypage x --> s avec formatage  t = nb chiffres ; p = nb dcimales }

Procedure dess_curseur_3 (titre, unite, f_d               : string;
                          numero,
                          coulb, coultexte, coulicone, coulbouton : word;
                          {x, y, dx, dy                     : integer;}
                          pasv,donnee_min,donnee_centre,donnee_max: real;
                          var donnee_deb, donnee_fin       : real;
                          ValeurAbsolue                    : boolean);
   { dessine triple curseur horizontal:
             le curseur central dplace l'ensemble,
             les curseurs extrmes permettent de modifier la largeur}

Procedure modif_donnee_3 (numero,
                          coulb, coultexte, coulicone, coulbouton : word;
                          pasv,donnee_min,donnee_centre,donnee_max: real;
                          var donnee_deb, donnee_fin       : real;
                          ValeurAbsolue                    : boolean);
   { Saisie des positions des curseurs                                      }

(*
Procedure dess_curseur_2 (titre, unite, f_d               : string;
                          numero,
                          coulb, coultexte, coulicone, coulbouton : word;
                          x, y, dx, dy                     : integer;
                          pasv, donnee_min, donnee_max     : real;
                          var donnee_deb, donnee_fin       : real);
   { dessine double curseur horizontal                                      }

Procedure modif_donnee_2 (numero,
                          coulb, coultexte, coulicone, coulbouton : word;
                          pasv, donnee_min, donnee_max     : real;
                          var donnee_deb, donnee_fin       : real);
   { Saisie des positions des curseurs                                      }

Procedure dess_curseur_1 (titre, unite, f_d                : string;
                          numero,
                          coultexte, coulicone, coulbouton : word;
                          x, y, dx, dy                     : integer;
                          pasv, donnee_min, donnee_max     : real;
                          var donnee                       : real);
   { dessine curseur simple horizontal                                      }

Procedure modif_donnee_1 (numero,
                          coultexte, coulicone, coulbouton : word;
                          pasv, donnee_min, donnee_max     : real;
                          var donnee                       : real);
   { Saisie de la position du curseur seul                                  }
*)
{---------------------------------------------------------------------------}

IMPLEMENTATION

VAR
   bou1,                  { bouton seul }
   binf, bsup,            { double bouton }
   BouG,BouC,BouD,
   cadr1,cadr2,cadr3  : limites;

   format_dt,              { nb chiffres total }
   format_dp               { nb dcimales      }
                    : byte;

   xs,  ys          : integer;

procedure formater (x  : real ; t,  p  : integer ; var s  : string;
                    ValeurAbsolue : boolean) ;
   begin If ValeurAbsolue then x:=abs(x);
      str (x :t:p, s) ;
      if pos ('.', s)  > (t-1)
      then s  :=  copy (s, 1, pos ('.', s) -1)
      else s  :=  copy (s, 1, t) ;
      while length (s)  < t do s  :=  ' '+s;
   end;

procedure initformat (f_d : string; var f_dt, f_dp : byte);
   var
      erreur   : integer;

   begin
      if pos (':', f_d)  > 0
      then begin
         val (copy (f_d, 1, pos (':', f_d) -1) , f_dt, erreur) ;
         val (copy (f_d, pos (':', f_d) +1, 2) , f_dp, erreur) ;
      end else begin
         val (f_d, f_dt, erreur) ;
         f_dp  :=  0;
      end;
   end;

procedure redess (lim : limites; coul1, coul2 : word);
   begin
      with lim do begin
         fixecoul  (coul1) ;
         rectangle ( xg,  yh,    xd,     yb ) ;
         coulbar   (1, coul2) ;
         bar       ( xg+1, yh+1,  xd-1,  yb-1 ) ;
      end;
   end;

procedure decale (coulb, coulicone, coulbouton : word ;
                  var lim               : limites;
                  x                     : integer;
                  bout, cadre           : limites) ;
   { dcale le BOUT de la distance X (pixels)
            de la position initiale LIM  dans les limites BOUT, CADRE }
   var
      y1, y2   : integer;

   begin
      with lim do begin
         y1  :=  (yh+yb)  div 2 - 1;
         y2  :=  y1+2;

         coulbar  (1, coulb) ;
         bar       (xg,  yh, xd, yb);
         if xd < bout.xg
         then begin
            if xg+x <= cadre.xg+2 then x  :=  cadre.xg+2-xg;
            if xd+x >= bout.xg    then x  :=  bout.xg-xd-1;

            if x > 0
            then begin
               coulbar (1, coulb) ;
               bar (xd+1, y1, xd+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xd+x, y1, xd,   y2) ;
            end;

         end else begin
            if xd+x >= cadre.xd-2 then x  :=  cadre.xd-2-xd;
            if xg+x <= bout.xd    then x  :=  bout.xd-xg+1;

            if x < 0
            then begin
               coulbar (1,  coulb) ;
               bar (xg-1, y1, xg+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xg+x, y1, xg,   y2) ;
            end;
         end;

         xg  :=  xg+x;
         xd  :=  xd+x;
         fixecoul (coulicone) ;
         rectangle ( xg,  yh,  xd,  yb ) ;
         coulbar (1, coulbouton) ;
         bar ( xg+1,  yh+1,  xd-1,  yb-1 ) ;
      end;
   end;

procedure fixe_lims (var l : limites; xg, yh, xd, yb :integer) ;
   begin
      l.xg  :=  xg;
      l.xd  :=  xd;
      l.yh  :=  yh;
      l.yb  :=  yb;
      rectangle ( xg,  yh,  xd,  yb ) ;
      bar ( xg+1,  yh+1,  xd-1,  yb-1 ) ;
   end;

procedure calc_donnee ( numero,coulb, coulbouton     : word;
                        pasv,donnee_min,donnee_centre,donnee_max : real;
                        var donnee_deb, donnee_fin   : real;
                        ValeurAbsolue                : boolean;
                        BInf,BSup,Cadre              : Limites);
   var
      ch                 : string;
      dim,
      xgi, xdi, yhi, ybi : integer;

Procedure decale_centre(var donnee:real);
begin If donnee> -Donnee_Centre then
         donnee := donnee+2*donnee_centre;
end;

begin xgi := xgicone (numero);  xdi := xdicone (numero);
      yhi := yhicone (numero);  ybi := ybicone (numero);
      dim         :=  (cadre.xd-cadre.xg-4-binf.xd+binf.xg) ;
      donnee_deb  :=  donnee_min+ (donnee_max-donnee_min-2*donnee_centre)
                                * (binf.xg-cadre.xg-2) /dim;
      donnee_fin  :=  donnee_min+ (donnee_max-donnee_min-2*donnee_centre)
                                * (bsup.xg-cadre.xg-2) /dim;
      If Donnee_Centre<>0 then begin decale_centre(donnee_deb);
                                     decale_centre(donnee_fin) end;
      coulbar (1, coulb) ;
      bar (cadre.xg+1-3,     cadre.yh +28-14,
           cadre.xd-1+3,     cadre.yh +37-14 ) ;
      fixecoul (coulbouton) ;

      settextjustify (0, 2);
      donnee_deb := round (donnee_deb/pasv) *pasv;
      formater  (donnee_deb, format_dt, format_dp, ch,ValeurAbsolue) ;
      outtextxy (cadre.xg+2-3,   cadre.yh + 28-14, ch) ;

      settextjustify (2, 2);
      donnee_fin := round (donnee_fin/pasv) *pasv;
      formater  (donnee_fin, format_dt, format_dp, ch,ValeurAbsolue) ;
      outtextxy (cadre.xd-2+3,   cadre.yh + 28-14, ch) ;
end;

procedure dess_curseur_3 (titre, unite, f_d            : string;
                          numero,
                          coulb, coultexte, coulicone, coulbouton : word;
                          {x, y, dx, dy                 : integer;}
                          pasv,donnee_min,donnee_centre,donnee_max: real;
                          var donnee_deb, donnee_fin   : real;
                          ValeurAbsolue                : boolean);
   var
      xgi,xdi,yhi,ybi, dim : integer;

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b :=  -1 * trunc (donnee * dim / (donnee_max-donnee_min));
      end;

   begin xgi := xgicone (numero);  xdi := xdicone (numero);
         yhi := yhicone (numero);  ybi := ybicone (numero);
      initformat (f_d, format_dt, format_dp);
      setusercharsize (1, 1, 1, 1);
      coulbar   (1, coulb) ;
      bar       ( xgi, yhi, xdi, ybi );
      fixecoul  (coulicone) ;
      rectangle ( xgi, yhi, xdi, ybi ) ;

      { titre } fixecoul     (coulbouton) ;
      settextjustify (1, 2); outtextxy (xdi div 2, yhi+1 , titre);

      { units }
      settextjustify (1, 0); outtextxy (xdi div 2, ybi-3 , unite);

      { barre horizontale } fixecoul  (coulicone) ;
      fixe_lims (cadr3, xgi + 3,  yhi  + 14,
                        xdi - 3,  yhi  + 26);

      { boutons } fixecoul (coulicone) ;
      coulbar  (1, coulbouton) ;
      fixe_lims (BouD,  xdi -10,  yhi  + 16,
                        xdi - 5,  yhi  + 24) ;

{      fixe_lims (BouC,  xdi -16,  yhi  + 16,
                        xdi -11,  yhi  + 24) ;}

      fixe_lims (BouG,  xdi -22,  yhi  + 16,
                        xdi -17,  yhi  + 24) ;

      dim      := cadr3.xd -cadr3.xg-4 -BouG.xd +BouG.xg ;
{      if donnee_deb > donnee_min
      then
         decale (coulb, coulicone, coulbouton,
                 BouG, (deplace_b (donnee_max-donnee_deb))+11, BouC, cadr3)
      else
         decale (coulb, coulicone, coulbouton,
                 BouG, -1000,  BouC, cadr3);}
      if donnee_deb < donnee_min then donnee_deb := donnee_min;
      if donnee_fin > donnee_max then donnee_fin := donnee_max;
      decale (coulb, coulicone, coulbouton,
                 BouG, (deplace_b (donnee_max-donnee_deb))+11, BouD, cadr3);
{      decale (coulb, coulicone, coulbouton,
              BouC, (deplace_b (donnee_max-(donnee_deb+donnee_fin)/2))+5,
              BouD, cadr3) ;
}
      if donnee_fin  < donnee_max
      then
         decale (coulb, coulicone, coulbouton,
                 BouD, (deplace_b (donnee_max-donnee_fin))-1, BouG, cadr3) ;

      fixe_lims (BouC,  xgi +BouG.xD  ,  yhi  + 16,
                        xgi +BouD.xG-2,  yhi  + 24) ;

      calc_donnee
         (numero, coulb, coultexte { valeurs },
          pasv, donnee_min, donnee_centre, donnee_max,
          donnee_deb, donnee_fin,ValeurAbsolue,BouG,BouD,Cadr3);
      setusercharsize (3, 2, 3, 2);
   end;

procedure decale_3 (coulb, coulicone, coulbouton : word ;
                  var lim               : limites;
                  var x                 : integer;
                  bout, cadre           : limites;
                  l : byte) ;
   { dcale le BOUT de la distance X (pixels)
            de la position initiale LIM  dans les limites BOUT, CADRE }
{   var
      y1, y2   : integer;}

   begin
      with lim do begin
{         y1  :=  (yh+yb)  div 2 - 1;
         y2  :=  y1+2;
}
         coulbar  (1, coulb) ;
         bar       (xg,  yh, xd, yb);
         if xd < bout.xg
         then begin
            if xg+x <= cadre.xg+2 then x  :=  cadre.xg+2-xg;
            if xd+x >= bout.xg-l then x  :=  bout.xg-xd-1-l;

            if x > 0
            then begin
               coulbar (1, coulb) ;
               bar (xd+1, yh, xd+x, yb) ;
{               bar (xd+1, y1, xd+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xd+x, y1, xd,   y2) ;
}            end;

         end else begin
            if xd+x >= cadre.xd-2 then x  :=  cadre.xd-2-xd;
            if xg+x <= bout.xd+l  then x  :=  bout.xd-xg+1+l;

            if x < 0
            then begin
               coulbar (1,  coulb) ;
               bar (xd+1, yh, xd+x, yb) ;
{               bar (xg-1, y1, xg+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xg+x, y1, xg,   y2) ;
}            end;
         end;

         xg  :=  xg+x;
         xd  :=  xd+x;
         fixecoul (coulicone) ;
         rectangle ( xg,  yh,  xd,  yb ) ;
         coulbar (1, coulbouton) ;
         bar ( xg+1,  yh+1,  xd-1,  yb-1 ) ;
      end;
   end;

procedure modif_donnee_3(numero,
                         coulb, coultexte, coulicone, coulbouton : word;
                         pasv,donnee_min,donnee_centre,donnee_max: real;
                         var donnee_deb, donnee_fin       : real;
                         ValeurAbsolue                    : boolean);
   var
      code, dx,
      xdep, ydep,
      xmem, ymem,
      x,xsi        : integer;
      BoutonInf,Bouton1,
      deplace      : boolean;

      dim, di2,
      xgi, xdi, yhi, ybi : integer;
      C_Inf, C_Sup       : word;

   procedure aff_donnee (coulb, coulbouton            : word;
                         pasv, donnee_min, donnee_max : real;
                         place                        : char;
                         var donnee   : real);
      var
         ch                 : string;
         Prov1,Prov2        : real;
   begin Prov1 := Donnee+PasV;
         If (donnee< -donnee_centre)and(Prov1>=donnee_centre)then
            Prov2:=Prov1+2*donnee_centre else prov2 := Prov1;
         If (donnee>donnee_centre)  and(prov1<=-donnee_centre)then
            Prov2:=Prov1-2*donnee_centre else Prov2 := Prov1;
         donnee:=prov2;
         if donnee < donnee_min then donnee := donnee_min;
         if donnee > donnee_max then donnee := donnee_max;
         donnee := round (donnee/pasv) *pasv;
         formater  (donnee, format_dt, format_dp, ch,ValeurAbsolue) ;
         coulbar (1, coulb) ; fixecoul (coulbouton) ;
         Case place of
         'd' : begin bar (xgi+1, yhi +28, xdi-1-di2, yhi +37 ) ;
               settextjustify (0, 2);
               outtextxy (xgi+2, yhi + 28, ch)  end;
         'f' : begin bar (xgi+1+di2, yhi +28, xdi-1,     yhi +37 ) ;
               settextjustify (2, 2);
               outtextxy (xdi-2, yhi + 28, ch) end;
         end;
      end;

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b := trunc (donnee * dim / (donnee_max-donnee_min));
      end;

   Procedure ReDessBouC(CoulBoutC : Word);
   Begin coulbar (1, coulboutC) ;
         fixe_lims (BouC,  xgi+BouG.xD  ,  yhi  + 16,
                           xgi+BouD.xG-2,  yhi  + 24) ;
   end;

   begin
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim :=  (cadr3.xd-cadr3.xg-4-BouG.xd+BouG.xg) ;
      di2 := (xdi-xgi) div 2;
      setusercharsize (1, 1, 1, 1);
      xmem  :=  0;
      ymem  :=  0;
      BoutonInf := False; Bouton1:=True;

      montrersouris;
      repeat
         code := 0;
         lirepositionsouris (xsi, ys);
         if UnBoutonSourisEnfonce  and dans (xsi, ys, BouC)
         then begin Bouton1 := true; {on dplace}
            repeat
               lirepositionsouris (xs, ys); x := xs-xsi;xsi:=xs;{x:=(BouC.xd+BouC.xg)div2;}
               if x<>0 then begin Cachersouris;
                If x>0 then begin {on va  droite => tester BouD en 1er}
                  decale_3 (coulb, coulicone, coulbouton, BouD, x , BouC, cadr3,0) ;
                  decale_3 (coulb, coulicone, colord,     BouC, x , BouG, cadr3,0) ;
                  decale_3 (coulb, coulicone, coulbouton, BouG, x , BouC, cadr3,0) ;
                end else    begin {on va  gauche => tester BouG en 1er}
                  decale_3 (coulb, coulicone, coulbouton, BouG, x , BouC, cadr3,0) ;
                  decale_3 (coulb, coulicone, colord,     BouC, x , BouD, cadr3,0) ;
                  decale_3 (coulb, coulicone, coulbouton, BouD, x , BouC, cadr3,0) ;
                end; {ReDessBouC(colord);}
                calc_donnee
                   (numero, coulb, coultexte,
                    pasv, donnee_min, donnee_centre, donnee_max,
                    donnee_deb, donnee_fin, ValeurAbsolue, BouG,BouD,Cadr3);
               MontrerSouris end;
            until not  UnBoutonSourisEnfonce ;
         end else
            if UnBoutonSourisEnfonce  and dans (xsi, ys, BouG)
            then begin Bouton1:=False;
               BoutonInf := true; {On redimensionne avec BouG}
               repeat
                  cachersouris;
                  lirepositionsouris (xs, ys); x := xs-xsi{(BouG.xd+BouG.xg)div 2};
                  If (BouC.xg+BouC.xd)<(cadr3.xg+cadr3.xd) then begin
                     decale_3(coulb, coulicone, colord,BouG,x,BouD{BouC}, cadr3,5) ;
                     x := -x;
                     decale_3(coulb, coulicone, coulbouton,BouD,x,BouG{BouC}, cadr3,5) ;
                  end else begin x := -x;
                     decale_3(coulb, coulicone, coulbouton,BouD,x,BouG{BouC}, cadr3,5) ;
                     x := -x;
                     decale_3(coulb, coulicone, colord,BouG,x,BouD{BouC}, cadr3,5) ;
                  end;ReDessBouC(coulbouton);{redess (BouC, coulicone, coulbouton);}
                  calc_donnee
                      (numero, coulb, coultexte,
                       pasv, donnee_min, donnee_centre, donnee_max,
                       donnee_deb, donnee_fin, ValeurAbsolue,BouG,BouD,Cadr3);
                  MontrerSouris;
                  xsi:=xs;
               until not  UnBoutonSourisEnfonce ;
            end else
               if UnBoutonSourisEnfonce and dans (xsi, ys, BouD)
               then begin Bouton1:=False;
                  BoutonInf := false;{On redimensionne avec BouD}
                  repeat
                     CacherSouris;
                     lirepositionsouris (xs, ys);x:=xs-xsi{(BouD.xd+BouD.xg)div 2};
                     If (BouC.xg+BouC.xd)<(cadr3.xg+cadr3.xd)then begin x:=-x;
                        decale_3(coulb, coulicone, coulbouton,BouG,x,BouD{BouC}, cadr3,5);
                        x := -x;
                        decale_3(coulb, coulicone, colord,BouD,x,BouG{BouC}, cadr3,5);
                     end else begin
                        decale_3(coulb, coulicone, colord,BouD,x,BouG{BouC}, cadr3,5);
                        x := -x;
                        decale_3(coulb, coulicone, coulbouton,BouG,x,BouD{BouC}, cadr3,5);
                     end;ReDessBouC(coulbouton); {redess (BouC, coulicone, coulbouton);}

                     calc_donnee
                         (numero, coulb, coultexte,
                          pasv, donnee_min, donnee_centre, donnee_max,
                          donnee_deb, donnee_fin, ValeurAbsolue,BouG,BouD,Cadr3);
                     MontrerSouris;
                     xsi:=xs;
                  until not  UnBoutonSourisEnfonce ;
               end;

         (*if ToucheClavier (Code) then begin
            cachersouris;
            case Code of
               FleG : dx :=-1;
               FleD : dx := 1;
               Tab  : If Bouton1 then begin Bouton1 := False;
                                            BoutonInf := False end
                         else if BoutonInf then begin BoutonInf := False;
                                                      Bouton1 := True end
                                 else BoutonInf := True;
            end;
            x := dx*deplace_b (pasv);

            if Bouton1 then begin
                    redess (BouG, coulicone, coulbouton);
                    redess (BouC, coulicone, colord);
                    redess (BouD, coulicone, coulbouton) end
            else if boutonInf
                 then begin
                    redess (BouG, coulicone, colord);
                    redess (BouC, coulicone, coulbouton);
                    redess (BouD, coulicone, coulbouton)
                 end else begin
                    redess (BouG, coulicone, coulbouton);
                    redess (BouC, coulicone, coulbouton);
                    redess (BouD, coulicone, colord)
                 end;
            if (Code = FleG) or (code = FleD) then
               if bouton1 then begin {on dplace}
                If x>0 then begin {on va vers la droite : tester BouD en 1er}
                  decale_3 (coulb, coulicone, coulbouton,
                            BouD, x , BouC, cadr3) ;
                  decale_3 (coulb, coulicone, colord,
                            BouC, x , BouG, cadr3) ;
                  decale_3 (coulb, coulicone, coulbouton,
                            BouG, x , BouC, cadr3) ;
                end else begin {on va vers la gauche : tester BouG en 1er}
                  decale_3 (coulb, coulicone, coulbouton,
                            BouG, x , BouC, cadr3) ;
                  decale_3 (coulb, coulicone, colord,
                            BouC, x , BouD, cadr3) ;
                  decale_3 (coulb, coulicone, coulbouton,
                            BouD, x , BouC, cadr3) ;
                end;
               end else begin {on redimensionne}
               if boutonInf then begin C_Inf := CoulBouton;C_Sup :=ColorD end
                            else begin C_Inf := ColorD;C_Sup :=CoulBouton end;
               If (BouC.xg+BouC.xd)<(cadr3.xg+cadr3.xd) then begin
                  decale_3 (coulb, coulicone, C_Inf,
                            BouG, x , BouC, cadr3) ;
                  x := -x;
                  decale_3 (coulb, coulicone, C_Sup,
                            BouD, x , BouC, cadr3) ;
               end else begin
                  if BoutonInf then x := -x;
                  decale_3 (coulb, coulicone, C_Sup,
                            BouD, x , BouC, cadr3) ;
                  x := -x;
                  decale_3 (coulb, coulicone, C_Inf,
                            BouG, x , BouC, cadr3) ;
               end;
            aff_donnee (coulb, coultexte,
                dx*pasv, donnee_min, donnee_fin, 'd', donnee_deb);
            aff_donnee (coulb, coultexte,
                dx*pasv, donnee_deb, donnee_max, 'f', donnee_fin);
            montrersouris;
            end;
         end;
         *)
      until (code = esc) or (UnBoutonSourisEnfonce
                            and not (dans (xs, ys, BouG) or
                                     dans (xs, ys, BouC) or
                                     dans (xs, ys, BouD)))
                         or (code = CR);
      cachersouris;
      redess (BouG, coulicone, coulbouton);
      redess (BouC, coulicone, coulbouton);
      redess (BouD, coulicone, coulbouton);
      setusercharsize (3, 2, 3, 2);
   end;

END.


{===========================================================================}
(*
procedure dess_curseur_2 (titre, unite, f_d            : string;
                          numero,
                          coulb, coultexte, coulicone, coulbouton : word;
                          x, y, dx, dy                 : integer;
                          pasv, donnee_min, donnee_max : real;
                          var donnee_deb, donnee_fin   : real);
   var
      dim : integer;

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b :=  -1 * trunc (donnee * dim / (donnee_max-donnee_min));
      end;

   begin
      initformat (f_d, format_dt, format_dp);
      setusercharsize (1, 1, 1, 1);
      coulbar  (1, coulb) ;
      bar                       ( x, y, x+dx, y+dy );
      fixecoul     (coulicone) ;
      rectangle                 ( x, y, x+dx, y+dy ) ;

      { titre }
      fixecoul     (coulbouton) ;
      settextjustify (1, 2);
      outtextxy (x+dx div 2, y+1 , titre);

      { units }
      settextjustify (1, 0);
      outtextxy (x+dx div 2, y+dy-3 , unite);

      { barre horizontale }
      fixecoul  (coulicone) ;
      fixe_lims (cadr2, x    + 3,  y  + 14,
                        x+dx - 3,  y  + 26);

      { boutons }
      fixecoul        (coulicone) ;
      coulbar (1, coulbouton) ;
      fixe_lims (bsup,  x+dx -10,  y  + 16,
                        x+dx - 5,  y  + 24) ;

      fixe_lims (binf,  x+dx -16,  y  + 16,
                        x+dx -11,  y  + 24) ;

      dim      := cadr2.xd -cadr2.xg-4 -binf.xd +binf.xg ;
      if donnee_deb > donnee_min
      then
         decale (coulb, coulicone, coulbouton,
                 binf, (deplace_b (donnee_max-donnee_deb))+6, bsup, cadr2)
      else
         decale (coulb, coulicone, coulbouton,
                 binf, -100,  bsup, cadr2);

      if donnee_fin  < donnee_max
      then
         decale (coulb, coulicone, coulbouton,
                 bsup, (deplace_b (donnee_max-donnee_fin))-1, binf, cadr2) ;
      calc_donnee
         (numero, coulb, coultexte { valeurs },
          pasv, donnee_min, 0, donnee_max, donnee_deb, donnee_fin,False,
          binf,bsup,cadr2);
      setusercharsize (3, 2, 3, 2);
   end;

procedure modif_donnee_2(numero,
                         coulb, coultexte, coulicone, coulbouton : word;
                         pasv, donnee_min, donnee_max     : real;
                         var donnee_deb, donnee_fin       : real);
   var
      code, dx,
      xdep, ydep,
      xmem, ymem
                   : integer;
      BoutonInf,
      deplace      : boolean;

      dim, di2,
      xgi, xdi, yhi, ybi : integer;

   procedure aff_donnee_d (coulb, coulbouton                   : word;
                           pasv, donnee_min, donnee_max : real;
                           var donnee   : real);
      var
         ch                 : string;

      begin
         donnee := donnee + pasv;
         if donnee < donnee_min then donnee := donnee_min;
         if donnee > donnee_max then donnee := donnee_max;

         coulbar (1, coulb) ;
         bar (xgi+1,     yhi +28,
              xdi-1-di2, yhi +37 ) ;
         fixecoul (coulbouton) ;

         settextjustify (0, 2);
         donnee := round (donnee/pasv) *pasv;
         formater  (donnee, format_dt, format_dp, ch,False) ;
         outtextxy (xgi+2, yhi + 28, ch) ;
      end;

   procedure aff_donnee_f (coulb, coulbouton   : word;
                           pasv, donnee_min, donnee_max : real;
                           var donnee   : real);
      var
         ch                 : string;

      begin
         donnee := donnee + pasv;
         if donnee < donnee_min then donnee := donnee_min;
         if donnee > donnee_max then donnee := donnee_max;

         coulbar (1, coulb) ;
         bar (xgi+1+di2, yhi +28,
              xdi-1,     yhi +37 ) ;
         fixecoul (coulbouton) ;

         settextjustify (2, 2);
         donnee := round (donnee/pasv) *pasv;
         formater  (donnee, format_dt, format_dp, ch,False) ;
         outtextxy (xdi-2, yhi + 28, ch) ;
      end;

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b := trunc (donnee * dim / (donnee_max-donnee_min));
      end;

   begin
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim :=  (cadr2.xd-cadr2.xg-4-binf.xd+binf.xg) ;
      di2 := (xdi-xgi) div 2;
      setusercharsize (1, 1, 1, 1);
      xmem  :=  0;
      ymem  :=  0;
      BoutonInf := false;

      montrersouris;
      repeat
         code := 0;
         lirepositionsouris (xs, ys);
         if UnBoutonSourisEnfonce  and dans (xs, ys, binf)
         then begin
            BoutonInf := true;
            repeat
               cachersouris; redess (bsup, coulicone, coulbouton);
               lirepositionsouris (xs, ys);
               decale
                   (coulb, coulicone, colord,
                    binf, xs- (binf.xd+binf.xg)  div 2, bsup, cadr2) ;
               calc_donnee
                   (numero, coulb, coultexte,
                    pasv, donnee_min, 0, donnee_max, donnee_deb, donnee_fin,False,
                    binf,bsup,cadr2);
               MontrerSouris;
            until not  UnBoutonSourisEnfonce ;
         end else
            if UnBoutonSourisEnfonce and dans (xs, ys, bsup)
            then begin
               BoutonInf := false;
               repeat
                  CacherSouris;redess (binf, coulicone, coulbouton);
                  lirepositionsouris (xs, ys);
                  decale
                     (coulb, coulicone, colord,
                      bsup, xs- (bsup.xd+bsup.xg) div 2, binf, cadr2) ;
                  calc_donnee
                     (numero, coulb, coultexte,
                      pasv, donnee_min, 0, donnee_max, donnee_deb, donnee_fin,
                      False,binf,bsup,cadr2);
                  MontrerSouris;
               until not  UnBoutonSourisEnfonce ;
            end;

         if ToucheClavier (Code)
         then begin
            cachersouris;
            case Code of
               FleG : dx :=-1;
               FleD : dx := 1;
               Tab  : BoutonInf := not BoutonInf;
            end;

            if boutonInf
            then begin
               redess (binf, coulicone, colord);
               redess (bsup, coulicone, coulbouton)
            end else begin
               redess (binf, coulicone, coulbouton);
               redess (bsup, coulicone, colord)
            end;
            if (Code = FleG) or (code = FleD)
            then
               if boutonInf
               then begin
                  decale
                     (coulb, coulicone, colord,
                      binf, dx*deplace_b (pasv), bsup, cadr2) ;
                  aff_donnee_d
                     (coulb, coultexte,
                      dx*pasv, donnee_min, donnee_fin, donnee_deb);
               end else begin
                  decale
                     (coulb, coulicone, colord,
                      bsup, dx*deplace_b (pasv), binf, cadr2) ;
                  aff_donnee_f
                     (coulb, coultexte,
                      dx*pasv, donnee_deb, donnee_max, donnee_fin);
               end;
            montrersouris;
         end;
      until (code = esc) or (UnBoutonSourisEnfonce
                            and not (dans (xs, ys, binf) or dans (xs, ys, bsup)))
                         or (code = CR);
      cachersouris;
      redess (binf, coulicone, coulbouton);
      redess (bsup, coulicone, coulbouton);
      setusercharsize (3, 2, 3, 2);
   end;

{===========================================================================}
procedure decale_1 (coulicone, coulbouton : word ;
                    var lim               : limites;
                          x               : integer;
                    cadr1                 : limites) ;
   { dcale le BOUT de la distance X (pixels)
            de la position initiale LIM  dans les limites du CADRE }
   var
      y1, y2   : integer;

   begin
      with lim do begin
         y1  := (yh+yb) div 2 - 1;
         y2  := y1+2;

         coulbar (1, coulboite);    { effacer le bouton en cours }
         bar    (xg,  yh, xd, yb);

         if xg+x <= cadr1.xg+2 then x := cadr1.xg+2-xg;
         if xd+x >= cadr1.xd-2 then x := cadr1.xd-2-xd;

         xg  :=  xg+ x;
         xd  :=  xd+ x;

         fixecoul  (coulicone) ;
         rectangle ( xg,  yh,  xd,  yb ) ;
         coulbar (1, coulbouton) ;
         bar ( xg+1,  yh+1,  xd-1,  yb-1 ) ;
      end;
   end;

procedure calc_donnee_1 ( numero,
                          coulbouton                   : word;
                          pasv, donnee_min, donnee_max : real;
                          var donnee                   : real);
   var
      ch                 : string;
      dim,
      xgi, xdi, yhi, ybi : integer;

   begin
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim         :=  (cadr1.xd-cadr1.xg-4-bou1.xd+bou1.xg);
      donnee      :=  donnee_min+ (donnee_max-donnee_min)
                                * (bou1.xg-cadr1.xg-2) /dim;

      coulbar (1, coulboite);
      bar (xgi+1,            yhi +28,
          (xgi+xdi) div 2,   ybi -1);
      fixecoul (coulbouton) ;

      settextjustify (0, 0);
      donnee := round (donnee/pasv) *pasv;
      formater  (donnee, format_dt, format_dp, ch,False);
      outtextxy (xgi+2,             ybi-4, ch);
   end;

procedure dess_curseur_1 (titre, unite, f_d            : string;
                          numero,
                          coultexte, coulicone, coulbouton : word;
                          x, y, dx, dy                 : integer;
                          pasv, donnee_min, donnee_max : real;
                          var donnee                   : real);
   var
      y1,
      dim      : integer;

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b :=  -1 * round (donnee * dim / (donnee_max-donnee_min));
      end;

   begin
      initformat (f_d, format_dt, format_dp);
      setusercharsize (1, 1, 1, 1);
      coulbar (1, coulboite) ;
      bar                       ( x, y, x+dx, y+dy );
      fixecoul     (coulicone) ;
      rectangle                 ( x, y, x+dx, y+dy ) ;

      { titre }
      fixecoul     (coulbouton) ;
      settextjustify (1, 2);
      outtextxy (x+dx div 2, y+1 , titre);

      { units }
      settextjustify (2, 0);
      outtextxy (x+dx-2, y+dy-4, unite) ;

      { barre horizontale }
      fixecoul     (coulicone) ;
      fixe_lims (cadr1, x    + 3,  y  + 14,
                        x+dx - 3,  y  + 26);

      { un bouton }
      fixecoul        (coulicone) ;
      coulbar (1, coulbouton) ;
      fixe_lims (bou1  ,x+dx -10,  y  + 16,
                        x+dx - 5,  y  + 24) ;

      dim      := cadr1.xd -cadr1.xg-4 -bou1.xd +bou1.xg ;

      decale_1 (coulicone, coulbouton,
                bou1, deplace_b (donnee_max-donnee), cadr1) ;
{      aff_donnee_1
            (numero, coultexte,
             0, donnee_min, donnee_max, donnee);      }
      calc_donnee_1
               (numero, coultexte ,
                pasv, donnee_min, donnee_max, donnee);

      setusercharsize (3, 2, 3, 2);
   end;

procedure modif_donnee_1 (numero,
                          coultexte, coulicone, coulbouton : word;
                          pasv, donnee_min, donnee_max     : real;
                          var donnee                       : real);
   var
      code, dx,
      xdep, ydep,
      xmem, ymem,
      dim,
      xgi, xdi,
      yhi, ybi
                   : integer;
      fini,
      deplace      : boolean;

   procedure aff_donnee_1  ( coulbouton                   : word;
                             pasv, donnee_min, donnee_max : real;
                             var donnee                   : real);
      var
         ch                 : string;

      begin
         donnee      :=  donnee+pasv;
         if donnee < donnee_min then donnee := donnee_min;
         if donnee > donnee_max then donnee := donnee_max;

         coulbar (1, coulboite);
         bar (xgi+1,            yhi +28,
             (xgi+xdi) div 2,   ybi -1);
         fixecoul (coulbouton) ;

         settextjustify (0, 0);
         donnee := round (donnee/pasv) *pasv;
         formater  (donnee, format_dt, format_dp, ch,False);
         outtextxy (xgi+2,             ybi-4, ch);
      end;

   function deplace_b (pasv : real) : integer;
      begin
         deplace_b   :=  round (pasv * dim / (donnee_max-donnee_min));
      end;

   begin
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim :=  (cadr1.xd-cadr1.xg-4-bou1.xd+bou1.xg);
      setusercharsize (1, 1, 1, 1);
      fini  :=  false;
      xmem  :=  0;
      ymem  :=  0;
      montrersouris;
      REPEAT
         code  := 0;
         lirepositionsouris (xs, ys);
         if UnBoutonSourisEnfonce  and dans (xs, ys, bou1)
         then begin
            repeat
               cachersouris;
               lirepositionsouris (xs, ys);
               decale_1
                     (coulicone, colord,
                      bou1, xs- (bou1.xd+bou1.xg)  div 2, cadr1) ;
               calc_donnee_1
                     (numero,  coultexte,
                      pasv, donnee_min, donnee_max, donnee);
               montrersouris;
            until not  UnBoutonSourisEnfonce ;
            fini  :=  true;
         end;
         if ToucheClavier (Code)
         then begin
            cachersouris;
            case Code of
               FleG : dx := -1;
               FleD : dx := 1;
            end;
            if (Code = FleG) or (Code = FleD)
            then begin
               decale_1
                     (coulicone, colord,
                      bou1, dx*deplace_b(pasv), cadr1) ;
               aff_donnee_1
                     (coultexte,
                      dx*pasv, donnee_min, donnee_max, donnee);
               montrersouris;
            end;
         end;
      until (Code = esc) or (UnBoutonSourisEnfonce
                            and not dans (xs, ys, bou1))
                         or (code = CR);
      redess (bou1, coulicone, coulbouton);
      setusercharsize (3, 2, 3, 2);
      cachersouris;
   end;

END.

procedure dess_curseur_3 (titre, unite, f_d            : string;
                          numero,
                          coulb, coultexte, coulicone, coulbouton : word;
                          {x, y, dx, dy                 : integer;}
                          pasv,donnee_min,donnee_centre,donnee_max: real;
                          var donnee_deb, donnee_fin   : real;
                          ValeurAbsolue                : boolean);
   var
      xgi,xdi,yhi,ybi, dim : integer;


   function deplace_b (donnee : real) : integer;
      begin
         deplace_b :=  -1*trunc(donnee*dim/(donnee_max-donnee_min));
      end;

   begin xgi := xgicone (numero);  xdi := xdicone (numero);
         yhi := yhicone (numero);  ybi := ybicone (numero);
      initformat (f_d, format_dt, format_dp);
      setusercharsize (1, 1, 1, 1);
      coulbar  (1, coulb) ;
      bar                       ( xgi, yhi, xdi, ybi );
      fixecoul     (coulicone) ;
      rectangle                 ( xgi, yhi, xdi, ybi ) ;

      { titre }
      fixecoul     (coulbouton) ;
      settextjustify (1, 2);
      outtextxy (xdi div 2, yhi+1 , titre);

      { units }
      settextjustify (1, 0);
      outtextxy (xdi div 2, ybi-3 , unite);

      { barre horizontale }
      fixecoul  (coulicone) ;
      fixe_lims (cadr3, xgi + 3,  yhi  + 14,
                        xdi - 3,  yhi  + 26);

      { boutons }
      fixecoul (coulicone) ;
      coulbar  (1, coulbouton) ;
      fixe_lims (BouD,  xdi -10,  yhi  + 16,
                        xdi - 5,  yhi  + 24) ;

      fixe_lims (BouC,  xdi -16,  yhi  + 16,
                        xdi -11,  yhi  + 24) ;

      fixe_lims (BouG,  xdi -22,  yhi  + 16,
                        xdi -17,  yhi  + 24) ;

      dim      := cadr3.xd -cadr3.xg-4 -BouG.xd +BouG.xg ;
      if donnee_deb < donnee_min then donnee_deb := donnee_min;
      if donnee_fin > donnee_max then donnee_fin := donnee_max;
      decale (coulb, coulicone, coulbouton,
              BouG, (deplace_b (donnee_max-donnee_deb))+11, BouC, cadr3);
      decale (coulb, coulicone, coulbouton,
              BouC, (deplace_b (donnee_max-(donnee_deb+donnee_fin)/2))+5,
              BouG, Cadr3) ;
      coulbar (1,  coulicone) ;bar (BouC.xd, yhi+19, BouD.xg, yhi+21) ;

      if donnee_fin  < donnee_max then
      decale (coulb, coulicone, coulbouton,
              BouD, (deplace_b (donnee_max-donnee_fin))-1, BouC, cadr3) ;

      calc_donnee
         (numero, coulb, coultexte { valeurs },
          pasv, donnee_min, donnee_centre, donnee_max,
          donnee_deb, donnee_fin,ValeurAbsolue,BouG,BouD,Cadr3);
      setusercharsize (3, 2, 3, 2);
   end;

Procedure decale_3 (coulb, coulicone, coulbouton : word ;
                  var lim               : limites;
                  var x                 : integer;
                  bout, cadre           : limites) ;
   { dcale le BOUT de la distance X (pixels)
            de la position initiale LIM  dans les limites BOUT, CADRE }
   var
      y1, y2   : integer;

   begin
      with lim do begin
         y1  :=  (yh+yb)  div 2 - 1;
         y2  :=  y1+2;

         coulbar  (1, coulb) ;
         bar       (xg,  yh, xd, yb);
         if xd < bout.xg
         then begin
            if xg+x <= cadre.xg+2 then x  :=  cadre.xg+2-xg;
            if xd+x >= bout.xg    then x  :=  bout.xg-xd-1  ;

            if x > 0
            then begin
               coulbar (1, coulb) ;
               bar (xd+1, y1, xd+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xd+x, y1, xd,   y2) ;
            end;

         end else begin
            if xd+x >= cadre.xd-2 then x  :=  cadre.xd-2-xd;
            if xg+x <= bout.xd    then x  :=  bout.xd-xg+1  ;

            if x < 0
            then begin
               coulbar (1,  coulb) ;
               bar (xg-1, y1, xg+x, y2) ;
            end else begin
               coulbar (1, coulicone) ;
               bar (xg+x, y1, xg,   y2) ;
            end;
         end;

         xg  :=  xg+x;
         xd  :=  xd+x;
         fixecoul (coulicone) ;
         rectangle ( xg,  yh,  xd,  yb ) ;
         coulbar (1, coulbouton) ;
         bar ( xg+1,  yh+1,  xd-1,  yb-1 ) ;
      end;
   end;

procedure modif_donnee_3(numero,
                         coulb, coultexte, coulicone, coulbouton : word;
                         pasv,donnee_min,donnee_centre,donnee_max: real;
                         var donnee_deb, donnee_fin       : real;
                         ValeurAbsolue                    : boolean);
   var
      code, dx,
      xdep, ydep,
      xmem, ymem,
      x            : integer;
      BoutonInf,Bouton1,
      deplace      : boolean;

      dim, di2,
      xgi, xdi, yhi, ybi : integer;
      C_Inf, C_Sup       : word;

   procedure aff_donnee (coulb, coulbouton            : word;
                         pasv, donnee_min, donnee_max : real;
                         place                        : char;
                         var donnee   : real);
      var
         ch                 : string;
         Prov1,Prov2        : real;
   begin Prov1 := Donnee+PasV;
         If (donnee< -donnee_centre)and(Prov1>=donnee_centre)then
            Prov2:=Prov1+2*donnee_centre else prov2 := Prov1;
         If (donnee>donnee_centre)  and(prov1<=-donnee_centre)then
            Prov2:=Prov1-2*donnee_centre else Prov2 := Prov1;
         donnee:=prov2;
         if donnee < donnee_min then donnee := donnee_min;
         if donnee > donnee_max then donnee := donnee_max;
         donnee := round (donnee/pasv) *pasv;
         formater  (donnee, format_dt, format_dp, ch,ValeurAbsolue) ;
         coulbar (1, coulb) ; fixecoul (coulbouton) ;
         Case place of
         'd' : begin bar (xgi+1, yhi +28, xdi-1-di2, yhi +37 ) ;
               settextjustify (0, 2);
               outtextxy (xgi+2, yhi + 28, ch)  end;
         'f' : begin bar (xgi+1+di2, yhi +28, xdi-1, yhi +37 ) ;
               settextjustify (2, 2);
               outtextxy (xdi-2, yhi + 28, ch) end;
         end;
      end;

   function deplace_b (donnee : real) : integer;
      begin
         deplace_b := trunc (donnee * dim / (donnee_max-donnee_min));
      end;

   begin
      xgi := xgicone (numero);
      xdi := xdicone (numero);
      yhi := yhicone (numero);
      ybi := ybicone (numero);
      dim :=  (cadr3.xd-cadr3.xg-4-BouG.xd+BouG.xg) ;
      di2 := (xdi-xgi) div 2;
      setusercharsize (1, 1, 1, 1);
      xmem  :=  0;
      ymem  :=  0;
      BoutonInf := False; Bouton1:=True;

      montrersouris;
      repeat
         code := 0;
         lirepositionsouris (xs, ys);
         if UnBoutonSourisEnfonce  and dans (xs, ys, BouC)
         then begin Bouton1 := true; {on dplace}
            repeat
               lirepositionsouris (xs, ys); x := xs-(BouC.xd+BouC.xg)div 2;
               if x<>0 then begin Cachersouris;
                If x>0 then begin {on va  droite => tester BouD en 1er}
                  decale_3 (coulb, coulicone, coulbouton, BouD, x , BouC, cadr3) ;
                  decale_3 (coulb, coulicone, colord,     BouC, x , BouG, cadr3) ;
                  decale_3 (coulb, coulicone, coulbouton, BouG, x , BouC, cadr3) ;
                end else    begin {on va  gauche => tester BouG en 1er}
                  decale_3 (coulb, coulicone, coulbouton, BouG, x , BouC, cadr3) ;
                  decale_3 (coulb, coulicone, colord,     BouC, x , BouD, cadr3) ;
                  decale_3 (coulb, coulicone, coulbouton, BouD, x , BouC, cadr3) ;
                end;
                calc_donnee
                   (numero, coulb, coultexte,
                    pasv, donnee_min, donnee_centre, donnee_max,
                    donnee_deb, donnee_fin, ValeurAbsolue, BouG,BouD,Cadr3);
               MontrerSouris end;
            until not  UnBoutonSourisEnfonce ;
         end else
            if UnBoutonSourisEnfonce  and dans (xs, ys, BouG)
            then begin Bouton1:=False;
               BoutonInf := true; {On redimensionne avec BouG}
               repeat
                  cachersouris;
                  lirepositionsouris (xs, ys); x := xs-(BouG.xd+BouG.xg)div 2;
                  If (BouC.xg+BouC.xd)<(cadr3.xg+cadr3.xd) then begin
                     decale_3(coulb, coulicone, colord,BouG,x,BouC, cadr3) ;
                     x := -x;
                     decale_3(coulb, coulicone, coulbouton,BouD,x,BouC, cadr3) ;
                  end else begin x := -x;
                     decale_3(coulb, coulicone, coulbouton,BouD,x,BouC, cadr3) ;
                     x := -x;
                     decale_3(coulb, coulicone, colord,BouG,x,BouC, cadr3) ;
                  end;Redess (BouC, coulicone, coulbouton);
                  calc_donnee
                      (numero, coulb, coultexte,
                       pasv, donnee_min, donnee_centre, donnee_max,
                       donnee_deb, donnee_fin, ValeurAbsolue,BouG,BouD,Cadr3);
                  MontrerSouris;
               until not  UnBoutonSourisEnfonce ;
            end else
               if UnBoutonSourisEnfonce and dans (xs, ys, BouD)
               then begin Bouton1:=False;
                  BoutonInf := false;{On redimensionne avec BouD}
                  repeat
                     CacherSouris;
                     lirepositionsouris (xs, ys);x:=xs-(BouD.xd+BouD.xg)div 2;
                     If (BouC.xg+BouC.xd)<(cadr3.xg+cadr3.xd)then begin x:=-x;
                        decale_3(coulb, coulicone, coulbouton,BouG,x,BouC, cadr3);
                        x := -x;
                        decale_3(coulb, coulicone, colord,BouD,x,BouC, cadr3);
                     end else begin
                        decale_3(coulb, coulicone, colord,BouD,x,BouC, cadr3);
                        x := -x;
                        decale_3(coulb, coulicone, coulbouton,BouG,x,BouC, cadr3);
                     end;Redess (BouC, coulicone, coulbouton);

                     calc_donnee
                         (numero, coulb, coultexte,
                          pasv, donnee_min, donnee_centre, donnee_max,
                          donnee_deb, donnee_fin, ValeurAbsolue,BouG,BouD,Cadr3);
                     MontrerSouris;
                  until not  UnBoutonSourisEnfonce ;
               end;

         if ToucheClavier (Code) then begin
            cachersouris;
            case Code of
               FleG : dx :=-1;
               FleD : dx := 1;
               Tab  : If Bouton1 then begin Bouton1 := False;
                                            BoutonInf := False end
                         else if BoutonInf then begin BoutonInf := False;
                                                      Bouton1 := True end
                                 else BoutonInf := True;
            end;
            x := dx*deplace_b (pasv);

            if Bouton1 then begin
                    redess (BouG, coulicone, coulbouton);
                    redess (BouC, coulicone, colord);
                    redess (BouD, coulicone, coulbouton) end
            else if boutonInf
                 then begin
                    redess (BouG, coulicone, colord);
                    redess (BouC, coulicone, coulbouton);
                    redess (BouD, coulicone, coulbouton)
                 end else begin
                    redess (BouG, coulicone, coulbouton);
                    redess (BouC, coulicone, coulbouton);
                    redess (BouD, coulicone, colord)
                 end;
            if (Code = FleG) or (code = FleD) then
               if bouton1 then begin {on dplace}
                If x>0 then begin {on va vers la droite : tester BouD en 1er}
                  decale_3 (coulb, coulicone, coulbouton,
                            BouD, x , BouC, cadr3) ;
                  decale_3 (coulb, coulicone, colord,
                            BouC, x , BouG, cadr3) ;
                  decale_3 (coulb, coulicone, coulbouton,
                            BouG, x , BouC, cadr3) ;
                end else begin {on va vers la gauche : tester BouG en 1er}
                  decale_3 (coulb, coulicone, coulbouton,
                            BouG, x , BouC, cadr3) ;
                  decale_3 (coulb, coulicone, colord,
                            BouC, x , BouD, cadr3) ;
                  decale_3 (coulb, coulicone, coulbouton,
                            BouD, x , BouC, cadr3) ;
                end;
               end else begin {on redimensionne}
               if boutonInf then begin C_Inf := CoulBouton;C_Sup :=ColorD end
                            else begin C_Inf := ColorD;C_Sup :=CoulBouton end;
               If (BouC.xg+BouC.xd)<(cadr3.xg+cadr3.xd) then begin
                  decale_3 (coulb, coulicone, C_Inf,
                            BouG, x , BouC, cadr3) ;
                  x := -x;
                  decale_3 (coulb, coulicone, C_Sup,
                            BouD, x , BouC, cadr3) ;
               end else begin
                  if BoutonInf then x := -x;
                  decale_3 (coulb, coulicone, C_Sup,
                            BouD, x , BouC, cadr3) ;
                  x := -x;
                  decale_3 (coulb, coulicone, C_Inf,
                            BouG, x , BouC, cadr3) ;
               end;
            aff_donnee (coulb, coultexte,
                dx*pasv, donnee_min, donnee_fin, 'd', donnee_deb);
            aff_donnee (coulb, coultexte,
                dx*pasv, donnee_deb, donnee_max, 'f', donnee_fin);
            montrersouris;
            end;
         end;
      until (code = esc) or (UnBoutonSourisEnfonce
                            and not (dans (xs, ys, BouG) or
                                     dans (xs, ys, BouC) or
                                     dans (xs, ys, BouD)))
                         or (code = CR);
      cachersouris;
      redess (BouG, coulicone, coulbouton);
      redess (BouC, coulicone, coulbouton);
      redess (BouD, coulicone, coulbouton);
      setusercharsize (3, 2, 3, 2);
   end;

