Unit Fourier_;

                 { ******************************
                   *   Transforme de Fourier   *
                   * discrte d'un vecteur rel *
                   ******************************

Units utilises: Math }

INTERFACE
{$O+,F+}

Uses Mathh;

Type t1026 = array [1..1026] of real;

Procedure FOUR1 (var donnee {data}: t1026; nn, isign: integer);

{ The Cooley-Tukey fast fourier transform in Usasi Basic Transform
  (ref. Cooley and Tukey, 1965, math. computation).
                n
                \-
  Transform(k) = > data(j)*exp(isign*2*pi*sqrt(-1)*(j-1)*(k-1)/n))
                /_
               j=1
     over all k = 1 to n

          data = complex array with real and imaginary components
                 in adjacent positions in storage (i.e. real=2i-1,
                 imaginary=2i, i=1,n ).
             n = number of points = 2**integer
         isign = +1 or -1
                 if +1 is followed by -1 in consecutive calls to four1
                 the original data reappears multiplied by n.

  the transformed array is returned by replacing the original data
  values.
  time required is proportional to  n*log2(n).
  rms relative error is bounded by  6*sqrt(2)*log2(n)*2**(-b)
          where b is the number of bits in the floating point
          fraction.
  author is  Norman Brenner of MIT Lincoln Labs, july, 1967.
          shortest fft known to the author.
  faster programs four2 and fourt exist that operate on arbitrarily
  sized multidimensional arrays.
  see-- Ieee Audio Transactions (june 1967), special issue on fft.
                                                                      }

Procedure FFT (var x: t1026; n, isign: integer);

{ programmer: various

  title:     fft - fast fourier transform

  purpose:   calculates forward transform of a real array of equally
             spaced values and reverse transform of a complex array
             of fourier coefficients.

             x = data sampled at constant interval
             n = number of sampled points = 2**integer
             isign = +1  forward transform of real array x (n)
                   = -1  reverse transform of complex array x of
                         length n/2 + 1, where xr = (2i-1) and
                         xi = (2i), i=1,n/2+1 .

  files used: none

  restrictions:

      if fft is called twice with isign first +1 then -1 or
      vice versa, the original data is returned multiplied by n/2.

      to obtain correct absolute values after one call to fft, the
      x values returned should be multiplied by the sample interval.

      fft is required as a driver for four1 when the array to be
      forward transformed is real and of length n. if the data
      is complex and of length n/2 then four1 may be used alone.

  subprograms:  four1

  method:       computes the fast fourier transform using the
                Cooley-Tukey algorithm (Cooley and Tukey, 1965,
                math. computations)

  for theoretical background see:
          1.   Brigham, E.O., 1974, The fast fourier transform,
               Prentice-hall, inc., Englewood n.j.
          2.   Bloomfield, P., 1976, Fourier analysis of time series;
               an introduction, John Wiley & sons, N.Y.
                                                                      }

IMPLEMENTATION

Procedure FOUR1 (var donnee : t1026; nn, isign : integer);
Var ii, jj, n, nmax, m, j, istep, i : integer;
    Wtemp, Wr, Wpr, Wpi, Wi, Theta, Tempr, Tempi : Real;
Begin
     {Isign := 1;} n := 2*nn; j := 1;
     For ii := 1 to nn do begin
         i := 2*ii-1;
         if j > i then begin
            Tempr := donnee[j]; Tempi := donnee[j+1];
            donnee[j] := donnee[i]; donnee[j+1] := donnee[i+1];
            donnee[i] := Tempr; donnee[i+1] := Tempi;
         end;
         m := n div 2;
         While ((m>=2) and (j>m)) do begin
               j := j - m; m := m div 2;
         end;
         Inc(j,m);
     end;
     NMax := 2;
     While n > NMax do begin
           IStep := 2 * NMax; Theta := 2 * Pi / (ISign * NMax);
           Wpr   := -2 * Sqr(Sin(Theta / 2));Wpi:=Sin(Theta);
           Wr := 1; Wi := 0;
           For ii := 1 to NMax div 2 do begin
               m := 2 * ii - 1;
               For jj := 0 to ((n - m) div iStep) do begin
                   i := m + jj * iStep; j := i + NMax;
                   TempR := wr * Donnee[j] - wi * Donnee[j+1];
                   TempI := wr * Donnee[j+1] + wi * Donnee[j];
                   Donnee[j] := Donnee[i] - TempR;
                   Donnee[j+1] := Donnee[i+1] - TempI;
                   Donnee[i] := Donnee[i] + TempR;
                   Donnee[i+1] := Donnee[i+1] + TempI;
               end;
               WTemp := Wr;
               Wr := Wr * (wpr +1) - wi * wpi;
               Wi := Wi * (wpr +1) + wtemp * wpi;
           end;
           NMax := Istep;
     end;
end;


(*
Procedure FOUR1 (var donnee : t1026; nn, isign : integer);
Label EndLoop1, EndLoop2, EndLoop3, Entree, Sortie, Debut, Fin;

var ip0, ip1, ip2, ip3, i3rev, i1, i2a, i2b, i3    : integer;
    tempr, tempi, theta, sinth,wstpr, wstpi, wr,wi : real;

begin
  ip0   := 2;
  ip3   := ip0 * n;
  i3rev := 1;
  for i3 := 1 to ip3 do begin
    if (MODULO(i3+ip0-1,ip0) <> 0) then goto EndLoop1; { loop with step ip0 }
    if (i3 < i3rev) then begin tempr         := data[i3];
                               tempi         := data[i3+1];
                               data[i3]      := data[i3rev];
                               data[i3+1]    := data[i3rev+1];
                               data[i3rev]   := tempr;
                               data[i3rev+1] := tempi; end;
    ip1 := ip3 div 2;
  Entree:
    if (i3rev <= ip1) then goto Sortie;
    i3rev := i3rev - ip1;
    ip1   := ip1 div 2;
    if (ip1 >= ip0) then goto Entree;
  Sortie:
    i3rev := i3rev + ip1;
EndLoop1:
  end;
  ip1 := ip0;
Debut:
   if (ip1 >= ip3) then goto Fin;
   ip2    := ip1 * 2;
   theta  := 6.283185307 / (isign*ip2/ip0);
   sinth  := sin (theta/2.0);
   wstpr  := -2.0 * sinth * sinth;
   wstpi  := sin (theta);
   wr     := 1.0;
   wi     := 0.0;
   for i1 := 1 to ip1 do begin                           { Loop with step ip0 }
     if (MODULO(i1+ip0-1, ip0) <> 0) then goto EndLoop3;
     for i3 := i1 to ip3 do begin                        { Loop with step ip2 }
       if (MODULO(i3+ip2-1, ip2) <> 0) then goto EndLoop2;
       i2a         := i3;
       i2b         := i2a + ip1;
       tempr       := wr * data[i2b]   - wi * data[i2b+1];
       tempi       := wr * data[i2b+1] + wi * data[i2b];
       data[i2b]   := data[i2a]   - tempr;
       data[i2b+1] := data[i2a+1] - tempi;
       data[i2a]   := data[i2a]   + tempr;
       data[i2a+1] := data[i2a+1] + tempi;
     EndLoop2:
     end;
     tempr := wr;
     wr    := wr * wstpr - wi    *wstpi + wr;
     wi    := wi * wstpr + tempr *wstpi + wi;
   EndLoop3:
   end;
   ip1 := ip2;
   goto Debut;
Fin:
end;*)

Procedure FFT (var x: t1026; n, isign: integer);

var nn, nm, fn, j, i, k1i, k1j, k2i, k2j         : integer;
    s, ex, wr, wi, wwr, wwi, wrr, a1, a2, b1, b2 : real;

begin
  nn := n div 2;
  if (isign = 1) then begin x[n+1] := 0.0; { compute forward transform }
                            x[n+2] := 0.0;
                            FOUR1 (x,nn,1); end;
  s   := x[1];    { set up constants }
  nm  := nn div 2;
  fn  := n;
  ex  := 6.283185307 / fn;
  j   := nn;
  wr  := 1.0;
  wi  := 0.0;
  wwr :=  cos (ex);
  wwi := -sin (ex);
  if (isign > 0) then begin { set up end values for the forward transform }
    x[1]   := x[1] + x[2];
    x[n+1] :=    s - x[2];
    x[2]   := 0.0;
    x[n+2] := 0.0;
    end
  else begin                { set up end values for the reverse transform }
    x[1]   := 0.5 * (x[1] + x[n+1]);
    x[2]   := 0.5 * (   s - x[n+1]);
    x[n+1] := 0.0;
    x[n+2] := 0.0;
    end;
  x[nn+2] := -x[nn+2];
  for i := 2 to nm do begin         { rearrange array elements }
    wrr    := wr * wwr - wi * wwi;
    wi     := wr * wwi + wi * wwr;
    wr     := wrr;
    k1j    := 2 * j - 1;
    k1i    := 2 * i - 1;
    k2j    := 2 * j;
    k2i    := 2 * i;
    a1     := 0.5 * ( x[k1i] + x[k1j] );
    a2     := 0.5 * ( x[k2i] - x[k2j] );
    b1     := 0.5 * (-x[k1i] + x[k1j] );
    b2     := 0.5 * (-x[k2i] - x[k2j] );
    s      := b1;
    b1     := b1 * wr + b2 * wi;
    b2     := b2 * wr -  s * wi;
    x[k1i] :=  a1 - b2;
    x[k2i] := -a2 - b1;
    x[k1j] :=  a1 + b2;
    x[k2j] :=  a2 - b1;
    j      := j - 1;
  end;
  if (isign = -1) then begin  { compute reverse transform }
    FOUR1 (x,nn,-1);
    for i := 1 to n do x[i] := x[i] / nn;
    x[n+1] := 0.0;
    x[n+2] := 0.0;
    end;
end;

end.
