UNIT COUP_DES;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                   procdures graphiques du module COUP                 }
   {------------------------------------------------------------------------}

   (*
   Coup_Des,         { graphisme du module                                  }
   *)

INTERFACE

{$O+,F+}

USES
   Dos,
   Graph,                    { TP 70   - unit  standard Borland            }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Edition,                  { ARX     - saisie/dition paramtres          }
   Graphism,                 { ARX     - initialisations graphiques         }
   Messarx,                  { ARX     - Textes des Messages de Base        }

   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Graphuti,                 { ARX     - utilitaires graphiques             }
   Graphsg,                  { ARX     - symboles et graduations            }
   Menus,                    { ARX     - interface menus                    }
   Icones,                   { ARX     - gestion de icnes                  }

   GRILLES,                  { ARX     - lecture des grilles                }
   COUPES,                   { ARX     - Calcul des coupes                  }

   GEO_VAR,                  { GEO     - variables globales communes        }
   GEO_DES,                  { GEO     - procdures graph. communes         }

   COUP_VAR,                 { COUP    - variables globales du module       }
   COUP_CAL;                 { COUP    - Calculs popres au module           }

{---------------------------------------------------------------------------}

Procedure aj_fond             (trac : boolean);
   { }

Procedure choisir_params_p;
   { Largeur                                                                }

Procedure choisir_params_l;
   { Lissage                                                                }

Procedure choix_4couleurs     (comm         : chainecar;
                               var cc1, cc2,
                                   cc3, cc4 : byte);
   { Dfinir les couleurs principales des profils                           }

{Procedure choisir_params_suite ;}
   { Domaine, densit, coefx, coefz, cart-type                             }

Procedure ajoute_grille       (trac, eff : boolean);
   { redessine la grille                                                    }
   {           dans la fentre principale                                   }

Function visupro                                                : boolean;
   { rend vrai si un profil au moins est affich                            }

Procedure efface_carte;
   { efface la carte si possible                                            }

Procedure modi_aff_carte;
   { dessine fentre graphique complte avec contour                        }

Procedure modi_aff_coupe      (f3, f4             : real;
                               t                  : chainecar;
                               var c1, c2, c3, c4 : integer;
                               var ech            : real);
   { dessine fentre graphique complte avec profil                         }

Procedure efftout;
   { efface la carte                                                        }
   { et libre les pointeurs sur la griile                                  }

Procedure recalc_ecran;
   { recalcule les coordonnes pour un cran autre que VGA                  }

Procedure def_icones;
   { Dfinit les icnes                                                     }

Procedure dess_icones;
   { affiche les icnes                                                     }

Procedure ini_extrems;
   { Demande de dfinir un profil si Nouveau                                }

Procedure iniecran;
   { initialise les paramtres de l'cran en fonction du fichier param      }

Procedure InifondEcran;
   { initialise l'tat de l'cran en fonction du fichier CFG                }

Procedure finir;
   { sort en rtablissant l'cran texte                                     }

Procedure ajoute_contours     (trac, eff    : boolean);
   { dessiner seulement les contours sans rgnrer toutes les courbes      }

Procedure redess_carte        (trac         : boolean);
   { carte et toponymie }

Procedure dess_carte          (trac         : boolean);
   { dessine seulement le contour                                           }

Procedure recadrer_profils    (ech_1        : boolean);
   { recalculer les cltures en fonction de l'ch. cte. du profil sismique  }

Procedure recalc_profils      (ox, oy, ex, ey : real);
   { recalculer ( et redessiner) le ou les profils                          }

Procedure desactive_sismi;
   { dsactive les icnes aff/eff SISMI                                     }

Procedure marqueicones_affichages;
   { marquage de l'une des 3 icnes  aff/eff                                }

Procedure dess_pro_sis;

Procedure dess_pro_top;

Procedure dess_pro_gra;
   { dessine un seul profil                                                 }

Procedure redess_pro;
   { redessine le profil courant                                            }

Procedure dess_profil         (typ          : integer;
                               trac         : boolean);
   { profil courant ou tous, sur traceur ou non                             }

Procedure effsismi;

Procedure efftopo;

Procedure effgravi;

Procedure effpro              (choi         : integer);  { 1 ou tous }
   { 1 : efface le profil courant , 2 : efface tous                         }

Procedure enlev_pro;
   { efface tous les profils et rtablit vt la carte }

Procedure extrems;
   { choix des extrmits du segment  la souris                            }

Function  zoneinconnue                                          : boolean;
   { VRAI si mazg ou maxtopo  > v_indef                                     }

Function  tropcourt           (x1, x2, y1, y2     :  real)      : boolean;
   { VRAI si le profil ne dpasse pas le pas de la grille                   }

Procedure deplace_extrems     (xs, ys  : integer;
                               var x1, y1, x2, y2 : real);
   { dplace les extrmits  la souris                                     }

Procedure efface_profil       (choi               : integer);
   { Efface 1 = le profil courant ou 2= tous                                }

Procedure choix_action        (var choi           : integer);
   { choix action effacer= 1 / afficher= 2                                  }

Procedure choix_pro           (var choi           : integer);
   { choix profil en cours= 1 / tous= 2                                     }

Procedure inisis;
   { initialise les variables menu SEISMES                                  }

Procedure initop;
   { initialise les variables menu TOPO                                     }

Procedure inigra;
   { initialise les variables menu GRAVI                                    }

Procedure affval_extremites   (a, b, c, d, l  : real;
                               n              : integer);
   { affiche valeurs sur la deuxime ligne d'tat                           }

Procedure af_points;
   { dessine un point par mesure dans la clture courante                   }

Procedure aj_points           (trac           : boolean);
   { appelle af   aprs clture                                             }

Function zone_fenetre         (xs, ys         : integer)        : integer;
   { rend le numro de la fenetre dsigne                                  }

{Procedure Effacer_Commentaires;}
   { !! Efface toute la zone centrale puis raffiche la carte                  }

Procedure calcule_profil      (ox, oy, ex, ey : real);
   { calcule un des profils                                                 }

Procedure anomalie_gravi      (ox, oy, ex, ey : real);
   { enchane topo puis gravi                                               }

Procedure dessine_tout        (trac           : boolean);
   { dessine carte et profils existants                                     }

Procedure redess_tout;
   { R affiche tout l'cran aprs une inversion de couleurs                }

Procedure effacer_tout_redessiner;
   { Efface toute la zone centrale puis raffiche la carte                  }

Procedure CALCULER;
   { relance le calcul avec les paramtres courants                         }

{---------------------------------------------------------------------------}

IMPLEMENTATION

VAR
   coefc,                        { coef cloture }
   coefpro                       { coef profil  }
                     : real;

procedure af_fond;
   begin
      if topo
      then
         dess_fond  (nomffond+extblf, c_topo, coul_e, heti);
      if gravi
      then
         dess_fond  (nomffong+extblf, c_gravi, coul_e, heti);
   end;

procedure aj_fond  (trac : boolean);
   { }
   begin
      fenetrecloturecrantrac (trac);
      af_fond;
      pleinecrantrac (trac)
   end;

procedure choisir_params_p ;
   var
      touche, poscur : integer;
      r2             : real;
      z2             : PZoneReel;
      boite          : PBoiteSaisie;

   begin
      r2     := larg;

      z2     := new (PZoneReel,
                init (     0,      0,  5,  2,  txtmenu, fondmenu,  @larg,
                b_largeur, unitl));

      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,      fondnorm, txtnorm,
                t_projection));
      poscur := 1;
      boite^.ajoute (z2);
      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');
      dispose (z2, fini);
      dispose (boite, fini);

      if (touche = ESC)
      then begin
       {  modipro := false;}
         larg := r2;
      end;                                 { rtablir les valeurs initiales }

      if larg/degkm < lagrille.pasxgrille/2
      then
         larg := lagrille.pasxgrille/2*degkm;

      if larg/degkm > lagrille.pasxgrille*2
      then
         larg := lagrille.pasxgrille*2*degkm;
      modipro := larg <> r2;
   end;

procedure pas_mini;
   var
      diagonale  : real;

   begin
      diagonale :=
         sqrt (sqr (lagrille.pasxgrille)+sqr (lagrille.pasxgrille));

      if pas/ (degkm*degkm_r)  < diagonale
      then
         pas  := diagonale*degkm*degkm_r;

      if pas/ (degkm*degkm_r)  > lagrille.pasxgrille*3
      then
         pas  := lagrille.pasxgrille*3*degkm*degkm_r;

      pas := round (pas);
      dom := pas / 2;
   end;

procedure choisir_params_l ;
   var
      touche, poscur : integer;
      r1             : real;
      z1             : PZoneReel;
      boite          : PBoiteSaisie;

   begin
      r1     := pas;

      z1     := new (PZoneReel,
                init (     0,      0,  5,  2,  txtmenu, fondmenu,  @pas,
                b_pas, unitl));

      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,      fondnorm, txtnorm,
                t_lisse));
      poscur := 1;
      boite^.ajoute (z1);
      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      laide ('');
      dispose (z1, fini);
      dispose (boite, fini);

      if (touche = ESC)
      then begin
        { modipro := false;}
         pas  := r1;
      end;                                 { rtablir les valeurs initiales }
      pas_mini;
      modipro := pas <> r1;
   end;

procedure choix_4couleurs (comm : chainecar; var cc1, cc2, cc3, cc4 : byte);
   var
      touche, poscur    : integer;
      co1, co2,
      co3, co4          : byte;
      zc1, zc2,
      zc3, zc4          : Pzonecouleur;
      boite             : PBoiteSaisie;

   begin
      co1    := cc1;
      co2    := cc2;
      co3    := cc3;
      co4    := cc4;

      Zc1    := new (PZoneCouleur,
                     init (0,   0, @cc1, b_anomalie, '', pal));
      Zc2    := new (PZoneCouleur,
                     init (0,   0, @cc2, b_topob,    '', pal));
      Zc3    := new (PZoneCouleur,
                     init (0,   0, @cc3, b_foyers,   '', pal));
      Zc4    := new (PZoneCouleur,
                     init (0,   0, @cc4, b_eau,      '', pal));

      boite  := new (PBoiteSaisie,
                init (milieu, milieu, 15,   fondnorm, txtnorm, comm));
      { diter le tout }
      poscur := 1;
      boite^.ajoute (zc1);
      boite^.ajoute (zc2);
      boite^.ajoute (zc3);
      boite^.ajoute (zc4);

      laide (aidedit);
      boite^.editeF (1, Poscur, Touche);
      boite^.vider;
      dispose (boite, fini);
      laide ('');

      if (touche = ESC)
      then begin
         cc1     := co1;
         cc2     := co2;
         cc3     := co3;
         cc4     := co4;
      end;                                 { rtablir les valeurs initiales }
  end;

procedure fond_boite (c1, c2, c3, c4, coul : integer);
   begin
      if ecran
      then begin
         coulbar (solidfill, coul);
         bar (0, 0, c2-c1, c4-c3);
      end;
   end;

procedure ajoute_contours (trac, eff : boolean);
   { dessiner seulement les contours sans rgnrer toutes les courbes }
   begin
      fenetrecloturecrantrac (trac);
      fixetrait (traitcont);
      if eff
      then
         fixecoul (coulboite)
      else
         fixecoul (c_carte);

      dess_contour ;

      fixetrait (0);
      pleinecrantrac (trac);
   end;

procedure ajoute_grille (trac, eff : boolean);
   var
      ixy            : real;
      nbdec          : integer;

   begin
      if gradauto
      then
         ixy   := 0
      else
         ixy   := inter_xy;
      fenetrecloturecrantrac (trac);
      fixetrait (traitgrille);
      if eff
      then
         fixecoul (coulboite)
      else
         fixecoul (c_grille);
      fixetrait      (traitgrille);
      dessine_lignes (ixy, ixy);
      fixetrait (0);
      pleinecrantrac  (trac);
   end;

procedure d_sismi (c1, c2, c3, c4 : integer);
   var
      minz, maxz        : real;

   begin
      if maxsismi < 10  then maxsismi :=  10;
      if minsismi >-10  then minsismi := -10;
      maxz := maxsismi + (maxsismi-minsismi) / 10;
      minz := minsismi - (maxsismi-minsismi) / 10;
      fenetre (-longpro/10, longpro, minz, maxz);
      cloture (c1,          c2,      c3,   c4);
      fond_boite (c1, c2, c3, c4, c_fpro );
      bordure (c_grille);
      axes;
      fixecoul  (c_grille);
      if legend
      then
         gradueplt (0, 0, 4, 3, 0, 3, 0, 'A -> B', titrz1, titrp1, 2, 3, 3, 2, 2)
      else
         gradue    (0, 0);
      visu_p3  (pro_sis, nbpts_s, c_sismi);
      visu1 := true;
      pleinecloture;
   end;

procedure d_topo (c1, c2, c3, c4 : integer);
   var
      minz, maxz        : real;

   begin
      if maxtopo > lagrille.maxzg
      then
         maxtopo := lagrille.maxzg;

      if mintopo < lagrille.minzg
      then
         mintopo := lagrille.minzg;

      if maxtopo  < 1
      then
         maxtopo  := 1;
      maxz := maxtopo + (maxtopo-mintopo) / 10;
      minz := mintopo - (maxtopo-mintopo) / 10;
      fenetre (-longpro/10, longpro, minz, maxz);
      cloture (c1, c2,     c3,      c4);
      fond_boite (c1, c2, c3, c4, c_fpro);
      bordure (c_grille);
      axes;
      fixecoul  (c_grille);

      if legend
      then
         gradueplt (0, 0, 4, 3, 0, 3, 0, unitl, titrz2, titrp2, 2, 3, 3, 1, 2)
      else
         gradue    (0, 0);

      if compare
      then begin
         visu_l3    (pro_c1, nbst, c_topo);
         visu_corps (poly, nbcorps, c_corps);
         visu_l2  (pro_l1, nbpts_t, c_topo);
      end else
         if reduc
         then begin
            visu_l3    (pro_c1, nbst, c_topo);
            visu_corps (poly, nbcorps, c_corps);
         end else
            visu_l2  (pro_l1, nbpts_t, c_topo);
      visu2 := true;
      pleinecloture;
   end;

procedure d_gravi (c1, c2, c3, c4 : integer);
   var
      minz, maxz        : real;

   begin
      if maxg > lagrill2.maxzg
      then
         maxg := lagrill2.maxzg;
      if ming < lagrill2.minzg
      then
         ming := lagrill2.minzg;
      if maxg < 10 then maxg     :=  10;
      if ming > 10 then ming     := -10;
      maxz := maxg + (maxg-ming) / 10;
      minz := ming - (maxg-ming) / 10;
      fenetre  (-longpro/10, longpro, minz, maxz);       { dessin gravi       }
      cloture    (c1, c2, c3, c4 );
      fond_boite (c1, c2, c3, c4, c_fpro);
      bordure  (c_grille);
      axes;
      fixecoul (c_grille);

      if legend
      then
         gradueplt (0, 0, 4, 3, 0, 3, 0, unitl, titrz3, titrp3, 0, 3, 3, 2, 2)
      else
         gradue    (0, 0);

      if compare
      then begin
         visu_l3  (pro_c2, nbst, c_gravi);            { profil rduit }
         visu_l2  (pro_l2, nbpts_g, c_gravi) ;       { profil brut   }
      end else
         if reduc
         then begin
            visu_l3  (pro_c2, nbst, c_gravi);            { profil rduit }
         end else
            visu_l2  (pro_l2, nbpts_g, c_gravi) ;       { profil brut   }

      visu3 := true;
      pleinecloture;
   end;

function visupro : boolean;
   begin
      visupro := (visu1 or visu2 or visu3);              { un au moins...  }
   end;

procedure fenetrecloturecarte;
   begin
      fenetre (fc1, fc2, fc3, fc4);
      cloture (cc1, cc2, cc3, cc4);
   end;

procedure EffacerCoordonnees1;
   begin
      PleineCloture;
      LEtat2 ('',  0, 9, c_fpro,
                         c_trace);
      LEtat2 ('', 10, 9, c_fpro,
                         c_trace);
      Cloture (cc1, cc2, cc3, cc4);
   end;

procedure AfficherCoordonnees1 (a, b : real);
   begin
      PleineCloture;
      str (a:6:2, chain);
      letat2 ('xA : '+chain,  0, 9, c_fpro,
                                    c_trace);
      str (b:6:2, chain);
      letat2 ('yA : '+chain, 10, 9, c_fpro,
                                    c_trace);
      Cloture (cc1, cc2, cc3, cc4);
   end;

procedure EffacerCoordonnees2;
   begin
      PleineCloture;
      LEtat2 ('', 20, 9, c_fpro, c_trace);
      LEtat2 ('', 30, 9, c_fpro, c_trace);
      Cloture (cc1, cc2, cc3, cc4);
   end;

procedure AfficherCoordonnees2 (a, b : real);
   begin
      PleineCloture;
      str (a:6:2, chain);
      letat2 ('xB : '+chain, 20, 9, c_fpro,
                                    c_trace);
      str (b:6:2, chain);
      letat2 ('yB : '+chain, 30, 9, c_fpro,
                                    c_trace);
      Cloture (cc1, cc2, cc3, cc4);
   end;

procedure affval_extremites (a, b, c, d, l : real; n : integer);
   begin
      setusercharsize (1, 1, 1, 1);
      AfficherCoordonnees1 (a, b );
      AfficherCoordonnees2 (c, d );
      pleinecloture;
      str (l:8:2, chain);
      letat2 ('L = '+chain+' '+unitl , 40, 10, c_fpro, c_trace);
      str (n:2  , chain);
      letat2 (chain+' '+n_points , 51,  9, c_fpro,   c_trace);
      setusercharsize (3, 2, 3, 2);
   end;

procedure desactive_sismi;
   begin
      inactive_icone (7);
      inactive_icone (10);
      inactive_icone (11);
      inactive_icone (12);
  end;

procedure marqueicones_affichages;
   begin
      if gra   then active_icone   (5);
      if top   then active_icone   (6);
      if sis   then active_icone   (7);
      if visu3 then marquericone   (5, c_gravi)
               else demarquericone (5);
      if visu2 then marquericone   (6, c_topo)
               else demarquericone (6);
      if visu1 then marquericone   (7, c_sismi)
               else demarquericone (7);
      if gra   then bordericone    (5, c_gravi);
      if top   then bordericone    (6, c_topo);
      if sis   then bordericone    (7, c_sismi);
   end;

procedure demarquertout;
   begin
      demarquericone  (8);
      demarquericone  (9);
      demarquericone (10);
   end;

procedure inigra;
   begin
      active (2,  3, true);
      active (2,  4, false);
      active (2,  5, true);
      c_coup  :=  c_gravi;
      demarquericone  (9);
      demarquericone (10);
      marquericone    (8, c_gravi);
   end;

procedure initop;
   begin
      active (2,  3, true);
      active (2,  4, false);
      c_coup  :=  c_topo;
      demarquericone  (8);
      demarquericone (10);
      marquericone    (9, c_topo);
   end;

procedure inisis;
   begin
      active (2,  3, true);            { extrmits }
      active (2,  4, true);            { largeur }
      c_coup  :=  c_sismi;
      demarquericone  (8);
      demarquericone  (9);
      marquericone   (10, c_sismi);
   end;

procedure choix_pro   (var choi : integer);
  begin
      choi := 1;
      creeliste (c_profil, 1);
      creeliste (c_tous,    2);
      liste     (l_pro1, l_pro2, l_pro3, 18, chain, choi);
  end;

procedure choix_action (var choi : integer);
  begin
      choi := 1;
      creeliste (n_effacer,    1);
      creeliste (n_afficher,   2);
      liste     (' ', l_Action, '', 18, chain, choi);
  end;

procedure recalc_ecran;
   begin
      if (coef_x <> 1)
      then begin
         maxc1   := round (maxc1   * coef_x);
         maxc2   := round (maxc2   * coef_x);
         cc1     := round (cc1     * coef_x);
         cc2     := round (cc2     * coef_x);
         cp1     := round (cp1     * coef_x);      { profil sismi }
         cp2     := round (cp2     * coef_x);
         ct1     := round (ct1     * coef_x);      {        topo  }
         ct2     := round (ct2     * coef_x);
         cg1     := round (cg1     * coef_x);      {        gravi }
         cg2     := round (cg2     * coef_x);
      end;

      if (coef_y <> 1)
      then begin
         maxc3   := round (maxc3   * coef_y);
         maxc4   := round (maxc4   * coef_y);
         cc3     := round (cc3     * coef_y);
         cc4     := round (cc4     * coef_y);
         cp3     := round (cp3     * coef_y);
         cp4     := round (cp4     * coef_y);
         ct3     := round (ct3     * coef_y);
         ct4     := round (ct4     * coef_y);
         cg3     := round (cg3     * coef_y);
         cg4     := round (cg4     * coef_y);
      end;
      coef_c := (cc2-cc1) / (cc4-cc3);
   end;

procedure cadrer;
   { SI cc2<= cc1 ou cc4<=cc3 ou hors limites...
     calcule cc2 et cc4 en fonction
         de la position du coin bas-gauche ( cc1, cc3 dans .PAR)
         et de l'extension maxi clture (maxC2, maxC4 dans .CFG)            }
   var
      coeff, coefc      : real;

   begin
      if cc1 < maxc1 then cc1 := maxc1;
      if cc2 > maxc2 then cc2 := maxc2;
      if cc3 < maxc3 then cc3 := maxc3;
      if cc4 > maxc4 then cc4 := maxc4;

      if (cc2 <= cc1) or (cc4 <= cc3)
      then begin
         coeff := (cor2   - cor1) / (cor4   - cor3) * (coef_x / coef_y);
         coefc := (maxc2  - cc1 ) / (maxc4  - cc3);
         if (coeff > coefc)
         then begin
            cc2 := maxc2;
            cc4 := cc3 + round ((maxc2-cc1) / coeff)
         end else begin
            cc4 := maxc4;
            cc2 := cc1 + round ((maxc4-cc3) * coeff)
         end;
      end;
   end;

procedure recadrer_profils (ech_1 : boolean);
   var
      coeff, coefc      : real;
      lpro              : integer;

   begin
      if ech_1
      then begin
         coeff := (longpro + longpro/10)
                  / (abs (maxsismi - minsismi) * (coef_x / coef_y) );
         coefc := (cp2 - cp1) / (cp4 - cp3);
         if (coeff > coefc)
         then begin                 { diminuer en hauteur }
            cp2  := cpi2;
            cp3  := cpi4 - round ((cpi2-cpi1) / coeff)
         end else begin             { diminuer en largeur }
            cp3  := cpi3;
            lpro := round ((cpi4-cpi3) * coeff) ;
            cp2  := cpi1 + lpro;
            ct2  := cti1 + lpro;
            cg2  := cgi1 + lpro;
         end;
      end else begin                { rtablir valeurs initiales }
         cp2 := cpi2;
         cp3 := cpi3;
         ct2 := cti2;
         cg2 := cgi2;
      end;
   end;

procedure libere_mem;
   begin
      lagrille.liberer;
      lagrill2.liberer;
      liberercontour;
      liberer_jeu_symb (1);
{      liberer_jeu_symb (2);}
      liberer_jeu_symb (3);
      liberericones;
      params.fini;
      parini.fini;
      liberer_commentaires;
      liberer_noms;
   end;

procedure finir;
   begin
      restorecrtmode;
      ecrantexte;
      libere_mem;
   end;

procedure effcart;
  begin
      coulbar (SolidFill, coulecran);
      bar (cc1, maxy-cc4, cc2, maxy-cc3);     { couleur fond cran }
   end;

procedure dessine_suite;
   { axes, bordure, lignes de rappel et graduation interne complte }
   {                VISULIGNES          LEGEND                      }

   const
      tiret             = 4;
      posx              = 1;
      posy              = 1;
      post              = 4;
      extx              = 1;
      exty              = 1;

   var
      ixy               : real;
      nbdec             : integer;

   begin
      if gradauto
      then begin
         ixy   := 0;
         nbdec := nbdec_xy;
      end else begin
         ixy   := inter_xy;
         nbdec := nbdec_xy;
      end;
      fixetrait (0);
      fixecoul  (c_bord);

      axes;
      bordure   (c_bord);

      if legend
      then
         gradueplt (ixy, ixy, tiret,
                    0, nbdec, 0, nbdec,
                    unitxy,  unitxy, '',
                    posx,   posy,  post,
                    extx,   exty )
      else
         gradue    (ixy, ixy);

      if visusymb
      then
         af_points  ;
   end;

procedure modi_aff_carte;
   begin
      ecran   := true;
      traceur := false;
      boite_graph_variable (titre,
                  false,                            { fermeture active  }
                  true,                             { cloture variable  }
                  true,                             { asc. vertical     }
                  true,                             { asc. horizontal   }
                  true,                             { bote mobile      }
                  false,                            { proportions fixes }
                  0.03,                             { rapport zoom      }
                  cor1, cor2, cor3, cor4,           { fentre maxgrille }
                  maxc1, maxc2, maxc3, maxc4,       { max clture       }
                  fc1,  fc2 , fc3,  fc4,            { fentre cte       }
                  cc1,  cc2,  cc3,  cc4,            { clture cte       }
                  coulboite,                        { couleur du fond   }
                  c_carte,                          { couleur du trait  }
                  dess_contour,                     { procedure dessin  }
                  ok);
      if not ok
      then message (M_not_memoire);
   end;

{$F+}
procedure dess_pro;
   { pour multifentres }
   begin
      dess_profil (1, false);
   end;
{$F-}

procedure modi_aff_coupe (f3, f4 : real; t : chainecar;
                          var c1, c2, c3, c4 : integer ; var ech : real);
   var
      f1 , f2           : real;

   begin
      f1 := 0;
      f2 := longpro;
      ecran   := true;
      traceur := false;
      boite_graph_variable
                 (t,                                { titre }
                  false,                            { fermeture active   }
                  true,                             { cloture variable   }
                  false,                            { asc. vertical      }
                  false,                            { asc. horizontal    }
                  true,                             { bote mobile       }
                  true,                             { proportions var.   }
                  0,                                { rapport zoom       }
                  f1, f2, f3, f4,                   { fentre maxgprofil }
                  maxc1, maxc2, maxc3, maxc4,       { max clture        }
                  f1, f2, f3, f4,                   { fentre cte        }
                  c1, c2, c3, c4,                   { clture cte        }
                  c_fpro,                           { couleur du fond    }
                  c_sismi,                          { couleur du trait   }
                  dess_pro,                         { procedure dessin   }
                  ok);
      if not ok
      then message (m_not_memoire);

      ech := (c4-c3) / (c2-c1) * longpro / abs (f4-f3);
             { l     / L       *  coefpro }
             { echelle relative des hauteurs / longueurs }
   end;

procedure ini_par_ecr;
   begin
      maxc1 := 1;           { extension maxi clture }
      maxc2 := posxbtn - 2 ;
      maxc3 := 3 * ty + 2* dd0 ; {place pour affichages coordonnes profil }
      maxc4 := maxy - hauteurmenu - ty div 3;
      (*maxc4 := maxy-24-1; { 2 * ty police normale pour caser la barre titre }*)
   end;

procedure recalc_profils (ox, oy, ex, ey : real);
   { Regnre les tableaux prcdents
          sans relire les fichiers dj contitus }
   var
      coefcp1, coefcp2, coefcp3 : real;

   begin
      laide (la_Calcul);
      MontrerSouris;
      ChangerCurseur (Sablier);
      fenetrecloturecarte;

      if sis and (nomfd3 <> '')
      then
         coupe_sismi (ox, oy, ex, ey);
      if top
      then begin
         coupe_topo  (ox, oy, ex, ey);
         coupe_corps (nbst, nbcorps );
      end;
      if gra
      then
         coupe_gravi (ox, oy, ex, ey);

      pleinecloture;
      cachersouris;
      ChangerCurseur (Fleche);
      laide ('');
   end;

procedure dess_pro_gra;
   begin
      ecran   := true;
      traceur := false;
      pleinecloture;

      d_gravi (cg1, cg2, cg3, cg4);
      visucontours := false;
      pleinecloture;
   end;

procedure dess_pro_top;
   begin
      ecran   := true;
      traceur := false;
      pleinecloture;

      d_topo  (ct1, ct2, ct3, ct4);
      visucontours := false;
      pleinecloture;
   end;

procedure dess_pro_sis;
   begin
      ecran   := true;
      traceur := false;
      pleinecloture;

      d_sismi (cp1, cp2, cp3, cp4);
      visucontours := false;
      pleinecloture;
   end;

procedure redess_pro;
   begin
      if visu1
      then
         dess_pro_sis;

      if visu2
      then
         dess_pro_top;

      if visu3
      then
         dess_pro_gra;
   end;

procedure cadrer_profils;
   var
      hpro, ipro, lpro  : integer;

   begin
      hpro := trunc ((maxc4-maxc3) /4);
      ipro := hpro div 2;

      if cp1 < maxc1 then cp1 := maxc1;
      if cp2 > maxc2 then cp2 := maxc2;
      if cp3 < maxc3 then cp3 := maxc3;
      if cp4 > maxc4 then cp4 := maxc4;

      if ct1 < maxc1 then ct1 := maxc1;
      if ct2 > maxc2 then ct2 := maxc2;
      if ct3 < maxc3 then ct3 := maxc3;
      if ct4 > maxc4 then ct4 := maxc4;

      if cg1 < maxc1 then cg1 := maxc1;
      if cg2 > maxc2 then cg2 := maxc2;
      if cg3 < maxc3 then cg3 := maxc3;
      if cg4 > maxc4 then cg4 := maxc4;

      if (cp1 >= cp2) or (cp3 >= cp4)
      then begin
         cp1 := maxc1;
         cp2 := maxc2;
         cp3 := maxc3;
         cp4 := maxc3 + hpro;
      end;
      cpi1 := cp1;
      cpi2 := cp2;
      cpi3 := cp3;
      cpi4 := cp4;
      lpro := cp2-cp1;

      if (ct1 >= ct2) or (ct3 >= ct4)
      then begin
         cti1 := maxc1;
         cti2 := cti2 + lpro;
         cti3 := cpi4 + ipro;
         cti4 := cti3 + hpro;
      end;
      cti1 := ct1;
      cti2 := ct2;
      cti3 := ct3;
      cti4 := ct4;

      if (cg1>=cg2) or (cg3>=cg4)
      then begin
         cgi1 := maxc1;
         cgi2 := cgi2 + lpro;
         cgi3 := cti4 + ipro;
         cgi4 := cgi3 + hpro;
      end;
      cgi1 := cg1;
      cgi2 := cg2;
      cgi3 := cg3;
      cgi4 := cg4;
   end;

procedure iniprofil;
   begin
      if nomfd3 = ''
      then begin
         sis      := false;
         sismi    := false;
         echelle1 := false;
      end;

      dom     := pas / 2 ;
      if unite = u_angle
      then
         coefx := degkm*degkm_r    { pour calc. distances }
      else
         if unite = 'km'
         then
            coefx := 1/(degkm*degkm_r)
         else
            coefx := 1;

      pas_mini;

      cadrer_profils;
      recadrer_profils (echelle1);

      if not sismi and not topo and not gravi
      then
         topo := true;

      if sis or top or gra
      then begin
         visucontours := false;
         recalc_profils (x1, y1, x2, y2);
      end;
      modipro      := false   ;
      modipar      := false   ;     { modif en cours params           }
    {  visu1 := sis;
      visu2 := top;
      visu3 := gra;}
   end;

procedure ini_extrems;
   begin
      if not (sis or top or gra)
      then begin
         message (m_definir_profil);
         extrems;
         modipar := true {modipar or modipro};
         affval_extremites (x1, y1, x2, y2, longpro, nbst);
         calculer;
      end;
   end;

procedure def_icones;
   var
      px, py            : integer;

   begin
      px  := posxbtn;
      py  := maxy - (30 + ty);
      bouton_icone (aidico1,   1, px,     py,    96, 30);

      bouton_icone (aidico2,   2, px+94,  py-2,   2,  2);

      bouton_icone (aidico3,   3, px,     py-53, 96, 50);
      active_icone            (3);

      py :=  hauteurmenu+6;
      bouton_icone (aidico4,   4, px,     py,    96, 30);

      py := py + 39;
      bouton_icone (aidico5,   5, px,     py,    30, 30);
      bouton_icone (aidico8,   8, px+36,  py,    60, 30);

      py := py + 36;
      bouton_icone (aidico6,   6, px,     py,    30, 30);
      bouton_icone (aidico9,   9, px+36,  py,    60, 30);
      py := py + 36;
      bouton_icone (aidico7,   7, px,     py,    30, 30);
      bouton_icone (aidico10, 10, px+36,  py,    60, 30);

      py := py + 48;
      px := px + 15;
      bouton_icone (aidico11, 11, px,     py,    30, 30);
      bouton_icone (aidico12, 12, px+36,  py,    30, 30);

      py := py + 36;
      bouton_icone (aidico13, 13, px,     py,    30, 30);
      bouton_icone (aidico14, 14, px+36,  py,    30, 30);

      py := py + 36;
      bouton_icone (aidico15, 15, px,     py,    30, 30);
      bouton_icone (aidico16, 16, px+36,  py,    30, 30);

      py := py + 36;
      bouton_icone (aidico17, 17, px,     py,    30, 30);
      bouton_icone (aidico18, 18, px+36,  py,    30, 30);
      icone_etat;
   end;

procedure dess_icones;
   var
      i                 : integer;

   begin
      for i := 1 to 18
      do
         Active_dess_icone (i);
   end;

procedure iniecran;
   begin
      cadrer;                         { calculer valeurs maxi cltures     }
      recalc_ecran;                   { recalculer les cltures /coef_y    }
      iniprofil;
   end;

procedure InifondEcran;
   begin
      ini_par_ecr;                    { dfinir plage centrale maxi        }
      ini_format (formatpapier) ;     { paramtres papier et traceur       }
      inicoul_cfg;                    { couleurs configuration             }
      fond_ecran  (coulecran);
      affichemenu;
      dess_icones;
      ini_titre;
   end;

procedure eff_trace;
   begin
      fixecoul   (coulboite);
      deplaceenl (x1, y1);
      if dans_fenetre (x1, y1)
      then
         ttexte     ('A', 2, 1);
      deplaceenl (x1, y1);
      tracevers  (x2, y2);
      if dans_fenetre (x2, y2)
      then
         ttexte     ('B', 0, 1);
   end;

procedure eff_trait;
   begin
      fixecoul   (coulboite);
      deplaceenl (x1, y1);
      tracevers  (x2, y2);
   end;

procedure dess_trace ;
   begin
      fixecoul   (c_trace);
      deplaceenl (x1, y1);
      ttexte     ('A', 2, 1);
      deplaceenl (x1, y1);
      tracevers  (x2, y2);
      ttexte     ('B', 0, 1);
   end;

procedure dess_carte (trac : boolean);
   begin
      fenetrecloturecrantrac (trac);

      fond_boite (cc1, cc2, cc3, cc4, coulboite);

      { autre ... }
      dess_trace;

      fixecoul  (c_carte);
      dess_contour;
      visucontours := true;
      dessine_suite;
      fixetrait (0);
      pleinecrantrac (trac);
   end;

procedure recalc_p3p4 (p1, p2 : integer ; var p3, p4 : integer);
   begin
      p3 := p4 - round (((p2 - p1) / coefpro ) );
      p4 := cpi4;
   end;

procedure recalc_p1p2 (var p1, p2 : integer; p3, p4 : integer);
   begin
      p1 := cpi1;
      p2 := round ((p1 + (p4 - p3) * coefpro ) );
   end;

procedure effzone (c1, c2, c3, c4 : integer);
   begin
      coulbar (SolidFill, coulecran);
      bar (c1, maxy-c4, c2, maxy-c3);     { couleur fond cran }
   end;

procedure effgravi;
   begin
      effzone (cg1, cg2, cg3, cg4);
      visu3 := false;
   end;

procedure efftopo;
   begin
      effzone (ct1, ct2, ct3, ct4);
      visu2 := false;
   end;

procedure effsismi;
   begin
      effzone (cp1, cp2, cp3, cp4);
      visu1 := false;
   end;

procedure effpro (choi : integer);  { 1 ou tous }
   begin
      case choi of
      1 : begin   { effacer le profil courant }
             if sismi then effsismi;
             if topo  then efftopo;
             if gravi then effgravi;
          end;

      2 : begin
             effsismi;
             efftopo;
             effgravi;
          end;
      end;
   end;

procedure redess_carte (trac : boolean);
   begin
      if visucarte
      then begin
         dess_carte (false);
         if visutoponym
         then
            dessiner_noms         (trac, true, false);
       end;
   end;

procedure enlev_pro;
   begin
      if visupro
      then begin
         effpro (2);
         redess_carte (false);
      end;
   end;

procedure efface_profil (choi : integer);  { 1  en cours, 2 tous }
   begin
      if visucontours           { carte au premier plan }
      then begin
         effpro (2) ;           { tous...}
         redess_carte (false)
      end else begin
         effpro (choi);         { efface le profil courant }
         redess_carte (false);
         redess_pro;            { redessiner les autres }
      end;
   end;

procedure dess_profil (typ : integer; trac : boolean);
   { dessine profils dans cltures courantes }

   begin
      if (sismi and (nbpts_s >= nbmaxstations) )
      then begin
         pleinecloture;
         message (m_reduire_larg);
      end;

      if trac
      then begin
         ini_traceur;
         ecran   := false;
      end else begin
         ecran   := true;
         traceur := false
      end;
      case typ of
         1 : begin
                if sismi and sis
                then                                     { sismes seuls   }
                   d_sismi  (cp1, cp2, cp3, cp4);

                if topo and top
                then                                     { topo seule      }
                   d_topo   (ct1, ct2, ct3, ct4);

                if gravi and gra
                then                                     { GRAVI seule     }
                   d_gravi  (cg1, cg2, cg3, cg4);
                visucontours := false;              { carte au  2ime plan }
             end;
         2 : begin
    	          if sis then  d_sismi (cp1, cp2, cp3, cp4);   { sismes,    }
	             if top then  d_topo  (ct1, ct2, ct3, ct4);   { topo        }
	             if gra then  d_gravi (cg1, cg2, cg3, cg4);   { et gravi    }
                visucontours := false;              { carte au  2ime plan }
             end;
      end;

      pleinecloture;
      { if traceur then
         trace_param (cp1, cp2, cp3, cp4);}
      if trac
      then begin
         libere_traceur;
         ecran := true
      end
   end;

procedure efface_carte;
   begin
      if ecran
      then begin
         effcart;
         if visupro
         then begin
            effpro (2);
            dess_profil (1, false)
         end ;
         visucontours := false;   { carte au  2ime plan }
      end;
   end;

procedure efftout;
   begin
      ecran := true;

      if visucarte
      then begin
         effcart;
         visucarte := false
      end;

      if visupro
      then
         effpro (2);

      demarquertout;

      liberer_commentaires;
      liberer_noms;
      lagrille.liberer;
      lagrill2.liberer;
      liberercontour;
      params.fini;
   end;

procedure ChangeRepere  (xt, yt           : integer;
                         var xc, yc       : real);
   begin
      Xc := XUtilisateur (xt);
      Yc := YUtilisateur (yt);
   end;

procedure AfficherMire (x, y : real);
   var
      xx, yy            : integer;

   begin
      SetColor (2 Xor CoulBoite);
      SetWriteMode (XOrPut);
      xx := XCloture (x);
      yy := YCloture (y);
      line (0, yy, cc2-cc1, yy);
      line (xx, 0, xx, cc4-cc3);
      SetWriteMode (NormalPut);
   end;

procedure EffacerMire (x, y : real);
   begin
      AfficherMire (x, y);
   end;

procedure LimiterXY (var x, y : real);
   begin
      if x < fc1
         then x := fc1
         else
            if x > fc2 then x := fc2;
      if y < fc3
         then y := fc3
         else
            if y > fc4 then y := fc4;
   end;

procedure def_profil (var xi, yi, xf, yf     : real);
   var
      x0, y0            : real;
      xs, ys            : integer;

      x2, y2,
      x,  y             : real;

      Ajoute, fin, ok   : boolean;

   begin
      Repeat until not UnBoutonSourisEnfonce;

      { PREMIER POINT }
      setusercharsize (1, 1, 1, 1);
      LirePositionSouris (xs, ys);
      ChangeRepere (xs, ys, x2, y2);
      AfficherMire (x2, y2);
      Repeat
         LirePositionSouris (xs, ys);
         ChangeRepere (xs, ys, x, y);
         LimiterXY    (x, y);
         AfficherCoordonnees1 (x, y);
         EffacerMire  (x2, y2);
         AfficherMire (x, y);
         x2 := x;
         y2 := y;
         if ToucheClavier (CodeClavier)
         then
            if CodeClavier = ESC
            then begin
               EffacerMire (x, y);
               EffacerCoordonnees1;
               exit
            end;
      until UnBoutonSourisEnfonce;
      EffacerMire (x2, y2);
      x0 := x;
      y0 := y;  { premier point }

      fixecoul   (c_trace);
      deplaceen  (x, y);
      setusercharsize (3, 2, 3, 2);
      ttexte     ('A', 2, 1);

      {* POUR LES AUTRES POINTS, REPETER }
      setusercharsize (1, 1, 1, 1);
      repeat until not UnBoutonSourisEnfonce;
      { Tracer le segment avec le dplacement de la souris }
      ok := false;
      Repeat
         LirePositionSouris (xs, ys);
         ChangeRepere (xs, ys, x, y);
         LimiterXY (x, y);
         {* AFFICHER MIRE, SEGMENT ET COORDONNEES }
         AfficherCoordonnees2 (x, y);
         AfficherMire (x, y);
         SetWriteMode (XOrPut);
         DeplaceEn (x0, y0);    { affiche }
         TraceVers (x,  y);
         SetWriteMode (NormalPut);
         ok := UnBoutonSourisEnfonce and
               ((xs <> 0) or (ys <> 0)) and
                ((x <> x0) and (y <> y0));
         {* EFFACER SEGMENT ET MIRE }
         x2 := x;
         y2 := y;
         SetWriteMode (XOrPut);
         DeplaceEn (x0, y0);
         TraceVers (x,  y);   { efface  }
         SetWriteMode (NormalPut);
         EffacerMire (x, y);
      until ok;
      xi := x0;
      xf := x2;
      yi := y0;
      yf := y2;
      deplaceen  (x2, y2);
      setusercharsize (3, 2, 3, 2);
      ttexte     ('B', 0, 1);
   end;

procedure extrems;
   var
      xx1, xx2,
      yy1, yy2          : integer;

   begin
      xx1 := 0;
      xx2 := 0;
      yy1 := 0;
      yy2 := 0;
      fenetre (fc1, fc2, fc3, fc4);
      cloture (cc1, cc2, cc3, cc4);
      eff_trace;
      def_profil (x1, y1, x2, y2 );
      modipro := true;
      dess_trace;
      pleinecloture;
   end;

function zoneinconnue : boolean;
   begin
       zoneinconnue := ((maxg >= v_indef) or (maxtopo >= v_indef))
   end;

function tropcourt (x1, x2, y1, y2 :  real) : boolean;
   begin
      tropcourt :=     (abs (x2-x1) < 2* lagrille.pasxgrille)
                   and (abs (y2-y1) < 2* lagrille.pasygrille)
   end;

function poignee (xs, ys : integer; x, y : real) : boolean;
   var
      dxy, xd, yd       : real;

   begin
      dxy := lagrille.pasxgrille;
      xd  := xutilisateur (xs);
      yd  := yutilisateur (ys);
      poignee :=      (xd > x - dxy) and (xd < x + dxy)
                  and (yd > y - dxy) and (yd < y + dxy);
   end;

procedure deplace_extrems (xs, ys : integer; var x1, y1, x2, y2 : real) ;
   procedure dep_extrems (x0, y0 : real; var xp, yp : real);
      var
         xx1, xx2,
         yy1, yy2    : integer;

      begin
         xx1 := xcloture (x0);
         yy1 := ycloture (y0);
         xx2 := xcloture (xp);
         yy2 := ycloture (yp);
         def_zone (3, c_trace, 0,
                   0 {cc1}, 0{maxy-cc4}, cc2-cc1, cc4-cc3{maxy-cc3},
                   xx1, yy1,      xx2, yy2);
         xp := xutilisateur (xx2+cc1);
         yp := yutilisateur (yy2+maxy-cc4);
      end;

   begin
      fenetre (fc1, fc2, fc3, fc4);
      cloture (cc1, cc2, cc3, cc4);

      if poignee (xs, ys, x1, y1)      { dpl ORIGINE }
      then begin
         eff_trace;
         repeat
            dep_extrems (x2, y2, x1, y1);
         until (x1<>x2) and (y1<>y2);
         dess_trace;
      end;

      if poignee (xs, ys, x2, y2)      { dpl EXTREMITE }
      then begin
         eff_trace;
         repeat
            dep_extrems (x1, y1, x2, y2);
         until (x1<>x2) and (y1<>y2);
         dess_trace;
      end;

      pleinecloture;
   end;

procedure dess_points (lagrille : Tgrille;
                       min, max : real; co : word);
   var
      t, i, j           : integer;
      x, y, c, d,
      val               : real;
      stop              : boolean;

   begin
{      if (lagrille = nil) then exit;}
      fixecoul (co);
      val  := min;
      t    := 0;
      stop := false;
      for i := 1 to lagrille.nblig
      do begin
         for j := 1 to lagrille.nbcog
         do begin
            val := lagrille.valeur (j, i);
            x   := lagrille.absx   (j)   ;
            y   := lagrille.ordy      (i);
            if (val >= min) and (val < max)
            then
               deplaceen (x, y);
         end;
         stop := toucheclavier (t);
         stop := (t = ESC) ;
         if stop
         then
            exit;
      end;
   end;

procedure dess_foyers (nmf : Pathstr ; num : integer;
                       min, max : real ; co : word);
   var
      x, y, c, d,
      val               : real;
      fentree           : text;
      t                 : integer;
      stop              : boolean;

   begin
      if not ftxt_present (nmf)
      then
         exit;
      assign (fentree, nmf);
      reset  (fentree);
      fixecoul (co);
      t := 0;
      stop := false;
      while (not (eof (fentree))) and not stop
      do begin
         readln (fentree, x, y, c, d);
         if num = 3
         then
            val := c
         else
            if num = 4
         then
            val := d;
         if (val >= min) and (val < max)
         then
            deplaceen (x, y);
         stop := toucheclavier (t);
         stop := (t = ESC) ;
      end;
      close (fentree);
   end;

procedure af_points;
   begin
      if visucontours
      then begin
         if sismi
         then
            dess_foyers
                (chemindonnees+nomfd3+extsis, 3, -1000,  1000, c_sismi);
         if visufond
         then
            af_fond;
{         if topo
         then
            dess_points (lagrille,               -10000, 10000, c_topo);
         if gravi
         then
            dess_points (lagrill2,                -1000,  1000, c_gravi);}
      end;
   end;

procedure aj_points (trac : boolean);
   begin
      fenetrecloturecrantrac (trac);
      af_points;
      pleinecrantrac (trac)
   end;

function dans_z0 (xs, ys : integer) : boolean;
   begin
      dans_z0 := visucarte
                 and ((xs > cc1)      and (xs < cc2)
                 and  (ys < maxy-cc3) and (ys > maxy-cc4))
   end;

function dans_z1 (xs, ys : integer) : boolean;
   begin
      dans_z1 := visu1
                 and ((xs > cp1)      and (xs < cp2)
                 and  (ys < maxy-cp3) and (ys > maxy-cp4))
   end;

function dans_z2 (xs, ys : integer) : boolean;
   begin
      dans_z2 := visu2
                 and ((xs > ct1)      and (xs < ct2)
                 and  (ys < maxy-ct3) and (ys > maxy-ct4))
   end;

function dans_z3 (xs, ys : integer) : boolean;
   begin
      dans_z3 := visu3
                 and ((xs > cg1)      and (xs < cg2)
                 and  (ys < maxy-cg3) and (ys > maxy-cg4))
   end;

function zone_fenetre (xs, ys : integer) : integer;
   { carte = 0; pr1 = 1; pr2 = 2; pr3 = 3 }
   var
      z0, z1, z2, z3,
      f0, f1, f2, f3    : boolean;

   begin
      z0 := dans_z0 (xs, ys);
      z1 := dans_z1 (xs, ys);
      z2 := dans_z2 (xs, ys);
      z3 := dans_z3 (xs, ys);

      f0 := (visucontours and dans_z0 (xs, ys)) or
            dans_z0 (xs, ys) and
            not (dans_z1 (xs, ys) or dans_z2 (xs, ys) or dans_z3 (xs, ys));
      if f0
      then
         zone_fenetre := 0
      else begin
         f1 := (visupro and sismi and dans_z1 (xs, ys)) or
               dans_z1 (xs, ys) and not (dans_z2 (xs, ys) or dans_z3 (xs, ys));
         if f1
         then
            zone_fenetre := 1;

         f2 := (visupro and topo  and dans_z2 (xs, ys)) or
               dans_z2 (xs, ys) and not (dans_z1 (xs, ys) or dans_z3 (xs, ys));
         if f2
         then
            zone_fenetre := 2;

         f3 := (visupro and gravi and dans_z3 (xs, ys)) or
               dans_z3 (xs, ys) and not (dans_z1 (xs, ys) or dans_z2 (xs, ys));
         if f3
         then
            zone_fenetre := 3;
      end;
   end;

procedure calcule_profil (ox, oy, ex, ey : real);
   begin
      MontrerSouris;
      ChangerCurseur (Sablier);
      fenetrecloturecarte;
      if nomfd3 <> ''
      then
         coupe_sismi (ox, oy, ex, ey);
      coupe_gravi (ox, oy, ex, ey);
      coupe_topo  (ox, oy, ex, ey);
      coupe_corps (nbst, nbcorps );
      anom := true;
      ChangerCurseur (fleche);
      cachersouris;
      pleinecloture;
   end;

procedure Calculer;
   begin                                                  {    calculer    }
      if not (topo or sismi or gravi)
      then
         exit;

      if tropcourt (x1, x2, y1, y2)
      then begin
         message (m_court);
         exit
      end;
      laide (la_calcul);

      {enlev_pro; }  { indispensable pour afficher les points trouvs }

      if modipro
      then begin
      {   anom  := false;}
      {   reduc := false;}
         sis   := false;
         top   := false;
         gra   := false;
      end;

      calcule_profil (x1, y1, x2, y2);

      if  (gravi or topo) and (nbst < 3)
      then begin
         message (m_peu);
         reduc := false;
         anom  := false;
         exit
      end;

      if zoneinconnue and reduc
      then begin
         message (m_inconnu);
         reduc := false;
         anom  := false;
         exit;
      end;

      if modicomm
      then
         effacer_tout_redessiner
      else
         dess_profil (1, false);
         { si trop de sismes  : dessine les "maxstations" premiers foyers }

      modipro := false;
      active (2,  3, false);   { extrmits }
      active (2,  4, false);   { largeur/lissage }
      affval_extremites (x1, y1, x2, y2, longpro, nbst);
      laide ('');
   end;

procedure anomalie_gravi (ox, oy, ex, ey : real);
   begin
      calcule_profil (ox, oy, ex, ey);
   end;

procedure dessine_tout (trac : boolean);
   begin
      redess_carte (trac);
      redess_pro;
      affval_extremites (x1, y1, x2, y2, longpro, nbst);

      if visucomm
      then
         Dessiner_Commentaires (trac, true, false);
      inietat;                        { crit infos sur la ligne d'tat    }
   end;

procedure redess_tout;
   begin
      if not copie_en_cours
      then begin
         affichemenu;
         dess_icones;
      end;
      ini_titre;
      inietat;
      dessine_tout (false);
   end;

procedure effacer_tout_redessiner;
   begin
      copie_en_cours := false;
      fond_ecran  (coulecran);
      redess_tout;
      modicomm := false;
   end;

END.

{--- GEOCEAN - COUP_des ---------------------- R.C.- INRP - TOULOUSE - 1995 }

