PROGRAM CONF;

{---------------------------------------------------------------------------}
{  Logiciel GEOCEAN - module CONF  Configuration du logiciel GEOCEAN        }
{                                                                           }
{---------------------------------------------------------------------------}
{             Institut National de Recherche Pdagogique - PARIS            }
{                          Equipe INRP  TOULOUSE                            }
{  S. DUPOUY, C. GROS, R. CULOS, F. BOULANGER, J. TONNELAT, J. Y. GUCHEREAU }
{ Ralisation :                                                             }
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}
{                                                                           }
{  programme principal du module          CONF                   06/04/96   }
{                                                                           }
{ cf doc GEOCEAN pour organiser le disque : rpertoires, accs, protections }
{                                                                           }
{---------------------------------------------------------------------------}


{---------------------------------------------------------------------------}
{ fichiers spciaux associs au programme d'installation                    }
{    INST    .NST            modules et rgions installs                   }
{    *       .MN0            modules et rgions installables                }
{---------------------------------------------------------------------------}
{ fichiers spciaux associs  ce programme dans le rpertoire MNU          }
{    MENU    .ICN            images, icnes                                 }
{    MENU    .PAL            palette     (isolation possible dans rep BGI)  }
{    MENU    .TXT            prsentation du logiciel                       }
{    MENU    .AID            texte d'aide                                   }
{    MENU    .MNU            paramtres de la page d'accueil en cours       }
{    UTILISAT.EUR            temporaire : tat des variables en cours (TEMP)}
{---------------------------------------------------------------------------}

{$M 48000,0,640000}

USES
   Periphs,                  { ARX     - priphriques, impression, palettes}
   CSI,                      { ARX     - gestion Clavier, Souris et Icnes  }
   MENUS,                    { ARX     - interface  menus droulants        }

   MENU_VAR,                 { MENU    - variables globales du module       }
   MENU_FIC,                 { MENU    - Initialisations fichiers           }
   MENU_MNU,                 { MENU    - initialisations, procdures MENU   }
   MENU_INS;                 { CONF    - procdures propres                 }


{---------------------------------------------------------------------------}

procedure CasMenus;
   var
      Choix             : integer;

   begin
      if changemenus then exit;
      menus.menu (a, b, codeclavier); { MENU2 }
                               { acquisition d'un choix valide dans un menu }

      if FF1 (codeclavier)     { CSI }
      then begin               { appui sur la touche F1 dans un sous-menu   }
         case a of
            1    : Aide        (a, b);
            2    : Aide_Region (b-1);
            3    : Aide_Module (b-1);
            4..6 : Aide        (a, b);
         end ;
      end else begin
         if b > 1
         then
            Choix := 100*a+b;
         case choix of         { validation d'une option dans un sous-menu  }
          { menu FICHIERS }
            102  : VOIR_CATALOGUE;                    { menus5 }
            103  : EDITINFO;                          { rsums }
            104  : COPIER;
            105  : NETTOYER;
            106  : TRANSFERER;
            107  : Mode_Exemples;
            108  : change_connexion;
            109  : Mode_Echanges;
            110  : Menu_Ins.Quitter  (false);             {    }

           { 112  : PALETTES ('menu');}

          { menu REGIONS }
            202..212 :
               begin
                  zi := b-1+der_icn ;                   { quiv zone ecran }
                  Choix_Region   (b-1);
               end;

          { menu ACTIVITES }
            302..312 :
               begin
                  zi := b-1+3 + of7ico [b-1];           { quiv zone ecran }
                  Choix_Activite (b-1);
               end;

          { menu INTERFACE }
            402  : Ouvrir_Menu;
            403  : Enregistrer_Menu;
            404  : Enregistrer_Menu_Sous;

            406  : Autoriser;
            407  : Mod_menu_Region;                      { au menu }
            408  : Mod_menu_activ;
            409  : Gerer_Groupes;
            410  : Gerer_Utilisateurs;
            411  : Nettoyer_travail;
            412  : Parametres_menu;

          { menu MODULES }
            502  : ouvrir_Config_Geocean;
            503  : enr_Config_Geocean;
            504  : enr_sous_Config_Geocean;
          { menu div }
            506  : options_periphs;
            507  : preferences;
            509  : Parametres_cfg;

          { menu AIDES }
            602  : Aide_Menus_B;                        { ini }
            603  : Aide (6, b);
            604  : Aide_Geoc;
            605  : Aide_Mnu ;
            606  : Infos_Systeme;
            608  : A_Propos;                      { INRP tlse}
            609  : Aide (6, b+1);
         end;
      end;
   end;

procedure CasIcones;
   begin
      if changemenus then exit;
      if affichetexte            { appui sur F1 au niveau d'une icne       }
      then
         case zi of                                { CSI }
             2     : Aide (6, 9);                  { INRP  paris}
             4..14 : Aide_Module (zi - 3 - of7ico [zi-3]);
            15..25 : Aide_Region (zi - der_icn);
         end
      else begin
         case zi of                                { CSI }
             2     : Aide_Geoc;                    { Gnralits MENU }
             4..14 : begin
                        Choix_Activite (zi - 3 - of7ico [zi-3]);
                        {    lancer; }
                        {    modifier_module;}
                     end;
            15..25 : begin
                        Choix_Region   (zi - der_icn);
                        {   creer_repert_region; }
                        {   modifier_region;  }
                     end;
         end;
      end;
   end;


BEGIN                 { programme principal }

   nomdumodule := nomconf;
   modipar     := false;
   modini      := false;
   iniparam;          { initialisation des paramtres par dfaut    }
   inimenus;          { initialisation de l'interface menus         }
   inifondecran;      { affiche la carte et bandeau en bas          }
   iniparam2;         { initialisation des paramtres par dfaut    }
   lire_menus;        { initialise les tableaux MENUS               }
   iniaide;           { initialisation de l'aide en ligne   fic.AID }
   inimenus_menu;     { initialise les menus du module menu         }
   inimenus_conf;     { initialise les menus du module conf         }
   rech_precedents;   { recherche l'tat session prcdente         }
   iniicones;         { initialisation des icnes                   }
   iniecran;          { initialisation de l'cran/MENU              }

   complete_install_auto (ok);  { rinstaller systmatiquement      }
   identifier_util;   { comparer util et liste --Groupe ou individu }
   choix_reg_act;     { initialiser rgion et activit              }

   repeat
      modif_menus;    { modifications fonction des paramtres PAR   }
      aff_l_aide;
      case ZoneDuClick (maxc1, maxc2, maxc3, maxc4) of                                       { GEO_CSI }
         1 : CasMenus;
         2 : CasIcones;
      end;
      if changemenus
      then
         inversemenus;
   until fini;
   fin;                                                          { MENU_MNU }

END.                { programme principal }


{--- GEOCEAN - CONF -------------------------- R.C.- INRP - TOULOUSE - 1995 }
