UNIT INST_FIC;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module INSTallation                                 }
   {                                                                        }
   {------------------------------------------------------------------------}
   (*
   INST_FIC,                 { MENU    -                                    }
   *)

INTERFACE

{$O+,F+}

USES
   dos, crt,                 { TP 70   - unit  standard                    }

   Messarx,                  { ARX     - Textes des Messages de Base        }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Utiledi,                  { ARX     - utilitaires dition                }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Periphs;                  { ARX     - priphriques, impression, palettes}


VAR
   chain                : string;

   {------------------------------------------------------------------------}

Function rep_dos                (var rep        : pathstr)      : boolean;
   { rend vrai si Smartdrv existe dans rep                                  }

Procedure chemin_courant        (var chemin     : pathstr;
                                 var ok         : boolean);
   { rechercher le chemin courant CHEMINc                                   }

Procedure changer_repert        (chemini,
                                 cheminb        : pathstr;
                                 var ok         : boolean);
   { se placer  la racine du rpert de destination         }

Procedure nom_repert_existant   (comm           : chainecar;
                                 var chemin     : pathstr;
                                 var ok         : boolean);
   { rend le nom complet d'un CHEMIN  "source"                              }

Procedure nom_repert            (comm           : chainecar;
                                 var chemin     : pathstr;
                                 var ok         : boolean);
   { rend le nom complet du chemin destination CHEMIN par dfaut            }
   { NE cre pas le rpert.  OK = rp valide                                }

Procedure creer_repert          (chemin         : pathstr;
                                 placemini      : longint;
                                 var ok         : boolean);
   { initialiser le rpertoire destination et s'y dplacer                  }

Procedure tuer_repert           (chemin         : pathstr ;
                                 var ok         : boolean);
   { dtruire le rpertoire destination                                     }

Procedure tester_repert         (chemin         : pathstr;
                                 placemini      : longint;
                                 var ok         : boolean);
   { vrifie l'existence du rpertoire, le cre sans bruit, revient         }

(*procedure copie_liste_fichiers (nomfl : namestr; var ok : boolean);*)

   {------------------------------------------------------------------------}

IMPLEMENTATION

procedure chemin_courant        (var chemin     : pathstr;
                                 var ok         : boolean);
   { rechercher le chemin courant CHEMINc           }
   var
      u_ct              : string [2];
      r_ct,
      chemp             : pathstr;
      chem              : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      ok      := false;
      chemp   := '';
      {$I-}
      getdir (0, chemp);
      {$I+}
      if (ioresult=0) and (chemp <> '')
      then begin
         fsplit (chemp, chem, nomf, ext);
         u_ct   := copy (chem, 1 , 2);
         r_ct   := copy (chem, 3, length (chem))+nomf;
         chemin := u_ct+r_ct;
         ok     := true;
      end else begin
         message (m_not_lit);
      end;
   end;

procedure nom_repert_existant   (comm           : chainecar;
                                 var chemin     : pathstr ;
                                 var ok         : boolean);
   { rend le nom complet du CHEMIN  "source" }
   var
      repertexist       : boolean;
      nb                : integer;

   begin
      nb := 0;
      repeat
         chemin      := '';
         repertexist := false;
         repertoire (comm, chemin, repertexist);
         inc (nb);
      until repertexist or (nb > 2);
      ok     := repertexist;
   end;


function NomFichierValide       (nomf           : pathstr)      : boolean;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      fsplit  (nomf, d, n, e);
      nomFichiervalide := (n=nomf);
   end;

function NomCheminValide        (var chem       : pathstr)      : boolean;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;
      u                 : byte;

   begin
      fsplit   (chem, d, n, e);
      chem := d+n;
      u    := byte (upcase(d [1]))-64;
      nomCheminValide := (length (d) >= 2) {and (length (n) >1)}
                         and (d [2] = ':')
                         and (u in liste_disques);
   end;

function rep_dos                (var rep        : pathstr)      : boolean;
   var
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;

   begin
      fsplit (rep, d, n, e);
      if exists ( d+'smartdrv.exe')
      then begin
         rep := d;
         rep_dos := true;
      end else begin
         rep := '';
         rep_dos := false;
      end;
   end;

(*procedure nom_repert_dir (comm : string; var chemin : dirstr ; var ok : boolean);
   { Parcourt le disque avant de demander un nom de rpertoire  ajouter }
   { rend le nom complet du chemin destination CHEMIN par dfaut       }
   { NE cre pas le rpert.  OK = rp valide                           }
   var
      u_chm           : string [2];
      repertexist     : boolean;

   begin
      chain       := nomlogiciel;
      repeat
         repertexist := false;
         repertoire (comm, chemin, repertexist);
         if repertexist
         then begin
            u_chm := copy (chemin, 1, 2);
{            enleve_antislash (chemin); }
            saisie     ('REPERTOIRE  CREER sur '+chemin, chain, 12);
            if (chain <> '') and nomfichiervalide (chain)
            then begin
               chemin := chemin+chain;
            end else
               repertexist := false;
         end;
      until repertexist;
      ok := repertexist;
   end; *)

procedure nom_repert            (comm           : chainecar;
                                 var chemin     : pathstr ;
                                 var ok         : boolean);
   { rend le nom complet du chemin destination CHEMIN par dfaut }
   { NE cre pas le rpert.  OK = rp valide                     }

   begin
      ok    := false;
      enleve_antislash (chemin);
      repeat
         chain := chemin;
         laide ('Valider ou modifier le nom du chemin.');
         saisie     (comm{+' '+chemin}, chain,  36);
         laide ('');
         if (chain <> '') and nomcheminvalide (chain)
         then begin
            chemin := chain;
            ok := true
         end;
      until ok;

      if ok
      then begin
         ok  := true;
         question (comm, chemin, ok);
      end;
   end;

procedure changer_repert        (chemini,
                                 cheminb        : pathstr;
                                 var ok         : boolean);
   { se placer  la racine du rpert de destination         }
   var
      place             : longint;
      plas              : t12;

   begin
      ok := false;
      {$I-}
      chdir (cheminb);
      {$I+}
      if ioresult = 0
      then begin
      { annoncer le nom du rpert et la place restante sur le disque }
         ok    := true;
         place := diskfree (0);
         str     (place, plas);
         message ('rp : '+cheminb+'  '+plas+' '+'octets');
      end else begin
         message ('rpertoire introuvable');
         chdir   (chemini);
      end;
   end;

procedure creer_repert          (chemin         : pathstr;
                                 placemini      : longint ;
                                 var ok         : boolean);
   { initialiser le rpertoire destination       }
   { et s'y dplacer                             }
   var
      place             : longint;
      plas              : t12;
      new               : boolean;

   begin
      ok := false;
      {$I-}       chdir (chemin);       {$I+}
      if ioresult = 0
      then begin
         ok  := true;
         new := false;
      end else begin
         {$I-}         mkdir (chemin);      {$I+}
         if ioresult = 0
         then begin
            new := true;
            ok  := true;
            chdir (chemin);
         end else begin
            message ('Impossible de crr le rpertoire ');
         end;
      end;

      if ok
      then begin
         place := diskfree (0);
         str (place, plas);
         if new
         then
            message ('Nouveau rp : '+chemin+'  '+plas+' '+'octets');
         ok :=  place > placemini;
      end;
   end;

procedure tuer_repert           (chemin         : pathstr ;
                                 var ok         : boolean);
   { dtruire le rpertoire destination                                     }
   begin
      ok := false;
      {$I-}       rmdir (chemin);       {$I+}
      if ioresult = 0
      then
         ok := true;
   end;

procedure tester_repert         (chemin         : pathstr;
                                 placemini      : longint ;
                                 var ok         : boolean);
   { initialiser le rpertoire destination       }
   var
      place             : longint;
      plas              : t12;
      new               : boolean;
      ch_ct             : pathstr;

   begin
      enleve_antislash (chemin);
      getdir (0, ch_ct);
      ok := false;
      {$I-}       chdir (chemin);       {$I+}
      if ioresult = 0
      then begin
         ok  := true;
         new := false;
      end else begin
         {$I-}         mkdir (chemin);      {$I+}
         if ioresult = 0
         then begin
            new := true;
            ok  := true;
         end;
      end;
      chdir (ch_ct);
      if ok
      then begin
         place := diskfree (0);
         str (place, plas);
         ok :=  place > placemini;
      end;
   end;

(*procedure copie_liste_fichiers (nomfl : namestr; var ok : boolean);
   var
      f                   : text;
      nomfic, lign        : string;
      i, l , nf           : integer;

   begin
      ok     := false;
      repsrc := ftxt_present (nomfl+extdir);
      if not repsrc then exit;

      assign (f, nomfl+extdir);
      reset  (f);
      i := 0;
      repeat
         readln (f, lign);              { sauter les lignes vides }
         l := length (lign);
      until l > 0 ;

      inc (i);
      nf := 0;
      while (not eof (f))
      do begin
         ok     := false;
         nomfic := copy (lign, 1, 12);
         nomfic [9] := '.';
         laide (nomfic);
         CopyFile (chemins+'\'+nomfic, cheminb+'\'+nomfic, ok );
         if ok  then inc (nf);

         readln (f, lign);
         inc (i);
      end;
      close (f);
      ok := i-1 = nf;
   end; *)

END .
   {------------------------------------------------------------------------}

