program prepgeo;
   { modifs 06/04/96
        taille maxi dk
   }
   { totalise la place occupe par une config GEOCEAN
     gnre un fichier
        INST.TXT :   nom, date, taille
     organise les disquettes pour installation

     et synthtise dans
        INST.LST :  listes pour installation }

USES
   dos,
   utildivs,
   fichiers,
   lipar,
   periphs;


CONST
    taille_dk           = 1450000; { octets dispo }
    t_rep               = 2028;
    nomd                = 'geoc';  { racine nom rpert "disquette" }
    Inte                = 'Interface';
    Modu                = 'Modules';
    Don                 = 'Donnes';
    Exe                 = 'Exemples';
    Doc                 = 'Documents';
    extdk               = '.dk';

VAR
   tab_t                : array [1..5] of longint;

   ch_ct,
   chemf, chemff,
   cf, cff, cf2         : pathstr;

   nomf,  nomff, nomf2  : namestr;

   extf,  extff, extf2  : extstr;

   f,  ff, f2           : text;

   ok,
   app                  : boolean;

   nbf_tot,                           { nbf du rpertoire  copier }
   nt                   : integer;    { vt nb total de fichiers  copier dans un rpert }

   esp_occ,                           { espace occup sur la disquette cte }
   total                : longint;

   dt                   : datetime;

   jourmois             : string [4]; { complment nom rpert GEOC }

   num_dk               : byte;       { numro disquette en cours  }

   l_ele,
   l_prg,                             { listes des objets/disquette }
   l_reg,
   l_xpl                : lst_chn;

   parzip                    { paramtres disquette mise  jour ou install  }
                        : lipar.liste;

   misaj                : boolean;

   is, fs, ns           : string [3];

procedure ecr_par_zip (nomf  : pathstr);
   begin
      parzip.ecrit  (nomf, 'livraison du '+datjour);
   end;

procedure ini_par_zip (nomf  : pathstr);
   begin
      parzip.init   (false);
      parzip.ajoute (Clongint ('Place ncessaire',     @total,    0     ));
      parzip.ajoute (Clst_chn ('Gocan',              @l_ele,    nil   ));
      parzip.ajoute (Clst_chn ('Modules',              @l_prg,    nil   ));
      parzip.ajoute (Clst_chn ('Donnes',              @l_reg,    nil   ));
      parzip.ajoute (Clst_chn ('Exemples',             @l_xpl,    nil   ));

      parzip.ajoute (CBoolean ('Mise  jour',          @misaj,    false ));

   {   if ftxt_present  (nomf)
      then
         parzip.lit    (nomf);  }
   end;

function datfic (d : datetime) : string;
   var
      ca, cm, cj        : string;

   begin
      with d
      do begin
         str (year:4, ca);
         str (month:2, cm);
         str (day:2, cj);
         datfic := cj+'/'+cm+'/'+copy (ca, 3, 2);
      end;
   end;

procedure totalise (cf : pathstr; var t : longint);
   var
       DirInfo          : SearchRec;         { For Windows, use TSearchRec }

   begin
      t := 0;
      FindFirst (cf, Archive, DirInfo);
      while DosError = 0
      do begin
         unpacktime (dirinfo.time, dt);
         t := t+dirinfo.size;
         FindNext (DirInfo);
      end;
   end;

procedure anal (cf : pathstr; var t : longint);
   var
      DirInfo           : SearchRec;         { For Windows, use TSearchRec }

   begin
      t := 0;
      FindFirst (cf, Archive, DirInfo);
      while DosError = 0
      do begin
          unpacktime (dirinfo.time, dt);

                       { col A }     { B }                  { C }
          writeln (ff, dirinfo.name, chr (9), datfic (dt),  chr (9), dirinfo.size);

          t := t+dirinfo.size;
          FindNext (DirInfo);
      end;

      if t > 0
      then begin                                      { D }
         writeln    (ff, cf +' : ', chr (9), chr (9), chr (9), t);
         t := t div 100;
         t := (t+1) * 100;
      end;
   end;

procedure anal_racine (cf : pathstr);
   var
      t                 : longint;

   begin
      anal (cf+'*.*', t);
      tab_t [1] := t
   end;

procedure anal_mnu (cf : pathstr);
   var
      t                 : longint;

   begin
      anal (cf+'*.*', t);
      tab_t [1] := tab_t [1]+t;
      {writeln    (ff, cf +' : ', chr (9), chr (9), chr (9), tab_t [1]);}
   end;

procedure anal_prg (cf : pathstr);
   var
      t,
      t1, t2, t3,
      t4, t5, t6        : longint;
      ts                : string;
      g                 : lst_chn;

   begin
      anal (cf+'CART.*', t1);
      anal (cf+'BLOC.*', t2);
      anal (cf+'NUAG.*', t3);
      anal (cf+'COUP.*', t4);
      anal (cf+'GRAV.*', t5);
      anal (cf+'EXOC.*', t6);
      totalise (cf+'*.*', t);
      tab_t [2] := t;                                               { col E }
    {  writeln    (ff, cf +' : ', chr (9), chr (9), chr (9), chr (9), tab_t [2]);}

      if (t1 > 0)
      then begin
         str (t1, ts);
         ajouter_nom_chaine (l_prg, 'CART');
         g  := p_element    (l_prg, 'CART');
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if (t2 > 0)
      then begin
         str (t2, ts);
         ajouter_nom_chaine (l_prg, 'BLOC');
         g  := p_element    (l_prg, 'BLOC');
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if (t3 > 0)
      then begin
         str (t3, ts);
         ajouter_nom_chaine (l_prg, 'NUAG');
         g  := p_element    (l_prg, 'NUAG');
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if (t4 > 0)
      then begin
         str (t4, ts);
         ajouter_nom_chaine (l_prg, 'COUP');
         g  := p_element    (l_prg, 'COUP');
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if (t5 > 0)
      then begin
         str (t5, ts);
         ajouter_nom_chaine (l_prg, 'GRAV');
         g  := p_element    (l_prg, 'GRAV');
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if (t6 > 0)
      then begin
         str (t6, ts);
         ajouter_nom_chaine (l_prg, 'EXOC');
         g  := p_element    (l_prg, 'EXOC');
         ajouter_nom_chaine (g^.elements, ts);
      end;
   end;

procedure anal_dnn (cf : pathstr);
   var
      DirInfo           : SearchRec;         { For Windows, use TSearchRec }
      t                 : longint;
      ts                : string;
      g                 : lst_chn;
      nomr              : namestr;

   begin
      FindFirst (cf+'*.*', Archive+Directory, DirInfo);
      while DosError = 0
      do begin
        if (dirinfo.name <> '.') and (dirinfo.name <> '..')
        then begin
           nomr := dirinfo.name;
           anal     (cf+dirinfo.name+'\*.*', t);
           tab_t [3] := tab_t [3]+t;
           if t > 0
           then begin
              str (t, ts);
              ajouter_nom_chaine (l_reg, nomr );
              g  := p_element    (l_reg, nomr);
              ajouter_nom_chaine (g^.elements, ts);
           end;
        end;
        findnext (Dirinfo);
      end;
{      writeln    (ff, cf +' : ', chr (9), chr (9), chr (9), chr (9), tab_t [3]);}
   end;

procedure anal_xpl (cf : pathstr);
   var
       DirInfo          : SearchRec;         { For Windows, use TSearchRec }
       t                : longint;
       ts               : string;
       nomr             : namestr;
       g                : lst_chn;

   begin
      FindFirst (cf+'*.*', Archive+Directory, DirInfo);
      while DosError = 0
      do begin
        if (dirinfo.name <> '.') and (dirinfo.name <> '..')
        then begin
           anal     (cf+dirinfo.name+'\*.*', t);
           tab_t [4] := tab_t [4]+t;
           if t > 0
           then begin
              str (t, ts);
              ajouter_nom_chaine (l_xpl, dirinfo.name );
              g  := p_element    (l_xpl, dirinfo.name);
              ajouter_nom_chaine (g^.elements, ts);
           end;
        end;
        findnext (Dirinfo);
      end;
{      writeln    (ff, cf +' : ', chr (9), chr (9), chr (9), chr (9), tab_t [4]);}
   end;

procedure anal_doc (cf : pathstr);
   var
      t                 : longint;
      ts                : string;

   begin
      anal (cf+'*.*', t);
      tab_t [5] := t;                                       { E }
   {   writeln    (ff, cf +' : ', chr (9), chr (9), chr (9), chr (9), tab_t [5]);}
   end;

procedure compte_t (var ok : boolean);
   var
      i                 : word;
      ts                : string;
      g                 : lst_chn;

   begin
      ok := false;
      assign  (ff, cff+'\'+nomff+extff);      { xls }
      rewrite (ff);
      writeln (ff, 'GEOCEAN', chr(9), datjour);
      writeln (ff, '');
      anal_racine (cf+'\');
      anal_mnu    (cf+'\geoc_mnu\');
      anal_prg    (cf+'\geoc_prg\');
      anal_dnn    (cf+'\geoc_dnn\');
      anal_xpl    (cf+'\geoc_xpl\');
      anal_doc    (cf+'\geoc_doc\');
      close (ff);

      total := 0;
      for i := 1 to 5
      do
         total := total + tab_t [i];

      if tab_t [1] > 0
      then begin
         str (tab_t [1], ts);
         ajouter_nom_chaine (l_ele, Inte);
         g  := p_element    (l_ele, Inte);
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if tab_t [2] > 0
      then begin
         str (tab_t [2], ts);
         ajouter_nom_chaine (l_ele, Modu);
         g  := p_element    (l_ele, Modu);
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if tab_t [3] > 0
      then begin
         str (tab_t [3], ts);
         ajouter_nom_chaine (l_ele, Don);
         g  := p_element    (l_ele, Don);
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if tab_t [4] > 0
      then begin
         str (tab_t [4], ts);
         ajouter_nom_chaine (l_ele, Exe);
         g  := p_element    (l_ele, Exe);
         ajouter_nom_chaine (g^.elements, ts);
      end;

      if tab_t [5] > 0
      then begin
         str (tab_t [5], ts);
         ajouter_nom_chaine (l_ele, Doc);
         g  := p_element    (l_ele, Doc);
         ajouter_nom_chaine (g^.elements, ts);
      end;
   end;

{---------------------------------------------------------------------------}
procedure identifier   (nomf : pathstr; nomdk : namestr; var  ok : boolean);
   var
      f                 : text;

   begin
      nomf := nomf+'\'+nomdk+extdk;
      assign  (f, nomf);
      rewriteTxterr (f, nomf, ok);
      writeln (f, 'GEOCEAN'+ nomdk);
      close   (f)
   end;

procedure copie_rac     (cf, cff : pathstr; var nomdk : namestr;
                                            var numi, numf : byte);
   var
      nf                : integer;
      volmax            : longint;

   begin
      Volmax := taille_dk;
      nomdk  := nomd+'1';
      numi   := 1;
      numf   := 1;
      creer_repert (cff+'\'+nomdk, volmax, ok);
      chdir (ch_ct);
      identifier   (cff+'\'+nomdk, nomdk, ok);
    {  copier_fichiers_max (cf+'\*.*', cff+'\'+nomdk+'\', volmax, 0, nf);
     }
      esp_occ := 7000; { place pour lisezmoi et arborescence }
     { if nf = 0 then esp_occ := 0;}
      writeln (nomdk);
      writeln ('          ', esp_occ, '   ', '\');
   end;

procedure copie_rep     (cf, cff        : pathstr;
                         rep            : dirstr;
                         var esp_occ    : longint;
                         var nomdk      : namestr;
                         var numi, numf : byte);
   var
      volmax            : longint;
      i,
      ni,
      nf                : integer;
      fs                : string [1];
      rep2              : namestr;
      rep1              : dirstr;
      e                 : extstr;
      sous_repert       : boolean;
      chain             : string;
 {     t0,t1 :longint;}

   begin
      fsplit (rep, rep1, rep2, e);
      chain := copy (rep, 2, length (rep)-1);
      sous_repert := pos ('\', chain) = 0;
      volmax  := taille_dk - esp_occ;
      if sous_repert
      then begin
{         t0 := placedisque   ('D:');}
         creer_repert (cff+'\'+nomdk+rep,  taille_dk, ok);
{         t1 := placedisque ('D:');    }
         esp_occ := esp_occ + t_rep;
      end else begin
         rep1 := copy (rep1, 1, length (rep1)-1);
         creer_repert (cff+'\'+nomdk+rep1, taille_dk, ok);
         creer_repert (cff+'\'+nomdk+rep,  taille_dk, ok);
         esp_occ := esp_occ + 2*t_rep;
      end;
      chdir (ch_ct);
      { sur le rpert "dk" en cours, pas encore plein }
      volmax  := taille_dk - esp_occ;

      nt := numeromaxi (cf+rep+'\*.*');
      ni := 0;  { num  fichier initial }
      nf := 0;
      i  := 0;
      while (ni < nt)
      do begin
         volmax  := taille_dk - esp_occ;
         copier_fichiers_max
                  (cf+rep+'\*.*', cff+'\'+nomdk+rep+'\', volmax, ni, nf);
         { place max peut diminuer : volume effectivement copi }
         esp_occ := esp_occ + volmax;
         ni  := ni+nf;
         writeln  ('       ', numi,' ', numf, ' ', esp_occ, '   ', rep, '  ',  nt, ' ', ni );

         if (ni < nt)
         then begin
   { le rpert dk en cours est plein et il y a encore des fichiers  copier }
            inc (numf);
            str (numf, fs);
            nomdk := nomd+ fs;
            writeln (nomdk);

            creer_repert (cff+'\'+nomdk,      taille_dk, ok);
            chdir (ch_ct);
            esp_occ := esp_occ + t_rep;
            identifier   (cff+'\'+nomdk, nomdk, ok);
            if sous_repert
            then begin
               creer_repert (cff+'\'+nomdk+rep,  taille_dk, ok);
               esp_occ := esp_occ + t_rep;
            end else begin
               creer_repert (cff+'\'+nomdk+rep1, taille_dk, ok);
               creer_repert (cff+'\'+nomdk+rep,  taille_dk, ok);
               esp_occ := esp_occ + t_rep*2;
            end;
            chdir (ch_ct);
            esp_occ := 0;
         end;
      end;
   end;

procedure copie_reps    (l_rep          : lst_chn;
                         cf, cff        : pathstr;
                         rep            : dirstr;
                         var esp_occ    : longint;
                         var nomdk      : namestr;
                         var numi, numf : byte);
   var
      nf                : integer;
      DirInfo           : SearchRec;         { For Windows, use TSearchRec }
      t                 : longint;
      ts                : string;
      g                 : lst_chn;
      nomr              : namestr;

   begin
      FindFirst (cf+rep+'\*.*', Archive+Directory, DirInfo);
      creer_repert (cff+'\'+nomdk+rep, taille_dk, ok);
      esp_occ := esp_occ + t_rep;
      nbf_tot := 0;
      while DosError = 0
      do begin
         if (dirinfo.name <> '.') and (dirinfo.name <> '..')
         then begin
            nomr := dirinfo.name;
            if (taille_dk-esp_occ) < 5*t_rep
            then begin
               inc (numf);
               str (numf, fs);
               nomdk := nomd+ fs;
               writeln (nomdk);
               creer_repert (cff+'\'+nomdk,     taille_dk, ok);
               creer_repert (cff+'\'+nomdk+rep, taille_dk, ok);
               identifier   (cff+'\'+nomdk,     nomdk,     ok);
               chdir (ch_ct);
               esp_occ := 2*t_rep;
            end;
            numi := numf;
            copie_rep
               (cf, cff, rep+'\'+nomr, esp_occ, nomdk, numi, numf);
            str (numi, is);
            str (numf, fs);
            g  := p_element    (l_rep, nomr);
            ajouter_nom_chaine (g^.elements, is);
            ajouter_nom_chaine (g^.elements, fs);
            str (nt  , ns);
            ajouter_nom_chaine (g^.elements, ns);
            nbf_tot := nbf_tot + nt;
         end;
         findnext (Dirinfo);
      end;
   end;

procedure organise_dk (var ok : boolean);
   var
      i                 : word;
      ts                : string;
      g                 : lst_chn;
      nmi,
      numi, numf        : byte;
      nomdk             : namestr;

   begin
      ok   := false;
{      copie_rep    (cf, cff, '\*.*',          esp_occ, nomdk, numi, numf);}
      copie_rac    (cf, cff,          nomdk, numi, numf);

      if tab_t [1] > 0
      then begin
         numi := numf;
         copie_rep    (cf, cff, '\geoc_mnu', esp_occ, nomdk, numi, numf);
         str (numi, is);
         str (numf, fs);
         g  := p_element    (l_ele, Inte);
         ajouter_nom_chaine (g^.elements, is);
         ajouter_nom_chaine (g^.elements, fs);
         str (nt  , ns);
         ajouter_nom_chaine (g^.elements, ns);
      end;

      if tab_t [2] > 0
      then begin
         numi := numf;
         copie_rep    (cf, cff, '\geoc_prg', esp_occ, nomdk, numi, numf);
         str (numi, is); str (numf, fs);
         g  := p_element    (l_ele, Modu);
         ajouter_nom_chaine (g^.elements, is);
         ajouter_nom_chaine (g^.elements, fs);
         str (nt  , ns);
         ajouter_nom_chaine (g^.elements, ns);
      end;

      if tab_t [3] > 0
      then begin
         numi := numf;
         nmi  := numi;
         copie_reps   (l_reg, cf, cff, '\geoc_dnn', esp_occ, nomdk, numi, numf);
         str (nmi, is);
         str (numf, fs);
         g  := p_element    (l_ele, don);
         ajouter_nom_chaine (g^.elements, is);
         ajouter_nom_chaine (g^.elements, fs);
         str (nbf_tot  , ns);
         ajouter_nom_chaine (g^.elements, ns);
      end;

      if tab_t [4] > 0
      then begin
         numi := numf;
         nmi  := numi;
         copie_reps   (l_xpl, cf, cff, '\geoc_xpl', esp_occ, nomdk, numi, numf);
         str (nmi, is); str (numf, fs);
         g  := p_element    (l_ele, exe);
         ajouter_nom_chaine (g^.elements, is);
         ajouter_nom_chaine (g^.elements, fs);
         str (nbf_tot, ns);
         ajouter_nom_chaine (g^.elements, ns);
      end;

      if tab_t [5] > 0
      then begin
         numi := numf;
         copie_rep    (cf, cff, '\geoc_doc', esp_occ, nomdk, numi, numf);
         str (numi, is); str (numf, fs);
         g  := p_element    (l_ele, doc);
         ajouter_nom_chaine (g^.elements, is);
         ajouter_nom_chaine (g^.elements, fs);
         str (nt  , ns);
         ajouter_nom_chaine (g^.elements, ns);
      end;
   end;

procedure init (var ok  : boolean);
   var
      i                 : integer;

   begin
      for i := 1 to 5
      do
         tab_t [i] := 0;

      chemf  := 'c:\geocean\';
      chemff := '';
      nomff  := 'INST';
      nomf2  := 'INST';
      extff  := '.txt';
      extf2  := '.lst';

      ok := false;
      if (paramcount > 0)
      then
         if (paramstr (1) = '?') or
            (paramstr (1) = '/?') or
            (paramstr (1) = '/help')
         then begin
            writeln ('Gnre un fichier GEOCEAN.TXT  partir du rp GEOCEAN en cours ' );
            writeln ('                  et un fichier INST.LST');
            writeln ('Copie l''arborescence dans les rpertoires D1, D2..');
            writeln (' ');
            writeln ('                  Le tout dans le rpertoire dsign');
            writeln ('ex :');
            writeln ('    PREP d:\geocean1 e:\instgeoc');
            exit;
         end;

      if paramcount > 0
      then begin
         cf  := paramstr (1);
         fsplit (cf,  chemf,  nomf,  extf);
         cf := chemf+nomf;

         if paramcount > 1
         then begin
            ok    := true;
            cff   := paramstr (2);
            fsplit (cff,  chemff,  nomff,  extff);
            cff   := chemff+nomff;
            nomff := 'inst';
            extff := '.txt';
         end;
      end;
      getdir (0, ch_ct);
      creer_repert (cff, 1000000, ok);
      esp_occ := esp_occ + t_rep;
      chdir (ch_ct);
      ini_par_zip (cff+'\'+nomf2+extf2); { initialiser vt avec MISAJ }
   end;

begin  { principal }
   init (ok);
   if ok
   then
      compte_t (ok);               { passe 1 : stat }

   ok := true;
   if ok
   then begin
      organise_dk (ok);
   end;

   if ok
   then begin
      ecr_par_zip (cff+'\'+nomf2+extf2);
      parzip.fini;
   end;
end.

{ PREPGEO }