UNIT UTILDIVS;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          divers utilitaires                               }
{                                                               27/01/93    }
{---------------------------------------------------------------------------}
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde  31130 BALMA  }
{---------------------------------------------------------------------------}

(*
   Utildivs,                 { ARX     - utilitaires divers                 }
*)

INTERFACE

{$O+,F+}

USES
   dos,
   crt,
   graph,           { TP 70   - units standard Borland                     }
   Graphism,        { ARX     - initialisations graphiques                  }
   Souris,          { ARX     - gestion de la souris                        }
   Clavier,         { ARX     - gestion du clavier                          }
   Messarx;         { ARX     - textes des messages de base                 }

CONST
   MaxListe             = 256;         { ht listes botes  dfilement      }
   str12                =  12;         { }
   str20                =  20;         { }
   str30                =  30;         { }
   MaxChaine            =  36;         { }
   MaxCar               =  63;         { lg lignes botes  dfilement      }
   MaxLongChaine        =  72;         { }
   tempo_txt            = 'temp.tmp';  { nom fichier temporaire/copie       }

TYPE
   car                  = string [1];
   t12                  = string [str12];
   t20                  = string [str20];           { ? }
   t30                  = string [str30];
   chaine               = string [MaxChaine];       { pour les menus }
   chainecar            = string [MaxCar];
   longchaine           = string [MaxLongChaine];   { pour les commentaires }
   listch               = array  [1..MaxListe]
                                     of LongChaine;
                                             { pour les botes  dfilement }

VAR
   listchaine                          { toutes listes de textes }
                        : ^Listch ;

   xs, ys,                             { dplacement souris }
   cx, cy                              { pas souris/flches }
                        : integer;

   prg_menu,                           { prg menu actif : inverser couleurs }
   g, d                                { boutons souris                     }
                        : boolean;

  { colord,    colorf,
   coulboite, coulecran  : cf graphism }

   c_barre,                            { couleur barre tat                 }
   c_t_boite_norm,                     { texte menu  fond titre listes      }
   c_t_boite_inac,                     { option inactive                   }
   c_t_boite_inve,                     { texte option slectionne          }
   c_f_boite_norm,                     { fond menu                          }
   c_f_boite_inve,                     { fond option slectionne           }
   c_fond,                             { ?? fond cran                      }
   aideinve                            { couleur vive fond aide             }
                        : word;

   entier, err                         { var temporaires                    }
                        : integer;
   reel                                { var temporaire                     }
                        : real;
   ch                                  { var temporaire                     }
                        : namestr;

Procedure echap;
   { Attend ESC au clavier                                                  }

Procedure entree;
   { Attend CR au clavier                                                   }

Procedure clav           (var Touche         : integer);
   { lecture des touches :
         FleG, FleD, FleH, FleB : modif CX et CY
         CR ESC                 : modif G D                                 }

Procedure clavsouris     (var Touche         : integer);
   { lecture CLAV et Bouton Gauche = G , Bouton Droit = D                   }

Procedure ClavSourisFleches (var Touche : integer);
   {}

Procedure creeliste      (t                  : chainecar;
                          pos                : integer);
   { ajout d'un lment  une liste.                                        }

Procedure liste          (texte1,
                          texte2, texte3     : chainecar;
                          x                  : integer;
                          var rep            : chainecar;
                          var indice         : integer);
   { affichage et slection dans une une liste.                             }
   { x := largeur en caract                                                 }

Function  DATTOJUL       (J, M, A            : Integer;
                          Var Err            : Integer)          : Real;
   { ROLE : Renvoie pour le jour J du mois M de l'anne A le jour Julien   }
   { 0 heure. Cette fonction n'est valable que pour les annes positives.   }

Procedure JULTODATE      (jje                : real;
                          var anneetrouvee,
                              moistrouve,
                              jourtrouve,
                              erreur         : integer);

Procedure DATE           (j, m, a            : integer;
                          Var Err            : integer;
                          var nj             : integer;
                          Var jo, mo         : t30);
   { Rle : dterminer le jour de la semaine et le nom du mois pour la date }

Function nomfdefo        (nomm, nomf, nomu   : string)          : namestr;
   {               module, nomfpar, nomutil }

Function souschaine      (ch1                : string ;
                          avant, apres       : car)             : string;
   { extraction d'une sous-chane entre deux caractres exclus.             }

Procedure enlev_blancs   (var ch             : string);
   { extrait les espaces d'une chane.                                      }

Procedure e_b            (var ch             : string);
   { idem pour un type STRING  aprs...                                     }

Procedure e_b_devant     (var ch             : string);
   { idem avant la chane                                                   }

Procedure sousch         (ch1                : string;
                          p                  : integer;
                          apres              : car;        { en entre }
                          var ssch           : string;
                          var ppos           : integer);   { en sortie }
   { chaine non vide et p < length (ch1)                                    }
   { extrait une portion de ch1
     depuis la position p jusqu'au caractre d'arrt APRES
                        p = length+1 si non touv                           }

Function maj             (s                  : string)           : string;
   { rend la chane S transforme en majuscules   par UPCASE                }

Function maj_sans_accent (s                  : string)           : string;
   {}

Procedure beep;
   { Emet un son aigu : OK                                                  }

Procedure zap;
   { Emet un son grave : erreur                                             }

Procedure Tilt;
   { son aigu }

Procedure attente;
   { attend une touche quelconque.                                          }

Procedure cristalise     (xmin, ymin, xmax, ymax, lim    : integer);
   { ralise des dgrads...                                                }

Procedure retourpoint    (xmin, ymin, xmax, ymax, bouton : integer;
                          var xs, ys                     : integer);
   { rend les coordonnes-cran d'un point.                                 }

Procedure def_zone       (typ, coul              : word;
                          rapxy                  : real;
                          xmin, ymin, xmax, ymax : integer;
                          var xi, yi, xf, yf     : integer);
   { typ 0 --> ligne              (2 point  )
     typ 1 --> rectangle          (2 points )
     typ 2 --> rectangle  tirer (1 point  dfinir)
     typ 3 --> ligne      tirer (1 point  dfinir)
     coul     : couleur du motif ; la couleur courante est rtablie.
     rapxy    : fixe le rapport  x/y si il est <> 0.
     min, max : limites de dplacement (coord clture)
     xs,  ys  : coordonnes ecran  (0, 0) en haut  gauche                  }

Procedure dep_rec        (var x0, y0         : integer;
                          lx, ly             : integer);
   { dplace un rectangle                                                   }

Procedure depl_rec       (var x0, y0         : integer;
                          lx, ly             : integer);
    { 11/03/95}

Procedure affiche_ascenseur_v
                         (bornei, bornef, x, y, ly, lgy, pos : integer);
   { dessine une barre de dfilement verticale                              }

Procedure affiche_ascenseur_h
                         (bornei, bornef, x, y, lx, lgx, pos : integer);
   { dessine une barre de dfilement horizontale                            }

Procedure ascenseur_v    (bornei, bornef, x, y, ly, lgy      : integer;
                          var pos, Touche                    : integer);
   { rend la POSition de l'ascenseur dans l'intervalle                      }

Procedure ascenseur_h    (bornei, bornef, x, y, lx, lgx      : integer;
                          var pos, Touche                    : integer);
   { rend la POSition de l'ascenseur dans l'intervalle                      }

Procedure letat          (t                  : chainecar;
                          p, lg              : integer);
   { affichage sur la barre d'tat infrieure.                              }

Procedure letat2         (t                  : chainecar;
                          p, lg              : integer;
                          c1, c2             : word);
   { affichage sur la barre d'tat suprieure.     fond  texte              }

Procedure laide          (t                  : longchaine);
   { affichage sur la barre d'aide.                                         }

Procedure message        (texte              : longchaine);
   { affiche une chane dans une bote centre.                             }

Procedure message3       (t1, t2, t3         : longchaine);
   { affiche les 3 chanes dans une bote centre.                          }

Procedure question       (texte1, texte2     : longchaine ;
                          var reponse        : boolean);
   { saisie d'une rponse O/N et validation dans une bote centre.         }

Function  datjour                                                : t30;
   { rend la date du systme sous la forme jj/mm/aa                         }

Function  memdisponible                                          : t20;
   { rend Memavail                                                          }

Procedure efface_boite   (x0, y0             : integer;
                          p                  : pointer);
   { rtablit le fond, efface la bote pointe et libre P                  }

Procedure fixecoulentete;
   { adapte la couleur de l'entte en fonction du module                    }

Procedure filtrer_indesirables (var nf : pathstr);
   { filtre les caractres pour un nom de fichier }

{---------------------------------------------------------------------------}
IMPLEMENTATION

procedure filtrer_indesirables (var nf : pathstr);
   var
      o                 : byte;
      l, i              : integer;
      c                 : char;
      nf2               : pathstr;

   begin
      nf2 := '';
      nf  := maj_sans_accent (nf);
      for i := 1 to length (nf)
      do begin
         c := nf [i];
         o := ord (c);
         if    (o > 47) and (o < 58)
            or (o > 40) and (o < 96)
            or (c in ['*', '?'])
         then
            nf2 := nf2 + c
         else
            nf2 := nf2 + '_'
      end;
      nf := nf2;
   end;

procedure fixecoulentete;
   begin
      if prg_menu
      then
         setfillstyle (1, c_f_boite_inve)  { coul  menu }
      else
         setfillstyle (1, c_t_boite_norm); { coul modules }
   end;

procedure efface_boite (x0, y0 : integer; p : pointer);
   begin
      putimage (x0, y0, p^, 0);
      libere   (p);
   end;

function memdisponible  : t20;
   var
      chain             : t20;

   begin
      str (Memavail:6, chain);
      memdisponible := chain;
   end;

function datjour : t30;
   var
      ca, cm, cj         : t30;
      a, m, j, n         : word;

   begin
      getdate (a, m, j, n);
      str (a:4, ca);
      str (m:2, cm);
      str (j:2, cj);
      datjour := cj+'/'+cm+'/'+copy (ca, 3, 2);
   end;

procedure echap;
   var
      code              : integer;

   begin
      repeat   lirecodeClavier (code) until code = ESC;
   end;

procedure entree;
   var
      code              : integer;

   begin
      repeat   lirecodeClavier (code) until code = CR;
   end;

procedure clav (var Touche : integer);
   var
      t                 : boolean;

   begin
      Touche := 0;
      t      := ToucheClavier (touche);
      case touche of
         FleG : cx := -tx;
         FleD : cx :=  tx;
         FleH : cy := -ty;
         FleB : cy :=  ty;
         CR   : g  := true;
         ESC  : d  := true;
      end;
   end;

procedure clavsouris (var Touche : integer);
   begin
      g := false;
      d := false;
      repeat
         clav (Touche);
         g := g or BoutonSourisEnfonce (BoutonGauche);
         d := d or BoutonSourisEnfonce (BoutonDroit);
      until g or d;
   end;

procedure ClavSourisFleches (var Touche : integer);
   begin
      g := false;
      d := false;
      repeat
         clav (Touche);
         g := g or BoutonSourisEnfonce (BoutonGauche);
         d := d or BoutonSourisEnfonce (BoutonDroit);
      until g or d or (touche <> 0);
   end;

procedure creeliste (t : chainecar; pos : integer);
   begin
      if pos < maxliste
      then begin
         listchaine^ [pos]   := t ;
         listchaine^ [pos+1] := '';
      end
   end;

procedure liste (texte1, texte2, texte3 : chainecar;
                 x               : integer;
                 var rep         : chainecar;
                 var indice      : integer);

   var
      p                 : pointer;

      taillep           : word {longint};

      Touche,
      ind0,
      supx,
      mxy, mxx,
      lx,  ly,
      x0,  y0,
      ny,
      max, h            : integer;

      asc_v,
      select            : boolean;

   procedure inverse_ligne (i : integer);
      begin
         setcolor                (c_t_boite_inve);
         setfillstyle (SolidFill, c_f_boite_inve);
{         bar          (x0   +2,   y0+h+(i-ny)   *ty,
                       x0+lx-2,   y0+h+(i-ny+1) *ty); }   {ligne pleine }
         bar          (x0   +4,   y0+h+1+(i-ny)   *ty,
                       x0+lx-4,   y0+h-1+(i-ny+1) *ty);
      end;

   procedure ligne_normale (i : integer);
      begin
         setcolor        (c_t_boite_norm);
         setfillstyle (SolidFill, c_f_boite_norm);
         bar          (x0   +2,   y0+h+(i-ny)   *ty,
                       x0+lx-2,   y0+h+(i-ny+1) *ty);
      end;

   procedure affiche_ligne ( i : integer);
      var
         pp              : integer;
         nomf            : namestr;
         ext             : extstr;

      begin
         pp := pos ('.', (listchaine^[i]));
         if (pp > 3) and (pp < 9)
         then begin
            nomf := copy  (listchaine^[i], 1,    pp-1);
            ext  := copy  (listchaine^[i], pp,   4   );
            outtextxy (x0+6,       y0+h+(i-ny)*ty, nomf);
            outtextxy (x0+6+tx*8,  y0+h+(i-ny)*ty, ext);
         end else                                     { liste banale  }
            outtextxy (x0+6,       y0+h+(i-ny)*ty,
                       copy (listchaine^[i], 1, mxx));
      end;

   procedure affiche;
      var
         i              : integer;

      begin
         setcolor        (c_t_boite_norm);
         setfillstyle (SolidFill, c_f_boite_norm);
         bar         (x0   +2,   y0+h,  x0+lx-2,   y0+ly+h-2);
         i := ny;
         repeat
            affiche_ligne (i);
            inc (i);
         until (listchaine^[i] = '') or (i = ny+mxy);

         if (indice >= ny) and (indice < ny+mxy)
         then begin
            inverse_ligne (indice);
            affiche_ligne (indice);
         end;
      end;

   procedure select_ligne ;
      var
         i1, i          : integer;

      { calculer rang  partir de Xs
                               de la position de la fentre
                               et du texte dans la f }
      begin
         i    := ny + (ys - (y0 + h +2)) div ty;

         inverse_ligne (i);
         affiche_ligne (i);

         { effacer ancienne slection <> dans le mme cadre }
         if (indice <> i) and (indice >= ny) and (indice < ny+mxy)
         then begin
            ligne_normale (indice);
            affiche_ligne (indice);
         end;

         ind0 := i;
      end;

   procedure select_ligne_clavier ;
      var
         i1, i          : integer;

      { calculer rang  partir de Xs
                               de la position de la fentre
                               et du texte dans la f }
      begin
         case Touche of
            FleH : dec (indice);
            FleB : inc (indice);
            PgUp : indice := indice - mxy +1;
            PgDn : indice := indice + mxy -1;
         end;
         if indice < 1   then indice := 1;
         if indice > max then indice := max;
         if indice < ny  then ny     := indice;

         if indice >= ny + mxy then ny := indice - mxy + 1;
         if ny     < 1         then ny := 1;
         if ny     > max - mxy then ny := max - mxy + 1;

         Affiche;

         ind0 := indice;
      end;

   begin
    { nouveau_style (0, 0, 1);
      tx :=  8;
      ty := 12; }

      if indice < 1
      then
         indice := 1;

      asc_v := false;
      memok := true;
      mxx   := Maxcar;
      mxy   := 10;
      max   :=  0;
      repeat
         inc (max);
      until listchaine^[max] = '';
      max   := max-1;

      if max <= mxy
      then begin
         supx  := 0;
         mxy   := max;
      end else begin
         supx  := 2*8 {tx};
         asc_v := true
      end;

      if length (texte1) > x then x := length (texte1);
      if length (texte2) > x then x := length (texte2);
      if length (texte3) > x then x := length (texte3);
      if x < 14  then x := 14;
      if x > mxx then x := mxx;

      lx  := x*tx + 2*6;
      if (posxbtn > 0) and (lx+supx > posxbtn)
      then begin
         x   := (posxbtn -2*6 - supx -1) div tx;
         mxx := x;
         lx  := x*tx + 2*6 +supx;
      end;

      h       := 3*ty + 11;
      ly      := ty*mxy + 2;
      taillep := imagesize (0, 0, lx+supx, ly+h);

      if (taillep < maxavail) and (taillep < maximage)
      then begin
         laide  (la_2clic_esc);
         getmem (p, taillep);
         if posxbtn = 0
         then begin
            x0 := (maxx -lx -supx)    div 2;
            y0 := (maxy -ly -h)       div 2;
         end else begin
            x0 := (posxbtn -lx -supx) div 2;
            y0 := (maxy    -ly -h)    div 2;
         end;
         if x0 < 0  then x0 := 0;
         if y0 < 0  then y0 := 0;

         getimage  (x0,   y0,   x0+lx+supx,   y0+ly+h, p^);

         setcolor                (c_t_boite_norm);
         setfillstyle (solidfill, c_f_boite_norm);
         bar       (x0,   y0,   x0+lx+supx,   y0+ly+h);

         rectangle (x0+1, y0+h-1, x0+lx-1,      y0+ly+h-1); { liste }
         rectangle (x0+1, y0+1,   x0+lx+supx-1, y0+   h-3); { en tte }

         ny := 1;
         if asc_v
         then
            affiche_ascenseur_v (1, max-mxy+1, x0+lx-1, y0+h-1, ly, -1, ny);

         setcolor        (c_t_boite_inve);      { titre }
         fixecoulentete ;
         (*            if prg_menu
         then
            setfillstyle (1, colord {c_f_boite_inve})
         else
            setfillstyle (1, c_t_boite_norm);        *)
         bar       (x0+2, y0+2,   x0+lx+supx-2, y0+h-4);
         settextjustify (1, 1);
         outtextxy (x0+(lx+supx) div 2, y0+3+       ty div 2,  texte1);
         outtextxy (x0+(lx+supx) div 2, y0+3+ty+    ty div 2,  texte2);
         outtextxy (x0+(lx+supx) div 2, y0+3+ty+ty +ty div 2,  texte3);
         settextjustify (0, 2);

         ind0    :=  0;
         select  := false;
         repeat until not unboutonsourisenfonce;
         repeat
            affiche;

            if asc_v
            then
               ascenseur_v (1, max-mxy+1, x0+lx-1, y0+h-1, ly, -1, ny, Touche);
            if not asc_v
            then begin
               MontrerSouris;
               ClavSourisFleches (Touche);
               LirePositionSouris (xs, ys);
               CacherSouris;
            end;

            if (xs > x0) and  (xs < x0+lx)
               and (ys > y0+h) and (ys < y0+h+ly)
               or (Touche = CR) or (Touche = FleB)
               or (Touche = FleH) or (Touche = PgUp)
               or (Touche = PgDn)
            then begin
               repeat until not unboutonsourisenfonce;

               if Touche = 0
               then
                  select_ligne
               else
                  select_ligne_clavier;

               if (Touche = 0) or (Touche = CR)
               then
                  select := ind0=indice;
               indice := ind0;
            end else
               select := false;
            delay (10);
         until d or select;

         if d
         then begin
            rep    := '' ;
            indice := 0
         end else begin
            rep := listchaine^[indice] ;
         end;
         {efface_boite (x0, y0, p);}
         putimage (x0, y0, p^, 0);
         freemem  (p, taillep);
         laide ('');
      end else
         memok := false;
      { ancien_style;}
   end;

Function sans_accent (carac : char) : char;
   var
      c                 : char;

   begin
      if carac in ['']             then c := 'c';
      if carac in ['','','']     then c := 'a';
      if carac in ['','','',''] then c := 'e';
      if carac in ['','']         then c := 'i';
      if carac in ['','']         then c := 'o';
      if carac in ['','','']     then c := 'u';
      sans_accent := c;
   end;

function maj (s : string) : string;
   var
      i                 : byte;
      s2                : string;

   begin
      s2  := '' ;
      for i := 1 to length (s)
      do
         s2 := s2 + upcase (s [i]);
      maj := s2 ;
   end;

function maj_sans_accent (s : string) : string;
   var
      c                 : char;
      i                 : byte;
      s2                : string;

   begin
      s2  := '' ;
      for i := 1 to length (s)
      do begin
         c := s [i];
         if c in ['a'..'z']
         then
            s2 := s2 + upcase (c)
         else
            if c in minus
            then
               s2 := s2 + upcase (sans_accent (c))
            else
               s2 := s2 + c;
      end;
      maj_sans_accent := s2 ;
   end;

function DATTOJUL (J, M, A : Integer; Var Err : Integer) : Real;
{ ROLE : Renvoie pour le jour J du mois M de l'anne A
                 le jour Julien  0 heure.
  Cette fonction n'est valable que pour les annes positives.
  PARAMETRES :
  E J:jour
  E M:mois
  E A:anne
  S Err:Flag d'erreur 0:la date est OK
    Les autres valeurs concernent des erreurs sur
    1:l'anne, 2:le mois, 3:le jour, 4:la priode.
  COMMENTAIRES : Les jours compris entre le 4 et le 15 Octobre 1582 (exclus)
  n'ont jamais exist.
  DEPENDANCE : aucune }

   function ANNEEBISSEXTILE(An:Integer):Boolean;
   {  ROLE : Renvoie Vrai si An est une anne bissextile
      PARAMETRE : E An:anne
      COMMENTAIRES : Avant 1582 (re Julienne), toutes les annes divisibles
      par 4 ou par 100 sont bissextiles.
      Aprs 1582 (re Grgorienne), une anne est bissextile si elle est divisible
      par 4 tout en n'tant pas divisible par 100 (annes non sculaires) ou
      si elle est divisible par 100 et par 400 (annes sculaires).
      DEPENDANCE : aucune}

      BEGIN
        If (An<1582)
        Then     {re julienne}
           If (An Mod 100=0) or (An Mod 4=0)
           Then
              AnneeBissextile:=True
           Else
              AnneeBissextile:=False
        Else  {re grgorienne}
           If (An Mod 4=0) and ((An Mod 400=0) or ((An Mod 400<>0) and
              (An Mod 100 <>0)))
           Then
              AnneeBissextile:=True
           Else
              AnneeBissextile:=False;
      END;

   CONST
      OK                = 0;
      AnneeFausse       = 1;
      MoisFaux          = 2;
      JourFaux          = 3;
      NexistePas        = 4;

   VAR
      Y, Mo             : Integer;
      A1, B1            : Real;
      Gregorien         : Boolean;

   Begin
      {Dtection d'une erreur sur les paramtres}
      If (A<1) Then Err:=AnneeFausse
      Else If (J<1) Then Err:=JourFaux
           Else If (M<1) or (M>12) Then Err:=MoisFaux
              Else  {Tests sur les mois de 31, 30 et 29 jours}
                If ((J>31) or ((J=31) and ((M=2) or (M=4) or (M=6) or (M=9)
                   or (M=11))) or ((J=30) and (M=2)) or ((J=29) and (M=2) and
                   (Not ANNEEBISSEXTILE(A)))) Then Err:=JourFaux
                Else Err:=OK;
      If (M>2) Then Begin
           Y:=A; Mo:=M; End
      Else Begin
           Y:=A-1; Mo:=M+12; End;
      If (A<1582) or ((A=1582) and (M<10)) or ((A=1582) and (M=10) and
         (J<5)) {re julienne} Then Begin
                 A1:=0; B1:=0;
                 DATTOJUL:=int(365.25*Y)+int(30.6001*(Mo+1))+J+B1+1720994.5
                 End
      Else If ((A=1582) and (M=10) and ((J>4) and (J<15))) Then Err:=NexistePas
           Else {re grgorienne} Begin
             A1:=int(Y/100); B1:=2-A1+int(A1/4);
             DATTOJUL:=int(365.25*Y)+int(30.6001*(Mo+1))+J+B1+1720994.5;
             End;

   end;

procedure JULTODATE     (jje               : real;
                         var anneetrouvee,
                         moistrouve,
                         jourtrouve,
                         erreur            : integer);

   Const
      JJb               = 2417941.5;   { 1 janvier 1908 a 0h }
      AnneeBase         = 1908;
      Jourbase          = 1;

   type
      tableau           = array [1..12] of integer;

   VAR
      NbJours,
      nbjoursref        : Real;
      Signe, ajout,
      NbAnnees,
      i, anneebis,
      bissex, anneetemp : integer;
      mois              : tableau;
      anneebissex       : boolean;

   BEGIN
      Mois [1] :=31; Mois [2] :=28; Mois [3] :=31; Mois [4] :=30;
      Mois [5] :=31; Mois [6] :=30; Mois [7] :=31; Mois [8] :=31;
      Mois [9] :=30; Mois[10] :=31; Mois[11] :=30; Mois[12] :=31;

      If (JJe >= JJb)   Then Signe  :=1 else Signe := -1;
      if (JJe < 4748.5) Then erreur :=1;
      if erreur = 0
      then begin
                           {****** 1- Trouver l'anne ******}
         NbJoursref:= abs(JJe-JJb);
         Nbannees:=trunc(NbJoursref/365.25);
         AnneeTrouvee:=AnneeBase+(Signe*NbAnnees);
         if signe = -1 then dec(anneetrouvee);

                            {****** enlever le nb jours dus aux annees ******}
         nbjours:=0;
         anneetemp:=anneebase;
         if (jje < 2299160.5) then nbjours:=nbjours-10; { date du 15/10/1582 a 0h}
         if signe=1
         then begin
            while (anneetemp<>(anneetrouvee))
            do begin
               ajout:=365;
               if (anneetemp mod 4 =0) and (anneetemp mod 100 <> 0)
               then
                  ajout:=366;
               if (anneetemp mod 400 = 0)
               then
                  ajout:=366;
               nbjours:= nbjours+ ajout;
               anneetemp:=anneetemp+1;
            end;
         end;

         if signe=-1
         then begin
            while (anneetemp<>(anneetrouvee+1))
            do begin
               ajout:=365;
               if (jje >= 2299160.5 )
               then begin
                  if ((anneetemp-1) mod 4 =0) and ((anneetemp-1) mod 100 <> 0)
                  then
                     ajout:=366;
                  if ((anneetemp-1) mod 400 = 0)
                  then
                     ajout:=366;
               end; { calendrier gregorien }
               if (jje < 2299160.5) and ((anneetemp-1) mod 4 =0)
               then
                  ajout:=366;
               nbjours:= nbjours+ ajout;
               anneetemp:=anneetemp-1;
            end;
         end;
         if (jje < 2299160.5)
         then
            nbjours:=nbjours-3;   {correction due aux boucles}
         nbjours:=nbjoursref-nbjours;
         bissex:=0; {si annee trouvee non bissextile}
         if (jje >= 2299160.5)
         then begin
            if ((anneetrouvee mod 4 = 0) and  (anneetrouvee mod 100 <> 0))
             or (anneetrouvee mod 400 =0)
            then  begin
               mois[2]:=29;
               bissex:=1;
            end;
        end;
        if (jje < 2299160.5) and (anneetrouvee mod 4 =0)
        then begin
           mois[2]:=29;
           bissex:=1;
        end;
        if signe=-1
        then
           nbjours:=365+bissex-nbjours;
        i:=1;

         while (nbjours >= 0)
         do begin
            nbjours:=nbjours-mois[i];
            inc(i);
         end;
         MoisTrouve:=i-1;        { le mois est trouve }

                       { trouver le jour }
         if nbjours=0
         then
            nbjours:=-1;
         JourTrouve:=jourbase+trunc(NbJours+mois[moistrouve]);
      end else
      writeln(m_errdate);
   END;

procedure DATE (j, m, a : integer; Var Err : integer; var nj : integer;
                                                      Var jo, mo : t30);
   { Rle : dterminer le jour de la semaine et le nom du mois pour la date }

   { PARAMETRES
   E       j,m,a    entier. Date Jour,Mois,Anne dont on cherche le "nom".
   S       jo, mo   chaine. Contient le "nom" du jour et du mois en sortie.
   S       nj       numro du jour de la semaine (Lundi = 1)
   S       Err      entier. Flag d'erreur. En sortie vaut :
                     0  si tout s'est bien pass.
                     1  s'il y a eu une erreur dans la procdure JulDate.
                     2  si le nombre de mois m est incorrect.
                     3  si le nombre de jours est incorrect.
                     4  si l'anne est ngative ou nulle.

    DEPENDANCE :  JULDATE.INC}

   Var
      Erreur, Bis       : Integer;
      Nombre            : Real;
      Jour, Annee       : String;
      T                 : Array [1..12] of Integer;

   Begin
        { 0- Code d'erreur}
        Err := 0;
        If a <= 0 then Err := 4; {Anne ngative}
        T[1] := 31; T[3] := 31; T[4] := 30; T[5] := 31; T[6] := 30;
        T[7] := 31; T[8] := 31; T[9] := 30; T[10] := 31; T[11] := 30;
        T[12] := 31;
        If (m < 1) or (m > 12)
        then begin
           Err := 2; m := 1;
        End; {Mois incorrect}
        If (a >= 1582) or (a = 1582) and (m >= 10) or
         (a = 1582) and (m = 10) and (j >= 15) then    {Ere Grgorienne}
        Begin
             If ((a mod 100) = 0) and ((a mod 400) <> 0)
                 or ((a mod 4) <> 0) then T[2] := 28
             Else T[2] := 29;
             If (j < 1) or (j > T[m]) then Err := 3   {Jour incorrect}
        End
        Else
        Begin
             If (a=1582) and (m=10) and (j>5) then Err := 4 {Date inexistante}
             Else If (a mod 4) = 0 then T[2] := 29 else T[2] := 28;
             If (j < 1) or (j > T[m]) then Err := 3   {Jour incorrect}
        End;

        { 1- Initialisation des paramtres}

        If Err = 0
        then Begin
           { 2- Choix d'un jour julien arbitraire connu: 10 avril 1910 }
           {    2418779.5  }

           { 3- Calcul du nombre de jours entre les deux dates j/m/a et j1/m1/a1}

           Nombre := dattojul (j,m,a,Erreur);
           Nombre := Nombre - 2418779.5;

           { 4- Division de ce nombre par 7 pour connatre le jour de la semaine }
           {    (reste de la division par 7)                                     }
           If Erreur = 0
           then Begin
                Nj := trunc(Round(Nombre) mod 7);
                If Nj < 0 then Nj := Nj + 7;

                { 5- Concatnation de la date dans la chane de caractres}

                Case Nj of
                     0 : jo := jo1;
                     1 : jo := jo2;
                     2 : jo := jo3;
                     3 : jo := jo4;
                     4 : jo := jo5;
                     5 : jo := jo6;
                     6 : jo := jo7;
                End;
                Nj := Nj + 1;
                Case m of
                   1 : mo := mo1;
                   2 : mo := mo2;
                   3 : mo := mo3;
                   4 : mo := mo4;
                   5 : mo := mo5;
                   6 : mo := mo6;
                   7 : mo := mo7;
                   8 : mo := mo8;
                   9 : mo := mo9;
                  10 : mo := mo10;
                  11 : mo := mo11;
                  12 : mo := mo12;
               End;
           End
           Else Err := 1;  {Erreur <> 0; Il y a une erreur au cours de NbJours}
        End
   End;

function nomfdefo (nomm, nomf, nomu : string) : namestr;
   {               module, nomfpar, nomutil }
   var
      l, p              : integer;
      ch                : string;

   begin
      l  := length (nomu);
      sousch (nomu, 1, ' ', ch, p);
      ch := copy (nomu, p, l+1-p);
      if length (ch) > 4
      then
         ch := copy (ch, 1, 4);
      nomfdefo := nomm+ch;
   end;

function souschaine (ch1 : string; avant, apres : car) : string;
   var
      i, lg             : integer;
      sch               : string;
      c                 : car;

   begin
      i := 0;
      if avant <> ''
      then
         repeat
            i := i+1;
            c := copy (ch1, i, 1);
         until c = avant;
      lg  := 0;
      sch := '';
      repeat
         i   := i+1;
         lg  := lg+1;
         c   := copy (ch1, i, 1);
         sch := concat (sch, c);
      until (c = apres) or (i > length (ch1));
      souschaine := copy (sch, 1, lg-1);
   end;

procedure enlev_blancs (var ch : string);
   var
      l                 : integer;

   begin
      l  := length (ch);
      while ch [l] = ' '
      do begin
         l  := l-1;
         ch := copy (ch, 1, l);
      end;
   end;

procedure e_b (var ch : string);
      var
         l              : integer;

      begin
         l := length (ch);
         while ch [l] = ' '
         do begin
            l  := l-1;
            ch := copy (ch, 1, l);
         end;
      end;

procedure e_b_devant (var ch : string);
   var
      l                 : integer;

   begin
      l := length (ch);
      while (ch [1] = ' ') and ( l > 1)
      do begin
         l  := l-1;
         ch := copy (ch, 2, l);
      end;
   end;

procedure sousch (ch1 : string; p : integer; apres : car;    { en entree}
             var ssch : string; var ppos : integer);         { en sortie}
   var
      i, l, lg          : integer;

   begin
      l  := length (ch1);
      i  := p;
      lg := 0;
      while (ch1 [i] <> apres) and (i <= l)
      do begin
         inc (i);
         inc (lg)
      end;
      ssch := copy (ch1, p, lg);

      if i > l
      then ppos := l+1
      else ppos := i+1
   end;

procedure inverse (var s : string);
   var
      s2                : string;
      i                 : word;

   begin
      s2 := '';
      i  := length (s);
      repeat
         s2 := s2 + s[i];
         dec (i);
      until i = 0 ;
      s := s2;
   end;

procedure beep;
   begin
      sound (100);
      sound (80);
      delay (40);
      nosound;
   end;

procedure zap;
   var
      i                 : integer;

   begin
      for i := 100 to 500
      do
         sound (i);
      nosound;
   end;

procedure Tilt;
   var
      i                 : integer;

   Begin
      for i := 1 to 10
      do begin
         sound (300);
         delay (1);
         sound (100);
         delay (1);
      end;
      delay (500);
      nosound;
   End;

procedure attente;
   var
      ch                : char;

   begin
      sound (200); delay (30); nosound;
      repeat until keypressed;
      ch := readkey;
   end;

procedure cristalise (xmin, ymin, xmax, ymax, lim : integer);
   var
      x, y, d, c        : integer;

   function distance (x, y : integer) : integer;
      var
         test           : boolean;
         dd, v          : integer;

      begin
         test := true;
         dd   := 1;
         repeat
            for v := 0 to dd*2
            do
               if    (getpixel (x-dd,   y-dd+v) = 0)
                  or (getpixel (x+dd,   y-dd+v) = 0)
                  or (getpixel (x-dd+v, y-dd)   = 0)
                  or (getpixel (x-dd+v, y+dd)   = 0)
               then begin
                  distance := dd;
                  test := false
               end;
            dd := dd+1;
            if dd > lim
            then test := false;
         until not test
      end;

   begin
      for y := ymin to ymax
      do
         for x := xmin to xmax
         do begin
            if getpixel (x, y) <> 0
            then begin
               d := distance (x, y);
               if d = 1
               then putpixel (x, y, 1)
               else begin
                  c := round ((d/lim)*13+2);
                  if c > 15
                  then
                     c := 15;
                  putpixel (x, y, c);
               end;
            end;
         end;
   end;

procedure retourpoint (xmin, ymin, xmax, ymax, bouton : integer;
                       var  xs, ys : integer);
   var
      gauche, droite,
      rep               : boolean;

   begin
      repeat
         until not UnBoutonSourisEnfonce;
      rep := false;
      limiterDeplacementSouris (xmin, ymin, (xmax-xmin), (ymax-ymin));
      MontrerSouris;
      while rep = false
      do begin
         gauche := BoutonSourisEnfonce (BoutonGauche);
         droite := BoutonSourisEnfonce (Boutondroit);
         if (gauche=true) and (bouton=0) then rep := true;
         if (droite=true) and (bouton=1) then rep := true;
      end;
      CacherSouris;
      LirePositionSouris (xs, ys);
      LibererDeplacementSouris;
   end;

procedure def_zone (typ, coul              : word;
                    rapxy                  : real;
                    xmin, ymin, xmax, ymax : integer;
                    var xi, yi, xf, yf     : integer);

   var
      co                : word;
      x, y,
      x1, y1,
      x2, y2,
      compte, entier    : integer;
      gauche,
      droite,
      bool              : boolean;

   begin
      co := getcolor;
      setcolor (coul);
      if (xi < xmin) or (xi > xmax) or (yi < ymin) or (yi > ymax)
      then begin
         x1 := xmin + (xmax-xmin) div 2;
         y1 := ymin + (ymax-ymin) div 2;
      end else begin
         x1 := xi;
         y1 := yi;
      end;

      limiterDeplacementSouris (xmin, ymin, (xmax-xmin), (ymax-ymin));
      MontrerSouris;

      setwritemode     (1);
      if typ < 2
      then begin
         repeat until not UnBoutonSourisEnfonce;
         gauche := false;
         while not gauche
         do begin
            gauche := BoutonSourisEnfonce (BoutonGauche);
            droite := BoutonSourisEnfonce (Boutondroit);
         end;
         lirepositionsouris (x1, y1);
         xi := x1;
         yi := y1;
      end else begin
         x1 := xf;
         y1 := yf;
         gauche := true;
         FixerPositionSouris (x1, y1);
      end;
      CacherSouris;
      CompteurSouris (x, y);
      while gauche or (x1 = xi) or (y1 = yi)
      do begin
         if typ = 3 then line      (xi, yi, x1, y1);
         if typ = 2 then rectangle (xi, yi, x1, y1);
         if typ = 0 then line      (xi-xmin, yi-ymin, x1-xmin, y1-ymin);
         if typ = 1 then rectangle (xi-xmin, yi-ymin, x1-xmin, y1-ymin);
         gauche := BoutonSourisEnfonce (BoutonGauche);
         droite := BoutonSourisEnfonce (Boutondroit);
         compteursouris (x, y);
{        if (x1+x < xmin) or (x1+x > xmax)
            or ((rapxy <> 0) and (round (yi+ ((x1+x-xi) / rapxy)) > ymax))
            or ((rapxy <> 0) and (round (yi+ ((x1+x-xi) / rapxy)) < ymin))
         then x2 := x1
         else x2 := x1+x;   }

         if rapxy = 0
         then begin
            if (x1+x < xmin) or (x1+x > xmax)
            then x2 := x1
            else x2 := x1+x;
         end else begin
            if (x1+x < xmin) or (x1+x > xmax)
               or (round (yi+ ((x1+x-xi) / rapxy)) > ymax)
               or (round (yi+ ((x1+x-xi) / rapxy)) < ymin)
            then x2 := x1
            else x2 := x1+x;
         end;

         if (y1+y < ymin) or (y1+y > ymax)
         then
            y2 := y1
         else
            y2 := y1+y;

         if typ = 3    then line      (xi, yi, x1, y1);
         if typ = 2    then rectangle (xi, yi, x1, y1);
      {   if typ = 2 then MontrerSouris;}
         if typ = 0    then line      (xi-xmin, yi-ymin, x1-xmin, y1-ymin);
         if typ = 1    then rectangle (xi-xmin, yi-ymin, x1-xmin, y1-ymin);
         if rapxy <> 0
         then
            y2 := round (yi+ ((x2-xi) / rapxy));
         x1 := x2;
         y1 := y2;
      end;
      if typ < 2
      then begin
         xf := x1-xmin;
         yf := y1-ymin;
         xi := xi-xmin;
         yi := yi-ymin;
      end else begin
         xf := x1;
         yf := y1;
      end;
      FixerPositionSouris (x1, y1);
      setwritemode  (0);
      setcolor      (co);
      LibererDeplacementSouris;
   end;

procedure dep_rec (var x0, y0 : integer; lx, ly : integer);
   var
      cx, cy,
      xx0, yy0,
      x, y, xs, ys,
      nul               : integer;
      g, d              : boolean;

   begin
      xx0 := x0;
      yy0 := y0;
      setwritemode (1);
      compteursouris (cx, cy);
      repeat
         rectangle (x0, y0, x0+lx, y0+ly);
         x := x0;
         y := y0;
         g := BoutonSourisEnfonce (BoutonGauche);
         d := BoutonSourisEnfonce (Boutondroit);
         compteursouris (cx, cy);
         x0 := x0+cx;
         y0 := y0+cy;
         if x0 < 0 then x0 := 0;
         if y0 < 0 then y0 := 0;
         if x0 > maxx-lx then x0 := maxx-lx;
         if y0 > maxy-ly then y0 := maxy-ly;
         rectangle (x, y, x+lx, y+ly);
      until not g;
      setwritemode (0);
   end;

procedure depl_rec (var x0, y0 : integer; lx, ly : integer);
   var
      xx, yy,
      x, y, dx, dy      : integer;

   begin
      setwritemode (1);
      repeat until not UnBoutonSourisEnfonce;
      MontrerSouris;
      repeat until BoutonSourisEnfonce (BoutonGauche);
      CacherSouris;
      repeat
         xx := x0; yy := y0;
         LirePositionSouris (x0, y0);
         if x0 < 0 then x0 := 0;
         if y0 < 0 then y0 := 0;
         if x0 > maxx-lx then x0 := maxx-lx;
         if y0 > maxy-ly then y0 := maxy-ly;
         if (xx <> x0) or (yy <> y0)
         then begin
            rectangle (xx, yy, xx+lx, yy+ly);   { efface }
            rectangle (x0, y0, x0+lx, y0+ly);   { affiche }
         end;
      until (not BoutonSourisEnfonce(BoutonGauche));
      setwritemode (0);
   end;

procedure affiche_ascenseur_v (bornei, bornef, x, y, ly, lgy, pos : integer);
   var
      l, db, lb, lc,
      d1, d2, d3,
      d4, d5, dx        : integer;

   begin
      setwritemode (0);
      dx := 8 {tx};
      l  := 2*dx;
      lc := l + 2;
      d1 := 2+     l div 6;
      d2 := 2+ 2* (l div 6);
      d3 := 2+ 3* (l div 6);
      d4 := 2+ 4* (l div 6);
      d5 := 2+ 5* (l div 6);
      setfillstyle (1, c_f_boite_norm );
      bar          (x,    y,        x+l,   y+ly);

      setcolor        (c_t_boite_norm );
      rectangle    (x,    y,        x+l,   y+ly);

      setfillstyle (1, c_f_boite_inve );
      bar          (x+2,  y+2,      x+l-2, y+l-1);
      bar          (x+2,  y+ly-l+1, x+l-2, y+ly-2);

      setcolor        (c_t_boite_inve );
      line (x+d3, y+d1, x+d5, y+d3);
      line (x+d5, y+d3, x+d4, y+d3);
      line (x+d4, y+d3, x+d4, y+d5);
      line (x+d4, y+d5, x+d2, y+d5);
      line (x+d2, y+d5, x+d2, y+d3);
      line (x+d2, y+d3, x+d1, y+d3);
      line (x+d1, y+d3, x+d3, y+d1);

      line (x+d3, y+ly-d1, x+d5, y+ly-d3);
      line (x+d5, y+ly-d3, x+d4, y+ly-d3);
      line (x+d4, y+ly-d3, x+d4, y+ly-d5);
      line (x+d4, y+ly-d5, x+d2, y+ly-d5);
      line (x+d2, y+ly-d5, x+d2, y+ly-d3);
      line (x+d2, y+ly-d3, x+d1, y+ly-d3);
      line (x+d1, y+ly-d3, x+d3, y+ly-d1);
      setfillstyle (9, c_f_boite_inve {colord});
      db := bornef-bornei;
      if lgy < 0
      then begin                            { curseur texte }
         lb := dx;
         bar (x+2,   round (y+lc+   (ly-2*lc-lb) * ((pos-bornei) / db)),
              x+l-2, round (y+lc+lb+(ly-2*lc-lb) * ((pos-bornei) / db)));
      end else begin
         bar (x+2,   y+lc+pos,
              x+l-2, y+lc+pos+lgy);
      end;
   end;

procedure affiche_ascenseur_h (bornei, bornef, x, y, lx, lgx, pos : integer);
   var
      l, lc, db, lb,
      d1, d2, d3,
      d4, d5, dx        : integer;

   begin
      setwritemode (0);
      dx := 8 {tx};
      l  := 2*dx;
      lc := l + 2;
      d1 := 2 +      l div 6;
      d2 := 2 + 2 * (l div 6);
      d3 := 2 + 3 * (l div 6);
      d4 := 2 + 4 * (l div 6);
      d5 := 2 + 5 * (l div 6);

      setfillstyle (1, c_f_boite_norm );
      bar          (x,        y,   x+lx,   y+l);

      setcolor     (c_t_boite_norm );
      rectangle    (x,        y,   x+lx,   y+l);

      setfillstyle (1, c_f_boite_inve );
      bar          (x+2,      y+2, x+l-1,  y+l-2);
      bar          (x-l+lx+1, y+2, x+lx-2, y+l-2);

      setcolor        (c_t_boite_inve );
      line (x+d1, y+d3, x+d3, y+d5);
      line (x+d3, y+d5, x+d3, y+d4);
      line (x+d3, y+d4, x+d5, y+d4);
      line (x+d5, y+d4, x+d5, y+d2);
      line (x+d5, y+d2, x+d3, y+d2);
      line (x+d3, y+d2, x+d3, y+d1);
      line (x+d3, y+d1, x+d1, y+d3);
      line (x+lx-d1, y+d3, x+lx-d3, y+d5);
      line (x+lx-d3, y+d5, x+lx-d3, y+d4);
      line (x+lx-d3, y+d4, x+lx-d5, y+d4);
      line (x+lx-d5, y+d4, x+lx-d5, y+d2);
      line (x+lx-d5, y+d2, x+lx-d3, y+d2);
      line (x+lx-d3, y+d2, x+lx-d3, y+d1);
      line (x+lx-d3, y+d1, x+lx-d1, y+d3);
      setfillstyle (9, c_f_boite_inve {colord});
      { lb := dx;        curseur simple
      bar (round (x+l+2+    (lx-2*l-4-lb) * ((pos-bornei) / (bornef-bornei)))
                 , y+2,
           round (x+l+2+lb+ (lx-2*l-4-lb) * ((pos-bornei) / (bornef-bornei)))
                 , y+l-2);               }
      db := bornef-bornei;                       { course }
      if lgx < 0
      then begin                              { curseur texte }
         lb := dx ;
         bar (round (x+lc+    (lx-2*lc-lb) * ((pos-bornei) / db)), y+2,
              round (x+lc+lb+ (lx-2*lc-lb) * ((pos-bornei) / db)), y+l-2);
      end else begin                           { curseur barre }
         bar (round (x+lc+pos),     y+2,
              round (x+lc+pos+lgx), y+l-2);
      end;
   end;

procedure ascenseur_v (bornei, bornef, x, y, ly, lgy : integer ;
                       var pos, Touche : integer);
   var
      l, i,
      dx, db,
      lb, lc            : integer;

   begin
      dx := 8 {tx};
      l  := 2*dx;
      lc := l+2;
      MontrerSouris;

      clavsourisFleches (touche);

      LirePositionSouris (xs, ys);
      CacherSouris;
      setcolor        (c_t_boite_norm );
      setfillstyle (1, c_f_boite_norm );
      if     (xs > x) and (xs < x+l) and (ys > y) and (ys < y+ly)
          or (Touche = FleB) or (Touche = FleH) or (Touche = PgUp)
          or (Touche = PgDn)
      then begin
         bar (x+1, y+l+1, x+l-1, y+ly-l-1);  { effacement curseur }
         if  ((ys < y+l) and (touche = 0)) or (touche = FleH)   { flche haute }
         then begin
            pos := pos-1;
            if pos < bornei then pos := bornei;
         end;

         if ((ys > y+ly-l) and (touche = 0)) or (touche = FleB)  { flche basse }
         then begin
            pos := pos+1;
            if pos > bornef then pos := bornef;
         end;

         db := bornef-bornei ;                { barre dfil }

         if (Touche = 0) and (ys > y+l+1) and (ys < y+ly-l-1)
         then
            pos := trunc (bornei+ db*((ys-y-lc) / (ly-2*lc-dx)));

         if Touche = PgUp
         then begin
            pos := pos - lgy;
            if pos < bornei then pos := bornei;
         end;

         if Touche = PgDn
         then begin
            pos := pos + lgy;
            if pos < bornei then pos := bornei;
         end;

         if pos < bornei then pos := bornei;
         if pos > bornef then pos := bornef;

         setfillstyle (9, c_f_boite_inve);

         if lgy < 0
         then begin
            lb := dx ;                         { curseur texte }
            bar (x+2,   round (y+l+2+   (ly-2*lc-lb) * ((pos-bornei)/db)),
                 x+l-2, trunc (y+l+2+lb+(ly-2*lc-lb) * ((pos-bornei)/db)));
         end else begin                         { curseur barre }
            lb := trunc ((ly - 2*lc) * (lgy / db));
            bar (x+2,   y+lc+pos,
                 x+l-2, y+lc+pos+lgy);
         end;
      end;
   end;

procedure ascenseur_h (bornei, bornef, x, y, lx, lgx : integer ;
                       var pos, Touche : integer);
   var
      l, i,
      dx, db,
      lb, lc         : integer;

   begin
      dx := 8 {tx};
      l  := 2*tx;
      lc := l+2;
      MontrerSouris;
      clavsouris (Touche);
      LirePositionSouris (xs, ys);
      CacherSouris;
      setcolor        (c_t_boite_norm );
      setfillstyle (1, c_f_boite_norm );
      if     (xs > x) and (xs < x+lx)
         and (ys > y) and (ys < y+l)
      then begin
         bar (x+1+l, y+1, x+lx-l-1, y+l-1);  { effacer curseur }
         if  (xs < x+l)                      { flche Gauche }
         then begin
            pos := pos-1;
            if pos < bornei then pos := bornei;
         end;

         if (xs > x+lx-l)                     { flche Droite }
         then begin
            pos := pos+1;
            if pos > bornef then pos := bornef;
         end;
         db := bornef-bornei;
                                              { barre dfilement }
         if (xs > x+l+1) and (xs < x+lx-l-1)
         then
            pos := trunc (bornei+db *((xs-(x+lc)) / (lx-2*lc-dx)));

         if pos < bornei then pos := bornei;
         if pos > bornef then pos := bornef;

         setfillstyle (9, c_f_boite_inve);

         if lgx < 0
         then begin
            lb := dx ;                              {   curseur texte }
            bar (round (x+lc+    (lx-2*lc-lb) * ((pos-bornei) / db)), y+2,
                 trunc (x+lc+lb+ (lx-2*lc-lb) * ((pos-bornei) / db)), y+l-2);
         end else begin
            lb := trunc ((lx - 2*lc) * (lgx / db));   {   curseur barre       }
            bar (x+lc+pos,    y+2,
                 x+lc+pos+lgx, y+l-2);
         end;
      end;
   end;

procedure Letat2 (t : chainecar; p, lg : integer; c1, c2 : word);
   begin
      coulbar (1, c1);
      bar       (p*tx,       maxy-(3*ty)- dd0,
                 p*tx+lg*tx, maxy- 2*ty - dd0);

      setcolor  (numcouleur (nomcouleur(c2)));
      outtextxy (p*tx+d0,    maxy-(3*ty)- dd0+1, t);
   end;

procedure Letat (t : chainecar; p, lg : integer);
   begin
      coulbar   (1, c_f_boite_norm {colord});
      bar       (p*tx,       maxy-2*ty-1,
                 p*tx+lg*tx, maxy-  ty-1);
      setcolor  (colorf);
      outtextxy (p*tx+d0,    maxy-2*ty+1,  t);
   end;

procedure Laide (t : longchaine);
   var
      c              : word;

   begin
      c := getcolor;
      coulbar      (1, c_barre);                  { fondaide }
      bar          (0,  maxy - ty, maxx, maxy);
      setcolor     (couleurnum (c_t_boite_norm)); { texte aide }
      settextjustify (1, 2);
      outtextxy    (maxx div 2, maxy-ty + 1, t);

    {  setcolor     (colord);
      line         (0, maxy-ty, maxx, maxy-ty);} { utilis dans ETIGEN }
      setcolor     (c);
      settextjustify (0, 2);
   end;

procedure message (texte : longchaine);
   var
      t                 : pointer;
      Code,
      xi, yi,
      x, y, l, h        : integer;
      Touche            : boolean;

   begin
      laide (la_fermer);
      repeat until not UnBoutonSourisEnfonce;
      if length (texte) < 4
      then
         l := 4*tx+8
      else
         l := textwidth (texte)+8;
      h := 5*ty;
      if posxbtn=0
      then begin
         x := trunc ((maxx - l - 4)    / 2);
         y := trunc ((maxy - h + 4)    / 2);
      end else begin
         x := trunc ((posxbtn - l - 4) / 2);
         y := trunc ((maxy - h + 4)    / 2);
      end;
      getmem       (t, imagesize (x, y, x+l+3, y+4*ty+3    ));
      getimage     (              x, y, x+l+3, y+4*ty+3, t^);
      setcolor     (colord);

      setfillstyle (SolidFill, colord);
      rectangle    (x+1, y+1,      x+l+2,  y+4*ty+2);
      bar          (x+1, y+1,      x+l+2,  y+2*ty+1);
      setcolor     (colorf);
      rectangle    (x,   y,        x+l+3,  y+4*ty+3);

      setfillstyle (SolidFill, c_f_boite_norm);
      bar          (x+2, y+2*ty+2, x+l+1, y+4*ty+1);
      settextjustify (1, 1);
      outtextxy    (x+l div 2, y+ty, texte);
      setcolor     (c_t_boite_norm);
      rectangle    (x+3, y+3+2*ty, x+l,   y+4*ty);
      outtextxy    (x+l div 2, y+3*ty, 'OK');
      settextjustify (0, 2);

      Code := 0;
      MontrerSouris;
      repeat
         touche := ToucheClavier (Code);
      until UnBoutonSourisEnfonce or (Code=CR) or (Code=ESC);
      CacherSouris;

      putimage (x,  y,  t^, NormalPut);
      libere   (t);
      laide    ('');
   end;

procedure message3 (t1, t2, t3 : longchaine);
   var
      tt                : longint;
      t                 : pointer;
      l1, l2,
      l3, l4,
      maxl,
      Code,
      xi, yi,
      x, y, l, h        : integer;
      Touche            : boolean;
      t4                : string [2];

   begin
      t4 := 'OK' ;
      l1 := textwidth (t1);
      l2 := textwidth (t2);
      l3 := textwidth (t3);
      l4 := textwidth (t4);
      maxl := l4;
      if (l1 <= l4) and (l2 <= l4) and (l3 <= l4)
      then
         maxl := l4
      else begin
         if l1 > maxl then maxl := l1;
         if l2 > maxl then maxl := l2;
         if l3 > maxl then maxl := l3;
      end;
      laide (la_fermer);
      repeat until not UnBoutonSourisEnfonce;
      l := maxl+8;
      h := 7*ty;
      if posxbtn = 0
      then begin
         x := trunc ((maxx - l - 4)    / 2);
         y := trunc ((maxy - h + 4)    / 2);
      end else begin
         x := trunc ((posxbtn - l - 4) / 2);
         y := trunc ((maxy - h + 4)    / 2);
      end;
      tt := imagesize (x, y, x+l+3, y+6*ty+3    );
      if tt > memavail
      then
         exit;

      getmem       (t, tt);
      getimage     (x, y, x+l+3, y+6*ty+3, t^);
      setcolor     (colord);
      setfillstyle (SolidFill, colord);

      rectangle    (x+1, y+1,      x+l+2,  y+6*ty+2);
      bar          (x+1, y+1,      x+l+2,  y+4*ty+1);
      setcolor     (colorf);
      rectangle    (x,   y,        x+l+3,  y+6*ty+3);

      setfillstyle (SolidFill, c_f_boite_norm);
      bar          (x+2, y+4*ty+2, x+l+1, y+6*ty+1);
      settextjustify (1, 1);
      outtextxy    (x+l div 2, y+ty,   t1);
      outtextxy    (x+l div 2, y+2*ty, t2);
      outtextxy    (x+l div 2, y+3*ty, t3);

      setcolor     (c_t_boite_norm);
      rectangle    (x+3, y+3+4*ty, x+l,   y+6*ty);
      outtextxy    (x+l div 2, y+5*ty, t4);
      settextjustify (0, 2);

      Code := 0;
      MontrerSouris;
      repeat
         touche := ToucheClavier (Code);
      until UnBoutonSourisEnfonce or (Code = CR) or (Code = ESC);
      CacherSouris;

      putimage (x,  y,  t^, NormalPut);
      libere   (t);
      laide    ('');
   end;

procedure question  (texte1, texte2 : longchaine ; var reponse : boolean);
   var
      b, r              : pointer;
      tailleb,
      tailleR           : word;

      reponsei,
      ch, ok,
      touche, clic      : boolean;
      x, y,
      xoui, xnon,
      l, th ,xi, yi,
      ld2,
      Code              : integer;

   procedure afficherOuiNon;
      var
         dx,
         yh             : integer;

      begin
         dx :=  ld2 div 2 ;
         yh :=  y + 2*th div 3 + 7;
         if not reponse
         then begin
            setfillstyle (SolidFill, c_f_boite_norm);
            setcolor                (c_t_boite_norm);
            bar (xoui+1, y+3*ty+1, xnon-1, y+th-1);
            outtextxy    (xoui + dx, yh, OUI);

            setfillstyle (SolidFill, c_f_boite_inve);
            setcolor                (c_t_boite_inve);
            bar (xnon+3, y+3*ty+4, x+l-4,  y+th-4);
            outtextxy    (xnon + dx, yh, NON);
         end else begin
            setfillstyle (SolidFill, c_f_boite_inve);
            setcolor                (c_t_boite_inve);
            bar (xoui+4, y+3*ty+4, xnon-4, y+th-4);
            outtextxy    (xoui + dx, yh, OUI);

            setfillstyle (SolidFill, c_f_boite_norm);
            setcolor                (c_t_boite_norm);
            bar (xnon, y+3*ty+1, x+l-1,  y+th-1);
            outtextxy    (xnon + dx, yh, NON);
         end;
      end;

   begin
      if not copie_en_cours
      then
         laide (la_fleches);
      if length (texte1) >= length (texte2)
      then
         l := textwidth (texte1)
      else
         l := textwidth (texte2);

      if l > 14*tx
      then
         l := l+14
      else
         l := 14*tx+14;

      ld2  := l div 2;
      th   := 5*ty+6;
      if posxbtn = 0
      then begin
         x    := trunc ((maxx-l)  / 2);
         y    := trunc ((maxy-th) / 2);
      end else begin
         x    := trunc ((posxbtn-l)/ 2);
         y    := trunc ((maxy-th)  / 2);
      end;
      xoui := x;
      xnon := x + ld2;

      tailleb  := imagesize (x, y, x+l, y+th);
      getmem       (b, tailleb);
      getimage              (x, y, x+l, y+th, b^);
      tailler  := imagesize (0, 0, ld2-8, 2*ty-1);
      getmem       (r, tailler);

      setfillstyle (SolidFill, colorf);
      bar          (x, y, x+l, y+th);

      setfillstyle (SolidFill, colord);
      bar          (x, y, x+l, y+3*ty);

      setfillstyle (SolidFill, c_f_boite_norm);
      bar          (x, y+3*ty+1, x+l, y+th-1);

      setcolor (colorf);
      settextjustify (1, 1);
      outtextxy    (x+ld2, y +th div 6, texte1);
      outtextxy    (x+ld2, y +th div 3, texte2);

      setcolor     (c_t_boite_norm );
      rectangle    (x , y     , x+l , y+th);

      reponsei := reponse;
      AfficherOuiNon;

      ok   := false;
      ch   := false;
      clic := false;
      g := false;
      d := false;
      repeat until not UnBoutonSourisEnfonce;
      repeat
         Code := 0;
         MontrerSouris;
         repeat
            Touche := ToucheClavier (Code);
         until UnBoutonSourisEnfonce or
               (Code = CR)   or (Code = ESC) or
               (Code = FleD) or (Code = FleG) or
               (code = ord ('N')) or (code = ord ('n')) or
               (code = ord ('Y')) or (code = ord ('y')) or
               (code = ord ('O')) or (code = ord ('o'));

         g := g or BoutonSourisEnfonce (BoutonGauche);
         d := d or BoutonSourisEnfonce (BoutonDroit);

         if touche
         then begin
            if (Code = FleD) or (code = ord ('N')) or (code = ord ('n'))
            then begin
               reponse := false;
               Ch      := true;
            end;
            if (Code = FleG) or (code = ord ('O')) or (code = ord ('o'))
                             or (code = ord ('Y')) or (code = ord ('y'))
            then begin
               reponse := true;
               Ch      := true;
            end;
         end else begin
            LirePositionSouris (xs, ys);
            if (xs > xnon)     and (xs < xnon+ld2) and
               (ys > y+3*ty+3) and (ys < y+th)
            then begin
               clic := true;
               if reponse
               then begin
                  ch      := true;
                  reponse := false
               end;
            end;

            if (xs > xoui-3)   and (xs < xnon-6) and
               (ys > y+3*ty+3) and (ys < y+th)
            then begin
               clic := true;
               if not reponse
               then begin
                  ch      := true;
                  reponse := true
               end;
            end;
         end;
         CacherSouris;
         if ch
         then
            AfficherOuiNon;

      until (Code = CR) or (Code = ESC) or clic;

      if (code = ESC) or d
      then
         reponse := reponsei;

      settextjustify (0, 2);
      putimage (x, y, b^, NormalPut);
      FreeMem   (b, TailleB);
      FreeMem   (r, TailleR);
      if not copie_en_cours
      then
         laide ('');
   end;

{---------------------------------------------------------------------------}

BEGIN

   new      (listchaine);
   prg_menu := False;

END.

{---- UTILDIVS ---------------------------------------------- ARX - BALMA --}
