UNIT GRAPHSG;

   {------------------------------------------------------------------------}
   { GRADUATIONS extrieures et polices de symboles                         }
   { Visualisation de Symboles Graphiques          commence       20/10/92 }
   {                                               rvise le      30/01/93 }
   {                                               rvise le      25/09/93 }
   {                                                                        }
   {                                                                        }
   {                                                                        }
   {------------------------------------------------------------------------}
   { A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA }
   {------------------------------------------------------------------------}

   { visualisation de Symboles Graphiques dans toutes les positions
     sur cran et traceur.
     Compatibles avec les symboles gnrs par SURFER\ALTERSYM
     (Golden Software)                                                      }
(*
   Graphsg,                  { ARX     - symboles et graduations            }
*)

INTERFACE

USES
   dos,
   graph,                    { TP 55   - units standard              }
   Graphism,                 { ARX     - initialisations graphiques   }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur   }
   Fctmath;                  { ARX     - fonctions mathmatiques      }

CONST
   maxsymb              = 96;

{---------------------------------------------------------------------------}

Procedure initialiser_jeu_symb
                             (nomfc  : pathstr;
                              police : byte);
   { initialise le jeu de symboles centrs dans SYMBOL }

Procedure liberer_jeu_symb   (police : byte);
   { libre tous les pointeurs d'un jeu de symboles }

Procedure initialiser_parametres_courants
                             (police                  : byte;
                              taille, direction, incl : real;
                              refhauteur              : integer);
   { initialise les paramtres du symbole courant }
   { taille en mm; direction et incl en degrs    }

Procedure initialiser_parametres_symbct
                             (police               : byte;
                              taille, dx, dy, incl : real;
                              refhauteur           : integer);
   { initialise les paramtres du symbole courant }
   { taille en mm; dpl en X et en Y ; incl en degrs; dx <> 0  }
   { dx, dy : dfinissent la direction }

Function longueur_texte      (texte : string)              : real;
   { rend la dimension du TEXTE recalcule en fonction de ECHS  }

Function hauteur_texte                                     : real;
   { repre utilisateur }

Procedure dessine_un_symb    (nums_ct : integer);
   { dessine le symbole (codaski 32..95) spcifi  la position courante,
     params.  cts }

Procedure ecrire_texte       (texte : string);
   { recalcule et dessine la suite de symboles TEXTE }

Procedure ecrire_symb_ct     (texte : string ; alfa : real);
   { recalcule la direction ; inclinaison et jeu courants }
   { dcale le point de dpart : centr en hauteur }
   { recalcule et dessine la suite de symboles TEXTE }

Procedure justifie_texte     (texte      : string ;
                              h, v       : byte;
                              var mx, my : real);
   { justifie le texte dans la direction courante                           }
   { recalcule et dessine la suite de symboles TEXTE                        }
   { h et v doivent avoir les mmes valeurs que SETJUSTIFY                  }

Procedure etiquette_crb      (x, y, t, d : real;
                              c          : word;
                              ch         : string);
   { Dessine une tiquette su une courbe - fond effac sur l'cran dans la
     couleur de la bote.
     x, y  coord utilisateur
     t     taille en mm
     d     direction en ?
     c     couleur
     ch    texte                                                          }

{---------------------------------------------------------------------------}

Procedure prep_graduation_2d (var px, py, dx, dy : real);
   { calcule les valeurs de la cloture en mm }

Procedure grad_ext_xy        (sens : integer; { sens }
                              px,             { coin g graphe mm }
                              py,             { coin g }
                              dx,             { largeur cartouche mm }
                              dy,             { hauteur cartouche (0 si 2d)}
                              ht   : real;    { hauteur totale }
                              coul : word);
   { dessine ou efface le rectangle occup par les graduations ext. }

Procedure graduer_xy         (sens,           {   1 -> X ,      -1 -> Y }
                              px,             { coin g graphe mm }
                              py,             { coin g }
                              dx,             { largeur cartouche mm }
                              dy,             { hauteur cartouche (0 si 2d) }
                              minf,           { min fentre graduation }
                              maxf,           { max                    }
                              interetiq,      { intervalle entre tiqs}
                              htir            { hauteur tiret mm }
                                        : real;
                              nbetic,         { nb tirets intermdiaires }
                              nbd       : integer;   { nb dcimales }
                              coul,           { axe, tirets int. et titres }
                              couletiq        { tiquettes et tirets pp }
                                        : word;
                              police    : byte;
                              taille    : real;      { taille en mm }
                              titre     : string);   { titre axe }

   { dessine une lgende gradue non directement lie  un graphique }

Procedure dessymb            (police : byte;
                              s      : integer;
                              h      : real;
                              co     : word);
   { dessine un seul symbole }

Procedure calc_point_suivant (var dx, dy : real);
   { rotation }

Procedure calculer_direction (dx, dy : real;
                              var dr : real);
   { }

{---------------------------------------------------------------------------}

IMPLEMENTATION

CONST
   coefpi               = 0.01745329252; { pi/180 }

TYPE
   surpcalc             = ^t_pcalc;       { pointe sur une liste de points }
   t_pcalc              = record          { liste des points d'un symboles }
                             x, y      : real;       { coordonnes         }
                             mvt       : byte;       { lev/baiss         }
                             suiv      : surpcalc;   { point suivant       }
                          end;

   surpoint             = ^t_point;       { pointe sur une liste de points }
   t_point              = record          { liste des points d'un symboles }
                             x, y      : integer;    { coordonnes         }
                             mvt       : byte;       { lev/baiss         }
                             suiv      : surpoint;   { point suivant       }
                          end;

   sursymb              = ^t_symb;        { pointe sur un symbole          }
   t_symb               = record                    { un symbole           }
                             nbp,                   { nombre de points     }
                             lsg,                   { largeur              }
                             hsg       : byte ;     { hauteur              }
                             points    : surpoint;  { descr. des mouvements}
                          end;

   tab_symb
                        = array [1..maxsymb] of sursymb;


VAR
   f_symb               : file of byte;

   jeu1,                               { police texte                       }
   {jeu2,}                             { police texte titres                }
   jeu3,                               { symboles divers                    }

   jeu_ct               : tab_symb;    { jeu de symboles courant            }

   h_symb, l_symb,                     { dimensions grille du symbole rf   }
   dirr, inclr,                        { direction, inclinaison en radians  }
   unitxy,                             {                                    }
   echs,                               { chelle symbole courant /papier    }
   dex, dey
                        : real;

   symb_ct              : surpcalc;    { symbole courant                    }

   sensy,
   nums_ct              : integer;     { numero ascii du symbole courant    }


procedure police_cte (pol : byte);
   begin
      case pol of
        1 : jeu_ct := jeu1;
{        2 : jeu_ct := jeu2;}
        3 : jeu_ct := jeu3;
      end;
   end;

procedure calculer_direction   (dx, dy : real; var dr : real);
   begin
      dirr  := arctangente (dy, dx);
      dr := dirr;
   end;

procedure calc_point_suivant (var dx, dy : real);   { rotation }
   const
      ech               =  1;

   var
      a,  b,
      c,  d,
      x1, y1            : real;

   begin
      x1 := dx;   y1 := dy;
      a  := ech;  c  := 0;
      b  := 0;    d  := a;
      if dirr <> 0
      then begin
         a :=  cos (dirr) * a;
         b := -sin (dirr) * ech;
         c := -b;
         d :=  a;
      end;
      dx :=   x1 * a + y1 * c;
      dy := -(x1 * b + y1 * d);
   end;

procedure tracer_axe (x, y, dx, dy : real; c : word);
   begin
      fixecoul   (c);
      deplaceenl (x,    y);
      tracevers  (x+dx, y+dy);
      deplaceenl (x,    y);
   end;

procedure prep_graduation_2d (var px, py, dx, dy: real);
   { calcule les valeurs de la cloture en mm }
   begin
      px := xgclot          * coef_mm_unit;         { pos clture cte en mm }
      py := ybclot          * coef_mm_unit;
      dx := (xdclot-xgclot) * coef_mm_unit;         { dim clture cte en mm }
      dy := (yhclot-ybclot) * coef_mm_unit;
   end;

procedure grad_ext_xy ( sens : integer;       { sens                        }
                          px,                 { coin g graphe mm            }
                          py,                 { coin g                      }
                          dx,                 { largeur cartouche mm        }
                          dy,                 { hauteur cartouche (0 si 2d) }
                          ht   : real;        { hauteur totale              }
                          coul : word);
   var
      ddx, ddy, x, y    : real;

   begin
      calculer_direction (dx, dy, dirr);               { met  jour DIRR }
      fixecoul   (coul);
      deplaceenl (px,    py);
      x   := px+dx;
      y   := py+dy;
      tracevers  (x,  y);
      ddx := 0;
      ddy := ht * sens;

      calc_point_suivant (ddx, ddy);
      x := x + ddx;
      y := y + ddy;
      tracevers  (x,  y);

      deplaceenl (px, py);
      x := px + ddx;
      y := py + ddy;
      tracevers  (x,  y);

      x := x + dx;
      y := y + dy;
      tracevers  (x,  y);

      deplaceenl (px, py);
   end;

procedure graduer_xy (  sens,                    {   1 -> X ,      -1 -> Y   }
                        px,                      { coin g graphe mm          }
                        py,                      { coin g                    }
                        dx,                      { largeur cartouche mm      }
                        dy,                      { hauteur (~ 0 si 2d)       }
                        minf,                    { min fentre graduation    }
                        maxf,                    { max                       }
                        interetiq,               { intervalle entre tiquettes
                                                   repre utilisteur         }
                        htir                     { hauteur tiret mm          }
                                  : real;
                        nbetic,                  { nb tirets intermdiaires  }
                        nbd       : integer;     { nb dcimales              }
                        coul,                    { axe, tirets et tiquettes }
                        couletiq                 { texte axes                }
                                  : word;
                        police    : byte;
                        taille    : real;        { taille symb en mm         }
                        titre     : string);     { titre axe                 }

   const
      epsi              = 1E-5;

   var
      i                 : integer;
      ch                : string;
      orig,  dirr,
      etiq,  etiqi,
      interetiqi,
      detiq,
      corr,  corri,
      ppx,   ppy,
      xetic, yetic,
      x1, y1,
      x2, y2,
      dx0
                        : real;

   procedure tiret (ppx, ppy, xe, ye : real);
      begin
         calc_point_suivant (ppx,       ppy);
         x1   := x1+ppx;
         y1   := y1+ppy;
         deplaceen (x1, y1);                                  { base tiret  }
         calc_point_suivant (xe,        ye);                  { forme tiret }
         x2   := x1+xe;
         y2   := y1+ye;
         tracevers (x2, y2);                                        { tiret }
      end;

   procedure etiquette (xe, ye : real);
      var
         mx, my         : real;
         v, h           : byte;

      begin
         h    := 1;
         v    := 2;
         calc_point_suivant (xe,        ye);           { base texte = tiret }
         x2   := x2 + xe;
         y2   := y2 + ye;
         if sens = -1 then v := 0;
         justifie_texte (ch, h, v, mx, my);            {    dans la cloture }
         mx   := mx / xrap;
         my   := my / yrap;
         deplaceenl      (x2 + mx, y2 + my);                        { texte }
         if dans_fenetre (x2 + mx, y2 + my)
         then ecrire_texte   (ch);
      end;

   procedure titre_axe (t : string; x0, y0 : real);
      var
         xt, yt,
         mx, my         : real;
         v, h           : byte;

      begin
         initialiser_parametres_symbct (police, taille*3/2, dx, dy, 0,  65);
         h    := 1;
         v    := 2;
         calc_point_suivant (x0, y0);
         { base texte = coin g }
         xt   := px + x0;
         yt   := py + y0;
         if sens = -1 then v := 0;
         justifie_texte (t, h, v, mx, my);
         mx   := mx / xrap;
         my   := my / yrap;
         deplaceent      (xt + mx, yt + my);                        { titre }
         fixecoul        (couletiq);
       {  if dans_fenetre (xt + mx, yt + my)
         then } ecrire_texte   (t);
      end;

   begin
                                     { travail dans la fentre papier en mm }
      interetiqi := interetiq / (nbetic+1);
      { intervalles tirets intermdiaires }
      tracer_axe (px, py, dx, dy, coul);
      calculer_direction (dx, dy, dirr);         { met  jour DIRR }
      initialiser_parametres_symbct (police, taille, dx, dy, 0,  65);

      if (minf < 0) and (maxf > 0)               { rec origine pour corr }
      then orig := 0
      else orig := minf;

      correctionaxe (orig, minf, interetiqi, corri);
      correctionaxe (orig, minf, interetiq,  corr);
                                                 { correction repre fentre }
      if corr  = interetiq
      then begin
         corr := 0;
         corri := 0
      end;
      if corri = interetiqi
      then corri := 0;
      etiq  := minf + corr ;                     { mini corrig rep. fentre }
      etiqi := minf + corri;
      detiq := DX / (maxf-minf) * interetiq / cos (dirr);
                                                 { dpl entre tiq sur l'axe }
      if sens=1
      then dx0 := dx
      else dx0 := dy;

      ppx   := DX0 / (maxf-minf)  * corri ;                  { correction mm }
      ppy   := 0;    {* sens}
      xetic := 0;                                { recalculer tiret/position }
      yetic := htir * sens;
      x1    := px;
      y1    := py;
      fixecoul (coul);                       { appel ici pour couleur unique }
      repeat
         {if (etiqi >= etiq) or ((etiqi > -0.01) and (etiqi <= 0))}
         if (etiqi > etiq-epsi)  and (etiqi < etiq+epsi)
         then begin                      { BIZARRE :    -1.5 + 1.5 <> 0 !!!  }
            str   (etiq:0:nbd, ch);                      { nombre  afficher }
            if nbd < 0 then ch := '';
            tiret (ppx, ppy,  xetic, yetic);               { tiret principal }
            etiquette        (xetic, 1*sens {yetic/2});            { nombre }
            etiq  := etiq  + interetiq;
            etiqi := etiqi + interetiqi
         end else begin
            tiret (ppx, ppy,  xetic, yetic/2);            { tiret secondaire }
            etiqi := etiqi + interetiqi;
         end;

         if nbetic > 0
         then begin
            ppx  := detiq / (nbetic+1);                { intervalle suivant }
            ppy  := 0;
         end else begin
            ppx  := detiq;                             { intervalle suivant }
            ppy  := 0;
         end;
      until etiqi > maxf ;
      titre_axe (titre, dx0/2, taille * sens + yetic * 2 + 2 * sens);
   end;


{---------------------------------------------------------------------------}

function entier (oct : byte) : integer;
   begin
     if oct > 127
     then entier := oct-256
     else entier := oct;
   end;

procedure initialiser_jeu_symb ( nomfc : pathstr ; police : byte);
   { initialise le jeu de symboles centrs dans SYMBOL }

   var
      nums,                           { numro du symbole }
      minh, maxh,
      taillef, i,
      nboctets,                       { taille fichier en octets }
      lgrs              : integer;

      oct,
      nbps                            { nombre de points, pos grille }
                        : byte;

      s_ct              : sursymb;   { symbole courant en cours de lecture }

   procedure creer_point   (var p : surpoint);
      begin
         new (p);
         p^.suiv := nil;
      end;

   procedure lire_point   (var  p : surpoint);
      var
         y              : integer;

      begin
         read (f_symb, oct);  inc (nboctets);  { lecture X }
         p^.x := entier (oct);

         read (f_symb, oct);  inc (nboctets);  { lecture Y }
         y := entier (oct);
         if y < minh then minh := y;
         if y > maxh then maxh := y;
         p^.y := y;

         read (f_symb, oct);  inc (nboctets);  { lecture mouvement }
         p^.mvt := oct; { entier (oct) et byte incompatibles ! }
      end;

   procedure ajouter_point (p : surpoint; var  lp : surpoint);
      begin
         lp^.suiv := p;
      end;

   procedure creer_symbole (var s : sursymb);
      begin
         new (s);
         s^.points  := nil;
      end;

   procedure lire_symbole (s : sursymb ; var nums, nb : integer);
      { charge le symbole NUMS }
      var
         p, p_preced    : surpoint;

         xgg, xgd,
         i              : integer;
         oct            : byte;

      begin
         read (f_symb, oct); inc (nb);
         nums := oct;
         read (f_symb, oct);  inc (nb);
         xgg := entier (oct);
         read (f_symb, oct);  inc (nb);
         xgd := entier (oct);
         read (f_symb, oct);  inc (nb);
         s^.nbp := oct; { entier(oct) plantait ! }
         s^.lsg := byte (xgd - xgg); { xgd-xgg plantait ! }
         minh   :=  256;
         maxh   := -256;

         p_preced := s^.points;
         for i := 1 to s^.nbp
         do begin
            creer_point   (p);
            lire_point    (p);
            ajouter_point (p, p_preced);
            if i = 1 then s^.points := p;
            p_preced := p;
         end;
         s^.hsg := byte (maxh - minh); { maxh-minh plantait ! }
         if s^.nbp = 0 then s^.nbp := s^.lsg;
      end;

   procedure ajouter_symbole (s     : sursymb;
                              nums  : integer
                             );
      begin
         jeu_ct [nums - 31] := s;
      end;

   begin
      for i := 1 to maxsymb
      do
        jeu_ct [i] := nil;
                                       { initialiser le tableau complet }
      filemode := 0;
      assign (f_symb, nomfc);
      reset  (f_symb);
      filemode := 2;
      taillef  := filesize (f_symb);
      nboctets := 0;
      for i := 1 to 3
      do begin
         read (f_symb, oct);
         inc  (nboctets)
      end;                             { en tte du fichier :  3 octets }
      s_ct := nil;
      while { not (eof (f_symb)) and } (nboctets < taillef)
      do begin
         creer_symbole   (s_ct);
         lire_symbole    (s_ct, nums, nboctets);
         ajouter_symbole (s_ct, nums);
      end;
      close (f_symb);
      case police of
         1 : jeu1 := jeu_ct;
        { 2 : jeu2 := jeu_ct;}
         3 : jeu3 := jeu_ct;
      end;
      symb_ct  := nil;           { symbole courant pour calculs successifs }
   end;

procedure calc_ech_symb (taille : real; ref : integer );
   begin
      l_symb := jeu_ct [ref-31]^.lsg;        { largeur du symbole REFrence }
      h_symb := jeu_ct [ref-31]^.hsg;        { hauteur du symbole REF       }

      if taille <> 0
      then
         echs   := taille / h_symb /coef_mm_unit
      else
         echs   := 1;
   end;

procedure liberer_scalc (var s : surpcalc);
   { liberer la liste de points pour calculs successifs }
   var
      p_ct, p_sui       : surpcalc;

   begin
      p_sui  := s;
      p_ct   := s;
      while p_ct <> nil
      do begin
         p_sui := p_ct^.suiv;
         dispose (p_ct);
         p_ct  := p_sui;
      end;
      s := nil;
   end;

procedure recalculer_symbct (nums : integer ;
                             var s_ct : surpcalc ; a, b, c, d : real);
   { cre une structure provisoire S_CT : les coordonnes des points sont
     recalcules en fonction des paramtres courants }
   var
      i, nbps,
      x1, y1            : integer;
      x2, y2            : real;
      p_si              : surpoint;
      p_ct, p_pre       : surpcalc;

   begin
      nbps := jeu_ct [nums-31]^.nbp;
      p_si := jeu_ct [nums-31]^.points;
      if p_si <> nil
      then begin
         new (s_ct);
         x1    := p_si^.x;
         y1    := p_si^.y;
         x2    := x1 * a +y1 * c;
         y2    := x1 * b +y1 * d;
         s_ct^.x    := round (x2);
         s_ct^.y    := round (y2);
         s_ct^.mvt  := p_si^.mvt;
         s_ct^.suiv := nil;
         p_ct  := s_ct;
         p_pre := s_ct;
         p_si  := p_si^.suiv;
      end;
      while p_si <> nil
      do begin
         new (p_ct);
         x1    := p_si^.x;
         y1    := p_si^.y;
         x2    := x1 * a +y1 * c;
         y2    := x1 * b +y1 * d;
         p_ct^.x     := round (x2);
         p_ct^.y     := round (y2);
         p_ct^.mvt   := p_si^.mvt;
         p_ct^.suiv  := nil;
         p_pre^.suiv := p_ct;
         p_pre := p_ct;
         p_si  := p_si^.suiv;
      end;
   end;

procedure transformer_symb (nums     : integer ;
                            var s_ct : surpcalc; dirr, inclr : real);
   { direction   deg = 0 --> horizontale  sens +  --> dirr  radians
     inclinaison deg = 0 --> verticale    sens -  --> inclr radians
     taille      cm  = 0 --> originale /10        --> ech_s (en y)  }

   var
      a, b,
      c, d              : real;                   { matrice transformation  }

   begin
      a := echs;      b := 0;      c := 0;      d := a;       { identit }
      if dirr <> 0
      then begin
         a := cos (dirr) * a ;
         b := sin (dirr) * echs;
         c := -b ;
         d := a ;
      end;

      if inclr <> 0
      then begin
         if dirr <> 0
         then begin
            c := -sin (dirr - inclr) * echs;
            d :=  cos (dirr - inclr) * echs;
         end else
            c :=  sin (inclr)        * echs;
      end;

      recalculer_symbct (nums, symb_ct, a, b, c, d);
   end;

function codel (carac : char) : byte;
   var
      codelp            : byte;

   begin
      if carac in ['']             then codelp := 32;
      if carac in ['']             then codelp := 99;
      if carac in ['','','']     then codelp := 97;
      if carac in ['','','',''] then codelp := 101;
      if carac in ['','']         then codelp := 105;
      if carac in ['','']         then codelp := 111;
      if carac in ['','','']     then codelp := 117;
      if chr (codelp) in ['a','e','i','o','u','c',' ']
      then
         codel := codelp
      else
         codel := ord (carac);
   end;

function codac (carac : char) : byte;
   begin
      if carac in ['']                 then codac := 127;
      if carac in ['']                 then codac := 64;
      if carac in ['']                 then codac := 34;
      if carac in ['','','']         then codac := 96;
      if carac in ['','','','',''] then codac := 94;
      if carac in ['','','','',''] then codac := 124;
   end;

function largeur         (nums : integer) : real;      { repre utilisateur }
   { rend la dimension non recalcule du symbole NUM dans le repre initial,
     jeu courant et paramtres courants taille;
     la direction et l'inclinaison n'interviennent pas }
   begin
      largeur := jeu_ct [nums-31]^.lsg ;
   end;

function hauteur_texte  : real;      { repre utilisateur }
   begin
      hauteur_texte := h_symb * echs ;
   end;

function longueur_texte  (texte   : string)        : real;
   var
      i, nums           : integer;
      lx                : real;

   begin
      lx := 0;
      for i := 1 to length (texte)
      do begin
         nums := ord (texte [i]);
         if nums > 127
         then
            nums := codel (chr (nums));

         if (nums-31 <= maxsymb) and (jeu_ct [nums-31] <> nil)
         then  { le symbole existe }
            lx := lx + largeur (nums);
      end;
      longueur_texte := lx * echs;
   end;

procedure dessiner_symb (nums_ct : integer);
   { numro et jeu de symboles courant, SYMBOLE DEJA RECALCULE
     direction et inclinaison courantes,
     couleur  courante,
     position courante dans la clture courante
     taille en mm  }

   var
      p_ct, p_pre       : surpcalc;

   begin
      if jeu_ct [nums_ct-31]^.points = nil then exit;
      { le symbole ne comporte pas de liste de points  }

      sensy := -1;  { pour travailler directement dans l'espace cloture }
      mover (symb_ct^.x, symb_ct^.y * sensy);
      p_pre := symb_ct;
      p_ct  := symb_ct^.suiv;
      while p_ct <> nil
      do begin
         if p_ct^.mvt = 3
         then
            mover (p_ct^.x - p_pre^.x,
                  (p_ct^.y - p_pre^.y) * sensy)  { lev }
         else
            liner (p_ct^.x - p_pre^.x,
                  (p_ct^.y - p_pre^.y) * sensy); { baiss }
         p_pre := p_ct;
         p_ct  := p_ct^.suiv;
      end;
      mover (0 - p_pre^.x , (0 - p_pre^.y)   * sensy);
   end;

procedure deplace_plume (dx, dy : real) ;
   { dplace la plume dans la direction courante (+dx) et perpend (+dy) }
   {         repre dpend de ECHS            }
   var
      ex, ey            : real;

   begin
      if dirr <> 0
      then begin
         ex :=  cos (dirr) * dx  - sin (dirr) * dy ;
         ey := -sin (dirr) * dx  - cos (dirr) * dy ;
      end else begin
         ey := 0;
         ex := dx;
      end;

      ex := ex * echs;
      ey := ey * echs;
      mover (ex, ey);
      dex  := ex;               { mmoriser dplacement pour l'accent }
      dey  := ey;
   end;

procedure deplacer_symb (nums_ct : integer) ;
   { dplace la plume dans la direction courante de la largeur du car ct }
   var
      lx                : real;

   begin
      lx := largeur (nums_ct);
      deplace_plume (lx, 0);
   end;

procedure initialiser_parametres_courants (police : byte;
                                           taille, direction, incl : real;
                                           refhauteur : integer);
   begin
      police_cte (police);
      calc_ech_symb (taille, refhauteur);
      dirr   := direction  * coefpi;             { direction en radians }
      inclr  := incl       * coefpi;             { inclinaison   ,,     }
   end;

procedure initialiser_parametres_symbct (police : byte ;
                                         taille, dx, dy, incl : real;
                                         refhauteur           : integer);
{   utilis dans fentre non millimtrique pour forcer chelle  }

   begin
      police_cte (police);
      calc_ech_symb (taille, refhauteur);
      dirr   := arctangente (dy, dx); { calculer direction courante en radians }
      inclr  := incl       * coefpi;             { inclinaison   ,,     }
   end;

procedure liberer_jeu_symb (police : byte);
   var
      i                 : integer;

   procedure liberer_points (var s : surpoint);
      { liberer la liste de points  }
      var
         p_ct, p_sui    : surpoint;

      begin
         p_sui  := s;
         p_ct   := s;
         while p_ct <> nil
         do begin
            p_sui := p_ct^.suiv;
            dispose (p_ct);
            p_ct  := p_sui;
         end;
         s := nil;
      end;

   procedure liberer_symbole (var s : sursymb);        { librer un symbole }
      begin
         dispose ( s );
         s := nil;
      end;

   begin
      police_cte (police);
      for i := 1 to maxsymb
      do
         if jeu_ct [i] <> nil
         then begin
            liberer_points  (jeu_ct [i]^.points);
            liberer_symbole (jeu_ct [i]);
         end;
   end;

procedure dessine_un_symb (nums_ct : integer);
   begin
      if (nums_ct-31 <= maxsymb) and (jeu_ct [nums_ct-31] <> nil)
      then begin
         { le symbole existe }
         transformer_symb (nums_ct, symb_ct, dirr, inclr);
         dessiner_symb (nums_ct);
         deplacer_symb (nums_ct);
         if  symb_ct <> nil
         then liberer_scalc (symb_ct);
      end;
   end;

procedure ecrire_texte   (texte   : string);
   { recalcule et dessine la suite de symboles TEXTE }
   var
      dx, dy, x, y      : real;
      i, cl, ca         : integer;

   begin
      for i := 1 to length (texte)
      do begin
         nums_ct := ord (texte [i]);
         if nums_ct > 127
         then begin
            cl := codel (chr (nums_ct));
            ca := codac (chr (nums_ct));
            dessine_un_symb  (cl);
            dx := dex;
            dy := dey;
            mover (-dx, -dy);
            dessine_un_symb (ca);
            mover (-dex, -dey);           { rcuprer le dcalage accent }
            mover ( dx, dy);
         end else
            dessine_un_symb (nums_ct);
      end;
   end;

procedure ecrire_symb_ct    (texte : string ; alfa : real);
   { pour crire en face d'une courbe de niveau }
   { police, taille dj connue, echs calcul  }
   begin
      dirr  := alfa;              { direction courante en radians }
      deplace_plume (l_symb/2 , - h_symb/2);
      ecrire_texte  (texte);
   end;

procedure etiquette_crb (x, y, t, d : real; c : word; ch : string);
   var
      ht, lgt,
      x1, y1, x2, y2,
      x3, y3, x4, y4,
      mx, my            : real;
      poly              : graphplt.polygone;

   procedure calcpoints;
      begin
         x2 := lgt;      y2 := 0;
         calc_point_suivant (x2, y2);
         x2 := x2 + x1;  y2 := y1 + y2;

         x4 := 0;        y4 := -ht;
         calc_point_suivant (x4, y4);
         x4 := x4 + x1;  y4 := y1 + y4;

         x3 := lgt;      y3 := 0;
         calc_point_suivant (x3, y3);
         x3 := x3 + x4;  y3 := y4 + y3;
      end;

   begin
      { police, taille dj connue, echs calcul  }
      { x y  repre carte }
      dirr := d;
      LgT  := Longueur_texte (ch)/xrap ;  { u F }
      ht   := Hauteur_texte      /xrap ;

      mx   :=  -(lgt / 2) ;
      my   :=  ( ht / 2);
      calc_point_suivant (mx, my);
      x1   := x + mx;
      y1   := y + my;

      calcpoints;
      poly [1].x := x1;   poly [1].y := y1;
      poly [2].x := x2;   poly [2].y := y2;
      poly [3].x := x3;   poly [3].y := y3;
      poly [4].x := x4;   poly [4].y := y4;
      poly [5].x := x1;   poly [5].y := y1;
      coulbar (solidfill, coulboite);
      fixecoul (coulboite);
      if maxcolor = 2 then fixecoul (0);
      if ecran
      then
         Polygoneplein (5, poly);
      fixecoul  (c);
      deplaceent     (x1, y1);                        { texte }
      ecrire_texte   (ch);
   end;

procedure justifie_texte (texte : string ; h, v : byte; var mx, my : real);
   var
      lx, ly            : real;

   begin
      if texte = ''
      then begin
         mx := 0 ;
         my := 0;
         exit
      end;
      ly := hauteur_texte;
      lx := longueur_texte (texte);

      case h of
         0 : case v of
                0 : begin
                       mx := 0 ;                                        { 1 }
                       my := 0
                    end;
                1 : begin
                       mx :=  sin (dirr)*ly/2 ;                         { 2 }
                       my := -cos (dirr)*ly/2
                    end;
                2 : begin
                       mx :=  sin (dirr)*ly ;                           { 3 }
                       my := -cos (dirr)*ly
                    end;
             end;

         1 : case v of
                0 : begin
                       mx := -cos (dirr)*lx/2 ;                         { 4 }
                       my := -sin (dirr)*lx/2
                    end;
                1 : begin
                       mx := -cos (dirr)*lx/2 + sin (dirr)*ly/2 ;       { 5 }
                       my := -sin (dirr)*lx/2 - cos (dirr)*ly/2
                    end;
                2 : begin
                       mx := -cos (dirr)*lx/2 + sin (dirr)*ly;          { 6 }
                       my := -sin (dirr)*lx/2 - cos (dirr)*ly
                    end;
             end;

         2 : case v of
                0 : begin
                       mx := -cos (dirr)*lx ;                           { 7 }
                       my := -sin (dirr)*lx
                    end;
                1 : begin
                       mx := -cos (dirr)*lx   + sin (dirr)*ly/2 ;       { 8 }
                       my := -sin (dirr)*lx   - cos (dirr)*ly/2
                    end;
                2 : begin
                       mx := -cos (dirr)*lx   + sin (dirr)*ly  ;        { 9 }
                       my := -sin (dirr)*lx   - cos (dirr)*ly
                    end;
             end;
      end;
   end;

procedure dessymb (police : byte; s : integer ; h : real; co : word);
   begin
      fixecoul  (co);

      initialiser_parametres_courants (police, h,   0,   0, 32);
                                    { fonte, taille, dir, incl, rf hauteur }
      dessine_un_symb (s);
   end;


END.

{ GRAPHSG ------------------------------------------- INRP - TOULOUSE - ARX }
