UNIT DIRINFO;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                     GESTION DU FICHIER DE RESSOURCES                   }
   {                                                            22/07/92    }
   {------------------------------------------------------------------------}

   { Le fichier de ressources associ  un rpertoire permet de mmoriser
     une ligne de description de chaque fichier .                           }
   (*
   DirInfo,                  { ARX     - Gestion des fichiers ressources    }
   *)

INTERFACE

{$O+,F+}

USES
   dos,
   crt,
   graph,                    { TP 70   - units standard Borland            }
   Graphism,                 { ARX     - initialisations graphiques         }
   Souris,                   { ARX     - gestion de la souris               }
   Clavier,                  { ARX     - gestion du clavier                 }
   Messarx,                  { ARX     - Textes des Messages de Base        }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Utiledi,                  { ARX     - utilitaires dition                }
   Fichiers;                 { ARX     - Gestion des fichiers et erreurs    }

{$I-,S-}

{$M 8192, 8192, 655360}

Procedure edite_info ( chemin  : pathstr;
                       filtre  : t12;
                       extf    : extstr );
   { Cre ou modifie fichier de ressources dans un rpertoire.              }
   { Dans la bote de slection sont affiches les                          }
   { informations associes  chaque fichier de la slection opre par     }
   { FILTRE s'il est prsent dans le rpertoire.                            }
   { CHEMIN contient le nom complet du fichier RESSOURCES.                  }
   { Utilise le rpertoire affect  la var. d'environnement TEMP           }

Procedure dir_info   ( com1, comm, com3    : chainecar;
                       chemin              : pathstr;
                       filtre              : t12;
                       extf                : extstr;
                       var nomf            : t12);
   { rend un nom complet de fichier comme DIR mais uniquement dans un       }
   { rpertoire. Dans la bote de slection sont affiches les              }
   { informations associes  chaque fichier de la slection opre par     }
   { FILTRE s'il est prsent dans le rpertoire.                            }
   { CHEMIN contient le nom complet du fichier RESSOURCES.                  }

{---------------------------------------------------------------------------}
IMPLEMENTATION

CONST
   ftmp                 = 'Info.tmp';
   MaxCarDir            = 56;
   lginfodir            = MaxCarDir - 14;

TYPE
   strinfo              = string [lginfodir];

   DirPtr               = ^DirRec;
   ptrstr               = ^strinfo;
   DirRec               = RECORD
                             info : ptrstr;
                             Attr : BYTE;
                             Time : LONGINT;
                             Size : LONGINT;
                             Name : T12;
                          END;
   DirList              = ARRAY [0..Maxliste - 1] OF DirPtr;

VAR
   Path                 : PathStr;
   Dir                  : DirList;
   Dirs                 : DirStr;
   Noms                 : NameStr;
   Exts                 : ExtStr;

   nul,
   count,
   lg_boite,
   ind,
   max,
   x0, y0               : integer;
   info_present,
   modi                 : boolean;
   finfo                : pathstr;
   l1                   : chainecar;

function ordre (x, y : dirptr) : boolean;
   begin
      ordre := x^.name < y^.name;
   end;

procedure GetCommand (var path : pathstr);
   VAR
      Attr              : WORD;
      F                 : File;

   BEGIN
      Path := FExpand (Path);
      IF Path [Length (Path)] <> '\'
      THEN BEGIN
         Assign   (F, Path);
         GetFAttr (F, Attr);
         IF (DosError = 0) AND (Attr AND Directory <> 0)
         THEN
            Path := Path + '\';
      END;
      FSplit (Path, Dirs, Noms, Exts);
      IF Noms = '' THEN Noms := '*';
      IF Exts = '' THEN Exts := '.';
      Path   := Dirs + Noms + Exts;
   END;

procedure FindFiles;
   VAR
      F                 : SearchRec;

   BEGIN
      Count  := 0;
      FindFirst (Path, ReadOnly + Archive, F);
      WHILE (DosError = 0) AND (Count < Maxliste)
      DO BEGIN
         new (dir [count]);
         dir [count]^.name := F.name;
         dir [count]^.info := nil;
         Inc (Count);
         FindNext (F);
      END
   END;

procedure quicksort (l, r : integer);
   var
      i, j              : integer;
      x, y              : dirptr;

   begin
      i := l;
      j := r;
      x := dir [(l+r) div 2];
      repeat
         while ordre (dir [i], x) do inc (i);
         while ordre (x, dir [j]) do dec (j);
         if i <= j
         then begin
            y       := dir [i];
            dir [i] := dir [j];
            dir [j] := y;
            inc (i);
            dec (j);
         end;
      until i > j;
      if l < j then quicksort (l, j);
      if i < r then quicksort (i, r);
   end;

procedure sortfiles;
   begin
      if (count > 1)
      then
         quicksort (0, count-1);
   end;

procedure liberedir;
   var
      i, j              : integer;

   begin
      for i := 0 to count-1
      do begin
         if dir [i]^.info <> nil {@vide}
         then
             dispose (dir [i]^.info);
         dispose (dir [i]);
      end;
   end;

procedure lire_info (nomf : pathstr ; var ok : boolean);
   var
      f_info            : text;
      i , lgl, pp       : integer;
      nf, nf2           : t12;
      trouve            : boolean;
      ligne             : string;

   begin
      ok := false;
      assign    (f_info, nomf);
      for i := 0 to count-1
      do begin
         nf        := dir [i]^.name;
         resetTxtErr (f_info, nomf, ok);
         trouve    := false;
         lgl       := 0;
         while not eof (f_info) and not trouve
         do begin
            readln (f_info, ligne);
            if ligne [1] = '*'
            then
               l1 := ligne
            else begin
               lgl  := length (ligne);
               nf2  := copy   (ligne, 1, 12);
               if pos ('.', nf2) = 0
               then
                  nf2 [pos (' ', nf2)] := '.';

               while pos (' ', nf2) > 0
               do
                  delete (nf2, pos (' ', nf2), 1);
               trouve := (nf = nf2);

               if trouve and (lgl > 14)
               then begin
                  if lgl > lg_boite
                  then
                     lg_boite := lgl;

                  if lg_boite > Maxcardir
                  then begin
                     lgl      := MaxCarDir;
                     lg_boite := MaxCarDir;
                     ligne    := copy (ligne, 1, MaxCarDir);
                  end;
                  new (dir [i]^.info);
                  dir [i]^.info^ := copy (ligne, 15, lgl);
                  ok := true;
               end;
               creeliste (ligne, i+1);
            end;
         end;
         if not trouve
         then
            creeliste (dir [i]^.name, i+1);
      end;
      close (f_info);
   end;

function nom12 (nf : t12) : t12;
   var
      N                 : namestr;
      l, i              : integer;

   begin
      n  := sansext (nf);
      l  := length  (n);
      for i := l+1 to 8
      do
         n := n + ' ';
      nom12 := n + extension (nf);
   end;

procedure ecrire_info (nomf : pathstr);
   var
      f_temp, f_info    : text;
      i, pp             : integer;
      ligne             : string;
      nf,
      nf2               : t12;
      ok,
      trouve            : boolean;
      linfo             : chainecar;

   begin
      assign        (f_temp, reptemp+ftmp);
      assign        (f_info, nomf);
      rewriteTxtErr (f_temp, reptemp+ftmp, ok);
      resetTxtErr   (f_info, nomf, ok);
      while  not (eof (f_info))
      do begin
         readln     (f_info, ligne);
         writeln    (f_temp, ligne);
      end;
      rewriteTxtErr (f_info, nomf, ok);
      resetTxtErr   (f_temp, reptemp+ftmp, ok);
      while not eof (f_temp)
      do begin
         readln (f_temp, ligne);
         trouve := false;
         nf2    := copy (ligne, 1, 12);
         if    pos ('.', nf2) = 0
         then
            nf2 [pos (' ', nf2)] := '.';
         while pos (' ', nf2) > 0
         do
            delete (nf2, pos (' ', nf2), 1);

         i := 0;
         while (i < count) and (not trouve)
         do begin
            nf     := dir [i]^.name;
            trouve := (nf = nf2);
            inc (i);
         end;

         if trouve
         then begin
            dec (i);
            if dir [i]^.info <> nil
            then
               linfo :=  dir [i]^.info^
            else
               linfo := '';
            ligne := (nom12 (dir [i]^.name) + '  ' +linfo);
         end;
         writeln  (f_info, ligne);
      end;

      for i := 0 to count-1
      do begin
         nf     := dir [i]^.name;
         resetTxtErr  (f_temp, reptemp+ftmp, ok);
         trouve := false;
         while not eof (f_temp) and not trouve
         do begin
            readln (f_temp, ligne);
            nf2  := copy (ligne, 1, 12);
            if    pos ('.', nf2) = 0
            then
               nf2 [pos (' ', nf2)] := '.';

            while pos (' ', nf2) > 0
            do
               delete (nf2, pos (' ', nf2), 1);
            trouve := (nf = nf2);
         end;
         if not trouve
         then begin
            ligne := (nom12 (dir [i]^.name) + '  ' + dir [i]^.info^);
            writeln  (f_info, ligne)
         end;
      end;
      close (f_info);
      close (f_temp);
   end;

procedure faire_info ( finfo : pathstr);
   var
      f_info            : text;
      i                 : integer;
      ok                : boolean;

   begin
      assign  (f_info, finfo);
      rewrite (f_info);
      RewriteTxtErr (f_info, finfo, ok);
      if ok
      then begin
         writeln (f_info, '*             prog/donnes');
         for i := 0 to  count-1
         do
            writeln (f_info, nom12 (dir [i]^.name));
         close   (f_info);
         modi := true;
      end;
   end;

procedure modifie_finfo ( texte1    : chainecar ; x : integer ;
                          var modi  : boolean );
   var
      p                 : pointer;
      taillep           : word;
      y, lx, ly, h,
      Touche,
      indice,
      ind0,
      supx,
      mxy, mxx,
      ny                : integer;
      asc_v,
      select            : boolean ;

   procedure affiche;
      var
         pp , i         : integer;
         nomf           : t12;
         suit           : strinfo;

      begin
         setcolor        (c_t_boite_norm);
         setfillstyle (SolidFill, c_f_boite_norm);
         bar         (x0   +2,   y0+h,  x0+lx-2,   y0+ly+h-2);
         i := ny;
         settextjustify (0, 2);
         repeat
            if i <> indice
            then begin
               setcolor        (c_t_boite_norm );
               setfillstyle (1, c_f_boite_norm );
            end else begin
               setcolor        (c_t_boite_inve );
               setfillstyle (1, c_f_boite_inve );
            end;
            bar       (x0   +3,    y0+h+1 + (i-ny)   *ty,
                       x0+lx-3,    y0+h-1 + (i-ny+1) *ty);
            nomf := dir [i-1]^.name;
            pp   := pos ('.', nomf);
            if dir [i-1]^.info <> nil
            then
               suit := dir [i-1]^.info^
            else
               suit := '';
            outtextxy (x0+6,       y0+h+(i-ny)*ty, copy (nomf,  1, pp-1));
            outtextxy (x0+6+tx*8,  y0+h+(i-ny)*ty, copy (nomf, pp, 4));
            setcolor  (c_t_boite_inac);
            if suit <> ''
            then
               outtextxy (x0+6+tx*14, y0+h+(i-ny)*ty, suit);
            inc       (i);
         until (i = count+1) or (i = ny+mxy);
      end;

   procedure select_ligne ;
      { calculer rang  partir de Xs
                               de la position de la fentre
                               et du texte dans la f }
      begin
         ind0    := ny + (ys - (y0 + h +2)) div ty;
      end;

   procedure select_ligne_clavier ;
      var
         i1, i          : integer;

      { calculer rang  partir de Xs
                               de la position de la fentre
                               et du texte dans la f }
      begin
         case Touche of
            FleH : dec (indice);
            FleB : inc (indice);
            PgUp : indice := indice - mxy +1;
            PgDn : indice := indice + mxy -1;
         end;
         if indice < 1   then indice := 1;
         if indice > max then indice := max;
         if indice < ny  then ny     := indice;

         if indice >= ny + mxy then ny := indice - mxy + 1;
         if ny     < 1         then ny := 1;
         if ny     > max - mxy then ny := max - mxy + 1;

         Affiche;
         ind0 := indice;
      end;

   procedure modif_ligne (i : integer ; var ok : boolean);
      var
         lgl,  pp       : integer;
         suit           : strinfo;
         nomf           : t12;

      begin
         setcolor        (c_t_boite_norm);
         setfillstyle (1, c_f_boite_norm);
         bar       (x0   +3,    y0+h+1 +(i-ny)   *ty,
                    x0+lx-3,    y0+h-1 +(i-ny+1) *ty);

         nomf  := dir [i-1]^.name;
         pp    := pos ('.', nomf);

         if dir [i-1]^.info <> nil
         then
            suit  := dir [i-1]^.info^
         else
            suit := '';

         outtextxy (x0+6,       y0+h+(i-ny)*ty, copy (nomf, 1,  pp-1));
         outtextxy (x0+6+tx*8,  y0+h+(i-ny)*ty, copy (nomf, pp, 4));

         setcolor  (c_t_boite_inac);
         outtextxy (x0+6+tx*14, y0+h+(i-ny)*ty, suit);
         setcolor  (c_f_boite_inve);
         readxy    (x0+8+tx*14, y0+h+(i-ny)*ty, suit, lg_boite-14{ -1});

         lgl   := length (suit);
         if (lgl > 0)
         then begin
            if dir [i-1]^.info = nil
            then
               new (dir [i-1]^.info);
            dir [i-1]^.info^ := suit;
            ok := true;
         end else
            if dir [i-1]^.info <> nil
            then begin
               dispose (dir [i-1]^.info);
               dir [i-1]^.info := nil;
               ok := true;
            end;
      end;

   begin                                                { modifie_finfo }
      { nouveau_style (0, 0, 1);
      tx      :=  8;
      ty      := 12;}
      asc_v   := false;
      memok   := true;
      mxx     := Maxcardir;
      max     := count;
      indice  := 1;
      mxy     := 7;
      if max <= mxy
      then begin
         supx  := 0;
         mxy   := max;
      end else begin
         supx  := 2*8 {tx};
         asc_v := true
      end;

      lx      := tx*x   + 2*6;
      h       := ty     + 11;
      ly      := ty*mxy + 2;
      taillep := imagesize (0, 0, lx+supx, ly+h);

      if (taillep < maxavail) and (taillep < maximage)
      then begin
         laide (la_clic_esc);
         getmem (p, taillep);
         x0 := (maxx - lx -supx) div 2;
         y0 := (maxy - ly -h)    div 2;

         if x0 < 0  then x0 := 0;
         if y0 < 0  then y0 := 0;

         getimage  (x0,   y0,   x0+lx+supx,   y0+ly+h, p^);

         setcolor                (c_t_boite_norm);
         setfillstyle (solidfill, c_f_boite_norm );         { fond boite }
         bar       (x0,   y0,   x0+lx+supx,   y0+ly+h);

         rectangle (x0+1, y0+h-1, x0+lx-1,      y0+ly+h-1); { liste }
         rectangle (x0+1, y0+1,   x0+lx+supx-1, y0+   h-3); { en tte }

         ny := 1;
         if asc_v
         then
            affiche_ascenseur_v (1, max-mxy+1, x0+lx-1, y0+h-1, ly, -1, ny);

         setcolor        (c_t_boite_inve);      { titre }
         fixecoulentete;
   (*    if prg_menu
         then
            setfillstyle (1, colord {c_f_boite_inve})
         else
            setfillstyle (1, c_t_boite_norm);
     *)
         bar       (x0+2,        y0+2,   x0+lx+supx-2, y0+h-4);
         settextjustify (1, 1);
         outtextxy (x0+(lx+supx) div 2, y0+ 3+ ty div 2,      texte1);
         settextjustify (0, 2);



         ind0    :=  0;
         select  := false;
         repeat until not unboutonSourisenfonce;
         repeat
            affiche;

            if asc_v
            then
               ascenseur_v (1, max-mxy+1, x0+lx-1, y0+h-1, ly, -1, ny, Touche);
            if not asc_v
            then begin
               MontrerSouris;
               ClavSourisFleches (Touche);
               LirePositionSouris (xs, ys);
               CacherSouris;
            end;

            if (xs > x0) and  (xs < x0+lx)
               and (ys > y0+h) and (ys < y0+h+ly)
               or (Touche = CR)
               or (Touche = FleH) or (Touche = FleB)
               or (Touche = PgDn) or (Touche = PgUp)
            then begin
               repeat until not unboutonsourisenfonce;

               if Touche = 0
               then
                  select_ligne
               else
                  select_ligne_clavier;

               if (Touche = 0) or (Touche = CR)
               then
                  select := ind0=indice;
               indice := ind0;
            end else
               select := false;
            delay (10);

            if select          { modif  }
            then begin
               repeat until not UnBoutonSourisEnfonce;
               modif_ligne (indice, modi);
               affiche ;
            end;
         until d or select;

         putimage (x0, y0, p^, 0);
         freemem  (p, taillep);
         laide ('');
      end else
         memok := false;
      { ancien_style; }
   end;                                                 { modifie_finfo }

{---------------------------------------------------------------------------}
procedure edite_info (chemin  : pathstr; filtre  : t12; extf : extstr);
   var
      texte1            : chainecar;

   begin
      info_present := false;
      FSplit (chemin, Dirs, Noms, Exts);
      path     := concat (dirs, filtre+extf);
      finfo    := concat (dirs, noms, exts);
      GetCommand (path);
      FindFiles;
      texte1   := t_mod_resume;
      lg_boite := maxcarDir;
      modi     := false;
      if count > 0
      then begin
         Sortfiles;
         if not ftxt_present (finfo)
         then
            faire_info       (finfo);
         lire_info           (finfo, info_present);

         if lg_boite < length (texte1)
         then
            lg_boite := length (texte1);

         modifie_finfo       (texte1, lg_boite, modi)
      end;
      {else         message3 ('Fichiers  ', filtre, 'introuvables !')}

      if modi
      then
         ecrire_info (finfo);

      liberedir;
   end;

{---------------------------------------------------------------------------}
procedure dir_info   ( com1, comm, com3   : chainecar;
                       chemin             : pathstr;
                       filtre             : t12;
                         extf             : extstr;
                     var nomf             : t12);

   procedure select_nomfinfo (     x : integer;
                             var rep : t12);
      var
         n              : integer;

      begin
         n := 0;
         liste (com1, comm, com3, x , rep, n);
         if n > 0
         then
            rep := dir [n-1]^.name
         else
            rep := '';
      end;

   procedure lire_liste;
      var
         i              : integer;

      begin
         for i := 0 to count-1
         do begin
            nomf := dir [i]^.name;
            creeliste (nomf, i+1);
         end;
      end;

   begin                                           { procdure  dir_info }
      ind      := 1;
      info_present := false;
      FSplit (chemin, Dirs, Noms, Exts);
      path     := concat (dirs, filtre+extf);
      finfo    := concat (dirs, noms, exts);
      GetCommand (path);
      FindFiles;

      lg_boite := length (com1);
      if lg_boite < length (comm)
      then
         lg_boite := length (comm);
      if lg_boite < length (com3)
      then
         lg_boite := length (com3);

      if count > 0
      then begin
         Sortfiles;
         if Exists (finfo)
         then begin
            lire_info          (finfo, info_present);
            if info_present
            then
               select_nomfinfo (lg_boite, nomf)
            else begin
               lire_liste;
               liste           (com1, comm, com3, 12, nomf, ind)
            end
         end else begin
            lire_liste;
            liste              (com1, comm, com3, 12, nomf, ind)
         end;
      end else begin
      (*  if count = 1
         then begin
            nomf := dir [0]^.name ;
            laide ('Un seul fichier '+filtre+extf +' trouv !');
         end else begin  *)
            nomf := '';
            laide (m_not_fichier+' '+filtre+extf);
        { end;   }
        { message3 ('Fichiers  ', filtre, 'introuvables !')} ;
      end;
      liberedir;
   end;                                            { procdure  dir_info }

END.

{--- DIRINFO ----------------------------------------------------- 1995 ----}




