UNIT GRILLES;

   {------------------------------------------------------------------------}
   {      GEOCEAN                                                           }
   {                       Lecture Grilles                                  }
   {                                                            30/01/93    }
   {------------------------------------------------------------------------}

   (*
   GRILLES,                  { ARX     - lecture des grilles                }
   *)

INTERFACE
{$O+,F+}

USES
   Dos,
   Objects,                 { TP 70   - units standard                    }
   Fichiers                 { ARX     - Gestion des fichiers et erreurs    }
   ;

CONST
   NbMaxCol             = 121;     { Nombre limite de colonnes }
   NbMaxLig             = 121;     { Nombre limite de lignes   }
                                   { 140*110 possible
                                      mais 150*100 col --> err exec  201}


   ValIndef             = 32767;   { Valeur entire indfinie  }
   INDEFINI             = 1.7e+38; { Valeur relle indfinie   }

TYPE
   UneLigne             = array [1..NbMaxCol] of real;
   SurLigne             = ^UneLigne;
   UneGrille            = array [1..NbMaxLig] of SurLigne;

   PGrille              = ^TGrille;
   TGrille              = Object (TObject)
      Grille            : UneGrille;
      NbLignes,         { Nombre de lignes charges }
      NbLigI, NbCogI,   { Nb lignes et colonnes initiaux }
      NbLig, NbCog      : Integer;
      MaxXG, MinXG,
      MaxYG, MinYG,
      MinZG, MaxZG,
      PasXgrille,
      PasYgrille        : real;
      Signature         : string;

      Constructor init;

      Function  absx     (i : integer)       : real;
         { calcule l'abscisse de la colonne I dans le repre de la carte }

      Function  ordy     (j : integer)       : real;
         { calcule l'ordonne de la ligne J dans le repre de la carte }

      Function  rangx    (x : real)          : integer;
         { calcule le rang de la colonne la plus proche de x }

      Function  rangy    (y : real)          : integer;
         { calcule le rang de la ligne la plus proche de y }

      Function  Valeur   (i, j : integer)    : real;
         { renvoie la valeur (nouveau repre) de la station (x,y) }

      Procedure Affecter (a, b : integer;
                          z    : real);
         { Met  jour une valeur dans la grille }

      Procedure Charger  (nomf : pathstr;
                          var debx, finx, deby, finy : real);
         {
           La grille utilise est un fichier ascii muni d'une en-tte :
           signature DSAA (compatible SURFER),  ou autre ... (INRP ou GEOC),
           nombre de colonnes et de lignes de la grille,
           valeurs mini et maxi en X, Y et Z.
           Valeurs indfinies suprieures au maxi en Z.
           La totalit de la grille est charge en mmoire si les valeurs
           limites dbordent celles de l'entte.
           max 121*121
           espacement automatique en x ou y (1 point sur 2) si dpassement
           troncature ensuite
           }

      Procedure Remplacer (v1, v2 : real);
         { Remplace toutes les valeurs gales  V1 par V2                   }

      Procedure Sauver    (nomf   : pathstr;
                           debx, finx, deby, finy : real);
         { !! Gnre un fichier grille }

      Procedure Liberer;
         { Libre les pointeurs }

      Destructor done; virtual;
         { Libre l'objet Grille  }
   end;

VAR
   lagrille,
   lagrill2             : TGrille;
   v_indef              : real;        { valeur indfinie                   }

   {------------------------------------------------------------------------}

IMPLEMENTATION

constructor TGrille.init;
   var
      i                 : integer;

   begin
      TObject.init;
      NbLignes := 0;
      for i := 1 to NbMaxLig
      do
         grille [i] := NIL;
   end;

procedure TGrille.Liberer;
   var
      i                 : integer;

   begin
      if NbLignes <> 0
      then
         for i := 1 to NbLignes
         do
            if grille [i] <> NIL
            then
               dispose (grille [i]);
      NbLignes := 0;
      for i := 1 to NbMaxLig
      do
         grille [i] := NIL;
   end;

destructor TGrille.done;
   begin
      Liberer;
      TObject.done;
   end;

function TGrille.absx (i : integer) : real;
   { calcule l'abscisse de la colonne I dans le repre de la carte }
   begin
      absx := minxg + (i-1) * pasxgrille;
   end;

function TGrille.ordy (j : integer) : real;
   { calcule l'ordonne de la ligne J dans le repre de la carte }
   begin
      ordy := minyg + (j-1) * pasygrille;
   end;

function  TGrille.rangx (x : real) : integer;
   { calcule le rang de la colonne la plus proche de x }
   begin
      rangx := trunc (round ((x-minxg)/PasXGrille));
   end;

function  TGrille.rangy (y : real) : integer;
   { calcule le rang de la ligne la plus proche de y }
   begin
      rangy := trunc (round ((y-minyg)/PasYGrille));
   end;

function  TGrille.Valeur (i, j : integer) : real;
   begin
      if j > nblig then j := nblig;
      if i > nbcog then i := nbcog;
      if i < 1 then i := 1;
      if j < 1 then j := 1;
      Valeur := Grille [j]^[i];
   end;

procedure TGrille.Affecter (a, b : integer; z : real);
   begin
      Grille [b]^[a] := z;
   end;

{****************************************************************************}
procedure TGrille.Charger (nomf : pathstr; var debx, finx, deby, finy : real);
   var
      dxi, dyi,                        { origine li et co de la fentre }

      nbl2, nbc2,
      i, j, k,
      dx, fx, dy, fy    : integer;

      z,
      pasxI, pasyI,
      n_minx, n_miny    : real;

      fentree           : text;

      un_x_sur2,
      un_y_sur2,
      ok                : boolean;

   procedure allouerLigne (li : integer);
      begin
         if grille [li] = NIL
         then begin
            new ( grille [li] );
            if li > NbLignes then NbLignes := li;
         end;
      end;

   procedure lire  (a, b : integer);
      var
         z              : real;

      begin                            { procedure lire }
         read (fentree, z);            { nombres rels  }
         grille [b]^[a] := z;
      end;

   begin                               { lire_grille }
      un_x_sur2 := false;
      un_y_sur2 := false;

      assign (fentree, nomf);
      resetTxtErr  (fentree, nomf, ok);
      Liberer;                         { initialisations pointeurs }
                                       { lecture en-tte fichier   }
      readln (fentree);                            { signature SURFER : DSAA}
      readln (fentree, NbCoG, NbLiG);
      readln (fentree, MinXG, MaxXG);
      readln (fentree, MinYG, MaxYG);
      readln (fentree, minZG, maxZG);
      pasxgrille := (maxXg - minXg) / (nbcog - 1);
      pasygrille := (maxYg - minYg) / (nblig - 1);
      nbligI := nblig;
      nbcogI := nbcog;
      pasxI  := pasxgrille;
      pasyI  := pasygrille;
      dxi    := 1;
      dyi    := 1;

      { si coord. non ou mal initialises alors on prend le tout }
      if (debx >= finx)
      then begin
         debx := MinXg;
         finx := MaxXg
      end;
      if (deby >= finy)
      then begin
         deby := MinYg;
         finy := MaxYg
      end;

      if debx < minXg then debx := minXg;          { troncature sous-grille }
      if finx > maxXg then finx := maxXg;
      if deby < minYg then deby := minYg;
      if finy > maxYg then finy := maxYg;

      { recalculer le nombre de lignes utiles }
      nblig := round ((finy-deby) / pasygrille) +1;
      nbcog := round ((finx-debx) / pasxgrille) +1;

      if Nblig > Nbmaxlig
      then begin
         nbl2       := (nblig div 2) + nblig mod 2;
         un_y_sur2  := true;
         if nblig mod 2 = 0
         then
            finy := finy - pasYgrille;
         nblig := nbl2;
         pasYgrille := pasYgrille * 2;
      end;

      if Nbcog > Nbmaxcol
      then begin
         nbc2       := (nbcog div 2) + nbcog mod 2;
         un_x_sur2  := true;
         if nbcog mod 2 = 0
         then
            finx := finx - pasXgrille;
         nbcog := nbc2;
         pasXgrille := pasXgrille * 2;
      end;

      if Nblig > nbmaxlig    { si  dpasse encore, troncature bas gauche }
      then begin
         Nblig := nbmaxlig;
         maxYg := minYg+ pasYgrille * (Nblig-1) ;
         finy  := maxYg;
      end;
      if Nbcog > nbmaxcol
      then begin
         Nbcog := nbmaxcol;
         maxXg := minXg+ pasXgrille * (Nbcog-1) ;
         finx  := maxXg;
      end;

      { coordonnes li * co initiales }
      dx := trunc ((debx-minXg) / pasxi)+1;       { rech. col. dbut et fin }
      dy := trunc ((deby-minYg) / pasyi)+1;

      fx := trunc ((finx-minXg) / pasxi);         { rech. lig. dbut et fin }
      fx := fx +1+1;
      fy := trunc ((finy-minYg) / pasyi);
      fy := fy +1+1;

   (*   for j := 1 to dy                       { sauter les lignes hors cadre }
      do begin
          for i := 1 to nbcogi
          do
             read (fentree, z);
      end; *)

      j := 1 ;
      while (j <= dy) and (dy <> dyi)
      do begin
         for i := 1 to nbcogi
         do
            read (fentree , z);
         inc (j)
      end;

      for j := 1 to  nblig
      do begin
         AllouerLigne (j);
                                           { sauter les colonnes hors cadre }
{         for i := 1 to dx
         do
            read (fentree, z);}
         i := 1;
         while (i <= dx)  and  (dx <> dxi)
         do begin
            read (fentree , z);
            inc (i)
         end;

         for i := 1 to nbcog
         do begin
            lire (i, j);                                    { chaque valeur }
            if un_x_sur2 and ((i <> nbcog) and (nbcogI mod 2 <> 0))
            then
               read (fentree, z);         { lecture bidon un colonne  sur 2 }
         end;

(*         for  i := fx +1 to nbcogi         { sauter les colonnes hors cadre }
         do
            read (fentree, z);*)
         i := fx+1;
         while (i <= nbcogi)
         do begin
            read (fentree , z);
            inc (i)
         end;

         if un_y_sur2 and ((j <> nblig) and (nbligI mod 2 <> 0))
         then
            for k := 1 to nbcogI            { lecture bidon une ligne sur 2 }
            do
               read (fentree, z);
      end;
      close (fentree);
      minxg := debx;
      maxxg := finx;
      minyg := deby;
      maxyg := finy;
   end;

procedure TGrille.Remplacer;
   var
      i, j              : integer;

   begin
      for j := 1 to nblig
      do
         for i := 1 to nbcog
         do
            if Valeur (i, j) = v1
            then
               Affecter (i, j, v2);
   end;

procedure TGrille.Sauver (nomf : pathstr; debx, finx, deby, finy : real);
   begin
   end;

(*   A REFAIRE si utile !
procedure sauver_grille (nomf : string; debx, finx, deby, finy : real);
   var
      f                       : text;
      i, j, k, nbl, nbc       : integer;
      z                       : real;

   begin
      assign  (f, nomf);
      rewrite (f);
     { rechercher min/max dans la zone }
     { recalculer limites }
      sign_inrp := 'INRP';
      writeln (f, sign_inrp);
      writeln (f, nbc:6, nbl:6);
      writeln (f, debX:6:0, finX:6:0);
      writeln (f, debY:6:0, finY:6:0);
      writeln (f, debZ:6:0, finZ:6:0);
      for j := 1 to nblig
      do begin
         for k := 1 to nbcog div 10
         do begin
            for i := 1 to 10 do
               write (f, Grille (10*(k-1), j):6:0 );
            writeln (f);
         end;
         for i := 1 to nbc mod 10
         do
            write (f, Grille (10* (nbc div 10 - 1)+i , j):6:0);
         writeln (f);
      end;
      close   (f);
   end;                         *)


END.

{--- GEOCEAN - GRILLES ---------------------- R.C.- INRP - TOULOUSE - 1993 }
