UNIT math3d_c;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                       fonctions  mathmatiques                            }
{                              VISU 3D                                      }
{                                                                03/09/91   }
{---------------------------------------------------------------------------}
{  A R X - Alain                  CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}
(*
   Math3d_c,                 { ARX     - fonctions math 3d                  }
*)

INTERFACE

{$O+,F+}

USES
   crt;

TYPE
   crdn                 = (x, y, z);
   vect                 = array [crdn] of real;
   mat                  = array [crdn] of vect;


CONST
   infini               = 1e38;

   vzero                : vect = (0,0,0);
   vux                  : vect = (1,0,0);
   vuy                  : vect = (0,1,0);
   vuz                  : vect = (0,0,1);

   mzero                : mat  = ((0,0,0), (0,0,0), (0,0,0));
   mid                  : mat  = ((1,0,0), (0,1,0), (0,0,1));


Function  suiv     (c  : crdn                         )         : crdn;

Procedure ligne    (m  : mat ; i : crdn; var v : vect ) ;

Procedure lignen   (m  : mat ; i : crdn; var a, b, c : real) ;

Procedure fixelig  (v  : vect; i : crdn; var m : mat  ) ;

Procedure fixelign (a, b, c : real; i : crdn;  var m : mat );

Procedure fixevect (a, b, c : real;      var v : vect );

Procedure diag     (m  : mat ;           var v : vect );

Procedure fixediag (v  : vect;           var m : mat  );

Procedure vmults   (v  : vect; s : real; var r : vect );

Procedure mmults   (m  : mat ; s : real; var r : mat  );

Procedure sommev   (a,b: vect;           var r : vect );

Procedure diffv    (a,b: vect;           var r : vect );

Procedure sommem   (a,b: mat ;           var r : mat  );

Procedure negv     (v  : vect;           var r : vect );

Procedure negm     (m  : mat ;           var r : mat  );

Procedure t        (m  : mat ;           var r : mat  );

Function  auto_a   (m  : mat                          )         : boolean;

Function  anti_aa  (m  : mat                          )         : boolean;

Function  norme2v  (v  : vect                         )         : real;

Function  normev   (v  : vect                         )         : real;

Function  normerv  (                     var v : vect )         : boolean;

Function  discrim  (m  : mat ; i, j : crdn            )         : real;

Function  det      (m  : mat                          )         : real;

Function  trace    (m  : mat                          )         : real;

Procedure tmcofact (m  : mat;            var r : mat  );

Function  inversion(m  : mat;            var r : mat  )         : boolean;

Function  produits (a,b: vect                         )         : real;

Procedure mmultv   (m  : mat ; v : vect; var r : vect );

Procedure vmultm   (v  : vect; m : mat ; var r : vect );

Procedure produitm (a,b: mat ;           var r : mat  );

Procedure trfmat   (v  : vect;           var m : mat  );

Function  trfvect  (m  : mat;            var v : vect )         : boolean;

Procedure produitv (a,b: vect;           var r : vect );

Procedure creerbase(a,b: vect;           var u, v, w : vect);

Procedure mrotation(u  : vect; a : real; var m : mat  );

Procedure mprojp   (u  : vect;           var m : mat  );

Procedure mprojd   (u  : vect;           var m : mat  );

Function  arccos   (c  : real                         )         : real;

Procedure projsph  (a, b, c, u : vect;   var aa, bb, r : real);

Procedure affichev (v  : vect ; c, l : integer; ch : string);

Procedure affichem (m  : mat  ; c, l : integer; ch : string);

{---------------------------------------------------------------------------}
IMPLEMENTATION

function suiv (c : crdn) : crdn;
   begin
      case c of
         x : suiv := y;
         y : suiv := z
      else
         suiv := x
      end
   end;

procedure ligne (m: mat; i: crdn; var v: vect);
   begin
      v[x] := m[x,i];    v[y] := m[y,i];     v[z] := m[z,i]
   end;

procedure lignen (m: mat; i: crdn; var a, b, c: real);
   begin
      a := m[x,i];       b := m[y,i];        c := m[z,i]
   end;

procedure fixelig (v: vect; i: crdn; var m: mat);
   begin
      m[x,i] := v[x];     m[y,i] := v[y];     m[z,i] := v[z]
   end;

procedure fixelign (a, b, c: real; i: crdn; var  m: mat);
   begin
      m[x,i] := a;        m[y,i] := b;        m[z,i] := c
   end;

procedure fixevect (a, b, c: real; var v: vect);
   begin
      v[x] := a;          v[y] := b;          v[z] := c
   end;

procedure diag (m: mat; var v: vect);
   begin
      v[x] := m[x,x];     v[y] := m[y,y];     v[z] := m[z,z]
   end;

procedure fixediag (v: vect; var m: mat);
   begin
      m[x,x]:=v[x];       m[y,y]:=v[y];       m[z,z]:=v[z]
   end;

procedure vmults (v: vect; s: real; var r: vect);
   begin
      r[x] := s*v[x];     r[y] := s*v[y];     r[z] := s*v[z]
   end;

procedure mmults (m: mat ; s: real; var r: mat );
   begin
      r[x,x] := s*m[x,x]; r[y,x] := s*m[y,x]; r[z,x] := s*m[z,x];
      r[x,y] := s*m[x,y]; r[y,y] := s*m[y,y]; r[z,y] := s*m[z,y];
      r[x,z] := s*m[x,z]; r[y,z] := s*m[y,z]; r[z,z] := s*m[z,z]
   end;

procedure sommev (a, b: vect; var r: vect);
   begin
      r[x] := a[x]+b[x];  r[y] := a[y]+b[y];  r[z] := a[z]+b[z]
   end;

procedure diffv (a, b: vect; var r: vect);
   begin
      r[x] := a[x]-b[x];  r[y] := a[y]-b[y];  r[z] := a[z]-b[z]
   end;

procedure sommem (a, b: mat ; var r: mat );
   begin
      r[x,x] := a[x,x]+b[x,x]; r[y,x] := a[y,x]+b[y,x]; r[z,x] := a[z,x]+b[z,x];
      r[x,y] := a[x,y]+b[x,y]; r[y,y] := a[y,y]+b[y,y]; r[z,y] := a[z,y]+b[z,y];
      r[x,z] := a[x,z]+b[x,z]; r[y,z] := a[y,z]+b[y,z]; r[z,z] := a[z,z]+b[z,z]
   end;

procedure negv (v: vect; var r: vect);
   begin
      r[x] := -v[x];      r[y] := -v[y];      r[z] := -v[z]
   end;

procedure negm (m: mat ; var r: mat );
   begin
      r[x,x]:=-m[x,x];    r[y,x]:=-m[y,x];    r[z,x]:=-m[z,x];
      r[x,y]:=-m[x,y];    r[y,y]:=-m[y,y];    r[z,y]:=-m[z,y];
      r[x,z]:=-m[x,z];    r[y,z]:=-m[y,z];    r[z,z]:=-m[z,z]
   end;

procedure t (m: mat ; var r: mat );
   begin
      r[x,x] := m[x,x];   r[y,x] := m[x,y];   r[z,x] := m[x,z];
      r[x,y] := m[y,x];   r[y,y] := m[y,y];   r[z,y] := m[y,z];
      r[x,z] := m[z,x];   r[y,z] := m[z,y];   r[z,z] := m[z,z]
   end;

function auto_a (m: mat): boolean;
   var
       r    : mat;
       i, j : crdn;

   begin
      t(m,r);
      i := x;
      j := x;
      while ((i <> z) or (j <> z)) and (m[i,j] = r[i,j])
      do begin
         i:=suiv(i);
         if i=x then j:=suiv(j)
      end;

      if ((i=z) and (j=z)) and (m[z,z]=r[z,z])
      then auto_a:=true
      else auto_a:=false
   end;

function anti_aa (m: mat): boolean;
   var
      r    : mat;
      i, j : crdn;

   begin
      t (m, r);
      negm (r, r);
      i := x;
      j := x;
      while ((i<>z) or (j<>z)) and (m[i,j]=r[i,j])
      do begin
         i := suiv(i);
         if i = x
         then
            j := suiv(j)
      end;

      if ((i=z) and (j=z)) and (m[z,z]=r[z,z])
      then anti_aa:=true
      else anti_aa:=false
   end;

function norme2v (v: vect): real;
   begin
     norme2v := sqr(v[x])+sqr(v[y])+sqr(v[z])
   end;

function normev (v: vect): real;
   begin
      normev := sqrt(sqr(v[x])+sqr(v[y])+sqr(v[z]))
   end;

function normerv (var v: vect): boolean;
   var
      n : real;

   begin
      n := normev(v);
      if n=0
      then
         normerv := false
      else begin
         vmults (v,1/n,v);
         normerv := true
      end
   end;

function discrim (m : mat; i, j : crdn) : real;
   var
      a, b, c, d : crdn;

   begin
      a := suiv(i);
      b := suiv(a);
      c := suiv(j);
      d := suiv(c);
      discrim := m[a,c]*m[b,d]-m[a,d]*m[b,c]
   end;

function det (m : mat) : real;
   var
      i : crdn;
      d : real;

   begin
      d := 0;
      for i := x to z
      do
         d := d+m[i,x]*discrim(m,i,x);
      det := d
   end;

function trace (m : mat) : real;
   begin
      trace := m[x,x]+m[y,y]+m[z,z];
   end;

procedure tmcofact (m : mat; var r : mat);
   var
      i, j : crdn;

   begin
      for i := x to z
      do
         for j := x to z
         do
            r[i,j] := discrim(m,j,i)
   end;

function inversion (m : mat ; var r : mat) : boolean;
   var
      d : real;

   begin
      d := det(m);
      if d = 0
      then
         inversion := false
      else begin
         tmcofact (m, r);
         mmults   (r, 1/d, r);
         inversion := true
      end
   end;

function produits (a, b : vect) : real;
   begin
      produits := a[x]*b[x]+a[y]*b[y]+a[z]*b[z]
   end;

procedure vmultm (v: vect; m: mat ; var r: vect);
   begin
      r[x] :=v[x]*m[x,x]+v[y]*m[x,y]+v[z]*m[x,z];
      r[y] :=v[x]*m[y,x]+v[y]*m[y,y]+v[z]*m[y,z];
      r[z] :=v[x]*m[z,x]+v[y]*m[z,y]+v[z]*m[z,z]
   end;

procedure mmultv (m: mat ; v: vect; var r: vect);
   begin
      r[x] :=v[x]*m[x,x]+v[y]*m[y,x]+v[z]*m[z,x];
      r[y] :=v[x]*m[x,y]+v[y]*m[y,y]+v[z]*m[z,y];
      r[z] :=v[x]*m[x,z]+v[y]*m[y,z]+v[z]*m[z,z]
   end;

procedure produitm(a,b:mat ;var r:mat );
   begin
      r[x,x] := b[x,x]*a[x,x]+ b[x,y]*a[y,x]+ b[x,z]*a[z,x];
      r[y,x] := b[y,x]*a[x,x]+ b[y,y]*a[y,x]+ b[y,z]*a[z,x];
      r[z,x] := b[z,x]*a[x,x]+ b[z,y]*a[y,x]+ b[z,z]*a[z,x];

      r[x,y] := b[x,x]*a[x,y]+ b[x,y]*a[y,y]+ b[x,z]*a[z,y];
      r[y,y] := b[y,x]*a[x,y]+ b[y,y]*a[y,y]+ b[y,z]*a[z,y];
      r[z,y] := b[z,x]*a[x,y]+ b[z,y]*a[y,y]+ b[z,z]*a[z,y];

      r[x,z] := b[x,x]*a[x,z]+ b[x,y]*a[y,z]+ b[x,z]*a[z,z];
      r[y,z] := b[y,x]*a[x,z]+ b[y,y]*a[y,z]+ b[y,z]*a[z,z];
      r[z,z] := b[z,x]*a[x,z]+ b[z,y]*a[y,z]+ b[z,z]*a[z,z]
   end;

procedure trfmat(v : vect; var m : mat);
   begin
      m := mzero;
      m[y,z] := v[x];       m[z,x]:= v[y];    m[x,y]:= v[z];
      m[z,y] :=-v[x];       m[x,z]:=-v[y];    m[y,x]:=-v[z]
   end;

function trfvect(m : mat ; var v : vect) : boolean;
   var
      b : boolean;

   begin
      b:=anti_aa(m);    trfvect:=b;
      if b
      then begin
         v[x] := m[y,z];     v[y] := m[z,x];        v[z] := m[x,y]
      end
   end;

procedure produitv(a, b : vect; var r : vect);
   begin
      r[x] := a[y]*b[z]-a[z]*b[y];
      r[y] := a[z]*b[x]-a[x]*b[z];
      r[z] := a[x]*b[y]-a[y]*b[x]
    end;

procedure creerbase (a, b : vect; var u, v, w : vect);
   procedure projp (a, b : vect; var r : vect);
      begin
         vmults (b, -produits (b, a), r);
         sommev (a, r, r)
       end;

    begin
       u := a;
       if not normerv(u)
       then u := vux;
       projp(b,u,v);  { v est la projection de b sur le plan orthogonal  u. }
       if not normerv(v)
       then begin
          projp(vuy,u,v);
          if not normerv(v)
          then begin
             projp(vuz,u,v);
             if normerv(v) then begin end
          end
       end;
       produitv(u,v,w)
   end;

procedure mrotation (u : vect; a : real; var m : mat);
   var
      mu : mat;

   begin
      trfmat   (u, mu);
      mmults   (mu, sin(a), m);
      sommem   (mid, m, m);
      produitm (mu, mu, mu);
      mmults   (mu, 1-cos(a), mu);
      sommem   (m, mu, m)
   end;

procedure mprojp (u : vect; var m : mat);
   begin
      trfmat   (u, m);
      produitm (m, m, m);
      negm     (m, m)
   end;

procedure mprojd (u: vect; var m : mat);
   begin
      trfmat   (u, m);
      produitm (m, m, m);
      sommem   (mid, m, m)
   end;

function arccos (c : real) : real;
   var
      s, a           : real;

   begin
      if c = 0
      then
         a := pi/2
      else begin
         s := sqrt(1/(c*c)-1);
         a := arctan(s);
         if c < 0 then a := pi-a
      end;
      arccos := a
   end;

procedure projsph (a, b, c, u: vect; var aa, bb, r: real);
   var
      v              : vect;

   begin
      aa := 0;
      bb := 0;
      r  := normev (u);
      if normerv (u)
      then begin
         bb     := arccos (produits (u, c));
         v[x]   := produits (u, a);
         v[y]   := produits (u, b);
         v[z]   := 0;
         if normerv(v)
         then aa   := arccos (produits (v, a));

         if produits (v,b) < 0
         then aa   := -aa
      end
   end;

procedure affichev (v: vect; c, l : integer; ch : string);
   var
      i              : crdn;
      j              : 0..1;

   begin
      j := 0;
      if ch <> ''
      then  begin
         gotoxy (c, l);
         write (ch);
         j := 1
      end;

      for i := x to z
      do begin
         gotoxy (c, l+ord(i)+j);
         write (v[i]:3:2)
      end
   end;

procedure affichem (m :mat; c, l: integer; ch: string);
   var
      i, j              : crdn;
      k                 : 0..1;

   begin
      k := 0;
      if ch <> ''
      then  begin
         gotoxy (c, l);
         write  (ch);
         k := 1
      end;

      for i := x to z
      do begin
         gotoxy (c, l+ord(i)+k);
         for j := x to z
         do
            write (m [j, i]:3:2,'  ')
      end
   end;

END.
{--- MATH3D_C ----------------------------------------------- ARX - BALMA --}
