Unit IGRF_;
        { *************************************************
          *  international  geomagnetic  reference  field *
          *         (  i . g . r . f .  1980. )           *
          *************************************************
        }
Interface
{$O+,F+}
Uses Exo_var,Geo_var,MathH;

Function GIgrf (Lat,Long,Alti : Real; Jour,Mois,An : Integer;
                Var Declin, Inclin : Real;
                Var Erreur : String) : Real;
{ Calcule la valeur du champ total  une date donne, la dclinaison
  et l'inclinaison correspondant  la date et  la position  partir
  des coefficients en harmoniques sphriques des mesures dfinitives
  et prvisionnelles du champ geomagnetique international de rfrence (IGRF)

      lat     latitude geographique
      long    longitude geographique
      alti    altitude
      gigrf   champ magnetique total en nanotesla
      Inclin  inclinaison du champ 'present'
      Declin  declinaison du champ 'present'

  Les donnes du champ de rfrence sont lues dans le fichier IGRF.DAT
  qui est un fichier texte ASCII commencant par une ligne d'en-tte
  contenant la chane "IGRFxxxx" o xxxx reprsente l'anne, suivie
  des donnes correspondant aux priodes de 5 ans dpuis 1945.
  Les donnes d'une priode sont une suite de 120 rels prcde par
  une ligne d'en-tte contenant la chane "DGRFxxxx" o xxxx reprsente
  l'anne.
  En cas de mise  jour du fichier IGRF.DAT, pourvu que la structure
  du nouveau fichier soit correcte, le code n'a pas  tre modifi.
}

Implementation
Const nrcoef = 120; nrepoch = 10; nrcoefsv = 80; nrcoefsh = 65; nrord = 10;

Type  TDgrf   = Array[1..NrCoef]of Real;
      TCoefSH = Array[1..nrcoefsh] of real;
      TCoefSV = Array[1..nrcoefsv] of real;
      TOrd    = Array[1..nrord] of real;


Procedure CalculEpoque (Jour,Mois,An : Integer;
                        Var Epoque : Integer;
                        Var TDif, EFrac,CompEFrac : Real);
{ Epoque est l'anne de la dernire srie de donnes disponibles dans le
  fichier IGRF avant la date de calcul, frac est la fraction de priode
  de 5 ans qui spare la date de calcul de l'Epoque}
Const nd:Array[1..12] of Integer=(0,31,59,90,120,151,181,212,243,273,304,334);
Var dagjaar,ndag : Integer;
Begin ndag:=jour+nd[mois]; dagjaar:=365;
      if (mois>2)and((an mod 4)=0) then begin {anne bissextile}
         inc(dagjaar); inc(ndag) end;
      Epoque := 5 * (An Div 5);
      TDif   := (An - Epoque)+(ndag / dagjaar);
      EFrac  := 0.2 * TDif;
      CompEFrac := 1-EFrac;
end;


Function GIgrf (Lat,Long,Alti : Real; Jour,Mois,An : Integer;
                Var Declin, Inclin : Real;
                Var Erreur : String) : Real;
Var f : text;
    Epoque, DerniereEpoque, Code,
    i, j, k, l, m, n    : Integer;
    TDif, EFrac,  CompEFrac, SLat,   CLat,
    One, Two, three, four, ratio, a2, b2, rr, fn, fm, hork, hor,
    x, y, z, r, cd, sd  : Real;
    Entete,Entete1,Entete2 : String[10];
    UsesSecVar : Boolean; {vrai si on doit extrapoler au del de l'IGRF}
    p,q        : TCoefSh;
    cl,sl      : TOrd;
    DGRF1,DGRF2: tdgrf;
    SecVar     : tcoefsv;

Begin Erreur :='';
      If An<45 then begin
         Erreur:='Pas de calcul possible avant 1945'; exit end;
      If (An<=99) then An:=1900+An else An:=2000+An;
      Assign(f,cheminmodule+NomFIGRF); ReSet(f); ReadLn(f,Entete);
      Val(Copy(Entete,5,4),DerniereEpoque,Code);
      If Code<>0 then begin
         Erreur:='Fichier '+NomFIGRF+' incorrect'; Close(f); exit end;
      CalculEpoque(Jour, Mois, An, Epoque, TDif, EFrac, CompEFrac);
      If Epoque>DerniereEpoque then begin
         Erreur:='Les donnes IGRF ne permettent pas de calculer le champ, il faut une mise  jour du fichier '+NomFIGRF;
         Close(f); exit end;
      UsesSecVar:=Epoque=DerniereEpoque;
{Lecture des valeurs appropries dans le fichier IGRF.DAT}
      Str(Epoque,Entete1); Entete1:='DGRF'+Entete1;
      Repeat ReadLn(f,Entete) until EOF(f) or (Entete=Entete1);
      If EOF(f) then begin
         Erreur:='Fichier '+NomFIGRF+' incorrect'; Close(f); exit end;
      For i:=0 to 14 do begin
          for j:=1 to 7 do Read(f,DGRF1[(8*i)+j]);
          ReadLn(f,DGRF1[(8*i)+8])
      end;
      If UsesSecVar then begin
           Repeat ReadLn(f,Entete) until EOF(f) or (Entete='secvar');
           If EOF(f) then begin
              Erreur:='Fichier '+NomFIGRF+' incorrect'; Close(f); exit end;
           For i:=0 to 9 do begin
               for j:=1 to 7 do Read(f,SecVar[(8*i)+j]);
               ReadLn(f,SecVar[(8*i)+8])
           end; end
      else begin
           Str(Epoque+5,Entete2); Entete2:='DGRF'+Entete2;
           Repeat ReadLn(f,Entete) until EOF(f) or (Entete=Entete2);
           If EOF(f) then begin
              Erreur:='Fichier '+NomFIGRF+' incorrect'; Close(f); exit end;
           For i:=0 to 14 do begin
               for j:=1 to 7 do Read(f,DGRF2[(8*i)+j]);
               ReadLn(f,DGRF2[(8*i)+8])
           end;
      end;
      Close(f);
{ Initialisation du calcul }
      one   := (90. - lat) * rad;
      slat  := cos (one);
      clat  := sin (one);
      one   := long * rad;
      cl[1] := cos (one);
      sl[1] := sin (one);
      x     := 0.0;
      y     := 0.0;
      z     := 0.0;
      l     := 1;
      m     := 1;
      n     := 0;
{ Conversion des coordonnes godsiques en gocentriques }
      a2    := 40680925;
      b2    := 40408585;
      one   := a2 * clat * clat;
      two   := b2 * slat * slat;
      three := one + two ;
      four  := sqrt (three);
      r     := sqrt (alti * (alti + 2. * four) +
                   (a2 * one + b2 * two) / three);
      cd    := (alti + four) / r;
      sd    := (a2 - b2) / four * slat * clat / r;
      one   := slat;
      slat  := slat * cd - clat * sd;
      clat  := clat * cd +  one * sd;

      ratio := 6371.2 / r;

{ calcul des coefficients quasi-normaliss de schmidt  p and x(=q)}
      p [1] := 2.0 * slat;
      p [2] := 2.0 * clat;
      p [3] := 4.5 * slat * slat - 1.5;
      p [4] := 5.1961524 * clat * slat;
      q [1] := -clat;
      q [2] :=  slat;
      q [3] := -3.0 * clat * slat;
      q [4] := 1.7320508 * (slat * slat - clat * clat);

      { calcul de la valeur de la fonction en harmoniques spheriques}
      For k := 1 to nrcoefsh do begin
          if (m > n) then begin
            m := 0;
            n := n + 1;
            rr := IPuissance(ratio,(n + 2));
            fn := {float (n)}n;
          end;
          fm := {float (m)}m;
          if (k >= 5) then
            if (m = n) then begin
              one    := sqrt (1. - 0.5 / fm);
              j      := k - n - 1;
              p [k]  := (1. + 1. / fm) * one * clat * p[j];
              q [k]  := one * (clat * q [j] + slat / fm * p [j]);
              sl [m] := sl [m - 1] * cl [1] + cl [m - 1] * sl [1];
              cl [m] := cl [m - 1] * cl [1] - sl [m - 1] * sl [1]; end
            else begin
              one    := sqrt (fn * fn - fm * fm);
              two    := sqrt (sqr(fn - 1) - sqr(fm)) / one;
              three  := (2. * fn - 1) / one;
              i      := k - n;
              j      := k - 2 * n + 1;
              p [k]  := (fn + 1) *
                (three * slat / fn * p [i] - two / (fn - 1.0) * p [j]);
              q [k]  :=
                three * (slat * q[i] - clat / fn * p [i]) - two * q [j]
            end;

          { synthesis de x, y et z en coordonnes geocentriques }
          if (not usesSecvar) then
            one := rr * (compefrac * dgrf1 [l] + efrac * dgrf2 [l])
          else
            if (l <= nrcoefsv) then
              one := rr * (dgrf1 [l] + tdif * secvar [l])
            else
              one := rr * dgrf1 [l];
           {endif
          endif}
          if (m = 0) then begin
            x     := x + one * q [k];
            z     := z - one * p [k];
            l     := l + 1; end
          else begin
            if (not usesSecvar) then
              two := rr * (compefrac * dgrf1 [l + 1] +
                          efrac * dgrf2 [l + 1])
            else
              if (l < nrcoefsv) then
                two := rr * (dgrf1 [l + 1] + tdif * secvar [l + 1])
              else
                two := rr * dgrf1 [l + 1];
             {endif
            endif}
            three := one * cl [m] + two * sl [m];
            x     := x + three * q [k];
            z     := z - three * p [k];
            if (clat > 0) then
              y := y + (one * sl [m] - two * cl [m]) * fm * p [k] /
                       ((fn + 1) * clat)
            else
              y := y + (one * sl [m] - two * cl [m]) * q [k] * slat;
           {endif}
            l := l + 2;
          end;{ if m = 0 }
          m := m + 1;
      end;

      { calcul de la composante horizontale, verticale et du champ total}
      one    := x;
      x      := x * cd +   z * sd;
      z      := z * cd - one * sd;
      hork   := sqr(x)+sqr(y);
      gigrf  := sqrt (hork + sqr(z));

      { calculate de l'inclinaison et de la dclinaison }
      hor    := sqrt (hork);
      declin := atan2 (y, x) / rad;
      inclin := atan2 (z, hor) / rad;
end;

END.

{
  dgrf is the complete set for all epochs
  partitioned for each epoch for data statements

      dimension dgrf (nrcoef, nrepoch)
      dimension dgrf45 (nrcoef), dgrf50 (nrcoef), dgrf55 (nrcoef)
      dimension dgrf60 (nrcoef), dgrf65 (nrcoef), dgrf70 (nrcoef)
      dimension dgrf75 (nrcoef), dgrf80 (nrcoef), dgrf85 (nrcoef)
      dimension igrf (nrcoef), secvar (nrcoefsv)
      equivalence (dgrf45, dgrf (1, 1)), (dgrf50, dgrf (1, 2))
      equivalence (dgrf55, dgrf (1, 3)), (dgrf60, dgrf (1, 4))
      equivalence (dgrf65, dgrf (1, 5)), (dgrf70, dgrf (1, 6))
      equivalence (dgrf75, dgrf (1, 7)), (dgrf80, dgrf (1, 8))
      equivalence (dgrf85, dgrf (1, 9))
      equivalence (igrf, dgrf (1, nrepoch))
{
  The following data statements supply s.h. coefficients for
  the different epochs

  These coefficients are updated till dgrf85 and igrf90 with secular variation
  for 90-95 (R.A. Langel, IAGA News, nr 30 p 69 (1991)), or better,
  Journal of Geomagnetism and Geoelectricity Vol 43 p1007-1012, 1991.
  For future updates simply bring igrf up to date, change the name into the
  appropriate dgrfnn, add an equivalence to the list, make a new igrf,
  update the secvar and increment nrepoch in the parameter statement
  The code does not need to be changed!
c
c dgrf (*, 1) for epoch 1945.0
c
      data dgrf45/
     1  -30594, -2285,  5810, -1244,  2990, -1702,  1578,   477,
     1    1282, -1834,  -499,  1255,   186,   913,   -11,   944,
     1     776,   144,   544,  -276,  -421,   -55,   304,  -178,
     1    -253,   346,   -12,   194,    95,   -20,   -67,  -142,
     1    -119,   -82,    82,    59,    57,     6,     6,   100,
     1    -246,    16,   -25,    -9,    21,   -16,  -104,   -39,
     1      70,   -40,   -45,     0,   -18,     0,     2,   -29,
     1       6,   -10,    28,    15,   -17,    29,   -22,    13,
     1       7,    12,    -8,   -21,    -5,   -12,     9,    -7,
     1       7,     2,   -10,    18,     7,     3,     2,   -11,
     1       5,   -21,   -27,     1,    17,   -11,    29,     3,
     1      -9,    16,     4,    -3,     9,    -4,     6,    -3,
     1       1,    -4,     8,    -3,    11,     5,     1,     1,
     1       2,   -20,    -5,    -1,    -1,    -6,     8,     6,
     1      -1,    -4,    -3,    -2,     5,     0,    -2,    -2./
c
c dgrf (*, 2) for epoch 1950.0
c
      data dgrf50/
     1  -30554, -2250,  5815, -1341,  2998, -1810,  1576,   381,
     1    1297, -1889,  -476,  1274,   206,   896,   -46,   954,
     1     792,   136,   528,  -278,  -408,   -37,   303,  -210,
     1    -240,   349,     3,   211,   103,   -20,   -87,  -147,
     1    -122,   -76,    80,    54,    57,    -1,     4,    99,
     1    -247,    33,   -16,   -12,    12,   -12,  -105,   -30,
     1      65,   -55,   -35,     2,   -17,     1,     0,   -40,
     1      10,    -7,    36,     5,   -18,    19,   -16,    22,
     1      15,     5,    -4,   -22,    -1,     0,    11,   -21,
     1      15,    -8,   -13,    17,     5,    -4,    -1,   -17,
     1       3,    -7,   -24,    -1,    19,   -25,    12,    10,
     1       2,     5,     2,    -5,     8,    -2,     8,     3,
     1     -11,     8,    -7,    -8,     4,    13,    -1,    -2,
     1      13,   -10,    -4,     2,     4,    -3,    12,     6,
     1       3,    -3,     2,     6,    10,    11,     3,     8./
c
c dgrf (*, 3) for epoch 1955.0
c
      data dgrf55/
     1  -30500, -2215,  5820, -1440,  3003, -1898,  1581,   291,
     1    1302, -1944,  -462,  1288,   216,   882,   -83,   958,
     1     796,   133,   510,  -274,  -397,   -23,   290,  -230,
     1    -229,   360,    15,   230,   110,   -23,   -98,  -152,
     1    -121,   -69,    78,    47,    57,    -9,     3,    96,
     1    -247,    48,    -8,   -16,     7,   -12,  -107,   -24,
     1      65,   -56,   -50,     2,   -24,    10,    -4,   -32,
     1       8,   -11,    28,     9,   -20,    18,   -18,    11,
     1       9,    10,    -6,   -15,   -14,     5,     6,   -23,
     1      10,     3,    -7,    23,     6,    -4,     9,   -13,
     1       4,     9,   -11,    -4,    12,    -5,     7,     2,
     1       6,     4,    -2,     1,    10,     2,     7,     2,
     1      -6,     5,     5,    -3,    -5,    -4,    -1,     0,
     1       2,    -8,    -3,    -2,     7,    -4,     4,     1,
     1      -2,    -3,     6,     7,    -2,    -1,     0,    -3./
c
c dgrf (*, 4) for epoch 1960.0
c
      data dgrf60/
     1  -30421, -2169,  5791, -1555,  3002, -1967,  1590,   206,
     1    1302, -1992,  -414,  1289,   224,   878,  -130,   957,
     1     800,   135,   504,  -278,  -394,     3,   269,  -255,
     1    -222,   362,    16,   242,   125,   -26,  -117,  -156,
     1    -114,   -63,    81,    46,    58,   -10,     1,    99,
     1    -237,    60,    -1,   -20,    -2,   -11,  -113,   -17,
     1      67,   -56,   -55,     5,   -28,    15,    -6,   -32,
     1       7,    -7,    23,    17,   -18,     8,   -17,    15,
     1       6,    11,    -4,   -14,   -11,     7,     2,   -18,
     1      10,     4,    -5,    23,    10,     1,     8,   -20,
     1       4,     6,   -18,     0,    12,    -9,     2,     1,
     1       0,     4,    -3,    -1,     9,    -2,     8,     3,
     1       0,    -1,     5,     1,    -3,     4,     4,     1,
     1       0,     0,    -1,     2,     4,    -5,     6,     1,
     1       1,    -1,    -1,     6,     2,     0,     0,    -7./
c
c dgrf (*, 5) for epoch 1965.0
c
      data dgrf65/
     1  -30334, -2119,  5776, -1662,  2997, -2016,  1594,   114,
     1    1297, -2038,  -404,  1292,   240,   856,  -165,   957,
     1     804,   148,   479,  -269,  -390,    13,   252,  -269,
     1    -219,   358,    19,   254,   128,   -31,  -126,  -157,
     1     -97,   -62,    81,    45,    61,   -11,     8,   100,
     1    -228,    68,     4,   -32,     1,    -8,  -111,    -7,
     1      75,   -57,   -61,     4,   -27,    13,    -2,   -26,
     1       6,    -6,    26,    13,   -23,     1,   -12,    13,
     1       5,     7,    -4,   -12,   -14,     9,     0,   -16,
     1       8,     4,    -1,    24,    11,    -3,     4,   -17,
     1       8,    10,   -22,     2,    15,   -13,     7,    10,
     1      -4,    -1,    -5,    -1,    10,     5,    10,     1,
     1      -4,    -2,     1,    -2,    -3,     2,     2,     1,
     1      -5,     2,    -2,     6,     4,    -4,     4,     0,
     1       0,    -2,     2,     3,     2,     0,     0,    -6./
c
c dgrf (*, 6) for epoch 1970.0
c
      data dgrf70/
     1  -30220, -2068,  5737, -1781,  3000, -2047,  1611,    25,
     1    1287, -2091,  -366,  1278,   251,   838,  -196,   952,
     1     800,   167,   461,  -266,  -395,    26,   234,  -279,
     1    -216,   359,    26,   262,   139,   -42,  -139,  -160,
     1     -91,   -56,    83,    43,    64,   -12,    15,   100,
     1    -212,    72,     2,   -37,     3,    -6,  -112,     1,
     1      72,   -57,   -70,     1,   -27,    14,    -4,   -22,
     1       8,    -2,    23,    13,   -23,    -2,   -11,    14,
     1       6,     7,    -2,   -15,   -13,     6,    -3,   -17,
     1       5,     6,     0,    21,    11,    -6,     3,   -16,
     1       8,    10,   -21,     2,    16,   -12,     6,    10,
     1      -4,    -1,    -5,     0,    10,     3,    11,     1,
     1      -2,    -1,     1,    -3,    -3,     1,     2,     1,
     1      -5,     3,    -1,     4,     6,    -4,     4,     0,
     1       1,    -1,     0,     3,     3,     1,    -1,    -4./
c
c dgrf (*, 7) for epoch 1975.0
c
      data dgrf75/
     1  -30100, -2013,  5675, -1902,  3010, -2067,  1632,   -68,
     1    1276, -2144,  -333,  1260,   262,   830,  -223,   946,
     1     791,   191,   438,  -265,  -405,    39,   216,  -288,
     1    -218,   356,    31,   264,   148,   -59,  -152,  -159,
     1     -83,   -49,    88,    45,    66,   -13,    28,    99,
     1    -198,    75,     1,   -41,     6,    -4,  -111,    11,
     1      71,   -56,   -77,     1,   -26,    16,    -5,   -14,
     1      10,     0,    22,    12,   -23,    -5,   -12,    14,
     1       6,     6,    -1,   -16,   -12,     4,    -8,   -19,
     1       4,     6,     0,    18,    10,   -10,     1,   -17,
     1       7,    10,   -21,     2,    16,   -12,     7,    10,
     1      -4,    -1,    -5,    -1,    10,     4,    11,     1,
     1      -3,    -2,     1,    -3,    -3,     1,     2,     1,
     1      -5,     3,    -2,     4,     5,    -4,     4,    -1,
     1       1,    -1,     0,     3,     3,     1,    -1,    -5./
c
c dgrf (*, 8) for epoch 1980.0
c
      data dgrf80/
     1  -29992, -1956,  5604, -1997,  3027, -2129,  1663,  -200,
     1    1281, -2180,  -336,  1251,   271,   833,  -252,   938,
     1     782,   212,   398,  -257,  -419,    53,   199,  -297,
     1    -218,   357,    46,   261,   150,   -74,  -151,  -162,
     1     -78,   -48,    92,    48,    66,   -15,    42,    93,
     1    -192,    71,     4,   -43,    14,    -2,  -108,    17,
     1      72,   -59,   -82,     2,   -27,    21,    -5,   -12,
     1      16,     1,    18,    11,   -23,    -2,   -10,    18,
     1       6,     7,     0,   -18,   -11,     4,    -7,   -22,
     1       4,     9,     3,    16,     6,   -13,    -1,   -15,
     1       5,    10,   -21,     1,    16,   -12,     9,     9,
     1      -5,    -3,    -6,    -1,     9,     7,    10,     2,
     1      -6,    -5,     2,    -4,    -4,     1,     2,     0,
     1      -5,     3,    -2,     6,     5,    -4,     3,     0,
     1       1,    -1,     2,     4,     3,     0,     0,    -6./
c
c dgrf (*, 9) for epoch 1985.0
c
      data dgrf85/
     1  -29873, -1905,  5500, -2072,  3044, -2197,  1687,  -306,
     1    1296, -2208,  -310,  1247,   284,   829,  -297,   936,
     1     780,   232,   361,  -249,  -424,    69,   170,  -297,
     1    -214,   355,    47,   253,   150,   -93,  -154,  -164,
     1     -75,   -46,    95,    53,    65,   -16,    51,    88,
     1    -185,    69,     4,   -48,    16,    -1,  -102,    21,
     1      74,   -62,   -83,     3,   -27,    24,    -2,    -6,
     1      20,     4,    17,    10,   -23,     0,    -7,    21,
     1       6,     8,     0,   -19,   -11,     5,    -9,   -23,
     1       4,    11,     4,    14,     4,   -15,    -4,   -11,
     1       5,    10,   -21,     1,    15,   -12,     9,     9,
     1      -6,    -3,    -6,    -1,     9,     7,     9,     1,
     1      -7,    -5,     2,    -4,    -4,     1,     3,     0,
     1      -5,     3,    -2,     6,     5,    -4,     3,     0,
     1       1,    -1,     2,     4,     3,     0,     0,    -6./
c
c dgrf (*, 10) (igrf) for epoch 1990.0
c
      data igrf/
     1  -29775, -1851,  5411, -2136,  3058, -2278,  1693,  -380,
     1    1315, -2240,  -287,  1246,   293,   807,  -348,   939,
     1     782,   248,   324,  -240,  -423,    87,   142,  -299,
     1    -211,   353,    47,   244,   153,  -111,  -154,  -166,
     1     -69,   -37,    98,    61,    64,   -16,    60,    83,
     1    -178,    68,     2,   -52,    17,     2,   -96,    27,
     1      77,   -64,   -81,     4,   -27,    28,     1,     1,
     1      20,     6,    16,    10,   -23,     0,    -5,    22,
     1       5,    10,    -1,   -20,   -11,     7,   -12,   -22,
     1       4,    12,     4,    11,     3,   -16,    -6,   -11,
     1       4,    10,   -21,     1,    15,   -12,    10,     9,
     1      -6,    -4,    -6,    -1,     9,     7,     9,     2,
     1      -7,    -6,     2,    -4,    -4,     1,     2,     0,
     1      -5,     3,    -2,     6,     4,    -4,     3,     0,
     1       1,    -1,     2,     4,     3,     0,     0,    -6./
c
c secular variation for epochs after 1990.0
c
      data secvar/
     1     18.0,   10.6,  -16.1,  -12.9,    2.4,  -15.8,    0.0,  -13.8,
     1      3.3,   -6.7,    4.4,    0.1,    1.6,   -5.9,  -10.6,    0.5,
     1      0.6,    2.6,   -7.0,    1.8,    0.5,    3.1,   -5.5,   -1.4,
     1      0.6,   -0.1,   -0.1,   -1.6,    0.5,   -3.1,    0.4,   -0.1,
     1      1.7,    2.3,    0.4,    1.3,   -0.2,    0.2,    1.8,   -1.3,
     1      1.3,    0.0,   -0.2,   -0.9,    0.1,    0.5,    1.2,    1.2,
     1      0.6,   -0.5,    0.6,   -0.3,    0.2,    0.6,    0.8,    1.6,
     1     -0.5,    0.2,   -0.2,    0.2,    0.0,    0.3,    0.0,    0.2,
     1     -0.7,    0.5,   -0.2,   -0.2,    0.1,    0.3,   -1.1,    0.3,
     1      0.0,    0.4,   -0.1,   -0.5,   -0.5,   -0.3,   -0.6,    0.6/
c
      subroutine gdag (idatum, idag, imnd, ijaar, ndag)
c_______________________________________________________________________
c
c * calculates from european date the julian date and the
c * components of the date
c *
c * same as vdag, only with integer*4 date
c *
c * date is da-mo-yr:  220245 is 22 feb 1945
c_______________________________________________________________________
c
        integer*4 idatum
        dimension nd (12)
        data nd/ 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334/
c
          ia = idatum / 100
          idag = ia / 100
          imnd = mod (ia, 100)
          ijaar = mod (idatum, 100)
          ndag = idag + nd (imnd)
c leap year ?
          if (mod (ijaar, 4) .eq. 0 .and. imnd .gt. 2) ndag = ndag + 1
        return
      end

