UNIT IMP_portr;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          "drivers" copie d'cran                          }
{                                                               29/03/95    }
{---------------------------------------------------------------------------}
{         d'aprs Alain Reverchon  (imprimantes  aiguilles)                }
{                 Pascalissime     (imprimantes type HP)                    }
{                                                                           }
{---------------------------------------------------------------------------}
{  F. BORIE                                                                 }
{---------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   printer,
   CRT,dos,Graph,
   Rs2322;

procedure impr_HP550C(inverse:boolean;MinLig,MinCol,MaxLig,MaxCol:Integer);
   { recopie d'cran vgaNB portrait  sur HP 550 C                           }

PROCEDURE hardcopy (inverse:boolean; mode:byte;MinLig,MinCol,MaxLig,MaxCol:Integer);
   { recopie d'cran vgaNB portrait  sur Epson 9 ou 24 aiguilles            }

{---------------------------------------------------------------------------}
IMPLEMENTATION

Procedure Envoie(S : String);
Var i : byte;
    impreg      : registers;
Begin impreg.dx := 0;
      For i:=1 to Length(s) do begin
          impreg.ax := ord(s[i]);
          intr  ($17, impreg);
      end;
end;

FUNCTION ArretDemande : boolean;
VAR cc:char;
BEGIN
  ArretDemande := FALSE;
  IF NOT Keypressed THEN exit;
  cc := ReadKey;  {Remplacer par read (kbd, cc) si Turbo-Pascal 3.0}
  IF ord (cc) IN [0, 27] THEN ArretDemande := TRUE;
END;

procedure impr_HP550C(inverse:boolean;MinLig,MinCol,MaxLig,MaxCol:Integer);
(* Unit permettant d'imprimer un cran VGA 640*480 ou 640*350 *)
(* sur une imprimante HP 550 couleur                           *)
(* d'aprs PASCALISSIME n56 oct-dc 93                        *)
{Begin imprime_vga_C (100, false); end; { AVEC/sans inversion vido }

CONST Port_VGA  = $03CE;
      Esc       = #27;
      FF        = #12;
{   MaxY      = 3389;     nombre maxi de points sur une page A4  300 ppp
   MaxX      = 2338;
}
Type Direction = (Portrait, Paysage);

Procedure Orientation (Dir : Direction);
   Begin
      Case Dir of
         Portrait : Envoie (Esc+'&l0O');
         Paysage  : Envoie (Esc+'&l1O');
      end;
   end;

Procedure Ejecte;
   Begin
{      Write (Lst, FF)}
       Envoie (Esc+'&l0H');
   end;

Procedure LstXY (X, Y : Word);
   Var
      X0, Y0 : String [4];

   Begin
      Str (X, X0);
      Str (Y, Y0);
      Envoie (Esc+'*b'+X0+'x'+Y0+'Y')
   end;

Procedure Resolution (X : Word);
   Var
      Ch : string [3];

   Begin
      Str (X, Ch);
      Envoie (Esc+'*t'+Ch+'R');
   end;

Procedure LstReset;
   Begin
      Envoie (Esc+'E'+Esc+'9')
   end;

{Procedure Imprime_Vga_C (Resol: Word; Inverse : Boolean);}
   Const
      GraphMemeOrientation = Esc+'*r0F';
      GraphDepart          = Esc+'*r1A';
      GraphFin             = Esc+'*rbC';

   Var
      ModeVideo : Byte;
      X, Y      : Word;
      Registres : Registers;
      Offset    : Word;
      Octet     : byte;

   Begin
      Registres.AH := $0F;
      Intr ($10, Registres);
      ModeVideo := Registres.AL;
      If not (modeVideo in [$10, $12])
      then Write (#7)
      else begin
         PortW [Port_Vga] := $0805;
         PortW [Port_Vga] := $0002;            { mode NB ? }
         PortW [Port_Vga] := $0F07;
         {LstReset;}
         Orientation (Portrait);
{         Case Resol of
            300 : LstXY (850,0);
            150 : LstXY (530,0);
            100 : LstXY (210,0);
            else begin
               Resol := 150;
               LstXY (530, 0)
            end;
         end;
         Resolution (Resol);}
         Resolution(100);LstXY (210,0);
         Envoie (GraphMemeOrientation);
         Envoie (GraphDepart);
         For y := MinLig to MaxLig
         do begin
            Envoie (Esc+'*b80W');
            For X := MinCol div 8 to MaxCol Div 8
            do begin
               Offset := Y*80+X;
{               Envoie(chr(Mem [$A000:Offset]));}
               If Inverse
               then Octet :=      Mem [$A000:Offset]
               else Octet := Not (Mem [$A000:Offset]);
               Envoie (Chr (Octet))
            end;
            If ArretDemande then exit;
         end;
         Envoie (GraphFin);
         {ejecte;}
      end;
   end;

PROCEDURE hardcopy (inverse:boolean; mode:byte;MinLig,MinCol,MaxLig,MaxCol:Integer);

VAR  i     : integer;
     nbpin : byte;

  FUNCTION ConstruitOctet (x, y : integer) : byte;
    CONST Bits : ARRAY [0..7] OF byte=(128,64,32,16,8,4,2,1);
    VAR   b    : byte;
          k    : integer;
    BEGIN
      b := 0;
      FOR k := 0 TO 7 DO
        IF (GetPixel (x, y + k) = 0) OR (y + k > MAXLIG) THEN
            b := b OR Bits [k];
      IF inverse
         THEN ConstruitOctet := b
         ELSE ConstruitOctet := NOT b;
    END;

  PROCEDURE ImprimeLigne (VAR i : integer);
  VAR  x, y       : integer;
       o,b1,b2,b3 : Byte;
  BEGIN
    IF (mode = 1)
      THEN Envoie (chr (27)+'L')
      ELSE Envoie (chr (27)+'*'+chr (mode));
    Envoie (chr (lo (MAXCOL-MinCol+1))+ chr (Hi (MAXCOL-MinCol + 1)));
    FOR x := MinCol to MAXCOL DO
    BEGIN
      y := nbpin * i;
      If Mode <=7 then Envoie (chr (ConstruitOctet (x, y)))
                  else begin {Cas d'une 24 aiguilles}
                  o:= ConstruitOctet(x,y);
                  if odd(o) then b3:=1+2+4 else b3:=0; o:=o shr 1;
                  if odd(o) then b3:=b3+8+16+32;       o:=o shr 1;
                  if odd(o) then begin b3:=b3+64+128;b2:=1 end
                            else b2:=0;                o:=o shr 1;
                  if odd(o) then b2:=b2+2+4+8;         o:=o shr 1;
                  if odd(o) then b2:=b2+16+32+64;      o:=o shr 1;
                  if odd(o) then begin b2:=b2+128;b1:=1+2 end
                            else b1:=0;                o:=o shr 1;
                  if odd(o) then b1:=b1+4+8+16;        o:=o shr 1;
                  if odd(o) then b1:=b1+32+64+128;     o:=o shr 1;
                  Envoie (chr (b1)+chr (b2)+chr (b3));
                  end;
(*      IF (nbpin = 24) THEN
      BEGIN
        Envoie (chr (ConstruitOctet (x, y + 8)));
        Envoie (chr (ConstruitOctet (x, y + 16)));
      END;*)
    END;
    {IF (mode <> 4) THEN }Envoie (#13+#10);
  END;

BEGIN
  If Mode=150 {jet d'encre} then begin
     Impr_HP550C(inverse,MinLig,MinCol,MaxLig,MaxCol); exit end;
{  IF (mode < 7)
    THEN nbpin := 8
    ELSE nbpin := 24;
} NbPin:=8;
  Envoie (chr (27)+'3'+chr (24)); {Interligne = 24/180 inches}
  FOR i:= MinLig DIV nbpin TO (MAXLIG+1) DIV nbpin DO
  BEGIN
    ImprimeLigne (i);
    IF ArretDemande THEN exit;
  END;
  Envoie (chr (27)+'2'); {6 ligne par inch}
END;

END.

{---- IMPRIM ---------------------------------------------------------------}
