UNIT CSI;

   {------------------------------------------------------------------------}
   {                                                                        }
   {                    CLAVIER SOURIS ICONES                               }
   {                                                                        }
   {------------------------------------------------------------------------}
   (*
   Csi,                      { ARX     - Clavier, Souris, Icnes            }
   *)

INTERFACE

{$O+,F+}
USES
   Crt,                      { TP 70   - unit  standard                    }
   Souris,                   { ARX     - gestion de la  souris              }
   Clavier,                  { ARX     - gestion du clavier                 }
   Graphism,                 { ARX     - initialisations graphiques         }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Icones,                   { ARX     - gestion de icnes                  }
   Menus;                    { ARX     - interface menus                    }

VAR
   xs, ys,                             { position souris                    }
   zi,                                 { numro icne                       }
   delai_db_click                      { double click en ms                 }
                        : integer;
   g, d, db,                           { bouton G, bouton D, double click   }
   Affichetexte,                       { bascule AIDE icones F1             }
   Changemenus                         { bascule PROF        Alt P          }
                        : boolean;

Procedure AttendClick  (var x, y, z : integer; var g, d, db : boolean);
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   { ENTREE GLOBALE                                                         }
   {------------------------------------------------------------------------}

Function  ZoneDuClick  (c1, c2, c3, c4 : integer)               : integer;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   { ENTREE GLOBALE                                                         }
   {------------------------------------------------------------------------}

Function  ZonEcran     (x, y : integer)                         : integer;
   {------------------------------------------------------------------------}
   { ROLE                                                                   }
   { ENTREE GLOBALE                                                         }
   {------------------------------------------------------------------------}

Function  FF1          (code : integer)                         : boolean;
   {------------------------------------------------------------------------}
   { ROLE rend VRAI si la touche F1 a t presse sur une entre active MENU}
   { ENTREE GLOBALE                                                         }
   {------------------------------------------------------------------------}

Procedure ChangerIcone (Action1, Action2, Couleur : integer);
   {------------------------------------------------------------------------}
   { ROLE Dmarque l'icne Action1, marque Action2 (encadr de couleur)     }
   { ENTREE GLOBALE                                                         }
   {------------------------------------------------------------------------}

IMPLEMENTATION

function dansZone (x, y, c1, c2, c3, c4 : integer) : boolean;
   begin
      danszone := (x > c1)      and (x < c2)      and
                  (maxy-y > c3) and (maxy-y < c4);
   end;

procedure AttendClick (var x, y, z : integer; var g, d, db : boolean);
   var
      T,
      nul,
      nclics,
      zz                : integer;

   begin
      t := 0;
      changemenus  := false;
      affichetexte := false;
      menuclavier  := false;
      MontrerSouris;
      repeat
         until (not UnBoutonSourisEnfonce);
      LirePositionSouris (x, y);
      zz := Zone (x, y);
      repeat
         LirePositionSouris (x, y);

(*         if (y < HauteurMenu) and (x < posxbtn)
         then
            ChangerCurseurSouris (fleche)
         else
            if zz >= 1
            then                                          { numro icone }
               ChangerCurseurSouris (fleche)
            else
               ChangerCurseurSouris (fleche);*)

         z := Zone (x, y);
         if (z <> zz)
         then begin
            AfficheAide (z);
            zz := z;
         end;

         if ToucheClavier (T)
         then
            case T of
               AltP : Changemenus  := true; { menus longs/courts    }
               F1   : Affichetexte := true; { aide menus/icnes     }
               F10  : menuclavier  := true; { accs barre des menus }
            end;

      until UnBoutonSourisEnfonce or Changemenus
                                  or Affichetexte
                                  or menuclavier
                                 ;

      LireDernierEnfoncementSouris (BoutonGauche, nul, nul, nul);
      LireDernierEnfoncementSouris (BoutonDroit,  nul, nul, nul);
      g := BoutonSourisEnfonce (BoutonGauche);
      d := BoutonSourisEnfonce (BoutonDroit);

      delay (delai_db_click);
      if g
      then
         LireDernierEnfoncementSouris (BoutonGauche, nclics,nul,nul)
      else
         LireDernierEnfoncementSouris (BoutonDroit,  nclics,nul,nul);
      db := (nclics > 0);
      CacherSouris;
   end;

function ZoneDuClick (c1, c2, c3, c4 : integer) : integer;
   begin
      AttendClick (xs, ys, zi, g, d, db);
 (*     if (ys <  HauteurMenu)
         and (xs < posxbtn)
         or menuclavier           { haut cran ou F10  }
      then ZoneDuClick := 1                                        { menus }
      else
         if (ys > maxy-c3)
             and (xs < posxbtn)
         then ZoneDuclick := 4                          { bas cran autres }
         else
            if dansZone (xs, ys, c1, c2, c3, c4)
            then ZoneDuClick := 3                                { fentre }
            else ZoneDuClick := 2;                               { icnes  }
   *)
      if zi > 0
      then
         ZoneDuClick := 2
      else begin
         if (ys <  HauteurMenu)
           { and (xs < posxbtn)}
                { utile pour utilisation d'une icne sur la barre des menus }
            or menuclavier           { haut cran ou F10  }
         then
            ZoneDuClick := 1                                        { menus }
         else
            if (ys > maxy-c3)
{   {             and (xs < posxbtn)  }
            then
               ZoneDuclick := 4                          { bas cran autres }
            else
               if dansZone (xs, ys, c1, c2, c3, c4)
               then
                  ZoneDuClick := 3                       { fentre }
               else
                  ZoneduClick := 4;                      { autres }
      end;
   end;

function Zonecran (x, y : integer) : integer;
   begin
      zonecran := zone (x, y);
   end;

function  FF1 (code : integer) : boolean;
   begin
      FF1 := (code = F1);
   end;

procedure ChangerIcone (Action1, Action2, Couleur : integer);
   begin
      DemarquerIcone (action1);
      MarquerIcone   (Action2, Couleur);
      Repeat
         until Not UnboutonSourisEnfonce;
   end;

BEGIN

   delai_db_click := 250;

END.

{--- CSI ------------------------------------- R.C.- INRP - TOULOUSE - 1993 }
