UNIT GRAPHPLT;

{ --------------------------------------------------------------------------}
{ Roger CULOS et ARX - 6 av de Lagarde 31130 BALMA -    02/05/91            }
{                                                                           }
{---------------------------------------------------------------------------}
{ d'aprs GRAPH2D        ( bibliothque de procdures graphiques de R.DONY) }
{    avec graduation complte des axes (tiquettes, titres)                 }
{         et liaison avec une table compatible HP GL.                       }
{ --------------------------------------------------------------------------}
{ Les graphes et les textes peuvent tre obtenus sur l'cran et sur le      }
{ traceur simultanment ou alternativement avec les bool. ECRAN et TRACEUR. }
{ par dfaut ECRAN est vrai et TRACEUR faux.                                }
{ La sortie papier reflte l'tat de l'cran.                               }
{---------------------------------------------------------------------------}
{ Les bibliothques GRAPHISM et SEKOPLT sont ncessaires.                   }
{ Il faut recompiler avec GRAPHDF au lieu de GRAPHISM pour intgrer toutes  }
{ les polices et pilotes d'cran utiles, sinon les polices LCOM et EURO     }
{ sont ncessaires dans le rpertoire du programme avec le pilote d'cran.  }
{---------------------------------------------------------------------------}
(*
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
*)

INTERFACE

{$O+,F+}

USES
   dos,
   crt,
   graph,           { TP55 - units standard  Borland                       }
   Graphism,        { ARX  - INIGRAPH  revoir en fonction des besoins      }
   Sekoplt;         { ARX  - GESTION du traceur Sekonic/HP7475A  6/8 plumes }

CONST
   MaxPointsPoly        = 100;

TYPE
   point                = record x, y : real end;
   polygone             = array [1..MaxPointsPoly] of point;

VAR
{  maxx, maxy                     : integer; dfinis dans GRAPHISM.INIGRAPH }
   formatpapier         : char;              {   SEKOPLT  }

   xgclot, xdclot,
   ybclot, yhclot       : integer;    { coord. cloture cran }

   papier_x,
   papier_y,
   coef_mm_unit,                  { dimensions effectives
                                                  du papier et coef }
   xgfen, xdfen,
   ybfen, yhfen,                  { coord fentre utilisateur }
   xrap,  yrap          : real;   { rapport cloture / fentre }

   ferme, ouvert        : string [6];
   traceur,
   ecran,
   leve
                        : boolean;
   ddxp, ddyp
                        : integer;    { dcalage clture simule  }
                                                { repre VGA }

{---------------------------------------------------------------------------}

Function distance         (xx1, yy1, xx2, yy2 : real)           : real;
   { Rend la distance entre 2 points de la fentre (coord utilisateur)}

Procedure taille_car_trac (d, i, tiret : integer);
   { Fixe la taille relative des carctres du traceur (Pstyle)
      direction, inclinaison, taille   }

Procedure ttexte          (ch : string; h, v                    : byte);
   { affiche CH sur cran ou traceur  la position courante dans la fentre,}
   { avec justification (cf TP70)                                           }

Procedure ttextePlein     (ch : string; h, v, coul : byte);
   { affiche CH sur le fond COUL                                            }

Procedure ttextxy         (x, y : integer; ch : string);
   { affiche CH sur cran ou traceur  la position indique sans justif.    }
   { le repre est toujours un cran VGA ; la position est recalcule en    }
   { fonction de coef_x et coef_y (cf INIGRAPH).                            }

Procedure mover           (dx, dy : real);
   { dplacement relatif dans la clture TRACEUR/ECRAN.                     }

Procedure liner           (dx, dy : real);
   { trac       relatif dans la clture TRACEUR/ECRAN.                     }

Procedure movet           (x, y : real);
   { dplacement absolu  dans la clture TRACEUR/ECRAN.                     }

Procedure linet           (x, y : real);
   { dplacement absolu  dans la clture TRACEUR/ECRAN.                     }

Procedure ecrantexte;
   { retour  l'cran texte.                                                }

Procedure effaceecran;
   { efface tout l'cran graphique.                                         }

Procedure fenetre         (f1, f2, f3, f4 : real);
   { initialise les coordonnes utilisateur.                                }

Procedure pleinecloture;
   { cloture = cran entier                                                 }

Procedure clotureauto;
   { cloture = cran occup dans sa plus grande dimension                   }

Procedure cloturemilli    (dpx, lpx, dpy, lpy : real);
   { cloture prcise en mm  : dplacements et dimensions                   }

Procedure cloture         (c1, c2, c3, c4 : integer);
   { dfinit la zone occupe sur l'cran.                                   }

{Procedure decoupage (x1, y1, x2, y2 : real);}
   { recherche des intesections avec la cloture.                            }

Procedure tracevers       (x, y : real);
   { trac depuis le point courant jusqu'au point de coordonnes x et y.    }

Procedure deplaceen       (x, y : real);
   { dplacement ....          et trac du point                            }

Procedure deplaceenT      (x, y : real);
   { dplacement ....          et trac du point                            }

Procedure deplaceenl      (x, y : real);
   { dplacement ....    plume leve, sans tracer le point x y              }

Procedure bordure         (c : word);
   { dessine le bordure de la cloture.                                      }

Procedure correctionaxe   (orig, gfen, unitxy : real; var correct : real);
   { rend la correction  apporter au dbut de la graduation                }

Procedure axes;
   { dessine les axes associs  la fentre.                                }
   { met  jour XORIG et YORIG                                              }

Procedure RecalculerUnitx (var unitx : real;
                           var nbdx  : word);
Procedure RecalculerUnity (var unity : real;
                           var nbdy  : word);
   { recalcule automatiquement les intervalles de graduation                }
   { en fonction de la fentre courante et de la clture                    }

Procedure UniteDeGraduation (Min, Max : real; var U : real ;
                                                    var dec : word) ;

Procedure gradue          (unitx, unity : real);
   { graduation simple sans lgende                                         }
   {  APPELER imprativement aprs la procdure AXES                       }

Procedure gradueplt       (unitx, unity                   : real;
                           tiret, nbcx,  nbdx, nbcy, nbdy : word;
                           titrx, titry, titr             : string;
                           posx,  posy,  post             : word;
                           extx,  exty                    : byte);

   { ajoute les valeurs  l'extrieur des axes
              nbc          : nb de chiffres
              nbd          : nb de dcimales
              tiret        : indexe la taille des caractres
              titrx, titry : titres des axes
              posx, posy   : position sur l'axe (1..7)
              titr         : titre du graphe
              post         : position dans la cloture (1..6)
              extx, exty   : avec chiffres: grad. int(1) ext (2) les 2 (0)
                             sans chiffres:          (4)     (5)       (3)  }

Function XUtilisateur     (x : integer)                         : real;
   { Transforme une abscisse cran en abscisse fentre utilisateur          }

Function YUtilisateur     (y : integer)                         : real;

Function XCloture         (x : real)                            : integer;
   { Transforme une abscisse utilisateur en abscisse clture cran          }

Function YCloture         (y : real)                            : integer;

Function XEcran           (x : real)                            : integer;
   { Transforme une abscisse utilisateur en abscisse cran                  }

Function YEcran           (y : real)                            : integer;

Function Xpapier          (x : real)                            : real;
   { Transforme une abscisse utilisateur en abscisse feuille                }
   {                   }
Function Ypapier          (y : real)                            : real;

Function Xpapier_ut       (x : real)                            : real;
   { Transforme une abscisse feuille en abscisse utilisateur                }

Function Ypapier_ut       (y : real)                            : real;

Function dans_fenetre     (x, y : real)                         : boolean;
   { rend VRAI si le couple x,y fait partie de la fentre courante.         }

Function AppartALaCloture (x, y : integer)                      : boolean;
   { rend VRAI si x y dans la clture courante                              }

Procedure grille          (unitx, unity : real);
   { dessine les points de la maille du repre.                             }
   {  APPELER imprativement aprs la procdure AXES                       }

Procedure dessine_lignes  (unitx, unity : real);
   { dessine les lignes de la maille du repre                              }
   {  APPELER imprativement aprs la procdure AXES                       }

Procedure fixecoul        (c     : word);
   { dfinit la couleur courante pour l'cran et le traceur.                }

Procedure fixetrait       (trait : word);
   { dfinit le type de trait courant pour l'cran et le traceur.           }
   { 0 plein 1 points 2 mixte 3 tirets  -  taille par dfaut 4% P1/P2       }

Procedure ini_traceur ;
   { initialise le traceur.                                                 }

Procedure ini_format      (formatpapier : char);
   { initialise les paramtres du traceur.                                  }

Procedure libere_traceur;
   { ferme le canal de communication avec le traceur.                       }

Procedure PolygonePlein   (n : integer; var p : polygone);
   { }

Procedure PolygoneFil     (n : integer; var p : polygone);
   { }

Procedure triangle        (x1, y1, x2, y2, x3, y3         : real; co : word);
   { }

Procedure Carre           (x1, y1, x2, y2, x3, y3, x4, y4 : real; co : word);
   { }

Procedure tracecercle     (xc, yc, r : real; pointille : boolean);
   { }

Procedure cercle          (xc, yc, r : real);
   { }

Procedure cerclepointille (xc, yc, r : real);
   { }

Procedure EffacerCloture;
   { }

{---------------------------------------------------------------------------}
IMPLEMENTATION

TYPE
   pointE               = record
                             x, y : integer
                          end;

   polygoneE            = array [1..MaxPointsPoly] of pointE;

VAR
   ch                   : string;

   avance               : boolean;

   xp1,   yp1,
   xp2,   yp2,                    { coord. point  tracer }
   xorig, yorig                                 { coord. origine des axes }
                        : real;

function distance (xx1, yy1, xx2, yy2 : real) : real;
   var
      d1, d2            : real;

   begin
      xx1 := XCloture (xx1);
      xx2 := XCloture (xx2);
      yy1 := YCloture (yy1);
      yy2 := YCloture (yy2);
      d1  := xx2-xx1;
      d1  := d1*d1;
      d2  := yy2-yy1;
      d2  := d2*d2;
      distance := sqrt (d1+d2)
   end;

function XUtilisateur (x : integer) : real;
   begin
       XUtilisateur := xgfen +        ((x-xgclot) / xrap);
   end;

function YUtilisateur (y : integer) : real;
   begin
       YUtilisateur := ybfen + ((maxy-y-ybclot) / yrap);
   end;

function XEcran       (x : real) : integer;
   { Transforme une abscisse utilisateur en abscisse cran                  }
   { fonction inverse de XUtilisateur                                       }
   begin
       XEcran       := xgclot + xcloture (x);
   end;

function YEcran       (y : real) : integer;
   begin
       YEcran       := maxy - yhclot + ycloture (y);
   end;

function XCloture (x : real) : integer;
   begin
       XCloture := integer (round ((x - xgfen) * xrap));
   end;

function YCloture (y : real) : integer;
   begin
       YCloture := integer (round ((yhfen - y) * yrap));
   end;

function Xpapier (x : real) : real;
   begin
       Xpapier := coef_mm_unit * (x - Xutilisateur (0)) * xrap;
   end;

function Ypapier (y : real) : real;
   begin
       Ypapier := coef_mm_unit * (y - Yutilisateur (maxy)) * yrap;
   end;

function Xpapier_ut (x : real) : real;
   begin
       Xpapier_ut := Xutilisateur (0) + x / (coef_mm_unit * xrap);
   end;

function Ypapier_ut (y : real) : real;
   begin
       Ypapier_ut := Yutilisateur (maxy) + y / (coef_mm_unit * yrap);
   end;

function dans_fenetre  (x, y : real) : boolean;
   begin
      dans_fenetre :=  (x >= xgfen) and (x <= xdfen)
                   and (y >= ybfen) and (y <= yhfen)
   end;

function AppartALaCloture (x, y : integer) : boolean;
   begin
      AppartALaCloture := (x      > xgclot) and (x      < xdclot) and
                          (maxy-y > ybclot) and (maxy-y < yhclot);
   end;

procedure taille_car_trac (d, i, tiret : integer);
   begin
      pstyle (0, 0, tiret/3)
   end;

procedure ttexte (ch : string; h, v : byte);
   begin
      if ch = ''
      then
         exit;
      settextjustify          (h, v);
      if ecran   then outtext (ch);
      if traceur then ptext   (ch, h, v);
      settextjustify          (0, 2);
   end;

procedure ttextePlein (ch : string ; h, v, coul : byte);
   var
      px, py : integer;

   begin
      if ch = ''
      then
         exit;
      settextjustify          (h, v);

      coulbar (solidfill, coul);
      case h of
         0 : px := getx;
         1 : px := getx - textwidth (ch) div 2;
         2 : px := getx - textwidth (ch);
      end;
      case v of
         0 : py := gety;
         1 : py := gety + textheight (ch) div 2;
         2 : py := gety + textheight (ch);
      end;

      if ecran
      then
         bar (px-1,
              py+2 {+1},
              px-1 + textwidth  (ch)+1,
              py   - textheight (ch){-1});
      { mieux centr en hauteur }

      if ecran   then outtext (ch);
      if traceur then ptext   (ch, h, v);
      settextjustify          (0, 2);
   end;

procedure ttextxy (x, y : integer; ch : string);
   begin
      if ch = '' then exit;
      x := trunc (x*coef_x);
      y := trunc (y*coef_y);
      if ecran   then outtextxy (x, y, ch);
      if traceur then ptextxy   (x, y, ch)
   end;

procedure mover (dx, dy : real);
   begin
      if traceur then pdeplacevers (dx, dy);
      if ecran   then moverel      (round (dx), round (dy))
   end;

procedure liner (dx, dy : real);
   begin
      if traceur then ptracevers   (dx, dy);
      if ecran   then linerel      (round (dx), round (dy))
   end;

procedure movet (x, y : real);
   begin
      if traceur
      then begin
         pdeplaceen (x+ddxp, y+ddyp);
         if avance
         then
            if not leve
            then begin pbc; plc end;
      end;
      if ecran
      then begin
         moveto (round (x), round (y));
         if not leve
         then linerel (0, 0);
      end
   end;

procedure linet (x, y : real);
   begin
      if traceur then ptraceen    (x+ddxp,    y+ddyp);
      if ecran   then lineto      (round (x), round (y))
   end;

procedure ecrantexte;
   begin
      closegraph
   end;

procedure effaceecran;
   begin
      cleardevice
   end;

procedure fenetre (f1, f2, f3, f4 : real);
   begin
      xgfen := f1;
      xdfen := f2;
      ybfen := f3;
      yhfen := f4;
   end;

procedure cloture (c1, c2, c3, c4 : integer);
   begin
      xgclot := c1;
      xdclot := c2;
      ybclot := c3;
      yhclot := c4;

      xrap := (xdclot-xgclot) / (xdfen-xgfen);
      yrap := (yhclot-ybclot) / (yhfen-ybfen);
      setviewport (xgclot, maxy-yhclot, xdclot, maxy-ybclot, clipon);
      if traceur
      then begin
         ddxp := c1;        { valeurs pour dcalage clture simule }
         ddyp := maxy-c4
      end else begin
         ddxp := 0;
         ddyp := 0
      end
   end;

procedure clotureauto;
   var
      coeff, coefp      : real;
      lcx, lcy          : longint;

   begin
      coeff := (yhfen-ybfen) / (xdfen-xgfen);
      coefp := maxy / maxx;
      if coeff < coefp
      then begin
         lcx := maxx;
         lcy := trunc (lcx * coeff)
      end else begin
         lcy := maxy;
         lcx := trunc (lcy / coeff)
      end;
      cloture (0, lcx, 0, lcy);
   end;

procedure cloturemilli (dpx, lpx, dpy, lpy : real);
   var
      c1, c2, c3, c4    : integer;

   begin
      c1 :=     trunc (dpx / coef_mm_unit);
      c2 := c1+ trunc (lpx / coef_mm_unit);
      c3 :=     trunc (dpy / coef_mm_unit);
      c4 := c3+ trunc (lpy / coef_mm_unit);

      cloture (c1, c2, c3, c4);
   end;

procedure pleinecloture;
   begin
      cloture (0, maxx, 0, maxy);
      ddxp := 0;
      ddyp := 0;
   end;

procedure decoupage (x1, y1, x2, y2 : real);
   type
      region         = (gauche, droite, basse, haute);
      code           = set of region;

   var
      c,
      c1, c2 ,
      c11, c21          : code;
      x, y,
      xx1, yy1,
      xx2, yy2          : real;

   procedure codebinaire (x, y : real; var c : code);
      begin
         c := [];
         if x < xgfen
         then
            c := [gauche]
         else
            if x > xdfen then c := [droite];

         if y < ybfen
         then
            c := c + [basse]
         else
            if y > yhfen then c := c+ [haute]
      end;

   begin
      codebinaire (x1, y1, c1); c11 := c1;
      codebinaire (x2, y2, c2); c21 := c2;

      while (c1 <> []) or (c2 <> [])
      do begin
         if(c1*c2) <> []
         then
            exit;

         if c1 = []
         then c := c2
         else c := c1;

         if gauche in c
         then begin
            x := xgfen;
            y := y1+(y2-y1) * (xgfen-x1) / (x2-x1)
         end else
            if droite in c
            then begin
               x := xdfen;
               y := y1+(y2-y1) * (xdfen-x1) / (x2-x1)
            end else
               if basse in c
               then begin
                  y := ybfen;
                  x := x1+(x2-x1) * (ybfen-y1) / (y2-y1)
               end else
                  if haute in c
                  then begin
                     y := yhfen;
                     x := x1+(x2-x1) * (yhfen-y1) / (y2-y1)
                  end;
         if c = c1
         then begin
            x1 := x;
            y1 := y;
            codebinaire (x, y, c1)
         end else begin
            x2 := x;
            y2 := y;
            codebinaire (x, y, c2)
         end
       end;

       xx1 := ((x1-xgfen) * xrap);
       yy1 := ((yhfen-y1) * yrap);
       xx2 := ((x2-xgfen) * xrap);
       yy2 := ((yhfen-y2) * yrap);

       if avance
       then begin
          if c21 = []
          then
             movet (xx2, yy2);
       end else begin
          if c11 <> []
          then
             movet (xx1, yy1);
          linet (xx2, yy2);
       end;
    end;

procedure tracevers (x, y : real);
   begin
      xp2 := x;
      yp2 := y;
      decoupage (xp1, yp1, xp2, yp2);
      xp1 := xp2;
      yp1 := yp2;
   end;

procedure deplaceen (x, y : real);
   begin
      xp1 := x;
      yp1 := y;
      avance := true;
      tracevers (x, y);
      avance := false;
   end;

procedure deplaceenT (x, y : real);
   var
      xx1, yy1          : real;

   begin
      xp1 := x;
      yp1 := y;
      xx1 := ((x-xgfen) * xrap);
      yy1 := ((yhfen-y) * yrap);
      avance := true;
      leve   := true;
      movet (xx1, yy1);
      avance := false;
      leve   := false;
   end;

procedure deplaceenl (x, y : real);
   begin
      xp1 := x;
      yp1 := y;
      avance := true;
      leve   := true;
      tracevers (x, y);
      avance := false;
      leve   := false;
   end;

procedure EffacerCloture;
   begin
      setviewport (xgclot, maxy-yhclot, xdclot, maxy-ybclot, clipon);
      clearviewport;
   end;

procedure bordure (c : word);
   begin
      fixecoul  (c);
      deplaceen (xgfen, ybfen);
      tracevers (xdfen, ybfen);
      tracevers (xdfen, yhfen);
      tracevers (xgfen, yhfen);
      tracevers (xgfen, ybfen);
   end;

procedure axes;
   const
      dx                = 5;
      dy                = 3;

   procedure flecheaxex;
      begin
         mover (-dx,  dy);
         liner ( dx, -dy);
         mover (-dx, -dy);
         liner ( dx,  dy);
      end;

   procedure flecheaxey;
      begin
         mover (-dy,  dx);
         liner ( dy, -dx);
         mover ( dy,  dx);
         liner (-dy, -dx);
      end;

   begin
      if (xgfen < 0) and (xdfen > 0) then xorig := 0
                                     else xorig := xgfen;
      if (ybfen < 0) and (yhfen > 0) then yorig := 0
                                     else yorig := ybfen;
      deplaceen (xgfen, yorig);
      tracevers (xdfen, yorig);
      flecheaxex;
      deplaceen (xorig, ybfen);
      tracevers (xorig, yhfen);
      flecheaxey;
   end;

procedure correctionaxe (orig, gfen, unitxy : real; var correct : real);
   var
      nbretirets        : real;

   begin
      if orig = 0
      then begin
         nbretirets   := (orig-gfen) / unitxy;
         correct      := (nbretirets-int (nbretirets)) * unitxy
      end else
         if orig > 0
         then
            correct := trunc (orig / unitxy+1) * unitxy - orig
         else
            correct := abs (orig)+trunc (orig / unitxy) * unitxy
   end;

procedure UniteDeGraduation (Min, Max : real; var U : real ;
                                                    var dec : word) ;
   {--------------------------------------------------------------------}
   { ENTREE Min, Max.                                                   }
   { M.A.J. U  unit de graduation calcule de telle faon que le nombre}
   {           d'intervalles de graduation soit compris entre 5 et 10   }
   {           inclus ; U est un multiple dcimal de 1, 2 ou 5 ; U n'est}
   {           calcul que s'il est <= 0 en entre.                     }
   { SORTIE dec nombre de dcimales de l'unit trouve                  }
   {--------------------------------------------------------------------}
   Const
      Ln10              = 2.3025850930 ;
   Var
      Largeur,
      Echelle,
      v                 : real ;
      p                 : integer ;

   begin
      if u <= 0
      then begin
         Largeur := Abs (Max - Min) ;
         p := Trunc (Ln (Largeur) / Ln10) ;
         if Largeur < 1
         then
            p := p - 1 ; { li  la dfinition Turbo de Trunc }
         Echelle := Exp (Ln10 * p) ; { facteur d'chelle }
         v := Largeur / Echelle ;  { dans l'intervalle [1,10[ }
         if v <= 2
         then begin
            u := 0.2 ;
            dec := 1
         end else
            if v <= 5
            then begin
               u := 0.5  ;
               dec := 1
            end else begin
               u := 1  ;
               dec := 0
            end ;

         u := u * Echelle ;
         if p > 0
         then
            dec := 0
         else
            if p < 0
            then
               dec := dec - p
      end else begin {calcul de dec}
         Dec := - Trunc (Ln(U) / Ln10) + 1 ;
         if Dec < 0
         then
            Dec := 0
      end
   end;

procedure RecalculerUnitx (var unitx : real;
                           var nbdx  : word);
   begin
      if unitx = 0
      then
         UniteDeGraduation (XGFen, XDFen, unitx, nbdx) ;

      { modifier intervalle en fonction de la clture }
      str (XDFen:0:nbdx, ch);
      if TextWidth (ch) >
         (XCloture (XDFen) - XCloture (XDFen-UnitX))
      then
         UnitX := 2 * UnitX;
   end;

procedure RecalculerUnity (var unity : real;
                           var nbdy  : word);
   begin
      if unity = 0
      then
         UniteDeGraduation (YBFen, YHFen, unity, nbdy) ;

      { modifier intervalle en fonction de la clture }
      str (YHFen:0:nbdy, ch);
      if TextWidth (ch) >
         (XCloture (YBFen) - XCloture (YBFen-UnitY))
      then
         UnitY := 2 * UnitY;
   end;

procedure gradue (unitx, unity : real);
   var
      correctx,
      correcty          : real;
      x, y              : real;
      tiretx, tirety    : byte;
      nbdx, nbdy        : word; { Nb de dcimales (bidon) }

   begin
      recalculerunitx (unitx, nbdx);
      recalculerunity (unity, nbdy);
      tiretx := 3;
      tirety := 4;
      if unitx > 0
      then begin
         correctionaxe (xorig, xgfen, unitx, correctx);
         x := xgfen+correctx;
         repeat
            deplaceen (x, yorig);
            mover     (0,    tiretx);
            liner     (0, -2*tiretx);
            x := x+unitx;
         until x > xdfen
      end;
      if unity > 0
      then begin
         correctionaxe (yorig, ybfen, unity, correcty);
         y := ybfen+correcty;
         repeat
            deplaceen (xorig,     y);
            mover     (tirety,    0);
            liner     (-2*tirety, 0);
            y := y+unity;
         until y > yhfen
      end;
   end;

procedure gradueplt (unitx, unity                   : real;
                     tiret, nbcx,  nbdx, nbcy, nbdy : word;
                     titrx, titry, titr             : string;
                     posx,  posy,  post             : word;
                     extx,  exty                    : byte);

   var
      correctx,
      correcty,
      x, y,
      unitxy            : real;

   procedure titre_g;
      begin
         filemode := 0;
         settextstyle (2, 0, 1*trunc(tiret*3/2));
         filemode := 2;
         if traceur
         then
            pstyle (0, 0, tiret/3);
         case post of
            1 : begin
                   deplaceen (xgfen, ybfen);
                   mover  (tiret, -tiret);
                   ttexte (titr,  0, 0)     { titre dans l'angle G B }
                end;
            2 : begin
                   deplaceen (xgfen, yhfen);
                   mover  (tiret, tiret);
                   ttexte (titr, 0, 2)      { titre dans l'angle G H }
                end;
            3 : begin
                   deplaceen (xdfen,ybfen);
                   mover  (-tiret, -tiret);
                   ttexte (titr, 2, 0)     { titre dans l'angle D B }
                end;
            4 : begin
                   deplaceen (xdfen, yhfen);
                   mover  (-tiret, tiret);
                   ttexte (titr, 2, 2)     { titre dans l'angle D H }
                end;
            5 : begin
                   deplaceen (xorig, yorig);
                   mover  (tiret, -tiret);
                   ttexte (titr, 0, 0)      { titre dans l'angle Origine }
                end;
            6 : begin
                   deplaceen ((xdfen-xgfen)/2, yhfen);
                   mover  (0, tiret+2);
                   ttexte (titr, 1, 2)      { titre centr en haut }
                end;
            7 : begin
                   deplaceen ((xdfen-xgfen)/2, yorig);
                   mover  (0, -tiret-2);
                   ttexte (titr, 1, 0)      { titre centr en bas }
                end;
         end;
      end;

   procedure titre_x;
      begin
         filemode := 0;
         settextstyle (2, 0, tiret);
         filemode := 2;
         if traceur
         then
            pstyle (0, 0, tiret/4);
         case posx of
            1 : begin
                   deplaceen (xdfen, yorig);
                   mover  (-tiret, -tiret);
                   ttexte (titrx, 2, 0)     { titre sur l'axe X  D }
                end;
            2 : begin
                   deplaceen (xdfen, yorig);
                   mover  (-tiret, tiret);
                   ttexte (titrx, 2, 2)     { titre sous l'axe X  D }
                end;
            3 : begin
                   deplaceen (xgfen, yorig);
                   mover  (tiret, -tiret);
                   ttexte (titrx, 0, 0)     { titre sur l'axe X  G }
                end;
            4 : begin
                   deplaceen (xgfen, yorig);
                   mover  (tiret, tiret);
                   ttexte (titrx, 0, 2)     { titre sous l'axe X  G }
                end;
            5 : begin
                   deplaceen (xorig, yorig);
                   mover  (tiret,-tiret);
                   ttexte (titrx, 0, 0)     { titre sur l'axe X en 0 }
                end;
            6 : begin
                   deplaceen (xorig, yorig);
                   mover  (tiret,tiret);
                   ttexte (titrx, 0, 2)     { titre sous l'axe X en 0 }
                end;
            7 : begin
                   deplaceen ((xdfen-xorig)/2, ybfen);
                   mover  (0, -tiret-2);
                   ttexte (titrx, 1, 0)     { centr sous l'axe X en 0 }
                end;
         end;
      end;

   procedure titr_y;
      begin
         filemode := 0;
         settextstyle (2, 1, tiret);
         filemode := 2;
         if traceur
         then
            pstyle (90, 0, tiret/4);
         case posy of
            1 : begin
                   deplaceen (xorig, yhfen);
                   mover  (tiret, tiret);
                   ttexte (titry, 0, 2)     { titre sous l'axe Y en H }
                end;
            2 : begin
                   deplaceen (xorig, yhfen);
                   mover  (-tiret, tiret);
                   ttexte (titry, 2, 2)     { titre sur l'axe Y en H }
                end;
            3 : begin
                   deplaceen (xorig, ybfen);
                   mover  (tiret, -tiret);
                   ttexte (titry, 0, 0)     { titre sous l'axe Y en B }
                end;
            4 : begin
                   deplaceen (xorig, ybfen);
                   mover  (-tiret, -tiret);
                   ttexte (titry, 2, 0)     { titre sur l'axe Y en B }
                end;
            5 : begin
                   deplaceen (xorig, yorig);
                   mover  (tiret, -tiret);
                   ttexte (titry, 0, 0)     { titre sous l'axe Y en 0 }
                end;
            6 : begin
                   deplaceen (xorig, yorig);
                   mover  (-tiret, -tiret);
                   ttexte (titry, 2, 0)     { titre sur l'axe Y en 0 }
                end;
            7 : begin
                   deplaceen (xgfen, (yhfen-yorig) / 2);
                   mover  (tiret+2, 0);
                   ttexte (titry, 0, 1)      { centr sur l'axe Y }
                end;
         end
      end;

   begin
      Nouveau_style (2, 0, tiret);
      if post > 0
      then
         titre_g;
      if traceur
      then
         pstyle (0, 0, tiret/5);

      nbcx  := 0; { cadrer les nombres  gauche quelque soit le format }
      nbcy  := 0;

      recalculerunitx (unitx, nbdx);
      recalculerunity (unity, nbdy);

      filemode := 0;
      settextstyle (2, 0, tiret);
      filemode := 2;
      if unitx > 0
      then begin
         correctionaxe (xorig, xgfen, unitx, correctx);
         x := xgfen+correctx {+unitx};
         if titrx <> ''
         then
            unitxy := unitx
         else
            unitxy := 0;
         repeat
            str (x:nbcx:nbdx, ch);
            if extx > 2 then ch:='';
            deplaceen (x, yorig);
            if extx mod 3 = 1
            then begin
               liner  (0, -tiret);
               mover  (2, tiret-2);
               ttexte (ch, 0, 0);
            end;
            if extx mod 3 = 2
            then begin
               liner  (0, tiret);
               mover  (2, (-tiret+1));
               ttexte (ch, 0, 2);
            end;
            if extx mod 3 = 0
            then begin
               mover  (0, -tiret);
               liner  (0, 2*tiret);
               mover  (2, (-tiret+1));
               ttexte (ch, 0, 2);
            end;
            x := x+unitx;
         until x >= xdfen-unitxy;
      end;
      if posx > 0 then titre_x;

      filemode := 0;
      settextstyle (2, 0, tiret);
      filemode := 2;
      if traceur
      then
         pstyle (0, 0, tiret/5);
      if unity > 0
      then begin
         correctionaxe (yorig, ybfen, unity, correcty);
         y := ybfen+correcty {+unity};
         if titry <> ''
         then unitxy := unity
         else unitxy := 0;
         repeat
            str (y:nbcy:nbdy, ch);
            if exty > 2 then ch:='';
            deplaceen (xorig, y);
            if exty mod 3 = 1
            then begin
               liner  (tiret, 0);
               mover  (-tiret+2, -2);
               ttexte (ch, 0, 0);
            end;
            if exty mod 3 = 2
            then begin
               liner  (-tiret, 0);
               mover  (tiret-1, -2);
               ttexte (ch, 2, 0);
            end;
            if exty mod 3 = 0
            then begin
               mover  (tiret, 0);
               liner  (-2*tiret, 0);
               mover  (tiret-1, -2);
               ttexte (ch, 2, 0);
            end;
            y := y+unity;
         until y >= yhfen-unitxy;
      end;
      if posy > 0
      then
         titr_y;

      Ancien_style;
      if traceur
      then
         pstyle (0, 0, tiret/2);
   end;

procedure grille (unitx, unity : real);
   var
      correctx,
      correcty,
      i, j              : real;
      nbd               : word;

   begin
      nbd := 0;
      recalculerunitx (unitx, nbd);
      recalculerunity (unity, nbd);
      correctionaxe  (xorig, xgfen, unitx, correctx);
      correctionaxe  (yorig, ybfen, unity, correcty);
      i := trunc (xgfen+correctx);
      while i < trunc (xdfen)
      do begin
         j := trunc (ybfen+correcty);
         while j < trunc (yhfen)
         do begin
            deplaceen (i, j);
            tracevers (i, j);
            j := j+unity;
         end;
         i := i+unitx;
      end;
   end;

procedure dessine_lignes (unitx, unity : real);
   var
      correct, i        : real;
      nbd               : word;

   begin
      nbd := 0;
      recalculerunitx (unitx, nbd);
      recalculerunity (unity, nbd);
      correctionaxe   (yorig, ybfen, unity, correct);

      i := trunc (ybfen+correct);
      while i <{= trunc} (yhfen)
      do begin
         deplaceen (xgfen, i);
         tracevers (xdfen, i);
         i := i+unity;
      end;

      correctionaxe   (xorig, xgfen, unitx, correct);
      i := trunc (xgfen+correct);
      while i <{= trunc} (xdfen)
      do begin
         deplaceen (i, ybfen);
         tracevers (i, yhfen);
         i := i+unitx;
      end;
   end;

procedure PolygonePlein (n : integer; var p : polygone);
   var
      pt                : polygoneE;
      i                 : integer;

   begin
      for i := 1 to n
      do begin
         pt [i].x := XCloture (p [i].x);
         pt [i].y := YCloture (p [i].y);
      end;
      FillPoly (n, pt);
   end;

procedure PolygoneFil (n : integer; var p : polygone);
   var
      pt                : polygoneE;
      i                 : integer;

   begin
      for i := 1 to n
      do begin
         pt[i].x := XCloture (p[i].x);
         pt[i].y := YCloture (p[i].y);
      end;
      DrawPoly (n, pt);
   end;

procedure triangle  (x1, y1, x2, y2, x3, y3 : real; co : word);
   type
      point             = record x, y : integer end;

   var
      tr                : array [1..3] of point;

   begin
      setcolor (co);
      setlinestyle (4, $0000,1);
      tr [1].x := round (((x1-xgFen) * Xrap));
      tr [2].x := round (((x2-xgFen) * Xrap));
      tr [3].x := round (((x3-xgFen) * Xrap));
      tr [1].y := round (((yhFen-y1) * Yrap));
      tr [2].y := round (((yhFen-y2) * Yrap));
      tr [3].y := round (((yhFen-y3) * Yrap));

   fillpoly (3, tr);
   setlinestyle (0, 0, 1);
end;

procedure Carre  (x1, y1, x2, y2, x3, y3, x4, y4 : real; co : word);
   type
      point             = record x, y : integer end;

   var
      tr                : array [1..4] of point;

   begin
      setcolor (co);
      setlinestyle (4, $0000, 1);
      tr [1].x := round (((x1-xgFen) * Xrap));
      tr [2].x := round (((x2-xgFen) * Xrap));
      tr [3].x := round (((x3-xgFen) * Xrap));
      tr [4].x := round (((x4-xgFen) * Xrap));
      tr [1].y := round (((yhFen-y1) * Yrap));
      tr [2].y := round (((yhFen-y2) * Yrap));
      tr [3].y := round (((yhFen-y3) * Yrap));
      tr [4].y := round (((yhFen-y4) * Yrap));

     fillpoly (4, tr);
     setlinestyle (0, 0, 1);
   end;

procedure tracecercle (xc, yc, r : real; pointille : boolean);
   var
      s, c,
      y, x, aux         : real;
      n                 : integer;

   begin
      s := sin (pi/9);
      c := cos (pi/9);
      x := xc+r;
      y := yc;
      deplaceen (x, y);
      for n := 1 to 18
      do begin
         aux := xc+ (x-xc)*c-(y-yc)*s;
         y   := yc+ (x-xc)*s+(y-yc)*c;
         x   := aux;
         if pointille
         then
            deplaceen (x, y);
         tracevers (x, y);
      end;
   end;

procedure cercle  (xc, yc, r : real);
   begin
{      tracecercle (xc, yc, r, false);}
     ellipse (XCloture (xc), YCloture (yc), 0, 360, round(r), round(r));
   end;

procedure cerclepointille (xc, yc, r : real);
   begin
      tracecercle (xc, yc, r, true);
   end;

procedure fixecoul (c : word);
   var
      coul              : couleur_palette;

   begin
      coul := nomcouleur (c);
      if ecran
      then
         setcolor (couleur_b [coul, ecr]);
      if traceur
      then
         pfcc     (couleur_b [coul, hp6]);
   end;

procedure fixetrait      (trait : word);
   var
      ptrait            : integer;

   begin
      if ecran
      then
         setlinestyle (trait, 0, 1 {normwith});

      if traceur
      then begin
         case trait of
           0 : ptrait := -1;
           1 : ptrait := 1;
           2 : ptrait := 4;
           3 : ptrait := 2; { ou 3 }
         else
               ptrait := -1
         end;
         ptypet (ptrait);
      end;
   end;

procedure ini_traceur;
   begin
{      inigraph_p (formatpapier, 0, maxx, maxy, 0);}

      inigraph_t (0, maxx, maxy, 0);        { initialise la machine }
                 { centr  VGA }
      traceur := true;
   end;

procedure ini_format (formatpapier : char);              { initialise les paramtres seulement }
   begin
      calculer_repere_traceur (formatpapier, 'C', 0,  maxx,  maxy,  0,
                               papier_x, papier_y, coef_mm_unit);
   end;

procedure libere_traceur;
   begin
      if traceur then pclose;
      traceur := false;
   end;

{---------------------------------------------------------------------------}

BEGIN
    traceur             := false;
    ecran               := true;

{   maxx := getmaxx;
    maxy := getmaxy;       dj affects dans GRAPHISM
    fcouleur;              dj excut  dans GRAPHISM
    formatpapier := '4';   par  dfaut   dans SEKOPLT    }

END.

{--- GRAPHPLT ----------------------------------------------- ARX - BALMA --}
