{ menu4  }

   {------------------------------------------------------------------------}
   {    MENUP                                                               }
   {              interface graphique  menus droulants                    }
   {                                                            03/05/91    }
   {------------------------------------------------------------------------}

procedure palette (pal : fixe);
   var
      r, v, b, r2,
      v2, b2, i                : real;
      Touche,
      cx, cy, num, xi, yi,
      nbcolor, ncase,
      rr, vv, bb, nul, j,
      xm, x1, x2, x3, y1, y2   : integer;
      p                        : pointer;
      ok, abandon              : boolean;
      texte                    : string;
      palini                   : palettetype;
      couleurs                 : rvb;
      numc                     : array [1..16] of integer;

   procedure affichec;
      begin
       {  CacherSouris;  }
         setrgbpalette (numc [ncase], round (r2*i),
                                      round (v2*i),
                                      round (b2*i));
         setfillstyle (SolidFill, c_f_boite_norm);
         str          (round (r2*i), texte);
         bar          (x3+52, y1+112, x3+76, y1+120);
         setcolor     (c_t_boite_norm);
         outtextxy    (x3+52, y1+112, texte);

         str          (round (v2*i), texte);
         bar          (x3+52, y1+122, x3+76, y1+130);
         outtextxy    (x3+52, y1+122, texte);

         str          (round (b2*i), texte);
         bar          (x3+52, y1+132, x3+76, y1+140);
         outtextxy    (x3+52, y1+132, texte);

         bar          (x3+52, y1+102, x3+76, y1+110);
         str          (round (i*100), texte);
         outtextxy    (x3+52, y1+102, texte);
       {  MontrerSouris;}
      end;

   begin
      x1 := 20;
      y1 := maxy-205;
      x2 := x1+100;
      x3 := x2+100;

      y2 := y1+150;

      getpalette    (palini);
      xm      := 300+x1;
      nbcolor := 0;
      ncase   := 1;
      abandon := false;
      ok      := false;

      getmem    (p,
      imagesize (x1-20,              y1-20,         xm,         y2+55));
      getimage  (x1-20,              y1-20,         xm,         y2+55,p^);

      setfillstyle (SolidFill, c_f_boite_norm);
      bar       (x1-20,              y1-20,         xm,         y2+55);
      setcolor  (c_t_boite_norm);
      rectangle (x1-20+1,            y1-20+1,       xm-1,       y2+55-1);

      rectangle (x3+20,              y1,            xm-20,       y1+24);
      rectangle (x3+20,              y1+34,         xm-20,       y1+58);
      rectangle (x3+20,              y1+68,  round((xm+x3)/2)-2, y1+92);
      rectangle (round((xm+x3)/2)+2, y1+68,         xm-20,       y1+92);
      line      (x1, y1, x2, y2);
      line      (x2, y2, x3, y1);
      line      (x3, y1, x1, y1);

      Nouveau_Style (0, 0, 1);

      outtextxy (x1-10, y1-10, 'R');
      outtextxy (x3+5 , y1-10, 'V');
      outtextxy (x2-5 , y2+5 , 'B');
      outtextxy (round ((xm+x3)/2)-28,           y1+10, 'ABANDON');
      outtextxy (round ((xm+x3)/2)-8,            y1+44, 'OK');
      outtextxy (round ((x3+20+(xm+x3)/2)/2)-4,  y1+78, '-');
      outtextxy (round ((xm-20+(xm+x3)/2)/2)-4,  y1+78, '+');
      outtextxy (x3+20, y1+102, 'I =');
      outtextxy (x3+20, y1+112, 'R =');
      outtextxy (x3+20, y1+122, 'V =');
      outtextxy (x3+20, y1+132, 'B =');

      for j := 0 to maxcolor do
         if pal [j]
         then begin
            nbcolor := nbcolor+1;
            numc [nbcolor] := j
         end;

      for j:=1 to nbcolor do
      begin
         getrgbpalette (palini.colors [numc [j]], rr, vv, bb);
         couleurs [numc [j]].r := rr;
         couleurs [numc [j]].v := vv;
         couleurs [numc [j]].b := bb;
      end;

      for j:=1 to nbcolor do
      begin
         setfillstyle (SolidFill, numc [j]);
         rectangle (x1-16+round ((xm-x1+16)/nbcolor*(j-1)),   y2+20,
                    x1-20+round ((xm-x1+16)/nbcolor*j)    ,   y2+50);
         bar       (x1-16+round ((xm-x1+16)/nbcolor*(j-1))+1, y2+20+1,
                    x1-20+round ((xm-x1+16)/nbcolor*j)    -1, y2+50-1);
      end;

      num := 5;j := 0;
      getrgbpalette (numc [1], rr, vv, bb);
      if (rr > vv) and (rr >= bb)
      then begin
            i  := rr / 63;
            r2 := 63;
            v2 := vv * 63 / rr;
            b2 := bb * 63 / rr
      end else
         if    (vv >= rr) and (vv > bb)
         then begin
            i  := vv / 63;
            r2 := rr * 63 / vv;
            v2 := 63;
            b2 := bb * 63 / vv
         end else
            if (bb >= vv) and (bb > rr)
            then begin
               i  := bb / 63;
               r2 := rr * 63 / bb;
               v2 := vv * 63 / bb;
               b2 := 63
            end else begin
               i  := rr / 63;
               r2 := 63;
               v2 := 63;
               b2 := 63
            end;
      MontrerSouris;
      affichec;
      repeat   until (not UnBoutonSourisEnfonce);
      repeat
         clavsouris (Touche);
         LirePositionSouris (xs, ys);

         if (xs > x3+20) and (ys > y1)    and
            (xs < xm-20) and (ys < y1+24) or d
         then
            abandon := true;

         if (xs > x3+20) and (ys > y1+34) and
            (xs < xm-20) and (ys < y1+58)
         then
            ok := true;

         if (xs > x3+20) and (ys > y1+68) and
            (xs < round ((xm+x3)/2)-2) and (ys < y1+92)
         then begin
            i := i-0.005;
            if i < 0 then i := 0;
            affichec
         end;
            if (xs > round ((xm+x3)/2)+2) and (ys > y1+68) and
               (xs < xm-20)               and (ys < y1+92)
            then begin
               i := i+0.005;
               if i > 1 then i := 1;
               affichec
            end;
         if (ys > y2+20) and (ys < y2+55) and
            (xs < xm)    and (xs > x1-20)
         then begin
            cachersouris;
            setcolor (c_f_boite_norm);

            rectangle (x1-16+round ((xm-x1+16)/nbcolor*(ncase-1))-1,
                       y2+20-1,
                       x1-20+round ((xm-x1+16)/nbcolor*ncase) +1   ,
                       y2+50 +1);

            ncase := trunc ((xs-x1+20) / (xm-x1+20)*nbcolor+1);

            setcolor (15);
            rectangle (x1-16+round ((xm-x1+16)/nbcolor*(ncase-1))-1,
                       y2+20-1,
                       x1-20+round ((xm-x1+16)/nbcolor*ncase) +1   ,
                       y2+50 +1);

            montrersouris;

            getrgbpalette (numc [ncase], rr, vv, bb);
            if (rr > vv) and (rr >= bb)
            then begin
               i := rr/63;         r2 := 63;       v2 := vv*63/rr; b2 := bb*63/rr
            end else
               if (vv >= rr) and (vv > bb)
               then begin
                  i := vv/63;      r2 := rr*63/vv; v2 := 63;       b2 := bb*63/vv
               end else
                  if (bb >= vv) and (bb > rr)
                  then begin
                       i := bb/63; r2 := rr*63/bb; v2 := vv*63/bb; b2 := 63
                  end else begin
                       i := rr/63; r2 := 63;       v2 := 63;       b2 := 63
                  end;
            affichec
         end;

         b := (ys-y1) / (y2-y1);
         r := (x3-xs) / (x3-x1) - b/2;
         v := 1-r-b;
         if (b >= 0) and (r >= 0) and (v >= 0) and
            (b <= 1) and (r <= 1) and (v <= 1)
         then begin
            if (b > r) and (b > v) and (b > 0)
            then begin
               r := r/b;
               v := v/b;
               b := 1;
            end else
            if ((v >= r) and (v >= b) and (v > 0))
            then begin
               r := r/v;
               b := b/v;
               v := 1;
            end else
               if (r >= b) and (r >= v) and (r > 0)
               then begin
                  b := b/r;
                  v := v/r;
                  r := 1;
               end;
            r := 63*r;
            v := 63*v;
            b := 63*b;
            r2 := r ;
            v2 := v ;
            b2 := b;
            affichec
         end;
      until ok or abandon;
      CacherSouris;

      if abandon
      then begin
         for j := 1 to nbcolor
         do
            setrgbpalette (numc [j], couleurs [numc [j]].r,
                                     couleurs [numc [j]].v,
                                     couleurs [numc [j]].b);
      end;
      putimage (x1-20, y1-20, p^, 0);
      libere (p);
      Ancien_Style;
   end;

{---------------------------------------------------------------------------}
procedure couleur (pal : fixe; var cc, cf : integer);
   var
      i                        : real;
      Touche,
      x1, x2, y1, y2, xi, yi,
      cx, cy, num, cci, cfi,
      nbcolor, ncase,
      nul, j, xm               : integer;
      p                        : pointer;
      ok, abandon              : boolean;
      texte                    : string;
      palini                   : palettetype;
      numc                     : array [1..16] of integer;

   begin
      x1 := 0;
      y1 := maxy-60;
      x2 := x1+400;
      y2 := y1+60;

      cci := cc;
      cfi := cf;
      nbcolor := 0;
      ncase   := 1;
      abandon := false;
      ok      := false;

      getmem        (p, imagesize (x1, y1, x2, y2));
      getimage      (              x1, y1, x2, y2,   p^);

      nouveau_style (0, 0, 1);

      setfillstyle  (1, colorf);
      bar           (x1,    y1,    x2,           y2);
      setcolor      (colord);
      rectangle     (x1+1,  y1+1,  x2-1,         y2-1);

      rectangle     (x1+4,  y1+4,  x1+4+(y2-y1), y2-4);
      rectangle     (x2-76, y1+4,  x2-4,         y1+28);
      rectangle     (x2-76, y2-28, x2-4,         y2-4);

      settextjustify (1, 1);
      outtextxy     (x2-42, y1+18, 'ABANDON');
      outtextxy     (x2-42, y2-18, 'OK');

      setfillstyle  (1, cf);
      bar           (x1+5,  y1+5,  x1+3+(y2-y1), y2-5);
      setfillstyle  (1,cc);
      bar           (x1+16, y1+16, x1-8+(y2-y1), y2-16);
      rectangle     (x1+15, y1+15, x1-7+(y2-y1), y2-15);

      getpalette    (palini);

      for j := 0 to 15 do
         if pal [j]
         then begin
            nbcolor := nbcolor+1;
            numc [nbcolor] := j
         end;

      for j := 1 to nbcolor do
      begin
         setfillstyle (1, numc [j]);
         rectangle
           (x1+  (y2-y1)+8+round((x2-80-(x1+8+(y2-y1))+4)/nbcolor*(j-1)), y1+4,
            x1+4+(y2-y1)+  round((x2-80-(x1+8+(y2-y1))+4)/nbcolor* j),    y2-4);
         bar
           (x1+  (y2-y1)+9+round((x2-80-(x1+8+(y2-y1))+4)/nbcolor*(j-1)), y1+5,
            x1+3+(y2-y1)+  round((x2-80-(x1+8+(y2-y1))+4)/nbcolor* j),    y2-5);
      end;

      i := 1;            num := 5;       j := 0;

      MontrerSouris;
      repeat until not UnBoutonSourisEnfonce;
      repeat
         clavsouris (Touche);
         LirePositionSouris (xs, ys);

         if     (xs > x2-76) and (ys > y1+4)
            and (xs < x2-4)  and (ys < y1+28) or d
         then
            abandon := true;

         if     (xs > x2-76) and (ys > y2-28)
            and (xs < x2-4)  and (ys < y2-4)
         then
            ok      := true;

         if     (ys > y1+4)  and (ys < y2-4)
            and (xs < x2-80) and (xs > x1+4+ (y2-y1))
         then begin
            ncase := trunc ((xs- (x1+8+(y2-y1))) /
                            (x2- 80- (x1+8+ (y2-y1))) * nbcolor+1);
            if d then
            begin
               cf := numc[ncase];
               setfillstyle (1, cf);
               bar          (x1+5, y1+5,   x1+3+(y2-y1), y2-5);
               setfillstyle (1,cc);
               bar          (x1+16, y1+16, x1-8+(y2-y1), y2-16);
               rectangle    (x1+15, y1+15, x1-7+(y2-y1), y2-15);
            end;

            if g then
            begin
               cc := numc [ncase];
               setfillstyle (1, cc);
               bar (x1+16, y1+16, x1-8+(y2-y1), y2-16);
            end
         end
      until ok or abandon;

      if abandon
      then begin
         cc := cci;
         cf := cfi
      end;

      CacherSouris;
      putimage      (x1, y1, p^, 0);
      libere (p);
      ancien_style;
   end;

{---------------------------------------------------------------------------}
procedure unecouleur (t : Chainecar; pal : fixe; var cc : integer);
   var
      x1, x2, y1, y2,
      cf                       : integer;
      p                        : pointer;

   begin
      cf := colorf;
      nouveau_style (0, 0, 1);
      x1 := 0;
      y1 := maxy-60-2*ty;
      x2 := x1+400;
      y2 := y1     +2*ty;

      getmem   (p, imagesize (x1, y1, x2, y2));
      getimage (              x1, y1, x2, y2,   p^);
      setfillstyle  (1, colorf);
      bar           (x1,    y1,    x2,    y2);
      setcolor      (colord);
      rectangle     (x1+1,  y1+1,  x2-1,  y2-1);
      settextjustify (1, 1);
      outtextxy     ((x1+x2) div 2 , (y1+y2) div 2 , t);
      ancien_style;

      couleur       (pal, cc, cf);

      putimage               (x1, y1,           p^, 0);
      libere   (p);
   end;

{---------------------------------------------------------------------------}
procedure plumes (nbpl : integer ; pal : fixe; var couleurb : palette_base);
   var
      i, at                  : real;
      Touche,
      x1, x2,
      y1, y2,
      xi, yi,
      cx, cy,
      num,
      cci, cfi,
      nbcolor, ncase, inter,
      xcentre, ycentre,
      numplume,
      nul, j, k, xm          : integer;
      p                      : pointer;
      ok, abandon            : boolean;
      texte                  : string;
      numc                   : array [1..16] of integer;
      s                      : couleur_palette;
      plini                  : palette_base;

   begin
      numplume := 1;
      x1 := 0;          y1 := maxy-88;
      x2 := x1+436;     y2 := y1+88;
      xs := 400;        ys := y1+68;
      nbcolor := 0;
      ncase   := 1;
      abandon := false;
      ok      := false;

      getmem   (p, imagesize (x1, y1, x2, y2));
      getimage               (x1, y1, x2, y2, p^);

      nouveau_style (0, 0, 1);

      { dessin de la boite }
      setfillstyle (1, colorf);
      bar       (x1,            y1,      x2,             y2);
      setcolor  (colord);
      rectangle (x1+1,          y1+1,    x2-1,           y2-1);
      rectangle (x1+4,          y1+4,    x1+4+(y2-y1)-8, y2-4);
      rectangle (x2-76,         y2-2*28, x2-4,y2-32);
      rectangle (x2-76,         y2-28  , x2-4,y2-4);

      outtextxy (x2-68,         y2-28-18, 'ABANDON');
      outtextxy (x2-36,         y2-18,    'OK');
      outtextxy (x1+(y2-y1)+26, y1+14,
                                    'CHOISIR UNE PLUME PUIS UNE COULEUR');

      { dessin du barillet porte-plumes }
      xcentre := x1+4+ (y2-y1-8) div 2;
      ycentre := y1+4+ (y2-y1-8) div 2;
      for j := 1 to nbpl do
      begin
         str (j, texte);
         circle    (round ( xcentre+ 26 * cos (j*(2*pi/nbpl)) ),
                    round ( ycentre- 26 * sin (j*(2*pi/nbpl)) ),9);
         outtextxy (round ( xcentre+ 26 * cos (j*(2*pi/nbpl)) -4 ),
                    round ( ycentre- 26 * sin (j*(2*pi/nbpl)) -4 ),texte);
      end;

         circle (round ( xcentre+ 26*cos (numplume* (2*pi/nbpl)) ),
                 round ( ycentre- 26*sin (numplume* (2*pi/nbpl)) ),10);

      { copie des valeurs initiales des plumes dans plini }
      for s := noir  to blanc
      do  plini [s, hp6] := couleurb [s, hp6];

      { recherche des couleurs autorisees }
      for j := 0 to 15
      do
         if pal [j]
         then begin
            nbcolor := nbcolor+1;
            numc [nbcolor] := j
         end;

      { affichage de la palette en cours }
      inter := trunc ((x2-76- (x1+y2-y1)) / nbcolor ) ;
      for j := 1 to nbcolor
      do begin
         setfillstyle (1, numc [j]);
         s   := noir;
         for k := 1 to numc [j]
         do  s := succ (s);
         str (couleur_b [s, hp6], texte);
         rectangle
              (x1  +y2-y1  + inter * (j-1), y2-2*28,
               x1-4+y2-y1  + inter * j,     y2-32);
         bar  (x1  +y2-y1+1+ inter * (j-1), y2-2*28+1,
               x1-5+y2-y1  + inter * j,     y2-33);
         rectangle
              (x1  +y2-y1  + inter * (j-1), y2-28,
               x1-4+y2-y1  + inter * j,     y2-4);
         outtextxy
              (x1-4+y2-y1  + inter * (j-1)+inter div 2, y2-12, texte);
      end;

      { saisie }
      i   := 1;
      num := 5;
      j   := 0;
      MontrerSouris;
      repeat   until (not UnBoutonSourisEnfonce);
      repeat
         clavsouris (Touche);
         LirePositionSouris (xs, ys);

         abandon := (xs > x2-76) and (ys > y2-2*28) and
                    (xs < x2-4)  and (ys < y2-32)   or d;

         ok      := (xs > x2-76) and (ys > y2-28)   and
                    (xs < x2-4)  and (ys < y2-4);

         {                             choix d'une COULEUR de la palette }
         if (ys > y1+28) and (ys < y2-28) and
            (xs < x2-80) and (xs > x1+(y2-y1))
         then begin
            ncase := trunc (nbcolor * ((xs-(x1+y2-y1)) / (nbcolor*inter)))+1;
            if g
            then begin
               s := noir;
               for k := 1 to numc [ncase] do s := succ (s);
               couleurb [s, hp6] := numplume;
               str (numplume, texte);
               setfillstyle (colorf, 1);
               bar (x1+1+(y2-y1) + inter * (ncase-1),             y2-27,
                    x1-5+(y2-y1) + inter * ncase,                 y2-5);
               outtextxy
                   (x1-4+(y2-y1) + inter * (ncase-1)+inter div 2, y2-12, texte);
            end;
         end;

         {                                    choix d'un numero de PLUME }
         if (ys > y1+4)         and (ys < y2-4) and
            (xs < x1+(y2-y1-4)) and (xs > x1+4)
         then begin
            CacherSouris;
            setcolor (colorf);
            circle (round ( xcentre + 26 *cos (numplume*(2*pi/nbpl)) ),
                    round ( ycentre - 26 *sin (numplume*(2*pi/nbpl)) ), 10);
            if ((xs-xcentre) = 0) and ((ycentre-ys) = 0)
            then xs := xs+1;

            if abs (xs-xcentre) < abs (ycentre-ys)
            then begin
               at := pi/2-arctan ((xs-xcentre)/(ycentre-ys));
               if ycentre-ys < 0 then at := at+pi;
            end else begin
               at := arctan ((ycentre-ys)/(xs-xcentre));
               if xs-xcentre < 0 then at := at+pi;
            end;
            if at < 0 then at := at+2*pi;
            numplume := round (nbpl*at / (2*pi));
            if numplume = 0 then numplume := nbpl;
            setcolor (colord);
            circle (round (xcentre+ 26*cos (numplume * (2 * pi /nbpl))),
                    round (ycentre- 26*sin (numplume * (2 * pi /nbpl))), 10);
            MontrerSouris;
         end;
      until ok or abandon;

      {                                                           sortie }
      if abandon
      then      { recopie des valeurs initiales des plumes dans couleurb }
         for s:= noir  to blanc
         do  couleurb [s, hp6] := plini [s, hp6];

      CacherSouris;
      putimage      (x1, y1, p^, 0);
      libere (p);
      ancien_style;
   end;

{--- MENU4 -----------------------------------------------------------------}
