UNIT COUPES;

   {------------------------------------------------------------------------}
   { Calcul       des coupes                                     1994       }
   {                                                                        }
   {------------------------------------------------------------------------}
   { Interpole les intersections du trait de coupe unique dans une grille   }
   { rgulire au format maxi NBMAXCOL*NBMAXLIG                             }
   {------------------------------------------------------------------------}

INTERFACE
{$O+,F+}

USES
   Dos,
   Fctmath,                  { ARX     - fonctions mathmatiques            }
   Graphism,                 { ARX     - initialisations graphiques         }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }

   GRILLES;                  { ARX     - Lecture des grilles                }


CONST
   NbMaxStations       =  120;  { nombre stations sur un profil            }
   NbMaxPoints         =  360;  { nombre max points calculs sur un profil }

TYPE
   pro3                 = array [1..nbmaxstations, 1..3] of real;
   pro2                 = array [1..nbmaxpoints,   1..2] of real;

   lp                   = array [1..Nbmaxstations, 1..2] of integer;

VAR
   pro_l1, pro_l2,                     { tableaux longs profils bruts       }
   poly
                        : pro2;        { mmorisation points calculs, tris }

   pro_c1, pro_c2,                     { tableaux courts profils rduits    }
   pro_sis
                        : pro3;        { mmorisation aprs traitements     }

   lpoly                      : lp;    { liste des corps                    }

   nbpts_s,
   nbpts_g,
   nbpts_t                             { nombre de points calculs }
                        : integer;

{---------------------------------------------------------------------------}


Procedure COUPER (visu, vite     : boolean;
                  lagrille       : TGrille;
                  coefx, coefz,
                  ox, oy, ex, ey : real;
                  co             : word;
                  var profil     : pro2;
                  var nbpts      : integer;
                  var lgpro,
                      minz, maxz : real);

Procedure projeter (visu               : boolean;
                    nomf               : dirstr;
                    k                  : integer;
                    ox, oy, ex, ey,
                    larg,
                    coefx, coefz       : real;
                    co                 : word;
                var proj               : pro3;
                var nbpts              : integer;
                var lgpro,
                    minz, maxz         : real);

   { Calcule les projections des noeuds d'une grille sur UN segment qui a
   pour extrmits ox,oy ( x1,y1)  et  ex,ey (x2,y2), sur une bande larg*2.
   La recherche s'effectue squentiellement sur le fichier d'entre.
   les units du fichier d'entre sont en degrs et centimes ou Km,
   le tableau proj (valeurs du profil brut),
   nbpts,
   et l (= longueur du profil en km) sont en sortie.                        }

Procedure trier2 (var a : pro2 ; nbp : integer);
Procedure trier3 (var a : pro3 ; nbp : integer);
   { d'aprs        Q S O R T       ***          (dmo TP5)                 }
   { pour trier un tableau de 3 col. (type list) sur la premire colonne.   }

Procedure reduire (var proj        : pro2;
                   var prof        : pro3;
                   lgpro, pas, dom : real;
                   nbpts           : integer;
                   ecartype        : boolean;
                   var nbs         : integer);

   { calcule les moyennes mobiles de l'altitude et de l'anomalie
   gravimtrique le long d'un profil.
   pas est la distance entre deux stations, Lx la distance  l'origine,
   dom est la demi largeur du domaine de calcul, Da est l'cart-type.       }

Procedure transferer (var p2 : pro2; var p3 : pro3; nbpts : integer);
   { recopie d'un tableau dans un autre }

Procedure extraire_corps (    pas   : real;
                          var pro   : pro3;
                          var poly  : pro2;
                          var lpoly : lp;
                              nbst  : integer;
                          var nbcor : integer);

{---------------------------------------------------------------------------}

IMPLEMENTATION

CONST
   infini               = 1E37;

VAR
   horiz,
   verti,
   fic_trie             : boolean;

procedure minmax (x : real ; var minz, maxz : real);
   begin
      if x > maxz then maxz := x;
      if x < minz then minz := x;
   end;

procedure COUPER (visu, vite     : boolean;
                  lagrille       : TGrille;
                  coefx, coefz,
                  ox, oy, ex, ey : real;
                  co             : word;
                  var profil     : pro2;
                  var nbpts      : integer;
                  var lgpro,
                      minz, maxz : real);
    var
      invx, invy
                        : boolean;
      num,
      ppx, ppy,
      dpx, dpy,
      nbc, nbl
                        : integer;
      lp, lp2,
      xi, xc, xp,
      yi, yc, yp,
      z1, z2, zp,
      a,  b,
      minxg, minyg,
      pasx,  pasy,
      pasdiagx,
      pasdiagy
                        : real;

   function interpolation (pas, y1, y2, xi : real) : real;
      var
         az, bz, yi     : real;

      begin
         if (y1 < v_indef) and (y2 < v_indef)
         then begin
            az := (y2-y1)/ pas;
            interpolation := az*xi+y1;
         end else
            az := v_indef;
      end;

   function abscisse ( i : integer) : real;
      { rend l'abscisse de l'intersection  de la ligne I avec la droite }
      { !!!  droite non horizontale }
      begin
         yc       := lagrille.ordy (i) {(i-1) * pasy + minyg};

         if verti
         then
            abscisse := ox
         else begin
            if not horiz
            then
               abscisse := (yc - b) / a
            else                                            { indtermin !!!  }
               abscisse :=        {lagrille.ordy (lagrille.nbcog); der col }
                        ox;                              { origine }
        end;
      end;

   function ordonnee ( i : integer) : real;
      { rend l'ordonne de l'intersection de la colonne I avec la droite }
      { !!!  droite non verticale }
      begin
         xc       := lagrille.absx (i) {(i-1)*pasx + minxg};
         if not verti
         then
            ordonnee := a * xc + b
         else                                                 { infini !!! }
            ordonnee :=  {lagrille.absx (lagrille.nblig);  dernire ligne  }
                   oy;                               { origine }
      end;

   procedure premiers_bouts (px, py : integer; var b1, b2 : real) ;
      { calcule la longueur de l'extrmit du profil :
          b1 jusqu' la premire colonne
          b2 jusqu' la premire ligne         }
      begin
         if not verti
         then begin
            yp := ordonnee (px);
            b1 := sqrt (sqr (xc-ox) + sqr (yp-oy));
            b1 := b1 * coefx;
         end;

         if not horiz
         then begin
            xp := abscisse (py);
            b2 := sqrt (sqr (xp-ox) + sqr (yc-oy));
            b2 := b2 * coefx;
         end;
      end;

   function val_point (x, y : real; px, py : integer ) : real;
         { interpoler un point dans la case px py  }
      var
         zp1, zp2       : real;

      begin
         { interpoler point intermdiaire ligne prcdente p'1 }
         z1  := lagrille.valeur (px    , py);
         z2  := lagrille.valeur (px +1 , py);
         if (z1 < v_indef) and (z2 < v_indef)
         then
            zp1 := interpolation (pasx, z1, z2, x-lagrille.absx (px))
         else
            zp1 := v_indef;

         { interpoler point intermdiaire ligne suivante p'2 }
         z1  := lagrille.valeur (px,     py+1);
         z2  := lagrille.valeur (px +1  ,py+1);
         if (z1 < v_indef) and (z2 < v_indef)
         then
            zp2 := interpolation (pasx, z1, z2, x- lagrille.absx (px))
         else
            zp2 := v_indef;

         { interpoler enfin p1 }
         if (zp1 < v_indef) and (zp2 < v_indef)
         then
            val_point := interpolation
                            (pasy, zp1, zp2, y - lagrille.ordy (py))
         else
            val_point := v_indef;
      end;

   function valorigine (px, py : integer) : real;
      begin
         if invx
         then begin
            if invy
            then
               zp := val_point (ox, oy, px, py)
            else
               zp := val_point (ox, oy, px, py-1)
         end else begin
            if invy
            then
               zp := val_point (ox, oy, px-1, py)
            else
               zp := val_point (ox, oy, px-1, py-1)
         end;
         valorigine := zp;
      end;

   function valextremite (dx, dy : integer) : real;
      begin
         if invx
         then begin
            if invy
            then
               zp := val_point (ex, ey, dx-1, dy-1)
            else
               zp := val_point (ex, ey, dx-1, dy)
         end else begin
            if invy
            then
               zp := val_point (ex, ey, dx, dy-1)
            else
               zp := val_point (ex, ey, dx, dy)
         end;
         valextremite := zp;
      end;

   procedure calculer_premier (px, py : integer);
      var
         zp             : real;

      begin
         inc (nbpts);
         profil [nbpts, 1] := 0 ;
         zp :=  valorigine    (px, py);
         profil [nbpts, 2] := zp * coefz ;
         minmax (zp*coefz, minz, maxz );
         if visu
         then begin
            fixecoul (15);
            deplaceen (ox, oy);
         end;
      end;

   procedure calculer_dernier (dx, dy : integer);
      var
         zp             : real;

      begin
         inc (nbpts);
         profil [nbpts, 1] := lgpro;
         zp :=  valextremite (dx, dy);
         profil [nbpts, 2] := zp * coefz;
         minmax (zp*coefz, minz, maxz );
         if visu
         then begin
            fixecoul (co);
            deplaceen (ex, ey);
         end;
      end;

   procedure couper_x (lp : real; d, f : integer);
      var
         i, j           : integer;

      procedure couperx (i, d : integer);
         begin
            j   := abs (i - d) +1 ;
            yp  := ordonnee (i);
            num := trunc ((yp-minyg) /pasy) +1;
            z1  := lagrille.valeur (i, num);
            z2  := lagrille.valeur (i, num +1);
            if (z1 < v_indef) and (z2 < v_indef)
            then begin
               yi  := yp -minyg -pasy*(num-1);
               zp  := interpolation (pasx, z1, z2, yi);
            end else
               zp  := v_indef;
            inc (nbpts);
            profil [nbpts, 1] := lp + pasdiagx * (j-1) * coefx;
            profil [nbpts, 2] := zp * coefz;
            minmax (zp*coefz, minz, maxz );
            if visu
            then begin
               fixecoul (co);
               deplaceen (xc, yp);
            end;
         end;

      begin
         if invx
         then
            for i := d downto f   do couperx (i, d)
         else
            for i := d to f       do couperx (i, d);
      end;

   procedure couper_y (lp : real; d, f : integer);
      var
         i, j           : integer;

      procedure coupery (i, d : integer);
         begin
            j   := abs (i-d)+1;
            xp  := abscisse (i);
            num := trunc ((xp-minxg)/pasx)+1;
            z1  := lagrille.valeur (num, i);
            z2  := lagrille.valeur (num+1, i);
            if (z1 < v_indef) and (z2 < v_indef)
            then begin
               xi  := xp-minxg-pasx*(num-1);
               zp  := interpolation (pasx, z1, z2, xi);
            end else
               zp  := v_indef;
            inc (nbpts);
            profil [nbpts, 1] := lp+pasdiagy*(j-1) * coefx;
            profil [nbpts, 2] := zp*coefz;
            minmax (zp*coefz, minz, maxz );
            if visu
            then begin
               fixecoul (co);
               deplaceen (xp, yc);
            end;
         end;

      begin
         if invy
         then
            for i := d downto f do coupery (i, d)
         else
            for i := d to f     do coupery (i, d);
      end;

   procedure rechercher_premier (var ppx, ppy : integer);
      begin
         if invx
         then
            ppx := trunc ((ox-minxg)/pasx)+1
         else
            ppx := trunc ((ox-minxg)/pasx)+2;
         if invy
         then
            ppy := trunc ((oy-minyg)/pasy)+1
         else
            ppy := trunc ((oy-minyg)/pasy)+2;
      end;

   procedure rechercher_dernier (var dpx, dpy : integer);
      begin
         if invx
         then
            dpx := trunc ((ex-minxg)/pasx)+2
         else
            dpx := trunc ((ex-minxg)/pasx)+1;
         if invy
         then
            dpy := trunc ((ey-minyg)/pasy)+2
         else
            dpy := trunc ((ey-minyg)/pasy)+1;
      end;

   procedure longueur_profil;
      begin
         lgpro := coefx * sqrt ((ex-ox)*(ex-ox) + (ey-oy)*(ey-oy));
      end;

   procedure calculer_params_droite;
      begin
         if ex <> ox
         then begin
            a := (ey-oy)/(ex-ox);
            b := oy-a*ox;
            if a <> 0
            then begin
               pasdiagx := sqrt (sqr (pasx) + sqr (pasx*a)); { trait oblique   }
               pasdiagy := sqrt (sqr (pasy) + sqr (pasy/a)); { trait oblique   }
               horiz := false;
               verti := false;
            end else begin
               horiz := true;
               pasdiagx := pasx;                            { trait horizontal }
               pasdiagy := 0;             { inutile ... }
            end;
         end else begin
            verti := true;
            a := infini;                                     { trait vertical  }
            b := infini;
            pasdiagx := 0;
            pasdiagy := pasy;
         end;
      end;

   begin
      minz  :=  infini;
      maxz  := -infini;
      nbpts := 0;
      lp    := 0;
      lp2   := 0;
      pasx  := lagrille.pasxgrille;
      pasy  := lagrille.pasygrille;
      minxg := lagrille.minxg;
      minyg := lagrille.minyg;
      invx  := (ex < ox);
      invy  := (ey < oy);
      calculer_params_droite;
      longueur_profil;
      rechercher_premier (ppx, ppy);           { premire colonne, ligne }
      rechercher_dernier (dpx, dpy);           { dernire colonne, ligne }
      premiers_bouts (ppx, ppy, lp, lp2) ;     { calc longueurs bouts    }
      nbc := abs (dpx-ppx)+1;                  { nb colonnes }
      nbl := abs (dpy-ppy)+1;                  { nb lignes   }

      vite := vite or (nbc+nbl+2 > Nbmaxpoints);
      if vite
      then begin
         if (nbc > nbl) and (nbc+2 <= Nbmaxpoints)
         then begin
            calculer_premier (ppx, ppy);
            couper_x (lp, ppx, dpx);
            calculer_dernier (dpx, dpy);
         end else begin
            if (nbl+2 <= Nbmaxpoints)
            then begin
               calculer_premier (ppx, ppy);
               couper_y (lp2, ppy, dpy);
               calculer_dernier (dpx, dpy);
            end;
         end;
      end else begin
         calculer_premier (ppx, ppy);
         if not verti
         then
            couper_x (lp, ppx, dpx );

         if not horiz
         then
            couper_y (lp2, ppy, dpy);
         calculer_dernier (dpx, dpy);
         trier2 (profil, nbpts);
      end;
   end;

procedure  transferer (var p2 : pro2; var p3 : pro3; nbpts : integer);
   var
      i                 : integer;

   begin
      if nbpts > nbmaxstations
      then nbpts := nbmaxstations;
      for i := 1 to nbpts
      do begin
         p3 [i, 1] := p2 [i, 1];
         p3 [i, 2] := p2 [i, 2];
         p3 [i, 3] := 0;
      end;
   end;

procedure projeter (visu               : boolean;
                    nomf               : dirstr;
                    k                  : integer;
                    ox, oy, ex, ey,
                    larg,
                    coefx, coefz       : real;
                    co                 : word;
                var proj               : pro3;
                var nbpts              : integer;
                var lgpro,
                    minz, maxz         : real);
   var
      xc, yc, z,
      xp, yp, db,
      a1, b1, lx,
      t,
      xg, xd, yb, yh    : real;
      fentree           : text;

   procedure calproj;
      begin
         xp := (yc + xc / a1 - b1) / (a1 + 1/a1);
         yp := a1*xp+b1;
         lx := sqrt ((xp-ox)*(xp-ox) + (yp-oy)*(yp-oy)) *coefx;
         db := sqrt ((xp-xc)*(xp-xc) + (yp-yc)*(yp-yc)) *coefx;
      end;

   procedure calprojverti;
      begin
         xp := ox;
         yp := yc;
         lx := abs (yp-oy)*coefx;
         db := abs (xc-ox)*coefx;
      end;

   procedure calprojhoriz;
      begin
         xp := xc;
         yp := oy;
         lx := abs (xp-ox)*coefx;
         db := abs (yc-oy)*coefx;
      end;

   function dans_zone : boolean;
      { limites recalcules en fonction de la disposition du profil }

      begin
         dans_zone := ((xc>=xg) and (xc<=xd) and (yc>=yb) and (yc<=yh))
      end;

   function dans_bande : boolean;
      begin
         dans_bande := (db<=larg)
                  and(((xp>=ox) and (xp<=ex) and (yp>=oy) and (yp<=ey))
                  or  ((xp<=ox) and (xp>=ex) and (yp<=oy) and (yp>=ey))
                  or  ((xp>=ox) and (xp<=ex) and (yp<=oy) and (yp>=ey))
                  or  ((xp<=ox) and (xp>=ex) and (yp>=oy) and (yp<=ey)))
      end;

   procedure limites_hv (var xg, xd, yb, yh : real);
      var
         dbc            : real;

      begin
         dbc := larg/coefx;
         if (ex=ox) and (oy<ey)                          {5}
         then begin
            xg := ox-dbc;
            xd := ex+dbc;
            yb := oy;
            yh := ey
         end;

         if (ex=ox) and (oy>ey)                          {6}
         then begin
            xg := ox-dbc;
            xd := ex+dbc;
            yb := ey;
            yh := oy
         end;

         if (ey=oy) and (ox<ex)                          {7}
         then begin
            xg := ox;
            xd := ex;
            yb := oy-dbc;
            yh := ey+dbc
         end;

         if (ey=oy) and (ox>ex)                          {8}
         then begin
            xg := ox;
            xd := ex;
            yb := oy+dbc;
            yh := ey-dbc
         end;
      end;

   procedure limites_obl (var xg, xd, yb, yh : real);
      var
         dbc            : real;

      begin
         dbc := larg / coefx;
         if ((ex > ox) and (ey > oy))                        {1}
         then begin
            xg := ox;
            xd := ex;
            yb := oy;
            yh := ey;
         end;

         if ((ex < ox) and (ey < oy))                        {2}
         then begin
            xg := ex;
            xd := ox;
            yb := ey;
            yh := oy;
         end;

         if ((ex > ox) and (ey < oy))                        {3}
         then begin
            xg := ox;
            xd := ex;
            yb := ey;
            yh := oy;
         end;

         if ((ex < ox) and (ey > oy))                        {4}
         then begin
            xg := ex;
            xd := ox;
            yb := oy;
            yh := ey;
         end;

         xg := xg-dbc;
         xd := xd+dbc;
         yb := yb-dbc;
         yh := yh+dbc;
      end;

   begin                               {-----------  projeter  -------------}
      assign (fentree, nomf) ;

      reset  (fentree);

      if (ex <> ox) and (ey <> oy)
      then begin
         a1    := (ey-oy) / (ex-ox);
         b1    := oy-a1*ox;
         lgpro := sqrt ((ex-ox)*(ex-ox) + (ey-oy)*(ey-oy));
         limites_obl (xg, xd, yb, yh);
      end else begin
         if ex = ox
         then
            lgpro := abs (ey-oy);
         if ey = oy
         then
            lgpro := abs (ex-ox);
         limites_hv  (xg, xd, yb, yh);
      end;
      lgpro := lgpro*coefx;
{      if lgpro > lgmaxpro then lgpro := lgmaxpro;}

      minz :=  infini;
      maxz := -infini;
      nbpts := 0;
      while (not eof (fentree)) and (nbpts < nbmaxstations)
      do begin
         if k > 2
         then
            readln (fentree, xc, yc, z, t)
         else
            readln (fentree, xc, yc, z);

         while (not eof (fentree)) and (not dans_zone)
               or (z >= v_indef )
         do begin
            if k > 2
            then
               readln (fentree, xc, yc, z, t)
            else
               readln (fentree, xc, yc, z);
            if eof (fentree)
            then begin
               close (fentree);
               exit
            end
         end;
         if ex = ox                   then calprojverti;
         if ey = oy                   then calprojhoriz;
         if (ex <> ox) and (ey <> oy) then calproj;
         if dans_bande
         then begin
            if visu
            then begin
               fixecoul (co);
               deplaceen (xc, yc);
            end;
            inc (nbpts);
            proj [nbpts, 1] := lx;

            proj [nbpts, 2]      := z*coefz;
            if k > 2
            then
               proj [nbpts, 3]  := t;
            minmax (z*coefz, minz, maxz );
         end
      end;
      close (fentree);
   end;

procedure trier3 (var a : pro3 ; nbp : integer);
   PROCEDURE Sort (l, r: INTEGER);
      VAR
         i, j           : INTEGER;
         x, y           : real;

      BEGIN
         i := l;
         j := r ;
         x := a [(l+r) DIV 2, 1];
         REPEAT
            WHILE a[i, 1] < x       DO i := i+1;
            WHILE x       < a[j, 1] DO j := j-1;
            IF i<=j
            THEN BEGIN
               y := a[i, 1]; a[i, 1] := a[j, 1]; a[j, 1] := y;
               y := a[i, 2]; a[i, 2] := a[j, 2]; a[j, 2] := y;
              { if k>2 then begin
               y := a[i, 3]; a[i, 3] := a[j, 3]; a[j, 3] := y;
              end               }
               i := i+1;
               j := j-1;
            END;
         UNTIL i > j;
         IF l < j THEN sort (l, j);
         IF i < r THEN sort (i, r);
      END;

   BEGIN                                               { trier }
      if nbp > 1
      then  Sort (1, nbp)
   END;

procedure trier2 (var a : pro2 ; nbp : integer);
   PROCEDURE Sort (l, r: INTEGER);
      VAR
         i, j           : INTEGER;
         x, y           : real;

      BEGIN
         i := l;
         j := r ;
         x := a [(l+r) DIV 2, 1];
         REPEAT
            WHILE a[i, 1] < x       DO i := i+1;
            WHILE x       < a[j, 1] DO j := j-1;
            IF i<=j
            THEN BEGIN
               y := a[i, 1]; a[i, 1] := a[j, 1]; a[j, 1] := y;
               y := a[i, 2]; a[i, 2] := a[j, 2]; a[j, 2] := y;
               i := i+1;
               j := j-1;
            END;
         UNTIL i > j;
         IF l < j THEN sort (l, j);
         IF i < r THEN sort (i, r);
      END;

   BEGIN
      if nbp > 1                                             { trier }
      then  Sort (1, nbp)
   END;

procedure reduire (var proj        : pro2;
                   var prof        : pro3;
                   lgpro, pas, dom : real;
                   nbpts           : integer;
                   ecartype        : boolean;
                   var nbs         : integer);
   var
      lx                : real;
      ls, sz, mz,
      somecart,
      variance          : extended;
      i, j, nb          : integer;

   begin
      nbs := 0;                        { nb stations }
      ls  := 0 {trunc (pas / 2)};
      i   := 1;
      lx  := proj [1, 1];
      if dom > pas / 2
      then
         dom := pas / 2;

      while (ls <= lgpro) and (nbs < nbmaxstations)
      do begin
         while (lx < ls-dom) and (i <= nbpts)
         do begin
            inc (i);
            lx := proj [i, 1];
         end;
         nb := 0;
         sz := 0;
         while (lx <= ls+dom) and (i <= nbpts)
         do begin
            inc (nb);
            sz := sz+proj [i, 2];
            inc (i);
            lx := proj [i, 1]
         end;

         if nb > 0
         then begin
            mz := sz/nb;
            inc (nbs);
            prof [nbs, 1] := ls;
            prof [nbs, 2] := mz;
            if ecartype
            then begin
               somecart := 0;
               for j := i-nb to i-1 do
                  somecart := somecart+sqr (proj [j, 2]-mz);
               variance := somecart/nb;
               prof [nbs, 3] := sqrt (variance)/2;
            end
         end else begin
            inc (nbs);
            prof [nbs, 1] := ls;
            prof [nbs, 2] := v_indef;
            if ecartype
            then
               prof [nbs, 3] := 0
         end;
         ls := ls+pas
      end;
   end;

{---------------------------------------------------------------------------}
{ corps }
procedure extraire_corps  (    pas   : real;
                           var pro   : pro3;
                           var poly  : pro2;
                           var lpoly : lp;
                               nbst  : integer;
                           var nbcor : integer);
   var
      nb, nbp, n, ip, id, nbpts, pp  : integer;
      z, l, lx                       : real;
      fini                           : boolean;

   function der  (i : integer) : integer;
      var
         nb             : integer;

      begin
         if (pro [i, 2] <= 0) and (i = nbst)
         then der := nbst
         else begin
            nb := 1;
            while (pro [i, 2] <= 0) and (i  <= nbst)
                               {    and (nb <= nbmaxsommets)}
            do begin
               inc (i);
               inc (nb)
            end;
            der := i-1
         end
      end;

   function prem (i : integer) : integer;
      var
         nb             : integer;

      begin
         if (pro [i, 2] <= 0) and (i = 1)
         then
            prem := 1
         else begin
            nb := 1;
            while (pro [i, 2] > 0 ) and (i  <  nbst)
                                  {  and (nb <= nbmaxsommets)}
            do begin
               inc (i);
               inc (nb);
            end;
            if (i > 1) and (i <= nbst)
            then
               prem := i-1
            else
               prem := i
         end
      end;

   procedure fairunpoly (n, i, pp : integer ; var d, nb : integer);
   {----------------------------------------------------------------------
   recherche les points constituant le polygone de rang n
   i            rang de la premire station
   pp                du premier sommet
   d            dernire station
   nb           nombre de sommets du polygone
   lpoly [n, 1] contient le nombre de sommets du polygone n
   ----------------------------------------------------------------------}
   var
      p                 : integer;

   begin                         { calculer coordonnes premier point }
      p := prem (i);
      if (pro [p, 2] <= 0)
      then begin
         poly [pp,   1] := pro [p, 1];
         poly [pp,   2] := 0;
         poly [pp+1, 1] := pro [p, 1];
         poly [pp+1, 2] := pro [p, 2];
         nb  := 2
      end else  begin
         poly [pp, 1]   := pro [p,1] +
                           abs (pas*pro [p, 2]
                                 / (pro [p, 2] - pro [p+1, 2]));
         poly [pp, 2]   := 0;
         nb   := 1
      end;

      { rech le dernier et mmorise les segments intermdiaires }
      i  := p + 1;
      if (i = nbst)
      then
         d := i
      else
         d := der (i);

      while (i <= d)
      do begin
         poly [pp+nb, 1] := pro [i, 1];
         poly [pp+nb, 2] := pro [i, 2];
         inc (i);
         inc (nb);
      end;
                                       { calcule le dernier segment         }
      if (pro [d, 2] <= 0) and (d = nbst)
      then begin
         poly [pp+nb, 1] := pro [d, 1] ;
         poly [pp+nb, 2] := 0
      end else begin
         poly [pp+nb, 1] := pro [d, 1] ;
         poly [pp+nb, 2] := pro [d, 2] ;
         inc (nb);
         poly [pp+nb, 1] := pro [d, 1] +
                            abs (pas* pro [d, 2]
                                   / (pro [d, 2]- pro [d+1, 2]));
         poly [pp+nb, 2] :=0
      end;
                                       { ferme le polygone                  }
      inc (nb);
      poly [pp+nb, 1] := poly [pp, 1];
      poly [pp+nb, 2] := 0;
      inc (nb)
   end;

   function finpoly (i : integer) : boolean;
      var
         p, d           : integer;

      begin
         p := prem (i);
         d := der  (p+1);
         if ((p = 1) and (d <= nbst)) or ((p < d) and (d <= nbst))
         then
            finpoly := false
         else
            finpoly := true
      end;

   begin           { extraire ...}
      ip := 1;
      pp := 1;
      n  := 0;
      while not finpoly (ip) do
      begin
         inc (n);
         fairunpoly (n, ip, pp, id, nbpts);
         lpoly [n, 1] := nbpts;
         ip := id+1;
         pp := pp+nbpts;
      end;
      nbcor := n;
   end;

END.

{ GEOCEAN - COUPES -------------------------------- INRP - TOULOUSE - ARX }

