UNIT GRAPHISM;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                       procdures graphiques                               }
{                                                               03/05/91    }
{---------------------------------------------------------------------------}
(*
   Graphism,                 { ARX     - initialisations graphiques         }
*)

INTERFACE

{$O+,F+}

USES
   dos,
   crt,
   graph;                         { TP 55   - units standard              }

CONST
   maximage        = 65520;



TYPE
   couleur_palette = (noir,         bleu,          vert,       cyan,
                      rouge,        magenta,       brun,       gris_clair,
                      gris_fonce,   bleu_clair,    vert_clair, cyan_clair,
                      rouge_clair,  magenta_clair, jaune,      blanc);

   periph          = (ecr, hp6);

   palette_base    = array [couleur_palette, periph] of word;
                               { contient les noms des couleurs,
                                 leurs numros d'origine
                                 et les affectations aux plumes du traceur. }

   fixe            = array [0..15] of boolean;

VAR
   couleur_b            : palette_base;

   memok                : boolean;               { mmoire suffisante       }

   maxcolor,                                     { nb couleurs simultanes  }
   colord, colorf,                               { couleur devant, fond     }
   c_icone,                                      { couleur dominante icnes }
   coulboite,                                    { couleur fond cartes      }
   coulecran                                     { couleur fond cran       }
                        : word;

   pal                  : fixe;                  { couleurs non modifiables }

   coef_x, coef_y                                { VGA: coef = 1            }
                        : real;

   posxbtn,                                      { position zone icones     }
   maxx, maxy,                                   { dimensions cran         }
   tx,   ty,                                     { largeur et hauteur car   }
   d0,   dd0                                     { espacement lignes suppl  }
                        : word;

   stylemenu,
   ancienstyle                                   { style police             }
                        : textsettingstype;

   copie_en_cours                      { VRAI = impression demande         }
                        : Boolean;

{---------------------------------------------------------------------------}
Procedure ini_stylemenu ;
   { initialise la variable Stylemenu                                       }

Procedure style_menu;
   { reprend les valeurs de Stylemenu                                       }

Procedure setpolmenu    (pol : integer);
   { initialise les paramtres lis  une police.                           }

Procedure nouveau_style (pol, dir, tailcar : word);
   { mmorise le style courant d'criture et affecte le nouveau             }
   {                     0     0    1                                       }

Procedure ancien_style;
   { restitue l'ancien style d'criture                                     }

Procedure inigraph      (chemin : pathstr);
   { initialise les couleurs modifiables par PALETTE (menup)
                les dimensions de l'cran
                la couleur d'criture et la couleur de fond
                le curseur souris                                          }

Procedure getrgbpalette (n   : integer; var r, v, b : integer);
   { }

Procedure loadimage     (nom : pathstr; var lieu : pointer; var test: boolean);
   { charge une image brute }

   { !!!  toutes les images sont limites  MAXIMAGE octets }

Procedure saveimage     (nom : pathstr; var lieu : pointer);
   { sauve une image brute }

Procedure libere        (             var lieu : pointer);
   { libre le pointeur d'image }

Procedure LoadImagePb   (noms : pathstr ; var im : pointer);
   { charge une image pcx }

Procedure loadimagepb2  (noms, nomb : pathstr; var test : boolean);
   { transforme une image PCX ou PCC en fichier .ima }

Procedure saveimagepb2  (noms, nomb : pathstr; var test : boolean);
   { sauve une image PCX }

Procedure scanpcx       (noms, nomb : pathstr; var test : boolean);
   { convertit une image format SCAnner en PCX }

Procedure chargepalette (nom        : pathstr; var test : boolean);
   { charge une palette }

Procedure sauvepalette  (nom        : pathstr; var ok : boolean );
   { sauve une palette }

Procedure grisligne     (niveau     : integer);
   { }

Function  curfleche                                             : pointer;
   { affecte la flche du curseur souris }

Procedure fcouleurhp6;
   { affecte les couleurs des plumes }

Procedure fcouleur      (f1, f2, f3, f4 : word);
   { affecte les couleurs d'cran en fonction de maxcolor
       blanc et noir sont inchangs
       sauf pour maxcolor = 0, blanc := noir.
       si maxcolor= 0  bleu, brun, gris_clair = 15 ; autres = 0
          maxcolor= 2  bleu, brun, gris_clair = 0  ; autres = 15
          maxcolor= 15  nom = ordre des noms tp std }

Function nomcouleur     (c : word)                         : couleur_palette;
   { rend le nom correspondant  un numro de couleur
       si numro non trouv
       alors
            si maxcolor <> 0
            alors blanc
            sinon noir                               }

Function numcouleur     (nomcoul : couleur_palette)             : word;
   { rend le numro correspondant  un nom de couleur}

Function couleurnum     (num : word)                            : word;
   { rend le numero de la couleur affect  la position NUM                }

Procedure coulbar       (pattern, coul : word);
   { affecte pattern et couleurcorrespondante pour un instruction BAR      }

Function getcoul                                                : word;
   { affecte la couleur courante dans le tableau palette                   }

{--------------------------------------------------------------------------}

IMPLEMENTATION

TYPE
   dess                 = array [1..maximage] of byte;

VAR
  { i, taillefleche       : integer;}
   fleche               : pointer;
   image, tampon        : file;
   taille               : word;
   dessin, despb        : ^dess;

{--------------------------------------------------------------------------}

procedure coulbar (pattern, coul : word);
   begin
      {setfillstyle (pattern, numcouleur (nomcouleur (coul)));}
      setfillstyle (pattern, couleurnum (coul));
   end;

function getcoul                                   : word;
   begin
      getcoul := couleurnum (getcolor);
   end;

procedure setpolmenu (pol : integer);
   var
      nerr              : integer;

   begin
      filemode := 0;
      settextstyle (pol, 0, 1);
      filemode := 2;
      tx := 8; ty := 8;

      if pol = 1 then setusercharsize (1, 2, 1, 2);  {triplex}
      if pol = 2 then setusercharsize (3, 2, 3, 2);  {small}
      settextjustify    (0, 2);
      tx  := textwidth  ('A');
      ty  := textheight ('Ag')+4;
      d0  := 2;
      dd0 := 4
   end;

procedure nouveau_style (pol, dir, tailcar : word);
   begin
      gettextsettings (ancienstyle);
      filemode := 0;
      settextstyle    (pol, dir, tailcar);
      filemode := 2;
      tx  := textwidth  ('A');
   end;

procedure ini_stylemenu ;
   begin
      gettextsettings (stylemenu);
   end;

procedure ancien_style;
   begin
      with ancienstyle
      do begin
         settextjustify (horiz, vert);
         filemode := 0;
         settextstyle   (font,  direction, charsize);
         setpolmenu     (font);
         filemode := 2;
      end;
   end;

procedure style_menu;
   begin
      with stylemenu
      do begin
         settextjustify (horiz, vert);
         filemode := 0;
         settextstyle   (font,  direction, charsize);
         setpolmenu     (font);
         filemode := 2;
      end;
   end;

procedure inigraph (chemin : pathstr);
   var
      i,
      graphdriver,
      graphmode,
      errorcode         : integer;

   begin
      filemode  := 0;
      graphdriver := detect;
      initgraph (graphdriver, graphmode, chemin);
      filemode  := 2;
      errorcode := graphresult;
      if errorcode <> grok
      then begin
         writeln ('Erreur graphique : ', grapherrormsg (errorcode));
         writeln ('Abandon du programme...');
         halt (1)
      end;
      maxcolor := getmaxcolor;
      if maxcolor = 15
      then begin
         for i := 0 to 15
         do
            setpalette  (i, i);
            setrgbpalette (0,  0,  0,  0);
            setrgbpalette (15, 63, 63, 63);
            colorf := 0;
            colord := 15
      end else begin
         colorf := 0;
         colord := 1
      end;
      maxx := getmaxx;
      maxy := getmaxy;
      coef_x := (maxx+1) / 640;
      coef_y := (maxy+1) / 480;
      posxbtn := 0;
      fcouleurhp6;
      fcouleur (1, 6, 7, 0);
      setpolmenu (1);
   end;

procedure getrgbpalette (n : integer; var r, v, b : integer);
   var
      r88srs            : registers;

   begin
      with r88srs
      do begin
         ah := $10;
         al := $15;
         bx := n;
         intr ($10, r88srs);
         r  := dh;
         v  := ch;
         b  := cl;
      end
   end;

procedure loadimage (nom : pathstr; var lieu : pointer; var test : boolean);
   begin
      filemode := 0;
      assign (image, nom);
      {$I-}
      reset  (image, 1);
      {$I+}
      if ioresult = 0
      then begin
         test   := true;
         taille := filesize (image);
         getmem    (lieu, taille);
         blockread (image, lieu^, taille);
         close     (image)
      end else test := false;
      filemode := 2;
   end;

procedure saveimage (nom : pathstr; var lieu : pointer);
   type
      int2              = record  x, y : word  end;

   var
      p                 : ^int2;

   begin
      p := lieu;
      assign  (image, nom);
      {$I-}
      rewrite (image, 1);
      {$I+}
{     taille := imagesize (0, 0, p^.x, p^.y);
      a devrait marcher en N&B et en couleurs }
      if ioresult = 0
      then begin
         if maxcolor = 1
         then
            taille := trunc ((p^.x+8) / 8) * (p^.y+1)+6;
         if maxcolor = 15
         then
            taille := trunc ((p^.x+8) / 8) * (p^.y+1)*4+6;
         blockwrite (image, lieu^, taille);
         close      (image);
      end { else
         message ('accs refus')};
   end;

procedure libere (var lieu : pointer);
   type
      int2              = record x, y : word end;

   var
      p                 : ^int2;
   {   text       : string;}

   begin
      p := lieu;
      if maxcolor = 1
      then
         taille := trunc ((p^.x+8) / 8) * (p^.y+1)+6;
      if maxcolor = 15
      then
         taille := trunc ((p^.x+8) / 8) * (p^.y+1)*4+6;
      freemem (lieu, taille);
      lieu := nil;
   end;

procedure LoadImagePb (noms : pathstr ; var im : pointer);
   var
      lx, tx, ty,
      i, j, k, nd       : word;
      d, d1, n, dif     : byte;
      taille1,
      taille2, f        : integer;

   begin
      filemode := 0;
      assign (image, noms);
      {$I-}
      reset  (image, 1);
      {$I+}
      filemode := 2;
      im := NIL;
      if ioresult = 0
      then begin
         taille1 := filesize (image);
         getmem (despb, taille1);
         blockread (image, despb^, taille1);
         for n:=0 to 15
         do begin
            setrgbpalette (n, round (despb^[17+3*n] * 63/255),
                              round (despb^[18+3*n] * 63/255),
                              round (despb^[19+3*n] * 63/255))
         end;
         close     (image);

         lx := despb^[ 9]+256 * despb^[10]+1;
         ty := despb^[11]+256 * despb^[12]+1;
         lx := trunc ((lx+8)/8);
         tx := despb^[67];
         if lx > tx then lx := tx;
         taille2 := lx * ty * despb^[66]+6;
         getmem (dessin, taille2);

         dif :=tx-lx;
         dessin^[1] := despb^[ 9];
         dessin^[2] := despb^[10];
         dessin^[3] := despb^[11];
         dessin^[4] := despb^[12];

         j := 5; i := 129; k := 1;

         repeat
            d := despb^[i];
            if (d<192)
            then
               if (k>0) or (dif=0)
                  then begin
                     dessin^[j] := d;
                     inc(j);
                     k := (k+1) mod tx
                  end else
                     k := (k+1) mod tx
            else begin
               inc (i);
               d1 := despb^[i];
               for n := 0 to d-193
               do
                  if (k>0) or (dif=0)
                     then begin
                        dessin^[j] := d1;
                        inc(j);
                        k := (k+1) mod tx
                     end else
                        k := (k+1) mod tx
            end;
            inc(i);
         until j > taille2;

         { INVERSION DES 4 PLANS }
         if despb^[66] > 1
         then begin
            for j := 1 to ty
            do begin
               for i:=1 to lx
               do begin
                  f := 4+(j-1)*lx*4;
                  d := dessin^[i+f];
                  dessin^[i+f] := dessin^[i+f+3*lx];
                  dessin^[i+f+3*lx] := d;
               end;
               for i:=1 to lx
               do begin
                  f := 4+(j-1)*lx*4;
                  d := dessin^[i+f+lx];
                  dessin^[i+f+lx] := dessin^[i+f+2*lx];
                  dessin^[i+f+2*lx] := d;
               end;
            end;
         end;

         freemem (despb, taille1);
         im := dessin;
      end;
   end;

procedure loadimagepb2 (noms, nomb : pathstr ; var test : boolean);
   var
      lx, tx, ty,
      i, j, k, nd       : word;
      d, d1, n, dif     : byte;
      ligne             : array [1..4] of pointer;

   begin
      filemode := 0;
      assign (image, noms);
      {$I-}
      reset  (image, 1);
      {$I+}
      if ioresult = 0
      then begin
         new (despb); new (dessin);
         test   := true;
         taille := filesize (image);
         blockread (image, despb^, taille);
         close     (image);
         for n:=0 to 15
         do begin
            setrgbpalette (n, round (despb^[17+3*n] * 63/255),
                              round (despb^[18+3*n] * 63/255),
                              round (despb^[19+3*n] * 63/255))
         end;
         lx := despb^[ 9]+256 * despb^[10]+1;
         ty := despb^[11]+256 * despb^[12]+1;
         lx := trunc ((lx+8)/8);
         tx := despb^[67];
         if lx > tx then lx := tx;
         taille := lx * ty * despb^[66]+6;
         dif :=tx-lx;
         dessin^[1] := despb^[ 9];
         dessin^[2] := despb^[10];
         for i := 3 to 4
         do dessin^[i] := despb^[8+i];
         j := 5;
         i := 129;
         k := 1;

         repeat
            d := despb^[i];
            if (d < 192)
            then
               if (k > 0) or (dif = 0)
                  then begin
                     dessin^[j] := d;
                     inc(j);
                     k := (k+1) mod tx
                  end else
                     k := (k+1) mod tx
            else begin
               inc (i);
               d1 := despb^[i];
               for n := 0 to d-193
               do
                  if (k>0) or (dif=0)
                     then begin
                        dessin^[j] := d1;
                        inc(j);
                        k := (k+1) mod tx
                     end else
                        k := (k+1) mod tx
            end;
            inc(i);
         until j > taille;
         dispose (despb);

         if despb^[66] > 1
         then begin
            assign    (image, nomb);
            rewrite   (image, 1);
            assign    (tampon, 'tampon.ima');
            rewrite   (tampon, 1);
            blockwrite(tampon, dessin^, taille);
            dispose   (dessin);
            reset     (tampon, 1);
            for i:=1 to 4
            do
               getmem (ligne [i], lx);
            blockread (tampon, ligne [1]^, 4);
            blockwrite(image,  ligne [1]^, 4);
            for j := 1 to ty
            do begin
               for i := 1 to 4 do blockread (tampon, ligne [i]^,   lx);
               for i := 1 to 4 do blockwrite(image,  ligne [5-i]^, lx);
            end;
            for i := 1 to 4 do freemem (ligne [i], lx);
            blockread (tampon, ligne [1]^, 2);
            blockwrite(image,  ligne [1]^, 2);
            close     (image);
            close     (tampon);
            erase     (tampon);
         end else begin
            assign    (image, nomb);
            rewrite   (image, 1);
            blockwrite(image, dessin^, taille);
            dispose   (dessin);
            close     (image);
         end;
      end else test := false;
      filemode := 2;
   end;

procedure saveimagepb2 (noms, nomb : pathstr; var test : boolean);
   var
      ro, ve, bl        : integer;
      tx, ty, i,   j,
      d1, u,  v,   d,
      n,  k,
      nbp, nump         : word;
      ligne             : array [1..4] of pointer;

   begin
      filemode := 0;
      assign (image, noms);
      {$I-}
      reset  (image, 1);
      {$I+}
      filemode := 2;
      if ioresult = 0
      then begin
         new       (dessin);
         taille := filesize (image);
         blockread (image, dessin^, taille);
         close     (image);

         tx := dessin^ [1]+256 * dessin^ [2]+1;
         ty := dessin^ [3]+256 * dessin^ [4]+1;

         tx := trunc ((dessin^ [1]+256 * dessin^ [2]+8) / 8);
         nbp:= (taille-6) div (tx*ty);

         if nbp > 1
         then begin
            dispose   (dessin);
            assign    (tampon, 'tampon.ima');
            rewrite   (tampon, 1);
            for i := 1 to 4 do getmem (ligne [i], tx);
            reset     (image, 1);
            blockread (image, ligne [1]^, 4);
            blockwrite(tampon,ligne [1]^, 4);
            for j := 1 to ty
            do begin
               for i := 1 to 4 do blockread  (image, ligne [i]^,   tx);
               for i := 1 to 4 do blockwrite (tampon,ligne [5-i]^, tx);
            end;
            blockread  (image, ligne [1]^, 2);
            blockwrite (tampon,ligne [1]^, 2);
            for i := 1 to 4 do freemem (ligne [i], tx);
            close     (image);
            reset     (tampon, 1);
            new       (dessin);
            blockread (tampon, dessin^, taille);
            close     (tampon);
            erase     (tampon);
         end;

         new (despb);
         test := true;

         tx := dessin^ [1]+256 * dessin^ [2]+1;
         ty := dessin^ [3]+256 * dessin^ [4]+1;
{
         despb^ [13] := tx mod 256; despb^ [14] := trunc (tx / 256);
         despb^ [15] := ty mod 256; despb^ [16] := trunc (ty / 256);
}
         despb^ [13] := 180; despb^ [14] := 0;
         despb^ [15] := 180; despb^ [16] := 0;

         tx  := trunc ((dessin^ [1]+256 * dessin^ [2]+8) / 8);
         nbp := (taille-6) div (tx*ty);

         despb^ [ 1] := 10; despb^ [ 2] :=  5;
         despb^ [ 3] :=  1; despb^ [ 4] :=  1;
         despb^ [ 5] :=  0; despb^ [ 6] :=  0;
         despb^ [ 7] :=  0; despb^ [ 8] :=  0;
         despb^ [65] :=  0; despb^ [66] :=nbp;
         despb^ [69] :=255; despb^ [70] :=255;
         despb^ [71] :=176; despb^ [72] :=  1;
         for n := 1 to 4 do   despb^ [8+n] := dessin^ [n];

         ty := ty-1;
         despb^ [67] := 2 * ((tx+1) div 2); despb^ [68] := 0;
         for n := 0 to 15
         do begin
            getrgbpalette (n, ro, ve, bl);
            ro := round (255 * ro / 63);
            ve := round (255 * ve / 63);
            bl := round (255 * bl / 63);
            despb^ [17+3*n] := ro;
            despb^ [18+3*n] := ve;
            despb^ [19+3*n] := bl
         end;
         j := 129; i := 4;

         for u := 0 to ty
         do begin
            for nump := 1 to nbp
            do begin
               d1 := 256;
               k  := 1;
               for v := 0 to tx-1
               do begin
                  inc (i);
                  d := dessin^ [i];
                  if d=d1 then inc (k);
                  if ((d <> d1) or (k = 64)) and (d1 <> 256)
                  then begin
                     if k=1
                     then begin
                        if d1 < 192
                        then despb^ [j] := d1
                        else begin
                           despb^ [j] := 193;
                           despb^ [j+1] := d1;
                           inc (j)
                        end;
                        inc (j)
                     end
                     else begin
                        if k=64 then k:=63;
                        despb^ [j] := 192+k;
                        despb^ [j+1] := d1;
                        k := 1;
                        j:= j+2
                     end
                  end;
                  d1 := d;
               end;

               if k=1
               then begin
                  if d1 < 192
                  then despb^ [j] := d1
                  else begin
                     despb^ [j] := 193;
                     despb^ [j+1] := d1;
                     inc (j)
                  end;
                 inc (j)
               end
               else begin
                  if k=64 then k := 63;
                  despb^ [j] := 192+k;
                  despb^ [j+1] := d1;
                  k := 1;
                  j := j+2
               end;
               if odd (tx)
               then begin
                  despb^ [j] := 0;
                  inc (j)
               end
            end
         end;
         taille := j-1;
         assign    (image, nomb);
         rewrite   (image, 1);
         blockwrite(image, despb^, taille);
         close     (image);
         dispose   (despb);
         dispose   (dessin)
      end else test := false
   end;

procedure scanpcx (noms, nomb : pathstr; var test : boolean);
   var
      cor               : array [0..15] of word;
      sc                : file of char;
      ii, mul, dd,
      ppp, mul2,
      er, ro, ve, bl,
      maxi, mini        : integer;
      tx, ty, i, j,
      txx,
      d1, u, v, d,
      n, k,
      nbp, nump         : word;
      car               : char;
      ch                : string;

   begin
      assign (sc, noms);
      filemode := 0;
      {$I-}
      reset  (sc);
      {$I+}
      filemode := 2;
      if ioresult=0
      then begin
         new (despb); new (dessin);
         test   := true;
         taille := filesize (sc);
         read (sc, car);
         i  := 1;
         ch := '';
         while car <> ','
         do begin
            ch := ch+car;
            read (sc, car);
            i := i+1;
         end;
         val (ch, tx, er);

         ch  := '';
         read (sc, car);
         i := i+1;
         while car<>','
         do begin
            ch := ch+car;
            read (sc, car);
            i := i+1;
         end;
         val (ch, ty, er);

         ch := '';
         read (sc, car);
         i := i+1;
         while car <> ','
         do begin
            ch := ch+car;
            read (sc, car);
            i := i+1;
         end;
         val (ch, mini, er);
         ch:= '';
         read (sc, car);
         i := i+1;
         while ((ord (car) <> 10) and (ord (car) <> 13))
         do begin
            ch := ch+car;
            read (sc, car);
            i := i+1;
         end;
         val (ch, maxi, er);

{         despb^[13]:=180; despb^[14]:=0;
         despb^[15]:=180; despb^[16]:=0;
}        despb^[13] :=tx mod 256; despb^[14] := trunc (tx / 256);
         despb^[15] :=ty mod 256; despb^[16] := trunc (ty / 256);
         txx := tx;
         tx  := tx div 8;

         nbp := (taille-6) div (tx*ty);

         despb^[1]  := 10;
         despb^[2]  :=  5;
         despb^[3]  :=  1;
         despb^[4]  :=  8;
         despb^[5]  :=  0;
         despb^[6]  :=  0;
         despb^[7]  :=  0;
         despb^[8]  :=  0;
         despb^[9]  := despb^[13];
         despb^[10] := despb^[14];
         despb^[11] := despb^[15];
         despb^[12] := despb^[16];

         despb^[65] :=   0;
         despb^[66] := nbp;
         despb^[67] :=  10;
         despb^[68] :=   0;
         despb^[69] := 255;
         despb^[70] := 255;
         despb^[71] := 176;
         despb^[72] :=   1;
{         for n := 1 to 4 do   despb^[8+n] := dessin^[n];}

         ty := ty-1;
         despb^[67] := 2 * ((tx+1) div 2); despb^[68] := 0;
         j      := 129;
         taille := 0;
         for u := 1 to ty
         do begin
            i  := i+1;
            ii := i;
            mul:= 1;
            for nump := 1 to nbp
            do begin
               seek (sc, ii);
               i := ii;
               for v := 0 to tx-1
               do begin
                  d := 0; mul2 := 128;
                  for ppp := 1 to 8
                  do begin
                     read (sc, car);
                     inc  (i);
                     dd := ord(car);
                     if (dd and mul) = mul
                     then
                        dd := 1 else dd := 0;
                     d    := d+dd*mul2;
                     mul2 := mul2 div 2;
                  end;
                  despb^[j] := 193; despb^[j+1] := d; inc(j);
                  inc (j)
               end;
               if tx*8<txx then for v := 1 to txx-tx*8
               do begin
                  read (sc, car);
                  inc  (i);
               end;
               mul := 2*mul;
               if odd (tx)
               then begin
                  despb^[j] := 0;
                  inc (j)
               end
            end
         end;
         despb^[j] := 12;
         inc (j);
         if mini>0
         then
            for n := 0 to mini-1
         do begin
            despb^[j] := 0; despb^[j+1] := 0; despb^[j+2] := 0;
            j := j+3;
         end;
         for n := mini to maxi
         do begin
            ro := n; ve := n; bl := n;
            despb^[j] := ro; despb^[j+1] := ve; despb^[j+2] := bl;
            j:=j+3;
         end;
         if maxi < 255
         then
            for n := maxi+1 to 255
         do begin
            despb^[j]   := 255;
            despb^[j+1] := 255;
            despb^[j+2] := 255;
            j := j+3;
         end;
         taille := j-1;
         close  (sc);
         assign     (image, nomb);
         rewrite    (image, 1);
         blockwrite (image, despb^, taille);
         close      (image);
         dispose    (despb);
         dispose    (dessin)
      end else test := false
   end;

procedure chargepalette (nom : pathstr; var test : boolean);
   type
      teintes = record
                   rvb : array [0..15]
                            of record
                               r, v, b : integer
                            end;
                   p   : palettetype;
                end;

   var
      palette        : file of teintes;
      pal            : teintes;
      i              : integer;

   begin
      if (maxcolor = 15) or (maxcolor = 1)
      then begin
         filemode := 0;
         assign (palette, nom);
         {$I-}
         reset    (palette);
         {$I+}
         if ioresult=0
         then begin
            test := true;
            read  (palette, pal);
            setallpalette (pal.p);
            for i := 0 to 15 do
               setrgbpalette
                  (i, pal.rvb [i].r, pal.rvb [i].v, pal.rvb [i].b);
            close (palette);
         end else
            test := false;
         filemode := 2;
      end;
   end;

procedure sauvepalette (nom : pathstr; var ok : boolean );
   type
      teintes = record
                   rvb : array [0..15]
                            of record
                               r, v, b : integer
                            end;
                   p   : palettetype;
                end;
   var
      palette        : file of teintes;
      pal            : teintes;
      i              : integer;

   begin
      ok := false;
      assign     (palette, nom);
      {$I-}
      rewrite    (palette);
      {$I+}
      if ioresult = 0
      then begin
         ok := true;
         for i := 0 to 15
         do
            getrgbpalette (i, pal.rvb [i].r, pal.rvb [i].v, pal.rvb [i].b);
         getpalette (pal.p);
         write      (palette, pal);
         close      (palette);
      end;
   end;

procedure grisligne;
   var
      t                 : array [1..9]
                             of longint;

   begin
      t [1] := $ffff;
      t [2] := $fbfb;
      t [3] := $bbbb;
      t [4] := $abab;
      t [5] := $aaaa;
      t [6] := $4949;
      t [7] := $1111;
      t [8] := $0101;
      t [9] := $0000;
      setlinestyle (4, t [niveau], 1);
   end;

function curfleche : pointer;
   begin
      curfleche := fleche;
   end;

procedure fcouleurhp6;
   begin
      couleur_b [noir,         hp6] := 6;
      couleur_b [bleu,         hp6] := 1;
      couleur_b [vert,         hp6] := 2;
      couleur_b [cyan,         hp6] := 3;
      couleur_b [rouge,        hp6] := 4;
      couleur_b [magenta,      hp6] := 5;
      couleur_b [brun,         hp6] := 3;
      couleur_b [gris_clair,   hp6] := 6;
      couleur_b [gris_fonce,   hp6] := 6;
      couleur_b [bleu_clair,   hp6] := 1;
      couleur_b [vert_clair,   hp6] := 2;
      couleur_b [cyan_clair,   hp6] := 3;
      couleur_b [rouge_clair,  hp6] := 4;
      couleur_b [magenta_clair,hp6] := 5;
      couleur_b [jaune,        hp6] := 3;
      couleur_b [blanc,        hp6] := 6;
   end;

procedure fcouleur (f1, f2, f3, f4 : word);
   var
      pf1, pf2,
      pf3, pf4,
      c                 : couleur_palette;
      i                 : byte;

   begin
      pf1 := nomcouleur (couleurnum (f1));
      pf2 := nomcouleur (couleurnum (f2));
      pf3 := nomcouleur (couleurnum (f3));
      pf4 := nomcouleur (couleurnum (f4));
      couleur_b [noir,         ecr] :=  0;
      couleur_b [blanc,        ecr] := 15;
      case maxcolor of
         15 : begin
                 i := 1;
                 for c := bleu to jaune
                 do begin
                    couleur_b [c, ecr] := i;
                    inc (i);
                 end;
              end;
          2 : begin
                 for c := vert to jaune
                 do
                    couleur_b [c, ecr] := 15;
                 if f1 <> 0
                 then
                    couleur_b [pf1, ecr] := 0;
                 if f2 <> 0
                 then
                    couleur_b [pf2, ecr] := 0;
                 if f3 <> 0
                 then
                    couleur_b [pf3, ecr] := 0;
                 if f4 <> 0
                 then
                    couleur_b [pf4, ecr] := 0;

              end;
          0 : begin                                    { maxcolor = 0 }
                 for c := vert to jaune
                 do
                    couleur_b [c, ecr] := 0;
                 if f1 <> 0
                 then
                    couleur_b [pf1, ecr] := 15;
                 if f2 <> 0
                 then
                    couleur_b [pf2, ecr] := 15;
                 if f3 <> 0
                 then
                    couleur_b [pf3, ecr] := 15;
                 if f4 <> 0
                 then
                    couleur_b [pf4, ecr] := 15;

                 couleur_b [blanc, ecr]  := 0;
{                 couleur_b [noir, ecr]  := 15;   }
              end;
      end;
   end;

function nomcouleur           (c       : word)              : couleur_palette;
   var
      s                 : couleur_palette;
      i                 : integer;
      trouve            : boolean;

   begin
      i := 0;
      s := noir;
      trouve := couleur_b [s, ecr] = c;
      while (not trouve) and (i < 15)
      do begin
         s := succ (s);
         inc (i) ;
         trouve := couleur_b [s, ecr] = c;
      end;
      if trouve
      then
         nomcouleur := s
      else
         if maxcolor <> 0
         then
            nomcouleur := blanc
         else
            nomcouleur := noir;
   end;

function numcouleur (nomcoul : couleur_palette) : word;
   begin
      numcouleur := couleur_b [nomcoul, ecr]
   end;

function couleurnum (num     : word)            : word;
   var
      s                 : couleur_palette;
      i                 : integer;

   begin
      if num > 15 then couleurnum := 15;
      if num < 0  then couleurnum :=  0;
      i := 0;
      s := noir;
      while  (i < num)
      do begin
         s := succ (s);
         inc (i) ;
      end;
      couleurnum := couleur_b [s, ecr]
   end;

END.

{--- GRAPHISM ----------------------------------------------- ARX - BALMA --}
