PROGRAM points_et_lignes_en_3_d;


USES
   crt,
   dos,
   graph,
   graphism,
   menus,
   fctmath,
   math3d_c,
   souris,
   lipar,
   utildivs,
   fichiers,
   imprim;


CONST
   coefpi     = 0.01745329252; { pi/180 }
   infini  =   1e38;

   xg      =      0;
   yh      =      0;
   lbtons  =    150;

   nmax    =  10921;
   nsmax   =   nmax;


   commentaire_fic  =  'nom du nouveau fichier';
   filtre_pal       =  '*.pal';

TYPE

   points           =  record  x,  y,  z  : integer  end;
   liste_de_points  =  array  [0..nmax]  of points;

   liste            =  record
                          pts       : ^liste_de_points;
                          debut,
                          fin       : integer;
                          contours  : boolean;
                        end;

   liste_de_reels   =  array  [0..nmax]  of real;
   liste_r          =  ^liste_de_reels;

   limites          =  record
                          xg,  xd,  yb,  yh  : integer;
                       end;

   liste_de_boites  =  ^t_boite;
   t_boite          =  record
                          lim          : limites;
                          a            : char;
                          s            : liste_de_boites;
                       end;


VAR
   mx, my, mz,
   mr, mr0,
   mx1, my1, mz1    : mat;

   org              : vect;

   azimuth, site,
   zoom, zoom_z,
   zoom_max_abs,
   zoom_max,
   zoom_z_max,
   valeur_unit,

   xmin, xmax,
   ymin, ymax,
   zmin, zmax,
   xlmax, ylmax,
   zlmax,

   donnee_min,
   donnee_max,
   donnee_deb,
   donnee_fin,

   diametre,
   echelle,
   echelle_z,
   ech_z_init       : real;

   nbpoints,
   nbseismes,
   ray,
   deus_coul,
   debut, fin,
   espace_v,
   espace, hh,
   demi_dim,
   pas_r,
   xd, yb,
   xs, ys,
   xsg, xsd,
   xxg, xxd,
   yyh, yyb,
   xxm, yym,
   yh_dubas,
   xg_dubas         : integer;

   format_4dt,
   format_4dp,
   format_zoomt,
   format_zoomp     : byte;

   quatrieme_donnee,
   seismes_x,
   seismes_y,
   seismes_z        : liste_r;

   reference,
   vue0,
   vue1, vue2       : liste;

   nul,
   contours,
   fils_seuls,
   axes_ecran,
   inversion_z,
   quitter,
   bln              : boolean;

   fichier          : text;

   fic, visu,
   l_fic            : lst_chn;

   fenetre,
   boite_donnee,
   boite_axes_ecran,
   boite_ctr,
   boites           : liste_de_boites;

   binf, bsup,
   cadre            : limites;

   params           : lipar.liste;

   cheminmodule,
   region,
   nom4d,
   unite_a_z,
   chemind,
   nom_pal,
   repbgi   : string;


function  dans (x, y : integer; l : limites)  :boolean;
   begin
      with l do dans  :=   (y >=yh)  and  (y <=yb)  and  (x >=xg)  and  (x <=xd) ;
   end;

procedure fixe_lims (var l : limites; xg, yh, xd, yb :integer) ;
   begin
      l.xg  :=  xg;
      l.xd  :=  xd;
      l.yh  :=  yh;
      l.yb  :=  yb;
      rectangle ( xg,  yh,  xd,  yb ) ;
   end;

procedure decale (var lim : limites; x : integer; bout, cadre : limites) ;
   var
      y1, y2   : integer;

   begin
      with lim
      do begin
         y1  :=   (yh+yb)  div 2 - 1;
         y2  :=  y1+2;

         setcolor (0) ;
         rectangle ( xg,  yh,  xd,  yb ) ;

         if xd <bout.xg
         then begin

            if xg+x <= cadre.xg+2 then x  :=  cadre.xg+2-xg;
            if xd+x >= bout.xg    then x  :=  bout.xg-xd-1;

            if x > 0
            then begin
               setfillstyle (1,  0) ;
               bar (xd+1, y1, xd+x, y2) ;
            end else begin
               setfillstyle (1, 15) ;
               bar (xd+x, y1, xd,   y2) ;
            end;

         end else begin

            if xd+x >= cadre.xd-2 then x  :=  cadre.xd-2-xd;
            if xg+x <= bout.xd    then x  :=  bout.xd-xg+1;

            if x < 0
            then begin
               setfillstyle (1,  0) ;
               bar (xg-1, y1, xg+x, y2) ;
            end else begin
               setfillstyle (1, 15) ;
               bar (xg+x, y1, xg,   y2) ;
            end;
         end;

         xg  :=  xg+x;
         xd  :=  xd+x;

         setcolor  (15) ;
         rectangle ( xg,  yh,  xd,  yb ) ;
      end;
   end;

procedure formater (x  : real ; t,  p  : integer ; var s  : string) ;
   begin
      str (x :t:p, s) ;
      if pos ('.', s)  > (t-1)
         then s  :=  copy (s, 1, pos ('.', s) -1)
         else s  :=  copy (s, 1, t) ;
      while length (s)  < t do s  :=  ' '+s;
   end;

procedure calc_donnee;
   var
      dim  : integer;
      ch   : string;

   begin
      dim         :=  (cadre.xd-cadre.xg-4-binf.xd+binf.xg) ;
      donnee_deb  :=  donnee_min+ (donnee_max-donnee_min)
                                * (binf.xg-cadre.xg-2) /dim;
      donnee_fin  :=  donnee_min+ (donnee_max-donnee_min)
                                * (bsup.xg-cadre.xg-2) /dim;

      setfillstyle (1, 0) ;
      bar (xsg+1+espace+10,             yyh+hh+6* (espace_v+41) +29,
          xsg+3* (espace+41) -10,       yyh+hh+6* (espace_v+41) +29+8 ) ;
      setcolor (15) ;

      formater (donnee_deb, format_4dt, format_4dp, ch) ;
      outtextxy (xsg+1+espace+10,       yyh+hh+6* (espace_v+41) +29, ch) ;

      formater (donnee_fin, format_4dt, format_4dp, ch) ;
      outtextxy (xsg+3* (espace+41) -10-8*format_4dt,  yyh+hh+6* (espace_v+41) +29, ch) ;
   end;

procedure modif_donnee;
   var
      xdep, ydep,
      xmem, ymem,
      bidon        : integer;
      g, d, fini,
      deplace      : boolean;
      a            : char;

   begin
      fini  :=  false;
      xmem  :=  0; ymem  :=  0;

      if not dans (xs, ys, boite_donnee^.lim)
      then
         with boite_donnee^.lim
         do begin
            xs  :=   (xd+xg)  div 2;
            ys  :=   (yh+yb)  div 2;
         end;

      repeat
         if keypressed
         then begin
            a  :=  readkey;
            case a of
               '/'  : decale (binf, -3, bsup, cadre) ;
               '*'  : decale (binf,  3, bsup, cadre) ;
               '-'  : decale (bsup, -3, binf, cadre) ;
               '+'  : decale (bsup,  3, binf, cadre) ;
               #13  : fini  :=  true;
               'q'  : begin
                         fini     :=  true;
                         quitter  :=  true;
                      end;
            end;
            calc_donnee;
         end else begin

            compteursouris (xdep, ydep) ;
            xmem := 0;
            ymem := 0;

            if UnBoutonSourisEnfonce  and dans (xs, ys, binf)
            then begin
               repeat
                  compteursouris (xdep, ydep) ;

                  deplace  :=  not  ( (xdep = 0)  and  (ydep = 0) ) ;

                  if deplace
                  then begin
                     xs  :=  xs+xdep; ys  :=  ys+ydep;
                     if xs < xg
                        then  xs  :=  xg  else if xs > xd then  xs  :=  xd;
                     if ys < yh
                        then  ys  :=  yh  else if ys > yb then  ys  :=  yb;

                     decale (binf, xs- (binf.xd+binf.xg)  div 2, bsup, cadre) ;
                     calc_donnee;

                     xmem  :=  xdep;  ymem  :=  ydep;
                  end else begin
                     xmem  :=  xdep;   ymem  :=  ydep;
                  end;
               until not  UnBoutonSourisEnfonce ;
               fini  :=  true;

            end else if UnBoutonSourisEnfonce and dans (xs, ys, bsup)
            then begin

               repeat
                  compteursouris (xdep, ydep) ;

                  deplace  :=  not  ( (xdep = 0)  and  (ydep = 0) ) ;

                  if deplace
                  then begin
                     xs  :=  xs+xdep; ys  :=  ys+ydep;
                     if xs < xg
                        then  xs  :=  xg  else if xs >xd then  xs  :=  xd;
                     if ys < yh
                        then  ys  :=  yh  else if ys >yb then  ys  :=  yb;

                     decale (bsup, xs- (bsup.xd+bsup.xg)  div 2, binf, cadre) ;
                     calc_donnee;

                     xmem  :=  xdep;  ymem  :=  ydep;
                  end else begin
                     xmem  :=  xdep;   ymem  :=  ydep;
                  end;
               until not  UnBoutonSourisEnfonce ;
               fini  :=  true;

            end else begin
               fini := true;
            end;

         end;
      until fini;

   end;

procedure cree_boite ( xg,  yh,  xd,  yb  : integer ; aa  : char ) ;
   var
      b  : liste_de_boites;

   begin
      new (b) ;

      with b^
      do begin
         fixe_lims (lim, xg, yh, xd, yb) ;
         a   :=  aa;
         s   :=  boites;

         outtextxy ( xg+3,  yh+3,  a ) ;
      end;

      boites  :=  b;
   end;

function  zone ( x,  y  : integer)   : char;
   var
      rep  : char;
      b    : liste_de_boites;

   begin
      b    :=  boites;
      rep  :=  ' ';

      while  (b <>nil)  and  (rep = ' ')
      do begin
         if dans (x, y, b^.lim)  then  rep  :=  b^.a;
         b  :=  b^.s;
      end;

      zone  :=  rep;
   end;

procedure bouton ( nom  : string; x, y  : integer; a  : char ) ;
   var
      image  : pointer;
      nul    : boolean;

   begin
      loadimage (nom, image, nul) ;
      putimage  (x, y, image^, 1) ;
      if not nul then libere (image) ;
      cree_boite (x, y, x+40, y+40, a) ;
   end;

procedure affiche_pas (n :integer) ;
   var
      ch   : string;

   begin
      str (n, ch) ;
      setfillstyle (1, 0) ;
      setcolor (0) ;
      bar (xsg+1+espace+13, yyh+hh+3* (espace_v+41) +23,
          xsg+1+espace+45, yyh+hh+3* (espace_v+41) +23+8 ) ;
      setcolor (15) ;
      outtextxy (xsg+1+espace+29-4*length (ch) ,
                 yyh+hh+3* (espace_v+41) +23, ch) ;
   end;

function hauteur : real;  { en radians }
   var
     h1 : real;
   { h1 : 0 = horizontale; pi/2 = znith; pi = envers; 3*pi/2 = dessous }
   { h  : 0 = horizontale; pi/2 = znith; 0  = envers; -pi/2  = dessous }
   begin
     if (mr [z, y] = 0) and (mr [z, z] = 0)
     then hauteur := 0
     else begin
       h1 := arctangente (-mr [z, y], sqrt( sqr(mr [z, z]) + sqr(mr [z, x]) ) );
       if h1 > pi/2  then h1 := pi - h1;
       if h1 < -pi/2 then h1 := -pi - h1;
       hauteur := h1
     end;
   end;

function orientation : real;  { en radians [0 .. 2 pi]           }
   { 0 = Est; pi/2 = Nord; ... }
   var
      mrm1 : mat;

   begin
      if inversion (mr, mrm1)
      then
        { 0 = Est;  3*pi/2 = Nord; ... }
     (*   if (mrm1 [y, y] = 0) and (mrm1 [y, x] = 0)
        then  { cas particulier }
           orientation := arctangente ( mrm1 [x, y],  mrm1 [x, x])
        else
           orientation := arctangente (-mrm1 [y, y], -mrm1 [y, x]);*)

        { 0 = Nord;  pi/2 = est; ... }
        if (abs(mrm1 [y, x]) < 1e-4) and (abs(mrm1 [y, z]) < 1e-4)
        then  { cas particulier }
           orientation := 0
        else
           orientation := arctangente (-mr [y, x], mr [y, z]);
   end;

procedure defrotations (n :integer) ;
   var
      nul  : boolean;
   begin
      mrotation (vux, 2*pi/n, mx) ;
      mrotation (vuy, 2*pi/n, my) ;
      mrotation (vuz, 2*pi/n, mz) ;
      nul  :=  inversion (mx, mx1) ;
      nul  :=  inversion (my, my1) ;
      nul  :=  inversion (mz, mz1) ;
      affiche_pas (n) ;
   end;

procedure defrotations_axes (n :integer) ;
   var
      nul  : boolean;
   begin
      mrotation (mr [x] , 2*pi/n, mx) ;
      mrotation (mr [y] , 2*pi/n, my) ;
      mrotation (mr [z] , 2*pi/n, mz) ;
      nul  :=  inversion (mx, mx1) ;
      nul  :=  inversion (my, my1) ;
      nul  :=  inversion (mz, mz1) ;
      affiche_pas (n) ;
   end;

procedure affiche_zooms;
   var
      ch  : string;

   begin
      setfillstyle (1, 0) ;

      str (zoom :4 :2, ch) ;
      setcolor  (0) ;
      bar (xsg+1+espace+10, yyh+hh+4* (espace_v+41) +17,
           xsg+1+espace+42, yyh+hh+4* (espace_v+41) +17+8) ;
      setcolor  (15) ;
      outtextxy (xsg+1+espace+10, yyh+hh+4* (espace_v+41) +17, ch) ;

      formater (echelle/ (zoom_z*echelle_z) , format_zoomt, format_zoomp, ch) ;

      setcolor  (0) ;
      bar (xsg+1+espace+10,                yyh+hh+5* (espace_v+41) +12,
           xsg+1+espace+10+format_zoomt*8, yyh+hh+5* (espace_v+41) +12+8) ;
      setcolor  (15) ;
      outtextxy (xsg+1+espace+10, yyh+hh+5* (espace_v+41) +12, ch) ;
   end;

procedure calcule_zooms_maxs;
   begin
      zoom_z_max :=  4095 * sqrt (1/sqr (zoom) - 1 / sqr (zoom_max_abs))
                              / (zlmax*echelle_z) ;
      if zoom_z_max >9.99 then zoom_z_max  :=  9.99;
      if zoom_z >zoom_z_max then zoom_z  :=  zoom_z_max;

      zoom_max   :=  4095 /
                  sqrt (sqr (diametre*echelle) + sqr (zlmax*echelle_z*zoom_z)) ;
      if zoom_max   >9.99 then zoom_max    :=  9.99;
   end;

procedure lecture_fichier;
   var
      ch          : string;
      i, j        : integer;
      a, b, c, d  : real;
      nul         : boolean;

   begin
      { test du fichier de points }
      nbseismes  :=  0;
      visu       :=  fic^.elements;

      if not fils_seuls
      then begin
         assign (fichier, chemind+visu^.nom^) ;
         reset  (fichier) ;

         repeat
            readln (fichier, ch) ;
            inc (nbseismes) ;
         until eof (fichier) ;

         if ch = '' then dec (nbseismes) ;

         close (fichier) ;
         visu  :=  visu^.suivant;
      end;

      { test du fichier de contours }

      if ftxt_present (chemind+visu^.nom^)
      then begin
         nbpoints  :=  0;
         bln := (extension (visu^.nom^) = '.BLN');
         while visu <> nil
         do begin
            assign (fichier, chemind+visu^.nom^) ;
            reset (fichier) ;

            repeat
               readln (fichier, a, ch) ;
               for i  :=  1 to round (a)  do readln (fichier, ch) ;
               nbpoints  :=  nbpoints+round (a) ;
            until eof (fichier) ;
            close (fichier) ;
            visu  :=  visu^.suivant;
         end;
      end;
      { initialisations }

      if nbseismes >nsmax  then nbseismes  :=  nsmax+1;
      nbpoints  :=  nbpoints+nbseismes;
      if nbpoints  >nmax   then nbpoints   :=  nmax +1;

      getmem ( seismes_x,        nbpoints * sizeof (real)  ) ;
      getmem ( seismes_y,        nbpoints * sizeof (real)  ) ;
      getmem ( seismes_z,        nbpoints * sizeof (real)  ) ;
      getmem ( quatrieme_donnee, nbpoints * sizeof (real)  ) ;

      getmem ( reference.pts,    nbpoints * sizeof (points)  ) ;
      getmem ( vue1.pts,         nbpoints * sizeof (points)  ) ;
      getmem ( vue2.pts,         nbpoints * sizeof (points)  ) ;

      nbseismes  :=  nbseismes-1;
      nbpoints   :=  nbpoints -1;

      xmin  :=  infini; xmax  :=  -infini;
      ymin  :=  infini; ymax  :=  -infini;
      zmin  :=  infini; zmax  :=  -infini;

      { lecture des points }

      visu  :=  fic^.elements;

      if not fils_seuls
      then begin
         assign (fichier, chemind+visu^.nom^) ;
         reset (fichier) ;

         for i  :=  0 to nbseismes
         do begin
            readln (fichier, a, b, c, d) ;

            if inversion_z then c  :=  -c;
            if a < xmin then  xmin  :=  a  else  if a >xmax then  xmax  :=  a;
            if b < ymin then  ymin  :=  b  else  if b >ymax then  ymax  :=  b;
            if c < zmin then  zmin  :=  c  else  if c >zmax then  zmax  :=  c;

            seismes_x^[i]   :=  a;
            seismes_y^[i]   :=  b;
            seismes_z^[i]   :=  c;
            quatrieme_donnee^[i]   :=  d;
         end;

         close (fichier) ;
         visu  :=  visu^.suivant;
      end;

      { lecture des contours }

      j  :=  nbseismes;

      while visu  <> nil
      do begin
         if ftxt_present (chemind+visu^.nom^)
         then begin
            assign  (fichier,  chemind+visu^.nom^) ;
            reset   (fichier) ;

            repeat
               readln (fichier,  a,  ch) ;

               if visu^.elements  =  nil
               then begin
                  quatrieme_donnee^[j+1]      :=   a+7/1000;
               end else begin
                  val  (visu^.elements^.nom^,  c,  i) ;
                  if c  > getmaxcolor then c  :=   getmaxcolor;
                  if c  < 0           then c  :=   0;
                  quatrieme_donnee^  [j+1]    :=   a+c/1000;
               end;

               for i  :=  1 to round (a)
               do begin
                  if bln
                  then begin
                     readln  (fichier, b, c) ;
                     d  :=  0 end
                  else readln  (fichier, b, c, d) ;
                  if  (j+i)   <  (nbpoints+1)
                  then begin
                     if b < xmin
                        then  xmin  :=  b
                        else  if b  > xmax then  xmax  :=  b;
                     if c < ymin
                        then  ymin  :=  c
                        else  if c  > ymax then  ymax  :=  c;
                     if d < zmin
                        then  zmin  :=  d
                        else  if d  > zmax then  zmax  :=  d;

                     seismes_x^[j+i]   :=  b;
                     seismes_y^[j+i]   :=  c;
                     seismes_z^[j+i]   :=  d;
                  end else begin
                     i    :=  round  (a) ;
                     nul  :=  seekeof  (fichier) ;
                     while visu <> nil do visu  :=  visu^.suivant;
                  end;
               end;
               j  :=  j+round (a) ;
            until eof (fichier) ;

            close (fichier) ;
         end;
         if visu <> nil then visu  :=  visu^.suivant;
      end;
   end;

procedure select_donnee;
   begin
      debut  :=  0;
      while quatrieme_donnee^[debut]   < donnee_deb do   inc (debut) ;

      fin    :=  nbseismes;
      while quatrieme_donnee^[fin]     > donnee_fin do   dec (fin) ;
   end;

procedure tri_par_quatrieme_donnee;

   procedure trier (g, d :integer) ;
      var
         gch, drt   : integer;
         critere,
         tampon    : real;

      begin
         gch  :=  g; drt  :=  d;
         critere  :=  quatrieme_donnee^[ (g+d)  div 2] ;

         repeat
            while quatrieme_donnee^[gch]  < critere do inc (gch) ;
            while quatrieme_donnee^[drt]  > critere do dec (drt) ;

            if gch <= drt
            then begin
               tampon            :=  seismes_x^[drt] ;
               seismes_x^[drt]   :=  seismes_x^[gch] ;
               seismes_x^[gch]   :=  tampon;
               tampon            :=  seismes_y^[drt] ;
               seismes_y^[drt]   :=  seismes_y^[gch] ;
               seismes_y^[gch]   :=  tampon;
               tampon            :=  seismes_z^[drt] ;
               seismes_z^[drt]   :=  seismes_z^[gch] ;
               seismes_z^[gch]   :=  tampon;
               tampon            :=  quatrieme_donnee^[drt] ;
               quatrieme_donnee^[drt]   :=  quatrieme_donnee^[gch] ;
               quatrieme_donnee^[gch]   :=  tampon;
               inc (gch) ;
               dec (drt) ;
            end;
         until gch >drt;

         if g < drt then trier (g, drt) ;
         if gch < d then trier (gch, d) ;
      end;

   begin
      trier (0, nbseismes) ;
      donnee_min  :=  quatrieme_donnee^[0] ;
      donnee_max  :=  quatrieme_donnee^[nbseismes] ;
      donnee_deb  :=  donnee_min;
      donnee_fin  :=  donnee_max;
      select_donnee;
   end;

procedure init_points;
   var
      dim_min_fen  : integer;

   begin
      { origine,  facteur d'echelle }

      lecture_fichier;

      if not fils_seuls
      then begin
         tri_par_quatrieme_donnee;
         calc_donnee;
      end;

      fixevect (  (xmin+xmax) /2,   (ymin+ymax) /2,   (zmin+zmax) /2,  org) ;

      xlmax   :=   xmax-xmin;
      ylmax   :=   ymax-ymin;
      zlmax   :=   zmax-zmin;

      dim_min_fen  :=  xxd-xxg;
      if  (yyb-yyh)  <dim_min_fen then  dim_min_fen  :=  yyb-yyh;

      demi_dim  :=  dim_min_fen div 2;

      if ech_z_init <0
      then begin
         diametre  :=  sqrt (sqr (xlmax) +sqr (ylmax) ) ;
         echelle   :=  dim_min_fen/diametre;
         if zlmax = 0 then zlmax  :=  diametre;
         echelle_z  :=  dim_min_fen/zlmax
      end else begin
         echelle_z  :=  ech_z_init/valeur_unit;
         diametre  :=  sqrt (sqr (xlmax) +sqr (ylmax) +sqr (zlmax*echelle_z) ) ;
         echelle   :=  dim_min_fen/diametre;
         echelle_z  :=  echelle_z*echelle;
      end;

      zoom_max_abs  :=  4095/dim_min_fen;
      zoom    :=  1;
      zoom_z  :=  1;

      calcule_zooms_maxs;
      affiche_zooms;
   end;

procedure complete (var s :string) ;
   begin
      if  (s <>'')  and  (s [length (s) ]  <>'\')  then s  :=  s+'\';
   end;

procedure ctr_ouinon;
   var
      x, y  : integer;

   begin
      with boite_ctr^.lim
      do begin
         setcolor (15) ;
         x  :=   (xd+xg)  div 2 - 12 + 4;
         y  :=   (yh+yb)  div 2 +  1;
         setfillstyle (1, 0) ;
         bar (x, y, x+24, y+8) ;
         if contours
            then outtextxy (x, y, 'oui')
            else outtextxy (x, y, 'non') ;
      end;
   end;

procedure axes_ecran_ouinon;
   var
      x, y  : integer;

   begin
      with boite_axes_ecran^.lim
      do begin
         setcolor (15) ;
         x  :=   (xd+xg)  div 2 - 12;
         y  :=   (yh+yb)  div 2 + 10;
         setfillstyle (1, 0) ;
         bar (x, y, x+24, y+8) ;
         if axes_ecran
            then outtextxy (x, y, 'oui')
            else outtextxy (x, y, 'non') ;
      end;
   end;

procedure lire_utilisateur; { nomutil+groupe, region }
   var
      f     : text;
      chain : string;

   begin
      assign (f, reptemp+'utilisat.eur');
      reset  (f);
      readln (f, chain);
      readln (f, chain);
      readln (f, region);
      readln (f, chain);              { module }
      readln (f, chain);              { module }
         complete (chain);
         chemind := chain+region+'\';
      readln (f, cheminmodule);
         complete (cheminmodule);
      close (f);
   end;

procedure init;
   type
      coord    =  record x, y :integer end;

   var
      erreur, hpal,
      hauteur, i,
      bidon, xgch    : integer;
      im             : pointer;
      xy             : ^coord;
      format_zoom,
      format_4d,
      nom_ini        : string;

   begin
      lire_utilisateur; { nomutil=nomutil+groupe, region }
      { affecter rpertoire configuration graphique   }
      repbgi  := maj (getenv ('repbgi'));
      if repbgi = '' then repbgi := cheminmodule;
      complete (repbgi);                       { ajoute ventuellement un \ }

      nom_ini := cheminmodule+'POLY.pts';

      nom_pal := 'poly.pal';
      axes_ecran  :=  true;
      quitter     :=  false;
      contours    :=  true;
      boites      :=  nil;
      unite_a_z   :=  '';

      { lecture du fichier d'initialisations pass en paramtre
        extension par dfaut  : .pts ou .fil selon le cas
        nom par dfaut        : seismes.pts      }

      params.init   (true);
      params.ajoute (Cstring  ('nom de la 4 donne',   @nom4d,          'magnitude'  ) ) ;
      params.ajoute (Cstring  ('format 4 donne',      @format_4d,      '3:1'        ) ) ;
      params.ajoute (Cboolean ('fils seuls',            @fils_seuls,     false   ));
      params.ajoute (Cinteger ('couleur des cadres',    @deus_coul,       7      ));
      params.ajoute (Cinteger ('rayon du repere',       @ray,            40      ));
      params.ajoute (Cstring  ('unit de l''axe z',     @unite_a_z,      'km/'  ));
      params.ajoute (Cboolean ('inversion de l''axe z', @inversion_z,    true    ));
      params.ajoute (Creal    ('valeur de l''unit',    @valeur_unit,     111    ));
      params.ajoute (Creal    ('echelle z initiale',    @ech_z_init,     -1      ));
      params.ajoute (Cstring  ('format zoom z',         @format_zoom,    '4:0'   ));
      params.ajoute (Clst_chn ('fichiers de donnes',   @l_fic     , Nil {(  violet (  seismes.dat ;  conti.bln (5) ))}));
      if ftxt_present (nom_ini)
      then params.lit (nom_ini) ;
      params.fini;

      fic   :=   l_fic;

      if pos (':', format_zoom)  > 0
      then begin
         val (copy (format_zoom, 1, pos (':', format_zoom) -1) , format_zoomt, erreur) ;
         val (copy (format_zoom, pos (':', format_zoom) +1, 2) , format_zoomp, erreur) ;
      end else begin
         val (format_zoom, format_zoomt, erreur) ;
         format_zoomp  :=  0;
      end;

      if pos (':', format_4d)  >0
      then begin
         val (copy (format_4d, 1, pos (':', format_4d) -1) , format_4dt, erreur) ;
         val (copy (format_4d, pos (':', format_4d) +1, 2) , format_4dp, erreur) ;
      end else begin
         val (format_4d, format_4dt, erreur) ;
         format_4dp  :=  0;
      end;

      if fils_seuls
      then begin
         hauteur   :=  26;
         espace_v  :=   7;
         hpal      :=  23;
      end else begin
         hauteur   :=  21;
         espace_v  :=   4;
         hpal      :=   8;
      end;

      ini_menu  (repbgi, 0) ;
      ReInitialiserSouris;

      if nom_pal = ''
      then
         for i  :=  0 to 7 do
            setrgbpalette (i+8, i*6+21, i*6+21, i*6+21)
      else chargepalette (repbgi+nom_pal, nul) ;

      clearviewport;

      { dfinition des cadres et des boutons }
      xd     :=  maxx;
      yb     :=  maxy-15;

      xxg    :=  xg+4; xxd  :=  xd-lbtons; xsg  :=  xxd+4; xsd  :=  xd-4;
      yyh    :=  yh+4; yyb  :=  yb-4;

      xxm    :=  (xxg+xxd)       div 2;
      yym    :=  (yyh+yyb)       div 2;
      espace :=  (xsd-xsg-3*41)  div 4;

      xs     :=  (xsg+xsd)  div 2;   ys   :=  yyh+11;

      setcolor   (15) ;
      rectangle  (  xg,   yh,   xd,   yb  ) ;
      setcolor   (deus_coul) ;
      cree_boite ( xxg,  yyh,  xxd,  yyb,  'f' ) ;
      fenetre  :=  boites;
      rectangle  (  xsg,  yyh,  xsd,  yyb ) ;

      cree_boite ( xsg+espace+1,         yyh+espace_v+1,
                   xsg+3* (espace+41) ,  yyh+espace_v+hauteur,  'q' ) ;
      setcolor   (15) ;
      outtextxy  ((xsg+xsd) div 2 - 27,  yyh+espace_v+hauteur div 2-3,  'QUITTER') ;

      hh  :=     hauteur+  espace_v+1;

      setcolor (deus_coul) ;
      cree_boite ( xsg+espace+1,         yyh+hh+espace_v+1,
                   xsg+3* (espace+41) ,  yyh+hh+espace_v+hauteur,  'F' ) ;
      setcolor (15) ;
      outtextxy ( (xsg+xsd)  div 2 - 27, yyh+hh+espace_v+hauteur div 2-3,  'FICHIER') ;

      hh  :=  hh+hauteur+  espace_v+1;

      setcolor (deus_coul) ;
      cree_boite ( xsg+espace+1,         yyh+hh+espace_v+1,
                   xsg+3* (espace+41) ,  yyh+hh+espace_v+hauteur,  'p' ) ;
      setcolor (15) ;
      outtextxy ( (xsg+xsd) div 2 - 27,  yyh+hh+espace_v+hauteur div 2-3,  'palette') ;

      hh  :=  hh+hauteur+2*espace_v+1;

      setcolor (6) ; {line (xsg+4, yyh+hh+ 8, xsg+10, yyh+hh+ 8) ;}
      outtextxy (xsg+2, yyh+hh+ 4, 'x-est') ;
      setcolor (3) ; {line (xsg+4, yyh+hh+20, xsg+10, yyh+hh+20) ;}
      outtextxy (xsg+2, yyh+hh+16, 'y-nord') ;
      setcolor (4) ; {line (xsg+4, yyh+hh+32, xsg+10, yyh+hh+32) ;}
      outtextxy (xsg+2, yyh+hh+28, 'z-ciel') ;

      setcolor (deus_coul) ;

      bouton (cheminmodule+'boite_zd.ima', xsg+1+espace+2* (espace+41) ,
                                                 yyh+hh+   (espace_v+41) , '6');
      bouton (cheminmodule+'boite_zg.ima', xsg+1+espace,
                                                 yyh+hh+   (espace_v+41) , '4');
      bouton (cheminmodule+'boite_yd.ima', xsg+1+espace+2* (espace+41) ,
                                                 yyh+hh+2* (espace_v+41) , '3');
      bouton (cheminmodule+'boite_yg.ima', xsg+1+espace+2* (espace+41) ,
                                                 yyh+hh,                   '9');
      bouton (cheminmodule+'boite_xb.ima', xsg+1+espace+   (espace+41) ,
                                                 yyh+hh+2* (espace_v+41) , '2');
      bouton (cheminmodule+'boite_xh.ima', xsg+1+espace+   (espace+41) ,
                                                 yyh+hh,                   '8') ;

      cree_boite (xsg+1+espace+   (espace+41) ,  yyh+hh+ (espace_v+41) ,
                  xsg+         2* (espace+41) ,  yyh+hh+ (espace_v+41) +40,'5');
      setcolor (15) ;
      outtextxy (xsg+1+espace+ (espace+41) +9,  yyh+hh+ (espace_v+41) +20, 'RAZ') ;


      { axes cran oui/non }

      setcolor (deus_coul) ;
      cree_boite (xsg+1+espace,            yyh+hh+2* (espace_v+41) ,
                  xsg+  espace+41,  yyh+hh+2* (espace_v+41) +40, 'i');
      outtextxy  (xsg+1+espace+ 4,  yyh+hh+2* (espace_v+41) +11, 'axes') ;
      outtextxy  (xsg+1+espace+ 1,  yyh+hh+2* (espace_v+41) +20, 'ecran') ;
      boite_axes_ecran  :=  boites;
      axes_ecran_ouinon;

      { pas de rotation }

      setcolor (deus_coul) ;
      cree_boite (xsg+1+espace,         yyh+hh+3* (espace_v+41) ,
                  xsg+3* (espace+41) ,  yyh+hh+3* (espace_v+41) +40, 'a');

      xgch  :=  60;
      outtextxy (xsg+1+espace+xgch, yyh+hh+3* (espace_v+41) + 5, ' pas de');
      outtextxy (xsg+1+espace+xgch, yyh+hh+3* (espace_v+41) +15, 'rotation');
      outtextxy (xsg+1+espace+xgch, yyh+hh+3* (espace_v+41) +25, 'en tours');

      setcolor (15) ;
      outtextxy (xsg+1+espace+25,   yyh+hh+3* (espace_v+41) + 8,   '1') ;
      line (     xsg+1+espace+18,   yyh+hh+3* (espace_v+41) +18,
                 xsg+1+espace+38,   yyh+hh+3* (espace_v+41) +18       ) ;


      { zoom }

      setcolor (deus_coul) ;
      rectangle ( xsg+1+espace,           yyh+hh+4* (espace_v+41) ,
                 xsg+ 3* (espace+41),     yyh+hh+4* (espace_v+41) +40);
      outtextxy ( xsg+1+espace+xgch,      yyh+hh+4* (espace_v+41) + 5, '  zoom  ');
      cree_boite (xsg+1+espace+xgch,      yyh+hh+4* (espace_v+41) +20,
                 xsg+1+espace+xgch+30,    yyh+hh+4* (espace_v+41) +36, '-') ;
      cree_boite (xsg+1+espace+xgch+34,   yyh+hh+4* (espace_v+41) +20,
                 xsg+1+espace+xgch+34+30, yyh+hh+4* (espace_v+41) +36, '+') ;

      setcolor (15) ;
      outtextxy ( xsg+1+espace+xgch+16,    yyh+hh+4* (espace_v+41) +25, '-') ;
      outtextxy ( xsg+1+espace+xgch+34+16, yyh+hh+4* (espace_v+41) +25, '+') ;


      { zoom z }

      setcolor (deus_coul) ;
      rectangle ( xsg+1+espace,            yyh+hh+5* (espace_v+41) ,
                  xsg+    3* (espace+41) , yyh+hh+5* (espace_v+41) +40) ;
      outtextxy ( xsg+1+espace+xgch,       yyh+hh+5* (espace_v+41) + 5, ' zoom z ');
      outtextxy ( xsg+1+espace+10,         yyh+hh+5* (espace_v+41) +22,  unite_a_z);
      cree_boite (xsg+1+espace+xgch,       yyh+hh+5* (espace_v+41) +20,
                 xsg+1+espace+xgch+30,     yyh+hh+5* (espace_v+41) +36, '/') ;
      cree_boite (xsg+1+espace+xgch+34,    yyh+hh+5* (espace_v+41) +20,
                 xsg+1+espace+xgch+34+30,  yyh+hh+5* (espace_v+41) +36, '*') ;

      setcolor (15) ;
      outtextxy ( xsg+1+espace+xgch+16,    yyh+hh+5* (espace_v+41) +25, '-') ;
      outtextxy ( xsg+1+espace+xgch+34+16, yyh+hh+5* (espace_v+41) +25, '+') ;


      { quatrieme_donnee }

      if not fils_seuls
      then begin
         setcolor (deus_coul) ;
         cree_boite (xsg+1 + espace,      yyh+hh+6* (espace_v+41) ,
                    xsg+ 3* (espace+41) , yyh+hh+6* (espace_v+41) +40, 'm') ;
         boite_donnee  :=  boites;
         outtextxy ( xsg+1+espace+xgch-4, yyh+hh+6* (espace_v+41) + 5, nom4d) ;

         fixe_lims (cadre, xsg+1 + espace+5,         yyh+hh+6* (espace_v+41) +16,
                           xsg+ 3* (espace+41) - 5,  yyh+hh+6* (espace_v+41) +25);
         setcolor (15) ;

         fixe_lims (bsup,  xsg+ 3* (espace+41) -12,  yyh+hh+6* (espace_v+41) +18,
                           xsg+ 3* (espace+41) - 7,  yyh+hh+6* (espace_v+41) +23) ;
         fixe_lims (binf,  xsg+ 3* (espace+41) -18,  yyh+hh+6* (espace_v+41) +18,
                           xsg+ 3* (espace+41) -13,  yyh+hh+6* (espace_v+41) +23) ;
         decale (binf, -300, bsup, cadre) ;
      end;


      { affichage du logo arx }

      loadimage (cheminmodule+'arx2.ima', im, nul) ;
      xy  :=  im;

      yh_dubas  :=  yyb-1-espace_v-xy^.y;
      xg_dubas  :=  2* (espace+41) +40-xy^.x;

      putimage (xsg+1+espace+xg_dubas, yh_dubas, im^, 4) ;
      libere (im) ;


      { boite contours oui/non }

      if not fils_seuls then begin
         xg_dubas  :=  xg_dubas-espace;

         setcolor (deus_coul) ;
         cree_boite (xsg+1+espace, yh_dubas, xsg+1+espace+xg_dubas, yyb-1-espace_v*3-hpal*2, 'c') ;
         boite_ctr  :=  boites;

         with boite_ctr^.lim do outtextxy ( (xd+xg)  div 2 - 16 + 4,   (yh+yb)  div 2 - 9,  'visu') ;
         ctr_ouinon;
      end;


      { affichage de la palette }

      for i  :=  0 to 7
      do begin
         setfillstyle (1, i+8) ;
         bar (xsg+1+espace+round ( i   *xg_dubas/8) , yyb-1-espace_v,
             xsg  +espace+round ( (i+1) *xg_dubas/8) , yyb  -espace_v-hpal) ;

         setfillstyle (1, i) ;
         bar (xsg+1+espace+round ( i   *xg_dubas/8) , yyb-1-espace_v*2-hpal,
             xsg  +espace+round ( (i+1) *xg_dubas/8) , yyb  -espace_v*2-hpal*2) ;
      end;


      { initialisation des rotations }

      pas_r  :=  256;
      defrotations (pas_r) ;
      mrotation (vux, pi/2, mr0) ;
      mr  :=  mr0;
   end;

procedure calcule;
   var
      i    : integer;
      mrs  : array [crdn, crdn]  of longint;

   begin
      mrs [x, x]   :=  round (mr [x, x] *8192) ;
      mrs [y, x]   :=  round (mr [y, x] *8192) ;
      mrs [z, x]   :=  round (mr [z, x] *8192) ;
      mrs [x, y]   :=  round (mr [x, y] *8192) ;
      mrs [y, y]   :=  round (mr [y, y] *8192) ;
      mrs [z, y]   :=  round (mr [z, y] *8192) ;
      mrs [x, z]   :=  round (mr [x, z] *8192) ;
      mrs [y, z]   :=  round (mr [y, z] *8192) ;
      mrs [z, z]   :=  round (mr [z, z] *8192) ;

      if not fils_seuls
      then begin
         vue1.debut     :=  debut;
         vue1.fin       :=  fin;
         vue1.contours  :=  contours;

         for i  :=  vue1.debut to vue1.fin
         do begin
            vue1.pts^[i] .x := (reference.pts^[i] .x*mrs [x, x] +
                                reference.pts^[i] .y*mrs [y, x] +
                                reference.pts^[i] .z*mrs [z, x] )  shr 16;
            vue1.pts^[i] .y := (reference.pts^[i] .x*mrs [x, y] +
                                reference.pts^[i] .y*mrs [y, y] +
                                reference.pts^[i] .z*mrs [z, y] )  shr 16;
            vue1.pts^[i] .z := (reference.pts^[i] .x*mrs [x, z] +
                                reference.pts^[i] .y*mrs [y, z] +
                                reference.pts^[i] .z*mrs [z, z] )  shr 16;
         end;
      end;

      if vue1.contours and  (nbpoints > nbseismes)
      then begin
         for i  :=  nbseismes+1 to nbpoints
         do begin
            vue1.pts^[i] .x := (reference.pts^[i] .x*mrs [x, x] +
                                reference.pts^[i] .y*mrs [y, x] +
                                reference.pts^[i] .z*mrs [z, x] )  shr 16;
            vue1.pts^[i] .y := (reference.pts^[i] .x*mrs [x, y] +
                                reference.pts^[i] .y*mrs [y, y] +
                                reference.pts^[i] .z*mrs [z, y] )  shr 16;
            vue1.pts^[i] .z := (reference.pts^[i] .x*mrs [x, z] +
                                reference.pts^[i] .y*mrs [y, z] +
                                reference.pts^[i] .z*mrs [z, z] )  shr 16;
         end;
      end;
      site    := hauteur;
      azimuth := orientation;
   end;

procedure modif_org;
   var
      mrm1        : mat;
      v           : vect;
      a           : char;
      fini, g, d,
      deplace     : boolean;
      xdep, ydep,
      xmem, ymem,
      bidon       : integer;

   begin
      if not dans (xs, ys, fenetre^.lim)
      then begin
         xs  :=  xxm;   ys  :=  yym;
         xmem  :=  0;   ymem  :=  0;
         a  :=  ' ';
         fini  :=  false;

         repeat
            if keypressed
            then begin

               a  :=  readkey;
               case a of
                  '4'  : xdep  :=  -12;
                  '6'  : xdep  :=   12;
                  '8'  : ydep  :=  -12;
                  '2'  : ydep  :=   12;
                  #13  : fini  :=  true;
                  'q'  : quitter  :=  true;
               end;

            end else begin
               compteursouris (xdep, ydep) ;
            end;

            xdep  :=  xdep+xmem;   ydep  :=  ydep+ymem;
            deplace  :=  not  ( (xdep div 3 = 0)  and  (ydep div 3 = 0) ) ;

            if deplace
            then begin
               xs  :=  xs+xdep div 3; ys  :=  ys+ydep div 3;
               if xs < xg
               then  xs  :=  xg
               else if xs > xd then  xs  :=  xd;
               if ys < yh
               then  ys  :=  yh
               else if ys > yb then  ys  :=  yb;
               xmem  :=  xdep mod 3;  ymem  :=  ydep mod 3;
            end else begin
               xmem  :=  xdep;   ymem  :=  ydep;
            end;

            fini  :=  fini or UnBoutonSourisEnfonce
                           or not dans (xs, ys, fenetre^.lim) ;
         until fini or quitter;

      end;

      if inversion (mr, mrm1)
      then begin
         fixevect (xs-xxm, 0, yym-ys, v) ;
         mmultv (mrm1, v, v) ;
         v [x]   :=  v [x]  /  (echelle  * zoom) ;
         v [y]   :=  v [y]  /  (echelle  * zoom) ;
         v [z]   :=  v [z]  /  (echelle_z* zoom * zoom_z) ;
         sommev (org, v, org) ;
         if org [x]  >xmax then org [x]   :=  xmax;
         if org [x]  <xmin then org [x]   :=  xmin;
         if org [y]  >ymax then org [y]   :=  ymax;
         if org [y]  <ymin then org [y]   :=  ymin;
         if org [z]  >zmax then org [z]   :=  zmax;
         if org [z]  <zmin then org [z]   :=  zmin;
      end;

      repeat until not UnBoutonSourisEnfonce ;
   end;

procedure definit_reference;
   var
      i     : integer;
   begin
      for i  :=  0 to nbpoints
      do begin
         reference.pts^[i] .x  :=  round (  (seismes_x^[i] -org [x] )  * 8
                                             * echelle   * zoom) ;
         reference.pts^[i] .y  :=  round (  (seismes_y^[i] -org [y] )  * 8
                                             * echelle   * zoom) ;
         reference.pts^[i] .z  :=  round (  (seismes_z^[i] -org [z] )  * 8
                                             * echelle_z * zoom * zoom_z) ;
      end;
   end;

procedure dessine_triedre (c  : integer) ;
   begin
      setcolor (c*6) ;  line ( xxm,  yym,
                               xxm+round (ray*mr [x, x] ) ,
                               yym-round (ray*mr [x, z] )  ) ;
      setcolor (c*3) ;  line ( xxm,  yym,
                               xxm+round (ray*mr [y, x] ) ,
                               yym-round (ray*mr [y, z] )  ) ;
      setcolor (c*4) ;  line ( xxm,  yym,
                               xxm+round (ray*mr [z, x] ) ,
                               yym-round (ray*mr [z, z] )  ) ;
   end;

procedure dessin ( t  : boolean ; vue  : liste ) ;
   var
      i, j, jm,
      a, b, c,
      x1, y1,
      x2, y2     : integer;

   begin
      if not fils_seuls
      then
         for i  :=  vue.debut to vue.fin
         do begin
            a  :=  xxm + vue.pts^[i] .x;
            if  (a >xxg)  and  (a < xxd)
            then begin
               b  :=  yym - vue.pts^[i] .z;
               if  (b >yyh)  and  (b < yyb)
               then begin
                  c  :=  round (11.5-vue.pts^[i] .y*4/demi_dim) ;
                  if  (c >7)  and  (c < 16)
                  then
                     if t then putpixel (a, b, c)
                          else putpixel (a, b, 0) ;
               end;
            end;
         end;

      if vue.contours and  (nbpoints > nbseismes)
      then begin
         i  :=  nbseismes+1;
         j  :=  1;
         setviewport (xxg+1, yyh+1, xxd-1, yyb-1, true) ;

         repeat
            x2  :=  x1;
            y2  :=  y1;

            x1  :=  xxm + vue.pts^[i] .x -xxg-1;
            y1  :=  yym - vue.pts^[i] .z -yyh-1;

            if j = 1
            then begin
               jm  :=  round (quatrieme_donnee^[i] ) ;
               if t then setcolor (round (1000*frac (quatrieme_donnee^[i] )  ) )
                    else setcolor (0) ;
            end else begin
               { dessin de la ligne }
               line (x1, y1, x2, y2) ;
            end;

            if j = jm then j  :=  1 else inc (j) ;
            inc (i) ;
         until i = nbpoints+1;

         setviewport (0, 0, maxx, maxy, true) ;
      end;
   end;

procedure affiche_angles;
   var
      a,   s     : integer;
      cha, chs   : string;

   begin
      a := round (azimuth/coefpi);
      s := round (site   /coefpi);
      str (a, cha);
      str (s, chs);
      if (a=0) and (s=0) then cha := '?';
      bar       (xxg+4,      yyb-12, xxd-4, yyb-4);
      outtextxy (xxg+4,      yyb-12, 'hauteur : '    +chs);
      outtextxy (xxd-4-17*8, yyb-12, 'orientation : '+cha);
   end;

procedure affiche;
   begin
      dessin (true, vue1) ;
   end;

procedure efface;
   begin
      dessin (false, vue2) ;
   end;

function  commande  : char;
   var
      a              : char;
      xdep, ydep,
      xmem, ymem,
      bidon          : integer;
      g, d, deplace  : boolean;

   begin
      xmem  :=  0;
      ymem  :=  0;

      MontrerSouris;
      repeat
         a  :=  ' ';

         if keypressed
         then begin
            a  :=  readkey;
         end else begin
            if UnBoutonSourisEnfonce
            then begin
               LirePositionSouris (xs, ys);
               a  :=  zone (xs, ys) ;
            end;
         end;

         case a of
            'a'   : begin
                        if      pas_r = 256 then pas_r  :=   64
                        else if pas_r =  64 then pas_r  :=   16
                        else if pas_r =  16 then pas_r  :=  256;

                        if axes_ecran then defrotations (pas_r)
                                      else defrotations_axes (pas_r) ;

                        delay (200) ;
                    end;

            chr(0): if readkey = chr (59)  then begin
                        aff_aide ('polydes.hlp', 1, 1) ;
                        delay (200) ;
                     end;
         end;
      until (a in
         ['2'..'6', '8', '9', '+', '-', '*', '/', 'q', 'f', 'p', 'F', 'i'] )
         or  (  (not fils_seuls)  and  (a in  ['m', 'c'] )  ) ;

      commande  :=  a;
      CacherSouris;
   end;

procedure termine_points;
   begin
      efface;
      nbpoints   :=   nbpoints + 1;

      freemem ( seismes_x,        nbpoints * sizeof (real)  ) ;
      freemem ( seismes_y,        nbpoints * sizeof (real)  ) ;
      freemem ( seismes_z,        nbpoints * sizeof (real)  ) ;
      freemem ( quatrieme_donnee, nbpoints * sizeof (real)  ) ;

      freemem ( reference.pts,  nbpoints * sizeof (points)  ) ;
      freemem ( vue1.pts,       nbpoints * sizeof (points)  ) ;
      freemem ( vue2.pts,       nbpoints * sizeof (points)  ) ;
   end;

procedure place (var l :lst_chn) ;
   begin
      if l <>nil
      then begin
         place (l^.elements) ;
         place (l^.suivant) ;
         dispose (l) ;
         l  :=  nil;
      end;
   end;

procedure termine;
   var
      b  : liste_de_boites;

   begin
      place (l_fic) ;

      while boites <>nil
      do begin
         b  :=  boites^.s;
         dispose (boites) ;
         boites  :=  b;
      end;

      restorecrtmode;
   end;

procedure debut_points;
   begin
      init_points;
      definit_reference;

      calcule;
      affiche;
      affiche_angles;
      dessine_triedre (1) ;
   end;

procedure tourne;
   var
      a          : char;
      d, g, ok   : boolean;
      n, i       : integer;
      s          : string;

   begin
      vue0  :=  vue1; vue1  :=  vue2; vue2  :=  vue0;

      repeat
         a  :=  commande;

         ok  :=  true;
         dessine_triedre (0) ;
         if not axes_ecran then defrotations_axes (pas_r) ;

         case a of
            '4'  : { rotation par rapport  l'axe vertical,  avant vers la gauche }
                  produitm (mz1, mr, mr) ;

            '6'  : { rotation par rapport  l'axe vertical,  avant vers la droite }
                  produitm (mz,  mr, mr) ;

            '8'  : { rotation par rapport  l'axe horizontal,  avant vers le haut }
                  produitm (mx1, mr, mr) ;

            '2'  : { rotation par rapport  l'axe horizontal,  avant vers le bas  }
                  produitm (mx,  mr, mr) ;

            '9'  : { rotation plane,  sens trigonometrique }
                  produitm (my1, mr, mr) ;

            '3'  : { rotation plane,  sens des aiguilles d'une montre }
                  produitm (my,  mr, mr) ;

            '5'  : { raz }
                  begin
                     mr      :=  mr0;
                     zoom    :=  1;
                     zoom_z  :=  1;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            '+'  : { zoom + }
                  begin
                     zoom    :=  zoom*1.1;
                     if zoom >zoom_max then zoom  :=  zoom_max;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            '-'  : { zoom - }
                  begin
                     zoom    :=  zoom*0.9;
                     if zoom <0.7 then zoom  :=  0.7;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            '*'  : { zoom z + }
                  begin
                     zoom_z  :=  zoom_z*1.1;
                     if zoom_z >zoom_z_max then zoom_z  :=  zoom_z_max;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            '/'  : { zoom z - }
                  begin
                     zoom_z  :=  zoom_z*0.9;
                     if zoom_z <0.1 then zoom_z  :=  0.1;
                     calcule_zooms_maxs;
                     affiche_zooms;
                     definit_reference;
                  end;

            'm'  : { selection de l'intervalle de quatrieme_donnee }
                  begin
                     modif_donnee;
                     select_donnee;
                  end;

            'f'  : { modification du point origine }
                  begin
                     modif_org;
                     definit_reference;
                  end;

            'F'  : begin
                     delay (200) ;
                     fic  := l_fic;
                     i    := 1;
                     while fic <>nil
                     do begin
                        creeliste (fic^.nom^, i) ;
                        inc (i) ;
                        fic  := fic^.suivant;
                     end;

                     utildivs.liste ('fichier de', 'donnes choisi  :', '', 16, s, n) ;

                     if n > 0
                     then begin
                        fic  := l_fic;
                        for i := 2 to n do fic := fic^.suivant;

                        termine_points;
                        debut_points;
                     end;

                     delay (100) ;
                  end;

            'c'  : begin
                     delay (200) ;
                     contours  :=  not contours;
                     ctr_ouinon;
                  end;

            'i'  : begin
                     delay (200) ;
                     axes_ecran  :=  not axes_ecran;
                     if axes_ecran then defrotations (pas_r) ;
                     axes_ecran_ouinon;
                  end;

            'p'  : begin
                     delay (200) ;

                     creeliste  ('modification',       1) ;
                     creeliste  ('chargement',         2) ;
                     creeliste  ('sauvegarde',         3) ;
                     creeliste  ('imp cran 24 aig',  4) ;
                     creeliste  ('imp cran  9 aig',  5) ;
                     utildivs.liste  ('',  'palettes  :',  '',  20,  s,  n) ;

                     case n of
                        1  : palette (pal) ;

                        2  : begin
                               dir ('choix de la palette', repbgi, nom_pal, filtre_pal, false) ;
                               if nom_pal <>'' then chargepalette (repbgi+nom_pal, nul) ;
                            end;

                        3  : begin
                               dir ('palette ou repertoire', repbgi, nom_pal, filtre_pal, false) ;

                               if nom_pal = ''
                               then begin
                                  delay (200) ;
                                  saisie ('nom de la palette', nom_pal, 8) ;
                                  if nom_pal  <>''
                                  then nom_pal  :=  nom_pal+'.pal';
                               end;

                               if nom_pal  <>''
                               then sauvepalette (repbgi+nom_pal, ok) ;
                            end;
                        4  : impvga_8c1;
                        5  : impvga_9c;
                     end;

                     delay (100) ;
                  end;

            'q'  : quitter  :=  true;

         else
            ok  :=  false;
         end;

         dessine_triedre (1) ;
      until ok;
   end;

BEGIN
   init;
   debut_points;
   tourne;

   while not quitter
   do begin
      calcule;
      efface;
      affiche;
      affiche_angles;
      tourne;
   end;

   termine_points;
   termine;
END.