UNIT COURBDES;

   {------------------------------------------------------------------------}
   { DESSIN       des courbes de niveau            commence       10/07/92 }
   {                                               rvise le      05/06/93 }
   {------------------------------------------------------------------------}
   { A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA }
   {------------------------------------------------------------------------}


   { AFFICHAGE D'UN NIVEAU DE COURBES.
     RECHERCHE  des tiquettes sur les courbes matresses.
     -----------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES

   dos,
   graph,                    { TP 70   - units standard Borland            }
   fctmath,                  { ARX     - fonctions mathmatiques            }
   Graphism,                 { ARX     - initialisations graphiques         }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   GraphSG,                  { ARX     - Symboles et Graduations            }
   COURBCAL;                 { ARX     - Calcul des courbes de niveau       }

{---------------------------------------------------------------------------}
TYPE
   surcord         = ^cordetiq;
   cordetiq        = record
                        a,                      { altitude }
                        x, y,                   { coordonnes deb }
                        f                       { angle }
                             : real;
                        suiv : surcord;
                     end;
VAR
   l_cordetiq      : surcord;                   { liste coord tiquettes    }

Procedure Dessine_une_courbe (alt      : real;
                              c        : surcourbe;
                              etic     : boolean);

    { dessine la courbe ALT  l'cran ou sur le traceur,
      Couleurs et trat courants.            }


Procedure Sauver_courbe      (alt      : real;
                              c        : surcourbe;
                              nomf     : pathstr;
                              blz      : boolean);
   { gnre un fichier au format BLN ou BLZ }

Procedure Charger_courbe     (alt      : real;
                              var nbpl : integer;
                              var c    : surcourbe;
                              var f    : text;
                              blz      : boolean;
                              var altc : real;
                              var finf : boolean );
   { charge un fichier au format BLN ou BLZ }

Procedure Rechercher_etiquettes (alt, dmin : real;
                                 c         : surcourbe);
   { Recherche les tiquettes des courbes matresses si ncessaire avec
      l'intervalle minimun dmin (mm).
      La taille et la police des caractres sont les mmes pour toute les
      courbes.
    Les coordonnes des tiquettes sont enregistres dans la liste
    L_cordetiq
   }

Procedure Sauver_etiquettes  (nomf     : dirstr);
   { Enregistre la liste courante des tiquettes dans un fichier texte
      x, y (carte)  direction (rad) altitude   }

Procedure Charger_etiquettes (nomf     : dirstr);
   { Affecte la liste depuis le fichier }

{---------------------------------------------------------------------------}

IMPLEMENTATION

   { --------- Calcul global de la position de chaque tiquette ----------- }
procedure ajoute_etiq_liste  (var l : surcord; a, x, y, f : real);
   var
      p_ct, el          : surcord;

   begin
      new (el);
      el^.a    := a;  { altitude     }
      el^.x    := x;  { coord centre }
      el^.y    := y;
      el^.f    := f;  { direction    }
      el^.suiv := nil;

      if l = nil
      then l := el
      else begin
         p_ct := l;
         while p_ct^.suiv <> nil
         do
            p_ct := p_ct^.suiv;
         p_ct^.suiv := el;
      end
   end;

procedure rechercher_etiquettes (alt, dmin : real;
                                 c         : surcourbe);
   var
      dmini                { distance mini entre tiquettes (repre carte) }
                        : real;
      p_sui, p_ct       : surcourbe;

   procedure rech_etiqs (br : surcourbe);
      var
         alts           : t12;
         nbpl,
         i, j
                        : integer;
         memedir,
         trouve,
         espace         : boolean;
         brx,  bry,                 { coord temp. }
         dist, distp,
         lgx,  lgx2,
         ax,   ay,
         dx,   dxp,
         dy,   dyp,
         dxy,
         alfa                       { inclinaison en  }
                        : real;
      begin
         str (round (alt), alts);
         lgx  := longueur_texte (alts)/xrap;
         lgx2 := sqr (lgx);
         { longeur tiquette en unit fentre }

         { laisse d'abord un espace minimum }
         i    := 1;
         nbpl := br^.nbp;
         while (i < nbpl)
         do begin
            espace := false;
            j      := i;
            dxp    := 0;
            dyp    := 0;
            distp  := 0;
            while not espace and (i < nbpl )
            do begin
               inc (i);
               ax     := c_x (br^.br, i) - c_x (br^.br, i-1);
               ay     := c_y (br^.br, i) - c_y (br^.br, i-1);
               dist   := sqrt (sqr (ax) + sqr (ay)) + distp;
               espace := dist >= dmini;
               distp  := dist;
            end;

            { recherche de la place trs grossirement
              dans la mme direction }
            trouve  := false;
            j       := i;
            dxy     := 0;
            memedir := true;
            while not trouve and (i < nbpl) and (dxy < lgx2*1.01)
            do begin
               inc (i);
               { fixecoul (15);
               deplaceen (c_x (br^.br, i), c_y(br^.br, i));}

               dx      := c_x (br^.br, i) - c_x (br^.br, j);
               dy      := c_y (br^.br, i) - c_y (br^.br, j);
               dxy     := sqr (dx) + sqr (dy);

               memedir := memedir and
                           (dx*dxp>=0) and (dy*dyp>=0)  and (dx*dy>=0);
               trouve  :=   ( dxy >= lgx2 )  and memedir;
               dxp     := dx;
               dyp     := dy;
            end;

            if trouve and espace
            then begin
               brx  := c_x (br^.br, j);
               bry  := c_y (br^.br, j);
               alfa := arctangente (dy, dx);

               { insertion tiquette centre }

               brx  := brx + lgx/2*cos (alfa);
               bry  := bry + lgx/2*sin (alfa);

               ajoute_etiq_liste (l_cordetiq, alt, brx, bry, alfa);
               change_etat (br^.br, j, i-1); { etat := false }
            end else begin
               i := j+1
            end ;
         end;
      end;

   begin                            { rechercher tiquettes  }
      dmini  := dmin / (xrap * coef_mm_unit);
      p_ct   := c;
      p_sui  := c;
      while p_ct <> nil
      do begin
         p_sui := p_ct^.suiv;
         rech_etiqs (p_ct);         { rech sur le brin }
         p_ct  := p_sui;
      end;
   end;

procedure Dessine_une_courbe (alt       : real;
                              c         : surcourbe;
                              etic      : boolean);
   var
      nbpl                            { nombre de points par brinS }
                        : integer;

   procedure dessiner_brins (br : surcourbe);
      var
         i              : integer;
         leve           : boolean;
         x0, y0,
         xi, yi         : real;

      begin
         x0 := c_x (br^.br, 1);
         y0 := c_y (br^.br, 1);
         deplaceenl (x0, y0);
         nbpl := br^.nbp;
         for i := 2 to nbpl
         do begin
            xi := c_x (br^.br, i);
            yi := c_y (br^.br, i);
            leve := not eta (br^.br, i-1);
            if etic and leve
            then
               deplaceenl (xi, yi)
            else
               tracevers (xi, yi);
         end;
      end;

   procedure dessiner_courbe_seule;
      var
         p_sui,
         p_ct           :  surcourbe;

      begin
         p_sui  := c;
         p_ct   := c;
         while p_ct <> nil
         do begin
            p_sui := p_ct^.suiv;
            dessiner_brins (p_ct);
            p_ct  := p_sui;
         end;
      end;

   begin                               { dessine une courbe }
      dessiner_courbe_seule;                { courbe sans tiquette }
   end;

procedure Sauver_courbe (alt : real;
                           c : surcourbe;
                        nomf : pathstr; blz : boolean);
   var
      f                 : text;
      p_ct, p_sui       : surcourbe;

   procedure sauver_brins ( br : surcourbe);
      var
         i, nbpl        : integer;
         a, b, c        : real;

      begin
         nbpl := br^.nbp;
         if nbpl < 1
         then
            exit; { tester nbpl }
         c    := alt;
         writeln (f, nbpl, c:10:2);
         for i := 1 to nbpl
         do begin
            a := c_x (br^.br, i);
            b := c_y (br^.br, i);
            if blz then writeln (f, a:10:2, b:10:2 , c:10:2)
                   else writeln (f, a:10:2, b:10:2 );
         end;
      end;

   begin                               { sauver courbe }
      assign  (f, nomf);
      append  (f);
      p_sui  := c;
      p_ct   := c;
      while p_ct <> nil
      do begin
         p_sui := p_ct^.suiv;
         sauver_brins (p_ct);
         p_ct  := p_sui;
      end;
     close (f);
   end;

procedure Charger_courbe (alt : real ; var nbpl : integer;
                          var c    : surcourbe;
                          var f    : text; blz : boolean;
                          var altc : real;
                          var finf : boolean );
   var
      p_ct, p_sui       : surcourbe;
      nbcrb             : integer;

   procedure charger_brins ( br : surcourbe; nbpl : integer );
      var
         i              : integer;
         a, b, c        : real;

         bri                { liste des coordonnes des points d'un brin }
                            : surbrin;

      begin
         for i := 1 to nbpl
         do begin
            if blz   then readln          (f,   a, b , c)
                     else readln          (f,   a, b );
            if i = 1 then ini_brin        (bri, a, b)
                     else ajoute_pt_queue (bri, a, b);
         end;
         ajoute_brins  (br, bri);
         br^.nbp := nbpl;
      end;

   begin
      p_sui   := c;
      p_ct    := c;
      altc    := alt;
      nbcrb   := 1;
      repeat
         p_sui   := p_ct^.suiv;
         if nbpl > 0
         then
            charger_brins (p_ct, nbpl);
         if nbcrb = 1
         then
            c := p_ct;
         inc (nbcrb);
         finf := eof (f);
         if not finf
         then begin
            init_courbe (p_ct^.suiv);
            p_ct      := p_ct^.suiv;
            readln (f, nbpl, altc);
         end;
      until (altc <> alt) or eof (f);
   end;

Procedure sauver_etiquettes (nomf : dirstr);
   { Enregistre la liste courante des tiquettes dans un fichier texte
      x, y (carte)  direction (rad) altitude   }
   var
      p_ct              : surcord;
      f                 : text;

   begin
      p_ct   := l_cordetiq;
      assign  (f, nomf);
      rewrite (f);
      writeln (f, '; x,      y,       direction,   alt');
      while p_ct <> nil
      do begin
         writeln (f, p_ct^.x:6:1,' ', p_ct^.y:6:1,' ', p_ct^.f:9:6,' ', p_ct^.a:6:0);
         p_ct := p_ct^.suiv;
      end;
      close (f);
   end;

Procedure charger_etiquettes (nomf : dirstr);
   { Affecte la liste depuis le fichier }
   var
      chain             : t30;
      fic               : text;
      x, y, f, a        : real;

   begin
      assign (fic, nomf);
      reset  (fic);
      readln (fic, chain);
      while not eof (fic)
      do begin
         readln (fic, x, y, f, a );
         ajoute_etiq_liste (l_cordetiq, a, x, y, f);
      end;
      close  (fic);
   end;


END.

{ GEOCEAN - Courbdes -------------------------------- INRP - TOULOUSE - ARX }
