UNIT FICHIERS;

   {------------------------------------------------------------------------}
   {      bibliothque                                                      }
   {                       GESTION DES ERREURS                              }
   {                       GESTION DES FICHIERS                             }
   {                                                            26/09/94    }
   {------------------------------------------------------------------------}
   (*

   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }

   Gestion des erreurs d'entres sortie et des erreurs d'excution
   Pour dbogger, dsactiver ExitProc:=@TrapRunTimeError;

   Gestion des erreurs entrees sortie :
   --> IOERROR :  Ce Word (variable globale) sert  rcuprer
                   le rsultat de la fonction Turbo Pascal IOResult;

     Si IOError <> 0 il y a une erreur qui peur tre traite par la
     fonction GereErreur.

   --> GereErreur : fonction de gestion des erreurs

     Protocole  INRP modifi ARX
         Si l'erreur est fatale, ARRETER le programme proprement
         Sinon
              soit Message d'erreur
                  - d'information
                  - soit proposition d'action  l'utilisateur (ESC/RETURN);
         Dans tous les cas IOError n'est pas modifi

     Donc en sortie de la fonction GereErreur :
     - un boolean false est renvoy si l'erreur n'a pas pu tre annule ;
     - un boolean true si l'erreur est traite ; la procdure fautive
       doit alors ritrer la commande qui a provoqu une erreur.

    Deux variables et une procdure permettent de grer les erreurs de faon
    plus souple :
     --> InitErreur  qui initialise SortieRapide  false et CompteErreur  0.
     --> CompteErreur : Byte global initialis  0 par InitErreur.
     --> SortieRapide : Boolean global initialis  false par InitErreur;
               SortieRapide permet par exemple de quitter les boucles
               d'Entre/Sortie en cas d'erreur rpte deux fois
               ou si GereErreur n'a pas pu traiter l'erreur...

   Pour grer correctement les erreurs, le programme doit, avant chacune
   des procdure d'entre/sortie, d'impression, de lecture sur les ports
   srie :
     Initialiser les Variables d'erreur (procedure INITERREUR;)
     Compiler les procdure d'entre/sortie ( Reset, Rewrite, Read(F,V),...)
              avec l'option {I-} ... {I+}
     Mettre  jour et tester IOERROR  (IOERROR := IOResult)
     Rcuprer le boolean renvoy par GereErreur si (IOERROR <> 0)
   ----------------------------------------------------------------------- *)

INTERFACE

{$O+,F+}

USES
   DOS,
   CRT,
   GRAPH,                    { TP 70   - units standard Borland            }
   UTILDIVS,                 { ARX     - utilitaires divers                 }
   Messarx;                  { ARX     - Textes des Messages de Base        }

VAR
   repdos,                     { rpertoire systme                         }
   reptemp                     { rpertoire fichiers temporaires            }
                         : pathstr;

   liste_disques               { units connectes                          }
                         : set of byte;

   ExitSauve             : Pointer;

   IOError               : Word;
                               { rsultat non nul si erreur d'entre sortie }

   SortieRapide          : boolean;
                               { True si sortie aprs erreurs               }

   Nombre_Disques,
   CompteErreur          : byte;
                               { compteur d'erreurs                         }

{------------------ E/S contrles -----------------------------------------}
Function dk_present          (path          : pathstr)          : boolean;
   { teste la prsence effective de l'unit disquette dans le chemin D      }

Function testdisk            (u             : pathstr)          : boolean;
   { si u contient une rfrence d'unit alors on teste sa prsence.        }

Function disque_rw           (num : byte) : boolean;
   { paramtre : numro du disque , A : 1, B : 2 ... rend V si RW           }

Function NatureDisque        (num : byte) : byte;
   { paramtre : numro du disque , A : 1, B : 2 ...
     renvoie 0 si disque local, 1 si distant, 2 si subst, 10 si inexistant  }

Function detect_unite        (U             : integer)          : boolean;
   { teste la prsence de l'unit U    (mme sans disquette prsente)       }
   { et revient dans le rpertoire courant                                  }

Procedure InitErreur;
   {  appeler avant toute entre sortie                                    }

Procedure EraseErr           (var F         : File ;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { Efface Fichier sans type                                               }

Procedure WritelnErr         (var F         : Text ;
                              Chaine, Msg   : Chainecar;
                              var ok        : boolean);
   { Ecrit une ligne dans un fichier texte                                  }

Procedure WriteErr           (var F         : text ;
                              Chaine, Msg   : Chainecar;
                              var ok        : boolean);
   { Ecrit une chaine dans un fichier texte                                 }

Procedure WriteIntegerErr    (var F         : text ;
                              N             : integer;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { Ecrit un entier dans un fichier texte                                  }

Procedure BlockWriteErr      (var ToF       : file;
                              var Buf;
                              NumRead       : word;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { Ecrit un bloc dans un fichier sans type }

Procedure RewriteErr         (var F         : file;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { OUVRE en criture un NOUVEAU fichier sans type                         }

Procedure RewriteTxtErr      (var F         : Text;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { OUVRE en criture un NOUVEAU texte                                     }

Procedure RewriteBErr
                             (var F         : file;
                              T             : word;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { OUVRE en criture un NOUVEAU fichier sans type , T = taille du bloc    }

Procedure ResetErr           (var F         : file;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { OUVRE en criture un fichier sans type                                 }

Procedure ResetTxtErr        (var F         : text;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { OUVRE en criture un fichier Texte                                     }

Procedure ResetBErr          (var F         : file;
                              t             : word;
                              Msg           : Chainecar;
                              var ok        : boolean);
   { OUVRE en criture un fichier sans type , T = taille du bloc            }

Procedure Mkdir_err          (chemin        : Pathstr;
                              Msg           : Chainecar;
                              var ok        : Boolean);
   { CREE un rpertoire                                                     }

{Function GereErreur (MsgE : string) : boolean;}
   { Gestion des erreurs DOS et Turbo Entrees/Sortie                        }

{--------------------------- Gestion des fichiers --------------------------}

Function placedisque         (u             : Pathstr)          : longint;
   { rend la place libre sur un disque dans le rpertoire courant }

Function Exists              (nomf          : Pathstr)          : Boolean;
   { Passer un nom de fichier complet ; renvoie faux si fichier non trouv  }

Function Exist_rep           (nomf          : PathStr)          : Boolean;
   { Passer un nom de rpertoire complet ; renvoie faux si rep  non trouv  }

Function Ouvftexte           (nomf          : Pathstr ;
                              var ft        : Text)             : boolean;
   { ouvre un fichier de type Text en lecture, rsultat true si Ok          }
   { recherche uniquement dans le chemin spcifi sans tenir compte de la
     commande APPEND                                                        }

{---------------------------------------------------------------------------}
Procedure cree_fichier       (nomf          : Pathstr);
   { cre un nouveau fichier en criture                                    }

Function file_RW             (nomf          : Pathstr)          : boolean;
   { }

Function ftxt_present        (nomf          : Pathstr)          : boolean;
   { contrle de prsence d'un fichier texte;
     nomf= nom complet ch+nom+ext                                           }
   { tient ventuellement compte de la commande APPEND                      }

Procedure lesdisques;
   { construit la liste_disques des units connectes                       }

Function  extension          (nomf          : Pathstr)          : extstr;
   { }

Function  sansext            (nomf          : Pathstr)          : namestr;
   { }

Procedure complete           (var s         : Pathstr);
   { ajoute \ pour complter le nom d'un rpertoire                         }

Procedure enleve_AntiSlash   (var s         : Pathstr);
   { enlve \ au nom d'un rpertoire                                        }

Procedure CopyFile           (nomf1, nomf2  : Pathstr;
                              var ok        : Boolean);
    { copie nomf1 vers nomf2 sans test d'crasement                         }

Procedure Eff_Fic            (nomf          : Pathstr;
                              var ok        : boolean);
    { sans confirmation ni test : le fichier existe  priori                }

Procedure EffaceFichier      (nomf          : Pathstr ;
                              var ok        : boolean);
    { sans confirmation ; ok = le fichier a t trouv                      }

{Procedure EraseFile     (nomf : Pathstr; ok : boolean);}
    { demande confirmation en mode texte                                    }

Procedure dir                (comm          : Chainecar;
                              var chemin    : Dirstr;
                              var nomf      : T12;
                              filtre        : T12;
                              ficseul       : Boolean);
   { rend un nom complet de fichier (unit/chemin/nom/extension).           }
   { le choix est effectu dans une bote  dfilement.                     }
   { comm    = commentaire;                                                 }
   { filtre  = filtre sur les noms;                                         }
   { ficseul = exclusion des rpertoires.                                   }

Function  numeromaxi         (path          : Pathstr)          : integer;
   { rend le nombre de fichiers correspondant  PATH                        }

Procedure effacer_fichiers   (path          : Pathstr ;
                              var nbf       : Integer);
   { efface tous les fichiers du rpertoire PATH sans confirmation          }

Procedure copier_fichiers    (paths, pathb  : Pathstr;
                              var nbf       : Integer);
   { copie tous les fichiers PATHS dans pathb sans confirmation             }

Procedure copier_fichiers_max  (paths, pathb : Pathstr;
                                var tmax     : longint;
                                nbi          : integer;
                                var nbf      : integer);
   { copie dans la limite tmax octets ; nbi = premier fichier  copier ;
                                        nbf = nb de fichiers copis        }

Function  volume_fichiers    (path          : Pathstr)          : longint;
   { rend la taille totale des fichiers slectionns                        }

Function  nomfichier_seul_ok (nomfc         : Pathstr)          : boolean;
   { rend  V si pas d'extension                                             }

Procedure extraire_fichiers_zip
                             (chpk, nomfz,
                              opts, listef,
                              chemf         : Pathstr;
                              var ok        : Boolean);
   { peut ne pas dclencher erreur dos en cas de mmoire insuffisante }

   { chpk   : chemin prg pkunzip ;
     nomfz  : chemin et nom fic compress ;
     listef : liste des fichiers  extraire (nom de fichier simple)
     chemf  : chemin destination                                            }

Procedure vider_buffers      (var ok        : boolean);
   { excute c:\dos\system\Smartdrive /c                                    }

{---------------------------------------------------------------------------}

IMPLEMENTATION

CONST
   MaxErrES             =  7;
   MaxErrDos1           = 36;
   MaxErrDos2           =  8;
   MaxerrCrit           = 12;

VAR
   ok                   : Boolean;

function TabErrESortie       (Code : byte) : Chainecar;
   begin
      case Code of
         0 : TabErrESortie := err0;
         1 : TabErrESortie := err1;
         2 : TabErrESortie := err2;
         3 : TabErrESortie := err3;
         4 : TabErrESortie := err4;
         5 : TabErrESortie := err5;
         6 : TabErrESortie := err6;
         7 : TabErrESortie := ' ';
      end;
   end;

function TabErrMSDOS1        (Code : byte)                      : Chainecar;
   begin
      case Code of
          0 : TabErrMSDOS1 := '';
          1 : TabErrMSDOS1 := errd1;
          2 : TabErrMSDOS1 := errd2;
          3 : TabErrMSDOS1 := errd3;
          4 : TabErrMSDOS1 := errd4;
          5 : TabErrMSDOS1 := errd5;
          6 : TabErrMSDOS1 := errd6;
          7 : TabErrMSDOS1 := errd7;
          8 : TabErrMSDOS1 := errd8;
          9 : TabErrMSDOS1 := errd9;
         10 : TabErrMSDOS1 := errd10;
         11 : TabErrMSDOS1 := errd11;
         12 : TabErrMSDOS1 := errd12;
         13 : TabErrMSDOS1 := errd13;
         14 : TabErrMSDOS1 := errd14;
         15 : TabErrMSDOS1 := errd15;
         16 : TabErrMSDOS1 := errd16;
         17 : TabErrMSDOS1 := errd17;
         18 : TabErrMSDOS1 := errd18;
         19 : TabErrMSDOS1 := errd19;
         20 : TabErrMSDOS1 := errd20;
         21 : TabErrMSDOS1 := errd21;
         22 : TabErrMSDOS1 := errd22;
         23 : TabErrMSDOS1 := errd23;
         24 : TabErrMSDOS1 := errd24;
         25 : TabErrMSDOS1 := errd25;
         26 : TabErrMSDOS1 := errd26;
         27 : TabErrMSDOS1 := errd27;
         28 : TabErrMSDOS1 := errd28;
         29 : TabErrMSDOS1 := errd29;
         30 : TabErrMSDOS1 := errd30;
         31 : TabErrMSDOS1 := errd31;
         32 : TabErrMSDOS1 := errd32;
         33 : TabErrMSDOS1 := errd33;
         34 : TabErrMSDOS1 := errd34;
         35 : TabErrMSDOS1 := errd35;
         36 : TabErrMSDOS1 := errd36;
      end;
   end;
   { les autres erreurs sont soit rserves soit destines aux rseaux  }

function TabErrMSDOS2        (Code          : byte)             : Chainecar;
   begin
      case Code of
         0 : TabErrMSDOS2 := errd2_0;                    { 80 }
         1 : TabErrMSDOS2 := errd2_1;
         2 : TabErrMSDOS2 := errd2_2;
         3 : TabErrMSDOS2 := errd2_3;
         4 : TabErrMSDOS2 := errd2_4;
         5 : TabErrMSDOS2 := errd2_5;
         6 : TabErrMSDOS2 := errd2_6;
         7 : TabErrMSDOS2 := errd2_7;
         8 : TabErrMSDOS2 := errd2_8;
      end;
   end;

function TabErrCritique      (Code          : byte)             : Chainecar;
   begin
      case Code of
         0 : TabErrCritique := errc0;            { 150 }
         1 : TabErrCritique := errc1;
         2 : TabErrCritique := errc2;
         3 : TabErrCritique := errc3;
         4 : TabErrCritique := errc4;
         5 : TabErrCritique := errc5;
         6 : TabErrCritique := errc6;      { position des ttes SEEK }
         7 : TabErrCritique := errc7;      { support magntique      }
         8 : TabErrCritique := errc8;
         9 : TabErrCritique := errc9;
        10 : TabErrCritique := errc10;
        11 : TabErrCritique := errc11;
        12 : TabErrCritique := errc12;
      end;
   end;

(****************** a suivre ***************
{F+} Procedure ExitErreur; {F-}
Begin
   if ExitCode = 300 then QuitGraphique;
   ExitProc := ExitSauve;
End;
******************************************)

procedure QuitGraphique;
   Begin
      RestoreCRTMode;
   End;

procedure InitErreur;
   { Initialisation des variables globales de gestion d'erreur }
   Begin
     SortieRapide := false;
     CompteErreur := 0;
   End;

function ClasseErreurMSDos   (Var Messag    : Chainecar)        : Byte;
   Var
      Reg               : Registers;

   begin
      With Reg do
      begin
         AH := $59;  { Gestion des erreurs par fonction 59hexa}
         BX := 0;
         MSDOS(Reg);

         Case BH of
             1 : Messag := Messag + ' '+errm1;
             2 : Messag := Messag + ' '; { situation temporaire }
             3 : Messag := Messag + ' '+errm3;
             4 : Messag := Messag + ' '+errm4;
             5 : Messag := Messag + ' '+errm5;
             6 : Messag := Messag + ' '+errm6;
             7 : Messag := Messag + ' '+errm7;
             8 : Messag := Messag +' ' +errm8;
             9 : Messag := Messag + ' '+errm9;
            10 : Messag := Messag + ' '+errm10;
            11 : Messag := Messag + ' '+errm11;
            12 : Messag := Messag + ' '+errm12;
            else
                 Messag := Messag + ' '+errm13; { Erreur non classable}
         end;

         Case CH of
             2 : Messag := Messag + ' '+errm14;
             3 : Messag := Messag + ' '+errm15;
             4 : Messag := Messag + ' '+errm16;
             5 : Messag := Messag + ' '+errm17;
         end;
         { --------------- CODE LOCALISATION D'ERREUR -----------------
         1 : Inconnue
         2 : Priphrique gr par bloc (Disque)
         3 : Rseau local
         4 : Priphrique srie (caractre)
         5 : Mmoire
         -------------------------------------------------------------}
         ClasseErreurMSDos := BL;
      end;
   end;

function GereErreurDos       (Msg : Chainecar ; NoErr : Word) : boolean;
   { En fonction du type d'erreur MSDOS
     un message ad hoc est affich, IOERROR est annul
     ou bien le programme est ARRETE par HALT             }
   Var
      CodeAction        : byte;
      Messag            : Chainecar;

   Begin
      If (NoErr <= MaxerrDos1)
      then Messag := TabErrMSDos1 (Byte (NoErr))
      else
         if (NoErr>=80) and (NoErr<=88)
         then Messag := TabErrMSDos2 (Byte (NoErr - 80))
         else Messag := ' '+m_not_connu+' ' ;

      CodeAction := ClasseErreurMSDos (Messag);
        {--------------------     CODE D'ACTION      -------------------
        1 : Nouvelle tentative ;
        2 : Nouvelle tentative aprs dlai
        3 : Demander  l'utilisateur de recommencer;
        4 : (ARRET DU PROGRAMME)
        5 : (ARRET D'URGENCE DU PROGRAMME)
        6 : Ignorer l'erreur;
        7 : Nouvel essai aprs intervention utilisateur;
        ------------------------------------------------------------------}
      if (CodeAction in [1, 2, 3, 6, 7])
      then begin
         Tilt;
{         if (CodeAction = 3) or (CodeAction = 7)
         then Message3 (Msg,  Messag, MsgInrp)
         else}
          Message3 (Msg , Messag, MsgInrp);
         IOError := 0;
      end else begin
         Tilt; Tilt;
         Message3 (Msg , Messag, MsgInrp {' ARRET DU PROGRAMME'});
         { ##################################### }
              QuitGraphique;
              HALT (NoErr);  { code de retour special maison}
         { ##################################### }
      end;
      GereErreurDos := false  {true} ;
   End;

function GereErreurESortie   (Msg : Chainecar; NoErr : Word): boolean;
   Var
      Messag            : Chainecar;

   Begin
      Messag     := TabErrESortie (IOERROR - 100);
      Tilt;
      Case NoErr of
         100 : Message3 (Msg, Messag, err100);
         101 : Message3 (Msg, Messag, err101);
         106 : Message3 ('',  Messag, err106);
         else Message (Msg);
      end;
      GereErreurESortie := true;
   End;

function GereErreurCritique  (Msg : Chainecar ; NoErr : Word) : boolean;
   Var
      Messag            : chainecar;

   Begin
      Messag := TabErrCritique ((NoErr - 150));
      Tilt;
      Case NoErr of
         150 : Message3 (Msg, Messag, ' '+err150);
         152 : Message3 (Msg, Messag, ' '+err152);
         159 : Message3 (Msg, Messag, ' '+err159);
         160 : Message3 (Msg, Messag, '');
         else Message3 ('', Msg, '');
      end;
      GereErreurCritique := true ;
   End;

function GereErreur          (MsgE : Chainecar) : boolean;
   (* Gestion des erreurs DOS et Turbo Entrees/Sortie *)
   (* IOERROR est une variable globale *)
   Var
      CodeSortie        : boolean;

   Begin
      CodeSortie := false;
      Case IOERROR of
                0 :  CodeSortie := true;
           1.. 99 :  CodeSortie := GereErreurDos      (MsgE, IOError);
         100..106 :  CodeSortie := GereErreurESortie  (MsgE, IOError);
         150..162 :  CodeSortie := GereErreurCritique (MsgE, IOError);
         else Message3 (MsgE, TabErrESortie (MaxErrES), MsgInrp);
      End; (* Case *)
      GereErreur := CodeSortie;
   End;

procedure TestIOError        (Msg : chainecar);
   Begin
      IOERROR := IOResult;
      If (IOERROR <> 0)
      then begin
         SortieRapide := (Not GereErreur (Msg)) or (CompteErreur>=1);
         Inc (CompteErreur);
      end;
   End;

procedure EraseErr           (var F : File; Msg : chainecar; var ok : boolean);
   Begin
      InitErreur;
      Repeat
         {$I-} Erase  (F); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   End;

procedure WritelnErr         (var F : Text; Chaine, Msg : chainecar; var ok : boolean);
   Begin
      InitErreur;
      Repeat
         {$I-} Writeln (F, Chaine); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   End;

procedure WriteErr           (var F : text; Chaine, Msg : chainecar; var ok : boolean);
   Begin
      InitErreur;
      Repeat
         {$I-} Write (F, Chaine); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   End;

procedure WriteIntegerErr    (var F : text; N : integer ; Msg : chainecar ; var ok : boolean);
   Begin
      InitErreur;
      Repeat
         {$I-} Write (F, N); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   End;

procedure BlockWriteErr      (var ToF : file; var Buf ; NumRead : word; Msg : chainecar; var ok : boolean);
   begin
      InitErreur;
      Repeat
         {$I-} BlockWrite (ToF,   Buf, NumRead); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

procedure RewriteErr         (var F : file; Msg : chainecar; var ok : boolean);
   begin
      InitErreur;
      Repeat
         {$I-} Rewrite (F); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

Procedure RewriteTxtErr      (var F : Text;        Msg : chainecar; var ok : boolean);
   begin
      InitErreur;
      Repeat
         {$I-} Rewrite (F); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

procedure RewriteBErr        (var F : file; T : word; Msg : chainecar; var ok : boolean);
   begin
      InitErreur;
      Repeat
         {$I-} Rewrite (F, T); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

procedure ResetErr           (var F : file; Msg : chainecar; var ok : boolean);
   begin
      InitErreur;
      Repeat
         {$I-} Reset (F); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

procedure ResetTxtErr        (var F : text; Msg : chainecar; var ok : boolean);
   begin
      InitErreur;
      Repeat
         {$I-} Reset (F); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

procedure ResetBErr          (var F : file ; t : word ; Msg : chainecar; var ok : boolean);
   begin
      InitErreur;
      Repeat
         {$I-} Reset (F, T); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

procedure Mkdir_Err          (chemin : Pathstr ; Msg : chainecar; var ok : Boolean);
   begin
      InitErreur;
      Repeat
         {$I-} mkdir (chemin); {$I+}
         TestIOError (Msg);
      Until (IOError=0) or SortieRapide;
      Ok := not SortieRapide;
   end;

{   -------------------- Gestion des fichiers --------------------------    }

function Exists              (nomf : Pathstr) : Boolean;
   var
      SR                : SearchRec;

   begin
      FindFirst (nomf, ReadOnly + Hidden + SysFile, SR);
      Exists := (DosError = 0) and (Pos ('?', nomf) = 0)
                               and (Pos ('*', nomf) = 0);
   end; { Exists }

function Exist_rep           (nomf : PathStr) : Boolean;
   var
      SR                : SearchRec;

   begin
      FindFirst (nomf, ReadOnly + Hidden + directory, SR);
      Exist_rep := (DosError = 0) and (Pos ('?', nomf) = 0)
                                  and (Pos ('*', nomf) = 0);
   end; { Exist_rep }

{--------------------- ouverture en lecture -----------------------}

function Ouvftexte           (Nomf : Pathstr; var ft : Text) : boolean;
   { ouvre un fichier de type Text en lecture, rsultat true si Ok }
   { IOERROR : word; variable globale }
   { CompteurErreur et SortieRapide aussi }
   var
      ok                : boolean;

   Begin
{      InitErreur;     }
      Assign (ft, nomf);
 (*     Repeat
         {$I-} Reset (ft); {$I+}
         IOERROR := IOResult;
         If (IOERROR <> 0)
         then begin
            SortieRapide := (Not GereErreur (NFic)) or (CompteErreur>=1);
            Inc (CompteErreur);
         end;
      Until (IOError=0) or SortieRapide;
      Ouvftexte := Not SortieRapide;
*)
      resetTxtErr ( ft, nomf, ok);
      Ouvftexte := ok;
   End;

(*      {-------------- LECTURE DE FICHIER BLINDEE -----------------}
      InitErreur;
      I := 0;
      Repeat
           {$I-} Read(fn,hist[i]);{$I+};
           IOERROR:=IOresult;
           if IOERROR <> 0
              then
              begin
                 SortieRapide := (Not GereErreur(nficim+exthisto))
                                 or (CompteErreur>=2);
                 Inc(CompteErreur);
              end
              else Inc(i);
      Until (i>255) or SortieRapide;
      {------------------------------------------------------------}

      {-------------- ECRITURE DE FICHIER BLINDEE -----------------}
      InitErreur;
      Repeat
           {$I-} Write(fn, n);{$I+};
           IOERROR:=IOresult;
           if IOERROR <> 0
              then
              begin
                 SortieRapide := (Not GereErreur(nf))
                                 or (CompteErreur>=2);
                 Inc(CompteErreur);
              end
              else Inc(i);
      Until (IOError=0) or SortieRapide;
      {------------------------------------------------------------}*)

procedure Str_Hex            (n : longInt ; var s : string);
   { convertit un entier long en chaine de chiffres hexa }
   Var
      neg               : boolean;
      Hexa              : string;

   Begin
      Hexa := '0123456789ABCDEF';
      s    := '';
      neg  := n < 0;
      If neg then n := -n;
      If n= 0 then s := '0'
      else
         While n <> 0
         do begin
            s := hexa [n mod 16 + 1] + s;
            n := n div 16;
         end;
      if neg then s := '-' + s;
      repeat
         if length (s) < 4 then s := '0'+s;
      until length (s) = 4;
   End;

{$F+}
procedure TrapRunTimeError;
{$F-}
   var
      s3                : string [3];
      s1, s2            : chainecar;
      c                 : char;

   begin
      if ExitCode <> 0
      then begin
         Str (ExitCode:3, s3);
         Str_Hex (longInt (Seg (ErrorAddr^)), s1);
         Str_Hex (longInt (Ofs (ErrorAddr^)), s2);
         Filemode := 0;
         settextstyle (0, 0, 1);
         Filemode := 2;
         Tilt; Tilt;
         Message3 ('Err. N'+' '+s3, ' adr. '+s1+s2, MsgInrp);
         ErrorAddr := nil;
         QuitGraphique;
      end;
      ExitProc := ExitSauve;
   end;

{--------------------- Gestion des fichiers --------------------------------}

procedure cree_fichier  (nomf : Pathstr);
   var
      f                 : text;

   begin
      assign  (f, nomf);
      rewrite (f);
      close   (f);
   end;

function ftxt_present        (nomf : Pathstr) : boolean;
   var
      ok                : boolean;
      f                 : text;

   begin
      ok := false;
      if nomf <> ''
      then begin
         assign   (f, nomf);
         {$I-} reset (f); {$I+}
         if ioresult <> 0
         then
            ok := false
         else begin
            ok := true;
            close (f)
         end;
      end;
      ftxt_present := ok
   end;

function file_RW             (nomf : Pathstr) : boolean;
   var
      ok                : boolean;
      f                 : file;

   begin
      ok := false;
      if nomf <> ''
      then begin
         assign   (f, nomf);
         {$I-} rewrite (f); {$I+}
         if ioresult <> 0
         then
            ok := false
         else begin
            ok := true;
            close (f);
            erase (f);
         end;
      end;
      file_rw := ok
   end;

function  sansext            (nomf : Pathstr) : namestr;
   var
      nom8           : namestr;
      p              : byte;

   begin
      p := Pos('.', nomf);
      if p = 0
      then
         nom8 := nomf
      else
         nom8 := Copy (nomf, 1, p-1);
      sansext := nom8;
   end;

function  extension          (nomf : Pathstr) : extstr;
   var
      l, p              : integer;

   begin
      l := length (nomf);
      p := Pos('.', nomf);
      if p = 0
      then
         extension := ''
      else
         extension := maj (Copy (nomf, p, l-p+1));
   end;

procedure complete           (var s : Pathstr);
   begin
      if (s <> '') and (s [length (s)] <> '\')
      then
          s := s+'\';
   end;

procedure enleve_AntiSlash   (var s : Pathstr);
   var
      l                 : word;

   begin
      l := length (s);
      if (s [l] = '\')
      then
         s := copy (s, 1, l-1);
   end;

procedure CopyFile           (nomf1, nomf2 : pathstr; var ok : boolean);
   var
      FromF, ToF        : file;
      NumRead,
      NumWritten        : Word;
      Buf               : array [1..2048] of Char;
      ok1, ok2          : boolean;

   begin
      ok  := false;
      ok1 := false;
      ok2 := false;
      filemode := 0;
      Assign      (FromF, nomf1); { Open input file }
      ResetBErr   (FromF, 1, Nomf1, ok1);     { Record size = 1 }
      filemode := 2;
{      if not ok1
         then close (FromF)
         else ok1 := true;}

      if ok1
      then begin
         Assign      (ToF,   nomf2); { Open output file }
         RewriteBErr (ToF,   1, Nomf2, ok2);     { Record size = 1 }
      end;

      if ok1 and ok2
      then begin
         repeat
            BlockRead  (FromF, Buf, SizeOf (Buf), NumRead);
            BlockWriteErr (ToF, Buf, NumRead, NomF2, ok);
         until (NumRead = 0) or SortieRapide;
         Close   (FromF);
         Close   (ToF);
      end;
   end;

procedure Eff_Fic            (nomf : Pathstr; var ok : boolean);
   var
      F                 :  file;

   begin
      Assign (F, nomf);
      EraseErr (F, nomf, ok);
   end;

procedure EffaceFichier      (nomf : Pathstr; var ok : boolean);
   { sans confirmation ; ok = fichier existait }
   var
      F                 : file;

   begin
      Assign (F, nomf);
      ResetErr   (F, Nomf, ok);
      if ok
      then begin
         Close  (F);
         EraseErr (F, nomf, ok);
      end;
   end;

procedure EraseFile          (nomf : Pathstr; ok : boolean);
   { demande confirmation en mode texte }
   var
      F                 : file;
      Ch                : Char;

   begin
      Assign (F, nomf);
      {$I-}  Reset  (F);  {$I+}
      if ioresult <>0
      then  begin
         writeln (nomf+' '+mt_not_trouve);
         ok := false;
      end else begin
         Close  (F);
         Write  (mt_efface+' ', nomf, ' ?');
         Readln (Ch);
         if UpCase (CH) = 'O'
         then
            Erase  (F);
         ok := true;
      end;
   end;

function dk_present          (path : pathstr) : boolean;
   VAR
      F                 : SearchRec;
      fic               : file;

   BEGIN
      path := path+'*.*';
      FindFirst (Path, anyfile, F);
      dk_present := (dosError < 150);
   END;

function placedisque         (u : Pathstr) : longint;
   begin
      placedisque := diskfree (ord (upcase (u [1]))-64);
   end;

function testdisk            (u : Pathstr) : boolean;
   { si u contient une rfrence d'unit alors on teste sa prsence.     }
   begin
      testdisk :=    (u [2] <> ':') or
                     (disksize (ord (upcase (u [1]))-64) >= 0);
   end;

function disque_rw           (num : byte) : boolean;
   { paramtre : numro du disque , A : 1, B : 2 ... rend V si RW           }
   var
       p                : pathstr;

   begin
       p := chr (num+64) + ':\'+tempo_txt;
       disque_rw := file_rw (p );
   end;

function natureDisque (num : byte) : byte;
   var
      regs              : registers;

   begin
      regs.ah := $44;
      regs.al := $09;
      regs.bl := num;
      intr ($21,regs);
      if ((regs.flags and 1) = 1)
      then
         naturedisque := 10                          { disque inexistant }
      else
         if ((regs.dx and $1000) = 0)
         then


            if ((regs.dx and $8000) = 0)
            then
                naturedisque := 0                      { disque local     }
            else
               naturedisque := 2                      { disque substitu }
         else
            naturedisque := 1;                        { disque distant   }
   end;

function detect_unite        (U : integer ) : boolean;
   { teste la prsence de l'unit U               }
   { et revient dans le rpertoire courant        }

   var
      S,  s0            : Pathstr;

   begin
      getdir (0, s0);             { s0 = rpertoire courant }
      S :=  chr (U+64) + ':';
      {$I-}  chdir ( S );  {$I+}
      if ioresult = 0
      then begin
         chdir ( s0 );
         detect_unite := true
      end else
         detect_unite := false;
   end;

procedure lesdisques;
   var
      tb                : array ['A'..'Z']
                             of set of byte;
      n_d,
      numero            : byte;

   begin
      tb ['A'] :=  [1];   tb ['B'] :=  [2] ;   tb ['C'] :=  [3];
      tb ['D'] :=  [4];   tb ['E'] :=  [5] ;   tb ['F'] :=  [6];
      tb ['G'] :=  [7];   tb ['H'] :=  [8] ;   tb ['I'] :=  [9];
      tb ['J'] := [10];   tb ['K'] := [11] ;   tb ['L'] := [12];
      tb ['M'] := [13];   tb ['N'] := [14] ;   tb ['O'] := [15];
      tb ['P'] := [16];   tb ['Q'] := [17] ;   tb ['R'] := [18];
      tb ['S'] := [19];   tb ['T'] := [20] ;   tb ['U'] := [21];
      tb ['V'] := [22];   tb ['W'] := [23] ;   tb ['X'] := [24];
      tb ['Y'] := [25];   tb ['Z'] := [26] ;
      liste_disques := [];
      nombre_disques := 0;
      for numero := 1 to 26 do
      begin
        { if detect_unite ( numero )}
         n_d := naturedisque (numero);
         if (n_d >= 0) and (n_d < 3)
         then begin { construire liste des units connectes }
            inc (Nombre_Disques);
            liste_disques := liste_disques + tb [chr (numero+64)]
         end;
      end;
   end;

procedure dir (comm       : Chainecar;
               var chemin : Dirstr;
               var nomf   : T12;
               filtre     : T12;
               ficseul    : Boolean );
      {$I-S-}
      {$M 8192,8192,655360}
  VAR
      Count             : INTEGER;
      Path              : PathStr;
      Attr              : WORD;
      D, chem           : DirStr;
      N                 : NameStr;
      E                 : ExtStr;
      F                 : File;

      testlist,
      testdir,
      repseul,
      local, ok         : Boolean;

      ind, nd, test     : Integer;

      chemini           : Pathstr;

      n_d               : byte;

   PROCEDURE GetCommand (var path : pathstr);
      VAR
         I, J           : INTEGER;

      BEGIN
         Path := FExpand (Path);
         IF Path [Length (Path)] <> '\'
         THEN BEGIN
            Assign   (F, Path);
            GetFAttr (F, Attr);
            IF (DosError = 0) AND (Attr AND Directory <> 0)
            THEN
               Path := Path + '\';
         END;
         FSplit (Path, D, N, E);
         IF N = ''  THEN N := '*';
         IF E = ''  THEN E := '.';
         Path   := D + N + E;
         chemin := D;
         if repseul then path := D;
      END;

   PROCEDURE FindFiles;
      TYPE
         Dirptr   = ^DirRec;
         DirRec   = record
                       name : STRING [12];
                    end;
         DirList  = ARRAY  [0..Maxliste - 1] OF DirPtr;

      VAR
         dir            : DirList;
         F              : SearchRec;
         repert         : byte;
         i, nb          : integer;
        { s               : string;}

      function ordre (x, y : dirptr) : boolean;
         begin
            ordre := x^.name < y^.name;
         end;

      procedure quicksort (l, r : integer);
         var
            i, j        : integer;
            x, y        : dirptr;

         begin
            i := l;
            j := r;
            x := dir [(l+r) div 2];
            repeat
               while ordre (dir [i], x) do inc (i);
               while ordre (x, dir [j]) do dec (j);
               if i <= j
               then begin
                  y       := dir [i];
                  dir [i] := dir [j];
                  dir [j] := y;
                  inc (i);
                  dec (j);
               end;
            until i > j;
            if l < j then quicksort (l, j);
            if i < r then quicksort (i, r);
         end;

       procedure sortfiles (count : integer);
         begin
            if (count > 1)
            then
               quicksort (0, count-1);
         end;

      procedure liberedir (nb : integer);
         var
            i           : integer;

         begin
            for i := 0 to nb-1
            do begin
               dispose (dir [i]);
               dir [i] := nil;
            end;
         end;

      procedure ajouteralalistedesfichiers (nb : integer) ;
         begin
            new (dir [nb]);
            dir [nb]^.name := f.name;
         end;

      procedure ajouteralalistecomplete    (nb : integer);
         var
            i, j        : integer;

         begin
            i := count-nb+1;
            for j := 0 to nb-1
            do
               creeliste (dir [j]^.name, i+j);
            creeliste ( '', i+j+1);
         end;

      BEGIN
         Count := 0;
         if ficseul
         then
            repert := 0
         else
            repert := directory;

         if repseul
         then begin
            inc (count);
            creeliste (validrepert, count)
         end;

         if not ficseul
         then
            { recompose pour affichage la liste des disques logiques connus }
            if not local
            then
               for i := 1 to 26
               do begin
                  if (i in liste_disques)
                  then begin
                     testlist := true;
                     inc (count);
                     n_d := naturedisque (i);
                     case n_d of
                     0 : creeliste ('[' + chr (64 + i)+ ':] local', count);
                     1 : creeliste ('[' + chr (64 + i)+ ':] distant', count);
                     2 : creeliste ('[' + chr (64 + i)+ ':] substitu', count);
                     end
                  end
               end;

         { recherche des rpertoires }
         if repert <> 0
         then begin
            FindFirst (D + N + '.', repert , F);
            if f.name = '.'
            then
               Findnext (F);
            nb := 0;
            WHILE (DosError <> 2) AND (DosError <> 18)
                                  AND (Count < Maxliste)
            DO BEGIN
               testlist := true;
               testdir  := ((F.attr and $10 ) = $10);
               if testdir
               then begin
                  F.name :=  '[' + F.name + ']';
                  ajouteralalistedesfichiers (nb) ;   { 0..max-1 }
                  inc (nb);
                  Inc (Count);
               end;
               FindNext (F);
            END;
            { if testdir then begin}
            sortfiles (nb);
            ajouteralalistecomplete (nb);  { 1..max }
            liberedir (nb);
            { end }
         end;

       { recherche des fichiers }
         if not repseul
         then begin
            FindFirst (Path, ReadOnly + Archive, F);
            if f.name = '.'
            then
               Findnext (F);
            nb := 0;
            WHILE (DosError <> 2)  AND (DosError <> 18)
                                   AND (Count < Maxliste)
            DO BEGIN
               testlist := true;
               nomf     := F.name;
               ajouteralalistedesfichiers (nb);   { 0..max-1 }
               Inc  (Count);
               inc  (nb);
               FindNext (F);
            END;
            if testlist
            then begin
               sortfiles               (nb);
               ajouteralalistecomplete (nb);  { 1..max }
               liberedir               (nb);
            end
         end                           { fin de recherche fichiers }
      END;

   Procedure catal              (chemin1 : Pathstr);
      var
         chain          : chainecar;

      begin
         if length (chemin1) >= 1
         then
            if (copy (chemin1, length (chemin1), 1) <> '\')
            then
               chemin1 := chemin1 + '\';

         testlist := false;
         path     := concat (chemin1, filtre);
         GetCommand  (path);
         FindFiles;

         if filtre = '*.'
         then
            chain := ''
         else
            chain := filtre;

         getdir (0, chemin1);
         if testlist
            then begin
               ind := 1;
               liste    (comm, chemin1, chain, 12, nomf, ind)
            end else
               if repseul
               then
                  message (m_not_repert)
               else
                  message (m_not_fichier);
      end;

   Function repert              (nomf : Pathstr) : boolean;
      begin
         repert := (nomf [1] = '[' );
      end;

(*   procedure attend_dk (var ok : boolean);
      begin
         message ('mettre la disquette en '+dk2);
         {$I-} chdir  (dk2+'\'); {$I+}
         ok := ioresult = 0  ;
      end; *)

   BEGIN
      ind := 1;
      local  := false;
      ok     := true;
      getdir (0, chemini);       { rcupre le chemin courant complet }
      fsplit (chemin, chem, n, e);

      if (chem [length (chem)] = '\') and (length (chem) > 3)
      then
         chem := copy (chem, 1, length (chem) - 1);

      {$I-}  chdir (chem); {$I+}
      if ioresult <> 0
      then begin
         chdir   (chemini);
         message (m_not_rep_trouve);
         ok := false;
         exit
      end;

      if filtre = '*.'
      then
         repseul := true
      else
         repseul := false;

      catal (chem);  { appelle LISTE qui affecte NOMF et IND }

      if repseul
      then
         test := 1
      else
         test := 0;

      while repert (nomf) and (ind <> test)
      do begin
         {nomf := copy (nomf, 2, length (nomf)-2);}
         nomf := copy (nomf, 2, (pos (']', nomf)-2));
         if testdisk (nomf)
         then begin
            {$I-} chdir (nomf); {$I+}
            if ioresult <> 0
            then begin
               message (m_not_rep_trouve);
               ok := false;
            end;
         end;
         getdir (0, chem);
         catal  (chem);
      end;

      if (chem [length (chem)] <> '\') and (length (chem) > 0)
      then
         chemin := chem+'\' ;
    {  filtre := extension (nomf);}
      chdir (chemini);
   END;

Function numeromaxi          (path : Pathstr) : integer;
   VAR
      F                 : SearchRec;
      i                 : integer;

   BEGIN
      i  := 0;
      FindFirst (Path, ReadOnly + Archive, F);
      WHILE (DosError = 0)
      DO BEGIN
         Inc (i);
         FindNext (F);
      END;
      numeromaxi := i;
   END;

procedure copier_fichiers    (paths, pathb : Pathstr; var nbf : integer);
   VAR
      F                 : SearchRec;
      Ds, Db            : DirStr;
      N                 : NameStr;
      E                 : ExtStr;
      ok                : boolean;

   BEGIN
      FSplit    (Pathb, Db, N, E);
      FindFirst (Paths, ReadOnly + Archive, F);
      nbf  := 0;
      ok   := true;
      WHILE (DosError = 0) and ok
      DO BEGIN
         FSplit (Paths, Ds, N, E);
         CopyFile (Ds+f.name, Db+f.name, ok);
         if ok
         then begin
            Inc   (nbf);
            laide (Ds+f.name);
            FindNext (F);
         end;
      END;
   END;

procedure copier_fichiers_max  (paths, pathb : Pathstr;
                                var tmax     : longint;
                                nbi          : integer;
                                var nbf      : integer);
   VAR
      F                 : SearchRec;
      Ds, Db            : DirStr;
      N                 : NameStr;
      E                 : ExtStr;
      ok                : boolean;
      t                 : longint;
      i                 : integer;

   BEGIN
      FSplit    (Pathb, Db, N, E);
      FindFirst (Paths, ReadOnly + Archive, F);
      i := 0;
      while (DosError = 0) and (i < nbi)
      do begin
         FindNext (F);
         inc (i);
      end;

      nbf  := 0;
      t    := F.size;
      ok   := true;
      WHILE (DosError = 0) and (t < tmax) and ok
      DO BEGIN
         FSplit (Paths, Ds, N, E);
         CopyFile (Ds+f.name, Db+f.name, ok);
         if ok
         then begin
            Inc   (nbf);
        {    laide (Ds+f.name+ ' ---> '+ Db);}
            FindNext (F);
            t    := t+F.size;
         end;
      END;
      if (t >= tmax) and (nbf > 0)
      then
          t := t-F.size;

      tmax := t;
   END;

procedure effacer_fichiers   (path : Pathstr; var nbf : integer);
   VAR
      D                 : DirStr;
      N                 : NameStr;
      E                 : ExtStr;
      F                 : SearchRec;
      fic               : file;

   BEGIN
      nbf  := 0;
      FindFirst (Path, ReadOnly + Archive, F);
      WHILE (DosError = 0)
      DO BEGIN
         Inc    (nbf);
         FSplit (Path, D, N, E);
         Assign (Fic,  D+f.name);
         laide  (f.name+ m_efface);
         Erase  (Fic);
         FindNext (F);
      END;
   END;

function volume_fichiers     (path : Pathstr) : longint;
   VAR
      V                 : longint;
      D                 : DirStr;
      N                 : NameStr;
      E                 : ExtStr;
      F                 : SearchRec;
      fic               : file;

   BEGIN
      v  := 0;
      FindFirst (Path, ReadOnly + Archive, F);
      WHILE (DosError = 0)
      DO BEGIN
         FSplit (Path, D, N, E);
         V := V+ F.size;
         FindNext (F);
      END;
      volume_fichiers := V;
   END;

Function nomfichier_seul_ok  (nomfc : Pathstr) : boolean;
   var
      path              : pathstr;
      D                 : DirStr;
      N                 : NameStr;
      E                 : ExtStr;

   begin
      if (Pos (' ', nomfc) = 0)
      then begin
         path := nomfc;
         FSplit (Path, D, N, E);
         if  (length (N) > 0) and (length (E) > 1)
         then
            nomfichier_seul_ok := true
         else
            nomfichier_seul_ok := false
      end else
         nomfichier_seul_ok := false;
   end;

procedure extraire_fichiers_zip
                             (chpk, nomfz, opts, listef, chemf : Pathstr;
                              var ok : boolean);
   { chpk   : chemin prg pkunzip ;
     nomfz  : chemin et nom fic compress ;
     listef : noms des fichiers  extraire
                 (noms de fichiers  ou  @nomliste)
     chemf  : chemin de destination            }
   var
      lignedeCmd   : string;
     { prg         := 'a:pkunzip.exe';
     lignedecmd  := 'a:zdnn -d -o -n @listmaj.lst  d:\essai';}

   begin
      lignedecmd := nomfz+' '+opts+' '+listef+' '+chemf+' >NUL';
      SwapVectors;
      Exec (chpk, lignedeCmd);
      SwapVectors;
      ok := (doserror=0);
   end;

procedure vider_buffers (var ok : boolean);
   var
      prg, lignedeCmd   : string;

   begin
      complete (repdos);
      prg        := repdos+'smartdrv.exe';
      lignedecmd := '/c > NUL';

      SwapVectors;
      Exec (prg, lignedeCmd);
      SwapVectors;

      ok := (doserror=0);
   end;


{---------------------------------------------------------------------------}
BEGIN

   ExitSauve := ExitProc;
   ExitProc  := @TrapRunTimeError;

   reptemp   := maj (getenv ('temp'));
   complete (reptemp);

   repdos    := maj (getenv ('comspec'));

END.

{--- FICHIERS--------------------------------- XC -- ARX ----------- - 1994 }
