UNIT FONCSTAT;

   {------------------------------------------------------------------------}
   {      bibliothque                                                      }
   {                       fonctions statistiques                           }
   {                                                             03/09/91   }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos;

CONST
   maxnp = 200;

TYPE
   pts   = array[1..maxnp,1..2] of real;

Procedure regression(var txy: pts; n : integer;
                     var xm, ym, teta, ecartmax, ecartype : real);

{  En entre : txy contient les coordonnes de N points
   En sortie : xm et ym = valeurs moyennes des abcisses et des ordonnes,
               teta = angle de la droite,
               ecartmax = valeur maxi de l'cart rencontr,
               ecartypy = cart-type calcul.                               }

{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure regression(var txy: pts; n : integer;
                     var xm, ym, teta, ecartmax, ecartype : real);
   var
      i                               : integer;
      c2t, s2t, deuxt, ecart, norme,
      sx,  sy,  sx2, sy2, sxy         : real;

   begin
         sx  := 0;  sy := 0;
         sx2 := 0; sy2 := 0;
         sxy := 0;

         for i := 1 to n do begin
            sx := sx+txy [i, 1];
            sy := sy+txy [i, 2];
         end;


         xm := sx/n;

         ym := sy/n;

         for i := 1 to n do begin
            sx2 := sx2+sqr (txy [i, 1]-xm);
            sy2 := sy2+sqr (txy [i, 2]-ym);
            sxy := sxy+(txy [i, 1]-xm) * (txy [i, 2]-ym);
         end;

      { calcul de la regression }

      norme := sqrt (sqr (sy2-sx2)+sqr (2*sxy));
      c2t   := (sy2-sx2)/norme;
      s2t   := 2*sxy/norme;

      if abs(c2t) < abs (s2t) then begin
         deuxt := pi/2-arctan (c2t / s2t);
         if s2t < 0 then deuxt := deuxt+pi;
      end else begin
         deuxt := arctan (s2t / c2t);
         if c2t < 0 then deuxt := deuxt+pi;
      end;

      teta := pi/2-deuxt / 2;

      ecartmax := 0;
      for i := 1 to n do begin
         ecart :=
         abs (sin (teta) * (txy [i, 1]-xm)-cos (teta) * (txy [i, 2]-ym));
         if ecart > ecartmax then ecartmax := ecart;
      end;
      ecartype := sx2 * sqr (sin (teta))+sy2 * sqr (cos (teta))
                 -2 * sxy * sin (teta) * cos (teta);
      ecartype := sqrt (ecartype/n);
   end;

END.

{------------------------------------------------------------ ARX - BALMA --}
