UNIT SEKOPLT;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                        gestion de la table traante                       }
{                                                               03/05/91    }
{                                                               02/10/92    }
{                                                               28/12/92    }
{---------------------------------------------------------------------------}
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde 31130 BALMA   }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{ sortie table traante paralllle : LPT1    ou srie   : COM1, COM2        }
{ la var. fichier LST est assigne par dfaut  LPT1 dans l'unit PRINTER   }
{ le progr. utilisateur peut rassigner LST  un autre port de sortie.      }
{---------------------------------------------------------------------------}
{  cette unit inclut les redfinitions de cltures, la gestion du texte.   }
{---------------------------------------------------------------------------}
{   t2x  = 11040        aire maximale de trac   (units traceur)           }
{   t2y  =  7721                                                            }
{   t3x  = 16158                                                            }
{   dec  =   320;       dcalage pour centrage                              }
{   l1x  =   276;       dimensions en mm                                    }
{   l1y  =   193;                                                           }
{   l2x  =   404;                                                           }
{---------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   printer;

TYPE
   s1 = string [1];

{VAR
    coef_mm_unit,                   conversion mm -> units utilisateur     }
{   papier_x,   papier_y : real;    dimensions en mm                        }
{   formatpapier         : char;    formats normaliss A4 ou A3             }

{---------------------------------------------------------------------------}

Procedure calculer_repere_traceur (f_papier : s1; position : char;
                      w1,  w2,  w3,  w4 : integer;   { fenetre utilisateur }
                      var papier_x, papier_y, coef_mm_unit : real);
   { met  jour les dimensions du papier en mm et le coef de conversion     }
   { format A '4' ou A '3' ; position  'T'out, 'M'axi, 'C'entr             }
   { retourne les dimensions du papier et le coef de conversion             }

procedure inigraph_t (w1,  w2,  w3,  w4 : integer);
                                       { fenetre utilisateur dj dfinie }
   { initialisation du traceur
   {              formatpapier global = '4' pour A4 ou '3' pour A3          }
   { occupation de la feuille : T = tout occuper                            }
   {                            M = maxi en conservant le rapport L/l       }
   {                            C = centr et raport conserv               }
   {                           w1, w2, w3, w4 = repre utilisateur          }
   { par dfaut : clture maxi centre au format du papier (A4)             }
   {               A4 247 x 185 mm  *1.414 ->  A3 349 x 262 mm              }
   {              plume   1                                                 }
   {              repre cran VGA si 4 valeurs  0                         }
   {              direction d'criture horizontale                          }
   {              jeu de car. 0 standard et jeu 7 secondaire                }
   {                                              pour les accents          }
   {              coef de taille des caractres 1.4  et 1.1                 }

Procedure inigraph_p (f_papier : s1;  w1, w2, w3, w4 : integer);
   { pour tracs homothtiques cran-table                                  }
   { initialisation du traceur f_papier= '4' pour A4 ou '3' pour A3         }
   {                           w1, w2, w3, w4 = repre utilisateur          }
   { autres initialisations : cf ci-dessus                                  }
   { REMPLACABLE PAR APPEL  inigraph_t                                   }

Procedure inigraph_pmax (f_papier : s1);
   { tracs indpendants du format cran                                    }
   { initialisation du traceur f_papier= '4' pour A4 ou '3' pour A3         }
   { A4 -> en mm    w1x:=  0; w1y:=  0; w2x:=  276; w2y:=  193              }
   { A3 -> en mm    w1x:=  0; w1y:=  0; w2x:=  404; w2y:=  276              }
   { origine de la feuille en bas  gauche                                  }
   { autres initialisations : cf ci-dessus                                  }
   { inutilis par GRAPHPLT                                                 }
   { REMPLACABLE PAR APPEL  inigraph_t                                   }

Procedure pclose;
   { pour terminer : range la plume et ferme le fichier de sortie           }

Procedure fenetre_p (f1, f2, f3, f4 : integer);
   { initialisation des valeurs de la fentre de travail= coord utilisateur }

Procedure pleine_page;
   { = clture  maximum                                                     }

Procedure cloture_p (xgc, xdc, ybc, yhc : integer; clip : boolean);
   { dfinit une nouvelle clture en recalculant P1 et P2                   }
   {          et un repre fonction de la fentre utilisateur (fenetre_p)   }
   { tous les dplacements sont effectus dan le nouveau repre             }
   { clip = vrai pour dcouper le trac aux limites                         }
   { inutilis par GRAPHPLT                                                 }

Procedure plc;
   { lve la plume                                                          }

Procedure pbc;
   { baisse la plume                                                        }

Procedure pfcc (n : integer);
   { change la plume                                                        }
   { range la plume si n=0                                                  }

Procedure pfpos  (x, y : real);
   { dplacement absolu sans modifier l'tat de la plume                    }

Procedure pfposr (dx, dy : real);
   { dplacement relatif sans changer l'tat de la plume                    }

Procedure ptrace (x1, y1, x2, y2 : real; c : integer);
   { trace une ligne en absolu        c =n de plume                        }

Procedure ptracevers   (dx, dy : real);
   { trace vers     relatif                                                 }

Procedure ptraceen     (x,  y  : real);
   { trace vers     absolu                                                  }

Procedure pdeplaceen   (x , y  : real);
   { dplace la plume leve en absolu                                       }

Procedure pdeplacevers (dx, dy : real);
   { dplace la plume leve en relatif                                      }

Procedure porigine;
   { ramne la plume en 0,0                                                 }

Procedure pcadre;
   { cadre de la clture courante                                           }

Procedure pcercle (r : integer);
   { cercle de rayon r centr sur la pos. courante avec la plume courante   }

Procedure parc (xc, yc : longint;  angle : integer);
   { trace un arc de centre xc yc  partir de la position courante          }

Procedure ptypet (typ : integer); {0..6}
   { fixe le type de trait                                                  }

Procedure ptypeh (typ, angle : integer); {1..4}
   { fixe le type de hachures                                               }

Procedure precth (dx, dy : integer);
   { rectangle hachur                                                      }

Procedure prect  (dx, dy : integer);
   { rectangle simple                                                       }

Procedure psect  (rayon, cap, ouverture : integer);
   { secteur   simple                                                       }

Procedure psecth (rayon, cap, ouverture : integer);
   { secteur   hachur                                                      }

Procedure pdir     (angl : integer);
   { fixe la direction d'criture du texte                                  }

Procedure pdir_cte ( portee, site : real);
   { fixe la direction d'criture du texte                                  }

Procedure pincl  (angl : integer);
   { fixe l'inclinaison des caractres                                      }

Procedure ptaille (coef : real);
   { fixe la taille relative des caractres relative  la clture courante  }
   {  -- 1 standard = L  0,75*(p2x-p1x)                                     }
   {                  H  1,5...                                             }

Procedure ptaille_abs (larg, haut : real);
   { fixe la taille absolue des caractres en Cm                            }

Procedure pstyle (dir, incl : integer; taille : real);
   { dir     = angle direction degrs   -- horizontale  =  0                }
   { incl    = inclinaison     degrs   -- verticale    =  0                }
   { taille  = coef dimension relative  -- normale      =  1                }
   {           avec couleur et jeu de car. courants                         }

Procedure pinicar;
   { initialise le jeu de caractres 0 en standard et 7 en secondaire       }

Procedure ptextxy (x, y : real; txt : string);
   { crit le texte en x,y dans le repre FEUILLE (dfini par cloture_p     }
   { ou par pleinpage)                                                      }
   { les minuscules                sont reconnues            }

Procedure ptext (             txt : string; h, v : byte);
   { crit le texte  la position courante corrige en par h et v           }
   { h et v doivent avoir les mmes valeurs que SETJUSTIFY                  }
   { h et v sont actifs si la direction d'criture est 0 ou 90             }
   { mmes lettres accentues                                               }

Procedure ptext_ct (lcar, hcar : real ; txt : string);
   { crit le texte  la position courante non corrige, avec par. courants }

{---------------------------------------------------------------------------}

IMPLEMENTATION

CONST                        { constantes du traceur SEKONIC 6 plumes       }
   t1x                  =     0;       {  units traceur : position P1 P2   }
   t1y                  =     0;
   t2x                  = 11040;
   t2y                  =  7721;
   t3x                  = 16158;
   dec                  =   320;       { dcalage pour centrer unit traceur }
   l1x                  =   276;       { dimensions maxi trac              }

{   l1y  =   193;
    l2x  =   404;   inutilis }

VAR
   xgf, xdf, ybf, yhf,                 {  fentre par dfaut                }
   p1x, p1y, p2x, p2y,                 {  points de rfrence du traceur    }
   w1x, w1y, w2x, w2y   : integer;     {  clture maxi traceur              }

   ch1, ch2, ch3, ch4   : string;

   coeftx, coefty,           { coefficients pour dterminer long. chaine    }
   coeftaille,               { paramtre taille de caractre                }

   ll, lh, dv, dh       : real;

   ok                   : boolean;

   dir_ecr              : byte;        { direction criture 0 1 2           }
   formatpapier         : char;        { formats normaliss A4 ou A3        }

procedure calculer_repere_traceur (f_papier : s1; position : char;
                      w1,  w2,  w3,  w4 : integer;   { fenetre utilisateur }
                      var papier_x, papier_y, coef_mm_unit : real);
   var
      dxy, dx, dy,
      ldx, ldy,
      lpx, lpy          : longint;
      coefw, coeft,
      coefmm            : real;
      d1x, d2x,
      d1y, d2y          : integer;

   begin
      if f_papier = ''
      then
         f_papier := '4';

      if position = ''
      then
         position     := 'C';

      coefmm := (t2x - t1x) / l1x;            { nb units traceur par mm }

      if (w1 = 0) and (w2 = 0) and
         (w3 = 0) and (w4 = 0)
      then begin        { repere VGA par dfaut }
         w1  :=   0;
         w2  := 639;
         w3  :=   0;
         w4  := 479
      end else begin
         w1x :=  w1;
         w1y :=  w3;
         w2x :=  w2;
         w2y :=  w4
      end;

     { raffecter les limites effectives de trac par dfaut
       en fonction du format du papier }
      d1x := t1x;
      d2x := t2x;
      d1y := t1y;
      d2y := t2y;
      if f_papier = '3'
      then begin                           { format A3 }
         d2y := t2x;
         d2x := t3x;
      end;

     { recalculer les limites trac pour garder rapport aggran. = 1.414 }

      if upcase (position) = 'C'
      then                    { TRACE CENTRE }
         if f_papier = '3'
         then begin                        { format A3 }
            ldx := t3x-dec-t1x;
            if (t2x-t1x) * 1.414 <= ldx
               then begin
                  ldx := trunc ((t2x-t1x)     * 1.414);
                  ldy := trunc ((t2y-t1y-dec) * 1.414)
               end else
                  ldy := trunc (ldx * (t2y-t1y-dec) / (t2x-t1x));
            dx  := t3x -t1x -ldx -dec;
            dy  := t2x -t1y -ldy;
            d1x := t1x + dx div 2;
            d2x := d1x + ldx;
            d1y := t1y + dy div 2;
            d2y := d1y + ldy;
         end else begin             { format A4 dans tous les autres cas }
            d1y := t1y + dec;
         end;

      { calculer les coordonnes des points de rfrence du traceur }

      p1x := d1x;
      p1y := d1y;
      if upcase (position) = 'T'
      then begin
         p2x := d2x;
         p2y := d2y;
         lpx := d2x-d1x;
         lpy := d2y-d1y;
      end;

      if (upcase (position) = 'M')                   { MAXI L/l conserv }
         or (upcase (position) = 'C')
      then begin   { CENTRE L/l conserv }
         coefw := abs ((w4 - w3) / (w2 - w1));
         coeft := abs ((d2y-d1y) / (d2x-d1x));
         if coefw < coeft
         then begin
            lpx := d2x-d1x;
            lpy := trunc (lpx * coefw);
            dxy := (d2y-d1y-lpy) div 2;
            p1y := d1y+dxy;
            p2x := p1x+lpx;
            p2y := p1y+lpy;
         end else begin
            lpy := d2y-d1y;
            lpx := trunc (lpy / coefw);
            dxy := (d2x-d1x-lpx) div 2;
            p1x := d1x+dxy;
            p2x := p1x+lpx;
            p2y := p1y+lpy;
         end;
      end;
      papier_x := lpx / coefmm;
      papier_y := lpy / coefmm;
      coef_mm_unit := papier_x / (abs (w2-w1)+1);
   end;

procedure ini_coef_traceur;
   begin
      fenetre_p (w1x, w2x, w1y, w2y);
      pleine_page;
      write     (lst, 'SP1;') ;
      coeftx     := 1.1;
      coefty     := 1.4;
      coeftaille := 1;
      dv         := 0;
      dh         := 0;
      pinicar;
      dir_ecr    := 0;
   end;

procedure inigraph_t (w1,  w2,  w3,  w4 : integer);
                                       { fenetre utilisateur dj dfinie }
   begin
      rewrite (lst);
      write   (lst, 'PS'+formatpapier+';');
      ini_coef_traceur;
   end;

procedure inigraph_p (f_papier : s1; w1, w2, w3, w4 : integer);
                                       { fentre centre }
   begin
      formatpapier := f_papier [1];
      inigraph_t (0, 0, 0, 0);
   end;

procedure inigraph_pmax (f_papier : s1);
                                       { fentre maxi }
   begin
      if f_papier='4'
         then begin
            formatpapier := '4';
            inigraph_t (0, 276, 0, 193)
         end else begin
            formatpapier := '3';
            inigraph_t (0, 404, 0, 276)
         end
   end;

procedure pclose;
   begin
      write (lst, 'SPIN;');
      close (lst)
   end;

procedure fenetre_p (f1, f2, f3, f4 : integer);
   begin
      xgf := f1;
      xdf := f2;
      ybf := f3;
      yhf := f4;
   end;

procedure pleine_page;
   begin
      str   (p1x, ch1);
      str   (p2x, ch2);
      str   (p1y, ch3);
      str   (p2y, ch4);
      write (lst, 'INIP' + ch1 + ',' + ch3 + ',' + ch2 + ',' + ch4 + ';');
      write (lst, 'IW'   + ch1 + ',' + ch3 + ',' + ch2 + ',' + ch4 + ';');
      str   (w1x, ch1);
      str   (w2x, ch2);
      str   (w1y, ch3);
      str   (w2y, ch4);
      write (lst, 'SC'  +ch1+','+ch2+','+ch3+','+ch4+';');
   end;

procedure cloture_p (xgc, xdc, ybc, yhc : integer ; clip : boolean);
   var
      v1x, v1y,
      v2x, v2y          : integer;
      z                 : real;

   begin
      z := (p2x-p1x) / w2x; v1x := trunc (xgc*z+p1x);
                            v2x := trunc (xdc*z+p1x);
      z := (p2y-p1y) / w2y; v1y := trunc (ybc*z+p1y);
                            v2y := trunc (yhc*z+p1y);
      str   (v1x, ch1);
      str   (v2x, ch2);
      str   (v1y, ch3);
      str   (v2y, ch4);
      write (lst, 'INIP' + ch1 + ',' + ch3 + ',' + ch2 + ',' + ch4 + ';');
      if clip then
         write (lst, 'IW'  + ch1 + ',' + ch3 + ',' + ch2 + ',' + ch4 + ';');

      str   (xgf, ch1);
      str   (xdf, ch2);
      str   (ybf, ch3);
      str   (yhf, ch4);
      write (lst, 'SC'  +ch1 + ',' + ch2 + ',' + ch3 + ',' + ch4 + ';');
   end;

procedure plc;
   begin
      write (lst, 'PU;')
   end;

procedure pbc;
   begin
      write (lst, 'PD;')
   end;

procedure pfcc;
   var
      s : s1;

   begin
      str   (n, s);
      write (lst, concat ('SP', s, ';'))
   end;

procedure pfpos;
   var
      xc, yc            : string;

   begin
      str   (x:6:2, xc);
      str   (y:6:2, yc);
      write (lst, concat ('PA', xc, ',', yc, ';'))
   end;

procedure pfposr (dx, dy : real);
   var
      xc, yc            : string;

   begin
      str   (dx:6:2, xc);
      str   (dy:6:2, yc);
      write (lst, concat ('PR', xc, ',', yc, ';'))
   end;

procedure ptrace;
   begin
      plc;
      pfcc  (c);
      pfpos (x1, y1);
      pbc;
      pfpos (x2, y2);
      plc
   end;

procedure ptraceen   (x , y  : real);
   begin
      pbc;
      pfpos (x, y)
   end;

procedure ptracevers (dx, dy : real);
   begin
      pbc;
      pfposr (dx, dy);
   end;

procedure pdeplaceen (x, y : real);
   begin
      plc;
      pfpos (x, y)
   end;

procedure pdeplacevers (dx, dy : real);
   begin
      plc;
      pfposr (dx, dy)
   end;

procedure porigine;
   begin
      pfpos (xgf, ybf)
   end;

procedure pcadre;
   begin
      plc;
      porigine;
      pbc;
      pfpos (xdf, ybf);
      pfpos (xdf, yhf);
      pfpos (xgf, yhf);
      porigine;
      plc
   end;

procedure pcercle;
   var
      ra, co            : string;

   begin
      str (r, ra);
      case round (abs (r)) of
         0..20  : co := '30';
         21..50 : co := '15'
      else
         co := '5'
      end;
      write (lst, concat ('CI', ra, {',', co,} ';'));
   end;

procedure parc;
   var
      x, y, a           : string;

   begin
      str   (xc, x);
      str   (yc, y);
      str   (angle, a);
      write (lst, concat ('AA', x, ',', y, ',', a, ';'));
   end;

procedure ptypet;
   var
      t                 : s1;

   begin
      str   (typ, t);
      write (lst, concat ('LT', t, ';'));
   end;

procedure ptypeh;
   var
      t                 : s1;
      a                 : string;

   begin
      str   (typ, t);
      str   (angle, a);
      write (lst, concat ('FT', t, ',', '4', ',', a, ';'));
   end;

procedure precth;
   var
      x, y              : string;

   begin
      str   (dx, x);
      str   (dy, y);
      write (lst, concat ('RR', x, ', ', y, ';'));
   end;

procedure prect;
   var
      x, y, x2, y2      : string;

   begin
      str   (dx, x);
      str   (dy, y);
      str   (-dx, x2);
      str   (-dy, y2);
      write (lst,
          concat ('PR', x, ', 0, 0, ', y, ', ', x2, ', 0, 0, ', y2, ';'));
   end;

procedure psect;
   var
      r, c, o           : string;

   begin
      str   (rayon, r);
      str   (cap, c);
      str   (ouverture, o);
      write (lst, concat ('EW', r, ',', c, ',', o, ';'));
   end;

procedure psecth;
   var
      r, c, o           : string;

   begin
      str   (rayon, r);
      str   (cap, c);
      str   (ouverture, o);
      write (lst, concat ('WG', r, ',', c, ',', o, ';'));
   end;

procedure pdir (angl : integer);
   var
      portee, site, ang : real;
      p, s              : string;

   begin
      ang    := 3.141592 * angl / 180;
      portee := cos (ang);
      site   := sin (ang);
      str   (portee:6:4, p);
      str   (site:6:4, s);
      write (lst, concat ('DI', p, ',', s, ';'));
      case angl of
          0 :  dir_ecr := 0;
         90 :  dir_ecr := 1;
         else  dir_ecr := 2;
      end;
   end;

procedure pdir_cte ( portee, site : real);
   var
      p, s              : string;

   begin
      str   (portee:6:4, p) ;
      str   (site:6:4, s);
      write (lst, concat ('DI', p, ',', s, ';'));
   end;

procedure pincl (angl : integer);
   var
      a      : string;
      t, ang : real;

   begin
      ang := (3.141592 * angl / 180);
      t   := sin (ang) / cos (ang);
      str   (t:6:4, a);
      write (lst, 'SL' + a + ';');
   end;

procedure ptaille (coef : real);
   var
      l, h              : string;
      larg, haut        : real;

   begin
      larg := 0.75 * coef;
      haut := 1.5  * coef;
      coeftaille := coef;
      str   (larg:6:4, l);
      str   (haut:6:4, h);
      write (lst, 'SR' + l + ',' + h + ';');
   end;

procedure ptaille_abs (larg, haut : real);
   var
      l, h              : string;

   begin
      str   (larg:6:4, l);
      str   (haut:6:4, h);
      write (lst, 'SI' + l + ',' + h + ';');
   end;

procedure pstyle ( dir, incl : integer; taille : real);
   begin
      pdir    (dir);
      pincl   (incl);
      ptaille (taille);
   end;

procedure pinicar;
   begin
      write (lst, 'CS0CA7SS;');
   end;


function codel (carac : char) : byte;
   var
     codelp             : byte;

   begin
     ok := false;
     if carac in ['','','']     then codelp := 97;
     if carac in ['','','',''] then codelp := 101;
     if carac in ['','']         then codelp := 105;
     if carac in ['','']         then codelp := 111;
     if carac in ['','','']     then codelp := 117;
     if chr(codelp) in ['a','e','i','o','u']
        then begin
             ok := true;
             codel := codelp end
        else codel := ord (carac);
   end;

function codac (carac : char): byte;
   begin
     if carac in ['']                 then codac := 40;
     if carac in ['','','']         then codac := 41;
     if carac in ['','','','',''] then codac := 42;
     if carac in ['','','','',''] then codac := 43;
   end;

function accent (car : char) : string;
   var
      cl, acc           : byte;

   begin
     if car=''
     then begin
        accent := chr (14) + chr (53) + chr (15);
        exit
     end;

      cl := codel (car);
      if ok
      then begin
         acc := codac (car);
         if cl = 105
         then begin
            if acc = 42 then acc := 81;
            if acc = 43 then acc := 93;
            accent := chr (14) + chr (acc) + chr (15)
         end else
            accent := chr (cl) + chr (8) + chr (14) + chr (acc) + chr (15)
      end else
         accent := car+'';
   end;

function accentuees (chaine : string) : string;
   var
      ch                : string;
      n, i              : integer;
      c                 : char;

   begin
      i  := 1;
      ch := '';
      repeat
         c := chaine [i];

         if ord (c) > 127
         then  ch := ch+accent (c)
         else  ch := ch+c;
         inc(i);
      until i > length (chaine);
      accentuees := ch;
   end;

procedure pjustifie (l : integer; h, v : byte);
   var
      ll, lh ,lp        : real;

   begin
      ll := l * coeftx * (w2x - w1x) / 100 * coeftaille;
      lh :=     coefty * (w2x - w1x) / 100 * coeftaille;
      if dir_ecr=1
      then
         case h of
           0: case v of
                0: begin dv := lh  ; dh := 0     end;
                1: begin dv := lh  ; dh := -ll/2 end;
                2: begin dv := lh  ; dh := -ll   end;
              end;
           1: case v of
                0: begin dv := lh/2; dh := 0     end;
                1: begin dv := lh/2; dh := -ll/2 end;
                2: begin dv := lh/2; dh := -ll   end;
              end;
           2: case v of
                0: begin dv := 0   ; dh := 0     end;
                1: begin dv := 0   ; dh := -ll/2 end;
                2: begin dv := 0   ; dh := -ll   end;
              end;
         end
      else begin
        if (h = 2) and (v = 2) then begin dv := -ll   ; dh := -lh   end;
        if (h = 1) and (v = 2) then begin dv := -ll/2 ; dh := -lh   end;
        if (h = 0) and (v = 2) then begin dv :=  0    ; dh := -lh   end;
        if (h = 2) and (v = 1) then begin dv := -ll   ; dh := -lh/2 end;
        if (h = 1) and (v = 1) then begin dv := -ll/2 ; dh := -lh/2 end;
        if (h = 0) and (v = 1) then begin dv :=  0    ; dh := -lh/2 end;
        if (h = 2) and (v = 0) then begin dv := -ll   ; dh :=  0    end;
        if (h = 1) and (v = 0) then begin dv := -ll/2 ; dh :=  0    end;
        if (h = 0) and (v = 0) then begin dv :=  0    ; dh :=  0    end;
      end;
   end;

procedure ptextxy (x, y : real; txt : string);
   begin
      pdeplaceen (x, y);
      txt := accentuees (txt);
      write (lst, 'LB' + txt + chr (3) + ';');
   end;

procedure ptext_ct (lcar, hcar : real ; txt : string);
   var
      l, h              : string;
      hc2               : real;

   begin
      hc2 := hcar / 4;                           { dcalage origine en dessous }
      str   (lcar:6:4, l); str (hc2:6:4, h);
      write (lst, 'SI' + l + ',' + h + ';');
      write (lst, 'LB' + chr (10) + chr (13) + chr (3)+';');

      str   (hcar:6:4, h);
      write (lst, 'SI' + l + ',' + h + ';');
      txt := accentuees (txt);
      write (lst, 'LB'+ chr (32) + txt + chr (3) +';');
   end;

procedure ptext (txt : string; h, v : byte);
   var
      l                 : integer;

   begin
      dv := 0; dh := 0;
      if (dir_ecr < 2)
      then
         begin l := length (txt);
         pjustifie (l, h, v);
         pdeplacevers (dv, -dh);
      end;
      txt := accentuees (txt);
      write (lst, 'LB' + txt + chr (3) + ';');
   end;

BEGIN
{   coef_mm_unit := 1;}
END.

{--- SEKOPLT ------------------------------------------------ ARX - BALMA --}
