UNIT DIRINFO;

   {------------------------------------------------------------------------}
   {      logiciel GEOCEAN                                                  }
   {                     GESTION DU FICHIER DE RESSOURCES                   }
   {                                                            22/07/92    }
   {------------------------------------------------------------------------}

   { Le fichier de ressources associ  un rpertoire permet de mmoriser
     une ligne de description de chaque fichier .                           }
   (*
   DirInfo,                  { ARX     - Gestion des fichiers ressources    }
   *)

INTERFACE

{$O+,F+}

USES
   dos, crt, graph,          { TP 70   - units standard Borland            }
   Graphism,                 { ARX     - initialisations graphiques         }
   Souris,                   { ARX     - gestion de la souris               }
   Clavier,                  { ARX     - gestion du clavier                 }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers;                 { ARX     - Gestion des fichiers et erreurs    }

{$I-,S-}
{$M 8192, 8192, 655360}

Procedure edite_info ( chemin  : pathstr;
                       filtre  : namestr;
                       extf    : extstr );
   { Cre ou modifie fichier de ressources dans un rpertoire.              }
   { Dans la bote de slection sont affiches les                          }
   { informations associes  chaque fichier de la slection opre par     }
   { FILTRE s'il est prsent dans le rpertoire.                            }
   { CHEMIN contient le nom complet du fichier RESSOURCES.                  }
   { Utilise le rpertoire affect  la var. d'environnement TEMP           }

Procedure dir_info   ( comm    : string;
                       chemin  : pathstr;
                       filtre  : namestr;
                       extf    : extstr;
                     var nomf  : string);
   { rend un nom complet de fichier comme DIR mais uniquement dans un       }
   { rpertoire. Dans la bote de slection sont affiches les              }
   { informations associes  chaque fichier de la slection opre par     }
   { FILTRE s'il est prsent dans le rpertoire.                            }
   { CHEMIN contient le nom complet du fichier RESSOURCES.                  }

{---------------------------------------------------------------------------}
IMPLEMENTATION

TYPE
   DirPtr   = ^DirRec;
   ptrstr   = ^string;
   DirRec   = RECORD
                 info : ptrstr;
                 Attr : BYTE;
                 Time : LONGINT;
                 Size : LONGINT;
                 Name : STRING [12];
              END;
   DirList  = ARRAY [0..Maxliste - 1] OF DirPtr;

VAR
   Count        : INTEGER;
   Path         : PathStr;
   Dir          : DirList;
   Dirs         : DirStr;
   Noms         : NameStr;
   Exts         : ExtStr;

   nul,
   lg_boite,
   ind,
   debu, max,
   x0, y0       : integer;
   vide         : string [1];
   info_present,
   modi         : boolean;
   finfo, l1    : string;

function ordre (x, y : dirptr) : boolean;
   begin
      ordre := x^.name < y^.name;
   end;

procedure GetCommand (var path : pathstr);
   VAR
      I, J     : INTEGER;
      Attr     : WORD;
      F        : File;

   BEGIN
      Path := FExpand (Path);
      IF Path [Length (Path)] <> '\'
      THEN BEGIN
         Assign   (F, Path);
         GetFAttr (F, Attr);
         IF (DosError = 0) AND (Attr AND Directory <> 0)
         THEN
            Path := Path + '\';
      END;
      FSplit (Path, Dirs, Noms, Exts);
      IF Noms = '' THEN Noms := '*';
      IF Exts = '' THEN Exts := '.';
      Path   := Dirs + Noms + Exts;
   END;

procedure FindFiles;
   VAR
      F      : SearchRec;
      repert : byte;
      i      : integer;
      s      : string;

   BEGIN
      Count  := 0;
      FindFirst (Path, ReadOnly + Archive, F);
      WHILE (DosError = 0) AND (Count < Maxliste)
      DO BEGIN
         GetMem (Dir [Count], 14 + length (f.name));
         Move (F.Attr, Dir [Count]^.attr, 10+length (F.name));
         dir [count]^.info := @vide;
         Inc (Count);
         FindNext (F);
      END
   END;

procedure quicksort (l, r : integer);
   var
      i, j : integer;
      x, y : dirptr;

   begin
      i := l;
      j := r;
      x := dir [(l+r) div 2];
      repeat
         while ordre (dir [i], x) do inc (i);
         while ordre (x, dir [j]) do dec (j);
         if i <= j
         then begin
            y       := dir [i];
            dir [i] := dir [j];
            dir [j] := y;
            inc (i);
            dec (j);
         end;
      until i > j;
      if l < j then quicksort (l, j);
      if i < r then quicksort (i, r);
   end;

procedure sortfiles;
   begin
      if (count > 1)
      then
         quicksort (0, count-1);
   end;

procedure liberedir;
   var
      i, j : integer;

   begin
      for i := 0 to count-1
      do begin
         if dir [i]^.info <> @vide
         then
            freemem (dir [i]^.info,               1+length (dir [i]^.info^) );
            freemem (dir [i], {sizeof (dirrec)} 14 +length (dir [i]^.name));
      end;
   end;

procedure lire_info (nomf : string ; var ok : boolean);
   var
      f_info      : text;
      i , lgl, pp : integer;
      nf          : string [12];
      trouve      : boolean;
      ligne, nf2  : string;

   begin
      ok := false;
      assign    (f_info, nomf);
      for i := 0 to count-1
      do begin
         nf     := dir [i]^.name;
         resetTxtErr (f_info, nomf, ok);
         trouve := false;
         while not eof (f_info) and not trouve
         do begin
            readln (f_info, ligne);
            if ligne [1] = '*' then l1 := ligne;
            lgl  := length (ligne);
            if lgl > lg_boite then lg_boite := lgl;
            if lg_boite > 63
            then begin
               lgl := 63;
               lg_boite := 63;
               ligne := copy (ligne, 1, 63);
            end;
            nf2  := copy (ligne, 1, 12);
            if pos ('.', nf2) = 0
            then
               nf2 [pos (' ', nf2)] := '.';
            while pos (' ', nf2) > 0
            do
               delete (nf2, pos (' ', nf2), 1);
            trouve := (nf = nf2);
         end;
         if trouve and (lgl > 14)
         then begin
            getmem (dir [i]^.info, lgl-12);
            dir [i]^.info^ := copy (ligne, 15, lgl);
            ok := true;
         end;
      end;
      close (f_info);
   end;

procedure affiche (lx, h, n, y : integer);
   var
      pp , i      : integer;
      nomf, suit  : string;

   begin
      if n > (y div 2)
      then debu := n-(y div 2)+1
      else debu := 1;

      if n >= max-(y div 2)
      then debu := max-y+1;
      i := debu;
      settextjustify (0, 2);
      repeat
         if i <> n
         then begin
            setcolor        (c_t_boite_norm );
            setfillstyle (1, c_f_boite_norm );
         end else begin
            setcolor        (c_t_boite_inve );
            setfillstyle (1, c_f_boite_inve );
         end;
         bar       (x0   +3,    y0+h+  (i-debu) *ty,
                    x0+lx-3,    y0+h-1+(i-debu+1) *ty);
         nomf := dir [i-1]^.name;
         pp   := pos ('.', nomf);
         suit := dir [i-1]^.info^;
         outtextxy (x0+6,       y0+h+(i-debu)*ty, copy (nomf, 1, pp-1));
         outtextxy (x0+6+tx*8,  y0+h+(i-debu)*ty, copy (nomf, pp, 4));
         setcolor  (c_t_boite_inac);
         outtextxy (x0+6+tx*14, y0+h+(i-debu)*ty, suit);
         inc       (i);
      until (i = count+1) or (i = debu+y);
      compteursouris (nul, nul);
   end;

function nom12 (nf : string) : string;
   var
      N, E  : string;
      l, i  : integer;

   begin
      n  := sansext (nf);
      l  := length  (n);
      for i := l+1 to 8 do n := n + ' ';
      nom12 := n + extension (nf);
   end;

procedure ecrire_info (nomf : string);
   var
      f_temp, f_info      : text;
      i, pp               : integer;
      nf                  : string [12];
      ligne, nf2          : string;
      ok,
      trouve              : boolean;

   begin
      assign   (f_temp, reptemp+'info.tmp');
      assign   (f_info, nomf);
      rewriteTxtErr (f_temp, reptemp+'info.tmp', ok);
      resetTxtErr  (f_info, nomf, ok);
      while  not (eof (f_info))
      do begin
         readln  (f_info, ligne);
         writeln (f_temp, ligne);
      end;
      rewriteTxtErr (f_info, nomf, ok);
      resetTxtErr   (f_temp, reptemp+'info.tmp' , ok);
      while not eof (f_temp)
      do begin
         readln (f_temp, ligne);
         trouve := false;
         nf2    := copy (ligne, 1, 12);
         if    pos ('.', nf2) = 0 then nf2 [pos (' ', nf2)] := '.';
         while pos (' ', nf2) > 0
         do
            delete (nf2, pos (' ', nf2), 1);

         i := 0;
         while (i < count) and (not trouve)
         do begin
            nf     := dir [i]^.name;
            trouve := (nf = nf2);
            inc (i);
         end;

         if trouve
         then begin
            dec (i);
            ligne := (nom12 (dir [i]^.name) + '  ' + dir [i]^.info^);
         end;
         writeln  (f_info, ligne);
      end;

      for i := 0 to count-1
      do begin
         nf     := dir [i]^.name;
         resetTxtErr  (f_temp, reptemp+'info.tmp', ok);
         trouve := false;
         while not eof (f_temp) and not trouve
         do begin
            readln (f_temp, ligne);
            nf2  := copy (ligne, 1, 12);
            if    pos ('.', nf2) = 0 then nf2 [pos (' ', nf2)] := '.';
            while pos (' ', nf2) > 0 do delete (nf2, pos (' ', nf2), 1);
            trouve := (nf = nf2);
         end;
         if not trouve
         then begin
            ligne := (nom12 (dir [i]^.name) + '  ' + dir [i]^.info^);
            writeln  (f_info, ligne)
         end;
      end;
      close (f_info);
      close (f_temp);
   end;

procedure faire_info ( finfo : string);
   var
      f_info      : text;
      i           : integer;
      ok          : boolean;

   begin
      assign  (f_info, finfo);
      rewrite (f_info);
      RewriteTxtErr (f_info, finfo, ok);
      if ok
      then begin
         writeln (f_info, '*             prog/donnees');
         for i := 0 to  count-1 do
            writeln (f_info, nom12 (dir [i]^.name));
         close   (f_info);
         modi := true;
      end;
   end;

procedure modifie_finfo ( texte1, finfo : string ; x : integer ;
                          var modi : boolean );
   var
      p                     : pointer;
      y, lx, ly, h
                            : word;
      nn, n, memy           : integer;
      taillep               : longint;

   procedure modif_ligne (i : integer ; var ok : boolean);
      var
         lgl,  pp       : integer;
         suit, nomf     : string;

      begin
         setcolor        (c_t_boite_norm );
         setfillstyle (1, c_f_boite_norm );
         bar       (x0   +3,    y0+h  +(i-debu)   *ty,
                    x0+lx-3,    y0+h-1+(i-debu+1) *ty);
         nomf  := dir [i-1]^.name;
         pp    := pos ('.', nomf);
         suit  := dir [i-1]^.info^;
         outtextxy (x0+6,       y0+h+(i-debu)*ty, copy (nomf, 1, pp-1));
         outtextxy (x0+6+tx*8,  y0+h+(i-debu)*ty, copy (nomf, pp, 4));
         setcolor  (c_t_boite_inac);
         outtextxy (x0+6+tx*14, y0+h+(i-debu)*ty, suit);
         readxy    (x0+6+tx*14, y0+h+(i-debu)*ty, suit, lg_boite-14-1);
         lgl   := length (suit);
         if (lgl > 0)
         then begin
            getmem (dir [i-1]^.info, lgl+1);
            dir [i-1]^.info^ := suit;
            ok := true;
         end;
      end;

   begin                                                { modifie_finfo }
      setfillstyle (1, c_barre);
      bar             (0, maxy-ty, maxx, maxy);
      { nouveau_style (0, 0, 1);
      tx      :=  8;
      ty      := 12;}
      y       := count;
      max     := y;
      n       := 1;
      if y > 12
      then y := 12;
      lx      := x*tx  + 2*6;
      h       :=   ty  + 11;
      ly      := h + ty*y + 2;
      taillep := imagesize (0, 0, lx, ly);
      if taillep < maxavail
      then begin
         laide ('Dplacer la slection avec la souris ou les flches puis valider');
         getmem (p, taillep);
         if posxbtn = 0
         then begin
            x0 := (maxx div 2)-(lx div 2);
            y0 := (maxy div 2)-(ly div 2);
         end else begin
            x0 := (posxbtn div 2)-(lx div 2);
            y0 := (maxy div 2)-(ly div 2);
         end;
         getimage  (x0,   y0,   x0+lx,   y0+ly, p^);

         setcolor        (c_t_boite_norm );
         setfillstyle (0, c_f_boite_norm );
         bar       (x0,   y0,   x0+lx,   y0+ly);
         rectangle (x0+1, y0+1, x0+lx-1, y0+ly-1);
         setcolor        (c_t_boite_inve );

         setfillstyle (1, c_f_boite_inve {c_t_boite_norm });

         bar       (x0+2, y0+2, x0+lx-2, y0+h-3);  { titre }
         settextjustify (1, 1);
         outtextxy (x0+lx div 2, y0+h div 2,      texte1);
         nn      := n;
         memy    := 0;
         affiche (lx, h, n, y);
         repeat until not unboutonsourisenfonce;
         repeat
            g := BoutonSourisEnfonce (BoutonGauche);
            d := BoutonSourisEnfonce (Boutondroit);
            compteursouris (cx, cy);
            cy   := cy div 2;
            clav;

            if cy <> 0
            then cy := cy + (cy div abs (cy)) * abs (memy)
            else cy := memy;

            n    := n + cy div ty;
            memy := cy mod ty;
            if n <  1   then   n  := 1;
            if n >  max then   n  := max;

            if n <> nn      { dplacement et slection dans la liste }
            then begin
               affiche (lx, h, n, y);
               nn := n
            end;
            if g              { modif  }
            then begin
               modif_ligne (n, modi);
               affiche (lx, h, n, y);
            end;
         until g or d;

         putimage (x0, y0, p^, 0);
         freemem  (p, taillep);
       end;
       { ancien_style; }
   end;                                                 { modifie_finfo }

{---------------------------------------------------------------------------}
procedure edite_info ( chemin  : pathstr; filtre  : namestr; extf : extstr);
   var
      texte1 : string;

   begin
      info_present := false;
      vide     := '';
      FSplit (chemin, Dirs, Noms, Exts);
      path     := concat (dirs, filtre+extf);
      finfo    := concat (dirs, noms, exts);
      GetCommand (path);
      FindFiles;
      texte1  := 'MODIFIER LE RESUME (ENTREE : modifier et valider)';
      lg_boite := length (texte1);
      modi     := false;
      if count > 0
      then begin
         Sortfiles;
         if not ftxt_present (finfo)
         then faire_info     (finfo);
         lire_info           (finfo, info_present);
         modifie_finfo       (texte1, finfo, lg_boite, modi)
      end{ else
         message ('pas de fichier '+filtre+' dans ce rpertoire !')} ;
      if modi
      then begin
         ecrire_info (finfo);
      end;
      liberedir;
   end;

{---------------------------------------------------------------------------}
procedure dir_info   (  comm   : string;
                       chemin  : pathstr;
                       filtre  : namestr;
                         extf  : extstr;
                     var nomf  : string  );

   procedure select_nomfinfo (texte1 : string;
                                   x : integer;
                             var rep : string);
      var
         p                     : pointer;
         y, lx, ly, h,
         nn, n, memy           : integer;
         taillep               : longint;

      begin
         repeat until not UnBoutonSourisEnfonce;
         (* setfillstyle (1, c_barre {colorf});
         bar (0, maxy-ty, maxx, maxy);
         nouveau_style (0, 0, 1);
         tx :=  8;
         ty := 12;    *)
         y  := count;
         max:= y;
         n  := 1;
         if y > 12 then y := 12;
         lx := x*tx  + 2*6;
         h  :=   ty  + 11;
         ly := h + ty*y + 2;
         taillep := imagesize (0, 0, lx, ly);

         if taillep < maxavail
         then begin
            laide ('Dplacer la slection avec la souris ou les flches puis valider');
            getmem (p, taillep);
            if posxbtn = 0
            then begin
               x0 := (maxx div 2)-(lx div 2);
               y0 := (maxy div 2)-(ly div 2);
            end else begin
               x0 := (posxbtn div 2)-(lx div 2);
               y0 := (maxy div 2)-(ly div 2);
            end;
            getimage  (x0,   y0,   x0+lx,   y0+ly, p^);

            setcolor        (c_t_boite_norm {colord});
            setfillstyle (0, c_f_boite_norm {colorf});
            bar       (x0,   y0,   x0+lx,   y0+ly);
            rectangle (x0+1, y0+1, x0+lx-1, y0+ly-1);
            setcolor        (c_t_boite_inve {colorf});
            setfillstyle (1, c_t_boite_norm {colord});
            bar       (x0+2, y0+2, x0+lx-2, y0+h-3);
            settextjustify  ( 1, 1);
            outtextxy (x0+lx div 2, y0 + 3+ ty div 2,      texte1);
            nn   := n;
            memy := 0;
            affiche (lx, h, n, y);
            repeat until not unboutonsourisenfonce;
            repeat
               g := BoutonSourisEnfonce (BoutonGauche);
               d := BoutonSourisEnfonce (Boutondroit);
               compteursouris (cx, cy);
               cy   := cy div 2;
               clav;
               if cy <> 0
               then cy := cy + (cy div abs (cy)) * abs (memy)
               else cy := memy;
               n    := n + cy div ty;
               memy := cy mod ty;
               if n <  1   then  n  := 1;
               if n >  max then  n  := max;
               if n <> nn
               then begin
                  affiche (lx, h, n, y);
                                 nn := n
               end;
            until d or g;

            if d then rep := ''
                 else rep := dir [n-1]^.name;

            putimage (x0, y0, p^, 0);
            freemem  (p, taillep);
            laide ('');
         end;
         { ancien_style; }
      end;

   procedure lire_liste;
      var
         i : integer;

      begin
         for i := 0 to count-1
         do begin
            nomf := dir [i]^.name;
            creeliste (nomf, i+1);
         end;
         creeliste ( '', count+1);
      end;

   begin                                           { procdure  dir_info }
      vide := '';
      info_present := false;
      FSplit (chemin, Dirs, Noms, Exts);
      path     := concat (dirs, filtre+extf);
      finfo    := concat (dirs, noms, exts);
      GetCommand (path);
      FindFiles;
      lg_boite := length (comm);
      if count > 0
      then begin
         Sortfiles;
         if Exists (finfo)
         then begin
            lire_info    (finfo, info_present);
            if info_present
            then
               select_nomfinfo (comm , lg_boite+1, nomf)
            else begin
               lire_liste;
               liste           ('', comm, '', 12, nomf, ind)
            end
         end else begin
            lire_liste;
            liste              ('', comm, '', 12, nomf, ind)
         end;
      end;
      liberedir;
   end;                                            { procdure  dir_info }

END.

{--- DIRINFO ----------------------------------------------------- 1995 ----}




