UNIT COUP_1;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module COUP                                         }
   {                                                                        }
   {                         menu FICHIERS                                  }
   {                                                                        }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   Dos,
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Dirinfo,                  { ARX     - gestion fichier INFO.DIR           }
   Periphs,                  { ARX     - Gestion priphriques              }
   Graphuti,                 { ARX     - utilitaires graphiques             }

   Grilles,                  { ARX     _ rcupration grilles rgulires    }

   GEO_var,                  { GEO     - variables globales communes        }
   GEO_des,                  { GEO     - procdures graph. communes         }

   COUP_VAR,                 { COUP    - variables globales du module       }
   COUP_INI,                 { COUP    - initialisations                    }
   COUP_CAL,                 { COUP    - calculs propres au module          }
   COUP_DES;                 { COUP    - affichages propres au module       }

Procedure voir_parametres;
   { afficher les listes dans une bote  dfilement                        }

Procedure supprimer_lien;
   { Supprimer une rfrence  un fichier "accessoire"                      }

Procedure modifier_lien;
   { Changer une rfrence  un fichier "accessoire"                        }

Procedure ouvrir_fichier;
   { slectionner un nom de fichier de paramtres existant dans le          }
   { rpertoire de travail (en cours) et rtablir l'environnement de        }
   { travail associ.                                                       }

Procedure nouveau_fichier;
   { slectionner un nouveau nom pour un nouveau fichier de paramtres      }
   { et rtablir l'environnement standard, vt  partir de COUP.CRT         }

Procedure enregistrer_fichier;
   { enregistre les paramtres en cours sans changer l'tat de l'cran.     }
   { enregistre aussi les donnes                                           }

Procedure enregistrer_sous;
   { copie les paramtres en cours dans un autre fichier                    }
   { copie aussi les donnes                                                }

Procedure quitter;
   { demander confirmation avant de stopper l'excution                     }


{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure voir_parametres;
   begin
      entier := 1;
      creeliste (c_Travail, 1);
      creeliste (c_Config,  2);

      liste     (l_params1, l_params2, l_params3, 35, chain, entier);
      case entier of
         1 : voir_ptrav;
         2 : voir_penv;
      end
   end;

procedure  FIC_DONNEES_contours;              { 1 }
   begin
      if visucontours
      then
         ajoute_contours (false, true);

      liberercontour;
      chang_contour;

      if visucontours
      then
         ajoute_contours (false, false);
   end;

procedure  FIC_DONNEES_noms;                  { 1 }
   begin
      liberer_noms;
      chang_noms;
      recalculer_toponymie_2d;
      effacer_tout_redessiner;
   end;

procedure  FIC_DONNEES_comm;                   { 1 }
   begin
      chang_comm (nomfcomm);
      effacer_tout_redessiner;
  end;

procedure  FIC_DONNEES_fond;                   { 1 }
   begin
      chang_fond (nomf_relief,    nomfd,  't*', nomffond);
      chang_fond (nomf_anomalies, nomfd2, 'g*', nomffong);
      effacer_tout_redessiner;
  end;

procedure modifier_lien;
   begin
      entier := 1;
      creeliste (c_contours      , 1);
      creeliste (c_toponymie     , 2);
      creeliste (c_comment       , 3);
      creeliste (c_fondcarte     , 4);
      liste (l_lien1, l_lien2, l_lien3, 35, chain, entier);
      case entier of
         1 : FIC_DONNEES_contours;              { 1 }
         2 : FIC_DONNEES_noms;                  { 1 }
         3 : FIC_DONNEES_comm;                  { 1 }
         4 : FIC_donnees_fond;
      end;
      modipar := true;
      inietat;
   end;

procedure  s_FIC_DONNEES_contours;              { 1 }
   begin
      visucontours := false;
      nomfcart := '';
      liberercontour;
   end;

procedure  s_FIC_DONNEES_noms;                  { 1 }
   begin
      { librer la collection }
      liberer_noms;
      nomftop     := '';
      visutoponym := false;
      ini_par_noms;
      dessine_tout (false);
   end;

procedure  s_FIC_DONNEES_comm;                  { 1 }
   begin
      { librer la collection }
      liberer_commentaires;

      { effacer}
      nomfcomm := '';
      visucomm := false;
      ini_par_COMM (nomfcomm + extcom); { commentaires }
      effacer_tout_redessiner;
   end;

procedure  s_FIC_DONNEES_fond;                  { 1 }
   begin
      nomffond := '';
      nomffong := '';
      effacer_tout_redessiner;
   end;

procedure supprimer_lien;
   begin
      entier := 1;
      creeliste (c_contours       , 1);
      creeliste (c_toponymie      , 2);
      creeliste (c_comment        , 3);
      creeliste (c_fondcarte      , 4);
      liste (s_lien1, s_lien2, s_lien3, 35, chain, entier);
      case entier of
         1 : s_FIC_DONNEES_contours;              { 1 }
         2 : s_FIC_DONNEES_noms;
         3 : s_FIC_DONNEES_comm;                  { 1 }
         4 : s_FIC_DONNEES_fond;                  { 1 }
      end;
      modipar := true;
      inietat;
   end;

procedure verif;
   begin
      ok := true;
      if (modipar or modipro) and not exempl
      then begin
         question (q_verif1, q_verif2, ok);
         if ok
         then
            if ((nomfpar <> nomdumodule))
            then begin
               if airlibre
               then
                  sauver_profils (dens)
               else
                  sauver_profils (0);
               ecrire_parametres (true);               { sauver_fichiers }
               modipar:= false;
            end else begin
               message (m_donner_nom);
               enregistrer_sous;
            end;
      end;
   end;

procedure ouvrir_fichier;
   var
      ok                : boolean;

   begin
      ok := visucomm or visutoponym;
      verif;
      efftout;                                                      { des }
      dir_info
         (choix_profil, '', nomutil,
          nomfinfo, '*', extPAR, nomfpar);
      nomfpar :=  sansext (nomfpar);
      if nomfpar = ''
      then
         nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      iniecran;                                                    { des }
      ini_noms;
      if ok
      then
         effacer_tout_redessiner
      else
         dessine_tout (false);
      ini_extrems;
   end;

procedure nouveau_fichier;
   var
      ok                : boolean;

   begin
      ok := visucomm or visutoponym;
      verif;
      efftout;
      nomfpar := nomdumodule;
      lire_parametres;
      inidonnees;
      iniecran;
      ini_noms;
      if ok
      then
         effacer_tout_redessiner
      else
         dessine_tout (false);
      ini_extrems;
   end;

procedure enregistrer_fichier;
   begin
      inietat ;
      if nomfpar = nomdumodule
      then
         nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      { enregistrer ou mettre  jour les fichiers de donnes dfinitifs }
      if ((nomfpar <> nomdumodule))
      then begin
         if airlibre
         then
            sauver_profils (dens)
         else
            sauver_profils (0);
         ecrire_parametres (true);
         modipar := false;
         modipro := false;
      end else
         message (m_donner_nom);
   end;

procedure enregistrer_sous;
   var
      ext               : extstr;

   begin
      inietat;
      ext     := extpar;
      ok      := false;
      if nomfpar = nomdumodule
      then
         nomfpar  := nomfdefo (nomdumodule, nomfpar, nomutil);

      nomfichier_sortie                                    { menus5 }
         (nomf_nouveau+' : (' +extpar+ ')', '', nomfpar, ext, ok);

      if (nomfpar = nomdumodule) and prof
      then begin
         ok := false;
         question (q_creer1, q_creer2, ok);
      end;

      if ((nomfpar <> nomdumodule) or prof) and ok
      then begin
         { enregistrer aussi les fichiers de donnes dfinitifs }
         if annotations <> nil
         then
            nomfcomm := nomfpar;

         if noms <> nil
         then
            nomftop  := nomfpar;

         inietat ;
         if airlibre
         then
            sauver_profils (dens)
         else
            sauver_profils (0);
         ecrire_parametres (true);
         modipar := false;
         modipro := false;
      end else
         message (m_lefichier+'  '+nomfpar+' '+m_lefichiers);
   end;

procedure quitter;
   begin
      question (q_quitter1, q_quitter2, fini);
      if fini
      then
         verif;
   end;


END.

{--- GEOCEAN - COUP_1 ------------------------ R.C.- INRP - TOULOUSE - 1993 }
