UNIT COUP_CAL;

   {------------------------------------------------------------------------}
   { Traitements, Fichiers      des coupes                                  }
   {                                                                        }
   {------------------------------------------------------------------------}

INTERFACE
{$O+,F+}

USES
   Dos,                      { Unit standard TP 7.0  Borland               }
   Graphism,                 { ARX     - initialisations graphiques         }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Graphplt,                 { ARX     - graphisme 2D cran/traceur         }
   Graphsg,                  { ARX     - symboles et graduations            }

   GRILLES,                  { ARX     - Lecture des grilles                }
   COUPES,                   { ARX     - Calcul des profils divers          }

   COUP_VAR,                 { COUP    - variables globales du module       }

   GEO_VAR;                  { GEO     - variables globales communes        }

CONST
   FinPoly              =  9999.99;

Procedure sauver_p2     (var p : pro2 ;     nomf : Pathstr; nbp : integer);
   { sauve un tableau simple P : deux valeurs.                              }

Procedure sauver_p3     (var p : pro3 ;     nomf : Pathstr; nbp : integer);
   { sauve le tableau trait P : 3 valeurs                                  }

Procedure sauver_bln2   (var p : pro2 ;     nomf : Pathstr; nbp : integer);
   { sauve le tableau P au format .BLN.                                     }

Procedure sauver_bln3   (var p : pro3 ;     nomf : Pathstr; nbp : integer);
   { sauve les 2 premires col du tableau P au format .BLN.                 }

Procedure sauver_anom   (var p1, p2 : pro3; nomf : Pathstr; nbp : integer);
   { fusionne et sauve les tableaux  p1 et p2                               }

Procedure sauver_corps  (nomf : Pathstr; nbc : integer; dens : real);
   { sauve nbc polygones  dfinis dans POLY et LPOLY                        }

Procedure sauver_profils (dens : real);
   { sauve tous les profils                                                 }

Procedure recup_p2      (var pro : pro2 ; nomf : Pathstr; var nbp : integer);
   { lit un tableau simple P : deux valeurs.                                }

Procedure recup_p3      (var pro : pro3 ; nomf : Pathstr; var nbp : integer);
   { lit le tableau trait P : 3 valeurs                                    }

Procedure recup_bln2    (var pro : pro2 ; nomf : Pathstr; var nbp : integer);
   { affecte le tableau P depuis un fichier au format .BLN.                 }

Procedure recup_bln3    (var pro : pro3 ; nomf : Pathstr; var nbp : integer);
   { affecte les 2 premires col du tableau P  depuis un  .BLN.             }

Procedure recup_profils;
   { lit  les fichiers profils et affecte les variables en mmoire          }

Procedure visu_corps    (poly : pro2 ; nbc : integer; co : word);
   { Dessine les corps extraits du profil topo rduit                       }

Procedure visu_l2       (var pro : pro2; nbp : integer; co : word);
   { Affiche la ligne dfinie dans les 2 premires colonnes                 }

Procedure visu_l3       (var pro : pro3; nbp : integer; co : word);
   { Affiche la ligne dfinie dans les 2 premires colonnes                 }

Procedure visu_p2       (var pro : pro2; nbp, hauts : integer; co : word);
   { Affiche les points dfinis dans les 2 premires colonnes               }

Procedure visu_p3       (var pro : pro3; nbp : integer; co : word);
   { Affiche les points dfinis dans les 2 premires colonnes               }

Procedure coupe_sismi   (ox, oy, ex, ey : real);
   { projection 2 valeurs ponctuelles                                       }

Procedure coupe_gravi   (ox, oy, ex, ey : real);
   { coupe grille                                                           }

Procedure coupe_topo    (ox, oy, ex, ey : real);
   { coupe grille                                                           }

Procedure coupe_corps   (nbst : integer; var nbc : integer);
   { gnre un fichier CORPS  partir d'un tableau topo rduit.             }

   {------------------------------------------------------------------------}

IMPLEMENTATION

VAR
   fpro                 : text;

procedure sauver_p2 (var p : pro2 ; nomf : Pathstr; nbp : integer);
   { sauve un tableau simple P : deux valeurs.}
   var
      i                 : integer;

   begin
      assign  (fpro, nomf);
      rewrite (fpro);
      FOR i := 1 TO nbp
      DO begin
         Write   (fpro, p [i, 1]:8:3,' ',p [i, 2]:8:3);
         writeln (fpro);
      end;
      close (fpro);
   end;

procedure sauver_p3 (var p : pro3 ; nomf : Pathstr; nbp : integer);
   { sauve le tableau trait P : 3 valeurs               }
   var
      i                 : integer;
{}    coef              : real;

   begin
      coef := 1;
      assign  (fpro, nomf);
      rewrite (fpro);
      FOR i := 1 TO nbp
      DO begin
         Write (fpro,      p [i, 1]:8:3);
         write (fpro, ' ', p [i, 2]*coef:8:2);
         write (fpro, ' ', p [i, 3]:8:2);
         writeln (fpro, ' ');
      end;
      close (fpro);
   end;

procedure sauver_bln2 (var p : pro2 ;nomf : Pathstr;  nbp : integer);
   { sauve le tableau P au format .BLN. : 1 seule ligne                 }
   var
      i                 : integer;

   begin
      assign  (fpro, nomf);
      rewrite (fpro);
      writeln (fpro, nbp, ' BATH  ');
      for i := 1 to nbp
      do
         writeln (fpro, p [i, 1]:8:3, ' ', p [i, 2]:8:3, ' ');
      close (fpro)
   end;

procedure sauver_bln3 (var p : pro3 ; nomf : Pathstr; nbp : integer);
   { sauve les 2 premires col du tableau P au format .BLN. 1 seule ligne  }
   var
      i                 : integer;

   begin
      assign  (fpro, nomf);
      rewrite (fpro);
      writeln (fpro, nbp, ' BATH  ');
      for i := 1 to nbp
      do
         writeln (fpro, p [i, 1]:8:3, ' ', p [i, 2]:8:3, ' ');
      close (fpro)
   end;


procedure sauver_anom (var p1, p2 : pro3; nomf : Pathstr; nbp : integer);
   { fusionne et sauve les tableaux rduits p1 et p2  }
   var
      i                 : integer;
      alt               : real;

   begin
      assign  (fpro, nomf);
      rewrite (fpro);
      for i := 1 to nbp
      do begin
         Write (fpro,      p1 [i, 1]:8:3);     { distance station/origine }
         alt := p1 [i, 2] * -1;
         if alt > 0
         then alt := 0;   { bathymtrie > 0  }
         write (fpro, ' ', alt:8:2);
         write (fpro, ' ', p2 [i, 2]:8:2);     { anomalie         }
         write (fpro, ' ', p2 [i, 3]:8:2);     { cart type       }
         writeln (fpro, ' ');
      end;
      close (fpro)
   end;

procedure sauver_corps (nomf : Pathstr; nbc : integer; dens : real);
   var
      nbp, n, pp        : integer;

   { sauve les polygones             }
   procedure sauverpoly (n, p, d : integer ; de : real);
      var
         lg, pr         : real;
         i              : integer;

      begin
         for i := p to d
         do begin
            lg := poly [i, 1];
            pr := (poly [i, 2]) * -1; { pour conserver compatibilit Grammag }
            writeln (fpro, lg:10:2, pr:10:2);
         end;
         writeln (fpro, finpoly:10:2, finpoly:10:2);
         writeln (fpro, de:9:2, n:7, ' ');
      end;

   begin
      assign  (fpro, nomf);
      rewrite (fpro);
      writeln (fpro, ' ', nbc, ' ');
      n  := 0;
      pp := 1;
      for n := 1 to nbc
      do begin
         nbp := lpoly [n, 1];
         sauverpoly (n, pp, pp+nbp-1, dens);
         pp    := pp+nbp
      end;
      close (fpro)
   end;

procedure sauver_profils (dens : real);
   begin
      laide (la_sauve);
      if sis
      then
         { sauve profil sismique au format DAT }
         SAUVER_p3    (pro_sis, nomfpar+extsis, nbpts_s);

      if anom
      then begin
         { sauve un fichier d'anomalies pour GRAV au format GRAMMAG }
         SAUVER_anom  (pro_c1, pro_c2, nomfpar+extgra, nbst);

         { sauve polygones EAU     pour GRAV au format GRAMMAG }
         SAUVER_corps (                nomfpar+extgam, nbcorps, dens);

         message (m_complet) ;
      end else
         message3 (m1_impossible, m2_impossible, m3_impossible);

      (*
      if prof and top
      then
          { sauve profil topo brut au format BLN}
         SAUVER_bln2  (pro_l1,  nomfpar+extbln, nbpts_t);

      if prof and gra
      then
          { sauve profil d'anomalies brut au format BLN}
         SAUVER_bln2  (pro_l2,  nomfpar+extblg, nbpts_g);*)
      laide ('');
   end;

procedure recup_p2   (var pro : pro2 ; nomf : Pathstr; var nbp : integer);
   { sauve un tableau simple P : deux valeurs.}
   var
      l, z              : real;

   begin
      if not ftxt_present (nomf) then exit;
      assign (fpro, nomf);
      reset  (fpro);
      nbp := 0;
      while  (not (eof (fpro)))
      do begin
         inc (nbp);
         readln (fpro, l, z);
         pro [nbp, 1] := l;
         pro [nbp, 2] := z;
      end;
      close (fpro);
   end;

procedure recup_p3   (var pro : pro3 ; nomf : Pathstr; var nbp : integer);
   { sauve le tableau trait P : 3 valeurs               }
   var
      l, z, m           : real;

   begin
      if not ftxt_present (nomf) then exit;
      assign (fpro, nomf);
      reset  (fpro);
      nbp := 0;
      while  (not (eof (fpro)))
      do begin
         inc (nbp);
         readln (fpro, l, z, m);
         pro [nbp, 1] := l;
         pro [nbp, 2] := z;
         pro [nbp, 3] := m;
      end;
      close (fpro);
   end;

procedure recup_bln2 (var pro : pro2 ; nomf : Pathstr; var nbp : integer);
   { sauve le tableau P au format .BLN.                    }
   var
      i                 : integer;
      l, p              : real;
      typ               : t12;

   begin
      if not ftxt_present (nomf) then exit;
      assign  (fpro, nomf);
      reset   (fpro);
      while (not (eof (fpro)))
      do begin                                  { lire une ligne }
         readln (fpro, nbp, typ);               { lire entte    }
         if nbp > 1
         then begin
            i := 0;
            while  (not (eof (fpro))) and (i < nbp)
            do begin
               inc (i);
               readln (fpro, l, p);
               pro [i, 1] := l;
               pro [i, 2] := p;
            end;
         end
      end;
      nbp := i;                { = si tout va bien ! }
      close (fpro);
   end;

procedure recup_bln3 (var pro : pro3 ; nomf : Pathstr; var nbp : integer);
   { sauve les 2 premires col du tableau P au format .BLN.                    }
   var
      i                 : integer;
      l, p              : real;
      typ               : t12;

   begin
      if not ftxt_present (nomf) then exit;
      assign  (fpro, nomf);
      reset   (fpro);
      while (not (eof (fpro)))
      do begin                                  { lire une ligne }
         readln (fpro, nbp, typ);               { lire entte    }
         if nbp > 1
         then begin
            i := 0;
            while  (not (eof (fpro))) and (i < nbp)
            do begin
               inc (i);
               readln (fpro, l, p);
               pro [i, 1] := l;
               pro [i, 2] := p;
               pro [i, 3] := 0;
            end;
         end
      end;
      nbp := i;                { = si tout va bien ! }
      close (fpro);
   end;

procedure recup_profils;
   begin
      laide  (la_lit_pro);
      if sis
      then
         recup_p3    (pro_sis, nomfpar+extsis, nbpts_s);
     { if top  then recup_bln2  (pro_l1,  nomfpar+extbln, nbpts_t);
      if gra  then recup_bln2  (pro_l2,  nomfpar+'.Blg', nbpts_g); }
      laide  (' ');
   end;

procedure visu_corps (poly : pro2 ; nbc : integer; co : word);
   var
      nbp, n, pp        : integer;

   procedure desspoly (n, p, d : integer);
      var
         lg, pr         : real;
         i              : integer;

      begin
         deplaceen (poly [p, 1], poly [p, 2]);
         for i := p+1 to d
         do begin
            lg := poly [i, 1];
            pr := poly [i, 2];
            tracevers (lg, pr);
         end;
      end;

   begin
      n  := 0;
      pp := 1;
      fixecoul (co);
      for n := 1 to nbc
      do begin
         nbp := lpoly [n, 1];
         desspoly (n, pp, pp+nbp-1);
         pp    := pp+nbp
      end;
   end;

procedure visu_p2  (var pro : pro2; nbp, hauts : integer; co : word);
   var
      i                 : integer;
      l, z              : real;

   begin
      for i := 1 to nbp
      do begin
         l := pro [i, 1];
         z := pro [i, 2];
         deplaceenl (l, z);
         dessymb (3, codask, hauts, c_sismi);
      end;
   end;

procedure visu_p3  (var pro : pro3; nbp : integer; co : word);
   var
      i                 : integer;
      h_s, l, z, m      : real;

   begin
      for i := 1 to nbp
      do begin
         l := pro [i, 1];
         z := pro [i, 2];
         m := pro [i, 3];
         deplaceenl (l, z);
         h_s := hmin + (hmax - hmin) * (m - 4) / (9 - 4);
         { recalculer la hauteur du symbole en fonction de m }
         dessymb (3, codask, h_s, co);
      end;
   end;

procedure visu_l2  (var pro : pro2; nbp : integer; co : word);
   var
      i                 : integer;
      l, p              : real;

   begin
      fixecoul (co);
      for i := 1 to nbp
      do begin
         l := pro [i, 1];
         p := pro [i, 2];
         while (p >= v_indef) and (i < nbp)
         do begin
            inc (i);
            l := pro [i, 1];
            p := pro [i, 2];
         end;
         if p < v_indef then deplaceen (l, p);
         while (p <  v_indef) and (i < nbp)
         do begin
            inc (i);
            l := pro [i, 1];
            p := pro [i, 2];
            if p < v_indef then tracevers (l, p);
         end
      end;
   end;

procedure visu_l3  (var pro : pro3; nbp : integer; co : word);
   var
      i                 : integer;
      l, p              : real;

   begin
      fixecoul (co);
      for i := 1 to nbp
      do begin
         l := pro [i, 1];
         p := pro [i, 2];
         while (p >= v_indef) and (i < nbp)
         do begin
            inc (i);
            l := pro [i, 1];
            p := pro [i, 2];
         end;

         if p < v_indef
         then
            deplaceen (l, p);

         while (p <  v_indef) and (i < nbp)
         do begin
            inc (i);
            l := pro [i, 1];
            p := pro [i, 2];
            if p < v_indef
            then
               tracevers (l, p);
         end
      end;
   end;

procedure coupe_sismi (ox, oy, ex, ey : real );
   begin
      sis := true;
      PROJETER (visucontours, chemindonnees+nomfd3+extsis,
                3, ox, oy, ex, ey, larg, coefx, -1, c_sismi,
                pro_sis, nbpts_s, longpro, minsismi, maxsismi);

      TRIER3 (pro_sis, nbpts_s);
      if maxsismi = minsismi
      then
         maxsismi := maxsismi +10;
      ech1  :=  (cp4-cp3) / (cp2-cp1) * longpro / abs (maxsismi - minsismi);
   end;

procedure coupe_topo (ox, oy, ex, ey   : real);
   begin
      top := true;

      COUPER (visucontours, {non vite }false, lagrille, coefx, 1/1000, ox, oy, ex, ey, c_topo,
              pro_l1, nbpts_t, longpro, mintopo, maxtopo);

      if (nbpts_t > 1) and (maxtopo > mintopo)
      then begin
         REDUIRE (pro_l1, pro_c1, longpro, pas, dom, nbpts_t, false, nbst);

         ech2  :=  (ct4-ct3) / (ct2-ct1) * longpro / abs (maxtopo  - mintopo);
      end;
   end;

procedure coupe_gravi (ox, oy, ex, ey : real);
   begin
      gra := true;

      COUPER (visucontours, false, lagrill2, coefx, 1, ox, oy, ex, ey, c_gravi,
              pro_l2, nbpts_g, longpro, ming, maxg);
                                                         { ecartype }
      if (nbpts_g > 1) and (maxg > ming)
      then begin
         REDUIRE (pro_l2, pro_c2, longpro, pas, dom, nbpts_g, true, nbst);

         ech3  :=  (cg4-cg3) / (cg2-cg1) * longpro / abs (maxg     - ming);
      end;
   end;

procedure coupe_corps (nbst : integer; var nbc : integer);
   begin
      extraire_corps (pas, pro_c1, poly , lpoly , nbst, nbc);
                  { topo rduite }
   end;


END.

{ GEOCEAN - COUP_CAL -------------------------------- INRP - TOULOUSE - ARX }
