UNIT COUP_INI;

   {------------------------------------------------------------------------}
   { logiciel GEOCEAN - module COUPES                                       }
   {                                                                        }
   {                          initialisations                               }
   {                                                       12/02/95         }
   {------------------------------------------------------------------------}

INTERFACE

{$O+,F+}

USES
   dos, crt, graph,          { TP 70   - unit  standard                    }
   Lipar,                    { ARX     - gestion fichiers paramtres        }
   Graphism,                 { ARX     - initialisations graphiques         }
   GraphUti,                 { ARX     - utilitaires graphiques             }
   Dirinfo,                  { ARX     - gestion fichier INFO.DIR           }
   Periphs,                  { ARX     - Gestion priphriques              }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Fichiers,                 { ARX     - Gestion des fichiers et erreurs    }
   Icones,                   { ARX     - gestion de icnes                  }
   Menus,                    { ARX     - interface menus                    }

   GRILLES,                  { ARX     - lecture des grilles                }

   GEO_VAR,                  { GEO     - variables globales communes        }
   GEO_DES,                  { GEO     - procdures graph. communes         }

   COUP_VAR,                 { COUP    - variables globales du module       }
   COUP_CAL,                 { COUP    - Calculs popres au module           }
   COUP_DES;                 { COUP    - affichages propres au module       }

Procedure iniparam;
   { initialise les paramtres de configuration  du programme.              }

Procedure iniparam2;
   { initialise les paramtres de travail                                   }

Procedure inidonnees;
   { charge les fichiers de donnes                                         }

Procedure ini_noms;
   { charge et recalcule les coordonnes des noms                           }

Procedure inimenus;
   { initialise les paramtres de l'interface MENUS.                        }

Procedure modif_menus;
   { modifie le texte des menus en fonction des paramtres initiaux         }

Procedure iniIcones;
   { initialise les pointeurs sur les icnes                                }

Procedure inversemenus;
   { inverse MENUS LONGS/COURTS                                             }

Procedure iniaide;
   { initialise les paramtres du fichier d'aide.                           }

Procedure fin;
   { restaure l'cran texte.                                                }

Procedure lire_parametres;
   { Procedure ini_par_trv (nomf : string); }
   { initialisation des paramtres de travail                               }
   { Procedure ini_par_symb (nomf : string);  }
   { initialisation des paramtres d'un ensemble de symboles reprsentant
     un fichier de donnes }

Procedure ecrire_parametres (resume : boolean);
   { Enregistre les paramtres de travail en cours
                               des symboles
                               des commentaires
        si RESUME   met  jour INFO.DIR    }

Procedure voir_ptrav;
   { visualise la liste  complte des paramtres du travail en cours        }

Procedure chang_seismes;
   { }

Procedure chang_fond (comm : chainecar; nomdef, filtr : namestr ; var nomf : dirstr);
   { }
{---------------------------------------------------------------------------}

IMPLEMENTATION


procedure iniIcones;
   begin
      laide (La_lit_icones);
      if ftxt_present (cheminmodule+nomdumodule+exticn)
      then begin
         ActiveListeIcones (cheminmodule+nomdumodule+exticn)                  { ICONES };
         def_icones;
      end else begin
         message (m_not_icones);
         halt;
      end;
      laide ('');
   end;

procedure voir_ptrav;
   begin
      params.boite;                                                 { lipar }
      bte_compl (t_btepar, -1, -1, nbc, nbo, 0, 10);{ menu6 }
   end;

procedure ini_par_trv  (nomf : pathstr);
   begin
      params.init (false);
   { configuration donnes : modifiables par l'installateur }
      params.ajoute (Cstring  ('fichier de donnes 1'   , @nomfd    , '' ));
      params.ajoute (Cstring  ('fichier de donnes 2'   , @nomfd2   , '' ));
      params.ajoute (Cstring  ('fichier de donnes 3'   , @nomfd3   , '' ));
      params.ajoute (Cstring  ('unit des grilles'      , @unite    , 'degrs'));
      params.ajoute (Cstring  ('unit longueur profil'  , @unitl    , 'km'));
      params.ajoute (Cstring  ('unit anomalie'         , @unitg    , 'mgal'));
      params.ajoute (Cstring  ('fichier contours'       , @nomfcart , '' ));
      params.ajoute (Creal    ('abs g carte'            , @cor1     , 0  ));
      params.ajoute (Creal    ('abs d carte'            , @cor2     , 0  ));
      params.ajoute (Creal    ('ord b carte'            , @cor3     , 0  ));
      params.ajoute (Creal    ('ord h carte'            , @cor4     , 0  ));
      params.ajoute (Cstring  ('titre'                  , @titre    , '' ));
      params.ajoute (Cstring  ('libell axe x carte'    , @titr1    , unite));
      params.ajoute (Cstring  ('libell axe y carte'    , @titr2    , unite));
      params.ajoute (Cstring  ('libell axe z profil 1' , @titrz1   , unitl));
      params.ajoute (Cstring  ('libell axe z profil 2' , @titrz2   , unitl));
      params.ajoute (Cstring  ('libell axe z profil 3' , @titrz3   , unitg));

      params.ajoute (Cstring  ('texte grad. intrieure' , @unitxy   , unite));
   {  params.ajoute (Cstring  ('texte grad. int. Z1   ' , @unitz    , 'mtres'  ));}

   { autres params : modifiables par l'utilisateur }
   { carte }
      params.ajoute (Cinteger ('abs gauche cloture'     , @cc1     ,    0 ));
      params.ajoute (Cinteger ('abs droite cloture'     , @cc2     ,    0 ));
      params.ajoute (Cinteger ('ord basse  cloture'     , @cc3     ,    0 ));
      params.ajoute (Cinteger ('ord haute  cloture'     , @cc4     ,    0 ));
      params.ajoute (Creal    ('abs gauche fenetre'     , @fc1     , -190 ));
      params.ajoute (Creal    ('abs droite fenetre'     , @fc2     , +190 ));
      params.ajoute (Creal    ('ord basse  fenetre'     , @fc3     ,  -90 ));
      params.ajoute (Creal    ('ord haute  fenetre'     , @fc4     ,  +90 ));

   { profil en cours }
      params.ajoute (Creal    ('abs origine'            , @x1      ,    0 ));
      params.ajoute (Creal    ('ord origine'            , @y1      ,    0 ));
      params.ajoute (Creal    ('abs extrmit'          , @x2      ,    0 ));
      params.ajoute (Creal    ('ord extrmit'          , @y2      ,    0 ));
      params.ajoute (Cinteger ('abs gauche cloture p'   , @cp1     ,   10 ));
      params.ajoute (Cinteger ('abs droite cloture p'   , @cp2     ,  500 ));
      params.ajoute (Cinteger ('ord basse  cloture p'   , @cp3     ,  100 ));
      params.ajoute (Cinteger ('ord haute  cloture p'   , @cp4     ,  200 ));
      params.ajoute (Cinteger ('abs gauche cloture p2'  , @ct1     ,   10 ));
      params.ajoute (Cinteger ('abs droite cloture p2'  , @ct2     ,  500 ));
      params.ajoute (Cinteger ('ord basse  cloture p2'  , @ct3     ,  210 ));
      params.ajoute (Cinteger ('ord haute  cloture p2'  , @ct4     ,  300 ));
      params.ajoute (Cinteger ('abs gauche cloture p3'  , @cg1     ,   10 ));
      params.ajoute (Cinteger ('abs droite cloture p3'  , @cg2     ,  500 ));
      params.ajoute (Cinteger ('ord basse  cloture p3'  , @cg3     ,  310 ));
      params.ajoute (Cinteger ('ord haute  cloture p3'  , @cg4     ,  400 ));
      params.ajoute (Creal    ('Largeur de la bande'    , @larg    ,   15 ));
      params.ajoute (Creal    ('distance entre stations', @pas     ,   30 ));
 {    params.ajoute (Creal    ('coefficient Z'          , @coefz   ,    1 ));}
      params.ajoute (Cinteger ('nombre de stations'     , @nbst    ,    0 ));
      params.ajoute (Creal    ('longueur du profil'     , @longpro ,    0 ));
      params.ajoute (Creal    ('minimum sismi'          , @minsismi,    0 ));
      params.ajoute (Creal    ('maximum sismi'          , @maxsismi,    0 ));
      params.ajoute (Creal    ('minimum topo'           , @mintopo ,    0 ));
      params.ajoute (Creal    ('maximum topo'           , @maxtopo ,    0 ));
      params.ajoute (Creal    ('minimum gravi'          , @ming    ,    0 ));
      params.ajoute (Creal    ('maximum gravi'          , @maxg    ,    0 ));
      params.ajoute (Cboolean ('anomalies airlibre'     , @airlibre, true ));
      params.ajoute (Cboolean ('profils sismi Echelle1' , @echelle1, false));
      params.ajoute (Cboolean ('profils sismiques'      , @sismi   , false));
      params.ajoute (Cboolean ('profil sismique calcul', @sis     , false));
      params.ajoute (Cboolean ('profils topographiques' , @topo    , false));
      params.ajoute (Cboolean ('profil topo calcul'    , @top     , false));
      params.ajoute (Cboolean ('profils gravimtriques' , @gravi   , false));
      params.ajoute (Cboolean ('profil gravi calcul'   , @gra     , false));
      params.ajoute (Cboolean ('fic. anomalies calcul' , @anom    , false));

   { affichages divers }
      params.ajoute (Cboolean ('profils superposs'     , @compare , false));
      params.ajoute (Cboolean ('commentaires visibles'  , @visucomm, false));
      params.ajoute (Cboolean ('toponymie visibles'     , @visutoponym, false));
      params.ajoute (Cboolean ('symboles visibles'      , @visusymb, true));
      params.ajoute (Cboolean ('profil sismi visible'   , @visu1   , false));
      params.ajoute (Cboolean ('profil topo visible'    , @visu2   , false));
      params.ajoute (Cboolean ('profil gravi visible'   , @visu3   , false));
      params.ajoute (Cword    ('couleur trace'          , @c_trace ,   12 ));
      params.ajoute (Cword    ('couleur fond profil'    , @c_fpro  ,    3 ));
      params.ajoute (Cword    ('couleur sismi'          , @c_sismi ,   11 ));
      params.ajoute (Cword    ('couleur bathy'          , @c_topo  ,   10 ));
      params.ajoute (Cword    ('couleur gravi'          , @c_gravi ,    9 ));
      params.ajoute (Cword    ('couleur corps'          , @c_corps ,   12 ));

   { symboles sismes }
      params.ajoute (Cinteger ('code symbole sismes'   , @codask  ,   32 ));
      params.ajoute (Creal    ('hauteur mini'           , @hmin    ,    1 ));
      params.ajoute (Creal    ('hauteur maxi'           , @hmax    ,    6 ));

   { toponymie }
      params.ajoute (Cstring  ('nom fichier toponymie'  , @nomftop, region));
      params.ajoute (Creal    ('hauteur texte'          , @haut_t ,     3 ));
      params.ajoute (Cword    ('couleur symboles'       , @coul_t ,     2 ));
      params.ajoute (Cword    ('couleur etiquettes'     , @coul_e ,    11 ));
      params.ajoute (Cword    ('couleur courbes'        , @coul_c ,     9 ));

   { commentaires associs }
      params.ajoute (Cstring  ('nom fichier commentaires', @nomfcomm,  '' ));

   { fond de carte }
      params.ajoute (Cstring  ('nom fichier fond topo',   @nomffond,   '' ));
      params.ajoute (Cstring  ('nom fichier fond gravi',  @nomffong,   '' ));
      params.ajoute (Creal    ('hauteur tiquettes',      @heti,        2 ));

      if ftxt_present (nomf)
      then
         params.lit (nomf);

      if exempl
      then begin
         if nomffond <> ''
         then
            nomffond := chemindonnees+nomffond;
         if nomffong <> ''
         then
            nomffong := chemindonnees+nomffong;
      end;

      traitgrille  :=  3 ;  { non utilis }
      inter_xy     :=  1 ;
      nbdec_xy     :=  0 ;
      nbti_xy      :=  4 ;
      htir_xy      :=  3 ;
      hcar_xy      :=  3 ;  { ini bidons : graduation auto obligatoire }

      dens         := 1.03;
      visugrad     := false;
      legend       := true;            { affichage lgendes des profils  }
      reduc        := true;            { affichage rduit }
      visucarte    := true;
      align_t      := 1;
      nbpg_t       := 0;
      fond_t       := false;
      deux_d       := true;
      visufond     := false;
   end;

procedure ecrire_parametres (resume : boolean);
   var
      echpro         : boolean;

   begin
      recadrer_profils (false);
      laide  (La_Ecr_par);
      nomfcomm := nomfpar;
      if nomftop <> ''
      then
         nomftop := nomfpar;

      chain := '';
{      if (prof and (nomfpar = nomdumodule))
      then
         chain := chemindonnees;}
      params .ecrit (chain+nomfpar + extpar, datjour+ ' ' +nomutil);
      { travail en cours }

      if echelle1
      then
         recadrer_profils (true);

      ecrit_par_COMM  (chain+nomfcomm + extcom);
          { commentaires }

      ecrit_par_noms  (nomftop+exttop);
          { toponymie }

      if resume
      then
         edite_info    (nomfinfo, nomfpar, extpar);
      laide  ('');
   end;

procedure chang_fond (comm : chainecar; nomdef, filtr : namestr ; var nomf : dirstr);
   var
      nomi,
      d                 : dirstr;
      n                 : namestr;
      e                 : extstr;
      c                 : integer;

   begin
      nomi := nomf;  { nom initial }

      fsplit (nomf, d, n, e );      { abstraire chemin }
      if n = ''
      then
         nomf := nomdef;

      dir_info                                               { dirinfo }
         (donnees_util,
          Choix_fond + ' '+comm,
          donnees_ini2,
         nomfinfo, '*', extblf, chain);

      fsplit (chain, d, n, e );
      if n <> ''
      then begin                 {  un fichier existe localement }

         nomf := n;

      end else begin             {  rechercher dans les donnes  }
         if nomi = ''
         then
            nomf := chemindonnees+nomdef;

         if not exists (nomf+extblf)   { nom par dfaut }
         then begin
            dir_info                                               { dirinfo }
               (Donnees_ini,
                '',
                Choix_fond+ ' ' + comm,
                chemindonnees+nomfinfod, filtr, extblf, chain);

            fsplit (chain, d, n, e );
            if n <> ''
            then                   { else pas de changement }
                nomf := chemindonnees+n;
         end;
      end;
   end;

procedure ini_fonds_cartes;
   begin
      if not exists (nomffond+extblf)
      then
         chang_fond (nomf_RELIEF, nomfd,  't*', nomffond);

      if not exists (nomffong+extblf)
      then
         chang_fond (nomf_ANOMALIES, nomfd2, 'g*', nomffong);

      visufond := (nomffond <> '') or (nomffong <> '');
   end;

procedure lire_parametres;
   begin
      laide  (La_lit_par);
      chain := '';
      if (maj (nomfpar) = nomdumodule)
          and not exists (nomfpar+extpar)
      then
         chain := chemindonnees;

      ini_par_TRV  (nomfpar + extpar) ; { charger les paramtres de travail }

      if titre    = ''
      then
         titre    := maj (region);

      if nomfcomm = ''
      then
         nomfcomm := nomfpar;

      ini_par_COMM (chain+nomfcomm + extcom); { commentaires }

      laide ('');
   end;

procedure iniparam;
   var
      chem, chemp       : dirstr;
      nomf              : namestr;
      ext               : extstr;

   begin
      help_txt_enligne (paramstr (1));
      { charger la configuration d'ensemble de GEOC }
      lire_utilisateur (paramstr (0));

      exempl := numeromaxi (cheminexemples+region+'\*'+extpar) > 0;
                                                   { rgion + fichiers }

      chemindonnees := chemindonnees+region+'\';

      chemp      := '';
      nomfpar    := nomdumodule;
      if paramcount > 0
      then
         chemp := paramstr (1);
      if chemp <> ''                { chercher le nom du fichier de travail }
      then begin
         fsplit (chemp, chem, nomf, ext);
         nomfpar := nomf;
      end;

      { charger la configuration d'ensemble de GEOC }
      { sans deuxime paramtre : config GEOCEAN }
      { avec deuxime  si <> geocean chemin et nom ok
                       sinon         config GEOCEAN }

      chemincfg  := cheminmodule;
      nomfcfg    := nomlogiciel;
      if paramcount > 1
      then
         chemp := paramstr (2);
      if chemp <> ''                { chercher le nom du chemin des donnes }
      then begin
         fsplit (chemp, chem, nomf, ext);
         if (nomf <> '') and (maj (nomf) <> nomlogiciel)
         then begin
            nomfcfg := nomf;
            if chem <> ''
            then
               chemincfg := chem
         end;
      end;
      complete (chemincfg);
      { charger la configuration d'ensemble de GEOC }
      ini_par_cfg (chemincfg+nomfcfg+extcfg);
      { si le fichier n'est pas trouv : paramtres par dfaut }

      { affecter rpertoire configuration graphique   }
      repbgi     := maj (getenv (NomBgi));
      if repbgi = ''
      then
         repbgi := cheminmodule;
      complete (repbgi);                       { ajoute ventuellement un \ }

   end;

procedure iniparam2;
   begin
      fini     := false;
      prof     := false;
      lire_parametres;
   end;

procedure chang_seismes;
   begin
      dir_info                                                  { dirinfo }
         ('', nomf_seismes, '',
          chemindonnees+nomfinfod, 'SEISM*', '.DAT', nomfd3);
      nomfd3 :=  sansext (nomfd3);
      if nomfd3 = ''
      then
         message (m_not_seism);
    {  visusymb    := (nomfd3  <> '') and visusymb;}
    end;

procedure inidonnees;
   var
      i                 : integer;
      nompro            : pathstr;

   begin
      chain := '';
      if (maj (nomfpar) = nomdumodule)
      then
         chain := chemindonnees;
      { charger les valeurs  reprsenter }
      if ftxt_present (chemindonnees+nomfd+extgrd)
      then
         lire_grille (Lagrille, nomfd)
      else begin
         i := 0;
         repeat
            inc (i);
            chang_grille (donnees_ini,
                          '' ,
                          choix_top_bat,
                          'topo',
                          Lagrille, nomfd);
         until (nomfd <> '') or (i>2);

         if nomfd = ''
         then begin
            message (m_not_topo);
            finir;
            halt;
         end
      end;

      { charger les valeurs  reprsenter }
      if ftxt_present (chemindonnees+nomfd2+extgrd)
      then
         lire_grille (Lagrill2, nomfd2)
      else begin
         i := 0;
         repeat
            inc (i);
            chang_grille (Donnees_ini,
                          '',
                          choix_gravi,
                          'grav',
            Lagrill2, nomfd2);
         until (nomfd2 <> '') or (i>2);
         if nomfd = ''
         then begin
            message (m_not_gravi);
            finir;
            halt;
         end
      end;
      airlibre := (nomfd2 = 'GRAV_AL') or (nomfd2 = 'GRAV_AB') ;
      nompro := nomffong;
      if not (ftxt_present (chemindonnees+nomfd3+extsis))
      then
         chang_seismes;
      nomffong := nompro;
      { charge le fichier de contours     }
      if ftxt_present (nomfcart+extbln)
      then
         lire_contour (nomfcart+extbln)
      else
         if ftxt_present (chemindonnees+nomfcart+extbln)
         then
            lire_contour (chemindonnees+nomfcart+extbln)
         else
            chang_contour;
      laide   ('');
      ini_fonds_cartes;


      {if not (ftxt_present (chemindonnees+nomftop+exttop))
      then begin
         chain := nomftop;
         chang_toponym (chain);
         nomftop := chain;
      end; }
   end;

procedure ini_noms;
   begin
      ini_par_noms;
      if  (ftxt_present (nomftop+exttop))
      then begin
         Noms^.lit      (nomftop+exttop, true);
         Noms^.modifier (nbpg_t, coul_t, haut_t);
      end else begin
        { if  (ftxt_present (chemindonnees+nomftop+exttop))
         then begin
            append_Noms    (chemindonnees+nomftop+exttop);
            Noms^.modifier (nbpg_t, coul_t, haut_t);
         end else begin }
            nomftop := '';
            chang_noms ;
            recalculer_toponymie_2d;
{         end;      }
      end;
      visutoponym := noms <> nil;
   end;

procedure inimenus_prof;
   begin
      textemenufichierprof;
      textemenu (3,  6, txt_mnu36, txt_mnu36);

      textemenu (4, 10, txt_mnu410, txt_mnu410a);
      textemenu (4, 11, txt_mnu411, txt_mnu411a);
   end;

procedure inimenus_eleve;
   begin
      textemenufichier;

      textemenu (2,  1, nomu_coup, '');
      textemenu (2,  2, txt_mnu22, txt_mnu22a);
      textemenu (2,  3, txt_mnu23, txt_mnu23a);
      textemenu (2,  4, txt_mnu24, txt_mnu24a);
      textemenu (2,  5, txt_mnu25, txt_mnu25a);

      textemenu (2,  6, txt_mnu26, txt_mnu26);

      textemenu (3,  2, txt_mnu32, txt_mnu32a);
      textemenu (3,  3, txt_mnu33, txt_mnu33a);
      textemenu (3,  4, txt_mnu34, txt_mnu34a);
      textemenu (3,  5, txt_mnu35, txt_mnu35a);
   end;

procedure modif_menus;
   begin
      if sis
      then
         active_icone (10)
      else
         if top
         then
            active_icone (9)
         else
            if gra
            then
               active_icone (8);

      if ((nomfpar <> nomdumodule) or prof)
      then
         active (1, 4, true)
      else
         active (1, 4, false);
      if exempl        { sans bascule }
      then begin
         active (1,  2, false);
         active (1,  4, false);
         active (1,  5, false);
         active (1, 10, false);
         active (1, 11, false);
         active (3,  2, false);  { comm }
         active (3,  5, false);  { topon }
      end;

      if TOPO  then initop;
      if GRAVI then inigra;
      if SISMI then inisis;
      marqueicones_affichages;

      if nomfd3 <> ''
      then begin
         if sismi or sis
         then begin
            active (4,  8, true);            { ech    1 }
            if echelle1
            then begin
               textemenu (4,  8, coche+' '+txt_mnu48, txt_mnu48a);
               Inactive_icone (12); { ch 1 }
               Active_icone   (11); { auto  }
             end else begin
               textemenu (4,  8,      '  '+txt_mnu482, txt_mnu48b);
               Inactive_icone (11);
               Active_icone   (12);
            end
         end else begin
            active (4,  8, false);
            Inactive_icone (11); { auto  }
            Inactive_icone (12); { ch 1 }
         end;
      end else
         desactive_sismi;

      if visucomm
      then begin
         textemenu (4,  2, coche+' '+txt_mnu42, txt_mnu42a);
         active (3, 2, true);
         Dessiner_Commentaires (false, true, false);
      end else begin
         textemenu (4,  2,      '  '+txt_mnu42, txt_mnu42b);
         active (3, 2, false);
      end;

      if annotations^.count = 0
      then begin
         visucomm := false;  { le premier lment  sera qd mme permis }
         active (3 , 2, true);
      end;

  {    if legend
      then
         textemenu (4,  3, coche+' Graduations',
                           'Efface les graduations associes  la carte.')
      else
         textemenu (4,  3, '  Graduations',
                           'Affiche les graduations associes  la carte.');}
      if compare
      then
         textemenu (4,  3, coche+' '+txt_mnu43, txt_mnu43a)
      else
         textemenu (4,  3,      '  '+txt_mnu43, txt_mnu43b);

      if visucarte
      then begin
         textemenu (4,  4, coche+' '+txt_mnu44, txt_mnu44a);
         Inactive_icone (13);
         Active_icone   (14);
      end else begin
         textemenu (4,  4,      '  '+txt_mnu44, txt_mnu44b);
         Inactive_icone (14);
         Active_icone   (13);
      end;

      If visusymb
      then begin
         textemenu (4,  5, coche+' '+txt_mnu45, txt_mnu45a);
         Inactive_icone (15);
         Active_icone   (16);
      end else begin
         textemenu (4,  5,      '  '+txt_mnu45, txt_mnu45b);
         Inactive_icone (16);
         Active_icone   (15);
      end;

      if (nomfd3 = '') and (nomffond = '') and (nomffong = '')
      then begin
         active  (4, 5, false);
         inactive_icone (15);
         inactive_icone (16);
      end;

      if visupro
      then
         textemenu (4,  6, coche+' '+txt_mnu46, txt_mnu46a)
      else
         textemenu (4,  6,      '  '+txt_mnu46, txt_mnu46b);

{  pour traiter les fonds  part...
      if visufond
      then
         textemenu (4,  6, coche+' Fond de carte',
                           'Un fond de carte est visible')
      else
         textemenu (4,  6, '  Fond de cartes',
                           'Le fond est masqu');

      if (nomffond = '') or (nomffong = '')
      then
         active    (4,   6, false);          }

      if reduc
      then begin
         textemenu (4,  7, coche+' '+txt_mnu47,  txt_mnu47a);
         Inactive_icone (17);
         Active_icone   (18);
      end else begin
         textemenu (4,  7, '  '+txt_mnu47, txt_mnu47b);
         Inactive_icone (18);
         Active_icone   (17);
      end ;

      if not (sis or top or gra)
      then begin
         inactive_icone (17);
         inactive_icone (18);
         active (4, 7, false);
      end else
         active (4, 7, true) ;

      if anom
      then
         active  (4,  5, true);  {    }

      if noms^.count = 0
      then
         visutoponym := false;

      If visutoponym
      then
         textemenu (4,  9, coche+' '+txt_mnu49, txt_mnu49a)
      else
         textemenu (4,  9,      '  '+txt_mnu49, txt_mnu49b);

      modif_menu_cfg; { modifie le menu SORTIES }
   end;

procedure inimenus;
   begin
      ini_menu      (repbgi, pol_menu);                             { menus }
      posxbtn := 541;
      chargepalette (cheminmodule+nomdumodule + extpal, ok);         { graphism }
      setcoulmenu   (fondmenu, txtmenu, txtnorm, txtnon,
                     txtoui,  fondnorm, fondoui, fondaide);
      inimenus_eleve;
      if prof
      then
         inimenus_prof;
   end;

procedure inversemenus;
   begin
      if not prof
      then
         inimenus_prof
      else begin
         initmenus;                                                { menus1 }
         inimenus_eleve;
      end;
      prof := not prof;
   end;

procedure iniaide;
   begin
      initaide (cheminmodule+nomdumodule + exthlp, ok);                         { menus6 }
   end;

procedure fin;
   begin
      finir;                                                          { des }
   end;

END.

{--- GEOCEAN - COUP_INI ------ --------------- R.C.- INRP - TOULOUSE - 1995 }
