UNIT FCTMATH;

   {------------------------------------------------------------------------}
   {     FONCTIONS MATHEMATIQUES                                            }
   {                                                                        }
   {                                               Alain Culos  22/07/90    }
   {------------------------------------------------------------------------}

   (*
   Fctmath                   { ARX     - Fonctions mathmatiques diverses   }
   *)

INTERFACE

{$O+,F+}


Procedure racines2    ( a, b, c     : integer;
                       var nbsol    : integer;
                       var x1, x2   : real ) ;

   {}

Function  fact        ( n           : integer)        : longint;
   {}

Procedure diviseur    ( a           : longint;
                       var nb       : integer);
   {}

Function  arcsin      ( v           : real )          : real;
   { -pi/2 < arcsin      < pi/2  }

Function  arctangente ( sinus, cosinus : real)        : real;
   {  0    < arctangente < 2.pi  }

Function  secants     ( xd, yd, xf, yf,
                        xxd, yyd, xxf, yyf : longint) : boolean;
   {}

Function  signe       (n               : real)        : real;
   {}

Function  puissance   (base, expo      : real)        : real;
   {}

Function  factorielle (x               : integer)     : real;
   {}


{---------------------------------------------------------------------------}

IMPLEMENTATION

procedure racines2;
   var
      delta             : real;
      test              : boolean;

   begin
      delta := b*b-4*a*c;
      if a = 0
      then begin
         x1    := -c/b;
         nbsol := 1;
      end else begin
         if delta >=0
         then begin
            nbsol:=2;
            if delta=0 then nbsol := 1;
            x1 := (-b+sqrt(delta))/(2*a);
            x2 := (-b-sqrt(delta))/(2*a);
         end else
            nbsol:=0;
      end;
   end;

function fact;
   begin
      if n = 0
      then
         fact := 1
      else
         fact := fact(n-1)*n
   end;

function  arcsin   ( v : real ) : real;
   begin
      if (v = 1) or (v = -1)
      then
         arcsin := v * pi / 2
      else
         arcsin := arctan (v / sqrt (1 - v * v));
   end;

function  arctangente (sinus, cosinus : real) : real;
   var
      arct              : real;

   begin
      if abs (cosinus) < abs (sinus)
      then begin
         arct := pi/2-arctan (cosinus/sinus);
         if sinus < 0   then arct := arct+pi;
      end else begin
         arct := arctan (sinus/cosinus);
         if cosinus < 0 then arct := arct+pi;
         if arct    < 0 then arct := arct+2*pi
      end;
      arctangente := arct
   end;

procedure diviseur;
    var
       i, nb1           : integer;

    begin
        nb1 := 1;
        while ((a mod 2)=0) and (2<=a)
        do begin
           a   := a div 2;
           nb1 := nb1+1
        end;
        nb := nb1;
        i  := 3;
        while i <= a
        do begin
            nb1 := 1;
            while ((a mod i)=0) and (i<=a)
            do begin
               a   := a div i;
               nb1 := nb1+1
            end;
            nb := nb*nb1;
            i  := i +2
        end
    end;

function secants;
   var
      a, b, c, d        : integer;
      num, den          : longint;
      la, mu            : real;

   begin
      if xf<>xd
      then begin
         num := (yd-yyd)*(xf-xd)+(xxd-xd)*(yf-yd);
         den := (xf-xd)*(yyf-yyd)+(yd-yf)*(xxf-xxd);
         if den<>0
         then
            mu :=num/den
         else
            if num <> 0
            then
               mu :=-1
            else begin
               if xd > xf
               then begin a := xd; b := xf end
               else begin b := xd; a := xf end;

               if xxd>xxf
               then begin c := xxd;d := xxf end
               else begin d := xxd;c := xxf end;

               if (b>c) or (d>a)
               then mu := -1
               else mu := 0
            end;
         la := ((xxd-xd)+mu*(xxf-xxd))/(xf-xd)
      end else
         if yd <> yf
         then begin
            if xxf <> xxd
            then
               mu := (xd-xxd)/(xxf-xxd)
            else
               if xd <> xxd
               then mu := -1
               else begin
                  if yd>yf
                  then begin a := yd;b := yf end
                  else begin b := yd;a := yf end;

                  if yyd > yyf
                  then begin c := yyd;d := yyf end
                  else begin d := yyd;c := yyf end;

                  if (b>c) or (d>a)
                  then mu := -1
                  else mu := 0
               end;
            la := ((yyd-yd)+mu*(yyf-yyd))/(yf-yd)
         end else begin
            mu := 0;
            if (xxf = xxd) and (xxd <> xd)
            then mu:=-1
            else if (yyf = yyd) and (yyd <> yd)
               then mu := -1
               else
                  if (xd-xxd)*(yyf-yyd) <> (yd-yyd)*(xxf-xxd)
                  then mu := -1;
            la := 0
         end;
      secants := (mu >= 0) and (mu <= 1) and (la >= 0) and (la <= 1)
   end;

function  signe    (n : real) : real;
   begin
      if n >= 0
      then signe := 1
      else signe := -1;
   end;

function  puissance (base, expo : real) : real;
   begin
      if abs(base) < 1E-6
      then
         if expo = 0.0
         then puissance := 1.0
         else puissance := 0.0
      else
         if base > 0
         then
            puissance := exp(expo*ln(base))
         else
            if odd(round(expo))
            then
               puissance := signe(base)*exp(expo*ln(abs(base)))
            else
               puissance :=-signe(base)*exp(expo*ln(abs(base)))
   end;

function  factorielle (x : integer)  : real;
   var
      i                 : integer;
      f                 : real;

   begin
      if x < 2
      then
         factorielle := 1
      else begin
         f := 1;
         for i := 2 to x
         do
            f := f*i;
         factorielle := f;
      end;
   end;


END.

{---FCTMATH-----------------------------------------------------------------}

