UNIT RS2322;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          gestion voie srie                               }
{                                                               03/05/91    }
{---------------------------------------------------------------------------}
{  ARX - Alain, Roger et Xavier CULOS - 6 av de Lagarde 31130 BALMA         }
{---------------------------------------------------------------------------}

{---------------------------------------------------------------------------}
{  pilote directement les ports srie COM1 et COM2 en entre et en sortie   }
{---------------------------------------------------------------------------}

(*
   Rs2322;                   { ARX     - gestion voie srie                 }
*)

INTERFACE
{$O+,F+}

USES
   crt;

Procedure initcom (pt : byte; vitesse, params : word; var err : boolean);
   {              1   COM1  en bauds
                  2   COM2                                               }

Function  litcom (pt : byte)   : string ;
   { lit une chane sur le port PT }

Procedure envcom (pt : byte; s : string);
   { envoit une chane sur le port PT }

{---------------------------------------------------------------------------}

IMPLEMENTATION

CONST
   com    = $2F8; {=adr. COM2 ;  COM1=COM+256=$3F8
                   tampon rception  si dlab=0 et bit 0 de lsr=1
                   tampon mission   si dlab=0 et bit 5 de lsr=1
                   lsb               si dlab=1                       }

   msbdiv = $2F9; {msb               si dlab=1                       }
   lcr    = $2FB; {contrle ligne       dlab= bit 7                  }
   mcr    = $2FC; {contrle modem}
   lsr    = $2FD; {tat ligne}
   msr    = $2FE; {tat modem}
   horloge= 115200;
   param0 = $3;
   paramd = $3;

VAR
   a     : char;
   ofset : integer;

function test_cts:boolean;
   var
      test : boolean;
      i    : integer;

   begin
      i := 0;
      repeat
         i := i+1;
         test := (port[msr+ofset] and 16)=16
      until test or (i=1000);
      test_cts :=test
   end;

procedure initcom (pt : byte ; vitesse, params : word; var err: boolean);
   var
      ls : word;

   begin
      err := false;
      if pt=2 then ofset := 0 else ofset := 256;
      if params=0 then params := param0;
      ls := horloge div vitesse;
      port [lcr   +ofset]   := $80;
      port [com   +ofset]   := ls mod 256;
      port [msbdiv+ofset]   := ls div 256;
      port [lcr   +ofset]   := params;
      port [mcr   +ofset]   := paramd;
      if not test_cts then err := true
   end;

function litcar (pt : byte) : char;
   var
      c : byte;

   begin
      c := (port [com+ofset] and $7F);
      litcar := chr (ord (c))
   end;

function car_recu : boolean;
   begin
      car_recu := (port [lsr+ofset] and 1)=1
   end;

function port_lib : boolean;
   begin
      port_lib := (port [lsr+ofset] and 32)=32
   end;

function litcom (pt : byte) : string;
   var
      a : char;
      s : string;

   begin
      s := '';
      if pt=2 then ofset := 0 else ofset := 256;
      repeat
         repeat until car_recu;
         a := litcar (pt);
         if ord (a) <> 13 then s := s+a;
      until ord (a)=13;
      litcom := s;
   end;

procedure envcar (pt : byte; c : char);
   begin
      repeat until port_lib;
      port [com+ofset] := ord (c);
   end;

procedure envcom (pt : byte ; s : string);
   var
      i : byte;

   begin
      if pt=2 then ofset := 0 else ofset := 256;
      for i := 1 to length (s) do envcar (pt, s [i])
   end;


END.

{--- RS2322 ------------------------------------------------- ARX - BALMA --}
