UNIT UTILEDI;

{---------------------------------------------------------------------------}
{         bibliothque                                                      }
{                          divers utilitaires                               }
{                                                               27/01/93    }
{---------------------------------------------------------------------------}
{  A R X - Alain, Roger et Xavier CULOS - 6 avenue de Lagarde  31130 BALMA  }
{---------------------------------------------------------------------------}

(*
   Utiledi,                  { ARX     - utilitaires dition                }
*)

INTERFACE

{$O+,F+}

USES
   graph,                    { TP 70   - units standard Borland            }
   Graphism,                 { ARX     - initialisations graphiques         }
   Souris,                   { ARX     - gestion de la souris               }
   Messarx,                  { ARX     - textes des messages de base        }
   Utildivs,                 { ARX     - utilitaires divers                 }
   Edition;                  { ARX     - gestion des botes de dialogue     }

Procedure EditerChaine   (x, y               : integer;
                          var PosCur         : integer;
                          var LaChaine       : String;
                          Taille             : integer;
                          CouleurFond        : word;
                          var CodeSortie     : integer);

   {-------------------------------------------------------------}
   {ROLE: permet la mise  jour d'une chaine de faon interactive}
   {       l'aide des touches de gestion de curseur.            }
   {      La chane est dite  partir de la position courante  }
   {       du curseur (position non modifie par la procdure)   }
   {ENTREE Taille: longueur de la chane (zone de saisie)        }
   {M.A.J. Chaine : chane  diter                              }
   {                  en entre: valeur initiale de la chane    }
   {                  en sortie: valeur finale aprs dition     }
   {SORTIE CodeSortie : code du caractre tap pour validation   }
   {-------------------------------------------------------------}

Procedure EditerReel     (x, y               : integer;
                          var PosCur         : integer;
                          var v              : real;
                          Taille, Decimales  : integer;
                          CouleurFond        : word;
                          var CodeSortie     : integer);
   {----------------------------------------------------------------}
   {ROLE: dition interactive d'un nombre rel                      }
   {ENTREE Taille: taille de la zone de saisie (rel cadr  droite)}
   {       Decimales: nombre de dcimales du nombre rel            }
   {M.A.J. x: en entre, valeur propose                            }
   {          en sortie, valeur modifie par l'dition              }
   {SORTIE CodeSortie: code-clavier de validation                   }
   {----------------------------------------------------------------}

Procedure EditerEntier   (x, y               : integer;
                          var PosCur         : integer;
                          var n              : integer;
                          Taille             : integer;
                          CouleurFond        : word;
                          var CodeSortie     : integer);
   { ------------------------------------------------------------------}
   { ROLE: dition interactive d'un nombre entier                      }
   { ENTREE Taille: taille de la zone de saisie (entier cadr  droite)}
   { M.A.J. n: en entre, valeur propose                              }
   {           en sortie, valeur modifie par l'dition                }
   { SORTIE CodeSortie: code-clavier de validation                     }
   { ------------------------------------------------------------------}

Procedure readxy         (x, y               : integer;
                          var texte          : string;
                          longueur           : integer);
   { saisie simple dans l'cran graphique.                                  }

Procedure saisie         (texte              : longchaine;
                          var reponse        : string;
                          taille             : integer);
   { saisie d'une chaine dans une bote centre.                            }

{---------------------------------------------------------------------------}
IMPLEMENTATION

Procedure EditerChaine (    x, y        : integer;
                        var PosCur      : integer;
                        var LaChaine    : String;
                            Taille      : integer;
                            CouleurFond : word;
                        var CodeSortie  : integer);

   Var
      zc                : PZoneChaine;
      co                : word;

   begin
      co := getcolor;
      zc := new (PZoneChaine, init (x, y, Taille, co, CouleurFond,
                 @LaChaine, '', ''));
      zc^.Edite (PosCur, CodeSortie);
      dispose (zc);
   end;

procedure EditerReel (x, y              : integer;
                      var PosCur        : integer;
                      var v             : real;
                      Taille, Decimales : integer;
                      CouleurFond       : word;
                      var CodeSortie    : integer);

   Var
      zr                : PZoneReel;
      co                : word;

   begin
      co := getcolor;
      zr := new (PZoneReel, init (x, y, Taille, Decimales,
                 co, CouleurFond, @v, '', ''));
      zr^.Edite (PosCur, CodeSortie);
      dispose (zr);
   end;

procedure EditerEntier (x, y            : integer;
                        var PosCur      : integer;
                        var n           : integer;
                        Taille          : integer;
                        CouleurFond     : word;
                        var CodeSortie  : integer);

   Var
      ze                : PZoneEntier;
      co                : word;

   begin
      co := getcolor;
      ze := new (PZoneEntier, init (x, y, Taille,
                 co, CouleurFond, @n, '', ''));
      ze^.Edite (PosCur, CodeSortie);
      dispose (ze);
   end;

procedure readxy (x, y : integer; var texte : string; longueur : integer);
   var
      PosCur, touche : integer;

   begin
      PosCur := 0;
      EditerChaine (x, y, PosCur, texte, Longueur, coulecran, touche);
   end;

procedure saisie (texte : longchaine ; var reponse : string ; taille : integer);
   var
      t                 : pointer;
      poscur, touche,
      x1, y1, dx        : integer;

   begin
      if length (texte) > taille+1
      then
         dx := textwidth (texte)+tx
      else
         dx := (taille+1)*tx+tx;

      if posxbtn=0
      then begin
         x1 := trunc ((maxx-(dx  +4)) / 2);
         y1 := trunc ((maxy-(4*ty+4)) / 2);
      end else begin
         x1 := trunc ((posxbtn-(dx  +4)) / 2);
         y1 := trunc ((maxy-(4*ty+4)) / 2);
      end;
      getmem    (t, imagesize (x1, y1, x1+dx+3, y1+4*ty+3));
      getimage                (x1, y1, x1+dx+3, y1+4*ty+3, t^);
      setcolor                (colord);
      setfillstyle (SolidFill, colord);
      rectangle (x1+1, y1+1, x1+dx+2, y1+4*ty+2);
      bar       (x1+1, y1+1, x1+dx+2, y1+2*ty+1);

      setcolor        (colorf);
      rectangle (x1,   y1,        x1+dx+3, y1+4*ty+3);
      setfillstyle (SolidFill, c_f_boite_inve);
      bar       (x1+2, y1+2+ty*2, x1+dx+1, y1+4*ty+1);
      settextjustify (1, 1);
      outtextxy (x1+dx div 2, y1+ty, texte);
      settextjustify (0, 2);

      setcolor         (c_t_boite_inve);
      poscur := 0;
      repeat until not UnBoutonSourisEnfonce;
      EditerChaine
         (x1+6, y1+2*ty+6, poscur, reponse, taille, c_f_boite_inve, touche);
{      if touche = 27
      then := '';    }
      putimage  (x1, y1, t^, NormalPut);
      libere    (t);
   end;

END.

{---- UTILEDI ---------------------------------------------- ARX - BALMA --}
