unit BarreIc2bis;
// Dl 29/04/00 modif gestion des Timer

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, jpeg,CompCadreIma2;

type
  TBarreIcones2 = class(TForm)
    Panel1: TPanel;
    FlecheG: TImage;
    FlecheD: TImage;
    TimerG: TTimer;
    TimerD: TTimer;
    CadreImage21: TCadreImage2;
    CadreImage22: TCadreImage2;
    CadreImage23: TCadreImage2;
    CadreImage24: TCadreImage2;
    Label2: TLabel;
    procedure FormShow(Sender: TObject);
    procedure ImageClick(Sender: TObject);
    procedure FlecheGMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheDMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheGMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FlecheDMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TimeG(Sender:TObject);
    procedure TimeD(Sender:TObject);
    procedure DeplacementGauche;
    procedure DeplacementDroit;
    procedure FormCreate(Sender: TObject);
    

  private
    { Dclarations prives }
    FSelection:integer;  // liste des noms des taxons slectionns

    Images : array[0..3] of TCadreImage2;


  public
    { Dclarations publiques }
    Premiere : integer;                 // index de la premire image
    NoImageSelected : integer;          // no de l'image slectionne
    listeCollections : array[0..50] of String ;
    procedure  SelectionCollectionMenu(nom : string);
    procedure AfficheIcones;

  end;

var
  BarreIcones2: TBarreIcones2;

implementation
uses Donnees, PhylObs, PhylChoi, PhylComp, PhylPlch, PhylMain;

{$R *.DFM}

procedure TBarreIcones2.FormCreate(Sender: TObject);
var
   i:integer;
begin
    TimerG.Interval:=100; // millisecondes
    TimerG.Enabled:=false;
    TimerD.Interval:=100;
    TimerD.Enabled:=false; 
    Images[0]:=CadreImage21;
    Images[1]:=CadreImage22;
    Images[2]:=CadreImage23;
    Images[3]:=CadreImage24;
    Premiere:=0;
    NoImageSelected :=0;
    for i:=0 to 3 do
    with Images[i] do
    begin
       OnClick:=ImageClick;
       Tag:=i;    // l'index de Taxons commence  0
    end;
    FSelection:=-1;
    visible:=false;
end;

procedure TBarreIcones2.FormShow(Sender: TObject);
begin
   AfficheIcones;
end;

procedure TBarreIcones2.ImageClick(Sender: TObject);
var
   NumEsp:integer;
   NomEsp:string;
   ind:integer;
   retour : boolean;
begin

   NumEsp:= TCadreImage2(Sender).Tag;
   NomEsp:= listeCollections[NumEsp];
   retour:=FormPrinc.Selectionner_une_collection(Nomesp);
   if (retour = true) then
   begin
    NoImageSelected := NumEsp;
    AfficheIcones;
   end; 
end;

procedure TBarreIcones2.SelectionCollectionMenu(nom : string);
var
index, No : integer;
begin
 index := 0;
 No := -1 ;
   while (listeCollections[index] <> '') do
   begin
     if (nom =  listeCollections[index]) then No := index ;   // pour connaitre l'indice de la collection slectionne
     index := index+1 ;                                       // pour connaitre le nombre total de collection
   end;
  if (No = -1) then exit ;
  index := index -1 ;
  
  if (No > index-4+1) then     Premiere := index-4+1  else Premiere := No   ;
    NoImageSelected := No;
  AfficheIcones;
  end;

procedure TBarreIcones2.FlecheGMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DeplacementGauche;
  TimerG.Enabled:=true;
end;

procedure TBarreIcones2.AfficheIcones;
// affiche les icones  partir de Premiere
var
    i:integer;
    NomCol:string;
    nomIcone :string;
begin

    for i:=0 to 3 do
    with Images[i] do
    begin
     Tag:=Premiere+i;
     nomIcone := 'Icone-';
     NomCol:=listeCollections[Tag];
     Affiche(CheminColl+'\'+NomCol+'\'+nomIcone+NomCol+'.bmp',NomCol);
     Selected:=(Tag = NoImageSelected )
    end;
end;



procedure TBarreIcones2.DeplacementGauche;

begin
  if (Premiere>0) then
  begin
     Premiere:=Premiere-1;
     AfficheIcones;
  end;
end;

procedure TBarreIcones2.FlecheDMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DeplacementDroit;
  TimerD.Enabled:=true;
end;

procedure TBarreIcones2.DeplacementDroit;
var
total, index : integer;
begin
   index := 0;
   while (listeCollections[index] <> '') do index := index+1 ;
  if (Premiere < index-4) then
  begin
    Premiere:=Premiere+1;
    AfficheIcones;
  end;
end;


procedure TBarreIcones2.FlecheGMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TimerG.Enabled:=false;
end;

procedure TBarreIcones2.FlecheDMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  TimerD.Enabled:=false;
end;


procedure TBarreIcones2.TimeG(Sender:TObject);
begin
   DeplacementGauche;
end;

procedure TBarreIcones2.TimeD(Sender:TObject);
begin
   DeplacementDroit;
end;

 

 

end.
 