unit CustomGraph2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   typedef,GraphObject,ListArray2;

type

 TCanClic = procedure ( WPoint : TPoint ; var ret :boolean) of object;
 TClicObject = procedure (WPoint:TPoint) of object;

 TCreateCoordObjects = procedure  of object;
 TCreateInfoGraph = procedure of object;
 TCreateObjects = procedure of object;
 TDeleteObjects = procedure of Object;
 TCreateModel = procedure of object;

 TCurPrioritys = set of (crPage,crObjet,crActif);


 TScrollDirection = (noscroll,scrollRight,ScrollLeft,ScrollUp, ScrollDown);
 

//******************************************************************************/
TGraphControl2 = class;
TGraphPage =class(TObject)
 private

  FOrgX     :integer;
  FOrgY     :integer;

  FWidth    :integer;
  FHeight   :integer;

  FBackGrdColor:TColor;

  FParent      :TGraphControl2;

  FLeftMargin   :integer;
  FRightMargin  :integer;
  FTopMargin    :integer;
  FBottomMargin :integer;

  FCoeffScaleW : double ;
  FCoeffScaleH : double;

 protected
  
   FScale:double;


  function GetPageWidth :integer; virtual;
  procedure SetPageWidth(width:integer); virtual;
  function GetPageHeight :integer; virtual;
  procedure SetPageHeight(height:integer); virtual;

  function GetClicObject(PagePoint :TPoint):TGraphObject;

  function GetRowCount :integer;
  function GetColCount(ARow:integer) :integer;

  function GetItems (ARow:integer; ACol:integer):TGraphObject;
  procedure SetItems ( ARow:integer; ACol:integer; AObject:TGraphObject);

 public

  FPage     :TListArray;

 constructor CreatePage(AParent: TGraphControl2);virtual;
 destructor Destroy; override;

 property Parent : TGraphControl2 read FParent write FParent;

 property BackGrdColor :TColor read FBackGrdColor write FBackGrdColor;
 property OrgX :integer read FOrgX write FOrgX;
 property OrgY :integer read FOrgY write FOrgY;
 property Width :integer read GetPageWidth write SetPageWidth;
 property Height :integer read GetPageHeight write SetPageHeight;

 property Items[ARow,ACol :integer]:TGraphObject read GetItems write SetItems;
 property RowCount     :integer read GetRowCount;
 property ColCount[ARow:integer] :integer read GetColCount;
 property LeftMargin   :integer read FLeftMargin write FLeftMargin;
 property RightMargin  :integer read FRightMargin write FRightMargin;
 property TopMargin    :integer read FTopMargin write FTopMargin;
 property BottomMargin :integer read FBottomMargin write FBottomMargin;

 property  CoeffScaleW : double read FCoeffScaleW write FCoeffScaleW;
 property  CoeffScaleH : double read FCoeffScaleH write FCoeffScaleH;

 procedure Paint(ACanvas:TCanvas);virtual;

 end;
//*********************************************************************************/

TGraphControl2 = class(TCustomControl)
  private

  DrawingMode :boolean;
  FAutoSize : boolean;

  FTimer:boolean;
  FModel : TModel;

  FFont :TLogFont;
  FActivePage :TGraphPage;

  FScrollDirection: TScrollDirection;

  FClicDownObject : TGraphObject;
  FClicUpObject   : TGraphObject;
  FMouseMoveObject: TGraphObject;
  FMouseDragObject: TGraphObject;

  FActiveObject :TActiveObject;

  FCanClicDown : TCanClic;
  FCanClicActivate : TCanClic;

  FRespClicDown : TClicObject;
  FRespClicUp : TClicObject;
  FRespMouseMove : TClicObject;
  FRespMouseDrag :TClicObject;
  FRespActiveObjectUp:TClicObject;

  FCreateCoordObjects : TCreateCoordObjects;
  FCreateInfoGraph : TCreateInfoGraph ;
  FCreateObjects : TCreateObjects ;
  FDeleteObjects : TDeleteObjects;
  FCreateModel : TCreateModel;
  
  FMouseExit:TClicObject;
  FMouseEnter:TClicObject;

  FCursor:array[0..3] of TCursorObj;

  //************************** variables de mise en page **********************//
  // Les objets graphiques s'affichent sur une page virtuelle dont les dimensions sont
  // fixes par FPageWidth et FPageHeight. Les scrolls n'ont de sens que si les
  // dimensions de cette page sont suprieures  celles de la fentre client.
  // Par dfaut l'affichage de la page se fait de telle faon que son origine graphique
  // concide avec l'origine de la fentre : POriginX:=0, POriginY:=0.


  // Les six valeurs suivantes sont calcules par CalcRange avant chaque
  // affichage qu'il soit normal (paint) ou  la suite d'un scroll (paintscroll)

  POriginX : integer; // Coordonne (en pixel) X de la page affiche dans le coin
                     // suprieur gauche de la fentre : dpend de HScrollCount
  POriginY : integer; // Coordonne (en pixel) Y de la page affiche dans le coin
                     // suprieur gauche de la fentre : dpend de VScrollCount

  XRange :integer; // Etendue maximale d'un scroll horizontal : = PageWidth-ClientWidth
  YRange :integer; // Etendue maximale d'un scroll vertical : = PageHeight-ClientHeight
                   // Ces deux valeurs sont calcules par CalcRange

  VRange : integer; // valeur maximum de VScrollCount calcul par CalcRange
  HRange : integer; // valeur maximum de HScrollCount calcul par CalcRange

  FUScrollV: integer; //unit de scrolling verticale;
  FUScrollH: integer; // Unit de scrolling horizontale

  HScrollCount : integer; // compteur des scrolls horizontaux
  VScrollCount : integer; // compteur des scrolls verticaux

  FCurPrioritys :TCurPrioritys;

  FSurface : TBitmap;
  FBackSurface :TBitmap;

  FBackGrdColor:TColor;
  // Les deux fonctions suivantes sont  redfinir dans une grille : si le nombre
  // de colonne est fix alors Getpagewidth retourne ce nombre multipli
  // par la largeur des colonnes. Sinon c'est la dernire colonne remplie qui sert
  // de nombre de colonne. Mme chose pour les lignes


  // CalcRange : calcule les six valeurs de scroll  partir des units de scroll
  // (FUScrollV-H) des compteurs de scroll(H-VScrollCount)
  //et de la taille des pages et de la fentre
  procedure CalcRange; virtual;

  // En ajoutant un 'model', on met les flags (createobjects..)  false et
  // on invalide la fentre, ce qui cre un appel aux fonctions correspondant aux flags
  
  procedure SetModel(Amodel : TModel) ;
  procedure SetScrollBar; // Rinitialise les barres de scroll

  procedure WMVScroll(var Msg: TWMVScroll); message WM_VSCROLL;
  procedure WMHScroll(var Msg: TWMHScroll); message WM_HSCROLL;
  procedure WMSize(var Msg: TWMSize); message WM_SIZE;
  procedure WMTimer(var Msg: TWMTimer); message WM_TIMER;

       { *******************  ******************** ********************}
       { ******************* Dclarations protges ********************}
       { *******************  ******************** ********************}

 protected

 Flag_CreateObjects:boolean;
 Flag_CreateCoordObjects:boolean;
 Flag_CreateInfoGraph:boolean;

  procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
  procedure MouseUp(Button: TMouseButton; Shift: TShiftState;X, Y: Integer); override;
  procedure CreateParams(var Params: TCreateParams); override;
  procedure Paint; override;

  // Fonction appele par ScrollTo. Elle initialise la surface cache,
  // appelle  PaintPage(surface.canvas), puis effectue la copie vers l'cran
  procedure PaintScroll;virtual;

  // Ces deux fonctions retournent 'true' par dfaut. Pour changer ce comportement
  // il suffit de dfinir une fonction du type MyCanClic..(TPoint, var boolean) et
  // de l'attribuer a FOnCanClic.. dans le constructeur d'une classe drive ou
  // de dfinir l'venement dans l'inspecteur d'objet

  function CanClicDown (WPoint :TPoint) : boolean;virtual;
  function CanClicActivate (WPoint :TPoint): boolean;virtual;

  procedure RespClicDown(ClientPoint :TPoint);virtual;
  procedure RespClicUp(ClientPoint:TPoint);virtual;
  procedure RespMouseMove(ClientPoint :TPoint);virtual;
  procedure RespMouseDrag(ClientPoint :TPoint);virtual;
  procedure RespActiveObjectUp(ClientPoint :TPoint);virtual;

  Procedure CreateObjects;virtual;
  Procedure DeleteObjects;virtual;
  
  procedure CreateInfoGraph(ACanvas:TCanvas); virtual;
  Procedure CreateCoordObjects(ACanvas:TCanvas);virtual;


  procedure ChangeCoordGraphObjects;
  procedure ChangeInfoGraph;

  function MouseExit(point:TPoint):boolean;
  function MouseEnter(point:TPoint):boolean;
  function MouseOutClient(point:TPoint):boolean;

  
  public { ************************ Dclarations public ********************* }

  constructor Create(AOwner: TComponent); override;


  procedure SetCursor(indexCurs :integer; AName :string; crtype:TCursorIndex);
  procedure ChangeScale(TypeZoom:string);
   Procedure ChangeGraphObjects;virtual;
   
  property ActivePage :TGraphPage read FActivePage ;

  property ClicDownObject : TGraphObject read FClicDownObject ;
  property ClicUpObject   : TGraphObject read FClicUpObject  ;
  property MouseMoveObject: TGraphObject read FMouseMoveObject  ;
  property MouseDragObject: TGraphObject read FMouseDragObject  ;
  property ActiveObject :TActiveObject read FActiveObject write FActiveObject;
  property Model : TModel read FModel write SetModel;
  property AutoSize :boolean read FAutosize write FAutosize;

  published { ************************** Dclarations publies ***************}

  property Align;
 

  property OnCanClicDown :TCanClic read FCanClicDown write FCanClicDown ;
  property OnCanClicActivate :TCanClic read FCanClicActivate write FCanClicActivate ;
  property OnMouseUp;

  property OnCreateCoordObjects :TCreateCoordObjects  read FCreateCoordObjects  write FCreateCoordObjects ;
  property OnCreateInfoGraph : TCreateInfoGraph   read FCreateInfoGraph  write FCreateInfoGraph ;
  property OnCreateObjects : TCreateObjects   read FCreateObjects  write FCreateObjects ;
  property OnDeleteObjects : TDeleteObjects  read  FDeleteObjects write  FDeleteObjects;
  property OnCreateModel : TCreateModel read FCreateModel write FCreateModel;

  property OnRespClicDown:TClicObject read FRespClicDown write FRespClicDown;
  property OnRespClicUp: TClicObject read FRespClicUp write FRespClicUp;
  property OnRespMouseMove: TClicObject read FRespMouseMove write FRespMouseMove ;

  property OnMouseExit:TClicObject read FMouseExit write FMouseExit;
  property OnMouseEnter:TClicObject read FMouseEnter write FMouseEnter;

  property CurPrioritys: TCurPrioritys read FCurPrioritys write FCurPrioritys
                          default[crObjet,crActif];
  end;

procedure Register;

 //******************************************************************************/
//******************************************************************************/
//                           implementation
//******************************************************************************/
//******************************************************************************/


implementation


{*****************************************************************************
                              TGraphPage
 *****************************************************************************}
constructor TGraphPage.CreatePage(AParent: TGraphControl2);
 begin
  FParent:=AParent;
  FPage:=TListArray.createListArray;

  FCoeffScaleW:=0;
  FCoeffScaleH:=0;

  FWidth:=0;
  FHeight:=0;

  FBackGrdColor:=Clwhite;

 end;
{*****************************************************************************}
destructor TGraphPage.Destroy;
 begin
  inherited ;
    FPage.free;
  end;
{*****************************************************************************}
function TGraphPage.GetItems (ARow:integer; ACol:integer):TGraphObject;
 begin
  result:=TGraphObject(FPage.Items[ARow,ACol]);
 end;
{*****************************************************************************}
procedure TGraphPage.SetItems ( ARow:integer; ACol:integer; AObject:TGraphObject);
begin
  FPage.Items[ARow,ACol]:=AObject;
 end;
{*****************************************************************************}
function TGraphPage.GetRowCount :integer;
begin
 result:=FPage.RowCount;
end;
{*****************************************************************************}
function TGraphPage.GetColCount(ARow:integer) :integer;
 begin
 result:=FPage.ColCount[ARow];
end;
{*****************************************************************************}
procedure TGraphControl2.ChangeScale(TypeZoom:string);
begin
 if typezoom='plus' then
 begin
  ActivePage.CoeffScaleW:=ActivePage.CoeffScaleW + 0.5;
  ActivePage.CoeffScaleH:=ActivePage.CoeffScaleH + 0.5;
 end;

 if typezoom='moins' then
 begin
   if ActivePage.CoeffScaleW >0 then ActivePage.CoeffScaleW:=ActivePage.CoeffScaleW - 0.5;
   if ActivePage.CoeffScaleH >0 then ActivePage.CoeffScaleH:=ActivePage.CoeffScaleH- 0.5;
  end;
   ActivePage.Height:=trunc(ClientHeight * ActivePage.CoeffScaleH + ClientHeight);
   ActivePage.Width:=trunc(ClientWidth+ClientWidth * ActivePage.CoeffScaleW);

   ChangeInfoGraph;
end;
{*****************************************************************************}
procedure TGraphControl2.ChangeInfoGraph;
begin
  Flag_CreateInfoGraph:=false;
  Flag_CreateCoordObjects:=false;
end;
{*****************************************************************************}
procedure TGraphControl2.ChangeCoordGraphObjects;
begin
  Flag_CreateCoordObjects:=false;
end;
{*****************************************************************************}
procedure TGraphControl2.ChangeGraphObjects;
begin

 if Flag_CreateObjects=true then DeleteObjects;
 // La fonction deleteObjects met Flag_CreateObjects:=false et
                               // Flag_CreateCoordObjects:=false;

end;
{*****************************************************************************}
function TGraphPage.GetPageWidth :integer;
begin
 result:=FWidth;
end;
//*****************************************************************************/
procedure TGraphPage.SetPageWidth(width:integer);
begin
FWidth:=width;
end;
//*****************************************************************************/
function TGraphPage.GetPageHeight:integer;
begin
 result:=FHeight;
end;
//*****************************************************************************/
procedure TGraphPage.SetPageHeight(height:integer);
begin
FHeight:=height;
end;
//*******************************************************************************/
Procedure TGraphControl2.CreateObjects;
begin
Flag_CreateObjects:=true;
Flag_CreateCoordObjects:=false;

if Assigned(FCreateObjects) then FCreateObjects;
end;
//*******************************************************************************/

Procedure TGraphControl2.DeleteObjects;
 begin
  Flag_CreateObjects:=false;
  Flag_CreateCoordObjects:=false;
  ActivePage.FPage.ClearListArray(toDelete); // Dtruit tous les objects graphiques et reinitialise FPAge
if Assigned(FDeleteObjects) then FDeleteObjects;
end;

//*******************************************************************************/
Procedure TGraphControl2.CreateInfoGraph(ACanvas:TCanvas);
begin
Flag_CreateInfoGraph:=true;
Flag_CreateCoordObjects:=false;
if Assigned(FCreateInfoGraph) then FCreateInfoGraph;
end;
//*******************************************************************************/
Procedure TGraphControl2.CreateCoordObjects(ACanvas:TCanvas);
begin
Flag_CreateCoordObjects:=true;

if Assigned(FCreateCoordObjects) then FCreateCoordObjects;
end;

//*******************************************************************************/
procedure TGraphPage.Paint(ACanvas :TCanvas);

var
obj : TGraphObject;
nbLayer,noLayer :integer;
nbObj,noObj:integer;

begin

nbLayer:=FPage.RowCount;
for nolayer:=0 to nbLayer-1  do
 begin
  nbObj:=FPage.ColCount[nolayer];
   for noObj:=0 to nbObj-1 do
    begin
      obj:=TGraphObject(FPage.Items[noLayer,noObj]);
      if obj <> nil then  obj.paint(ACanvas);
    end;
 end;
end;
//******************************************************************************/
function TGraphPage.GetClicObject(PagePoint :TPoint):TGraphObject;
var
IsObj:boolean;
obj : TGraphObject;
nbLayer,noLayer :integer;
nbObj,noObj:integer;

begin

// Si la page a t dcale les coordones du point de cliquage (coordonnes fentres)
// doivent tre modifie

IsObj:=false;
obj:=nil;
nbLayer:=FPage.RowCount;
for nolayer:=nbLayer-1 downto 0 do
 begin
  nbObj:=FPage.ColCount[nolayer];
   for noObj:=0 to nbObj-1 do
    begin
      obj:=TGraphObject(FPage.Items[noLayer,noObj]);
      if obj <> nil then
          begin
          IsObj:=obj.PtInObject(PagePoint);
          if IsObj<>false then break;
          end;
    end;
   if IsObj<>false then break;
 end;
if IsObj<>false then result:=obj
else result:=nil;
end;



{ *****************************************************************************
                              TGraphControl2
*****************************************************************************}

constructor TGraphControl2.Create(AOwner: TComponent);
var
i:integer;

begin
  inherited Create(AOwner);

  HScrollCount:=0;
  VScrollCount:=0;

  FUScrollV:=10;
  FUScrollH:=10;

  FSurface:= TBitmap.create;
  FBackSurface:=TBitmap.create;

  FBackGrdColor:=clwhite;

  FCanClicDown:=nil;
  FCanClicActivate:=nil;

  FRespClicDown := nil;
  FRespClicUp :=nil ;
  FRespMouseMove :=nil ;
  FRespMouseDrag := nil;
  FRespActiveObjectUp:=nil;

  FMouseExit:=nil;
  FMouseEnter:=nil;
  FAutosize:=False;

  for i:=0 to 3 do begin
  FCursor[i].index:=crArrow;
  FCursor[i].name:='';
  end;
  

  FScrollDirection:=noscroll;
  DrawingMode :=false;

  FTimer:=false;

  // En mettant  true les flags suivants, on vite l'appel aux fonctions correspondantes
  // Donc dans la fonction "paint" ou "paintscroll" seule est appele la fonction d'affichage
  // des objects graphiques. Comme ils n'existent pas  rien ne s'affiche
  // Des qu'un model est ajout ces flags deviennent false et les fonctions correspondantes
  // sont appeles

  Flag_CreateObjects:=true;
  Flag_CreateCoordObjects:=true;
  Flag_CreateInfoGraph:=true;

  FClicDownObject:=nil;
  FClicUpObject:=nil;
  FActiveObject:=nil;
  FMouseMoveObject :=nil;
  FMouseDragObject:=nil;

  FCreateCoordObjects :=nil;
  FCreateInfoGraph :=nil;
  FCreateObjects :=nil;
  FDeleteObjects:=nil;
  FCreateModel:=nil;
  
  FActivePage:=TgraphPage.CreatePage(self);
  FModel:=nil;

end;
//*******************************************************************************/
procedure TGraphControl2.SetModel;
begin
FModel:=AModel;

 Flag_CreateObjects:=false;
 Flag_CreateCoordObjects:=false;
 Flag_CreateInfoGraph:=false;

 invalidate;
end;

procedure TGraphControl2.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
  begin
    Style := Style or WS_BORDER;

   end;
end;


//******************************************************************************/
procedure TGraphControl2.PaintScroll;
var
w,h,ph,pw :integer;

begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;

h:=clientheight;
w:=clientwidth;

FSurface.Height:=h;
FSurface.Width:=w;

// Cette fonction cre un appel  CreateCoordObjects(ACanvas) car elle met
// le drapeau Flag_CreateCoordObjects:=false;
if not Flag_CreateObjects then CreateObjects;

// Comme la prcdante cette fonction cre un appel  CreateCoordObjects(ACanvas)
// car elle met le drapeauFlag_CreateCoordObjects:=false;
if not Flag_CreateInfograph then CreateInfoGraph(FSurface.canvas);

if not Flag_CreateCoordObjects then CreateCoordObjects(FSurface.canvas);

if ActivePage.Height=0 then ph:=clientheight else ph:=ActivePage.Height;
if ActivePage.Width=0 then pw:=clientwidth else pw:=ActivePage.Width;

CalcRange; // fonction qui calcule POriginX et POriginY et qui s'occupe des barres
            // de scroll

// Cette fonction n'tant utilise que si la taille de la page est suprieure
// ou gale  celle de la fentre client, il est inutile de repeindre le fond
// de cette fentre comme dans la fonction paint.



// Ce test est en principe inutile puisqu'il ne peut y avoir de scroll quand la taille
// de la page est infrieure  celle de la fentre ; mais il est plus "joli"
// de repeindre la fentre par cette technique de double buffer, aussi la fonction
// paintscroll peut tre appele en dehors de contexte de scroll
 if (ph<h) or (pw<w) then
 begin

  with FSurface.canvas do begin
   brush.style:=bssolid;

   brush.color:=FBackGrdColor;
   FillRect(RECT(0,0,w,h));

   SetViewportOrgEx(FSurface.canvas.handle,- POriginX, -POriginY,nil);
   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(0,0,pw,ph));
  end;
 end

else begin

  with FSurface.canvas do begin
   brush.style:=bssolid;
   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(0,0,w,h));
   SetViewportOrgEx(FSurface.canvas.handle,- POriginX, -POriginY,nil);
  end;
end;



ActivePage.Paint(FSurface.canvas);

// Pour viter que la copie elle mme se fasse avec le dcalage
 SetViewportOrgEx(FSurface.canvas.handle, 0, 0,nil);

Canvas.CopyRect(RECT(0,0,w,h),FSurface.canvas,RECT(0,0,w,h));

SetViewportOrgEx(canvas.handle, 0,0,nil);

end;

//******************************************************************************/
procedure TGraphControl2.Paint;
var
w,h :integer;
pw,ph: integer;

begin
h:=clientheight;
w:=clientwidth;

if ActivePage=nil then begin
   with canvas do begin
    brush.style:=bssolid;
    brush.color:=FBackGrdColor;
    FillRect(RECT(0,0,w,h));
   end;
 exit;
 end;

// Cette fonction cre un appel  CreateCoordObjects(ACanvas) car elle met
// le drapeau Flag_CreateCoordObjects:=false;
if not Flag_CreateObjects then CreateObjects;

// Comme la prcdante cette fonction cre un appel  CreateCoordObjects(ACanvas)
// car elle met le drapeauFlag_CreateCoordObjects:=false;
if not Flag_CreateInfograph then CreateInfoGraph( canvas);

if not Flag_CreateCoordObjects then CreateCoordObjects( canvas);

if ActivePage.Height=0 then ph:=clientheight else ph:=ActivePage.Height;
if ActivePage.Width=0 then pw:=clientwidth else pw:=ActivePage.Width;

CalcRange ; // fonction qui calcule POriginX et POriginY et qui s'occupe des barres
            // de scroll



if (ph<h) or (pw<w) then
 begin

  with canvas do begin
   brush.style:=bssolid;

   brush.color:=FBackGrdColor;
   FillRect(RECT(0,0,w,h));

   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(ActivePage.OrgX,ActivePage.OrgY,ActivePage.OrgX+ActivePage.width,
            ActivePage.OrgY+ActivePage.Height));
   end;
 end

else begin
  with canvas do begin
   brush.style:=bssolid;
   brush.color:=ActivePage.BackGrdColor;
   FillRect(RECT(0,0,w,h));
  end;
end;

SetViewportOrgEx(canvas.handle,-POriginX, -POriginY,nil);


ActivePage.Paint(canvas);

// Pour viter que la copie se fasse avec le dcalage
SetViewportOrgEx(canvas.handle, 0, 0,nil);
end;

//******************************************************************************/
procedure TGraphControl2.SetScrollBar;
begin
if HandleAllocated then
 begin
 SetScrollRange(Handle,sb_horz,0,XRange,false);
 SetScrollPos(Handle,sb_horz,POriginX,true);

 SetScrollRange(Handle,sb_vert,0,YRange,false);
 SetScrollPos(Handle,sb_vert,POriginY,true);
 end;
end;

//******************************************************************************/
procedure TGraphControl2.CalcRange;
begin

// c'est une fonction cl car elle dtermine la possibilit de scroll, l'emplacement
// de la page dans la fentre, et met  jour les scrollbar

XRange:=ActivePage.Width-clientwidth; // Pagewidth est une proprit faisant appel  GetPageWidth

// Dans le cas ou la page est moins large que le fentre, la scrollbar horizontale
// doit disparatre car XRange=0 et tout scroll horizontal est impossible
// puisque HRange=0. (Un scroll  la souris (wmtimer) ou par les flche (wmshcroll)
//  modifie  HScrollCount et le rend <0 ou >HRange)

if (XRange<=0) then
 begin
   HRange:=0;
   POriginX:=-ActivePage.OrgX;
 end
else begin
 HRange:=(XRange div FUScrollH)+1;
 POriginX:=HScrollCount*FUScrollH;
 end;

YRange:=ActivePage.Height-clientheight; // Pagewidth est une proprit faisant appel  GetPageWidth

if (YRange<=0) then
 begin
   VRange:=0;
   POriginY:=-ActivePage.OrgY;
 end
else begin
  VRange:=(YRange div FUScrollV)+1;
  POriginY:=VScrollCount*FUScrollV;
end;

 SetScrollBar;
end;
//******************************************************************************/
procedure TGraphControl2.WMSize(var Msg: TWMSize);
begin
  inherited;
  if (ActivePage=nil) or (Model=nil) then exit;
  if AutoSize=true then begin

  ActivePage.Height:=trunc(ClientHeight * ActivePage.CoeffScaleH + ClientHeight);
  ActivePage.Width:=trunc(ClientWidth+ClientWidth * ActivePage.CoeffScaleW);
  ChangeInfoGraph;
  end
  else
  begin
   ActivePage.Height:= ClientHeight ;
   ActivePage.Width:= ClientWidth;
   ChangeInfoGraph;
 end;
 PaintScroll;
end;


//******************************************************************************/
procedure TGraphControl2.WMHScroll(var Msg: TWMHScroll);
begin

if ActivePage=nil then exit;

case Msg.ScrollCode of

 sb_LineUp :HScrollCount := HScrollCount-1;  // Flche gauche
 sb_LineDown :HScrollCount := HScrollCount+1; // Flche droite

 sb_PageUp : HScrollCount := HScrollCount-2;
 sb_PageDown : HScrollCount := HScrollCount+2;

 sb_Top : HScrollCount :=0;
 sb_bottom :HScrollCount:=HRange;

 sb_ThumbPosition,
 sb_ThumbTrack : HScrollCount:=Msg.Pos div FUScrollH;
 end;

 // Rappel si l'une des dimensions(hauteur ou largeur) de la page est infrieure
//  celle de la fentre client, HRange=0 ou VRange=0 et le scroll ne se fait pas
// puisque Paintscroll n'est pas appel
 if (HScrollCount > HRange)or (HScrollCount <0) then
  begin
   if (HScrollCount > HRange) then HScrollCount := HRange;
   if (HScrollCount <0)    then  HScrollCount :=0;
   end                           // Dans ce cas le scroll n'a pas lieu d'tre
 else
 if (VScrollCount > VRange)or (VScrollCount <0) then
  begin
   if (VScrollCount > VRange) then VScrollCount := VRange;
   if (VScrollCount <0)    then  VScrollCount :=0;
   end
 else  PaintScroll;    // Fonction qui provoque le dfilement de la fentre
                       // aprs avoir fait appel  CalcRange
 end;


//******************************************************************************/
procedure TGraphControl2.WMTimer(var Msg: TWMTimer);
var
comptH,comptV:integer;
begin
comptH:=0;
comptV:=0;

if ActivePage=nil then exit;

if FScrollDirection=noScroll then exit;
case FScrollDirection  of
  ScrollRight: comptH:=-1;
  ScrollLeft : comptH:=1;
  ScrollUp   : comptV:=+1;
  ScrollDown : comptV:=-1;
 end;

HScrollCount := HScrollCount+comptH;
VScrollCount := VScrollCount+comptV;

// Dans les deux cas suivants le scroll n'a pas lieu d'tre
// Rappel si l'une des dimensions(hauteur ou largeur) de la page est infrieure
//  celle de la fentre client, HRange=0 ou VRange=0 et le scroll ne se fait pas
// puisque Paintscroll n'est pas appel

if (HScrollCount > HRange)or (HScrollCount <0) then
  begin
   if (HScrollCount > HRange) then HScrollCount := HRange;
   if (HScrollCount <0)    then  HScrollCount :=0;
   end
 else
 if (VScrollCount > VRange)or (VScrollCount <0) then
  begin
   if (VScrollCount > VRange) then VScrollCount := VRange;
   if (VScrollCount <0)    then  VScrollCount :=0;
   end
 else
 begin
  PaintScroll;
  // Comme la page est redessine en mmoire  partir des objets graphiques sans
  // tenir compte de l'objet actif, il est inutile d'effacer l'objet actif avant
  // de le dessiner
   if FActiveObject<>nil then
     begin
      FActiveObject.FStartPt.x:= FActiveObject.FStartPt.x-(comptH*FUScrollH);
      FActiveObject.FStartPt.y:= FActiveObject.FStartPt.y-(comptV*FUScrollV);
     FActiveObject.paint(Point(0,0));
     end;
  end;

end;


//******************************************************************************/
function TGraphControl2.MouseEnter(point:TPoint):boolean;
begin
 if (FTimer)and(point.x>0) and (point.x<Clientwidth) and (point.y>0) and (point.y<Clientheight)
  then begin
   KillTimer(Handle,1);
   FTimer:=false;
  result:=true
  end
 else result:=false;
end;

function TGraphControl2.MouseOutClient(point:TPoint):boolean;
begin
 result:=false;
 if FTimer then
   begin
     if (point.x>0) and (point.x<Clientwidth) and (point.y>0) and (point.y<Clientheight)
        then result:=false
     else begin
       result:=true;
       if point.x<=0 then FScrollDirection:=scrollright
       else if point.x>=Clientwidth then FScrollDirection:=scrollleft
       else if point.y<=0 then  FScrollDirection:=scrolldown
       else if point.y>=Clientheight then FScrollDirection:=scrollUp;
     if FActiveObject<>nil then
      begin
       FActiveObject.FEndPt.x:=point.x;
       FActiveObject.FEndPt.y:=point.y;
      end;
   end;
end;
end;

function TGraphControl2.MouseExit(point:TPoint):boolean;
begin
 result:=false;
 if not FTimer then
   begin
     if (point.x>0) and (point.x<Clientwidth) and (point.y>0) and (point.y<Clientheight)
     then result:=false
   else begin
   SetTimer(Handle, 1, 1, nil);
   FTimer:=true;
   result:=true;
   if point.x<=0 then FScrollDirection:=scrollright
   else if point.x>=Clientwidth then FScrollDirection:=scrollleft
   else if point.y<=0 then  FScrollDirection:=scrolldown
   else if point.y>=Clientheight then FScrollDirection:=scrollUp;
   if FActiveObject<>nil then
    begin
     FActiveObject.FEndPt.x:=point.x;
     FActiveObject.FEndPt.y:=point.y;
    end;
   end;
end;   
if Assigned(FMouseExit) then FMouseExit(point);
end;

//******************************************************************************/
procedure TGraphControl2.WMVScroll(var Msg: TWMVScroll);
begin

if ActivePage=nil then exit;

case Msg.ScrollCode of

 sb_LineUp :VScrollCount := VScrollCount-1;  // Flche gauche
 sb_LineDown :VScrollCount := VScrollCount+1; // Flche droite

 sb_PageUp : VScrollCount := VScrollCount-2;
 sb_PageDown : VScrollCount := VScrollCount+2;

 sb_Top : VScrollCount :=0;
 sb_bottom :VScrollCount:=VRange;

 sb_ThumbPosition,
 sb_ThumbTrack : VScrollCount:=Msg.Pos div FUScrollV;
 end;

 if (VScrollCount > VRange)or (VScrollCount <0) then
  begin
   if (VScrollCount > VRange) then VScrollCount := VRange;
   if (VScrollCount <0)    then  VScrollCount :=0;
   end   // Dans ce cas le scroll n'a pas lieu d'tre

 else  PaintScroll;    // Fonction qui provoque le dfilement de la fentre
end;

//*****************************************************************************/
function TGraphControl2.CanClicDown(WPoint:TPoint) : boolean;
begin
Result:=true;
If Assigned(FCanClicDown) then FCanClicDown(WPoint,Result);
end;
//*****************************************************************************/
function TGraphControl2.CanClicActivate(WPoint:TPoint) : boolean;
begin
Result:=true;
If Assigned(FCanClicActivate) then FCanClicActivate(WPoint,Result);
end;

//********************************************************************************/
procedure TGraphControl2.MouseUp(Button :TMouseButton; Shift: TShiftState;X,Y:Integer);
 var
 ClicObj: TGraphObject;
 PagePoint :TPoint;
 ClientPoint,nullPoint :TPoint;
 PCurs:PCursorObj;
 begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;

 PCurs:=nil;

 nullPoint.x:=0;
 nullPoint.y:=0;

 ClientPoint.X:=X; // pour tenir compte du scrolling ventuel;
 ClientPoint.Y:=Y;

 PagePoint.X:=X+POriginX; // pour tenir compte du scrolling ventuel;
 PagePoint.Y:=Y+POriginY;

 if  FTimer then
  begin
   KillTimer(Handle,1);
   FTimer:=false;
  end;


 if FActiveObject<>nil then FActiveObject.Hide;

 ClicObj:=ActivePage.GetClicObject(PagePoint);

 if ClicObj<>nil then
   begin
     ClicObj:=ClicObj.MouseUp(Button,shift,PagePoint);
     if ClicObj <> nil then FClicUpObject :=ClicObj
     else FClicUpObject :=nil;
   end
  else FClicUpObject :=nil;

 if (crObjet in CurPrioritys) and (FClicUpObject<>nil)
      then PCurs:=FClicUpObject.GetPCursorObj(crUp);

 // Donc l'application a  sa disposition pour rpondre
 // - L'objet,si il existe, sur lequel  eu lieu le premier clic de souris : FclicdownObject
 // - Le dernier objet,si il existe, sur lequel la souris a t dplac : FClicDragObject
 // - l'objet, si il existe, o a lieu le clic Up :FClicUpObject.
 // - L'objet actif qui a ses coordonnes en 'mmoire'

 RespClicUp(ClientPoint);
 if FActiveObject <> nil then FActiveObject.free;

 paintScroll;

 DrawingMode:=false;
 FActiveObject:=nil;
 FClicDownObject:=nil;
 FClicUpObject:=nil;
 FMouseMoveObject :=nil;
 FMouseDragObject:=nil;
 inherited MouseUp(Button, Shift, X, Y);
end;


//*****************************************************************************/
procedure TGraphControl2.MouseDown(Button :TMouseButton; Shift: TShiftState;X,Y:Integer);
 var
 ClicObj: TGraphObject;
 PagePoint :TPoint;
 ClientPoint :TPoint;
 PCurs:PCursorObj;
 begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;

 if FTimer=true then exit;

 PCurs:=nil;

 ClientPoint.X:=X; // pour tenir compte du scrolling ventuel;
 ClientPoint.Y:=Y;

 PagePoint.X:=X+POriginX; // pour tenir compte du scrolling ventuel;
 PagePoint.Y:=Y+POriginY;

 FClicDownObject:=nil;
 FClicUpObject:=nil;
 FActiveObject:=nil;
 FMouseMoveObject :=nil;
 FMouseDragObject:=nil;

 DrawingMode:=false;

 // L'application peut interdire toute rponse  un clic

 if not CanClicDown(ClientPoint) then exit;


 ClicObj:=ActivePage.GetClicObject(PagePoint);
 if ClicObj <> nil then
   begin
     ClicObj:=ClicObj.MouseDown(Button,shift,PagePoint);
     // Cette fonction doit permettre  un objet de garder les coordonnes de la souris
     // Cette fonction est trs importante : elle peut changer la nature de l'objet
     // qui rpond. Par exemple si le clic a lieu sur une poigne d'un objet
     // redimensionnable, la poigne va retourner par dfaut son objet pere c.a.d
     // l'objet redimensionnable lui mme.
     // Cette fonction peut galement forcer un objet  se redessiner (cas d'un
     // bouton qui s'enfonce par exemple ; dans ce cas
     // l'objet doit se redessiner en forant le raffichage de la fentre par la
     // fonction UpdateWindow(Parent.FHandle) pour que l'object actif soit ensuite
     // redessin

       if ClicObj <> nil then
        begin
         FClicDownObject :=ClicObj;
         FClicUpObject:=ClicObj;

         // CreateActiveObject cre un objet actif et initialise ces coordonnes
         if CanClicActivate(ClientPoint)then
            FActiveObject:=ClicObj.CreateActiveObject(PagePoint) ;
        end;
   end;
   // Mme si le clic de souris a eu lieu en dehors d'un objet, l'application
   // peut crer un objet actif  condition d'initialiser ces coordonnes

   RespClicDown(ClientPoint);

   if FActiveObject<> nil then
     begin
       DrawingMode:=true;
       // on dessine pour la premire fois l'objet actif
       FActiveObject.paint(ClientPoint);

      if crActif in CurPrioritys then PCurs:=FActiveObject.GetPCursorObj(crdown);
     end
   else
     begin
      if (crObjet in CurPrioritys) and (FClicDownObject<>nil)
      then PCurs:=FClicDownObject.GetPCursorObj(crdown);
     end;

inherited MouseDown(Button, Shift, X, Y);
end;
//******************************************************************************/
procedure TGraphControl2.MouseMove(Shift: TShiftState; X, Y: Integer);
var
 ClicObj: TGraphObject;

 PagePoint :TPoint;
 nullPoint :TPoint;
 ClientPoint :TPoint;

 PCurs:PCursorObj;
 begin

 if not HandleAllocated then exit;
 if ActivePage=nil then exit;

 PCurs:=nil;

 nullPoint.x:=0;
 nullPoint.y:=0;

 ClientPoint.X:=X;
 ClientPoint.Y:=Y;

 PagePoint.X:=X+POriginX; // pour tenir compte du scrolling ventuel;
 PagePoint.Y:=Y+POriginY;

if not DrawingMode  then  // la souris se dplace sans qu'il y ait eu de clic au pralable
 begin
   FMouseDragObject:=nil;
   ClicObj:=ACtivePage.GetClicObject(PagePoint);

   if ClicObj<> nil then
     begin
      ClicObj:=ClicObj.MouseMove(shift,PagePoint);
      if ClicObj<> nil then FMouseMoveObject:=ClicObj
      else FMouseMoveObject:=nil;
    end
   else FMouseMoveObject:=nil;
  // l'application peut crer une rponse au dplacement de la souris
  // sans que le curseur passe sur un  objet.

  RespMouseMove(ClientPoint);

 if (crObjet in CurPrioritys)and (FMouseMoveObject<>nil)
  then  PCurs:=FMouseMoveObject.GetPCursorObj(crmove);

 end;

 if DrawingMode  then  // la souris se dplace avec un clic au pralable
  begin
  // si le mouvement de la souris a lieu en dehors de l'aire client c'est
  // le timer qui rentre en jeu
 // if (MouseEnter(ClientPoint)=false) and (FActiveObject<> nil) then FActiveObject.Hide;

  if MouseExit(ClientPoint)=true then exit;
  if MouseOutClient(ClientPoint)=true then exit;

  FMouseMoveObject:=nil;

 // l'objet actif doit s'effacer aprs ce premier appel;
  if MouseEnter(ClientPoint) then  PaintScroll

  else

  if FActiveObject<> nil then FActiveObject.Hide;

   ClicObj:=ActivePage.GetClicObject(PagePoint);
   if ClicObj<> nil then
    begin
      ClicObj:=ClicObj.MouseDrag(shift,PagePoint);
     // si un objet rpond en se redessinant il doit le faire par l'intermdiaire
     // de la mthode paint en appelant InvalidateRect et update cf essaipmxor
     if ClicObj<> nil then FMouseDragObject:=ClicObj
     else FMouseDragObject:=nil;
   end
  else FMouseDragObject:=nil;

 // l'application peut crer une rponse au dplacement de la souris avec le
 // bouton gauche enfonc sans que le curseur passe sur un  objet.

 RespMouseDrag(ClientPoint);

 // Attention il est important que le mode pmnotxor soit mis car l'objet  pu
 // se redessiner par la procdure ClicObj.MouseDrag ou l'application a pu modifier
 // le canvas au cours de la rponse RespMouseDrag

 // l'objet actif se redessine  une nouvelle position.

 if FActiveObject<> nil then FActiveObject.paint(ClientPoint);

 if (crActif in CurPrioritys) and (FMouseDragObject<>nil)
                  then PCurs:=FActiveObject.GetPCursorObj(crdown);

 if (crObjet in CurPrioritys)and (FMouseDragObject<>nil)
                  then PCurs:=FMouseDragObject.GetPCursorObj(crdrag);

 end;

//inherited MouseMove(Shift, X, Y);
end;

//******************************************************************************/
procedure TGraphControl2.SetCursor(indexCurs :integer; AName :string; crtype:TCursorIndex);
var
ind:integer;
begin
 case crtype of
  crdown : ind := 0;
  crmove : ind := 1;
  crup   : ind := 2;
  crDrag : ind := 3;
 end;
 FCursor[ind].index:=indexCurs;
 FCursor[ind].Name:=AName;
 end;

//******************************************************************************/
procedure TGraphControl2.RespClicDown(ClientPoint:TPoint);
 begin
  If Assigned(FRespClicDown) then FRespClicDown(ClientPoint);
 end;
//******************************************************************************/
procedure TGraphControl2.RespClicUp(ClientPoint:TPoint);
 begin
  If Assigned(FRespClicUp) then FRespClicUp(ClientPoint);
 end;
//******************************************************************************/
procedure TGraphControl2.RespMouseMove(ClientPoint:TPoint);
 begin
  If Assigned(FRespMouseMove) then FRespMouseMove(ClientPoint);
 end;
//******************************************************************************/
procedure TGraphControl2.RespMouseDrag(ClientPoint:TPoint);
 begin
  If Assigned(FRespMouseDrag) then FRespMouseDrag(ClientPoint);
 end;
 //******************************************************************************/
procedure TGraphControl2.RespActiveObjectUp(ClientPoint:TPoint);
 begin
  If Assigned(FRespMouseDrag) then FRespMouseDrag(ClientPoint);
 end;


procedure Register;
begin
  RegisterComponents('Phylo', [TGraphControl2]);
end;

end.
