unit ListInteger;
{$R-}

interface
uses SysUtils,classes;

const

{ Maximum TList size }

  MaxListSize = Maxint div 16;
{ TList class }

type 
  TIntegerList = array[0..MaxListSize - 1] of Integer;
  PIntegerList = ^TIntegerList;
  
  TListInteger = class(TObject)
  private
    FList: PIntegerList;
    FCount: Integer;
    FCapacity: Integer;
    FNumError :integer;
    
  protected
    function Get(Index: Integer): Integer;

    procedure Grow; virtual;
    procedure Put(Index: Integer; Item: Integer);

    procedure SetCapacity(NewCapacity: Integer);
    procedure SetCount(NewCount: Integer);

  public
    constructor Create;
    constructor CreateInit(init :integer);

    destructor Destroy; override;
    function Add(Item: Integer): Integer;
    procedure Clear;
    procedure Delete(Index: Integer);
    procedure Exchange(Index1, Index2: Integer);
    function Expand: TListInteger;

    procedure Insert(Index: Integer; Item: Integer);

    property NumError: integer read FNumError write FNumError;
    property Capacity: Integer read FCapacity write SetCapacity;
    property Count: Integer read FCount write SetCount;
    property Items[Index: Integer]: Integer read Get write Put; default;
    property List: PIntegerList read FList;
  end;

TTabInteger = class(TObject)
 private
 ListRow:TList;
 FNumError :integer;

 function GetRowCount: integer;

 protected

 procedure PutItem(ARow:integer ;ACol : integer; value :integer); // Appel setItem
 function GetItem(Arow,ACol :integer) :integer ;     // *** fait

 procedure PutRow(ARow:integer; List:TListinteger); // Appel setRow (cf property)
 function GetRow(ARow:integer): TlistInteger;

 public

 constructor create;
 destructor Destroy; override;

 property Items[ARow,ACol :integer]:integer read GetItem write PutItem;
 property Row[ARow :integer]:TListInteger read GetRow write PutRow;
 property RowCount:integer read GetRowCount;

 end;

implementation


constructor TListInteger.Create;
 begin
 FCount:=0;
 FCapacity:=100;
 FNumError:=0;
 FList:=AllocMem(FCapacity*SizeOf(integer));
 end;

constructor TListInteger.CreateInit(init :integer);
 begin
 FCount:=0;
 FCapacity:=Init;
 FNumError:=0;
 FList:=AllocMem(FCapacity*SizeOf(integer));
 end;

destructor TListInteger.Destroy;
begin
  FreeMem(FList,FCapacity*SizeOf(integer));
end;

function TListInteger.Add(Item: Integer): Integer;
begin
  
  if FCount = FCapacity then Grow;
  FList^[FCount] := Item;
  Inc(FCount);
  Result := FCount;
end;

procedure TListInteger.Clear;
begin
  SetCount(0);
  SetCapacity(0);
end;

procedure TListInteger.Delete(Index: Integer);
begin
  if (Index < 0) or (Index >= FCount) then exit;

  Dec(FCount);
  if Index < FCount then
    System.Move(FList^[Index + 1], FList^[Index],
      (FCount - Index) * SizeOf(Integer));
end;


procedure TListInteger.Exchange(Index1, Index2: Integer);
var
  Item: Integer;
begin
  if (Index1 < 0) or (Index1 >= FCount) then exit;
  if (Index2 < 0) or (Index2 >= FCount) then exit;

  Item := FList^[Index1];
  FList^[Index1] := FList^[Index2];
  FList^[Index2] := Item;
end;

function TListInteger.Expand: TListInteger;
begin
  if FCount = FCapacity then Grow;
  Result := Self;
end;



function TListInteger.Get(Index: Integer): Integer;
begin
  if (Index < 0) or (Index >= FCount) then Result:=FNumError
  else Result := FList^[Index];
end;

procedure TListInteger.Grow;
var
  Delta: Integer;
begin
  if FCapacity > 64 then Delta := FCapacity div 4 else
    if FCapacity > 8 then Delta := 16 else
      Delta := 4;
  SetCapacity(FCapacity + Delta);
end;


procedure TListInteger.Insert(Index: Integer; Item: Integer);
begin
   if (Index < 0)  then exit;
   if (Index >= FCount)then Count:=Index+1
   else
    begin
     if FCount = FCapacity then Grow;
     System.Move(FList^[Index], FList^[Index + 1],(FCount - Index) * SizeOf(Integer));
     Inc(FCount);
    end;
  FList^[Index] := Item;
end;



procedure TListInteger.Put(Index: Integer; Item: Integer);
begin
  if (Index < 0) then exit ;
  if (Index >= FCount) then Count:=Index+1;
  FList^[Index] := Item;
end;



procedure TListInteger.SetCapacity(NewCapacity: Integer);
begin
  if (NewCapacity < FCount) or (NewCapacity > MaxListSize) then exit;

  if NewCapacity <> FCapacity then
  begin
    ReallocMem(FList, NewCapacity * SizeOf(Integer));
    FillChar(FList^[FCapacity], (NewCapacity - FCapacity) * SizeOf(Integer), 0);
    FCapacity := NewCapacity;
  end;
end;

procedure TListInteger.SetCount(NewCount: Integer);
begin
  if (NewCount < 0) or (NewCount > MaxListSize) then exit;

  if NewCount > FCapacity then SetCapacity(NewCount);
  if NewCount > FCount then
    FillChar(FList^[FCount], (NewCount - FCount) * SizeOf(Integer), 0);
  FCount := NewCount;
end;

function TTabInteger.GetRow(ARow:integer): TListinteger;
begin
  Result:=nil;
  if (ARow <ListRow.Count) or (ARow>=0) then
    if ListRow.Items[ARow]<> NIL then Result:=TListInteger(ListRow.Items[ARow]);
end;
//*****************************************************************************/

procedure TTabInteger.PutRow(ARow:integer; List:TListInteger );
var
  i:integer;

begin
    if ARow+1 > ListRow.Count then
    for i:=ListRow.Count to ARow do ListRow.Add(NIL);
     ListRow.Items[ARow]:=List;
end;
 //****************************************************************************/

function TTabInteger.GetItem(ARow,ACol : integer):integer;
 var
  sublist: TListinteger;
begin
  Result:=FNumError;
  if (ARow+1 > ListRow.Count) or (ACol<0) or (ARow<0) then Exit;
  if ListRow.Items[ARow] = NIL then Exit;

  sublist:=TListInteger(ListRow.Items[ARow]);
  if ACol+1 > sublist.Count then Exit;

  Result:=sublist.Items[ACol];
end;
//******************************************************************************/
procedure TTabInteger.PutItem(ARow,ACol : integer; value :integer);

var
  i:integer;
  sublist:TListInteger;

 begin
   if ARow+1 > ListRow.Count then
    for i:=ListRow.Count to ARow do  ListRow.Add(NIL);

  if ListRow.Items[ARow] = NIL then  ListRow.Items[ARow]:=TListInteger.Create;

  sublist:=TListInteger(ListRow.Items[ARow]);

  if ACol+1 > sublist.Count then
   for i:=sublist.Count to ACol do sublist.Add(FNumError);

  sublist.Items[ACol]:=value;
 end;
{****************************************************************************}
function TTabInteger.GetRowCount: integer;
begin
result:=ListRow.Count;
end;
//******************************************************************************/
constructor TTabInteger.create;
begin
ListRow:=Tlist.Create;
FNumError:=-1
end;

destructor TTabInteger.Destroy;
var
 row :integer;
 sublist:TListInteger;
 begin
 for row:=0 to ListRow.Count-1 do
  begin
     sublist:=getRow(row);
     if sublist<>nil then sublist.free;
  end;
  ListRow.free;
end;

end.
