unit MyGrid;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids,strbox,ListArray;

type
  TFileMolecule=(null,pir,bas,aln);
  TMyAlign=(alRight,alLeft,alCenter);
  TCompare=(nocompare,colortext,colorrect);

  TMyCustomGrid = class(TStringGrid)
  private

  FAlignValue:TMyAlign;

  FRowSelect:boolean; // Flag indiquant que les lignes peuvent tre slectionnes
  FColSelect:boolean; // Flag indiquant que les colonnes peuvent tre slectionnes

  FRowSelectAll:boolean;
  FColSelectAll:boolean;

  FColorSelect:TColor;
  FListArray :TStrListArray;
  
  FCompare:TCompare;
  FActiveEdit:boolean;

  FOnMouseDown: TMouseEvent;

  ListSelectRow :TStrings;
  ListSelectCol :TStrings;

  function IsSelectRow(row :longint):boolean;
  function IsSelectCol(col :longint):boolean;

  procedure SetSelectRow(row:longint; select:boolean);
  procedure SetSelectCol(col:longint; select:boolean);

  procedure SelectAllRow(select:boolean);
  procedure SelectAllCol(select:boolean);

  procedure FillCell(Color:TColor ; Rect :TRect);
  procedure RoundCell(ColorL:TColor;ColorR:TColor;Rect:TRect);

  protected  {*** protected***}

  function GetMaxFillRow : integer;
  function GetMaxFillColOfRow(row:integer):integer;
  function GetMaxFillCol :integer;

  function TextWidth(ACol,ARow:integer): integer;virtual;

  procedure DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);virtual;

  procedure SelfMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  procedure SetActiveEdit(active :boolean);

  procedure Click;override;

  public  {****public****}

  constructor Create(AOwner:TComponent);override;
  destructor Destroy; override;

  procedure AdjustColWidths;
  procedure AdjustColWidth(ACol:integer);

  function Contents2CSV(data:TMemorystream; csv:char; range:TGridRect):TMemorystream;
  procedure CSV2Contents(data:TStream; csv:char; range:TGridRect);
  procedure Contents2CSVClipboard(csv:char; range:TGridRect);
  procedure ClipboardCSV2Contents(csv:char; range:TGridRect);

  procedure CopyToClipboard;
  procedure CopyFromClipboard;

  procedure CopyToListArray;
  procedure CopyFromListArray(left :integer;top :integer);

  property MaxFillRow : integer read GetMaxFillRow;
  property MaxFillCol :integer read GetMaxFillCol;
  property MaxFillColOfRow[index:longint]:integer read GetMaxFillColOfRow;

  property SelectCol[index:longint]:boolean read IsSelectCol write SetSelectCol;
  property SelectRow[index:longint]:boolean read IsSelectRow write SetSelectRow;
  property AllColSelect : boolean read FColSelectAll  write SelectAllCol;
  property AllRowSelect : boolean read FRowSelectAll write SelectAllRow;
  property ListArray :TStrListArray read FListArray write FListArray;

  procedure SaveToFile(const filename:string);virtual; abstract;
  procedure LoadFromFile(const filename:string);virtual ;abstract;

  published

  property _AlignValue:TMyALign read FAlignValue write FAlignValue;
  property _RowSelect :boolean read FRowSelect write FRowselect;
  property _ColSelect :boolean read FColSelect write FColSelect;
  property _ColorSelect : TColor read FColorSelect write FColorSelect;
  property _ActiveEdit :boolean read FActiveEdit write SetActiveEdit;
  property _Compare :TCompare read FCompare write FCompare ;


  property OnMouseDown: TMouseEvent read FOnMouseDown write FOnMouseDown;

  end;

{******************************************************************************}
 TTabGrid = class(TMyCustomGrid)
  private

  FTextVertical:boolean;
  FMultiline :boolean;

  protected

  function TextHeight(ACol,ARow:integer): integer;
  function TextWidth(ACol,ARow:integer): integer;override;

  procedure AdjustRowHeights;
  procedure AdjustRowHeight(Arow :integer);

  procedure DrawCellTextVertical(ACol,ARow:longint; ARect :TRect);
  procedure DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState); override;
  procedure Paint; override;

   public

  constructor Create(AOwner:TComponent);override;

  procedure SaveToFile(const filename:string);
  procedure LoadFromFile(const filename:string);

  published
  property _Multiline :boolean read FMultiline write FMultiline;
  property _TextVertical :boolean read FTextVertical write FTextVertical;
  end;

 {******************************************************************************}
 {******************************************************************************}

 TMolGrid = class(TMyCustomGrid)
  private
  { A rajouter }
  FFileMolecule :TFileMolecule;
  procedure LoadAlnMol(filename :string; TabMol:TStrings) ;

  protected

  procedure DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState); override;
  procedure Paint; override;

  procedure LoadFromFileALN(const filename:string);
  procedure LoadFromFilePIR(const filename:string);
  procedure LoadFromFileBAS(const filename:string);
  procedure LoadFromFileMOL(const filename:string);

  procedure DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);override;

  public
  constructor Create(AOwner:TComponent);override;

  //procedure SaveToFile(const filename:string); override;
  procedure LoadFromFile(const filename:string);override;

  property FileMolecule:TFileMolecule read FFileMolecule write FFileMolecule;

  published
  end;

{******************************************************************************}
procedure Stream2Clipboard(stream:TStream; format:integer);
procedure Clipboard2Stream(stream:TStream; format:integer);

procedure Register;

implementation
var
colorrectbis:TColor;
//**********function GetPointer(index: integer; memblock: THandle):pointer;
function GetPointer(index: integer; memblock: THandle):pointer;
begin
  result:=pointer(longint(GlobalLock(memblock))+index);
  end;

(*@/// function min(x,y: longint):longint; *)
function min(x,y: longint):longint;
begin
  if x<y then result:=x
         else result:=y;
  end;
(*@\\\*)
(*@/// function max(x,y: longint):longint; *)
function max(x,y: longint):longint;
begin
  if x>y then result:=x
         else result:=y;
  end;
(*@\\\*)

{ Write a string into a stream }
(*@/// procedure String2Stream(stream:TMemorystream; const s:string); *)
procedure String2Stream(stream:TMemorystream; const s:string);
begin
  stream.write(s[1],length(s));
  end;
  (*@/// procedure Stream2Clipboard(stream:TStream; format:integer); *)

procedure Stream2Clipboard(stream:TStream; format:integer);
const
  max_write = $8000;    (* must obey ($10000 mod max_write = 0) for Delphi 1 *)
var
  size: longint;
  s: word;
  curpos: longint;
  Memblock: THandle;
  FClipboardWindow: THandle;
begin
  FClipboardWindow := Application.Handle;
  if FClipboardWindow = 0 then
    FClipboardWindow := AllocateHWnd(NIL);
  OpenClipboard(FClipboardWindow);

  stream.seek(0,0);
  size:=stream.size;
  stream.seek(0,0);
  MemBlock:=GlobalAlloc(gmem_moveable or gmem_zeroinit,size+1);
  curpos:=0;
  while curpos+1<size do begin
    s:=stream.read(getPointer(curpos,MemBlock)^,min(max_write,size-curpos));
    inc(curpos,s);
    GlobalUnLock(MemBlock);
    if s=0 then BREAK;
    end;
  char(getPointer(curpos,memblock)^):=#0;
  GlobalUnLock(MemBlock);
  EmptyClipBoard;
  SetClipBoardData(format,memblock);

  CloseClipboard;
  if FClipboardWindow<>Application.Handle then
    DeallocateHWnd(FClipboardWindow);
  end;
(*@\\\*)
(*@/// procedure Clipboard2Stream(stream:TStream; format:integer); *)
procedure Clipboard2Stream(stream:TStream; format:integer);
const
  max_read = $8000;   (* must obey ($10000 mod max_read = 0) for Delphi 1 *)
var
  size: longint;
  curpos: longint;
  Memblock: THandle;
  FClipboardWindow: THandle;
begin
  FClipboardWindow := Application.Handle;
  if FClipboardWindow = 0 then
    FClipboardWindow := AllocateHWnd(NIL);
  OpenClipboard(FClipboardWindow);

  stream.seek(0,0);
  MemBlock:=GetClipboardData(format);
  size:=GlobalSize(Memblock);
  curpos:=0;
  while curpos+1<size do begin
    stream.write(getPointer(curpos,MemBlock)^,min(max_read,size-curpos-1));
    inc(curpos,min(max_read,size-curpos-1));
    GlobalUnLock(MemBlock);
    end;

  CloseClipboard;
  if FClipboardWindow<>Application.Handle then
    DeallocateHWnd(FClipboardWindow);
  end;
(*@\\\0000001024*)
(*@\\\0000000F01*)

(*@\\\*)


//*****************************************************************************/
procedure TMyCustomGrid.Click;
begin
  if ((FCompare<>NoCompare) and FActiveEdit) then invalidate;
  inherited Click;
end;

{******************************************************************************
                         Constructeur
 ******************************************************************************}
constructor TMyCustomGrid.Create(AOwner:TComponent);
var
index:integer;
begin
inherited Create(AOwner);
colorrectbis:=clblue;
options:=[goFixedVertLine,goFixedHorzLine,
          goVertLine,goHorzLine,goRangeSelect];

ListSelectRow:=TStringList.create;
ListSelectCol:=TStringList.Create;

FListArray:=nil;
FRowSelect:=true;
FColSelect:=true;
FColorSelect:=clLtGray;
FAlignValue:=alLeft;
FActiveEdit:=false;
DefaultDrawing:=true;

FRowSelectAll:=false;
FColSelectAll:=false;

Inherited OnMouseDown:=SelfMouseDown;

FOnMouseDown:=nil;
FCompare:=NoCompare;

FColSelectAll:=false;
FRowSelectAll:=true;

EditorMode:=false;

for index:=0 to RowCount-1 do ListselectRow.Add('N');
for index:=0 to ColCount-1 do ListselectCol.Add('N');

end;
{******************************************************************************
                         Destructeur
 ******************************************************************************}
destructor TMyCustomGrid.Destroy;
begin
ListselectRow.Free;
ListselectCol.Free;

inherited Destroy;
end;
{******************************************************************************
                         Destructeur
 ******************************************************************************}
procedure TMyCustomGrid.CopyToListArray;
var
Pstr :^string;
col,row:integer;
begin
if FListArray=nil then FListArray:=TStrListArray.Create;
 for col:=0 to ColCount-1 do
 begin
  for row:=0 to RowCount-1 do
     ListArray.StrItems[row,col]:=Cells[col,row];
 end;
end;
{******************************************************************************

 ******************************************************************************}
procedure TMyCustomGrid.CopyFromListArray(left :integer;top :integer);
var
AString :string;
col,row:integer;
MaxCol,MaxRow:integer;

begin
if FListArray=nil then Exit;
ListArray.GetMaxDim(MaxCol,MaxRow);

ColCount:=MaxCol+left+1;  // +1 car left reprsente un indice et non une quantit
RowCount:=MaxRow+top+1;   // idem

for col:=0 to ColCount-1 do
 begin
  for row:=0 to RowCount-1 do
  begin
   if (col<left) or (row<top) then Cells[col,row]:=''
   else begin
       Astring:=ListArray.StrItems[row-top,col-left];
       if AString<>'' then Cells[col,row]:=AString
                      else Cells[col,row]:='';
        end;
  end;
 end;
end;       


  

{******************************************************************************
                         MouseDown
 ******************************************************************************}
procedure TMyCustomGrid.SelfMouseDown(Sender:TObject;Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
row,col:longint;
begin
 MouseToCell(X,Y,col,row);

 if ((FGridState<>gsRowsizing) and (FGridState<>gsColSizing)
 and (FGridState<>gsRowmoving)and (FGridState<>GsColMoving))then
  begin
  if ((FRowSelect) and (FixedCols>0) and (col<FixedCols) and (row<>0)) then
   begin
     if IsSelectRow(row) then SetSelectRow(row,false) else SetSelectRow(row,true);
     InvalidateCell(col,row);
   end;

   if ((FColSelect) and (FixedRows>0) and (col<>0) and (row<FixedRows)) then
   begin
     if IsSelectCol(col) then SetSelectCol(col,false) else SetSelectCol(col,true);
     InvalidateCell(col,row);
   end;
 end;
 if( Assigned(FOnMouseDown)) then FOnMouseDown(self,Button, Shift, X, Y);

end;
{******************************************************************************
                         FillCell
 ******************************************************************************}
procedure TMyCustomGrid.FillCell(color :TColor ; Rect :TRect);
var
 OldPstyle: TPenStyle;
 OldBstyle :TBrushStyle;
 OldPenColor :TColor;
 OldBrushColor :TColor;

begin
 with canvas do begin

    OldPstyle:=Pen.Style;
    OldBstyle:=Brush.style;
    OldPenColor:=Pen.color;
    OldBrushColor:=Brush.color;

    Pen.Style:=psclear;
    Brush.Style:=bssolid;

    brush.color:=Color;
    Rectangle(Rect.Left,Rect.top,Rect.Right+1,Rect.Bottom+1);

    Pen.Style:=OldPstyle;
    Brush.style:=OldBstyle;
    Pen.color:=OldPenColor;
    Brush.color:=OldBrushColor;
  end;
end;

//******************************************************************************/
function TMyCustomGrid.TextWidth(ACol,ARow:integer): integer;
const
  min_width = 4;
 var
  width: integer;
  str: string;                          
begin
  str:=Cells[ACol, ARow];
  width:=0;
  if (trim(str)<>'') then
  begin
   width:=Canvas.TextWidth(str)+(2*min_width);
   if width<=min_width then width:=0;
  end;
 Result:= width;
end;

//******************************************************************************/
procedure TMyCustomGrid.AdjustColWidths;
var
ACol:integer;
begin
  for ACol:=0 to ColCount-1 do AdjustColWidth(ACol);
end;

//******************************************************************************/
procedure TMyCustomGrid.AdjustColWidth(ACol:integer);
var
  max: longint;
  width: longint;
  ARow: longint;
begin
  max:=0;
  if ACol>=ColCount then EXIT;
  if Cols[ACol].count>0 then begin  // Si la colonne est vide c'est inutile de calculer
   for ARow:=0 to RowCount-1 do
    begin
     width:=textwidth(ACol,ARow);
     if max<width then max:=width;
    end;
   if max=0 then max:=ColWidths[ACol];
   ColWidths[ACol]:=max;
   end;
  end;

//******************************************************************************/
procedure TMyCustomGrid.RoundCell(colorL :TColor ;colorR :TColor; Rect :TRect);
 var
 OldPstyle: TPenStyle;
 OldPenColor :TColor;

 begin
 with canvas do begin
 OldPstyle:=Pen.Style;
 OldPenColor:=Pen.color;

 Pen.Style:=psSolid;
 Pen.Color:=ColorL;

  MoveTo(Rect.Left,Rect.Bottom);
  LineTo(Rect.Left,Rect.Top+2);
  LineTo(Rect.Right,Rect.Top+2);

  MoveTo(Rect.Left+1,Rect.Bottom);
  LineTo(Rect.Left+1,Rect.Top+1);
  LineTo(Rect.Right-1,Rect.Top+1);

  Pen.Color:=ColorR;

    MoveTo(Rect.Right-1,Rect.top+1);
    LineTo(Rect.Right-1,Rect.bottom-1);
    LineTo(Rect.left,Rect.bottom-1);

    MoveTo(Rect.Right-2,Rect.top+1);
    LineTo(Rect.Right-2,Rect.bottom-2);
    LineTo(Rect.left,Rect.bottom-2);

   Pen.Style:=OldPstyle;
   Pen.color:=OldPenColor;
   end;
end;

{ ****************************************************************************}

function TMyCustomGrid.GetMaxFillRow : integer;
var
row, max ,nbcol:integer;
str:string;
begin
max:=-1;
for row:=0 to rowcount-1 do
  begin
  nbcol:=GetMaxFillColOfRow(row);
  if (nbcol>0) then max:=row;
  end;
result:=max+1;
end;

{****************************************************************************}
function TMyCustomGrid.GetMaxFillColOfRow(row:integer):integer;
var
col:integer;
max:integer;
str:string;

begin
max:=-1;
for col:=0 to ColCount-1 do
 begin
  str:=cells[col,row];
  if ((str<>'') and (Trim(str)<>''))then max:=col;
 end;
 result:=max+1;
end;
{******************************************************************************}

function TMyCustomGrid.GetMaxFillCol :integer;
var
row,col,maxrow,max:integer;
str:string;
begin

maxrow:=GetMaxFillRow;
max:=-1;

for row:=0 to maxrow-1 do
  begin
   for col:=0 to ColCount-1 do
    begin
     str:=cells[col,row];
     if ((str<>'') and (Trim(str)<>''))then
      begin
       if max<col then max:=col;
      end;
    end;
  end;
result:=max+1;
end;

{*******************************************************************************}

procedure TMyCustomGrid.SetActiveEdit(active :boolean);
begin
if not active then
 begin
  Options:=Options-[goEditing];
  Options:=Options-[goAlwaysShowEditor];
  FActiveEdit:=false;
 end
else begin

  Options:=Options+[goEditing];
  FActiveEdit:=true;
 end;
end;
//******************************************************************************/
function TMyCustomGrid.IsSelectRow(row :longint):boolean;
begin
Result:=false;
if row>=ListSelectRow.Count then exit;
if ListSelectRow[row]='Y' then Result:=true;
end;
//******************************************************************************/
function TMyCustomGrid.IsSelectCol(col :longint):boolean;
begin
Result:=false;
if col>=ListSelectCol.Count then exit;
if ListSelectCol[col]='Y' then Result:=true;
end;
//******************************************************************************/
procedure TMyCustomGrid.SetSelectRow(row:longint; select:boolean);
var
index:integer;
begin
if (row>=ListSelectRow.Count) then
 begin
  for index:=ListSelectRow.Count-1 to row do ListSelectRow.add('N');
 end;
if select then ListSelectRow[row]:='Y' else ListSelectRow[row]:='N';
end;
//******************************************************************************/
procedure TMyCustomGrid.SetSelectCol(col:integer;select:boolean);
var
index:integer;
begin
if (col>=ListSelectCol.Count) then
 begin
  for index:=ListSelectCol.Count-1 to col do ListSelectCol.add('N');
 end;
if select then ListSelectCol[col]:='Y' else ListSelectCol[col]:='N';
end;
//******************************************************************************/
procedure TMyCustomGrid.SelectAllRow(select:boolean);
var
row:integer;
begin
 for row:=0 to ListSelectRow.Count-1 do
 begin
  if select then ListSelectRow[row]:='Y'
  else ListSelectRow[row]:='N';
  end;
end;
//******************************************************************************/
procedure TMyCustomGrid.SelectAllCol(select:boolean);
var
col:integer;
begin
 for col:=0 to ListSelectCol.Count-1 do
 begin
  if select then ListSelectCol[col]:='Y'
  else ListSelectCol[col]:='N';
 end; 
end;

//*****************************************************************************/
(*@\\\*)
(*@/// function TMyCustomGrid.Contents2CSV(data:TMemorystream; csv:char; range:TGridRect):TMemorystream; *)
function TMyCustomGrid.Contents2CSV(data:TMemorystream; csv:char; range:TGridRect):TMemorystream;
var
  ACol,ARow: integer;
  s: string;
begin
  if data<>NIL then
    result:=data
  else
    result:=TMemorystream.Create;
  if (range.right<range.left) or (range.right<0) then range.right:=self.colcount-1;
  if range.left<0 then range.left:=0;
  if (range.bottom<range.top) or (range.bottom<0) then range.bottom:=self.rowcount-1;
  if range.top<0 then range.top:=0;
  for ARow:=range.top to range.bottom do begin
    s:='';
    for ACol:=range.left to range.right do
      s:=s+cells[ACol,ARow]+csv;
    String2Stream(result,s+#13#10);
    end;
  end;
(*@\\\*)
(*@/// procedure TMyCustomGrid.CSV2Contents(data:TStream; csv:char; range:TGridRect); *)
procedure TMyCustomGrid.CSV2Contents(data:TStream; csv:char; range:TGridRect);
var
  h: TStringlist;
  i,ACol,ARow: integer;
  s: string;
begin
  if data=NIL then EXIT;
  if Range.Top<0 then Range.top:=0;
  if Range.left<0 then Range.left:=0;
  if Range.Bottom<range.top then range.bottom:=maxint;
  if Range.right<range.left then range.right:=maxint;
  h:=NIL;
  try
    h:=TStringlist.Create;
    data.seek(0,0);
    h.loadfromstream(data);
    ARow:=range.top;
    i:=0;
    while (i<h.count) and (ARow<=Range.bottom) do begin
      if ARow>=RowCount then RowCount:=RowCount+1;
      ACol:=range.left;
      s:=h.strings[i]+csv;
      while (ACol<=range.right) and (length(s)>1) do begin
        if ACol>=ColCount then ColCount:=ColCount+1;
        cells[ACol,ARow]:=copy(s,1,pos(csv,s)-1);
        s:=copy(s,pos(csv,s)+1,length(s));
        inc(ACol);
        end;
      inc(ARow);
      inc(i);
      end;
  finally
    h.free;
    end;
  end;

(*@/// procedure TMyCustomGrid.Contents2CSVClipboard(csv:char; range:TGridRect); *)
procedure TMyCustomGrid.Contents2CSVClipboard(csv:char; range:TGridRect);
var
  h: TMemorystream;
begin
  h:=NIL;
  try
    h:=TMemorystream.Create;
    Contents2CSV(h,csv,range);
    Stream2Clipboard(h,cf_text);
  finally
    h.free;
    end;
  end;
(*@\\\000000091F*)
(*@/// procedure TMyCustomGrid.ClipboardCSV2Contents(csv:char; range:TGridRect); *)
procedure TMyCustomGrid.ClipboardCSV2Contents(csv:char; range:TGridRect);
var
  h: TMemorystream;
begin
  h:=NIL;
  try
    h:=TMemorystream.Create;
    Clipboard2Stream(h,cf_text);
    CSV2Contents(h,csv,range);
  finally
    h.free;
    end;
  end;
(*@\\\000000081F*)

(*@/// procedure TMyCustomGrid.CopyToClipboard; *)
procedure TMyCustomGrid.CopyToClipboard;
var
  rect: TGridRect;
begin
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  Contents2CSVClipboard(#7,rect);
  end;
(*@\\\*)
(*@/// procedure TMyCustomGrid.CopyFromClipboard; *)
procedure TMyCustomGrid.CopyFromClipboard;
var
  rect: TGridRect;
begin
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  ClipboardCSV2Contents(#7,rect);
  end;
(*@\\\*)
{******************************************************************************
                        DrawCellText
 ******************************************************************************}
procedure TMyCustomGrid.DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);
var
  width,high: integer;
  Left,Top: integer;
  FirstMode:Integer;
  ident:boolean;
  AlignValue: TMyAlign;
  str,strfirst: string;

begin
  Top:=Arect.Top+2;

  ident:=false;
  Str:=Cells[Acol,Arow];

  { Si le Flag FCompare <> NoCompare le texte de la cellule est compar  celui
  de la cellule de la premire ligne  condition que la cellule n'appartienne
  pas  une ligne ou une colonne fixe }

 if ( (FCompare<>NoCompare) and (ACol>=FixedCols)and(ARow>=FixedRows))then
  begin
    strfirst:=Cells[Acol,1];
    if ((trim(str)<>'')and (Str=strfirst)) then
     begin
      if FCompare=ColorText then Canvas.Font.Color:=clRed
                             else FillCell(ClRed,ARect);
      end
     else Canvas.Font.color:=clblack;
  end;

 FirstMode:=SetBkMode(Canvas.Handle,transparent);

  width:=Canvas.TextWidth(str);
  high:=Canvas.TextHeight(str);

  case FAlignValue of
   alLeft: Left:=ARect.Left+2;
   alCenter: begin width:=( (Arect.Right-ARect.Left)-width ) div 2;
                   Left:=ARect.Left+width;
             end;
   alRight: Left:=ARect.Right-width-2;
  end;

  ExtTextOut(Canvas.Handle, Left, Top,option,
      @ARect, PChar(Str), length(str), nil);

  Canvas.Font.color:=clblack;
 SetBkMode(Canvas.Handle,FirstMode);
end;
//******************************************************************************/
//******************************************************************************/
                              {TabGrid}
//******************************************************************************/
//******************************************************************************/
constructor TTabGrid.Create(AOwner:TComponent);
begin
inherited Create(AOwner);

FTextVertical:=false;
FMultiline:=false;
end;

{******************************************************************************
                         DrawCell
 ******************************************************************************}
procedure TTabGrid.DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState);
  begin
     // Affichage des cellules appartenant  des lignes ou des colonnes Fixes
     if ((Acol<FixedCols) or (ARow<FixedRows)) then
     begin
      FillCell(clLtGray,ARect);
      if (((Acol<FixedCols)and (SelectRow[ARow]))
          or  ((ARow<FixedRows)and (SelectCol[ACol])))
         then RoundCell(clGray,clWhite,ARect)
         else RoundCell(clWhite,clGray,ARect);

       if (FTextVertical and (FixedRows=1) and (ARow<FixedRows)) then
       DrawCellText(Acol,Arow,ARect,ETO_CLIPPED);
      end
    // Affichage des cellules normales
    else
     begin
       if not defaultDrawing then FillCell(clWhite,ARect);
       DrawCellText(ACol,ARow,ARect,ETO_CLIPPED);
     end;

    if Assigned(OnDrawCell) then OnDrawCell(Self, ACol, ARow, ARect, AState);
 end;


{******************************************************************************
                         Paint
 ******************************************************************************}
 procedure TTabGrid.Paint;
var
Rect:TRect;
select:boolean;
row,col:integer;

begin
inherited Paint;

if(FixedCols>0) then
begin
 for row:=0 to RowCount-1 do
  begin
   for col:=0 to FixedCols-1 do
    begin
     Rect:=CellRect(col,row);
     Rect.bottom:=Rect.top+RowHeights[row];
     FillCell(clLtGray,Rect);
     if IsSelectRow(row) then RoundCell(clGray,clWhite,Rect)
                         else RoundCell(clWhite,clGray,Rect);
     DrawCellText(col,row,Rect,ETO_CLIPPED);
    end;
  end;
end;

if(FixedRows>0) then
begin
 for col:=0 to colCount-1 do
  begin
   for row:=0 to FixedRows-1 do
    begin
     Rect:=CellRect(col,row);
     Rect.Right:=Rect.Left+ColWidths[col];
     FillCell(clLtGray,Rect);
     if IsSelectCol(col) then RoundCell(clGray,clWhite,Rect)
                         else RoundCell(clWhite,clGray,Rect);
     if Row=0 then drawcellTextVertical(col,row,Rect)else                    
     DrawCellText(col,row,Rect,ETO_CLIPPED);
    end;
  end;
end;
end;

{*******************************************************************************}
procedure TTabGrid.SaveToFile(const filename:string);
var
  data: TMemoryStream;
  rect: TGridRect;
begin
  data:=NIL;
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  try
    data:=Contents2CSV(data,#7,rect);
    data.savetofile(filename);
  finally
    data.free;
    end;
  end;
(*@\\\*)
//******************************************************************************/
(*@/// procedure TTabGrid.LoadFromFile(const filename:string); *)
procedure TTabGrid.LoadFromFile(const filename:string);
var
  data: TFileStream;
  rect: TGridRect;
begin
  data:=NIL;
  rect.left:=-1;
  rect.right:=-1;
  rect.top:=-1;
  rect.bottom:=-1;
  try
    data:=TFileStream.Create(filename,fmOpenRead);
    CSV2Contents(data,#7,rect);
  finally
    data.free;
    end;
  end;
(*@\\\*)

//******************************************************************************/
procedure TTabGrid.AdjustRowHeights;
var
ARow :integer;
begin
  for ARow:=0 to RowCount-1 do AdjustRowHeight(Arow);
end;
//******************************************************************************/
procedure TTabGrid.AdjustRowHeight(Arow :integer);
var
max,ACol,height :integer;

 begin
  max:=0;
  if ARow>=RowCount then EXIT;
  if Rows[ARow].count>0 then begin  // Si la ligne est vide c'est inutile de calculer
   for ACol:=0 to ColCount-1 do
    begin
     height:=textHeight(ACol,ARow);
     if max<height then max:=height;
    end;
   RowHeights[ARow]:=max;
   end;
  end;
//******************************************************************************/
function TTabGrid.TextWidth(ACol,ARow:integer): integer;
const
  min_width = 4;
 var
  width: integer;
  str: string;
begin
  str:=Cells[ACol, ARow];
  width:=0;
  if (trim(str)<>'') then
  begin
  if (FMultiLine and (GetNbWord(str,#32)>1))then
    width:=Canvas.TextWidth(GetLargestWord(str,#32))+(2*min_width)
  else
    width:=Canvas.TextWidth(str)+(2*min_width);

  if width<=min_width then width:=0;
  end;
 Result:= width;
end;
//******************************************************************************/
function TTabGrid.TextHeight(ACol,ARow:integer): integer;
const
  min_height = 4;
var
  height,l: integer;
  str: string;
begin
  str:=Cells[ACol, ARow];
  height:=min_height;
  height:=Canvas.TextHeight(str)+height;
  if FMultiLine then height:=height*GetNbWord(str,#32);
  if height<=min_height then height:=0;
  result:= height;
end;
//******************************************************************************/
procedure TTabGrid.DrawCellTextVertical(ACol,ARow:longint; ARect :TRect);
var
NewFont, OldFont :TFont;
LogFont :TLogFont;
Str :string;
FirstMode:Integer;

begin
Str:=Cells[Acol,Arow];
NewFont:=TFont.Create;
OldFont:=TFont.Create;

NewFont.Assign(Canvas.Font);
OldFont.Assign(Canvas.Font);

NewFont.name:='times new roman';
NewFont.Height:=25;

GetObject(NewFont.Handle,sizeof(Logfont),@Logfont);
Logfont.lfEscapement:=900;
Logfont.lfOrientation:=900;

NewFont.Handle:=CreateFontIndirect(Logfont);

Canvas.Font.Assign(NewFont);
NewFont.free;

FirstMode:=SetBkMode(Canvas.Handle,transparent);

ExtTextOut(Canvas.Handle,ARect.left+2,ARect.Bottom+2,ETO_CLIPPED,
      @ARect, PChar(@str[1]), length(str), nil);

SetBkMode(Canvas.Handle,FirstMode);

Canvas.Font.Assign(OldFont);
OldFont.free;
end;

//******************************************************************************//
//******************************************************************************}
constructor TMolGrid.Create(AOwner:TComponent);
begin
FileMolecule:=null;
inherited Create(AOwner);
end;

//******************************************************************************/
 procedure TMolGrid.DrawCellText(ACol, ARow: Longint; ARect: TRect; Option :longint);
var
  width,high: integer;
  Left,Top: integer;
  FirstMode:Integer;
  ident:boolean;
  AlignValue: TMyAlign;
  str,strfirst: string;
  OldAlign :TMyAlign;
  options:integer;

begin
  Top:=Arect.Top+2;
  OldAlign:=_AlignValue;

  ident:=false;

  if ((ARow=0)and (ACol<>0)and((Acol mod 5)=0)) then
    begin str:=IntToStr(ACol);
     width:=Canvas.TextWidth(str);
     if width>ARect.right-ARect.Left-2 then _ALignValue:=alright
     else _ALignValue:=alcenter;
     end

  else if (ARow=0) then Exit
       else  Str:=Cells[Acol,Arow];

  { Si le Flag FCompare <> NoCompare le texte de la cellule est compar  celui
  de la cellule de la premire ligne  condition que la cellule n'appartienne
  pas  une ligne ou une colonne fixe }

 if ( (FCompare<>NoCompare) and (ACol>=FixedCols)and(ARow>=FixedRows))then
  begin
    strfirst:=Cells[Acol,1];
    if ((trim(str)<>'')and (Str=strfirst)) then
     begin
      if FCompare=ColorText then Canvas.Font.Color:=clRed
                             else FillCell(ClRed,ARect);
      end
     else Canvas.Font.color:=clblack;
  end;

 FirstMode:=SetBkMode(Canvas.Handle,transparent);

  width:=Canvas.TextWidth(str);
  high:=Canvas.TextHeight(str);

  case _AlignValue of
   alLeft: Left:=ARect.Left+2;
   alCenter: begin width:=( (Arect.Right-ARect.Left)-width ) div 2;
                   Left:=ARect.Left+width;
             end;
   alRight: Left:=ARect.Right-width;
  end;


  ExtTextOut(Canvas.Handle, Left, Top,option, @ARect, PChar(Str), length(str), nil);

  Canvas.Font.color:=clblack;
 SetBkMode(Canvas.Handle,FirstMode);
 _ALignValue:=OldAlign;

end;
//******************************************************************************//
procedure TMolGrid.DrawCell(ACol,ARow:Longint; Arect: TRect;AState:TGridDrawState);
  begin

     // Affichage des cellules appartenant  des lignes ou des colonnes Fixes
     if ((Acol<FixedCols) or (ARow<FixedRows)) then
     begin
        FillCell(clLtGray,ARect);
        if (Acol<FixedCols)then
         begin
          if (SelectRow[Arow])
            then RoundCell(clGray,clWhite,ARect)
            else RoundCell(clWhite,clGray,ARect);
          end;

        if (ARow<FixedRows) then
         begin
          if (SelectCol[ACol])
            then RoundCell(clGray,clWhite,ARect)
            else RoundCell(clLtGray,clLtGray,ARect);
         end;
         if  (ARow>=FixedRows)
           then DrawCellText(Acol,Arow,ARect,ETO_CLIPPED);
     end

    // Affichage des cellules normales
    else  begin
    if not defaultDrawing then FillCell(clWhite,ARect);
    DrawCellText(ACol,ARow,ARect,ETO_CLIPPED);
     end;

    if Assigned(OnDrawCell) then OnDrawCell(Self, ACol, ARow, ARect, AState);
 end;

//******************************************************************************}
procedure TMolGrid.Paint;
var
Rect:TRect;
select:boolean;
row,col,larg,MaxRow,Maxcol:integer;
stop:integer;

begin
inherited Paint;
MaxRow:=TopRow+VisibleRowcount;
Maxcol:=LeftCol+VisibleColCount;

if(FixedCols>0) then
begin
 for row:=TopRow to MaxRow-1 do
  begin
   for col:=0 to FixedCols-1 do
    begin
     Rect:=CellRect(col,row);
     Rect.bottom:=Rect.top+RowHeights[row];
     FillCell(clLtGray,Rect);
     if IsSelectRow(row) then RoundCell(clGray,clWhite,Rect)
                         else RoundCell(clWhite,clGray,Rect);
     DrawCellText(col,row,Rect,ETO_CLIPPED);
    end;
  end;
  if MaxRow<RowCount then begin
   for col:=0 to FixedCols-1 do
     begin
      Rect.top:=Rect.bottom;
      Rect.bottom:=Rect.top+RowHeights[MaxRow];
      FillCell(clLtGray,Rect);
      if IsSelectRow(Maxrow) then RoundCell(clGray,clWhite,Rect)
                            else RoundCell(clWhite,clGray,Rect);
      DrawCellText(col,Maxrow,Rect,ETO_CLIPPED);
   end;
   end;
end;

if(FixedRows>0) then
begin
  // Cette partie doit tre limite aux colonnes visibles, sinon Rect est nul et
 // l'affichage se fait dans la premiere cellule (0,0)
 for col:=leftcol to MaxCol-1 do
  begin
     Rect:=CellRect(col,0);
     Rect.Right:=Rect.Left+ColWidths[col];
     Rect.left:=Rect.left-1;   // Pour effacer les lignes noires dessines entre les cellules
     Rect.Right:=Rect.Right+1;
      FillCell(clLtGray,Rect);
   end;

 if MaxCol<ColCount then
  begin
     Rect.left:=Rect.Right;
     Rect.Right:=Rect.Left+ColWidths[Maxcol];
     FillCell(clLtGray,Rect);
  end;

  for col:=leftcol to MaxCol-1 do
  begin
     Rect:=CellRect(col,0);
     Rect.Right:=Rect.Left+ColWidths[col];
     DrawCellText(col,0,Rect,0);
  end;

 if MaxCol<ColCount then
  begin
    Rect.left:=Rect.Right+1;
     Rect.Right:=Rect.Left+ColWidths[Maxcol];
     DrawCellText(maxcol,0,Rect,0);
  end;

end;
end;

procedure TMolGrid.LoadAlnMol(filename :string; TabMol:TStrings) ;
var
Line,MolName:string;
MolStrings:TStringList;
TabMolName:TStringList;
index:integer;
indextab :integer;

begin
   MolStrings:=TStringList.create;
   TabMolName:=TStringList.create;

   MolStrings.LoadFromFile(fileName);

   for index:=1 to MolStrings.count-1 do // la premire ligne est ignor
    begin
      Line:=MolStrings[index];
      if line='' then continue ; // si la ligne est vide, on passe  la suivante
      MolName:=copy(line,0,16);

      indextab:=TabMolName.IndexOf(MolName);
      if indextab=-1 then      // si le nom de la molcule n'existe pas encore
           begin
           TabMolName.add(MolName);
           TabMol.add(Line);
           end
       else TabMol[indextab]:=TabMol[indextab]+copy(line,17,60);;
     end;
  MolStrings.free;
  TabMolName.free;
end;

procedure TMolGrid.LoadFromFile(const FileName:string);
var
Ext:string;
begin
 Ext:= ExtractFileExt(FileName);
 if Ext='.aln' then LoadFromFileALN(FileName)
 else if Ext='mol' then LoadFromFileMOL(FileName)
 else if Ext='bas' then LoadFromFileBAS(FileName)
 else if Ext='pir' then LoadFromFilePIR(FileName);
end;

//******************************************************************************/
procedure TMolGrid.LoadFromFileBAS(const Filename :string);
begin
end;
procedure TMolGrid.LoadFromFilePIR(const Filename :string);
begin
end;
procedure TMolGrid.LoadFromFileMOL(const Filename :string);
begin
end;
procedure TMolGrid.LoadFromFileALN(const Filename :string);
var
i,j :integer;
lon,max :integer;
TabMol :TStringList;
Tm:TTextMetric;

 begin
 if FileName='' then Exit;

 TabMol:=TStringList.Create;
 try
 LoadAlnMol(filename,TabMol);
 max:=0;
   for i:=0 to TabMol.Count-1 do
    begin
    lon:=length(TabMol[i]);
    if lon>max then max:=lon;
    Cells[0,i+1]:=copy(TabMol[i],0,16);

    for j:=17 to lon  do
       Cells[j-16,i+1]:=copy(TabMol[i],j,1);
    end;

   RowCount:=TabMol.Count+1;
   ColCount:=max-15; // Le nom de la molcule est sur 16 caractres
                                 // mais ne correspond en fait qu' une cellule
   AdjustColWidth(0);

   if (GetTextMetrics(Canvas.handle,Tm)) then
    begin
     for i:=1 to ColCount-1 do ColWidths[i]:=Tm.TmMaxCharWidth+4;
    end;

   FileMolecule:=aln;
  // ColWidths[105]:=ColWidths[105]+15;
   finally
    TabMol.free;
   end;
end;


procedure Register;
begin
  RegisterComponents('Phylo', [TTabGrid]);
  RegisterComponents('Phylo', [TMolGrid]);
end;

end.
