program Phylo;

uses
  Forms,
  SysUtils,
  Dialogs,
  BarreIc2bis in 'BarreIc2bis.pas',
  PhylMain in 'PhylMain.pas' {FormPrinc},
  PhylObs in 'PhylObs.pas' {FormObs},
  BarreIc in 'BarreIc.pas' {BarreIcones},
  Donnees in 'Donnees.pas',
  PhylAbout in 'PhylAbout.pas' {AboutBox},
  PhylBig in 'PhylBig.pas' {FormBig},
  PhylChoi in 'PhylChoi.pas' {FormChoisir},
  PhylPlch in 'PhylPlch.pas' {FormPlanche},
  PhylComp in 'PhylComp.pas' {FormComp},
  MyNewGrid in 'MyNewGrid.pas',
  PhylMol in 'PhylMol.pas' {FormMol},
  OptionsMol in 'OptionsMol.pas' {OptionForm},
  PhylTrier in 'PhylTrier.pas' {FormTri},
  TreeCLGR in 'TreeCLGR.pas' {FormArbre},
  optionleg in 'optionleg.pas' {FicheOptionLeg},
  optioncode in 'optioncode.pas' {FicheOptionCode},
  CODE in 'CODE.PAS' {FicheCode},
  BarreCar in 'BarreCar.pas' {BarreCaract},
  PhylDef in 'PhylDef.pas' {FormDefinition},
  TabGridMark in 'TabGridMark.pas',
  GraphControlTreeCL in 'GraphControlTreeCL.pas',
  PhylGlo in 'PhylGlo.pas' {FormGlossaire},
  group2 in 'group2.pas',
  FenEtatcarac in 'FenEtatcarac.pas' {FicheEtatCarac},
  CompCadreIma2 in 'CompCadreIma2.pas',
  boite in 'boite.pas',
  GraphTri3 in 'GraphTri3.pas',
  phylClasser in 'phylClasser.pas' {FormClasser};


{$R *.RES}
type
  TT_Exceptions=class
    private
    public
     constructor TT_Create;
     procedure Handle(Sender:TObject;E:Exception);
  end;

var
  T_Exceptions : TT_Exceptions;
  
constructor TT_Exceptions.TT_Create;
begin
   inherited Create;
   Application.OnException:=Self.Handle;
end;

procedure SpecialTerminate;
begin
   T_Exceptions.Free;
   Application.Terminate;
end;

procedure TT_Exceptions.Handle(Sender:TObject;E:Exception);
const
  CRLF=#13#10;
begin
  MessageDlg('Une erreur inopine s''est produite :'+CRLF+
              '"'+E.Message+'"'+CRLF+CRLF+
             ' Veuillez en informer Naoum Salam (ressources-acces@inrp.fr)'
             ,mtError,[mbOK],0);
  SpecialTerminate;
end;

begin
  T_Exceptions:= TT_Exceptions.TT_Create;
  Application.Initialize;
   Application.CreateForm(TBarreIcones2, BarreIcones2);
  Application.CreateForm(TFormPrinc, FormPrinc);
  Application.CreateForm(TBarreIcones, BarreIcones);
  //Application.CreateForm(TBarreIcones2, BarreIcones2);
  
  Application.CreateForm(TFormPlanche, FormPlanche);
  Application.CreateForm(TFormObs, FormObs);
  Application.CreateForm(TFormComp, FormComp);
  Application.CreateForm(TFormChoisir, FormChoisir);
  Application.CreateForm(TAboutBox, AboutBox);
  Application.CreateForm(TFormMol, FormMol);
  Application.CreateForm(TOptionForm, OptionForm);
  Application.CreateForm(TFormTri, FormTri);
  Application.CreateForm(TFormArbre, FormArbre);
  Application.CreateForm(TFicheOptionLeg, FicheOptionLeg);
  Application.CreateForm(TFicheOptionCode, FicheOptionCode);
  Application.CreateForm(TFicheCode, FicheCode);
  Application.CreateForm(TFormDefinition, FormDefinition);
  Application.CreateForm(TFormGlossaire, FormGlossaire);
  Application.CreateForm(TFicheEtatCarac, FicheEtatCarac);
  Application.CreateForm(TFormClasser, FormClasser);
  Application.Run;
end.
