
unit DataselMat;

interface

uses
  SysUtils,windows,Classes,math,ListArray2,ListInteger,strbox,typedef;
  
type



TDataSelect = class ;
TDataSelectDist =class;
//******************************************************************************/
TDistMatrix = class(TObject)
 protected

 
 Data : TDataSelectDist;

  public
 
 TabMatrix :TStrListArray;

 destructor destroy;override;
 constructor createMatrix(AData :TDataSelectDist); virtual;

 procedure PutName(name :string; i,j:integer);
 function  GetName(i,j :integer):string;

 procedure InitMatrice; virtual;
 procedure InitDistance ; virtual;

 function PaireWiseDist( row1,row2 : integer):double ;

 procedure PutDistance(dist :double; i,j :integer);
 function GetDistance(i,j : integer):double;

 function CalculerDistElem(row1,row2,col:integer; var total:integer):double; virtual;
 procedure FindDistMin(var row: integer;  var col:integer); virtual;
 function AverageDistance(row,col,no : integer):double; virtual;
end;

//******************************************************************************/

TUPGMAMatrix = class(TDistMatrix)
 protected

  MatSrc :TDistMatrix ;
  ColSrc :integer;
  RowSrc :integer;

 public
  constructor CreateFirstMatrix(AMat:TDistMatrix); virtual;
  constructor CreateNextMatrix(AMat:TDistMatrix;row,col:integer); virtual;

  procedure InitMatrice ; override;
  procedure InitDistance; override;

  function  NewDistance(noligne:integer ):double;virtual;
 end;

//******************************************************************************/


TNJMatrix = class (TUPGMAMatrix)
 protected
  NbCol :integer;
  NbRow :integer;

  procedure CalculDistPond;
  function  TotalRow(norow:integer):double;
  procedure Find_R;

 public
 procedure FindDistMin(var row :integer; var col : integer); override;
 function NewDistance(norow :integer):double; override;

 constructor CreateFirstMatrix(mat :TDistMatrix); override;
 constructor CreateNextMatrix(mat :TDistMatrix ;row,col :integer); override;

 procedure InitDistance;override;
 procedure InitMatrice ;override;
 function AverageDistance(row,col,no :integer):double; override;
 end;

TDataSelect = class(TObject)
 private
  TreeActionIndex :integer;


 protected
   ListTreeAction : TStringList;
   TabData : TstrListArray;     // tableau d'origine

   // lignes et colonnes slectionnes dans le tableau d'origine. Si il n'y a pas de
   // ligne ou de colonne selectionne, ce sont toutes les lignes et les colonnes
   // prsentes.

  public

 ListMaxRow :TListInteger;
 ListMaxCol :TListInteger;

 ListRow :TListInteger;
 ListCol :TListInteger;

constructor createDataSelect(tab : TStrListArray);virtual;
destructor destroy; override;

procedure AddNode_DND(var chaine : string ; name :string);

procedure  DeleteTreeAction;
procedure  RemoveTreeAction;
procedure  AddTreeAction( treename : string);
function  GetNextTreeAction: string;
function  GetPriorTreeAction:string;

function  GetNameOfCol(ListC : TListInteger; col: integer ):string;virtual;
function  GetNameOfDirectCol(col :integer ):string; virtual;

function  IsTabColFull(col :integer ):boolean;
function  IsTabRowFull( row :integer):boolean;

function  GetIndex(List :TListInteger;name :string):integer;

function  GetDirectNameOfRow(row : integer ):string;
function  GetNameOfRow(ListR :TListInteger;row :integer):string;

function  GetDirectData( row,col :integer):string;
function  GetData(ListR : TListInteger; ListC : TListInteger ; row,col :integer):string;

function  RemoveColCond(listr:TListInteger; listc:TListInteger;cond :string): TListInteger; virtual;
function  RemoveRowCond(listr:TListInteger; listc:TListInteger;cond :string):TListInteger;virtual;
function  RemoveEmptyRow(listr:TListInteger; listc:TListInteger):TListinteger;virtual;
function  RemoveEmptyCol(listr:TListInteger; listc:TListInteger):TListinteger;virtual;

procedure CreateListMax(listrowsel:TStrings; listColsel:Tstrings);
procedure CopyListMax(listrow : TListInteger ; listcol :TListInteger);
procedure ChangeListMaxCol( listColsel:Tstrings);

function  CreateList:boolean; virtual;

function  InitListCol: boolean;
function  InitListRow: boolean;
function RowCount : integer;

end;

//******************************************************************************/

TDataSelectDist =class (TDataSelect)
 protected
 FListMatrix: TList;
 FDistMatrix: TDistMatrix;
 
 FFormatDistance : TFormatDistance;
 FCalcDistance : TCalcDistance;
 FBaseCount : TBaseCount;
 FDeleteDistance : TDeleteDistance;

 public

  destructor destroy; override;
  constructor createDataSelect(tab : TStrListArray);override;
  
  procedure AdjustListBase(List :TListInteger; dep :integer);
  function RemoveEmptyCol(listr:TListInteger; listc:TListInteger):TListinteger; override;

  function  CreateNextMatrix(mat: TDistMatrix; row,col:integer):TDistMatrix;virtual;
  function  CreateFirstMatrix(mat:TDistMatrix):TDistMatrix;virtual;

  procedure Root_DND(List :TStringlist; dist :string);
  procedure InsertAndRemoveString_DND(List:TStringList;index,first,last :integer);
  function FindOtherItem_DND(List: TStringList; chaine1 :string ; pos :integer):integer;
  function FindPthL_DND(list :TstringList; posD : integer):integer ;
  procedure Adjust_DND(List :TStringlist);
  function CreateString_DND(list: TStringList):string;
  procedure Add_DND(list: TStringList; mat:TDistMatrix; row,col :integer);
  function Calculate_DND: string;
  property DistMatrix :TDistMatrix read FDistMatrix;
  property ListMatrix :TList read FListMatrix;

  property BaseCount :TBaseCount read FBaseCount write FBaseCount;
  property DeleteDistance : TDeleteDistance read FDeleteDistance write FDeleteDistance;
  property FormatDistance : TFormatDistance read FFormatDistance write FFormatDistance;
  property CalcDistance : TCalcDistance read  FCalcDistance write FCalcDistance;

  end;

TDataSelectDistUPGMA =class (TDataSelectDist)
  public

  function  CreateNextMatrix(mat: TDistMatrix; row,col:integer):TDistMatrix;override;
  function  CreateFirstMatrix(mat:TDistMatrix):TDistMatrix;override;
end;

TDataSelectDistNJ =class (TDataSelectDist)
  public

  function  CreateNextMatrix(mat: TDistMatrix; row,col:integer):TDistMatrix;override;
  function  CreateFirstMatrix(mat:TDistMatrix):TDistMatrix;override;
end;


//******************************************************************************/

TDataSelectCL =class (TDataSelect)
 protected

  TabCod : TStrListArray;
  
 public
  ListCarac : TListInteger;
  ListTaxon : TStringList;

 constructor CreateDataSelectCL(tab :TStrListArray ; tabcodage : TStrListArray);
 destructor destroy; override;

function   ErrorCod: TPoint ;virtual;


function   CreerListCarac:boolean; virtual;
function   CreerListTaxon:boolean;

procedure   ChangeTabCod(tab : TStrListArray); virtual ;
function   TransformToListCod(listetat:string; nomcarac:string):string;virtual;
function   TransformToListStr(listcod:TListInteger; nomcarac: string):string; virtual;
function   CopyMaxState(nomcarac : string ):string;virtual;
function   GetListEtat(nomtax: string; nomcarac: string):string; virtual;

function   GetIndexRow(str1:string; tab:TStrListArray; col,dep:integer):integer;
function   GetIndexCol(str:string ;tab :TStrListArray; row,dep:integer):integer;

procedure   TaxonRemove(nomtax :string) ;
function   GetTabData(row,col:integer; tab:TStrListArray):string;
function   GetTypeOfCarac(nomcarac: string):integer;virtual;

function  Create_DND :string;
function  Create_DND_Polytom :string;
end;


TDataSelectCLMol =class (TDataSelectCL)
 public

 TabCodage : array[0..122] of integer;

 function   GetTypeOfCarac(nomcarac:string):integer; override;
 function   CopyMaxState(str :string ):string; override;

 function   GetNameOfCol(ListC: TListInteger; col :integer ):string;override;
 function   GetNameOfDirectCol(col :integer): string; override;

 function   GetListEtat(nomtax:string; nomcarac:string):string;override;
 function   CreerListCarac: boolean;override;
 function   TransformToListCod(listetat :string; nul :string):string;override;
 function   TransformToListStr ( listcod: TListInteger; nomcarac: string):string; override;
 procedure   ChangeTabCod(Tab: TStrListArray); override;
 procedure   TabCodageCreate; virtual;
 function   ErrorCodMol(mol:string):TPoint;
end;

TDataSelectCLMolNuc =class (TDataSelectCLMol)
public
 function GetNameOfCol(ListC: TListInteger; col :integer ):string;override;
 function GetNameOfDirectCol(col :integer ):string; override;
 function ErrorCod : TPoint; override;
 procedure  TabCodageCreate; override;
end;

TDataSelectCLMolPro =class (TDataSelectCLMol)
public
 procedure TabCodageCreate; override;
 function GetNameOfCol(ListC: TListInteger; col : integer ):string;override;
 function GetNameOfDirectCol(col : integer ):string;override;
 function ErrorCod: TPoint;override;
end;

implementation

destructor TDistMatrix.destroy;
begin
 inherited;
 TabMatrix.free;
 end;

destructor  TDataSelect.destroy;
 begin
inherited;
  if (ListCol<>nil) then ListCol.free;
  if (ListRow<>nil) then ListRow.free;
  if (ListMaxCol<>nil) then ListMaxCol.free;
  if (ListMaxRow<>nil) then ListMaxRow.free;
  if (ListTreeAction<>nil) then ListTreeAction.free;
end;

destructor  TDataSelectDist.destroy;
var
Amatrix:TDistMatrix;
index:integer;

 begin
 inherited;
  if FDistMatrix<>nil then FDistMatrix.free;
  if FListMatrix<>nil then
   begin
    for index:=0 to FListMatrix.count-1 do
     begin
      Amatrix:=TDistMatrix(FListMatrix.Items[index]);
      Amatrix.free;
     end;
   FListMatrix.free;
   end;
 end;

constructor TDataSelectCL.CreateDataSelectCL(tab :TStrListArray ; tabcodage : TStrListArray);
begin
 inherited CreateDataSelect(tab);
 TabCod:=tabcodage;
end;

destructor  TDataSelectCL.destroy;
begin
 inherited;
 if ListCarac<>nil then ListCarac.free;
end;

constructor  TDataSelect.createDataSelect(tab : TStrListArray);
 begin
   inherited ;
   ListCol:=nil;
   ListRow:=nil;
   ListMaxCol:=nil;
   ListMaxRow:=nil;
   ListTreeAction:=nil;

   TabData:=tab;
   ListTreeAction:= TStringList.create;
   TreeActionIndex:=-1;



// ListActionTree est un container qui contient au maximum 10 sauvegardes
// correspondant  l'arbre avant une action le modifiant.
// La premire sauvegarde doit correspondre  l'arbre initial et ne peut tre
// modifie. Quand le container est plein, il est vid par le bas mais la premire
// sauvegarde est conserve.
 end;

constructor  TDataSelectDist.createDataSelect(tab : TStrListArray);
 begin
   inherited createDataSelect(tab);
    FFormatDistance := TPercentage;
    FCalcDistance := observed;
    FBaseCount:=allBase;
    FDeleteDistance:=allremoved;
 end;


 function TDataSelect.RowCount:integer;
begin
 result:=Tabdata.RowCount;
end; 
//*********************************************************************************/
procedure  TDataSelect.DeleteTreeAction;
 begin
  ListTreeAction.clear;
  TreeActionIndex:=-1;
 end;
//*********************************************************************************/
procedure  TDataSelect.RemoveTreeAction;
begin
  ListTreeAction.Delete(ListTreeAction.Count-1);
end;
//*********************************************************************************/
procedure  TDataSelect.AddTreeAction( treename : string);
begin
 if ListTreeAction.Count=10 then
   ListTreeAction.delete(1);
 ListTreeAction.Add(treename);
 TreeActionIndex:=ListTreeAction.Count-1;
end;
//*********************************************************************************/
// Cette fonction n'a de sens que si elle fait suite  "GetPriorAction"

function  TDataSelect.GetNextTreeAction: string;
var
  treename :string ;
 begin
  treename:='';
  if (TreeActionIndex<ListTreeAction.Count-1) then
    begin
    TreeActionIndex:=TreeActionIndex+1;
    treename:=ListTreeAction[TreeActionIndex];
    end;
  result:=treename;
end;
//********************************************************************************/
function  TDataSelect.GetPriorTreeAction:string;
var
  treename :string;
 begin
  treename:='';
  if (TreeActionIndex>=0) then
    begin
    TreeActionIndex:=TreeActionIndex-1;
    treename:=ListTreeAction[TreeActionIndex];
    end;
  result:=treename;
end;

//********************************************************************************/
function  TDataSelect.GetNameOfCol(ListC: TListInteger; col: integer ):string;
 var
 index: integer;
  begin
   index:=ListC.Items[col];
   result:=TabData.StrItems[0,index];
  end;
//**********************************************************************************/
function  TDataSelectCLMol.GetNameOfCol(ListC: TListInteger; col :integer ):string;
var
 index: integer;
 begin
 index:=ListC.Items[col];
 result:=IntToStr(index);
end;
//**********************************************************************************/
function  TDataSelectCLMolNuc.GetNameOfCol(ListC: TListInteger; col :integer ):string;
var
 index: integer;
 text :string;
 begin
 index:=ListC.Items[col];
 text:=IntToStr(index);
 result:='Base : '+text;
end;

//**********************************************************************************/
function  TDataSelectCLMolPro.GetNameOfCol(ListC: TListInteger; col : integer ):string;
var
 index: integer;
 text :string;
 begin
 index:=ListC.Items[col];
 text:=IntToStr(index);
 result:='A. amin : '+text;
end;
//**********************************************************************************/
function  TDataSelectCLMolNuc.GetNameOfDirectCol(col :integer ):string;
var
 text :string;
 begin
 text:=IntToStr(col);
 result:='Base : '+ text;
end;
//**********************************************************************************/
function  TDataSelectCLMolPro.GetNameOfDirectCol(col : integer ):string;
var
 text :string;
 begin
 text:=IntToStr(col);
 result:='A. amin : '+ text;
end;
//********************************************************************************/
function  TDataSelect.IsTabColFull(col :integer ):boolean;
var
 nbRow,row : integer;
 text :string;
 begin
  result:=true;
  nbRow:=TabData.RowCount;
 for row:=0 to nbRow-1 do
  begin
    text:=TabData.StrItems[row,col];
    if text='' then
       begin result:=false;
             break;
       end;
  end;
end;
//********************************************************************************/
function  TDataSelect.IsTabRowFull( row :integer):boolean;
var
 nbCol,Col : integer;
 text :string;
 begin
  result:=true;
  nbCol:=TabData.ColCount[row];
 for Col:=0 to nbCol-1 do
  begin
    text:=TabData.StrItems[row,col];
    if text='' then
       begin result:=false;
             break;
       end;
  end;
end;
//********************************************************************************/
function  TDataSelect.GetNameOfDirectCol(col :integer ):string;  //GetNameOfCol(integer col)
begin
 result:=TabData.StrItems[0,col];
end;
//***********************************************************************************/
function  TDataSelectCLMol.GetNameOfDirectCol(col :integer): string;
begin
 result:=IntToStr(col);
end;
 //********************************************************************************/
function  TDataSelect.GetDirectNameOfRow(row : integer ):string;
var
 index: integer;
  begin
   index:=ListRow.Items[row];
   result:=TabData.StrItems[index,0];
  end;

function  TDataSelect.GetIndex(List :TListInteger;name :string):integer;
var
 ind, index :integer;
 str :string;
begin
 result:=-1;
 for  ind:=0 to List.Count-1 do
  begin
    index:=List.Items[ind];
    str:=TabData.StrItems[index,0];
    if str=name then
     begin
      result:=ind;
      break;
     end;
  end;
end;
//********************************************************************************/
function  TDataSelect.GetNameOfRow(ListR :TListInteger;row :integer):string;
var
 index: integer;
  begin
   index:=ListR.Items[row];
   result:=TabData.StrItems[index,0];
 end;
//******************************************************************************/
function  TDataSelect.GetDirectData( row,col :integer):string;
var
indexR,indexC: integer;
  begin
   indexR:=ListRow.Items[row];
   indexC:=ListCol.Items[col];

   result:=TabData.StrItems[indexR,indexC];
 end;
//
//******************************************************************************/
function  TDataSelect.GetData(ListR : TListInteger; ListC : TListInteger ; row,col :integer):string;
var
indexR,indexC: integer;
  begin
   indexR:=ListR.Items[row];
   indexC:=ListC.Items[col];

   result:=TabData.StrItems[indexR,indexC];
 end;
// fonction qui supprime les colonnes si "cond" s'y trouve
//*******************************************************************************/
function  TDataSelect.RemoveColCond(listr:TListInteger; listc:TListInteger;cond :string): TListInteger;
var
  data : string;
  NbMax1,NbMax2,index1,index2 :integer  ;
  datapresent : boolean;
  NewList :TListInteger;

begin

  NbMax1:=listc.Count;
  NbMax2:=listr.Count;

  NewList:=TListInteger.CreateInit(NbMax1);

 for index1:=0 to NbMax1-1 do
  begin
  datapresent:=false;
   for index2:=0 to NbMax2-1 do
    begin
      data:=GetData(listr,listc,index2,index1);
      if (data=cond) then begin datapresent:=true; break;end;
    end;
   if (not datapresent)then NewList.Add(listc.Items[index1]);
  end;
  result:= NewList;
end;
//******************************************************************************/
function  TDataSelect.RemoveRowCond(listr:TListInteger; listc:TListInteger;cond :string):TListInteger;
 var
  data : string;
  NbMax1,NbMax2,index1,index2 :integer  ;
  datapresent : boolean;
  NewList :TListInteger;

  begin

 NbMax1:=listc.Count;
 NbMax2:=listr.Count;

 NewList:=TListInteger.createInit(NbMax1);

 for index2:=0 to NbMax2-1 do
  begin
   datapresent:=false;
   for  index1:=0 to NbMax1-1 do
     begin
       data:=GetData(listr,listc,index2,index1);
      if (data=cond) then begin datapresent:=true; break;end;
     end;
   if ( not datapresent) then NewList.Add(listr.Items[index2]);
  end;

 result:=NewList;
end;
 //*******************************************************************************/
function  TDataSelectCL.ErrorCod: TPoint;
var
 Data,Etat,subetat : string;
 col, row, NbCol, NbRow,indexcar,indexcol :integer;
 point:TPoint;
 begin

 NbCol:=ListCol.Count;
 NbRow:=ListRow.Count;

 for col:=0 to NbCol-1 do
   begin
    data:=GetNameOfCol(ListCol,col);
    if (data='')or (Trim(data)='') then  begin point.x:=col; result:=point; exit; end;

    indexcar:=GetIndexRow(data,TabCod,0,0);

    if (indexcar<0)  then begin point.x:=col;result:=point; exit; end;

    for row:=0 to NbRow-1 do
     begin
      etat:= GetDirectData(row,col);
      if (etat<>'')then
        begin
         subetat:=RemoveFirst(etat,'/');

         while(subetat<>'')do
          begin
            indexcol:=GetIndexCol(subetat,TabCod,indexcar,0);
             if (indexcol<0) then begin point.x:=col; point.y:=row; result:=point;exit;end;
            subetat:=RemoveFirst(etat,'/');
          end;

         subetat:=etat;
         indexcol:=GetIndexCol(subetat,TabCod,indexcar,0);
         if (indexcol<0) then begin point.x:=col; point.y:=row; result:=point;exit;end;
       end;
     end;
    end;

result:=point;
end;

// c'est une fonction qui enlve de la liste, les lignes sans
// en tte et les lignes entirement vides de donnes.
//******************************************************************************/
function  TDataSelect.RemoveEmptyRow(listr:TListInteger; listc:TListInteger):TListinteger;
var
 NbMaxRow, NbMaxCol, row, col:integer;
 datapresent: bool;
 data : string;
 NewList : TListInteger;
begin

 NbMaxRow:=listr.Count;
 NbMaxCol:=listc.Count;

 NewList:=TListInteger.createInit(NbMaxRow);
   for row:=0 to NbMaxRow-1 do
   begin
      data:=GetNameOfRow(listr,row);
      datapresent:=false;
      if (data<>'')and (Trim(data)<>'') then
       begin
        datapresent:=false;
        for col:=0 to NbMaxCol-1 do
          begin
            data:=GetData(listr,listc,row,col);
            if (data<>'')and (Trim(data)<>'') then begin datapresent:=true; break; end;
          end;
       end;
       if (datapresent) then NewList.Add(listr.items[row]);
  end;
 result:=NewList;
end;
//*******************************************************************************/
procedure  TDataSelectDist.AdjustListBase(List :TListInteger; dep :integer);
var
nbcount :integer;
 begin
 nbcount:=List.Count;
  while (dep<nbcount) do
  begin
   List.Delete(dep);
   nbcount:=nbcount-1;
   dep:=dep+2;
   end;
end;
  //*******************************************************************************/
function  TDataSelectDist.RemoveEmptyCol(listr :TListInteger; listc :TListInteger):TListinteger;
var
 NbMaxCol,col,row,NbRow,NbCol : integer;
 ListRest,ListRestbis : TListInteger;
 data :string;
 datapresent,dataabsent :boolean ;

 begin

 NbMaxCol:=ListMaxCol.Count;
 ListRest:=TListInteger.createinit(NbMaxCol);

 for col:=0 to NbMaxCol-1
   do  ListRest.Add(ListMaxCol.Items[col]);

 // Ces trois conditions ne concernent que les molcules d'ADN

 if (FBaseCount=noBase1) then AdjustListBase(ListRest,0);//La premire base de chaque codon n'est pas compte
 if (FBaseCount=noBase2) then AdjustListBase(ListRest,1); //La deuxime base de chaque codon n'est pas compte
 if (FBaseCount=noBase3) then AdjustListBase(ListRest,2); //La troisime base de chaque codon n'est pas compte

 NbRow:=ListR.Count;   // Travaille sur ListRow
 NbCol:=ListRest.Count;

 ListRestbis:=TListInteger.createinit(NbCol);

 for col:=0 to NbCol-1 do
  begin
    datapresent:=false;
    dataabsent:=false;

   for  row:=0 to NbRow-1 do
    begin
      data:=GetData(ListR,ListRest,row,col);
      if (data='')or (Trim(data)='') or (data='-') then dataabsent:=true else datapresent:=true;
    end;

  // si la colonne est vide alors elle n'est pas comptabilise dans la listcol
  // si une colonne contient des vides ou des "-" elle n'est comptabilise que si
  // "DelDist!=allremoved"

  if (datapresent) then
    begin
     if (dataabsent=false) then ListRestbis.Add(ListRest.Items[col]);
     if (dataabsent=true) and (FDeleteDistance<>allremoved)
        then ListRestbis.Add(ListRest.Items[col]);
    end;
  end;

  ListRest.free;
  result:=ListRestbis;
 end;
//******************************************************************************/
function  TDataSelect.RemoveEmptyCol(listr :TListInteger; listc :TListInteger):TListinteger;
var
 NbMaxCol,NbMaxRow, col,row : integer;
 NewList : TListInteger;
 data :string;
 datapresent:boolean ;

 begin
  NbMaxCol:=listc.Count;
  NbMaxRow:=listr.Count;

 NewList:=TListInteger.createinit(NbMaxCol);

 for col:=0 to NbMaxCol-1 do
 begin
   data:=GetNameOfCol(listc,col);
   datapresent:=false;
   if (data<>'')and (Trim(data)<>'')then
    begin
      datapresent:=true;
      for row:=0 to NbMaxRow-1 do
       begin
         data:=GetData(listr,listc,row,col);
         if (data='')or(Trim(data)='') or (data=' ') then
          begin datapresent:=false; break; end;
       end;
    end;
   if (datapresent=true) then NewList.Add(listc.Items[col]);
  end;
 result:=NewList;
end;
//******************************************************************************/
function  TDataSelectCLMol.GetListEtat(nomtax:string; nomcarac:string):string;
var
indexcar,indextax :integer;
substr,etat,listetat :string;
begin

  RSubstr(nomcarac,substr,':');
  indexcar:=StrToInt(substr);

  indextax:=GetIndexRow(nomtax,TabData,0,0);

  etat:=GetTabData(indextax,indexcar,TabData);
  listetat:=TransformToListCod(etat,nomcarac);

  if (listetat='?') then  listetat:=CopyMaxState(nomcarac);
 result:=listetat;
end;
//******************************************************************************/
procedure TDataSelectCL.TaxonRemove(nomtax :string);
var
 index :integer;
 begin
  index:=GetIndex(ListMaxRow,nomtax);
  if index>=0 then ListMaxRow.delete(index);

  index:=GetIndex(ListRow,nomtax);
  if index>=0 then ListRow.delete(index);
 end;

//******************************************************************************/
function  TDataSelectCL.GetListEtat(nomtax: string; nomcarac: string):string;
var
 indextax, indexcar : integer;
  etat, listetat,temp :string;
begin
   indextax:=GetIndexRow(nomtax,TabData,0,0);
   indexcar:=GetIndexCol(nomcarac,TabData,0,0);

   etat:=GetTabData(indextax,indexcar,TabData);
   listetat:=TransformToListCod(etat,nomcarac);

   //jfr modifie le 07/09/04   pour informer la fonction appelante que l'tat est inconnu (missing)
  if (listetat='?') then
  begin
  temp:= CopyMaxState(nomcarac);
  if (pos('?',temp)=0) then begin   // si le fichier de codage n'est pas trouv le ? est automatiquement ajout
      listetat:= '?/'+temp;         // donc inutile de le remettre !
      end;
  end;
result:=listetat;
end;
// *********** utilise dans le calcul automatique d'un TreeCL pour crer une DataNJ**
// ************pour viter le problme de slection de caractre

procedure TDataSelect.CopyListMax(listrow : TListInteger ; listcol :TListInteger);
var
i:integer;
 begin
     ListMaxRow:=TListInteger.create;
     ListMaxCol:=TListInteger.create;
   for i:=0 to listrow.count-1 do  ListMaxRow.add(listrow[i]);
   for i:=0 to listcol.count-1 do  ListMaxCol.add(listcol[i]);
 end;

//******************************************TListInteger************************************/
procedure TDataSelect.ChangeListMaxCol( listColsel:Tstrings);
 var
 i:integer;
 begin
  ListMaxCol.free;
  ListMaxCol:=TListInteger.create;

  for i:=0 to listcolsel.count-1 do
    if listcolsel[i]='Y' then ListMaxCol.add(i);

  if ListMaxCol.count=0 then  for i:=1 to (Tabdata.Colcount[0])-1 do ListMaxCol.add(i);
 end;

procedure TDataSelect.CreateListMax(listrowsel:TStrings; listColsel:Tstrings);
  var
 i:integer;
 begin
  ListMaxRow:=TListInteger.create;
  ListMaxCol:=TListInteger.create;

  for i:=0 to listrowsel.count-1 do
   if listrowsel[i]='Y'
      then ListMaxRow.add(i);

  if ListMaxRow.count=0 then  for i:=1 to TabData.rowcount-1 do ListMaxRow.add(i);

  for i:=0 to listcolsel.count-1 do
    if listcolsel[i]='Y' then ListMaxCol.add(i);

  if ListMaxCol.count=0 then  for i:=1 to (Tabdata.Colcount[0])-1 do ListMaxCol.add(i);
 end;

//******************************************************************************/
function  TDataSelect.CreateList:boolean;
begin
  result:=true;
  if (not InitListRow) then result:= false;
  if (not InitListCol) then result:= false;
end;
//*******************************************************************************/
function  TDataSelectCL.CreerListCarac:boolean;
var
 data1,data2:string;
 NbMax1, NbMax2, index1,index2: integer ;
 trouve :boolean;

begin
  if (ListCarac<>nil) then  ListCarac.free;

  NbMax1:=ListCol.Count;
  NbMax2:=ListRow.Count;

 trouve:=false;

 ListCarac:=TListInteger.createinit(NbMax1);

 for index1:=0 to NbMax1-1 do
 begin
   data1:=GetDirectData(0,index1);
   for index2:=1 to NbMax2-1 do
     begin
      data2:=GetDirectData(index2,index1);
       if (data1<>data2) then           // Si il y a une diffrence, on comptabilise
         begin
           ListCarac.Add(index1);
           trouve:=true;
           break;
          end;
      end;
  end;
  if ( not trouve) then begin ListCarac.free ; ListCarac:=nil;end;
  result:=trouve;
end;
//*******************************************************************************/
procedure  TDataSelectCL.ChangeTabCod(tab : TStrListArray);
 begin
   TabCod:=tab;
 end;
//*******************************************************************************/
function  TDataSelectCLMol.CreerListCarac: boolean;
var
 data1,data2:string;
 NbMax1, NbMax2, index1,index2: integer ;
 trouve :boolean;
 begin
 if (ListCarac<>nil) then ListCarac.free;

 NbMax1:=ListCol.Count;
 NbMax2:=ListRow.Count;

 trouve:=false;

 ListCarac:=TListInteger.createinit(NbMax1);

 for index1:=0 to NbMax1-1 do
   begin
    data1:=GetDirectData(0,index1);
       for index2:=1 to NbMax2-1 do
         begin
           data2:=GetDirectData(index2,index1);
          if (data1<>data2) then // Si il y a une diffrence, on comptabilise
            begin
              ListCarac.Add(index1);
              trouve:=true;
              break;
            end;
        end;
    end;
  if ( not trouve) then begin ListCarac.free ; ListCarac:=nil;end;
  result:=trouve;
 end;
//******************************************************************************/
function  TDataSelectCL.CreerListTaxon:boolean;
var
  taxon : string;
  trouve : boolean;
  NbMax,index :integer;

 begin
  trouve:=false;

  NbMax:=ListRow.Count;
  ListTaxon:=TStringList.create;

   for index:=0 to NbMax-1 do
   begin
     taxon:=GetDirectNameOfRow(index);
     if (taxon<>'') then
         begin
              ListTaxon.Add(taxon);
              trouve:=true;
          end;
     end;
   if (not trouve) then begin ListTaxon.free; ListTaxon:=nil;end;
   result:= trouve;
 end;
//******************************************************************************/
function  TDataSelect.InitListCol: boolean;
var
  trouve : boolean;
  begin
    trouve:=true;
  // c'est une fonction qui enlve de la liste initiale ("ListMaxCol")
  // les colonnes qui sont sans en tte ou les colonnes dans lesquelles
  // il y a des trous

  ListCol:=RemoveEmptyCol(ListRow,ListMaxCol);
  if (ListCol.Count=0) then
   begin
     trouve:=false;
     ListCol.free;
     ListMaxCol.free;
    ListCol:=nil ;ListMaxCol:=nil;
  end;
  result:= trouve;
end;
//******************************************************************************/
function  TDataSelect.InitListRow: boolean;
var
  trouve : boolean;
  begin
    trouve:=true;
  // c'est une fonction qui enlve de la liste, les lignes sans
  // en tte et les lignes entirement vides de donnes. Les trous dans
  // les donnes sont enlevs au moment ou est construit "ListCol"

  ListRow:=RemoveEmptyRow(ListMaxRow,ListMaxCol);
  if (ListRow.Count=0) then
  begin
    trouve:=false;
    ListRow.free;
    ListMaxRow.free;
    ListRow:=nil ;ListMaxRow:=nil;
  end;
  result:= trouve;
end;
//******************************************************************************/
//* Fonction qui retourne la ligne >= dep du tableau "tab" dont la cellule situe  la
// colonne "col" contient la chaine "str"

function  TDataSelectCL.GetIndexRow(str1:string; tab:TStrListArray; col,dep:integer):integer;
var
  retour,row :integer;
  str2 :string;

 begin
  retour:=-1;

  for row:=dep to tab.RowCount-1 do
   begin
     str2:=tab.StrItems[row,col];
     if (str2=str1) then
         begin
           retour:=row;
           break;
         end;
    end;
 result:=retour;
end;
//******************************************************************************/
// Fonction qui retourne la colonne >= dep du tableau "tab" dont la cellule situe  la
// ligne "row" contient la chaine "str"

function  TDataSelectCL.GetIndexCol(str:string ;tab :TStrListArray; row,dep:integer):integer;
 var
  retour,col,max :integer;
  str2 :string;

 begin
  max:=tab.ColCount[row];
  retour:=-1;
  for col:=dep to max-1 do
   begin
      str2:=tab.StrItems[row,col];
      if (str2=str)  then
       begin
         retour:=col;
         break;
       end;
  end;
 result:=retour;
end;
//*******************************************************************************/
function  TDataSelectCL.GetTabData(row,col:integer; tab:TStrListArray):string;  // GetData
begin
  result:=tab.StrItems[row,col];
end;
//*******************************************************************************/
function  TDataSelectCLMol.CopyMaxState(str :string ):string;
 var
  Icode,Index :integer ;
  strcode : string;

 begin

  for index:=45 to 121 do
  begin
    Icode:=TabCodage[index];
    if (Icode>=0) then
    begin
     strcode:=strcode+IntToStr(index);
     strcode:=strcode+'/';
    end;
  end;
  Icode:=TabCodage[122];
  if (Icode>=0) then strcode:=strcode+IntToStr(122);
 result:=strcode;
end;

//*******************************************************************************/
function  TDataSelectCL.CopyMaxState(nomcarac : string ):string;
 var
    strcode,code: string ;
    indexrow,nbetat,compt,index : integer ;

  begin

  compt:=3;
  indexrow:=GetIndexRow(nomcarac,TabCod,0,0);

  if(indexrow<0) then begin result:=''; exit end;

  nbetat:=TabCod.ColCount[indexrow];
  nbetat:=(nbetat-2) div 2;

  for index:=0 to nbetat-1 do
   begin
     code:=GetTabData(indexrow,compt,TabCod);

     if (trim(code)<>'') then              // jfr modifie le 29/04/02 : ligne rajoute
      begin                                 // jfr modifie le 29/04/02 : ligne rajoute
      strcode:=strcode+code;
      strcode:=strcode+'/';
      end;                                   // jfr modifie le 29/04/02  : ligne rajoute
     compt:=compt+2;
   end;
  SetLength(Strcode,Length(Strcode) - 1 );
  result:=strcode;
end;
//*******************************************************************************/

function  TDataSelectCLMol.TransformToListCod(listetat :string; nul :string):string;
var
  strcode,subetat, stretat,code:string;
  retour,ICode: integer;
 begin

 if (listetat='?') then begin result:=listetat; exit; end;

 stretat:=listetat;

 // On dcompose stretat en une suite ventuelle d'tat ("subetat") spar
 // par des "/". On recherche alors le code de cet tat dans TabCodage

 subetat:=RemoveFirst(stretat,'/');
 retour:=1;
 while(subetat<>'')do
  begin
   Icode:=TabCodage[ord(subetat[1])];
   if (Icode>=0) then
    begin
     code   :=intTostr(Icode);
     strcode:=strcode+code;
     strcode:=strcode+'/';
     subetat:=RemoveFirst(stretat,'/');
    end
    else
    begin retour:=0; break ;end;
   end;

   // Ncessaire pour le dernier tat situ aprs le dernier "/", ou pour
   // l'unique tat si le caractre est monomorphique
 if (retour<>0) then
  begin
    Icode:=TabCodage[ord(stretat[1])];
    if (Icode>=0) then begin  code:=intTostr(Icode);strcode:=strcode+code;end
    else retour:=0;
   end;
if (retour<>0) then result:=strcode
else result:='';
// Si un tat n'est pas trouv alors cette fonction retourne NULL
end;
//*******************************************************************************/
function  TDataSelectCL.TransformToListCod(listetat:string; nomcarac:string):string;
var
 code, stretat,strcode, subetat :string;
 indexrow,indexcol,retour:integer;
begin
 // indexrow indice de la ligne du caractre ("nomcarac") dans TabCod
 // indexcol indice de la colonne correspondant  un tat du caractre

 if (listetat='?') then begin result:=listetat;exit;end;

 // le nom des caractre est situ dans la premire colonne donc
 // la recherche se fait dans la colonne absolue "0"

 // Si le nom du caractre n'est pas trouv dans TabCod la fonction retourne NULL
 indexrow:=GetIndexRow(nomcarac,TabCod,0,0);
 if(indexrow<0) then begin result:=''; exit;end;

 retour:=1;
 stretat:=listetat;
 // On dcompose stretat en une suite ventuelle d'tat ("subetat") spar
 // par des "/". On recherche alors la colonne de cet tat dans TabCode
 // puis son code  la colonne suivante.
 subetat:=RemoveFirst(stretat,'/');
  while(subetat<>'')do
  begin
    indexcol:=GetIndexCol(subetat,TabCod,indexrow,0);
    if (indexcol>=0) then
      begin
       code:=GetTabData(indexrow, indexcol+1,TabCod);
       if (code<>'') then
        begin
         strcode:=strcode+code;
         strcode:=strcode+'/';
         subetat:=RemoveFirst(stretat,'/');
        end
       else begin retour:=0; break ;end;
     end
   else begin retour:=0; break ;end;
 end;
   // Ncessaire pour le dernier tat situ aprs le dernier "/", ou pour
   // l'unique tat si le caractre est monomorphique
 if (retour<>0) then
  begin
    indexcol:=GetIndexCol(stretat,TabCod,indexrow,0);
    if (indexcol>=0) then
       begin
        code:=GetTabData(indexrow, indexcol+1,TabCod);
        if (code<>'') then strcode:=strcode+code
                      else retour:=0;
       end
    else retour:=0;
  end;
if (retour<>0) then result:=strcode
else result:='';
// Si un tat n'est pas trouv alors cette fonction retourne NULL
end;
//********************************************************************************/
function  TDataSelectCL.GetTypeOfCarac(nomcarac: string):integer;
 var
 indexcar,typeI: integer ;
 typeC:string ;

  begin
  typeI:=-1;
  indexcar:=GetIndexRow(nomcarac,TabCod,0,0);
  if (indexcar>=0) then
    begin
     typeC:=GetTabData(indexcar,1,TabCod);
     if (typeC<>'') then  typeI:=StrToInt(typeC);
    end;
 result:=typeI;
end;
//********************************************************************************/
// par dfinition un caractre molculaire est non ordonn
function  TDataSelectCLMol.GetTypeOfCarac(nomcarac:string):integer;
begin
 if nomcarac='' then result:=-1    // jfr modifie le 07/07/00 
 else  result:=0;
end;
//********************************************************************************/
function  TDataSelectCL.TransformToListStr(listcod: TListInteger; nomcarac: string):string;
var
code ,etat, listetat: string ;
indexrow, indexcol, retour, index: integer;
begin
 retour:=1;
 result:='';

  // indexrow : indice de la ligne du caractre ("nomcarac") dans TabCod
  // indexcol : indice de la colonne correspondant  un tat du caractre

 indexrow:=GetIndexRow(nomcarac,TabCod,0,0) ;

 if(indexrow<0) then exit;

 for index:=0 to listcod.count-1 do
 begin
  code :=intTostr (listcod.items[index]) ;
  indexcol:=GetIndexCol(code,TabCod,indexrow,2);
      if (indexcol>=0) then
         begin
          etat:=GetTabData(indexrow, indexcol-1,TabCod) ;
          if (etat<>'') then
            begin listetat:=listetat+etat;listetat:=listetat+ '/';end
          else begin retour:=0; break;end;
         end
      else begin retour:=0;break;end;
  end;

 if (retour<>0)then
 begin
   SetLength(listetat ,Length(listetat) - 1 );
   result:=listetat;
 end
 else result:='';
end;
//********************************************************************************/
function  TDataSelectCLMol.TransformToListStr ( listcod:TListInteger; nomcarac: string):string;
var
 listetat: string ;
  retour,index,k : integer ;
begin
 retour:=0;
 for index:=0 to listcod.count-1 do  // Attention nbcod dans l'original
 begin
    retour:=0;
      for k:=45 to 122 do
        begin
         if listcod.Items[index]=TabCodage[k] then
            begin
              listetat:=chr(k);
              listetat:=listetat+'/';
              retour:=1;
              break;
            end;
        end;
    if(retour=0) then break;
   end;

 if (retour<>0) then
 begin
   SetLength(listetat ,Length(listetat) - 1 );
   result:=listetat;
 end
 else result:='';
end;
//********************************************************************************/
procedure  TDataSelectCLMol.ChangeTabCod(Tab: TStrListArray);
 begin
  TabCod:=Tab;
  TabCodageCreate;
 end;
//********************************************************************************/
procedure  TDataSelectCLMol.TabCodageCreate;
 var
  etat:string;
  nbetat,compt,index :integer ;
  begin

  nbetat:=TabCod.ColCount[0];
  nbetat:=(nbetat-2) div 2;
  compt:=2;

  for index:=0 to nbetat-1 do
  begin
     etat:=GetTabData(0,compt,TabCod);
    TabCodage[ord(etat[1])]:=StrToInt(GetTabData(0,compt+1,TabCod));
    compt:=compt+2;
  end;
end;
//********************************************************************************/
function  TDataSelectCLMolPro.ErrorCod: TPoint;
 var
 prot:string;
 begin
  prot:='ACDEFGHIKLMNPQRSTVWYacdefghiklmnpqrstvwy-';
  result:= ErrorCodMol(prot);
 end;
//********************************************************************************/
function  TDataSelectCLMolNuc.ErrorCod: TPoint;
var
 nuc:string;
 begin
  nuc:='ACGTacgt-';
  result:= ErrorCodMol(nuc);
end;
//********************************************************************************/
function  TDataSelectCLMol.ErrorCodMol(mol:string):TPoint;
var
  Apoint :  TPoint;
  car : char ;
  lon,index,NbCol,NbRow,col, row ,posi:integer;
  Etat,subetat :string;

begin
  lon:=length(mol);
  for index:=1 to lon do
   begin
      car:=mol[index];
    if (TabCodage[ord(car)]<0)then
      begin Apoint.y:=ord(car);
      result:=Apoint;
      exit;
      end;
   end;

 NbCol:=ListCol.Count;
 NbRow:=ListRow.Count;

 for col:=0 to NbCol-1 do
  begin
    for row:=0 to NbRow-1 do
    begin
     etat:=GetTabData(row,col,TabData);
      if (etat<>'') then
       begin
         subetat:=RemoveFirst(etat,'/');
         while(subetat<>'')do
          begin
            posi:=Pos(subetat,mol);
            if (posi=0)then
             begin
               Apoint.x:=row;
               Apoint.y:=col;
               result:=Apoint;
               exit;
             end;
            subetat:=RemoveFirst(etat,'/');
          end;
    // Ncessaire pour le dernier tat situ aprs le dernier "/", ou pour
   // l'unique tat si le caractre est monomorphique
         posi:=Pos(etat,mol);
         if (posi=0)then
          begin
               Apoint.x:=row;
               Apoint.y:=col;
               result:=Apoint;
               exit;
          end;
      end;
   end;
  end;
  result:=point(0,0);
 end;

//*********************************************************************************/
procedure   TDataSelectCLMolNuc.TabCodageCreate;
 var
 i:integer;
 begin
 if (TabCod<>nil) then  inherited TabCodageCreate
  else
   begin
   for i:=0 to 122 do TabCodage[i]:=-1;
    TabCodage[65]:=0; TabCodage[97]:=0;   // A et a
    TabCodage[84]:=1; TabCodage[116]:=1;  // T et t
    TabCodage[67]:=2; TabCodage[99]:=2;   // C et c
    TabCodage[71]:=3; TabCodage[103]:=3;  // G et g
    TabCodage[85]:=4;  TabCodage[117]:=4; // U et u
    TabCodage[45]:=5;                     // -
   end;
 end;
//********************************************************************************/
procedure  TDataSelectCLMolPro.TabCodageCreate;
var
 i: integer;
begin
 if (TabCod<>nil) then  inherited TabCodageCreate
  else
   begin
   for i:=0 to 122 do TabCodage[i]:=-1;
    TabCodage[65]:=0; TabCodage[97]:=0;
    TabCodage[84]:=16; TabCodage[116]:=16;
    TabCodage[67]:=1; TabCodage[99]:=1;
    TabCodage[71]:=5; TabCodage[103]:=5;

    TabCodage[68]:=2; TabCodage[100]:=2;   // D et d
    TabCodage[69]:=3; TabCodage[101]:=3;
    TabCodage[70]:=4; TabCodage[102]:=4;
    TabCodage[72]:=6; TabCodage[104]:=6;
    TabCodage[73]:=7; TabCodage[105]:=7;
    TabCodage[75]:=8; TabCodage[107]:=8;
    TabCodage[76]:=9; TabCodage[108]:=9;
    TabCodage[77]:=10; TabCodage[109]:=10;
    TabCodage[78]:=11; TabCodage[110]:=11;
    TabCodage[80]:=12; TabCodage[112]:=12;
    TabCodage[81]:=13; TabCodage[113]:=13;
    TabCodage[82]:=14; TabCodage[114]:=14;
    TabCodage[83]:=15; TabCodage[115]:=15;
    TabCodage[84]:=16; TabCodage[116]:=16;
    TabCodage[86]:=17; TabCodage[118]:=17;
    TabCodage[87]:=18; TabCodage[119]:=18;
    TabCodage[89]:=19; TabCodage[121]:=19;

    TabCodage[45]:=20;
   end;
 end;
 //******************************************************************************/
procedure TDataSelect.AddNode_DND(var chaine : string ; name :string);
 begin
  chaine:='('+ chaine;

  chaine:=chaine+',';
  chaine:=chaine+name;
  chaine:=chaine+':';
  chaine:=chaine+'0.0';
  chaine:=chaine+')';
  chaine:=chaine+':';
  chaine:=chaine+'0.0';
 end;
//*******************************************************************************/
function  TDataSelectCL.Create_DND :string;
 var
  NbRow , index : integer;
  name, stringDND : string ;

 begin
  NbRow:=ListRow.Count;

   stringDND:=GetNameOfRow(ListRow,0);
   stringDND:=stringDND+':';
   stringDND:=stringDND+'0.0';


    for index:=1 to NbRow-1 do
      begin
      name:=GetNameOfRow(ListRow,index);
      AddNode_DND(stringDND,name);
     end;

    SetLength(stringDND, Length(stringDND) - 1);
    stringDND:=stringDND+';' ;

  result:= stringDND;
end;

function  TDataSelectCL.Create_DND_Polytom :string;
 var
  NbRow , index : integer;
  name, stringDND : string ;

 begin
  NbRow:=ListRow.Count;

   stringDND:='(';
   stringDND:=stringDND+GetNameOfRow(ListRow,0);
   stringDND:=stringDND+':';
   stringDND:=stringDND+'0.0';


    for index:=1 to NbRow-1 do
      begin
      name:=GetNameOfRow(ListRow,index);
      stringDND:=stringDND+',';
      stringDND:=stringDND+name ;
      stringDND:=stringDND+':';
      stringDND:=stringDND+'0.0';
     end;

    stringDND:=stringDND+')' ;
    stringDND:=stringDND+':' ;
    stringDND:=stringDND+'1.0' ;
    stringDND:=stringDND+';' ;

  result:= stringDND;
end;

function TDataSelectDist.CreateFirstMatrix(mat :TDistMatrix):TDistMatrix;
begin
end;

function  TDataSelectDist.CreateNextMatrix(mat: TDistMatrix; row,col:integer):TDistMatrix;
begin
end;

function TDataSelectDistUPGMA.CreateFirstMatrix(mat :TDistMatrix):TDistMatrix;
begin
  result:= TUPGMAMatrix.CreateFirstMatrix(mat);
end;


function  TDataSelectDistUPGMA.CreateNextMatrix(mat: TDistMatrix; row,col:integer):TDistMatrix;
begin
   result:= TUPGMAMatrix.CreateNextMatrix(mat,row,col);
end;

function  TDataSelectDistNJ.CreateFirstMatrix(mat:TDistMatrix):TDistMatrix;
begin
  result:= TNJMatrix.CreateFirstMatrix(mat);
end;

function  TDataSelectDistNJ.CreateNextMatrix(mat: TDistMatrix; row,col:integer):TDistMatrix;
begin
   result:= TNJMatrix.CreateNextMatrix(mat,row,col);
end;

//*****************************************************************************/
procedure TDataSelectDist.Root_DND(List :TStringlist; dist :string);
 var
  index :integer;
 begin
  index:=List.Count-1;
  list.delete(index);
  List.Add(':');
  List.Add(dist);
  List.Add(';');
 end;
//*******************************************************************************/
procedure TDataSelectDist.InsertAndRemoveString_DND(List:TStringList;index,first,last :integer);
var
 newList :TStringList;
 chaine : string ;
 ind,j :integer;
 begin
  newList:=TStringlist.create;

  for  ind:=0 to List.Count-1 do
  begin
    if (ind < first)or (ind > last+1) and (ind < index) then
     begin
      chaine:=List[ind];
      newList.Add(chaine);
     end;
    if (ind < first)or (ind > last+1) and (ind = index) then
     begin
      for j:=first to last do
        begin
         chaine:=List[j];
         newList.Add(chaine);
       end;
     end;
    if (ind < first)or (ind > last+1) and (ind > index) then
     begin
     chaine:=List[ind];
     newList.Add(chaine);
     end;
  end;
 List.clear;
 for ind:=0 to newList.count-1 do
  begin
   chaine:=newList[ind];
   List.Add(chaine);
  end;
  newList.free;
 end;
//******************************************************************************/
function TDataSelectDist.FindOtherItem_DND(List: TStringList; chaine1 :string ; pos :integer):integer;
 var
 posF  : integer;
 index : integer;
 chaine :string;
 begin
   posF:=-1;
  for index:=0 to List.count-1 do
   begin
    if(index<>pos)then
     begin
      chaine:=List[index];
       if (chaine1=chaine)then
        begin
         posF:=index;
         break;
        end;
     end;
  end;
  result:=posF;
end;
//******************************************************************************/
// position de la parenthse droite
function TDataSelectDist.FindPthL_DND(list :TstringList; posD : integer):integer ;
var
 compt,posG, index :integer;
 chaine : string;

 begin
  compt:=0;
  posG:=-1;

   for index:=posD-1 downto 0 do
     begin
     chaine:=list[index];
     if (Pos( ')',chaine) >0 ) then  begin compt:=compt+1;continue;end;
     if (Pos( '(',chaine) >0 ) then
      begin
       if (compt=0) then begin posG:=index; break; end  // position de "("
        else compt:=compt-1;
      end
    end;
  result:=posG;
end;

//******************************************************************************/
procedure TDataSelectDist.Adjust_DND(List :TStringlist);
var
posG,posD,posR :integer;
chaine1,chaine2 : string;
index :integer;
begin
 index:=0;
 while (index < List.Count-1) do
   begin
    chaine1:=List[index];
    if (Pos('/', chaine1) > 0) and (index>0) then
     begin
      chaine2:=List[index-1];
       if (Pos( ')', chaine2)>0) then
        begin
          posD:=index-1;   // position de ")
          // On recherche la position de la premire "("
          posG:=FindPthL_DND(list,posD);
            if (posG>=0) then
             begin
               posR:=FindOtherItem_DND(list,chaine1,posD+1);
               InsertAndRemoveString_DND(list,posR,posG,posD);
             end;
         index:=0;  // On repart pour un tour
        end
       else index:=index+1;
     end
    else index:=index+1;
   end;
 end;

//******************************************************************************/
// Pour debugger
function TDataSelectDist.CreateString_DND(list: TStringList):string;
 var
 chaine :string;
 index :integer;
 begin
  for index:=0 to list.Count-1 do chaine:=chaine+list[index];
  result:=chaine;
 end;
//******************************************************************************/
procedure TDataSelectDist.Add_DND(list: TStringList; mat:TDistMatrix; row,col :integer);
var
  node1, node2,dist1,dist2,total :string;
begin
  node1:=mat.GetName(0,row);
  node2:=mat.GetName(0,col);
  total:=node1 + '/' + node2;

  dist1:= FloatToStr(mat.AverageDistance(row,col,1));
  dist2:= FloatToStr(mat.AverageDistance(row,col,2));

  list.Add('(');
  list.Add(node1);
  list.Add(':');
  list.Add(dist1);
  list.Add(',');
  list.Add(node2);
  list.Add(':');
  list.Add(dist2);
  list.Add(')');
  list.Add(total);
 end;
//*****************************************************************************/
function TDataSelectDist.Calculate_DND: string;
var
 Matrix,NewMatrix,FirstMatrix :TdistMatrix;
 ListStr : TStringlist;
 row, col: integer;
 stringArbreDND :string;

begin
  ListStr:=TStringList.Create;

  FListMatrix:=TList.Create;
  FDistMatrix:=TDistMatrix.createMatrix(self) ;// Premire matrice : obligatoire


  FirstMatrix :=CreateFirstMatrix(FDistMatrix); // Variable suivant UPGMA ou NJ
  FListMatrix.Add(FirstMatrix);
  Matrix:=FirstMatrix;

  while (Matrix.TabMatrix.RowCount>2)do
    begin
    Matrix.FindDistMin(row,col);
    Add_DND(ListStr,Matrix,row,col);

    NewMatrix:=CreateNextMatrix(Matrix,row,col); //variable suivant UPGMA ou NJ
    NewMatrix.InitMatrice;
    NewMatrix.InitDistance;
    FListMatrix.add(NewMatrix);
    Matrix:=NewMatrix;
   end;

  Adjust_DND(ListStr);

  Root_DND(ListStr,'0.0');
  stringarbreDND:=CreateString_DND(ListStr);
  ListStr.free;

  result:=stringarbreDND;
end;

//******************************************************************************/
procedure TDistMatrix.PutName(name :string; i,j:integer);    // ancien putnom
begin  
  TabMatrix.StrItems[i,j]:=name;
end;

//*****************************************************************************/

//*****************************************************************************/
constructor TDistMatrix.createMatrix(AData :TDataSelectDist);
begin
  Data:=AData;

  TabMatrix:=TStrListArray.createListArray;
  InitMatrice;
  InitDistance;
end;
// la fonction InitMatrice inscrit les noms des taxons aux endroits voulus en faisant appelle
//  GetDonnee qui prend les donnes(i=ligne, j=col) dans le tableau de donnes initial (TabDonnee)
// et renvoit le (char *) nom contenu dans la cellule ou 0. PutNom cre les cellules
// de TabMatrice si elles n'existent pas et place (char *)nom dans ces cellules


//******************************************************************************/
procedure TDistMatrix.InitMatrice;
var
compt,NbRow,row :integer;
name :string;

begin
  compt:=1;
  NbRow:=Data.ListRow.Count;
      for row:=0 to NbRow-1 do
	  begin
            name:=Data.GetNameOfRow(Data.ListRow,row);
	    PutName(name,compt,0);
            PutName(name,0,compt);
            compt:=compt+1;
	  end;
end;
// La fonction InitDistance commence par remplir dans TabMatrice les cases correspondant 
// la diagonale 0. Puis,pour chaque paire de taxon, est appelle la fonction PaireWiseDist
 //******************************************************************************/

procedure TDistMatrix.InitDistance ;
var
row1,row2,comptl,comptc1,comptc2,NbRow:integer;

begin
 comptl:=1;
 comptc1:=0;

 NbRow:=Data.ListRow.Count;

    for row1:=0  to NbRow-2 do
     begin
      comptc1:=comptc1+1;
      comptc2:=comptc1;
      PutDistance(0.0,comptl,comptc2);
      comptc2:=comptc2+1;
        for  row2:=row1+1 to NbRow-1 do
          begin
          PutDistance((PaireWiseDist(row1,row2)),comptl,comptc2);
          comptc2:=comptc2+1;
          end;
      comptl:=comptl+1;
      end;
    PutDistance(0.0,NbRow,NbRow);

  end;
//**********************************************************************************/

function TDistMatrix.PaireWiseDist( row1,row2 : integer):double ;
var
dist,Dr:double;
total,NbCol,col :integer;

begin
 dist:=0.0;
 total:=0;
 NbCol:=Data.ListCol.Count;

  for col:=0 to NbCol-1 do
    dist:=dist+CalculerDistElem(row1,row2,col,total);

  if (total=0) then result:=0.0
  else
  begin
    dist:=dist/total;
    Dr:=dist;
    
    if (Data.CalcDistance=poisson) then  dist:=dist-(log10(1-dist));
    if (Data.CalcDistance=kimura) then dist:=dist-(log10(1-dist-(0.2*(dist*dist))));

    if (Data.FormatDistance=Tabsolute) then Dr:=dist*total;
    if (Data.FormatDistance=Tproportion) then Dr:=dist;
    if (Data.FormatDistance=Tpercentage)then Dr:=dist*100;

    result:=Dr;
  end;
end;

//******************************************************************************/

procedure TDistMatrix.PutDistance(dist :double; i,j :integer);
var
 name :string;
begin
  DecimalSeparator:='.';
  name:=FloatToStrF(dist,ffGeneral,3,2); // jfr modifie le 25/06/02 ,5,3);
  TabMatrix.StrItems[i,j]:=name;
end;

//******************************************************************************/
function TDistMatrix.CalculerDistElem(row1,row2,col:integer; var total:integer):double;
var
  donnee1,donnee2:string;
 begin
  result:=0.0;
  donnee1:=Data.GetData(Data.ListRow,Data.ListCol,row1,col);
  donnee2:=Data.GetData(Data.ListRow,Data.ListCol,row2,col);

  if (((donnee1='')or(donnee2=''))and((Data.DeleteDistance=removed)
                                       or(Data.DeleteDistance=allremoved)))
   then exit;

   if (donnee1='')and (donnee2<>'') then
       begin
        total:=total+1;
        if (Data.DeleteDistance<>removed)
         then result:=1.0 else result:=0.0;
         exit;
       end;
   if ((donnee1<>'')and(donnee2='')) then
       begin
        total:=total+1;
        if (Data.DeleteDistance<>removed)then result:=1.0 else result:=0.0;
        exit;
       end;
   if ((donnee1='')and(donnee2='')) then
       begin
        total:=total+1;
        result:=0.0;
        exit;
       end;

   if ((donnee1='-')and (donnee2<>'-'))then
       begin
        total:=total+1;
        if (Data.DeleteDistance<>removed)then result:=1.0 else result:=0.0;
        exit;
        end;
   if (donnee1<>'-')and(donnee2='-') then
       begin
       total:=total+1;
        if (Data.DeleteDistance<>removed) then result:=1.0 else result:=0.0;
        exit;
       end;
   if (donnee1='-')and(donnee2='-') then
       begin
       total:=total+1;
       result:=0.0;
       exit;
       end;
       
   total:=total+1;
	if (donnee1=donnee2)then result:= 0.0
	else result:=1.0;
 end;
//******************************************************************************/
function TDistMatrix.GetName(i,j :integer):string;
begin
  result:=TabMatrix.StrItems[i,j];
end;
//******************************************************************************/
procedure TDistMatrix. FindDistMin(var row: integer;  var col:integer);
var
 min :double;
 i,j :integer;
begin
  min:=GetDistance(1,2);

  row:=1;
  col:=2;

  for i:=1 to TabMatrix.Rowcount-1 do
    begin
     for j:=i+1 to TabMatrix.Rowcount-1 do
	 begin
          if (min>GetDistance(i,j)) then
		begin min:=GetDistance(i,j);
                 row:=i;
                 col:=j;
                end;
         end;
     end;
end;
//******************************************************************************/

function TDistMatrix.GetDistance(i,j : integer):double;
var
name :string;
begin
  DecimalSeparator:='.';
  name:=TabMatrix.StrItems[i,j];
  if name<>'' then
     result:=strToFloat(name)
  else result:=0.0;
end;
//*********************************************************************************/

function TDistMatrix.AverageDistance(row,col,no : integer):double;
begin
 result:=GetDistance(row,col)/2;
end;

//******************************************************************************/
                           //TUPGMAMatrix
//******************************************************************************/
constructor TUPGMAMatrix.CreateFirstMatrix(AMat:TDistMatrix);
   begin
     MatSrc:=AMat;
     ColSrc:=0;
     RowSrc:=0;
     Data:=AMat.Data;
     TabMatrix:=TstrListArray.CopyCreate(AMat.TabMatrix);

   end;
//*******************************************************************************/
constructor TUPGMAMatrix.CreateNextMatrix(AMat:TDistMatrix;row,col:integer);
   begin
     MatSrc:=Amat;
     ColSrc:=col;
     RowSrc:=row;
     Data:=Amat.Data;
     TabMatrix:=TStrListArray.createListArray;
    
   end;
//******************************************************************************/

procedure TUPGMAMatrix.InitMatrice ;
var
compt,index,NbRow :integer;
chaine1,chaine2 :string;
begin
 compt:=1;
 NbRow:=MatSrc.TabMatrix.RowCount;
  for index:=1 to NbRow-1 do
  begin
   if (index<>RowSrc)and(index<>ColSrc) then
	begin
          PutName(MatSrc.GetName(0,index),0,compt);
	  PutName(MatSrc.GetName(0,index),compt,0);
          compt:=compt+1;
	end;
  end;
  chaine1:=MatSrc.GetName(0,RowSrc);
  chaine2:=MatSrc.GetName(0,ColSrc);

  chaine1:=chaine1+'/';
  chaine1:=chaine1+chaine2;

  PutName(chaine1,0,compt);
  PutName(chaine1,compt,0);
 end;

//******************************************************************************/

function TUPGMAMatrix.NewDistance(noligne:integer ):double;
var
  ligne1,ligne2, col1 ,col2 :integer;
begin
  if (noligne>RowSrc) then
   begin
    ligne1:=RowSrc;
    col1:=noligne;
   end
  else
   begin
    ligne1:=noligne;
    col1:=RowSrc;
   end;
  if (noligne>ColSrc)then
   begin
    ligne2:=ColSrc;
    col2:=noligne;
   end
  else
    begin
     ligne2:=noligne;
      col2:=ColSrc;
    end;
  result:=((MatSrc.GetDistance(ligne1,col1))
           +(MatSrc.GetDistance(ligne2,col2)))/2;
end;
//******************************************************************************/
procedure TUPGMAMatrix.InitDistance;
 var
   comptl,comptc,index1,index2 :integer;
 begin
   for index1:=1 to TabMatrix.rowcount-1 do  PutDistance(0,index1,index1);
   comptl:=1;
   for index1:=1 to MatSrc.TabMatrix.rowcount-1 do
	begin
	  if (index1<>RowSrc)and(index1<>ColSrc) then
	  begin
           comptc:=comptl+1;
            for index2:=index1+1 to MatSrc.TabMatrix.rowcount-1 do
		begin
		  if (index2<>RowSrc) and (index2<>ColSrc) then
                     begin
                      PutDistance(MatSrc.GetDistance(index1,index2),comptl,comptc);
                      comptc:=comptc+1;
                      end;
                   // Conserve les anciennes distances quand les noeuds/taxons
		  // ne sont  pas concerns
		 end;
            PutDistance(NewDistance(index1),comptl,comptc);
	    comptl:=comptl+1;
end;  end;end;
//********************************************************************************/
                         //* TNJMatrix */
//********************************************************************************/
function TNJMatrix.TotalRow(norow:integer):double;
var
 sum :double;
 i,j :integer;
begin
  Sum:=0;
  for j:=norow+1 to NbRow-1 do
   Sum:=Sum+GetDistance(norow,j);
  for i:=1 to norow-1 do
   Sum:=Sum+GetDistance(i,norow);
  result:=Sum;
end;

//********************************************************************************/
procedure TNJMatrix.Find_R;
var
i:integer;
R, Rn: double;
begin
 for  i:=1 to NbRow-1 do
  begin
   R:=TotalRow(i);
   Rn:=R/(NbRow-1); // Nombre de donnes moins 2
   PutDistance(R,i,NbCol-2);
   PutDistance(Rn,i,NbCol-1);
  end;
end;
//*********************************************************************************/
procedure TNJMatrix.CalculDistPond;
var
i,j :integer;
NDist,R1,R2 :double;
begin
 for i:=2 to NbRow-1 do
   begin
      for j:=1 to i-1 do
	 begin
           NDist:=GetDistance(j,i);
           R1:=GetDistance(i,NbCol-1);
	   R2:=GetDistance(j,NbCol-1);
	   NDist:=NDist-R1;
	   NDist:=NDist-R2;
	   PutDistance(NDist,i,j);
end; end; end;
 //*********************************************************************************/
procedure TNJMatrix.FindDistMin(var row :integer; var col : integer);
 var
 min :double;
 i,j :integer;
 begin
   min:=GetDistance(2,1);
   row:=2;
   col:=1;

 for i:=1 to NbRow-1 do
  begin
   for j:=1 to i-1 do
	 begin
          if (min>GetDistance(i,j)) then
	    begin
             min:=GetDistance(i,j);
	     row:=i;
             col:=j;
end; end; end;	end;
//******************************************************************************/

function TNJMatrix.NewDistance(norow :integer):double;
var
dist :double;
begin
  dist:=inherited NewDistance(norow);
  dist:=dist-((MatSrc.GetDistance(ColSrc,RowSrc))/2);
 result:=dist;
end;
//******************************************************************************/
constructor TNJMatrix.CreateFirstMatrix(mat :TDistMatrix);
begin
  inherited CreateFirstMatrix(mat);
  NbCol:=TabMatrix.RowCount+2;
  NbRow:=TabMatrix.RowCount;

  PutName('R',0,NbCol-2);
  PutName('R/N-2)',0,NbCol-1);

  if (NbCol>4) then
  begin
    Find_R;
    CalculDistPond;
    end;
end;
//******************************************************************************/
// Construit une matrice qui contient une ligne de moins que la prcdente

constructor TNJMatrix.CreateNextMatrix(mat :TDistMatrix ;row,col :integer);
begin
  inherited CreateNextMatrix(mat,row,col);
  NbCol:=mat.TabMatrix.RowCount+1;
  NbRow:=mat.TabMatrix.RowCount-1;
end;

//*********************************************************************************/
procedure TNJMatrix.InitDistance;
 begin
   inherited InitDistance; // doit faire appel  nouvelle distance de TNJMatrix
  if (NbCol>4) then
   begin
    Find_R;
    CalculDistPond;
  end;
end;
//******************************************************************************/

procedure TNJMatrix.InitMatrice ;
begin
   inherited InitMatrice;
  PutName('R',0,NbCol-2);
  PutName('R/(N-2)',0,NbCol-1);
end;
//********************************************************************************/
function TNJMatrix.AverageDistance(row,col,no :integer):double;
var
Sr,dist :double;
begin
   dist:=GetDistance(col,row)/2;
  if (no=1) then
    Sr:=(GetDistance(row,NbCol-1)-GetDistance(col,NbCol-1))/2
  else
    Sr:=(GetDistance(col,NbCol-1)-GetDistance(row,NbCol-1))/2;

  dist:=dist+Sr;
  result:= dist;
end;
end.
