unit carac;


interface

uses
sysutils,Donnees ,strbox,classes,listarray ,ListInteger, listetat,DataselMat,node;
type

TTypeCarac =(ordered,UnOrdered);
TTypePolytom =(hard,soft);

TEtatFreq=class(TObject)
public
 etat:integer;
 freq:integer;
constructor create(e :integer);
end;

// utiliser pour les HardPolytomies des caracO
TEtatLR=class(TObject)
public
 etat:integer;
 R:integer;
 L:integer;
constructor create(e :integer);
end;

// petite classe cre pour l'algorithme HP
TListEtatLR=class(TObject)
 public
  list:TList;
  constructor  create;
  constructor createList(listOflistEtat :TList);
  function createListEtatMedian:TListEtat;
 end;

TListEtatFreq=class(TObject)
 public
  list:TList;
   constructor  create;
  procedure test(e:integer);
  function createListEtat:TListEtat;
 end;



TCaractere = class(TObject)
 private

  FData:TDataSelectCL;
  FName : string;
  FType :TTypecarac;
  FPolytom : TTypePolytom;

 public
 constructor createcarac(AName :string; Data :TDataSelectCL);virtual;

 function AffecteDT(Node : TNodeCL):integer;virtual;
 function AffecteDI(Node : TNodeCL):integer;virtual;
 function AffecteDSP(Node : TNodeCL):integer;virtual;
 function AffecteDHP(Node : TNodeCL):integer;virtual;
 procedure AffecteMPRIHP(Node : TNodeCL);virtual;
 procedure AffecteMPRISP(Node : TNodeCL);virtual;
 procedure AffecteEtatUp(Node : TNodeCL) ;

 procedure AffecteUp(Node : TNodeCL) ;virtual;
 procedure AffecteMPRI(Node : TNodeCL) ;virtual;
 procedure AffecteMPRT (Node : TNodeCL);virtual;

 function AffecteEtatDown(Node : TNodeCL):integer;
 procedure AffecteEtatMPR(Node :TNodeCL);
 end;

TCaracU=class(TCaractere)
 public

 constructor createcarac(AName :string; Data :TDataSelectCL);override;

 procedure AffecteMPRIHP(Node : TNodeCL); override;
 procedure AffecteMPRISP(Node : TNodeCL); override;
 procedure AffecteMPRI(Node : TNodeCL) ;override;

 function AffecteDHP(Node : TNodeCL):integer; override;
 function AffecteDSP(Node : TNodeCL):integer; override;

 procedure DefinirListEtat(Node : TNodeCL ; tab: TTabInteger);
 procedure InitListEtat(Alistetat: TListEtat ; listint :TListInteger);
 function  TrouveIntersect(Node : TNodeCL):integer;

 function FindTabSmallSet(TabCombin :TTabInteger ;  Node : TNodeCL;
                         ListNoeudRestant : TListInteger):TTabInteger;

 function SelectNoeudRestant(Node : TNodeCL; listint:TListInteger ): TListInteger;
 function DefListePrimaire(Node : TNodeCL):TListInteger;
 function DefListeSecondaire(Node : TNodeCL; listnode :TListInteger):TListInteger;
 function IsNoeudInclude(Node : TNodeCL ; listint: TListInteger):integer;

 function  AffecteDI(Node : TNodeCL):integer;override;
 function   AffecteDT(Node : TNodeCL):integer ;override;
end;

TCaracO = class(TCaractere)
 public
 constructor createcarac(AName :string; Data :TDataSelectCL);override;
 procedure AffecteMPRIHP(Node : TNodeCL);override;
 procedure AffecteMPRI(Node : TNodeCL);override;
 procedure AffecteMPRT (Node : TNodeCL); override;
 function AffecteDSP(Node : TNodeCL):integer; override;
 function AffecteDHP(Node : TNodeCL):integer;override;
 function AffecteDI(Node : TNodeCL):integer; override;
 function AffecteDT(Node : TNodeCL):integer;override;
 function  IntersectOListEtat( listOflistEtat :TList):TListEtat;
 end;




function CombineListe( listint :TListInteger ; NbIndex:integer ):TTabInteger;
function  Factoriel(n :integer):integer;
function CnP( n,p :integer):integer;

implementation

//****************************************************************************/
// jfr modifie le 09/09/04
// toutes les fonctions suivantes ont t cres
constructor TEtatFreq.create(e:integer);
begin
  etat:=e;
  freq:=1;
end;

constructor TEtatLR.create(e:integer);
begin
  etat:=e;
  R:=0;
  L:=0;
end;

constructor TListEtatFreq.create;
begin
  list:=TList.create;
end;

constructor TListEtatLR.create;
begin
  list:=TList.create;
end;

// Pour CaracO.affecteDHP
function  Distance(val:integer ;listEtat :TListEtat):integer;
 var
 i,valT :integer;
 trouve : boolean;
 begin
 trouve:=false;
 result:=0;
 for i:=0 to listEtat.list.count-1 do
   begin
      valT:=listEtat.list[i];
      if (valT=val) then begin trouve:=true; break; end;
    end;
    if (trouve=true) then result:=0
    else
      begin
        if (val>listEtat.Max) then result:=val-listEtat.Max
        else  if (val<listEtat.Min) then result:=listEtat.Min-val;
      end;
 end;

//***************************************************************************/
// Pour CaracO.affecteDHP
function calculDistance(val:integer ; listOflistEtat :TList):integer;

var
 listEtatp :TListEtat;
 step,i: integer;

 begin
 step:=0;
  for i:=0 to listOflistEtat.count-1 do
   begin
    listEtatp:=TListEtat(listOflistEtat.Items[i]);
    step :=step+ distance(val,listEtatp);
    end;
  result:=step;
 end;

 // Pour CaracO.affecteDHP
function calculDistanceTotale(listEtat:TListEtat ; listOflistEtat :TList):integer;
var
i,val,step:integer;
 begin
 step:=0;
  for i:=0 to listEtat.list.count-1 do
     begin
     val:=listEtat.List[i];
      step :=step+ calculdistance(val,listOflistEtat );
    end;
    result:=step;
 end;

//***************************************************************************/
 constructor TListEtatLR.createList(listOflistEtat :TList);
var
i,val,j:integer;
listEtatp, listEtatT, listEtatf: TListEtat;
etatLR:TEtatLR;
begin
  list:=TList.create;
  listEtatf:=TListEtat.Create;

  listEtatT:=TListEtat.CreateListEtat((listOflistEtat.Items[0]));
  listEtatT.Lister;
  for i:=1 to listOflistEtat.count-1 do
   begin
    listEtatp:=TListEtat(listOflistEtat.Items[i]);
    listEtatf.unir( listEtatp,listEtatT);
    listEtatf.Lister;
    listEtatT.copyList(listEtatf.list);
   end;
   listEtatT.free;

   for i:=0 to listEtatf.list.count-1 do
    begin
      val:=listEtatf.list[i];
      etatLR:=TEtatLR.create(val);
           for j:=0 to listOflistEtat.count-1 do
             begin
               listEtatp:=TListEtat(listOflistEtat.Items[j]);
               if (listEtatp.Left(val)=true) then inc(etatLR.L);
               if (listEtatp.Right(val)=true) then inc(etatLR.R);
             end;
      list.add(etatLR);
    end;

end;

function TListEtatLR.CreateListEtatMedian:TListEtat;
var
i:integer;
etatlr,etatlrg,etatlrd:TEtatLR ;
listetat:TListEtat;

 begin
  listetat:=TListEtat.Create;

 if (list.count<3) then begin result:=listetat ; exit; end
 // si la liste contient moins de trois etats, il n'est pas possible de trouver des etats medians
   else begin
    for i:=1 to list.count-2 do
     begin
       etatlrg:=TEtatLR(list.items[i-1]);
       etatlrd:=TEtatLR(list.items[i+1]);
       etatlr:=TEtatLR(list.items[i]);
       if (etatlr.R<=etatlrd.L) and (etatlr.L<=etatlrg.R) then
         listetat.List.Add(etatlr.etat);
      end;
   end;
 result:=listetat;
 end;

procedure TListEtatFreq.test(e:integer);
var
i:integer;
trouve:boolean;
etatfreq:TEtatFreq ;

 begin
 trouve:=false;
 for i:=0 to list.count-1 do
  begin
   etatfreq:=TEtatFreq(list.items[i]);
   if (etatfreq.etat=e)  then
    begin
     inc(etatfreq.freq);
     trouve:=true;
     break;
    end ;
   end;
 if (trouve=false) then
  begin
   etatfreq:=TEtatFreq.create(e);
   list.add(etatfreq);
  end;
  end;


 function TListEtatFreq.createListEtat:TListEtat;
 var
 max,i:integer;
 listetat:TListEtat;
 etatfreq:TEtatFreq;
 begin
 max:=0;
 listetat:=TListEtat.Create;
 // on cherche la valeur maximale
   for i:=0 to list.count-1 do
      begin
        etatfreq:=TEtatFreq(list.items[i]);
        if (etatfreq.freq>max) then max:=etatfreq.freq ;
      end;
  for i:=0 to list.count-1 do
      begin
        etatfreq:=TEtatFreq(list.items[i]);
        if (etatfreq.freq=max) then  listetat.List.Add(etatfreq.etat);
     end;
 result:=listetat;
 end;

 // fin des fonctions rajoutes le 09/09/04
//*******************************************************************************/
function  Factoriel(n :integer):integer;
var
 ret :integer;
begin
  ret:=1;
  if (n>0) then
   begin
    while (n>0) do ret:=ret*n; dec(n);end;
  result:=ret;
end;
//********************************************************************************/
function CnP( n,p :integer):integer;
var
ret,denom:integer;
begin
 if (p=0)and(n<>0) then begin result:=n; exit; end;
  if (p=0)and(n=0) then begin result:=1; exit; end;

  ret :=Factoriel(n);
  denom:= Factoriel(p) * Factoriel(n-p);
  ret := ret div denom;
  result:=ret;
end;
//*******************************************************************************/
// recherche  partir d'une liste d'entier(ListInt) contenant NbInt chiffres
// le nombre et le contenu de toutes les combinaisons possibles de 1,2,.. ou NbIndex chiffres

function CombineListe( listint :TListInteger ; NbIndex:integer ):TTabInteger;
var
 NoCase, nocases ,depcase, nbrepet, nbindexs : integer;
  NbTab,nbtabs ,NoChiffre, dep,i, NbCombin : integer;
 Tab : TTabInteger;

begin
  // NoCase : numro de la case qui doit tre remplie
  // nbindex : variable temporaire miroir de NbIndex
  // NoChiffre : Numro du chiffre courant dans la ListInt
  // nbrepet : Correspond au nombre de rptions d'un chiffre dans TabInt

  NbTab:=listint.Count;
   // Calcul du nombre de combinaisons possibles
  NbCombin:=CnP(NbTab,NbIndex);
  Tab:=TTabInteger.create;
  NoCase:=0;
  nbindexs:=NbIndex-1;

  while (NoCase<NbIndex-1) do
  begin
    NoChiffre:=NoCase;
    nbtabs:=NbTab-NoChiffre-1;
    dep:=0;
    nocases:=NoCase;
    depcase:=NoCase;
    nbrepet:=CnP(nbtab,nbindexs);

    while (nbrepet>=1)and (dep<NbCombin) do
    begin
       for i:=0 to nbrepet-1 do
        begin
         Tab.Items[i+dep,NoCase]:=listint.Items[NoChiffre];
         inc(dep);
         end; // pour la lisibilit
       inc(NoChiffre);

      if (NoChiffre>(NbTab-NbIndex+NoCase))or (nbtabs=0) then
        begin
         inc (nocases);
         if (nocases>=NbTab)then  begin inc(depcase); nocases:=depcase;end;
         NoChiffre:=nocases;
         nbtabs:=NbTab-NoChiffre-1;
         end
      else dec(nbtabs);

      nbrepet:=CnP(nbtabs,nbindexs);
    end;
    inc(NoCase); dec(nbindexs);
  end;
  result:=Tab;
 end;
//**********************************************************************/
                      // TCaractere
//**********************************************************************/
 constructor TCaractere.createcarac(AName :string; Data :TDataSelectCL);
  begin
    FName:=AName;
    FData:=Data;
    if (typePolytom='hard') then FPolytom:=hard else FPolytom:=soft;
  end;
//**********************************************************************/
 function TCaractere.AffecteDT(Node : TNodeCL):integer;
  begin
  result:=0;
  end;
//**********************************************************************/
 function TCaractere.AffecteDI(Node : TNodeCL):integer;
  begin
  result:=0;
  end;
//**********************************************************************/
 function TCaractere.AffecteDSP(Node : TNodeCL):integer;
 begin
 result:=0;
 end;
//**********************************************************************/
 function TCaractere.AffecteDHP(Node : TNodeCL):integer;
  begin
  result:=0;
  end;
 // jfr modifie le 28/09/04 pour la clart du code
 //**********************************************************************/
 procedure TCaractere.AffecteMPRI(Node : TNodeCL) ;
 begin
 end;
//**********************************************************************/
 procedure TCaractere.AffecteMPRIHP(Node : TNodeCL);
 begin
 end;
//**********************************************************************/

 procedure TCaractere.AffecteMPRISP(Node : TNodeCL);
 begin
 end;
//**********************************************************************/
 procedure TCaractere.AffecteEtatUp(Node : TNodeCL) ;
 begin
  Node.EtatUp.List.count:=0;
  AffecteUp(Node);
  end;
//**********************************************************************/
function TCaractere.AffecteEtatDown(Node : TNodeCL):integer;
var
step :integer;
begin
  Node.EtatDown.List.count:=0;
   case Node.NbChilds of
        0 : Step:= AffecteDT(Node);
     else  Step:= AffecteDI(Node);
   end;
   result:=Step;
 end;
//**********************************************************************/
procedure TCaractere.AffecteEtatMPR(Node :TNodeCL);
begin
node.EtatMPR.List.count:=0;
   case Node.NbChilds of
      0 : AffecteMPRT(Node);
    else  AffecteMPRI(Node);
   end;
end;
//********************************************************************/

procedure TCaractere.AffecteMPRT (Node : TNodeCL);
var
 StrlistEtat :string;
 etats ,FM :TListEtat;
 nbetat,offset :integer;
 missing : boolean; //jfr modifie le 07/09/04
begin
  missing:=false;
  StrlistEtat:=FData.GetListEtat(Node.Name,FName);
     //jfr modifie le 07/09/04 pour tenir compte de la modification de GetListEtat
     OffSet:=pos('?/',StrListEtat);
     if (Offset>0) then begin Delete(StrListEtat,1,2); missing:=true;end;

  etats:=TListEtat.CreateStr(Strlistetat,'/');

  if Node.Parent<>nil then
  FM:=(TNodeCL (Node.Parent)).EtatMPR;
  // attention il faudrait rajouter else return null     JFR modifi le 23//2007
 nbetat:=etats.List.Count;

 //jfr modifie le 07/09/04 pour tenir compte de l'tat inconnu
 if (missing=true) then
         begin
           if (Node.NbBrothers>1)then
           begin
           // modifi le 08/09/04
                if (FPolytom=hard) then  (Node.EtatMPR).CopyList(FM.list)
                else (Node.EtatMPR).CopyList(Node.EtatUP.List);
               end
	   else  (Node.EtatMPR).CopyList(FM.list);
// oblige  connaitre l'tat mpr du parent et donc  modifier la fonction TArbre.DefineStateMPR et la boucle de calcul en prtant par la racine
           exit;
	 end;
 if (nbetat=1)then (Node.EtatMPR).CopyList(etats.list) // monomorphic
 else
    begin if (nbetat>1) then
       begin if (Node.NbBrothers=1)then
	    begin
             if (FM.IsSubset(etats)<>0) then (Node.EtatMPR).CopyList(FM.List)
	     else begin
                  if (etats.Uncertain=1) then
                     (Node.EtatMPR).CopyList(etats.list)
		     else  (Node.EtatMPR).Unir(etats,FM);
		   end;
	    end
	 else  (Node.EtatMPR).CombinePlus(etats,Node.EtatUP);
       end else
      begin if (nbetat=0)then            // inutile doit correspondre  l'tat inconnu
	 begin
         if (Node.NbBrothers>1)then (Node.EtatMPR).CopyList(Node.EtatUP.List)
	   else  (Node.EtatMPR).CopyList(FM.list);
	 end;
      end;
    end;
end;

//********************************************************************/


//********************************************************************/

procedure TCaractere.AffecteUp(Node : TNodeCL) ;
var
 AParent,ANode,frere :TNodeCL;
 etatp,listDown :  TListEtat;
 i :integer;
begin
  AParent:=TNodeCL(Node.Parent);
  if (AParent=nil)  then exit ;
 // la racine n'a pas de uppass set

 if (AParent.Parent=nil) then // son pere est la racine
  begin
   if (Node.NbBrothers=1)then   // Le pere est une racine dichotome
	begin                   // on copie l'tat down du frere
         frere :=TNodeCL ( Node.Brother[0]);
         listDown :=frere.EtatDown;
         Node.EtatUp.CopyList(listDown.list);
         
	end
    else
     begin
       // son pere est une racine polytome : interpretation
       // on combine tous les tatsDown des frres
      Anode:=TNodeCL (Node.brother[0]);
      etatp:=TListEtat.createListEtat(Anode.EtatDown);  // problme
        for i:=2 to AParent.NbChilds-1 do        // jfr modifie le 07/09/04   grosse erreur "for i:=1..."
	  begin
               Anode:=TNodeCL (Node.brother[i-1]);  // -1 rajout
               (Node.EtatUp).CombinePlus(etatp,Anode.EtatDown);
                etatp.CopyList(Node.EtatUp.list);    // jfr modifie le 07/07/04   grosse erreur "Parent.EtatUp.list
             // bien comprendre que c'est une boucle qui enrichit  chaque tour etatp
	    end;
	    etatp.free;
       end;
  end
 else
  begin
  if (AParent.NbChilds>2) then // Le pere n'est pas la racine et est polytome
  // interprtation : on combine l'tatUp du pre avec tous les etatDown des frres
     begin
     etatp:=TListEtat.createListEtat(AParent.EtatUp);
	 for i:=1 to AParent.NbChilds-1 do
           begin
            Anode:=TNodeCL (Node.brother[i-1]);  // -1 rajout
            (Node.EtatUp).CombinePlus(etatp,Anode.EtatDown);
             etatp.CopyList(Node.EtatUp.List);
	       // ou  etatNode.CopyEtat(AParent.GetEtatUp()); ?
	    end;
         etatp.free;
      end
  else
    begin   // Le AParent n'est pas la racine et a deux fils
    // interprtation : on combine l'tatUp du pre avec l'etatDown du frre
      Anode:=TNodeCL (Node.Brother[0]);
      (Node.EtatUp).CombinePlus(Anode.EtatDown,AParent.EtatUp);
    end;
  end;
end;
//******************************************************************************/
                        // TCaracU
//******************************************************************************/
constructor TCaracU.createcarac(AName :string; Data :TDataSelectCL);
  begin
    inherited createcarac(AName,Data);
    FType:=UnOrdered;
  end;

//*********************************************************************/
function TCaracU. AffecteDT(Node : TNodeCL):integer ;// en ralite (NoeudT *N)
 var
  step : integer;
  ListE : TListEtat;
  AName , Etats: string;
   Offset:Integer;
   missing : boolean;      //jfr modifie le 07/09/04 pour tenir compte de la modification de GetListEtat
                           // missing inutile car l'algo n'est pas modifi
 begin
  Step:=0;
  AName:=node.Name;
  Etats:=FData.GetListEtat(AName,FName);
  missing:=false;

  //jfr modifie le 07/09/04 pour tenir compte de la modification de GetListEtat
     OffSet:=pos('?/', Etats);
     if (Offset>0) then begin Delete(Etats,1,2); missing:=true; Node.Missing:=true; end
     else Node.Missing:=false;

  ListE:=TListEtat.CreateStr(Etats,'/');
  Step:=ListE.List.Count-1;

  if (Node.EtatDown<>nil) then node.EtatDown.free;
  node.EtatDown:=ListE;

  result:=Step;
end;
//**********************************************************************/

function TCaracU.AffecteDI(Node : TNodeCL):integer;      // Pour un noeud interne
 var
 node1, node2 :TNodeCl;

 begin
 if (Node.NbChilds>2) then
  begin
   if (FPolytom=hard)
    then  result:=AffecteDHP(Node)
    else result:= AffecteDSP(Node);
   end
 else
   begin
    node1 :=TNodeCL (Node.Child[0]);
    node2 :=TNodeCL (Node.Child[1]);
    result:= (Node.EtatDown).CombinePlus(node1.EtatDown,node2.EtatDown);
    end;
end;


//********************************************************************************/

function TCaracU.IsNoeudInclude(Node : TNodeCL ; listint: TListInteger):integer;
var
  Alistetat: TListEtat;
  retour ,Nb ,i,j:integer;
begin
 Alistetat:=node.EtatDown;
 retour:=0;
 for i:=0 to listint.count-1 do
  begin
    Nb:=listint.Items[i];
     for j:=0 to AListEtat.List.Count-1 do
       begin
        if (Nb=Alistetat.List.Items[j]) then
            begin
             retour:=1;
             break;
             end;
        end;
    if (retour>0)then  break;
  end;
  result:=retour;
end;
//********************************************************************************/
// Construit une deuxime liste  partir des noeuds prsentants plusieurs tats
// que l'on ne retrouve pas dans la liste des tats primaires

function TCaracU. DefListeSecondaire(Node : TNodeCL; listnode :TListInteger):TListInteger;
var
NoNode ,i: integer;
AChild :TNodeCL;
listdef : TListEtat;
listint : TListInteger;
begin
  listdef:=TListEtat.Create;

  NoNode :=listnode.Items[0];
  AChild := TNodeCL (Node.Child[NoNode]);
  listdef.CopyList(AChild.EtatDown.List);

  for i:=1 to listnode.Count-1 do
  begin
   NoNode:=listnode.Items[i];
   AChild:= TNodeCL (Node.Child[NoNode]);
   listdef.Unir(listdef,AChild.EtatDown);
  end;

  listint:=TListInteger.create;

  for i:=0 to listdef.List.Count-1 do
   listint.Add(listdef.List.Items[i]);

 listdef.free;
 result:=listint;
end;

//********************************************************************************/
// Construit une premire liste d'entier  partir des noeuds qui ne prsentent qu'un tat

function TCaracU.DefListePrimaire(Node : TNodeCL):TListInteger;
var
 Achild: TnodeCL;
 listint :TListInteger;
 dep,tot,i :integer;
  Alistetat , listpro :TListEtat;
begin
  listint:=TListInteger.create;
  dep:=0;
  tot:=0;
  for i:=0 to Node.NbChilds -1 do
   begin
    AChild:=TNodeCL (Node.Child[i]);
    listpro:=AChild.EtatDown;
     if (listpro.List.Count=1)then
      begin
       Alistetat:=TListEtat.CreateListEtat(listpro);
       dep:=i+1;
       break;
      end;
   end;

  if (dep=0) then
    begin
     listint.free; result:=nil; exit ;
   end;

   for i:=dep to Node.NbChilds -1 do
   begin
       AChild:=TNodeCL (Node.Child[i]);
       listpro:=AChild.EtatDown;
       if (listpro.List.Count=1)then Alistetat.Unir(Alistetat,listpro);
   end;

  for  i:=0 to Alistetat.List.Count-1 do
     listint.Add(Alistetat.List.items[i]);
  result:=listint;
 end;

//*******************************************************************************/
// Recherche des noeuds qui ne contiennent aucun des tats appartenant 
// la premire liste d'tats cre  partir des noeuds monotats

function TCaracU.SelectNoeudRestant(Node : TNodeCL; listint:TListInteger ): TListInteger;
var
 listnode :TListInteger;
 tot,i :integer;
 AChild :TNodeCL;
 begin
  listnode :=TListInteger.create;
  tot:=0;
 if (listint=nil) then
   begin
     for i:=0 to Node.NbChilds-1 do listnode.Add(i);
     result:=listnode;
     exit;
   end;

 for i:=0 to Node.NbChilds-1 do
 begin
     AChild:=TNodeCL(Node.Child[i]);
     if (IsNoeudInclude(AChild,listint)=0) then
      begin
       inc(tot);
       listnode.Add(i);
      end;
 end;
 if (tot>0) then result:=listnode
 else
  begin
   listnode.free;
   result:=nil;
  end;
 end;
 //********************************************************************************/
// Renvoie la table des plus petits ensembles couvrant les noeuds restants
// ou NULL s'il n'y en a pas

function TCaracU.FindTabSmallSet(TabCombin :TTabInteger ;  Node : TNodeCL;
                         ListNoeudRestant : TListInteger):TTabInteger;
var
 dep,trouve ,NoNode :integer;
 AChild :TNodeCL;
 TabSmallSet:TTabInteger;
 listint :  TListInteger ;
 i, j :integer;
begin
  dep:=0;
  
  TabSmallSet:=TTabInteger.create;

  for i:=0 to TabCombin.RowCount-1 do
  begin
    listint:=TabCombin.Row[i];
    trouve:=1;
    for j:=0 to ListNoeudRestant.Count-1 do
     begin
       NoNode:=ListNoeudRestant.Items[j];
       AChild:=TNodeCL(Node.child[NoNode]);
       if (IsNoeudInclude(AChild,listint)=0) then
        begin
         trouve:=0;
         break;
         end;
      end;
   if (trouve>0)then begin TabSmallSet.row[dep]:=listint; inc(dep); end;
  end;
 if (dep>0) then result:=TabSmallSet
 else
  begin TabSmallSet.free ; result:=nil; end;
 end;

//********************************************************************************/
// Recherche si l'intersection des listeetats des noeuds fils est non vide
function TCaracU.TrouveIntersect(Node : TNodeCL):integer;
var
 etatp :  TListEtat;
 AChild :TNodeCL;
 i:integer;
begin
  AChild:=TNodeCL(Node.Child[0]);
  etatp := TListEtat.CreateListEtat(AChild.EtatDown);

 for i:=1 to Node.NbChilds-1 do
   begin
      AChild:=TNodeCL(Node.Child[i]);
     (Node.EtatDown).Intersect(etatp,AChild.EtatDown);
     etatp.CopyList(Node.EtatDown.List);
   end;
   etatp.free;
   result:= (Node.EtatDown).List.Count;
end;

//********************************************************************************/
procedure TCaracU.InitListEtat(Alistetat: TListEtat ; listint :TListInteger);
var
i :integer;
begin
  Alistetat.list.clear;
  for i:=0 to listint.count-1 do
  Alistetat.List.add(listint.items[i]);
end;


//********************************************************************************/
procedure TCaracU.DefinirListEtat(Node : TNodeCL ; tab:TTabInteger);
var
Alistetat : TListEtat;
dep,i :integer;
begin
 dep:=0;
 // si la premire liste existe, elle a servi  initialiser Node.EtatDown
 // sinon il faut le faire !
 if ((Node.EtatDown).List.Count=0)then
  begin
   InitListEtat(Node.EtatDown,tab.Row[0]);
   dep:=1;
  end;

 for i:=dep to tab.RowCount-1 do
  begin
    Alistetat:=TListEtat.create;
    InitListEtat(Alistetat,tab.row[i]);
    Node.EtatDown.Unir(Node.EtatDown,Alistetat);
    Alistetat.free;
  end;
end;

//*******************************************************************************/
function TCaracU.AffecteDSP(Node : TNodeCL):integer;
var
  TabCombin,TabCover  : TTabInteger ;
  compt, NbStep , index : integer;
  firstList, ListeNoeudRestant, SecondeListe :TListInteger;
begin

   TabCover:=nil;
   compt:=0;
   NbStep:=0;  // si l'intersection est non vide : aucun saut volutif n'est ncessaire

   if (TrouveIntersect(Node)<>0) then begin result:= NbStep; exit ; end;

   firstList:=DefListePrimaire(Node);
   if (firstList<>nil) then compt:=firstList.count-1;

   // Si premire liste n'existe pas La listeNoeudrestant est initialise par
   // la fonction SelectNoeudRestant  la liste de tous les noeuds fils

   ListeNoeudRestant:= SelectNoeudRestant(Node,firstList);

   if (ListeNoeudRestant=nil) then
    begin
      InitListEtat(Node.EtatDown,firstList);
      result:=firstList.count-1;
      exit;
    end;

   SecondeListe:=DefListeSecondaire(Node,ListeNoeudRestant);

   for index:=2 to SecondeListe.Count-1 do
   begin
    TabCombin:=CombineListe(SecondeListe,index);
    TabCover:=FindTabSmallSet(TabCombin,Node,ListeNoeudRestant);
      if (TabCover<>nil) then
        begin
         if (firstList<>nil) then
           InitListEtat(Node.EtatDown,firstList);
         DefinirListEtat(Node,TabCover);
         NbStep:=index+compt ;
         break;
        end;
   end;
   if (TabCombin<>nil) then TabCombin.free;
   if (TabCover<>nil) then TabCover.free;
  result:=NbStep;
end;
//*******************************************************************************/

//function TCaracU.AffecteDHP(Node : TNodeCL):integer;
// var
 //node1 ,node2 :TNodeCL;
// etat1, etat2, etatp ,etat: TListEtat ;
 //trouve ,ret ,max, i ,j: integer;
 //begin
 // trouve:=0;
//  for i:=0 to Node.NbChilds-1 do
 //	begin
 //         node1:=TNodeCL(Node.child[i]);
 //	  etat1:=node1.EtatDown;
 //         etat1.Freq:=1;
 //         for j:=i+1 to Node.NbChilds-1 do
  //	     begin
  //               node2:=TNodeCL(Node.child[j]);
  //               etat2:=node2.EtatDown;
  //               ret:= etat1.Compare(etat2) ;
   //		 if (ret>0) then inc(etat1.Freq) ;
  //	end; end;
 // Recherche le premier ( cause du ">") tat dont la frquence est maximale
// Max:=0;
 //for i:=0 to Node.NbChilds-1 do
   //	begin
    //     node1:=TNodeCL(Node.child[i]);
    //     etat1:=node1.EtatDown;
    //	 if (etat1.Freq>Max)then
    //       begin
    //        etatp:=etat1;
    //        Max:=etat1.Freq;
    //        trouve:=i;
   //         end;
   //	end;
 // Recherche si d'autres tats ont une frquence maximale identique
 //et les unit  celui dj trouv
// etat:=Node.EtatDown;
 //etat.CopyList(etatp.List);
 // for i:=0 to Node.NbChilds-1 do
 //   begin
 //    node1:=TNodeCL(Node.child[i]);
  //   etat1:=node1.EtatDown;
  //   if (etat1.Freq=Max)and(trouve<>i) then
   //    (Node.EtatDown).Unir(Node.EtatDown,etat1);
  //  end;
// Remet les frquences  zro
//for i:=0 to Node.NbChilds-1 do
// begin
 // node1:=TNodeCL(Node.child[i]);
 // etat1:=node1.EtatDown;
 // etat1.Freq:=0;
 //end;
// result:=Node.NbChilds-Max;
//end;



//*******************************************************************************/
// jfr modifie le 09/09/04
function TCaracU.AffecteDHP(Node : TNodeCL):integer;
var
 node1  :TNodeCL;
 etat1 : TListEtat ;
  nb, i ,j,k: integer;
 listfreq:TListetatfreq;
 trouve :boolean;
 begin

  listfreq:=TListetatfreq.create;
  for i:=0 to Node.NbChilds-1 do
	begin
          node1:=TNodeCL(Node.child[i]);
	  etat1:=node1.EtatDown;
          for j:=0 to etat1.List.Count-1 do
            listfreq.test(etat1.list[j]);
        end;



 Node.EtatDown:=listfreq.CreateListetat;

 // nb est le nombre de noeuds fils ayant un des tats les plus frquents
 nb:=0;
 for i:=0 to Node.NbChilds-1 do
	begin
          node1:=TNodeCL(Node.child[i]);
	  etat1:=node1.EtatDown;
          trouve:=false;
          for j:=0 to etat1.List.Count-1 do
             begin
              trouve:=false;
                 for k:=0 to Node.EtatDown.List.Count-1 do
                   begin
                     if (etat1.List[j]=Node.EtatDown.List[k])  then
                        begin
                           trouve:=true;
                           inc(nb);
                           break;
                          end;
                     end;
                    if (trouve=true) then break;
             end;
          
       end;
  result:= Node.NbChilds-nb;
  end;

//*******************************************************************************/
procedure TCaracU.AffecteMPRI(Node : TNodeCL) ;
var
 AChild1,AChild0 :TNodeCL;
begin

  if (Node.Parent=nil) then // P est la racine
   begin
    (Node.EtatMPR).CopyList(Node.EtatDown.List);
     exit ;
     end;

  if (Node.NbChilds=2) then
   begin
    AChild0:= TNodeCL(Node.Child[0]);
    AChild1:= TNodeCL(Node.Child[1]);
    (Node.EtatMPR).CombinePlus3(AChild0.EtatDown,AChild1.EtatDown,Node.EtatUp);
  end;
  if (Node.NbChilds>2) then
  begin
    if (FPolytom=hard) then AffecteMPRIHP(Node)
    else AffecteMPRISP(Node);
  end;
end;

//***********************************************************************************/
procedure TCaracU.AffecteMPRISP(Node : TNodeCL);
begin
 (Node.EtatMPR).CombinePlus(Node.EtatDown,Node.EtatUp);
end;
//*******************************************************************************/
// C'est la mme que AffecteDHP mais elle rajoute en plus le Uppass du noeud
// jfr modifie le 09/09/04
procedure TCaracU.AffecteMPRIHP(Node : TNodeCL);
 var
 node1  :TNodeCL;
 etat1 : TListEtat ;
    i ,j : integer;
 listfreq:TListetatfreq;

 begin

  listfreq:=TListetatfreq.create;
  for i:=0 to Node.NbChilds-1 do
	begin
          node1:=TNodeCL(Node.child[i]);
	  etat1:=node1.EtatDown;
          for j:=0 to etat1.List.Count-1 do
            listfreq.test(etat1.list[j]);
        end;

 etat1:=Node.EtatUp;
   for j:=0 to etat1.List.Count-1 do listfreq.test(etat1.list[j]);

 Node.EtatMPR:=listfreq.CreateListetat;
 end;

//procedure TCaracU.AffecteMPRIHP(Node : TNodeCL);
//var
 // node1, node2 :TNodeCL;
// etat1, etat2, etatp ,etat: TListEtat;
// trouve,i,j,max  :integer;
// begin
//  trouve:=0;
  // Mme algorithme que pour le down pass mais avec en plus l'tatUp du noeud
//  etat1:=Node.EtatUp;
//  etat1.Freq:=1;

 // for  j:=0 to Node.NbChilds-1 do
 //   begin
 //    node2:=TNodeCL(Node.Child[j]);
 //    etat2:=node2.EtatDown;
 //    if ((etat1.Compare(etat2))>0) then inc(etat1.Freq) ;
 //   end;

//  for i:=0 to Node.NbChilds-1 do
 //   begin
  //   node1:=TNodeCL(Node.Child[i]);
 //    etat1:=node1.EtatDown;
 //    etat1.Freq:=1;
//     for j:=i+1 to Node.NbChilds-1 do
 //	  begin
 //          node2:=TNodeCL(Node.Child[j]);
  //         etat2:=node2.EtatDown;
  //         if (etat1.Compare(etat2)>0) then inc(etat1.Freq);
 // end; end;
 // Recherche le premier ( cause du ">") tat si il existe
 // dont la frquence est suprieure  celle de l'Up pass du noeud

// Max:=(Node.EtatUp).Freq;
// etatp:=Node.EtatUp;
// trouve:=-1;

 //for i:=0 to Node.NbChilds-1 do
 //   begin
  //   node1:=TNodeCL(Node.Child[i]);
 //    etat1:=node1.EtatDown;
   //  if (etat1.Freq>Max) then
   //     begin
  //       etatp:=etat1;
  //       Max:=etat1.Freq;
  //       trouve:=i;
   //      end;
  //   end;
 // Recherche si d'autres tats ont une frquence maximale identique
 //et les unit  celui dj trouv

 // etat:=Node.EtatMPR;
 // etat.CopyList(etatp.List);

  //for i:=0 to Node.NbChilds-1 do
 //   begin
  //    node1:=TNodeCL(Node.Child[i]);
 //     etat1:=node1.EtatDown;
 //     if (etat1.Freq=Max)and(trouve<>i) then
  //     (Node.EtatMPR).Unir(Node.EtatMPR,etat1);
//    end;
// Remet les frquences  zro
//for i:=0 to Node.NbChilds-1 do
 //begin
 //  node1:=TNodeCL(Node.Child[i]);
 //  node1.EtatDown.Freq:=0;
 //end;
 //etat1:=Node.EtatUp;
 //etat1.Freq:=0;
//end;
//******************************************************************************/
                        // TCaracO
//******************************************************************************/
constructor TCaracO.createcarac(AName :string; Data :TDataSelectCL);
  begin
    inherited createcarac(AName,Data);
    FType:=Ordered;
  end;

//**********************************************************************/
// Cette fonction est cre pour trouver l'intersection d'une liste d'tat
// elle doit tre commune  AffecteDHP et AffecteMPRIHP
// jfr modifie le 09/09/04
function TCaracO.IntersectOListEtat( listOflistEtat :TList):TListEtat;
var
listEtatf,listEtatTemp, listEtatp : TListEtat;
 i:integer;
begin
listEtatf:=TListEtat.Create;
 listEtatTemp:=TListEtat.CreateListEtat((listOflistEtat.Items[0]));
 for i:=1 to listOflistEtat.count-1 do
   begin
    listEtatp:=TListEtat(listOflistEtat.Items[i]);
    listEtatf.intersectO( listEtatp,listEtatTemp);
     if listEtatf.list.count=0 then break;
    listEtatTemp.copyList(listEtatf.list);
    end;
  listEtatTemp.free;
  result:= listEtatf;
end;

function TCaracO. AffecteDT(Node : TNodeCL):integer; // en ralite (NoeudT *N)
var
step :integer;
ListE : TListEtat;
strlistetat :string;
Offset:Integer;
missing : boolean;   //jfr modifie le 07/09/04 pour tenir compte de la modification de GetListEtat
begin                // missing inutile car l'algo n'est pas modifi

  Step:=0;
  strlistetat:=FData.GetListEtat(Node.name,FName);
   missing:=false;
  //jfr modifie le 07/09/04 pour tenir compte de la modification de GetListEtat
     OffSet:=pos('?/', strlistetat);
     if (Offset>0) then begin Delete(StrListEtat,1,2); missing:=true;Node.Missing:=true;end
     else Node.Missing:=false;

  ListE:= TListEtat.createStr(strlistetat,'/');
  Step:=(ListE.Max)-(ListE.Min);

  // if (node.EtatDown<>nil) then node.EtatDown.free;
  node.EtatDown.Range(ListE);
  ListE.free;
  result:= Step;
end;
//******************************************************************************/
function TCaracO.AffecteDI(Node : TNodeCL):integer;
var
 n1, n2 :TNodeCL;
 etatdown, etatdown1, etatdown2 : TListEtat;
begin
 if (Node.NbChilds=2)then
  begin
    n1:= TNodeCL (Node.child[0]);
    n2:= TNodeCL (Node.child[1]);
    etatdown:=Node.EtatDown;
    etatdown1:=n1.EtatDown;
    etatdown2:=n2.EtatDown;
    result:=etatdown.CombineO(etatdown1,etatdown2);
   end
  else begin
  if (FPolytom=hard) then
       result:=AffecteDHP(Node)
  else result:=AffecteDSP(node);
  end;
end;

//**********************************************************************/
// jfr modifie le 09/09/04
function TCaracO.AffecteDHP(Node : TNodeCL):integer;
var
 listOfListEtat :TList;
 listEtat:TListEtat;
  i:integer;
  ListEtatLR :TListEtatLR ;

begin
   listOfListEtat:=TList.Create;
   for i:=0 to Node.NbChilds-1 do
      listOfListEtat.Add(TNodeCL(Node.Child[i]).EtatDown);
      
   listEtat:=IntersectOListEtat( listOflistEtat)  ;
   if (listEtat.List.count>0)   then           // l'intersection est non vide : c'est bon
    begin
        Node.EtatDown.CopyList(listEtat.List);
        result:=0;     
        listEtat.Free;
        exit;
     end
   else
   begin
       listEtatLR:=TListEtatLR.createList(listOflistEtat);
       listEtat:=listEtatLR.createListEtatMedian;
        if (listEtat.List.count>0)   then           // l'intersection est non vide : c'est bon
          begin
            Node.EtatDown.CopyList(listEtat.List);
            result:=calculDistanceTotale(Node.EtatDown,listOflistEtat);
            listEtat.Free;
            exit;
           end
         else    // je ne sais pas traiter ce cas
          result:=AffecteDSP(Node);
  end;
end;


function TCaracO.AffecteDSP(Node : TNodeCL):integer;
var
etatp ,e1 :TListEtat ;
AChild :TNodeCL;
i, min, max, Mi, Ma, temp :integer;
begin
  AChild:=TNodeCL(Node.Child[0]);
  etatp:= TListEtat.createListEtat(AChild.EtatDown);

   // Recherche l'intersection des EtatsDown de tous les noeuds fils
   for i:=1 to Node.NbChilds-1 do
   begin
      AChild:=TNodeCL(Node.Child[i]);
     (Node.EtatDown).IntersectO(etatp,Achild.EtatDown);    // // jfr corrig le 03/06/2003 (Node.EtatDown).Intersect(etatp,Node.EtatDown);
     etatp.CopyList(Node.EtatDown.list);
   end;

   etatp.free;

   // Si cette intersection est vide. On recherche l'tat (1) dont le maximum
   // est le plus petit de l'ensemble et l'tat (2) dont le minimum est le plus grand
   // On dfinit alors une tat comprenant toutes les valeurs comprises entre (1) et (2)

   if ((Node.EtatDown).List.Count=0) then
    begin
      AChild:=TNodeCL(Node.Child[0]);
      e1:=AChild.EtatDown;
      min:=e1.Min; max:=e1.Max;

      for i:=1 to Node.NbChilds-1 do
        begin
          AChild:=TNodeCL(Node.Child[i]);
	  e1:=AChild.EtatDown;
	  Mi:=e1.Min;
	  Ma:=e1.Max;
           //jfr modifie le 28/09/04
           // aprs relecture de l'algorithme, il semble que la premire version soit la bonne

          //if (Mi<min)then  min:=Mi;     // jfr corrig le 03/06/2003     (Mi>min)
          //if (Ma>max)then  max:=Ma;     // jfr corrig le 03/06/2003     (Ma<max)
          if (Mi>min) then min:=Mi;
          if (Ma<max) then max:=Ma;

       end;
       // pour corriger l'ventuel problme du min>max
       if (min>max) then begin temp:=min; min:=max; max:=temp; end;
      result:=((Node.EtatDown).AffecteMinMax (min, max)-1);
    end
   else result:=0;
end;

//*******************************************************************************/
procedure TCaracO.AffecteMPRT (Node : TNodeCL);
var
BList,etats :TListEtat;
AParent :TNodeCL;
strListetat :string;
nbetat,OffSet :integer;
missing : boolean;  //jfr modifie le 07/09/04 pour tenir compte de la modification de GetListEtat

begin

 if (Node.NbBrothers=1) //and (FPolytom=soft))    // jfr corrig le 04/06/2003
 then
  begin
    APArent := TNodeCL (Node.Parent);
     BList:=AParent.EtatMPR;
  end
 else if (Node.NbBrothers>1)then BList:=Node.EtatUp;

 missing:=false;
 strlistetat:=FData.GetListEtat(Node.Name,FName);
 //jfr modifie le 07/09/04 pour tenir compte de la modification de GetListEtat
     OffSet:=pos('?/', strlistetat);
     if (Offset>0) then begin  Delete(StrListEtat,1,2); missing:=true;end;

 etats:=TListEtat.CreateStr(strlistetat,'/');

 nbetat:=etats.List.count;

 if (nbetat=1) then   // Monomorphique
  begin
  (Node.EtatMPR).CopyList(etats.list);
   exit ;
   end;

 //jfr modifie le 07/09/04 pour tenir compte de l'tat inconnu
 if (missing=true) then begin (Node.EtatMPR).CopyList(BList.list); exit;end;

 if (nbetat>1)or(etats.Uncertain=1) then
        (Node.EtatMPR).Closest(Node.EtatDown,BList);
 if (nbetat=0) then (Node.EtatMPR).CopyList(BList.list);
 end;
//*******************************************************************************/
procedure TCaracO.AffecteMPRI(Node : TNodeCL);
var
Achild0,AChild1 :TNodeCL;
begin
 if (Node.Parent=nil) then // Node est la racine
   begin
     (Node.EtatMPR).CopyList(Node.EtatDown.List);
     exit ;
   end;

 if (Node.NbChilds=2) then
    begin
    AChild0:=TNodeCL(Node.Child[0]);
    AChild1:=TNodeCL(Node.Child[1]);
   (Node.EtatMPR).CombineMult3(AChild0.EtatDown,AChild1.EtatDown,Node.EtatUp);
    end;
 if ((Node.NbChilds)>2) then
  begin
   if (FPolytom=soft)then        // jfr corrig le 03/06/2003
    (Node.EtatMPR).CombineO(Node.EtatDown,Node.EtatUp)
     else AffecteMPRIHP(Node);
  end;
end;
//********************************************************************************/
procedure TCaracO.AffecteMPRIHP(Node : TNodeCL);
var
 listOfListEtat :TList;
 listEtat:TListEtat;
  i:integer;
  ListEtatLR :TListEtatLR ;

begin
   listOfListEtat:=TList.Create;
   for i:=0 to Node.NbChilds-1 do
      listOfListEtat.Add(TNodeCL(Node.Child[i]).EtatDown);
   listOfListEtat.Add(TNodeCL(Node.EtatUp));   // mme algorithme que AffecteDHP
                                               // avec en plus Node.Etatup
   listEtat:=IntersectOListEtat( listOflistEtat)  ;
   if (listEtat.List.count>0)   then           // l'intersection est non vide : c'est bon
    begin
        Node.EtatMPR.CopyList(listEtat.List);
        listEtat.Free;
        exit;
     end
   else
   begin
       listEtatLR:=TListEtatLR.createList(listOflistEtat);
       listEtat:=listEtatLR.createListEtatMedian;
        if (listEtat.List.count>0)   then           // l'intersection est non vide : c'est bon
          begin
            Node.EtatMPR.CopyList(listEtat.List);
            listEtat.Free;
            exit;
           end
         else    // je ne sais pas traiter ce cas
          (Node.EtatMPR).CombineO(Node.EtatDown,Node.EtatUp); // fonction quivalente a  une TCaracO.AffecteMPRISP
  end;
end;



end.
 