unit fenarbre;
// Le 19/10/98 Ligne 674 perenodeG.OrgY+(dif... => perenodeG.OrgY-(dif...
// Le 19/10/98 Ligne 864 la fonction NodeBottomCoord a t change
interface

uses
sysutils,windows,graphics, classes, donnees, customgraph,arbre,node,ListARray2,dataselmat,
typedef,Listetat,group2,boite;


const NodeColor : array[0..17] of TColor =(clBlack ,clBlue, clYellow,clFuchsia,clRed, clGreen,
                                      clNavy,clLime, clPurple ,clTeal ,clGray, clSilver,
                                      clMaroon ,  clOlive ,
                                      clAqua , clLtGray ,clDkGray ,  clWhite );
type
{******************************************************************************
                              TLegende
*******************************************************************************}

TLegende =class (TGraphObject)
  private                                  
 FEndX : integer;
 FEndY : integer;
 FText : string;

 public

 property  Text:string read FText write FText;

 property  EndX : integer read FEndX write FEndX;
 property  EndY : integer read FEndY write FEndY;

 function PtInObject(APoint:TPoint):boolean;override;
 procedure Draw(ACanvas:TCanvas);override;
end;
{******************************************************************************
                              TGraphNode
*******************************************************************************}
TGraphNode =class (TGraphObject)
 protected

 FTypePage:TTypePage;
 FTypeTree:TTypeTree;

 function CreateActiveObject(Apoint :TPoint): TActiveObject;override;

 public
 PtArray : array[0..4]of TPoint;
 destructor destroy;override;

 function IsRoot:boolean;
 function AsChild:boolean;
 function IsPointAtTop(APoint:TPoint):boolean;
 function IsParent(ANode:TGraphNode): boolean;
 function IsBrother(ANode:TGraphNode): boolean;
 function IsNodePro: boolean;
 function IsInPolytom:boolean;
 function IsMissing:boolean;
 property TypePage:TTypePage read FTypePage write FTypePage;
 property TypeTree:TTypeTree read FTypeTree write FTypeTree;

 procedure Draw(ACanvas:TCanvas);override;
 function PtInObject(APoint:TPoint):boolean;override;
end;
{******************************************************************************
                              TGraphNodeT
*******************************************************************************}
TGraphNodeT =class (TGraphNode)
 public
 Text:string;
 procedure Draw(ACanvas:TCanvas);override;
end;
 {******************************************************************************
                             TTreePage (par dfaut horizontale)
*******************************************************************************}
TTreePage =class (TGraphPage)

 private
  FTree :TTree;


  FFontLeg : TLogFont;

  FLeftMargin:integer;
  FRightMargin:integer;
  FTopMargin:integer;
  FBottomMargin:integer;

  FTreeHeight:integer;
  FTreeWidth:integer;

  FInternode:integer;
  FBranchLength:integer;
  FBranchwidth:integer;

  protected


  FTypePage :TTypepage;

  public
  
  FFontTaxon :TLogFont;
  Flag_Legende: boolean;
  Flag_Color:boolean;

  IndexTreeAction :integer;
  ListTreeAction  : TStringList;

  procedure AddTreeAction( TreeStr :string);
  procedure DeleteTreeAction;
  function  GetPriorTreeAction : string;
  function  GetFirstTreeAction : string;
  function  GetNexTreeAction : string;
  procedure SaveTreeAction;

  property Tree :TTree read FTree write FTree;

  property TypePage :TTypepage read FTypePage write FTypePage;
  property FontTaxon:TLogFont read FFontTaxon write FFontTaxon;
  property FontLeg:TLogFont read FFontLeg write FFontLeg;

  constructor CreatePage(AParent: TGraphControl; ATree :TTree);

  function CalcMaxTextLength(ACanvas:TCanvas):integer;

  function CalcTextwidth(text:string;logfont:TLogFont;ACanvas:TCanvas):integer;
  function CalcTextHeight(text:string;logfont:TLogFont;ACanvas:TCanvas):integer;

  procedure CreateFontTaxon;virtual;
  procedure CreateFontLegende;

  procedure CreateCoordLeg(ACanvas:TCanvas);

  procedure CreateLeg;virtual;
  procedure CreateNodeG;

  procedure DeleteLeg;
  procedure DeleteNodeG;

  procedure CreateInfoGraph(ACanvas:TCanvas); override;

  procedure CalcNodeOrgX;virtual;
  procedure CalcNodeOrgY;virtual;

  procedure DefCoordNodeG;virtual;

  Procedure CreateObjects;override;
  Procedure DeleteObjects;override;

  Procedure CreateCoordObjects(ACanvas:TCanvas);override;

  procedure TreeRoot( NodeToRoot :TGraphNode);virtual;
  procedure TreeSwap(NodeToSwap :TGraphNode);

end;

{****************************************************************************** }

TTreePageVert =class (TTreePage)
 private

 FSelectCarac:string;

 FTypeEtat: TTypeEtatNode;
 FTypeLegende :TTypeLegende;
 FData: TDataSelectCL;

 public
  function NameOfFlagTaxonPro :string;

  // jfr modifie le 10/04/00
  // "_DND" rajout
  constructor CreatePageVert(AParent: TGraphControl; AData :TDataSelectCL; _DND :string);
  constructor CreatePageVertGroup(AParent:TGraphControl;AData :TDataSelectCL;TreeGroup :TTreeGroup);
  constructor CreatePageVertBoite(AParent: TGraphControl; AData :TDataSelectCL; Treeboite :TTreeBoite);
  procedure CreateFontTaxon; override;
  procedure CreateInfoGraph(ACanvas:TCanvas); override;
  procedure CalcNodeOrgX; override;
  procedure CalcNodeOrgY; override;
  procedure DefCoordNodeG; override;
  procedure CreateLeg;override;

  procedure TreeTaxonRemove( AName :string);

  procedure GraftTaxonPro(NodePro:TGraphNode; OnNode:TGraphNode);
  procedure GraftPolytomTaxonPro(NodePro:TGraphNode; OnNode:TGraphNode);

  procedure AddTaxonPro(AName : string); // AJoute un taxon  la fentre mais pas  l'arbre
  procedure  AddTaxonToDataList(num :integer);

  // jfr modifie le 10/04/00
  // fonction rajoute
  
  function CreateListCarac(ANodeG:TGraphNode): TStrListArray;
  procedure TreeRemoveAndGraftPolytom(NodeToRemove :TGraphNode; OnNodeGraft:TGraphNode);
  procedure TreeRemoveAndGraft(NodeToRemove :TGraphNode; OnNodeGraft:TGraphNode);
  procedure TreeRoot( NodeToRoot :TGraphNode);override;

  procedure ChangeListCarac( AName :string );
  procedure ChangeSelectCarac(AName :string);
  procedure ChangeTabCod(newtabcod :TStrListArray);
  procedure ChangeTree(newTreeStr :string);
  
  procedure NodeTopCoord;
  procedure NodeBottomCoord;

  property TypeEtat    :TTypeEtatNode read FTypeEtat  write FTypeEtat ;
  property TypeLegende :TTypeLegende read FTypeLegende  write FTypeLegende ;
  property Data  :TDataSelectCL read FData;
  
  property SelectCarac :string read FSelectCarac write FSelectCarac;
 end;

{ *******************************************************************************}
implementation


function TLegende.PtInObject(APoint:TPoint):boolean;
var
rec:TRect;
 begin

 rec.TopLeft:=Point(OrgX,OrgY);
 rec.BottomRight:=Point(EndX,EndY);

 if PtInRect(rec,APoint) then result:=true else result:=false;
 end;
{ *******************************************************************************}

procedure TLegende.draw(ACanvas:TCanvas);
var
NewFont :TFont;
OldFont :TFont;
logfont:TLogFont;
OldColor: TColor ;
OldStyle: TBrushStyle;

 begin
  OldColor:= ACanvas.brush.color;
  OldStyle:= ACanvas.brush.style;

  ACanvas.brush.style:=bssolid;
  ACanvas.brush.Color:=clwhite;

   ACanvas.Rectangle(OrgX-1,OrgY-1,EndX+2,EndY+2);

  NewFont:=TFont.Create;
  OldFont:=TFont.Create;

  OldFont.Assign(ACanvas.Font);
  logfont:=TTreePage(Parent).FontLeg;

  NewFont.Handle:=CreateFontIndirect(logfont);

  ACanvas.Font.Assign(NewFont);
  NewFont.free;


  ACanvas.TextOut(OrgX,OrgY,FText);
 //  ACanvas.TextRect(rec,OrgX,OrgY,FText);

  ACanvas.Font.Assign(OldFont);
  OldFont.free;

 ACanvas.brush.color:= OldColor;
 ACanvas.brush.style:=OldStyle ;

 end;
{******************************************************************************
                           TGraphNode
*******************************************************************************}
destructor TGraphNode.Destroy;
var
 node:TNodeBase;
 begin
  // rajout le 12/12/98 pour pouvoir supprimer un arbre avant la page qu'il contient
  //node:=TNodeBase(AssocObject);
  //if node<>nil then
  //node.ObjectAssoc:=nil;
  inherited destroy;
 end;

function TGraphNode.IsPointAtTop(APoint:TPoint):boolean;
var
rec:TRect;
page : TTreePage; 
 begin
 page:= TTreePage(Parent);
 rec.TopLeft:=Point(PtArray[1].x-(page.FBranchWidth div 2), PtArray[1].y);
 rec.BottomRight:=Point(PtArray[1].x + (page.FBranchWidth div 2),
                        PtArray[1].y + page.FBranchWidth);

 if PtInRect(rec,APoint) then result:=true else result:=false;
 end;

function TGraphNode.IsInPolytom:boolean;
 var
 node1 :TNodeBase;
 begin
  node1:=TNodeBase(AssocObject);
  if node1.NbBrothers > 1 then result:=true
  else result:=false;
 end;

function TGraphNode.IsParent(ANode:TGraphNode): boolean;
 var
 node1,node2:TNodeBase;
 begin
  node1:=TNodeBase(AssocObject);
  node2:=TNodeBase(ANode.AssocObject);

  if node1=node2.Parent then result:=true
  else result:=false;
 end;

function TGraphNode.IsNodePro: boolean;
 var
 node1:TNodeBase;
 begin
  node1:=TNodeBase(AssocObject);
  if node1.level=0 then result:=true else result:=false;
 end;

function TGraphNode.IsBrother(ANode:TGraphNode): boolean;
 var
 node1,node2:TNodeBase;
 begin
  node1:=TNodeBase(AssocObject);
  node2:=TNodeBase(ANode.AssocObject);

  if node1.Parent=node2.Parent then result:=true
  else result:=false;
 end;

 function TGraphNode.AsChild:boolean;
 var
 node:TNodeBase;
 begin
  node:=TNodeBase(AssocObject);
  if node.NbChilds > 0 then result:=true
  else result:=false;
 end;

function TGraphNode.IsMissing:boolean;
var
 node,nodeP:TNodeBase;
begin
  node:=TNodeBase(AssocObject);
  result:=node.Missing;
 end;

function TGraphNode.IsRoot:boolean;
var
 node,nodeP:TNodeBase;
begin
  node:=TNodeBase(AssocObject);
  if node.Parent=nil then result:=true
  else
  begin
   nodeP:=node.Parent;
   if nodeP.Parent=nil then result:=true
   else result:=false;
  end;
 end;

function TGraphNode.CreateActiveObject(Apoint :TPoint): TActiveObject;
begin
 result:=TLineGrow.createLine(Parent.Parent,APoint);
end;

function TGraphNode.PtInObject(APoint:TPoint):boolean;
var
reg:HRGN;    
begin
 reg:=CreatePolygonRgn(PtArray,5,ALTERNATE);
 if ptInRegion(reg,Apoint.X,Apoint.Y) then  result:=true else result:=false;
 DeleteObject(reg);
end;

{ *******************************************************************************}
procedure TGraphNode.draw(ACanvas:TCanvas);
var
 left,right,top,bottom:integer;
 node,nodechild:TNodeBase;
 OldColor: TColor ;
 OldStyle: TBrushStyle;
 nocolor: integer;

 begin
  OldColor:= ACanvas.brush.color;
  OldStyle:= ACanvas.brush.style;

  if TTreePage(Parent).Flag_Color=true then
     begin
      nocolor:=TNodeCL(AssocObject).GetNocolor(NEtatMPR);//TTreePagevert(Parent).TypeEtat);

      if nocolor=-1 then
           begin
           //jfr modifie le 28/09/04 remise de la racine monique si c'est marqu dans le ini
           //jfr modifie le 07/09/04   annulation de la modification prcdente
           // jfr modifie le 07/07/00  "and (TNodeCL(AssocObject).typeCarac=1)" rajout

           if  (ModifRacine='oui') and (IsRoot=true)and (TNodeCL(AssocObject).typeCarac=1) then
              ACanvas.brush.color:=NodeColor[1]  // Ceci a t rajout  la demande de certains..
            else begin                        // pour que la racine ait l'tat primtif quand son tat est incertain (prsent/absent)
               ACanvas.brush.color:=clblack;    // mais a n'a de sens que si le caractre est ordonn et donc que l'tat primtif est connu
               ACanvas.brush.style:=BsCross;
            end;
           end
      else
           begin
             if nocolor<11 then

                ACanvas.brush.color:=NodeColor[nocolor+1]  //  clwhite

             else
              begin

                ACanvas.brush.color:=NodeColor[nocolor-10];
                ACanvas.brush.style:=bsCross;
                end;
             
           end;
      end
  else   ACanvas.brush.color:=clblack;


  ACanvas.PolyGon(PtArray);

  ACanvas.brush.color:= OldColor;
  ACanvas.brush.style:=OldStyle ;

   if (TypePage=VERTICAL)and (Typetree=orthogonal) // noeud  vertical
	  then
           begin
            node:=TNodeBase(AssocObject);
            nodechild:=node.child[0];

	    left:=TGraphNode(nodechild.objectassoc).OrgX;
            nodechild:=node.child[node.NbChilds-1];
            right:=TGraphNode(nodechild.objectassoc).OrgX;

	    ACanvas.MoveTo(left,OrgY);
            ACanvas.LineTo(right,OrgY);

	  end


   else if (TypePage=HORIZONTAL)and (Typetree=orthogonal) // noeud  vertical
	  then
           begin
            node:=TNodeBase(AssocObject);
            nodechild:=node.child[0];

	    top:=TGraphNode(nodechild.objectassoc).OrgY;
            nodechild:=node.child[node.NbChilds-1];
            bottom:=TGraphNode(nodechild.objectassoc).OrgY;

	    ACanvas.MoveTo(OrgX,top);
            ACanvas.LineTo(OrgX,bottom);
         end;

 end;
{******************************************************************************
                            TGraphNodeT
*******************************************************************************}
procedure TGraphNodeT.draw(ACanvas:TCanvas);
var
NewFont :TFont;
OldFont :TFont;
logfont :TLogFont;
page    :TTreepage;
OldColor: TColor ;
OldStyle: TBrushStyle;
nocolor: integer;
 begin

  OldColor:= ACanvas.brush.color;
  OldStyle:= ACanvas.brush.style;

  if TTreePage(Parent).Flag_Color=true then
     begin
      nocolor:=TNodeCL(AssocObject).GetNocolor(NEtatMPR); //TTreePagevert(Parent).TypeEtat);
      if nocolor=-1 then
           begin
             ACanvas.brush.color:=clblack;
             ACanvas.brush.style:=BsCross;
           end
      else
           begin
             if nocolor<11 then
              begin
               ACanvas.brush.color:=NodeColor[nocolor+1];// clwhite
               if  (IsMissing=true)   then
                 begin
                   if (Quadrillage='non')
                      then
                         begin
                             ACanvas.brush.color:=clblack  ;
                             ACanvas.brush.style:=bsSolid ;
                           end  
                      else
                   ACanvas.brush.style:=bsdiagcross		;
                end ;
                end
             else
              begin
              ACanvas.brush.color:=NodeColor[nocolor-10];
              ACanvas.brush.style:=bsCross;
             end;
           end;
      end
  else   ACanvas.brush.color:=clblack;


  ACanvas.PolyGon(PtArray);

  ACanvas.brush.color:= OldColor;
  ACanvas.brush.style:=OldStyle ;

  NewFont:=TFont.Create;
  OldFont:=TFont.Create;

  OldFont.Assign(ACanvas.Font);
  logfont:=TTreePage(Parent).FontTaxon;

  NewFont.Handle:=CreateFontIndirect(logfont);

  ACanvas.Font.Assign(NewFont);
  NewFont.free;
  page:= TTreePage(Parent);

  ACanvas.brush.style:=bsclear;

  if TTreePage(Parent).TypePage=vertical then
      ACanvas.TextOut(PtArray[0].x-(page.FBranchWidth div 2),PtArray[0].y-page.FBranchWidth,Text);

  if TTreePage(Parent).TypePage=Horizontal then
      ACanvas.TextOut(PtArray[0].x+page.FBranchWidth,PtArray[0].y-(page.FBranchWidth div 2),Text); //(-

  ACanvas.Font.Assign(OldFont);
  OldFont.free;
 end;
{******************************************************************************
                                TTreePage
*******************************************************************************}

Procedure TTreePage.CreateObjects;
begin
   CreateNodeG;
   if Flag_Legende then CreateLeg;
   inherited CreateObjects;
 end;

Procedure TTreePage.DeleteObjects;
begin
  DeleteNodeG;
  if Flag_Legende then DeleteLeg;
  FPage.ClearListArray(nodelete);
  inherited DeleteObjects;
end;


Procedure TTreePage.CreateCoordObjects(ACanvas:TCanvas);
 begin
  if not Flag_CreateInfograph then CreateInfoGraph(ACanvas);
  DefCoordNodeG;
  Flag_CreateCoordObjects:=true;
  if Flag_Legende then CreateCoordLeg(ACanvas);
 end;

function TTreePage.CalcMaxTextLength(ACanvas:TCanvas):integer;
var
 text:string;
 max,index,len:integer;
begin
  max:=0;
  index:=0;
  text:=FTree.GetTaxName(index);
 while text<>'' do
   begin
   len:=CalcTextwidth(text,FFontTaxon,ACanvas);
   if len>max then max:=len;
   index:=index+1;
   text:=FTree.GetTaxName(index);
   end;
 result:=max + (max div 10);
end;

procedure TTreePage.AddTreeAction( TreeStr :string);
begin
 ListTreeAction.add(TreeStr);
 IndexTreeAction:=ListTreeAction.count;
end;

procedure TTreePage.DeleteTreeAction;
 begin
 ListTreeAction.clear;
 IndexTreeAction:=0;
end;

function TTreePage.GetFirstTreeAction : string;
 begin
  result:='';
  if IndexTreeAction>=1 then
   begin
     IndexTreeAction:=0;
     result:=ListTreeAction[IndexTreeAction];
     ListTreeAction.clear;
   end ;
 end;

function TTreePage.GetPriorTreeAction : string;
 begin
  result:='';
  if IndexTreeAction>=1 then
   begin
     dec(IndexTreeAction);
     result:=ListTreeAction[IndexTreeAction];
   end ;
 end;

function TTreePage.GetNexTreeAction : string;
 begin
  result:='';
  if IndexTreeAction<ListTreeAction.Count then
   begin
     inc(IndexTreeAction);
     result:=ListTreeAction[IndexTreeAction-1];
   end ;
 end;

procedure TTreePage.SaveTreeAction;
var
 strTree :string;
begin
   strTree:=FTree.Transform_L_DND;
   AddTreeAction( StrTree);
end;

constructor TTreePage.CreatePage(AParent: TGraphControl; Atree :TTree);
begin
 inherited create(APArent);

 FTree:=ATree;
 CreateFontLegende;
 CreateFontTaxon;
 FTypePage :=horizontal;
 Flag_Legende:=false;
 Flag_Color:=false;
 
 IndexTreeACtion:=0;
 ListTreeACtion:=TStringList.Create ;
end;

function TTreePage.CalcTextwidth(text:string;logfont:TLogFont;ACanvas:TCanvas):integer;
var
NewFont :TFont;
OldFont :TFont;

begin
 NewFont:=TFont.Create;
 OldFont:=TFont.Create;

 OldFont.Assign(ACanvas.Font);
 NewFont.Handle:=CreateFontIndirect(logfont);

 ACanvas.Font.Assign(NewFont);
 NewFont.free;

 result:=ACanvas.TextWidth(text);

 ACanvas.Font.Assign(OldFont);
 OldFont.free;
end;

function TTreePage.CalcTextHeight(text:string;logfont:TLogFont;ACanvas:TCanvas):integer;
var
NewFont :TFont;
OldFont :TFont;

begin
 NewFont:=TFont.Create;
 OldFont:=TFont.Create;

 OldFont.Assign(ACanvas.Font);
 NewFont.Handle:=CreateFontIndirect(logfont);

 ACanvas.Font.Assign(NewFont);
 NewFont.free;

 result:=ACanvas.TextHeight(text);

 ACanvas.Font.Assign(OldFont);
 OldFont.free;
end;

procedure TTreePage.CreateFontTaxon;
begin
 FFontTaxon.lfHeight := 14;     // jfr modifie octobre 2001
 FFontTaxon.lfWidth :=0;          // Choisie par Windows
 FFontTaxon.lfEscapement :=0;   // Orientation horizontale du texte
 FFontTaxon.lfOrientation  :=0;  // de bas en haut
 FFontTaxon.lfWeight := FW_BOLD;
 FFontTaxon.lfItalic := 0;
 FFontTaxon.lfUnderline := 0;
 FFontTaxon.lfStrikeOut := 0;
 FFontTaxon.lfCharSet := ANSI_CHARSET;
 FFontTaxon.lfOutPrecision := OUT_TT_PRECIS;
 FFontTaxon.lfClipPrecision := CLIP_DEFAULT_PRECIS;
 FFontTaxon.lfQuality := PROOF_QUALITY;
 FFontTaxon.lfPitchAndFamily := VARIABLE_PITCH or FF_MODERN;
 FFontTaxon.lfFaceName := 'Times New Roman';
end;

procedure TTreePageVert.ChangeTree(newTreeStr :string);
begin
  DeleteObjects;      // dtruit les objets graphiques et reinitialise FPage
  TTreeCL(FTree).Change(newTreeStr);
  TTreeCL(FTree).CalcLength;
 if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);

 end;

constructor TTreePageVert.CreatePageVertBoite(AParent: TGraphControl;
                                               AData :TDataSelectCL; Treeboite :TTreeBoite);
begin
 inherited create(APArent);

 FData:=Adata;
 FTree:=TTreeCL.createTreeCLBoite(Treeboite,AData);
 TTreeCL(FTree).CalcLength;

 CreateFontLegende;
 CreateFontTaxon;

 FTypePage :=horizontal;
 Flag_Legende:=false;
 Flag_Color:=false;

 FTypePage :=vertical;
 FSelectCarac:='';
 FTypeEtat:=NEtatMPR;
 FTypeLegende:=texte;

 IndexTreeACtion:=0;
 ListTreeACtion:=TStringList.Create ;

end;
constructor TTreePageVert.CreatePageVertGroup(AParent: TGraphControl;
                                               AData :TDataSelectCL; TreeGroup :TTreeGroup);
begin
 inherited create(APArent);

 FData:=Adata;
 FTree:=TTreeCL.createTreeCLGroup(TreeGroup,AData);
 TTreeCL(FTree).CalcLength;

 CreateFontLegende;
 CreateFontTaxon;

 FTypePage :=horizontal;
 Flag_Legende:=false;
 Flag_Color:=false;

 FTypePage :=vertical;
 FSelectCarac:='';
 FTypeEtat:=NEtatMPR;
 FTypeLegende:=texte;

 IndexTreeACtion:=0;
 ListTreeACtion:=TStringList.Create ;

end;

// jfr modifie le 10/04/00
// "_DND" rajout
constructor TTreePageVert.CreatePageVert(AParent: TGraphControl; AData :TDataSelectCL; _DND :string);
begin
 inherited create(APArent);

 FData:=Adata;
 if _DND='' then FTree:=TTreeCL.createTreeCL(AData)
 else FTree:=TTreeCL.createTreeCLFile(_DND,AData);
 TTreeCL(FTree).CalcLength;

 CreateFontLegende;
 CreateFontTaxon;

 FTypePage :=horizontal;
 Flag_Legende:=false;
 Flag_Color:=false;

 FTypePage :=vertical;
 FSelectCarac:='';
 FTypeEtat:=NEtatMPR;
 FTypeLegende:=texte;

 IndexTreeACtion:=0;
 ListTreeACtion:=TStringList.Create ;

end;

procedure TTreePageVert.CreateFontTaxon;
begin
 FFontTaxon.lfHeight := 16;        // jfr modifie octobre 2001   12 avant
 FFontTaxon.lfWidth :=0;         // jfr modifie octobre 2001   8 avant    // Choisie par Windows
 FFontTaxon.lfEscapement :=900;   // Orientation verticale du texte
 FFontTaxon.lfOrientation  :=0;  // de bas en haut
 FFontTaxon.lfWeight := FW_BOLD;
 FFontTaxon.lfItalic := 0;
 FFontTaxon.lfUnderline := 0;
 FFontTaxon.lfStrikeOut := 0;
 FFontTaxon.lfCharSet := ANSI_CHARSET;
 FFontTaxon.lfOutPrecision := OUT_TT_PRECIS;
 FFontTaxon.lfClipPrecision := CLIP_DEFAULT_PRECIS;
 FFontTaxon.lfQuality := PROOF_QUALITY;
 FFontTaxon.lfPitchAndFamily := VARIABLE_PITCH or FF_MODERN;
 FFontTaxon.lfFaceName := 'Times New Roman';
end;
//******************************************************************************/
procedure TTreePage.CreateCoordLeg(ACanvas:TCanvas);
var
 index,level,width,height:integer;
 nodeG:TGraphNode;
 Leg:TLegende;
 point:TPoint;

 begin
  level:= FPage.RowCount-1; // Les lgendes sont places au dernier niveau de la
                             // page. Les noeuds sont placs  des niveaux correspondants
                             //  ceux qu'ils occupent dans l'arbre.
  index:=0;
  Leg:=FPage.Items[level,index];
  while Leg<>nil  do
   begin
    nodeG:=TGraphNode(Leg.ParentObject);

    point.x:=(nodeG.PtArray[0].x+nodeG.PtArray[3].x) div 2;
    point.y:=(nodeG.PtArray[0].y+nodeG.PtArray[3].y) div 2;

    width:=CalcTextwidth(Leg.Text,FFontLeg,ACanvas);
    height:=CalcTextheight(Leg.Text,FFontLeg,ACanvas);

    Leg.OrgX:=point.x-(width div 2);
    Leg.OrgY:=point.y-(height div 2);

    Leg.EndX:=point.x+(width div 2);
    Leg.EndY:=point.y+(height div 2) ;

    index:=index+1;
    Leg:=FPage.Items[level,index];
    end;
end;




procedure TTreePage.CreateLeg;
 var
 index,nblevel,level:integer;
 node:TNodeBase;
 nodeG:TGraphNode;
 Leg:TLegende;
 dist: string;

 begin
  nblevel:=FTree.Nblevel;

 for level:=1 to nblevel-1 do
  begin
   index:=0;
   node:=FTree.GetNode(level,index);
    while node<>nil  do
     begin
       dist:=FloatToStrF(node.distance,ffFixed,15,2);
       nodeG:=FPage.Items[level,index];
       Leg:=TLegende.create(self);
       Leg.Text:=dist;
       Leg.ParentObject:=nodeG;
       FPage.AddItem(nblevel,Leg);

       index:=index+1;
       node:=FTree.GetNode(level,index);
     end;
   end;
end;

procedure TTreePage.DeleteLeg;
var
Leg:TGraphObject;
Level,index : integer;
begin
  level:= FPage.RowCount-1;
// Les lgendes sont places au dernier niveau de la page. Les noeuds sont placs
//  des niveaux correspondants  ceux qu'ils occupent dans l'arbre.

  index:=0;
  Leg:=FPage.Items[level,index];
  if Leg is TLegende then
  begin
   while Leg<>nil  do
    begin
     Leg.free;
     index:=index+1;
     Leg:=FPage.Items[level,index];
    end;
 FPage.ClearRow(level);   
 FPage.deleteRow(level,toTrim);
  end;
end;

procedure TTreePage.DeleteNodeG;
var
 index,level:integer;
 nodeG:TGraphObject;
begin
for level:=FPage.RowCount-1 downto 0 do
  begin
   index:=0;
   nodeG:=FPage.Items[level,index];
   if (nodeG<>nil )and (nodeG is TGraphNode)  then
   begin
    while nodeG<>nil do
     begin
       nodeG.free;
       index:=index+1;
       nodeG:=FPage.Items[level,index];
     end;
    FPage.ClearRow(level);
    FPage.deleteRow(level,toTrim);
   end;
   end;
end;


procedure TTreePage.CreateNodeG;
var
 index,level:integer;
 node:TNodeBase;
 nodeG:TGraphNode;
 nodeGT:TGraphNodeT;

 begin
  index:=0;
  level:=0;

  node:=FTree.GetNode(level,index);   // Pour le noeud provisoire
  if node<>nil then
  begin
    nodeGT:=TGraphNodeT.create(self);
     nodeGT.AssocObject:=node;
     node.ObjectAssoc:=nodeGT;
     nodeGT.Text:=node.name;
     nodeGT.TypePage:=TypePage;
     nodeGT.TypeTree:=FTree.TypeTree;
     FPage.AddItem(level,nodeGT);
  end;
  
  level:=1;

  node:=FTree.GetNode(level,index);
  while node<>nil  do
   begin
     nodeGT:=TGraphNodeT.create(self);
     nodeGT.AssocObject:=node;
     node.ObjectAssoc:=nodeGT;
     nodeGT.Text:=FTree.GetTaxName(index);
     nodeGT.TypePage:=TypePage;
     nodeGT.TypeTree:=FTree.TypeTree;
          // le noeud est ajout  la couche correspondant  son niveau
     FPage.AddItem(level,nodeGT);
     index:=index+1;
     node:=FTree.GetNode(level,index);
   end;

 for level:=2 to FTree.NbLevel-1 do
  begin
   index:=0;
   node:=FTree.GetNode(level,index);
    while node<>nil do
     begin
       nodeG:=TGraphNode.create(self);
       nodeG.AssocObject:=node;
       nodeG.TypePage:=TypePage;
       nodeG.TypeTree:=FTree.TypeTree;
       node.ObjectAssoc:=nodeG;
       FPage.AddItem(level,nodeG);
       index:=index+1;
       node:=FTree.GetNode(level,index);
     end;
   end;
end;


procedure TTreePage.CreateFontLegende;
begin
 FFontLeg.lfHeight := 12;
 FFontLeg.lfWidth :=8;          // Choisie par Windows
 FFontLeg.lfEscapement :=0;   // Orientation verticale du texte
 FFontLeg.lfOrientation  :=0;  // de bas en haut
 FFontLeg.lfWeight := FW_BOLD;
 FFontLeg.lfItalic := 0;
 FFontLeg.lfUnderline := 0;
 FFontLeg.lfStrikeOut := 0;
 FFontLeg.lfCharSet := ANSI_CHARSET;
 FFontLeg.lfOutPrecision := OUT_TT_PRECIS;
 FFontLeg.lfClipPrecision := CLIP_DEFAULT_PRECIS;
 FFontLeg.lfQuality := PROOF_QUALITY;
 FFontLeg.lfPitchAndFamily := VARIABLE_PITCH or FF_MODERN;
 FFontLeg.lfFaceName := 'Times New Roman';
end;

procedure TTreePage.CreateInfoGraph(ACanvas:TCanvas);
var
TextLength:integer;
begin

TextLength:=CalcMaxTextLength(ACanvas)+10; // fonction qui calcule la hauteur en pixel du plus

FInterNode:=Height div (FTree.NbTaxon);   // NbTAxon est une proprit
FTreeHeight:=Height-FInterNode;
FTopMargin:=FInterNode div 2;
FBottomMargin:=Height-FInterNode div 2;

FRightMargin:=Width-Textlength;
FLeftMargin:=(FInterNode div 2);

FTreeWidth:=FRightMargin-FLeftMargin;

FBranchLength:=FInterNode div 2;   // sans importance ici car ne concerne pas ArbreMC

FScale:=FTreewidth / FTree.SumDistances;
FBranchWidth:=7;
inherited CreateInfoGraph(ACanvas);
end;

procedure TTreePageVert.CreateInfoGraph(ACanvas:TCanvas);
var
TextLength:integer;
begin
TextLength:=CalcMaxTextLength(ACanvas); // fonction qui calcule la hauteur en pixel du plus
FTopMargin:=Textlength;
FTreeHeight:=Height-TextLength;

if FTree.TypeTree=orthogonal then
 begin
    FInterNode:=Width div (FTree.NbTaxon);
    FTreeWidth:=width-FInterNode;
    FTreeHeight:=FTreeHeight-Finternode;
    FLeftMargin:=FInterNode div 2;
  end
  else begin
    FTreeWidth:=2*FTreeHeight;
    if (FTreeWidth>Width)  then
      begin
         FTreeHeight :=Width div 2;
         FTreeWidth:=2*FTreeHeight;
      end;

 {   FLeftMargin:=(Width div 2) - (FTreeWidth div 2);
    FInterNode:=FTreeWidth div (FTree.NbTaxon+1);   // NbTAxon est une proprit
    FLeftMargin:=FLeftMargin+(FInterNode div 2); // L'intervalle suplmentaire est rpartie
  end;                                            // pour moiti  gauche et pour moiti  droite
FBottomMargin:=Height-FInterNode ; //L'intervalle suplmentaire est en totalit en bas
FBranchLength:=FInterNode div 2;
FSCale:=FTreeHeight / FBranchLength;
 }
FInterNode:=FTreeWidth div (FTree.NbTaxon+1);
FLeftMargin:=(Width div 2) - (FTreeWidth div 2);
if FLeftMargin<FInterNode then FLeftMargin:=FInterNode;
end;

FBranchLength:=FInterNode div 2;
FTreeHeight:= FBranchLength * FTree.NbTaxon ;
FBottomMargin:= (FBranchLength * FTree.NbTaxon )+ FTopMargin;
 FSCale:=FTreeHeight / FBranchLength;

FBranchWidth:=10;

Flag_CreateInfoGraph:=true;
Flag_CreateCoordObjects:=false;
// Dans le cas d'un arbreMC la distance d'un noeud est gale  la diffrence
// de niveau entre lui et son pre. La somme des distances est alors gale 
// NbTaxon et donc FScale = FBranchLength;
end;

procedure TTreePageVert.CalcNodeOrgX;
var
 index,level,coord,dif,nbchilds      :integer;
 node,leftnode,rightnode    :TNodebase;
 nodeG,leftnodeG,rightnodeG :TGraphNode;

begin
coord:=FLeftMargin;
index:=0;
level:=1;

node:=FTree.GetNode(level,index);   // Calcul de OrgX pour les noeuds terminaux
while node<>nil do
 begin
  nodeG:=node.ObjectAssoc;
  nodeG.OrgX:=coord; // InterNode=2*BrancheUnit
  coord:=coord+FInterNode;
  index:=index+1;
  node:=FTree.GetNode(level,index);
 end;

for level:=2 to FTree.NbLevel-1 do  // Calcul de OrgX pour les noeuds internes
 begin
  index:=0;
  node:=FTree.GetNode(level,index);
    while node<>nil do
     begin
        leftnode  :=node.Child[0];
        leftnodeG :=leftnode.ObjectAssoc;
        nodeG     :=node.ObjectAssoc;

        if FTree.TypeTree=Diagonal then
         begin
           dif:=node.Level-leftnode.Level;
           nodeG.OrgX:=leftnodeG.OrgX+ (dif*FBranchLength);
         end
        else
         begin
          nbchilds:=node.NbChilds-1;
          rightnode :=node.Child[nbchilds];
          rightnodeG:=rightnode.ObjectAssoc;
          nodeG.OrgX:=leftnodeG.OrgX+ ((rightnodeG.OrgX-leftnodeG.OrgX)div 2);
         end;
     index:=index+1;
     node:=FTree.GetNode(level,index);
    end;
 end;
end;

procedure TTreePageVert.CalcNodeOrgY;
var
 index,level,dif:integer;
 node,perenode:TNodebase;
 nodeG,perenodeG:TGraphNode;
 dist :integer;
begin
for level:=FTree.NbLevel-1 downto 1 do  // Calcul de OrgY pour les noeuds internes
 begin
  index:=0;
  node:=FTree.GetNode(level,index);

    while node<>nil do
     begin
        nodeG    :=node.ObjectAssoc;
        perenode :=node.Parent;
        if perenode<>nil then
          begin
           perenodeG:=perenode.ObjectAssoc;
             if FTree.TypeTree=Diagonal then
               begin
                  dif:=perenode.Level-node.Level;
                  nodeG.OrgY:=perenodeG.OrgY-(dif*FBranchLength);
               end
             else
               begin
               dif:=perenode.Level-node.Level;
               nodeG.OrgY:=perenodeG.OrgY-(dif*FBranchLength);
               //dist:=round(node.distance*FScale);
               //nodeG.OrgY:=perenodeG.OrgY-dist;
              end;
           end
         else
          nodeG.OrgY:=FBottomMargin;
      index:=index+1;
      node:=FTree.GetNode(level,index);
     end;
 end;
end;

procedure TTreePage.CalcNodeOrgX;
var
 index,level:integer;
 node,perenode:TNodebase;
 nodeG,perenodeG:TGraphNode;
begin

for level:=FTree.NbLevel-1 downto 1 do  // Calcul de OrgX pour les noeuds internes
 begin
  index:=0;
  node:=FTree.GetNode(level,index);

    while node<>nil  do
     begin
        nodeG    :=node.ObjectAssoc;
        perenode :=node.Parent;
        if perenode<>nil then
          begin
           perenodeG:=perenode.ObjectAssoc;
           nodeG.OrgX:=perenodeG.OrgX+ round(node.distance*FScale);
          end
        else
          nodeG.OrgX:=FLeftMargin;
     index:=index+1;
     node:=FTree.GetNode(level,index);
     end;
 end;
end;

procedure TTreePage.CalcNodeOrgY;
var
 index,level,coord,nbchilds  :integer;
 node,leftnode,rightnode    :TNodeBase;
 nodeG,leftnodeG,rightnodeG :TGraphNode;

begin
coord:=FTopMargin;
index:=0;
level:=1;

node:=FTree.GetNode(level,index);   // Calcul de OrgY pour les noeuds terminaux
while node<>nil  do
 begin
  nodeG:=node.ObjectAssoc;
  nodeG.OrgY:=coord; // InterNode=2*BrancheUnit
  coord:=coord+FInterNode;
  index:=index+1;
  node:=FTree.GetNode(level,index);
 end;

for level:=2 to FTree.NbLevel-1 do  // Calcul de OrgY pour les noeuds internes
 begin
  index:=0;
  node:=FTree.GetNode(level,index);
    while node<>nil do
     begin
        leftnode  :=node.Child[0];
        leftnodeG :=leftnode.ObjectAssoc;
        nodeG     :=node.ObjectAssoc;

          nbchilds:=node.NbChilds-1;
          rightnode :=node.Child[nbchilds];
          rightnodeG:=rightnode.ObjectAssoc;
          nodeG.OrgY:=leftnodeG.OrgY+ ((rightnodeG.OrgY-leftnodeG.OrgY)div 2);

      index:=index+1;
      node:=FTree.GetNode(level,index);
     end;
 end;
end;

procedure TTreePage.DefCoordNodeG;
 var
 BrWidth,index,level,dif:integer;
 node,perenode:TNodeBase;
 nodeG,perenodeG:TGraphNode;

  begin

  CalcNodeOrgX;
  CalcNodeOrgY;

  BrWidth:=FBranchWidth div 2;

  for level:=1 to FTree.NbLevel-1 do  // Calcul de OrgY pour les noeuds internes
   begin
    index:=0;
    node:=FTree.GetNode(level,index);

    while node<>nil do
     begin
      nodeG:=node.ObjectAssoc;

      nodeG.PtArray[0]:=POINT(nodeG.OrgX,nodeG.OrgY-BrWidth); // Dfinition des coordones
      nodeG.PtArray[1]:=POINT(nodeG.OrgX,nodeG.OrgY);
      nodeG.PtArray[2]:=POINT(nodeG.OrgX,nodeG.OrgY+BrWidth); // des points hauts

      perenode :=node.Parent;
       if perenode<>nil then
        begin
         perenodeG :=perenode.ObjectAssoc;
         dif :=nodeG.OrgX-perenodeG.OrgX;
        end
       else dif:=round(node.distance*FScale);

     nodeG.PtArray[3]:=POINT(nodeG.OrgX-dif,nodeG.OrgY+BrWidth);
     nodeG.PtArray[4]:=POINT(nodeG.OrgX-dif,nodeG.OrgY-BrWidth);

     index:=index+1;
     node:=FTree.GetNode(level,index);
    end;
   end;
 end;

procedure TTreePageVert.DefCoordNodeG;
 begin
  CalcNodeOrgX;
  CalcNodeOrgY;
  NodeTopCoord;
  NodeBottomCoord;
 end;

procedure TTreePageVert.NodeTopCoord;
var
 BrWidth,index,level:integer;
 node:TNodeBase;
 nodeG,nodePro:TGraphNode;
 begin
  BrWidth:=FBranchWidth div 2;

  Node:=FTree.GetNode(0,0);

  if Node<>nil then    // Pour le noeud provisoire
   begin
      nodepro:=node.ObjectAssoc;
      nodepro.PtArray[0]:=POINT(FInterNode -BrWidth,Height-10-FBranchLength); // Dfinition des coordones
      nodepro.PtArray[1]:=POINT( FInterNode,Height-10-FBranchLength);
      nodepro.PtArray[2]:=POINT( FInterNode+BrWidth,Height-10-FBranchLength); // des points hauts
   end;

  level:=1;                           // puis pour les noeuds terminaux
  index:=0;

    node:=FTree.GetNode(level,index);
      while node<>nil  do
      begin
      nodeG:=node.ObjectAssoc;

      nodeG.PtArray[0]:=POINT(nodeG.OrgX-BrWidth,nodeG.OrgY); // Dfinition des coordones
      nodeG.PtArray[1]:=POINT(nodeG.OrgX,nodeG.OrgY);
      nodeG.PtArray[2]:=POINT(nodeG.OrgX+BrWidth,nodeG.OrgY); // des points hauts

      index:=index+1;
      node:=FTree.GetNode(level,index);
    end;

  for level:=2 to FTree.NbLevel-1 do  // les noeuds internes
    begin
      index:=0;
      node:=FTree.GetNode(level,index);
      while node<>nil do
       begin
       nodeG:=node.ObjectAssoc;
       if FTree.TypeTree=Orthogonal then    // Arbre vertical
        begin
         nodeG.PtArray[0]:=POINT(nodeG.OrgX-BrWidth,nodeG.OrgY); // Dfinition des coordones
         nodeG.PtArray[1]:=POINT(nodeG.OrgX,nodeG.OrgY);
         nodeG.PtArray[2]:=POINT(nodeG.OrgX+BrWidth,nodeG.OrgY); // des points hauts
        end
       else                          // Arbre diagonal
        begin
           nodeG.PtArray[0]:=POINT(nodeG.OrgX-BrWidth,nodeG.OrgY); // Dfinition des coordones
           nodeG.PtArray[1]:=POINT(nodeG.OrgX,nodeG.OrgY-BrWidth);
           nodeG.PtArray[2]:=POINT(nodeG.OrgX+BrWidth,nodeG.OrgY);
        end;
      index:=index+1;
      node:=FTree.GetNode(level,index);
    end;
  end;
end;

procedure TTreePageVert.NodeBottomCoord;
var
 BrWidth,index,level,dif:integer;
 node,perenode:TNodeBase;
 nodeG,nodepro, perenodeG:TGraphNode;
 
begin
  BrWidth:=FBranchWidth div 2;
  BrWidth:=FBranchWidth div 2;

  Node:=FTree.GetNode(0,0);

  if Node<>nil then    // Pour le noeud provisoire
   begin
      nodepro:=node.ObjectAssoc;
      nodepro.PtArray[3]:=POINT(FInterNode+BrWidth,Height-10);
      nodepro.PtArray[4]:=POINT(FInterNode-BrWidth,Height-10); // des points bas
   end;

  for level:=1 to FTree.NbLevel-1 do
   begin
    index:=0;
    node:=FTree.GetNode(level,index);

    while node<>nil do
      begin
      nodeG:=node.ObjectAssoc;
      perenode :=node.Parent;

     if FTree.TypeTree=Orthogonal then        // Arbre vertical
       begin
        if perenode<>nil then
         begin
          perenodeG :=perenode.ObjectAssoc;
          dif :=perenodeG.OrgY-nodeG.OrgY;
          nodeG.PtArray[3]:=POINT(nodeG.OrgX+BrWidth,nodeG.OrgY+dif);
          nodeG.PtArray[4]:=POINT(nodeG.OrgX-BrWidth,nodeG.OrgY+dif);
         end
        else
       begin
         dif:=FBranchLength;
         nodeG.PtArray[3]:=POINT(nodeG.OrgX+BrWidth,nodeG.OrgY+dif);
         nodeG.PtArray[4]:=POINT(nodeG.OrgX-BrWidth,nodeG.OrgY+dif);
       end;
        
      end
    else
     begin
      if perenode<>nil then
         begin
          perenodeG :=perenode.ObjectAssoc;
          dif :=perenodeG.OrgY-nodeG.OrgY;
          nodeG.PtArray[3]:=POINT(perenodeG.OrgX+BrWidth,nodeG.OrgY+dif);
          nodeG.PtArray[4]:=POINT(perenodeG.OrgX-BrWidth,nodeG.OrgY+dif);
         end
        else
         begin
         dif:=FBranchLength;
         nodeG.PtArray[3]:=POINT(nodeG.OrgX+dif+BrWidth,nodeG.OrgY+dif);
         nodeG.PtArray[4]:=POINT(nodeG.OrgX+dif-BrWidth,nodeG.OrgY+dif);
          end;

     end;
     // Ceci laisse supposer que les noeuds sont placs dans des couches
     // successives qui correspondent  leur niveau : donc un noeud pre sera
     // plac dans une couche d'un niveau suprieur  celle de ses fils ce qui
     // a deux consquences :
     // - Il est dessin aprs donc il les recouvre pour leur partie commune
     // - il intercepte en premier les clic de souris si celui-ci a lieu dans
     // la partie commune
    index:=index+1;
    node:=FTree.GetNode(level,index);
  end;
end;
end;

procedure TTreePage.TreeSwap(NodeToswap :TGraphNode);
 begin
 SaveTreeAction;
 Ftree.Turn(NodeToSwap.AssocObject);
 ChangeGraphObjects;
end;

procedure TTreePage.TreeRoot(NodeToRoot:TGraphNode);
 begin
  SaveTreeAction;
  FTree.Root(NodeToRoot.AssocObject);
  ChangeGraphObjects;
end;

procedure TTreePageVert.TreeRoot(NodeToRoot:TGraphNode);
begin
   SaveTreeAction;
  FTree.Root(NodeToRoot.AssocObject);
   TTreeCL(FTree).CalcLength;
  // Pour afficher les couleurs correspondant au caractre slectionn
  if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);
  ChangeGraphObjects;
end;

procedure TTreePageVert.ChangeTabCod(newtabcod :TStrListArray);
 begin
 Data.ChangeTabCod(newTabCod);
 TTreeCL(FTree).CalcLength;
 if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);
 ChangeGraphObjects;
 end;

procedure TTreePageVert.ChangeListCarac( AName :string );
 begin
  TTreeCL(FTree).CalcLength;
  ChangeSelectCarac('');
 end;

procedure TTreePageVert.ChangeSelectCarac(AName :string);

begin
 FSelectCarac:=AName;
 if (AName<>'') then Flag_color:=true
 else Flag_color:=false;
 
 TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);
 ChangeGraphObjects;
end;

procedure TTreePageVert.TreeRemoveAndGraftPolytom( NodeToRemove:TGraphNode; OnNodeGraft:TGraphNode);
begin
  SaveTreeAction;
  FTree.Remove(NodeToRemove.AssocObject);
  FTree.GraftPolytom( NodeToRemove.AssocObject, OnNodeGraft.AssocObject);
  TTreeCL(FTree).CalcLength;

  // Pour afficher les couleurs correspondant au caractre slectionn
  if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);

  ChangeGraphObjects;
end;

procedure TTreePageVert.GraftPolytomTaxonPro(NodePro:TGraphNode; OnNode:TGraphNode);
 begin
   DeleteTreeAction;

   FTree.L_RemoveNode( NodePro.AssocObject); // Enleve le noeud du tabLevel (0,0)

  FTree.GraftPolytom(NodePro.AssocObject, TNodeBase(OnNode.AssocObject));//.Parent);
  // modifi le 15/10/99; le greffage sur le parent n'a pas de raison d'tre et
  // provoque un plantage si l'on greffe sur la racine

  TTreeCL(FTree).CalcLength;

  // Pour afficher les couleurs correspondant au caractre slectionn
  if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);

  ChangeInfoGraph;
  ChangeGraphObjects;
end;

procedure TTreePageVert.GraftTaxonPro(NodePro:TGraphNode; OnNode:TGraphNode);
 begin
  DeleteTreeAction;

  FTree.L_RemoveNode( NodePro.AssocObject); // Enleve le noeud du tabLevel (0,0)
  FTree.Graft( NodePro.AssocObject, OnNode.AssocObject);
  TTreeCL(FTree).CalcLength;

  // Pour afficher les couleurs correspondant au caractre slectionn
  if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);

  ChangeInfoGraph;
  ChangeGraphObjects;
end;
// Fonction qui ajoute  la page un taxon provisoire qui n'est pas comptabilis
// dans l'arbre ni dans Fdata.List(Max)Row
procedure TTreePageVert.AddTaxonPro(AName : string);
var
node:TNodeCL;
nodeGT :TGraphNodeT;
begin

 node:=TNodeCL.create;
 node.Name:=AName;

 FTree.AddNode(0,node);

 nodeGT:=TGraphNodeT.create(self);
 nodeGT.AssocObject:=node;
 node.ObjectAssoc:=nodeGT;
 nodeGT.Text:=node.Name;
 nodeGT.TypePage:=TypePage;
 nodeGT.TypeTree:=FTree.TypeTree;
 FPage.AddItem(0,nodeGT);

 // Pour afficher les couleurs correspondant au caractre slectionn
  if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);

 ChangeCoordGraphObjects;
end;

function TTreePageVert.NameofFlagTaxonPro :string;
var
ANode :TNodeBase;
begin
 ANode:=FTree.GetNode(0,0);
 if ANode<>nil then result:=ANode.Name
               else result:='';
end;

procedure TTreePageVert.AddTaxonToDataList(num :integer);
 begin
 Data.ListMaxRow.add(num);
 Data.ListRow.add(num);
 end;

procedure TTreePageVert.TreeTaxonRemove( AName :string);
var
index : integer;
begin
 DeleteTreeAction;
 Data.TaxonRemove(AName);
 FTree.Remove(Ftree.GetTaxNode(ANAme));
 TTreeCL(FTree).CalcLength;

  // Pour afficher les couleurs correspondant au caractre slectionn
  if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);
  ChangeInfoGraph;
  ChangeGraphObjects;
end;

procedure TTreePageVert.TreeRemoveAndGraft( NodeToRemove:TGraphNode; OnNodeGraft:TGraphNode);
begin
  SaveTreeAction;
  FTree.Remove(NodeToRemove.AssocObject);
  FTree.Graft( NodeToRemove.AssocObject, OnNodeGraft.AssocObject);
  TTreeCL(FTree).CalcLength;

  // Pour afficher les couleurs correspondant au caractre slectionn
  if FSelectCarac<>'' then TTreeCL(FTree).DefineState(FSelectCarac,FTypeEtat);

  ChangeGraphObjects;
end;

procedure TTreePageVert.CreateLeg;
 var
 index,nblevel,level:integer;
 node:TNodeBase;
 nodeG:TGraphNode;
 Leg:TLegende;
 Etat :TListetat;

 begin
  nblevel:=FTree.Nblevel;

 for level:=1 to nblevel-1 do
  begin
   index:=0;
   node:=FTree.GetNode(level,index);
    while node<>nil  do
     begin
       nodeG:=FPage.Items[level,index];
       Leg:=TLegende.create(self);

      case FTypeEtat  of
          NEtatDown : Etat:= TNodeCL(node).EtatDown;
          NEtatUp :  Etat:= TNodeCL(node).EtatUP;
          NEtatMPR : Etat:= TNodeCL(node).EtatMPR ;
      end;
      if etat.List.Count=0 then Leg.Text:=''
      else begin
           if FTypeLegende=codeL then Leg.Text:=TNodeCL(node).EtatToStr(etat)
           else Leg.Text:= Data.TransformToListStr(Etat.List, FSelectCarac);
           end;
           
       Leg.ParentObject:=nodeG;
       FPage.AddItem(nblevel,Leg);

       index:=index+1;
       node:=FTree.GetNode(level,index);
     end;
   end;
end;

// jfr modifie le 10/04/00
// fonction rajoute
function TTreePageVert.CreateListCarac(ANodeG:TGraphNode): TStrListArray;
var
  AListArray :TStrListArray;
  NbCaracTot,noRow,i :integer;
  NomCarac , StrEtat : string;
  Etat : TListEtat;
  node,ANode : TNodeCL;
  
  begin
  AlistArray:=TStrListArray.CreateListArray;
  ANode:=ANodeG.AssocObject;

  NbCaracTot:=FData.ListCol.Count;
  noRow:=0;

  for  i:=0 to NbcaracTot-1 do
  begin
    NomCarac:=FData.GetNameOfCol(FData.ListCol,i);
    AListArray.StrItems[noRow,0]:=NomCarac;

    TTreeCL(FTree).DefineState(NomCarac,NEtatMPR);

    node:=TNodeCL(FTree.getNode(ANode.Level,ANode.IndexLevel));
    Etat:=node.EtatMPR;

    if Etat.List.Count=0 then StrEtat:=''
    else StrEtat:=FData.TransformToListStr(Etat.List,NomCarac);

   AListArray.StrItems[noRow,1]:=StrEtat;
   inc(noRow);
  end;
  result:=AlistArray;
 end;
end.
