unit GraphTri;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  group2,GraphObject,CustomGraph2,listarray2;

type
  TGraphTri = class(TGraphControl2)
  private

  FinterGY :integer;    // distance sparant verticalement les groupes
  FinterGX :integer;    // distance sparant horizontalement les groupes

  FcaracX  : integer;
  FCaracY : integer;

  function CreateCoordVertical(ACanvas :TCanvas):integer;
  function CreateCoordHorz(ACanvas :TCanvas):integer;
    { Dclarations prives}
  protected
   Procedure CreateObjects;override;

   procedure CreateInfoGraph(ACanvas:TCanvas); override;
   Procedure CreateCoordObjects(ACanvas:TCanvas);override;
    { Dclarations protges}
  public
    { Dclarations publiques}
  constructor Create(AOwner: TComponent); override;

  published

  property  interGY :integer read  FinterGY write FinterGY  ;
  property  interGX :integer read  FinterGX write FinterGX ;

  property  caracX  : integer read FcaracX write  FcaracX ;
  property  CaracY : integer  read FCaracY write  FCaracY ;

  end;
//*************************************************************************/
TGraphButton =class (TGraphObject)
  private

 FEndX : integer;
 FEndY : integer;
 FText : string;

 public

 constructor CreateObject(AParent:TCustomControl);override;

 property  Text:string read FText write FText;

 property  EndX : integer read FEndX write FEndX;
 property  EndY : integer read FEndY write FEndY;

 procedure Draw(ACanvas:TCanvas);override;
end;

//*************************************************************************/
TGraphGroup=class (TGraphObject)
  private

 FEndX : integer;
 FEndY : integer;
 FObject :TObject;

 public

 constructor CreateObject(AParent:TCustomControl);override;
 property AObject :TObject read FObject write FObject;

 property  EndX : integer read FEndX write FEndX;
 property  EndY : integer read FEndY write FEndY;

 procedure Draw(ACanvas:TCanvas);override;
end;

//*************************************************************************/
function BoxCoordHeight (Atext :string; ACanvas:TCanvas; Top :TPoint;intY :integer):integer;
function BoxCoordwidth (Atext :string; ACanvas:TCanvas; Top :TPoint; intX:integer):integer;
function BoxHeight(list :TStringList; ACanvas:TCanvas; intY :integer):integer;
function Boxwidth(list :TStringList; ACanvas:TCanvas; intX :integer):integer;

//*************************************************************************/
procedure Register;

//*************************************************************************/
//*************************************************************************/

implementation

function BoxHeight(list :TStringList; ACanvas:TCanvas; intY :integer):integer;
var
 index, heightText :integer;
 begin
   result:=0;
   for index:=0 to list.count-1 do
     begin
       heightText:=ACanvas.Textheight(list[index]);
       result:=result+heightText+intY;
    end;
 end;

function Boxwidth(list :TStringList; ACanvas:TCanvas; intX :integer):integer;
var
 index, max:integer;
 begin
   result:=0;
   max:=0;
   for index:=0 to list.count-1 do
    if  ACanvas.TextWidth(list[index]) >max then max:=ACanvas.TextWidth(list[index]);
   result:=max+intX;
 end;

function BoxCoordwidth (Atext :string; ACanvas:TCanvas; Top :TPoint; intX:integer):integer;
var
widthText  :integer;
 begin
   widthText:=ACanvas.TextWidth(Atext);
  result:=Top.X+widthText+intX;
end;

function BoxCoordHeight (Atext :string; ACanvas:TCanvas; Top :TPoint;intY :integer):integer;
var
heightText  :integer;

 begin
   heightText:=ACanvas.Textheight(AText);
  result:=Top.Y+ heightText+intY;
end;
//*************************************************************************/

// Affiche un texte centr tant en hauteur qu'en largeur
// retourne la valeur de top.y augment de la hauteur du texte et de la marge haute (intY)

function BoxDraw(Atext :string; ACanvas:TCanvas; IsRect :boolean;
                  Top :TPoint; EndX,intY :integer):integer;
var
widthText, heightText, width, height,OrgXText,OrgYText :integer;
Bottom:TPoint;

 begin
   widthText:=ACanvas.TextWidth(Atext);
   heightText:=ACanvas.Textheight(Atext);

   Bottom.X:=EndX;
   Bottom.Y:=Top.Y+heightText+ intY ;

   width:=Bottom.X-Top.X+1;
   height:=Bottom.Y-Top.Y+1;

  OrgXText:=Top.X+(width-widthText) div 2;
  OrgYText:=Top.Y+(height-heightText) div 2;

  if IsRect=true then  ACanvas.Rectangle(Top.X-1,Top.Y-1,Bottom.X+2,Bottom.Y+2);

  ACanvas.TextOut(OrgXText,OrgYText-1,AText);

  Result :=Bottom.Y;
end;
//******************************************************************************/
constructor TGraphTri.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
    FinterGY :=10 ;    // distance sparant verticalement les groupes
    FinterGX :=30 ;    // distance sparant horizontalement les groupes
    FcaracX  :=2  ;
    FCaracY :=1  ;
 end;   
//******************************************************************************/
Procedure TGraphTri.CreateCoordObjects(ACanvas :TCanvas);
 begin
ActivePage.Height := ActivePage.TopMargin  + createCoordVertical(ACanvas);
 ActivePage.WIdth  := ActivePage.LeftMargin + createCoordHorz(ACanvas);
  inherited CreateCoordObjects(ACanvas);      
 end;
//******************************************************************************/
function TGraphTri.CreateCoordHorz(ACanvas :TCanvas):integer;
var
 lastRow,col,row,max,GWidth: integer;
 graphbutton :TGraphButton;
 graphGroup : TGraphGroup;
 group :TGroup;
 Pt:TPoint;

 begin
 Pt.x:=ActivePage.LeftMargin;

  graphGroup :=TGraphGroup(ActivePage.Items[0,0]);
  graphGroup.OrgX:=Pt.x;

  group:=TGroup(GraphGroup.ObjectAssoc);
  Pt.x:=Pt.x+BoxWidth(group.ListItems,ACanvas,FcaracX);
  graphGroup.EndX:=Pt.x;
  Pt.x:=Pt.x+FintergX;

 for row:=1 to ActivePage.RowCount-1 do
  begin
       max:=0;
       graphbutton :=TGraphButton(ActivePage.Items[Row,0]);
       graphbutton.OrgX:=Pt.x;
       GWidth:=  Acanvas.TextWidth(graphbutton.Text)+FCaracX;
       if GWidth > max then max:=GWidth;

     for col:=1 to ActivePage.ColCount[Row]-1 do
       begin
        graphGroup :=TGraphGroup(ActivePage.Items[Row,col]);
        group:=TGroup(GraphGroup.ObjectAssoc);
        GWidth:= BoxWidth(group.ListItems,ACanvas,FcaracX);
        if GWidth > max then max:=GWidth;
        graphGroup.OrgX:=Pt.x;
       end;
       // On calcule la largeur des groupes en prenant le plus grand des groupes et du bouton
       graphbutton :=TGraphButton(ActivePage.Items[Row,0]);
       graphbutton.EndX:=Pt.x+max;
       for col:=1 to ActivePage.ColCount[Row]-1 do
       begin
         graphGroup :=TGraphGroup(ActivePage.Items[Row,col]);
         graphGroup.EndX:=Pt.x+max ;
       end;
       Pt.x:=Pt.x+max+FintergX;
  end;
  result:=Pt.x+10;
end;

function TGraphTri.CreateCoordVertical(ACanvas :TCanvas):integer;
var
 lastRow,col,row: integer;
 graphbutton :TGraphButton;
 graphGroup,graphGroupGhild : TGraphGroup;
 group,groupchild :TGroup;
 Pt:TPoint;

 begin
 Pt.y:=ActivePage.TopMargin;

 lastRow:=ActivePage.RowCount-1;
  // On fixe les coordonnes verticales du bouton de la dernire colonne
  if lastRow = 0 then
  begin
    Pt.y:=Pt.y+intergY;
     graphGroup :=TGraphGroup(ActivePage.Items[0,0]);
     graphGroup.OrgY:=Pt.y;
     group:=TGroup(GraphGroup.ObjectAssoc);
     Pt.y:=Pt.y+ BoxHeight( group.ListItems,ACanvas,FcaracY)+intergY;
  end
  else
   begin
    graphbutton :=TGraphButton(ActivePage.Items[lastRow,0]);
    graphbutton.OrgY:=ActivePage.TopMargin;
    Pt.y:=BoxCoordHeight(graphbutton.FText,ACanvas,Pt,FcaracY)+intergY;
    // On fixe les coordonnes verticales des groupes de la dernire colonne
   for col:=1 to ACtivePage.ColCount[lastRow]-1 do
    begin
     graphGroup :=TGraphGroup(ActivePage.Items[lastRow,col]);
     graphGroup.OrgY:=Pt.y;
     group:=TGroup(GraphGroup.ObjectAssoc);
     Pt.y:=BoxCoordHeight(group.Caption,ACanvas,Pt,FcaracY)+intergY;
     Pt.y:=Pt.y+ BoxHeight( group.ListItems,ACanvas,FcaracY)+intergY;
   end;
  end;
 result:=Pt.y;  
 // On fixe les coordonnes verticales des groupes des autres colonnes en alignant
 // chaque groupe sur le haut de son premier fils de la colonne suivante
 for row:=lastRow-1 downto 0 do
   begin
    if row > 0 then  // pas de bouton pour le premier groupe
     begin
       graphbutton :=TGraphButton(ActivePage.Items[Row,0]);
       graphbutton.OrgY:=ActivePage.TopMargin;
      for col:=1 to ActivePage.ColCount[Row]-1 do
       begin
       graphGroup :=TGraphGroup(ActivePage.Items[Row,col]);
       group:=TGroup(GraphGroup.ObjectAssoc);

       groupChild:=group.child[0];
       graphGroupGhild:= TGraphGroup( groupchild.AObject);

       graphGroup.OrgY:=graphGroupGhild.OrgY;
       end;
      end
      else
        begin
           graphGroup :=TGraphGroup(ActivePage.Items[0,0]);
           group:=TGroup(GraphGroup.ObjectAssoc);
           groupChild:=group.child[0];
           graphGroupGhild:= TGraphGroup( groupchild.AObject);
           graphGroup.OrgY:=graphGroupGhild.OrgY;
        end ;
    end;
 end;


Procedure TGraphTri.CreateObjects;
var
 row, col :integer;

 graphbutton :TGraphButton;
 graphGroup : TGraphGroup;
 group :TGroup;

begin
  group:=TGroup(Model.Items[0,0]); // groupe initial : caption='';

 graphGroup := TGraphGroup.CreateObject(self);
 graphGroup.ObjectAssoc:=group;
 group.AObject:=graphGroup;

 ActivePage.Items[0,0]:=graphGroup;

 for row:=1 to Model.RowCount-1 do
  begin
    graphbutton :=TGraphButton.CreateObject(self);
    graphbutton.Text:=TTreeGroup(Model).SortItem[row];
    ActivePage.Items[row,0]:=graphbutton;

   for col:=0 to Model.ColCount[row]-1 do
    begin
     group:=TGroup(Model.Items[row,col]);

      graphGroup := TGraphGroup.CreateObject(self);
      graphGroup.ObjectAssoc:=group;
      group.AObject:=graphGroup;
      
      ActivePage.Items[row,col+1]:=graphGroup; // +1 pour tznir compte du button
    end;
  end;
 inherited CreateObjects;  
end;

//*************************************************************************/
procedure TGraphTri.CreateInfoGraph(ACanvas:TCanvas);
begin
 ActivePage.TopMargin:=Acanvas.TextHeight('ESSAI')* 2;
 ActivePage.LeftMargin:=ACanvas.TextWidth('E')*2;

 inherited CreateInfoGraph(ACanvas);
end;

//*************************************************************************/
constructor TGraphButton.CreateObject(AParent:TCustomControl);
 begin
  inherited CreateObject(AParent);
  FText:='';
  end;

//*************************************************************************/
constructor TGraphGroup.CreateObject(AParent:TCustomControl);
 begin
  inherited CreateObject(AParent);
  FObject:=nil;
 end;

//*************************************************************************/
procedure TGraphGroup.draw(ACanvas:TCanvas);
var
 OldColor: TColor ;
 OldStyle: TBrushStyle;
 ListText:TStringList;
 group, groupParent: TGroup;
 groupGParent:TgraphGroup;

 Pt1 :TPoint;
 index ,carX, carY,bottom, diff:integer;
 x1,x2,y1,y2:integer;

begin
group:=TGroup(FObjectAssoc);
ListText:=group.ListItems;

carX:=TgraphTri(Parent).CaracX;
carY:=TgraphTri(Parent).caracY;

Pt1.x:=OrgX;
Pt1.y:=OrgY;
// ACanvas.Rectangle(OrgX-1,OrgY-1,EndX+2,EndY+2);

OldColor:= ACanvas.brush.color;
OldStyle:= ACanvas.brush.style;

ACanvas.brush.style:=bssolid;
ACanvas.brush.Color:=clLtgray;
// Les coordonnes globales du groupe ont t calcules dans createcoordobjects

EndY:= OrgY+ BoxHeight(ListText,ACanvas,carY);

if group.Caption<>'' then
begin
 bottom:= BoxCoordHeight(group.Caption,ACanvas,Pt1,carY);
 ACanvas.brush.Color:=clLtgray;
 ACanvas.Rectangle(OrgX-1,OrgY-1,EndX+2,bottom);
 Pt1.y:=BoxDraw(group.Caption,ACanvas,false,Pt1,EndX,carY)+1;
end
else bottom:=OrgY-1;

diff:=bottom-OrgY+1;

ACanvas.brush.Color:=clwhite;

ACanvas.Rectangle(OrgX-1,bottom,EndX+2,EndY+2+diff);


for index:=0 to ListText.Count-1 do
    Pt1.y:=BoxDraw(ListText[index],ACanvas,false,Pt1,EndX,carY);

groupParent:=group.Parent;
if groupParent<>nil then
 begin
  groupGParent:=TgraphGroup(groupParent.AObject);
  x1:=groupGParent.EndX+2;
  x2:=OrgX;
  y1:=(groupGParent.EndY - groupGParent.OrgY)div 2 + groupGParent.OrgY ;
  y2:= (EndY -  OrgY)div 2 +  OrgY ;
  with ACanvas do
   begin
    moveTo(x1,y1);
    lineTo ((x1+x2)div 2,y1);
    lineTo ((x1+x2)div 2,y2);
    lineTo(x2,y2);
    end;
 end;
    
 ACanvas.brush.color:= OldColor;
 ACanvas.brush.style:=OldStyle ;

end;

//*************************************************************************/
procedure TGraphButton.draw(ACanvas:TCanvas);
var
 OldColor: TColor ;
OldStyle: TBrushStyle;
Pt :TPoint;
carX,carY,largX :integer;

 begin
  OldColor:= ACanvas.brush.color;
  OldStyle:= ACanvas.brush.style;

  ACanvas.brush.style:=bssolid;
  ACanvas.brush.Color:=clLtGray;

  Pt.x:=OrgX;
  Pt.y:=OrgY;

  carX:=TgraphTri(Parent).CaracX;
  carY:=TgraphTri(Parent).caracY;

  largX:=OrgX+carX+ACanvas.Textwidth(Text);
  BoxDraw(Text,ACanvas,true,Pt,EndX+1,carY);

 ACanvas.brush.color:= OldColor;
 ACanvas.brush.style:=OldStyle ;

 end;


procedure Register;
begin
  RegisterComponents('phylo', [TGraphTri]);
end;

end.
