unit GraphTri3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  group2,GraphObject,CustomGraph2,listarray2,boite;

type

   // C'est une classe quivalente d'un jPanel qui hrite d'une classe de base qui avant de s'afficher procde toujours pareil :
   // - elle cre des objets graphiques (CreateObjects ici pour simplifier)
   // - elle calcule les coordonnes de ses objets graphiques   (CreateCoordObjects)
   // - elle affiche chaque objet graphique en appelant sa fonction "paint"
   
  // Les objets graphiques crs sont des noeuds graphiques qui correspondent aux nodeBoite du modle "treeBoite" auxquels
  // sont ajouts des noeuds graphiques pour les taxons libres
  // la diffrence entre ces deux types de noeuds se traduira par  un affichage diffrent :
  // - les uns entours d'un rectangle et affichant en entte le ou les caractres
  // - les autres n'affichant que la liste des taxons libres
  
  TGraphTri2 = class(TGraphControl2)
  private

       { Dclarations prives}
  protected
  // fonction qui cre les noeuds graphiques  partir des objets du modle (nodeBoite et treeBoite)
  // voir explications plus dtailles ensuite
   Procedure CreateObjects;override;
    // dans ...BoiteG le G signifie graphique
   procedure  calculLargeurNodeBoiteG(nodeBoiteG : TNodeBoiteG ; ACanvas :TCanvas);
   procedure  calculHauteurNodeBoiteG(nodeBoiteG : TNodeBoiteG ; ACanvas :TCanvas);
   // fonction qui part des noeuds (noeud graphique) de niveau 1 puis remonte vers la racine en calculant
   // pour chaque noeud d'abord leur hauteur puis leur largeur
   procedure  CreateLargHautBoite(ACanvas :TCanvas);
   // fait la mme chose mais pour les coordonnes du coin suprieur gauche de chaque noeud graphique
   procedure  CreateOrigineBoite(ACanvas :TCanvas) ;
   procedure  CalcNodeOrgX(anodeg : TNodeboiteG);
   procedure  CalcNodeOrgY(anodeg : TNodeboiteG);

   //intert spcifique delphi
   Procedure  placer_NodeG_sur_ActivePage(nodeg :TNodeBoiteG)  ;
   // intert spcifique delphi
   procedure CreateInfoGraph(ACanvas:TCanvas); override;        // fonctions redfinies hrites de TGraphControl2   qui servent  afficher des objets graphiques

   Procedure CreateCoordObjects(ACanvas:TCanvas);override;      // appelle CreateLargHautBoite puis  CreateOrigineBoite
    { Dclarations protges}
  public

  treeBoite : TTreeBoite;
  compteurcol : integer ;
  Esp_hz :integer ;
  Esp_vt : integer ;

  constructor Create(AOwner: TComponent); override;

end;

//*************************************************************************/
function BoxCoordHeight (Atext :string; ACanvas:TCanvas; Top :TPoint;intY :integer):integer;
function BoxCoordwidth (Atext :string; ACanvas:TCanvas; Top :TPoint; intX:integer):integer;
function BoxHeight(list :TStringList; ACanvas:TCanvas; intY :integer):integer;
function Boxwidth(list :TStringList; ACanvas:TCanvas; intX :integer):integer;

//*************************************************************************/
procedure Register;

//*************************************************************************/
//*************************************************************************/

implementation

function BoxHeight(list :TStringList; ACanvas:TCanvas; intY :integer):integer;
var
 index, heightText :integer;
 begin
   result:=0;
   if (list <> nil) then
   begin
    for index:=0 to list.count-1 do                               
     begin
       if (list[index] <> '') then
        begin
         heightText:=ACanvas.Textheight(list[index]);
        // rajout pour des raisons esthtiques : le texte finissait par sortir quand trop de taxons
        result:=result+heightText+2;
         //  result:=result+heightText ;
        end;
    end;
    end;
     if (result <> 0) then  result:=result+intY;
 end;

function Boxwidth(list :TStringList; ACanvas:TCanvas; intX :integer):integer;
var
 index, max:integer;
 begin
   result:=0;
   max:=0;
   // jfr modifie le 07/07 pour tenir compte des caractres en gras
   ACanvas.Font.Style := [fsBold];
   for index:=0 to list.count-1 do
    begin
     if (list[index] <> '') then
        begin
          if  ACanvas.TextWidth(list[index]) >max then max:=ACanvas.TextWidth(list[index]);
        end;
    end;
  if (max <> 0) then result:=max+intX ;
    ACanvas.Font.Style := [];
 end;

function BoxCoordwidth (Atext :string; ACanvas:TCanvas; Top :TPoint; intX:integer):integer;
var
widthText  :integer;
 begin
   widthText:=ACanvas.TextWidth(Atext);
   result:=Top.X+widthText+intX;

end;

function BoxCoordHeight (Atext :string; ACanvas:TCanvas; Top :TPoint;intY :integer):integer;
var
heightText  :integer;

 begin
   heightText:=ACanvas.Textheight(AText);
  result:=Top.Y+ heightText+intY;
end;
//*************************************************************************/

// Affiche un texte centr tant en hauteur qu'en largeur
// retourne la valeur de top.y augment de la hauteur du texte et de la marge haute (intY)

function BoxDraw(Atext :string; ACanvas:TCanvas; IsRect :boolean;
                  Top :TPoint; EndX,intY :integer):integer;
var
widthText, heightText, width, height,OrgXText,OrgYText :integer;
Bottom:TPoint;

 begin
   widthText:=ACanvas.TextWidth(Atext);
   heightText:=ACanvas.Textheight(Atext);

   Bottom.X:=EndX;
   Bottom.Y:=Top.Y+heightText+ intY ;

   width:=Bottom.X-Top.X+1;
   height:=Bottom.Y-Top.Y+1;

  OrgXText:=Top.X+(width-widthText) div 2;
  OrgYText:=Top.Y+(height-heightText) div 2;

  if IsRect=true then  ACanvas.Rectangle(Top.X-1,Top.Y-1,Bottom.X+2,Bottom.Y+2);

  ACanvas.TextOut(OrgXText,OrgYText-1,AText);

  Result :=Bottom.Y;
end;
//******************************************************************************/
constructor TGraphTri2.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
    Esp_vt :=10 ;    // distance sparant verticalement les groupes
    // Modifi par jfr le 25-06-07 : avant la valeur tait de 30
    Esp_hz :=10 ;    // distance sparant horizontalement les groupes
    //jfr modifie le 07/07
    ActivePage.TopMargin := 30;
    ActivePage.LeftMargin:=30;
   treeBoite:=TTreeBoite.create ;

 end;
//******************************************************************************/
Procedure TGraphTri2.CreateCoordObjects(ACanvas :TCanvas);
 begin
   CreateLargHautBoite(ACanvas);
   CreateOrigineBoite(ACanvas);

 ActivePage.Height := ActivePage.TopMargin  + treeBoite.root.nodeAssocG.haut;
 ActivePage.WIdth  := ActivePage.LeftMargin + treeBoite.root.nodeAssocG.larg;

  inherited CreateCoordObjects(ACanvas);

 end;

//******************************************************************************/
 procedure TGraphTri2.calculHauteurNodeBoiteG(nodeBoiteG : TNodeBoiteG ; ACanvas :TCanvas);
 var
 ret1,ret2, i,max :integer;
 nodeBoiteGF : TNodeBoiteG ;
 begin
   if (nodeBoiteG.niveauG=1) then
   begin
     ret1 := boxHeight(nodeBoiteG.caracteresG,acanvas,Esp_vt);
     ret2 := boxHeight(nodeBoiteG.taxonsG,acanvas,Esp_vt);
      //nodeBoiteG.haut := ret1+ret2+(2*Esp_vt);
     nodeBoiteG.haut := ret1+ret2 ;
    end
   else begin
       max:=0;
         for i:=0 to nodeboiteg.nodechildsG.Count-1 do
           begin
             nodeboitegf := nodeboiteg.nodechildsG.items[i];
             if (nodeboitegf.haut > max) then max:=nodeboitegf.haut;
           end;
        nodeBoiteG.haut :=max+(2*esp_vt)+boxHeight(nodeBoiteG.caracteresG,acanvas,Esp_vt);
        end;
 end;
//******************************************************************************/
 procedure TGraphTri2.calculLargeurNodeBoiteG(nodeBoiteG : TNodeBoiteG ; ACanvas :TCanvas);
 var
 ret1,ret2, i,max :integer;
 nodeBoiteGF : TNodeBoiteG ;
 begin
   if (nodeBoiteG.niveauG=1) then
   begin
     // ret1 := boxWidth(nodeBoiteG.caracteresG,acanvas,Esp_hz);
     // ret2 := boxWidth(nodeBoiteG.taxonsG,acanvas,Esp_hz);

     ret1 := boxWidth(nodeBoiteG.caracteresG,acanvas,1);
    if (nodeBoiteG.taxonsG <> nil) then  ret2 := boxWidth(nodeBoiteG.taxonsG,acanvas,1)
     else  ret2:=0 ;
     if (ret1>ret2) then nodeBoiteG.larg := ret1+(2*Esp_hz)
     else  nodeBoiteG.larg := ret2+(2*Esp_hz);
    end
   else begin
       max:=0;
       ret1 := boxWidth(nodeBoiteG.caracteresG,acanvas,1);
         for i:=0 to nodeboiteg.nodechildsG.Count-1 do
           begin
             nodeboitegf := nodeboiteg.nodechildsG.items[i];
              max := max+ nodeBoiteGf.larg + (2*esp_hz);
              // jfr modifie 07/07 
              if (max < ret1) then max:=ret1;
           end;
         nodeboiteg.larg:= max - esp_hz ;
        end;
 end;
//******************************************************************************/
procedure TGraphTri2.CreateLargHautBoite(ACanvas :TCanvas);
var
  i,j,nb: integer;
  Pt:TPoint;
  liste :Tlist ;
  nodeBoiteG :TNodeBoiteG ;
 begin
  liste:=TList.Create;
  nb := treeBoite.getNbNiveaux();

  for i:=1 to nb do                    // pour chaque niveau en commenant par le niveau 1
   begin
    liste.Clear;
    treeBoite.creerListeNodeLevel (i , liste)  ;    // on cre la liste de tous les noeux qui y sont
     for j:=0 to liste.Count-1 do
      begin
        nodeBoiteG := TNodeBoiteG(liste.Items[j]);
        if nodeBoiteG<>nil then
         begin
           calculHauteurNodeBoiteG(nodeBoiteG, ACanvas);
           calculLargeurNodeBoiteG(nodeBoiteG, ACanvas);
         end ;
      end;
  end;
  liste.Free;
end;
//******************************************************************************/
procedure TGraphTri2.CalcNodeOrgX(anodeG : TNodeboiteG);
 var
   i : integer ;
   nodefg : TNodeboiteG ;
 begin
      if (anodeG.nodeParentG = nil) then anodeG.OrgX :=ActivePage.LeftMargin
      else if (anodeG.getIndex()=0)
        then  anodeG.OrgX := anodeG.nodeParentG.OrgX+esp_hz
      else if (anodeG.getfrereGaucheG()<> nil)
         then anodeG.OrgX := anodeG.getfrereGaucheG().orgx+ anodeG.getfrereGaucheG().larg  + esp_hz;

        for   i:=0 to  anodeG.nodeChildsG.count-1 do
         begin
          nodefg :=anodeG.nodechildsG.items[i] ;
          CalcNodeOrgX(nodefg);
         end;
  end;

procedure TGraphTri2.CalcNodeOrgY(anodeg : TNodeboiteG);
 var
   i : integer ;
   nodefg : TNodeboiteG ;
 begin
       if (anodeG.nodeParentG = nil) then anodeG.OrgY :=ActivePage.TopMargin
      else
        begin
         // modifi par jfr le 25-06-07 : suppression d'un affichage spcifique des taxons libres qui donnait des choses zarbies
         // pour l'affichage des taxons libres
       {  if (anodeG.caracteresG <> nil) and (anodeG.caracteresG[0]='')
          then  anodeG.OrgY := anodeG.nodeParentG.OrgY+ (( anodeG.nodeParentG.haut- anodeG.haut )div 2)
         else     }

         anodeG.OrgY := anodeG.nodeParentG.OrgY+esp_vt+boxHeight(anodeG.nodeParentG.caracteresG,self.Canvas,Esp_vt); ;
        end ;
      for   i:=0 to  anodeG.nodeChildsG.count-1 do
         begin
          nodefg :=anodeG.nodechildsG.items[i] ;
          CalcNodeOrgY(nodefg);
         end;
  end;

procedure TGraphTri2.CreateOrigineBoite(ACanvas :TCanvas) ;
 begin
   CalcNodeOrgX(treeBoite.root.NodeAssocG);
   CalcNodeOrgY(treeBoite.root.NodeAssocG);
 end;

Procedure TGraphTri2.placer_NodeG_sur_ActivePage(nodeg :TNodeBoiteG) ;
 var
 i:integer;
 nodefg :TNodeBoiteG ;
begin
  ActivePage.Items[0,compteurcol]:=nodeG;
  compteurcol:=compteurcol+1 ;

  for   i:=0 to  nodeG.nodeChildsG.count-1 do
         begin
          nodefg :=nodeG.nodechildsG.items[i] ;
          placer_NodeG_sur_ActivePage(nodefg) ;
         end;
end;

// fonction qui cre les objets graphiques calqus sur les objets du modle (nodeBoite et treeBoite)
Procedure TGraphTri2.CreateObjects;
begin
  treeBoite.DeleteNodeG();
  treeBoite.DeleteTaxonsLibres();

   // fonction qui pour chaque "boite" (noeud) de l'arborescence dtermine les taxons libres c.a.d
   // ceux qui ne sont pas dans une boite fille
   treeBoite.CreerTaxonsLibres();

   // les noeuds graphiques sont crs : pour chaque nodeBoite un noeud graphique est cr
   // plus un noeud graphique correspondant aux taxons libres
   treeBoite.creerNodeG(self);
   compteurcol:=0;
    // intert spcifique delphi
   placer_NodeG_sur_ActivePage(treeboite.root.nodeAssocG);

   // fait appel  une serie de fonctions rcursives complexes  ( traduire telles quelles)
   // qui attribuent  chaque noeud graphique un niveau (utilis ensuite pour l'affichage)
   // le principe est simple : un noeud terminal (c.a.d un noeud qui n'a pas d'enfant) a un niveau=1
   // sinon un noeud a un niveau gal  la somme des niveaux de ses noeuds fils
   treeBoite.definirNiveauxG();

  // intert spcifique delphi
 inherited CreateObjects;
end;

//*************************************************************************/
procedure TGraphTri2.CreateInfoGraph(ACanvas:TCanvas);
begin
 ActivePage.TopMargin:=Acanvas.TextHeight('ESSAI')* 2;
 ActivePage.LeftMargin:=ACanvas.TextWidth('E')*2;

 inherited CreateInfoGraph(ACanvas);
end;



procedure Register;
begin
  RegisterComponents('phylo', [TGraphTri2]);
end;

end.
