unit node;

interface
 
uses
  SysUtils, Classes , ListEtat,typedef;

type


TNodebase =class(TObject)
  private

 FName :string ;
 FLevel :integer  ;     // 0 par defaut
 FVerticalLevel:integer;
 FIndexLevel :integer;
 FParentLevel :integer;
 FParentIndexLevel:integer;
 FSens : TypeSens ;           // 0 gauche, 1 intermediaire, 2 droit
 FDistance: double;
 FDistanceReel :double ;
 FParent : TNodebase ;
 FMissing : boolean;




 protected

 
 function GetChild (index:integer ): TNodebase ; virtual;
 function GetBrother(index:integer ): TNodebase ; virtual;
 function GetNbChilds               : integer    ;  //int GetNbFils(){return NbFils ;}
 function GetNbBrothers              : integer    ;  // int GetNbFrere();

 public
 Childs :TList;
 ObjectAssoc :pointer;
 function GetNoColor(const typeetat:TTypeEtatNode): integer    ; virtual;

 function IsFrere(nodefrere :TNodeBase): boolean;
 function IsDescendant(node :TNodeBase): boolean;
 function IsChild(nodeParent :TNodeBase)  : boolean;   // bool IsFils(TNoeudBase *pere);
 procedure AddChild(nodefils: TNodeBase); virtual; // virtual void AjouteFils( TNoeudBase *fils);
 procedure AddAChild(nodefils: TNodeBase; index:integer); // void AjouteUnFils(TNoeudBase *noeudfils,int place);
 procedure AddParent( nodeParent: TNodeBase); // virtual void AjoutePere(TNoeudBase *);

 function IsCalcLevel:boolean;virtual;   // virtual void CalculNiveau();
 procedure CalcVerticalLevel;virtual ; // virtual void CalculNiveauVertical();

 procedure RemoveChild (nodefils :TNodeBase); virtual; // virtual void EnleveFils(TNoeudBase *fils);
 function  RemoveAChild(nodefils : TNodebase):integer; // int EnleveUnFils(TNoeudBase *fils);
 procedure RemoveTheChild(nodefils :TNodebase); // void EnleveLeFils(TNoeudBase *fils);
 procedure InsertChild(nodefils:TNodeBase; index:integer);
 function SwapChilds : integer;
 procedure InverseSens(sens:TypeSens);
 function IsLChild : boolean; //  int FilsG(){if (Sens==0)return 1;else return 0;}
 function IsRChild :boolean;  //  int FilsD(){if (Sens!=2)return 0;else return 1;}

  constructor create;virtual;
  destructor destroy;override;

  property Name :string read FName write FName;
  property Level :integer read FLevel write FLevel  ;     // 0 par defaut
  property IndexLevel :integer read FIndexLevel write FIndexLevel  ;
  property VerticalLevel :integer read FVerticalLevel write FVerticalLevel ;
  property ParentLevel :integer read FParentLevel write FParentLevel;
  property ParentIndexLevel :integer read FParentIndexLevel write FParentIndexLevel;
  property Sens : TypeSens  read FSens write FSens;           // 0 gauche, 1 intermediaire, 2 droit
  property Distance: double read FDistance write FDistance;
  property DistanceReel :double read FDistanceReel write FDistanceReel;
  property Parent : TNodebase read FParent write FParent;
  property Child[Index: Integer]: TNodeBase read GetChild;
  property Brother[Index: integer] : TNodebase read GetBrother;
  property Missing : boolean read FMissing write FMissing;

  property NbChilds : integer read GetNbChilds  ;
  property NbBrothers :integer read GetNbBrothers;
 end;

TNodeCL = class(TNodeBase)
 public
  EtatDown : TListEtat;
  EtatUp   : TListEtat;
  EtatMPR  : TListEtat;
  typeCarac :integer;     // jfr modifie le 07/07/00 pour simplifier car le typecarac ne devrait pouvoir prendre
                          // que les valeurs 0 (non ordonn), ou 1 (ordonn) avec une valeur suplmentaire -1 ( non dtermin)

  function GetNoColor(const typeetat:TTypeEtatNode) : integer    ; override;

  function EtatToStr(Etat :TListEtat):string;

  constructor create ; override;
  destructor destroy ; override;
 end;

 implementation

 //*************************************************************************/

 constructor TNodebase.create;
  begin
    inherited create;
    FName:='';
    Parent:=nil;
    FLevel:=0;
    FIndexLevel:=0;
    ObjectAssoc:=nil;

    FParentLevel:=0;
    FParentIndexlevel:=0;
    FDistance:=1;
    Childs:=TList.create;
    FSens:=ssLeft;
    FVerticalLevel:=1;
    FMissing:=false;
  end;

destructor TNodeBase.destroy;
begin
  Childs.free;
  inherited destroy;
end;

//*************************************************************************/

 constructor TNodeCL.create;
  begin
    inherited create;

    EtatDown :=TListEtat.create;
    EtatUP   :=TListEtat.create;
    EtatMPR  :=TListEtat.create;
    typecarac:=-1;       // jfr modifie le 07/07/00

  end;
//*****************************************************************************/
destructor TNodeCL.destroy;
 begin
  if(EtatDown<>nil) then EtatDown.free;
  if(EtatUp<>nil) then EtatUp.free;
  if(EtatMPR<>nil) then EtatMPR.free;
  inherited destroy;
 end;
//*****************************************************************************/
function TNodeCL.GetNoColor(const typeetat:TTypeEtatNode): integer ;
var
  no :integer;
begin
  result:=0;
  no:=0;
  case typeetat of
   NEtatDown : begin  if EtatDown.List.Count>1 then  no:=-1;
                     if EtatDown.List.Count=1 then  no:=EtatDown.List.Items[0];
              end;

   NEtatUP : begin if EtatUp.List.Count>1 then  no:=-1;
                 if EtatUp.List.Count=1 then  no:=EtatUp.List.Items[0];
           end;
   NEtatMPR : begin if EtatMPR.List.Count>1
                  then no:=-1;
                  if EtatMPR.List.Count=1 then no:=EtatMPR.List.Items[0];
            end;
  end;
 result:= no;
end;

 function  TNodeCL.EtatToStr(Etat:TListEtat):string;
 begin
  if etat<>nil then result:=Etat.Transforme('/')
  else result:='';
 end;
 //*****************************************************************************/
 function TNodeBase.GetNoColor(const typeetat:TTypeEtatNode): integer  ;
  begin
   result:=0;
  end;
//*****************************************************************************/
 function TNodeBase.GetChild (index:integer ): TNodeBase ;
 begin
   result:=nil;
   if index<Childs.Count then Result:=TNodebase(Childs.Items[index]);
  end;
//*****************************************************************************/
 function TNodeBase.GetBrother(index:integer ): TNodeBase ;
 var
 k:integer;
 node :TNodeBase;
 begin
   result:=nil;
   k:=0;
   if (FParent<>nil) then
     begin
      Node:=FParent.GetChild(k);
       while (node<>nil) and (node<>self) do
       begin
        k:=k+1;
        Node:=FParent.GetChild(k);
       end;
      if index>=k then index:=index+1;
      result:=FParent.GetChild(index);
     end;
  end;
//*****************************************************************************/
 function TNodeBase.GetNbChilds               : integer    ;  //int GetNbFils(){return NbFils ;}
 begin
    result:=Childs.Count;
  end;
//*****************************************************************************/
 function TNodeBase.GetNbBrothers              : integer    ;
 begin
   result:=0;
   if (FParent<>nil) then result:=FParent.GetNbChilds -1;
 end;
//*****************************************************************************/
 function TNodeBase.IsFrere(nodefrere :TNodeBase): boolean;
 begin
 result:=false;
 if(FParent=nodefrere.FParent) then result:=true;
 end;
//*****************************************************************************/
 function TNodeBase.IsDescendant(node :TNodeBase):boolean;
 var
 nodeP : TNodebase;
 begin
 result:=false;
 nodeP:=FParent;
  while(nodeP<>nil) do
  begin
    if (nodeP=node) then
       begin
        result:=true; break;
       end
     else nodeP:=nodeP.FParent;
  end;
 end;
//*****************************************************************************/

function TNodeBase.IsChild(nodeParent :TNodeBase):boolean ;   // bool IsFils(TNoeudBase *pere);
 var
  index:integer;
  nbfils :integer;
  node:TNodebase;
 begin
 result:=false;
 nbfils:= nodeParent.GetNbChilds ;
  for index:=0 to nbfils-1 do
    begin
      node:=FParent.Child[index];
      if FName=node.Name then
       begin result:=true; break; end;
    end;
 end;
//*****************************************************************************/
procedure TNodeBase.AddChild(nodefils: TNodeBase);         // virtual void AjouteFils( TNoeudBase *fils);
var
 index,i :integer;
 node : TNodeBase;
 nbfils :integer;

 begin
  index:=-1;
  nbfils:=Childs.Count;
   for i:=0 to nbfils-1 do
     begin
       node:=Child[i];
	if (node<>nil) then
	  if (nodefils.Sens < node.Sens) // Dans une polytomie un fils est
	     then begin index:=i; break; end; // insr  l'avant derniere position

     end;
  if (index<0) then Childs.Add(nodefils)
  else Childs.Insert(index,nodefils);
end;
//*****************************************************************************/
 procedure TNodeBase.AddAChild(nodefils: TNodeBase; index:integer); // void AjouteUnFils(TNoeudBase *noeudfils,int place);
 var
  i: integer;
 begin
 nodeFils.Parent:=self;
  if index+1 > Childs.Count then for i:=Childs.Count to index do Childs.Add(NIL);
  Childs.Items[index]:=nodefils;
 end;
//*****************************************************************************/
 procedure TNodeBase.AddParent( nodeParent: TNodeBase);
  begin
  FParent:=nodeParent;                      // en temps que fils, au pere.
  FParent.AddChild(self);
 end;
//*****************************************************************************/
 function TNodeBase.IsCalcLevel:boolean;   // virtual void CalculNiveau();
 //Si un des fils a un niveau inconnu le calcul est impossible.
 //Si le noeud n'a pas de fils son niveau est 1;
 var
  node   : TNodeBase;
  i,nbfils  : integer;
 begin
   result:=true;
   FLevel:=0;
   nbfils:=GetNbChilds;
   if nbfils>0 then
    for i:=0 to nbfils-1 do
      begin
        node:=GetChild(i);
         if (node<>nil) then
          begin
           if node.FLevel<> 0 then FLevel:=FLevel+node.FLevel
           else begin result:=false;break; end;
          end;
      end
  else FLevel:=1;
  CalcVerticalLevel;
 end;
//*****************************************************************************/
procedure TNodeBase.CalcVerticalLevel;   // virtual void CalculNiveauVertical();
 var
 node : TNodeBase ;
 nbfils ,i,j,Maxlevel :integer;
 begin
  FVerticalLevel:=0;
  nbfils:=GetNbChilds;

  if (nbfils<=2)then
    for i:=0 to nbfils-1 do
      begin
        node:=GetChild(i);
         if (node<>nil) then
          FVerticalLevel:=FVerticalLevel+node.FVerticalLevel
      end
   else
     begin
       MaxLevel:=0;
         for i:=0 to nbfils-1 do
          begin
            node:=GetChild(i);
            if (node<>nil) then
             if (node.FVerticalLevel>MaxLevel) then MaxLevel:=node.FVerticalLevel;
          end;

	 for j:=1 to MaxLevel do
	  begin
           for i:=0 to nbfils-1 do
             begin
               node:=GetChild(i);
                if (node<>nil) then
                  if (node.FLevel=j)then
                   begin FVerticalLevel:=FVerticalLevel+j;break;end;
             end;
          end;
	if (FVerticalLevel<2) then FVerticalLevel:=2;
   end;
 end;
//*****************************************************************************/
procedure TNodeBase.RemoveChild (nodefils :TNodeBase); // virtual void EnleveFils(TNoeudBase *fils);
 begin
  Childs.Remove(nodefils);
  nodefils.FParent:=nil;
 end;
//*****************************************************************************/
function  TNodeBase.RemoveAChild(nodefils : TNodebase):integer; // int EnleveUnFils(TNoeudBase *fils);
 var
 index:integer;
 begin
  index:= Childs.IndexOf(nodefils);
  if index<> -1 then Childs.Items[index]:=nil;
  result:=index;
 end;
//*****************************************************************************/
procedure TNodeBase.RemoveTheChild(nodefils :TNodebase); // void EnleveLeFils(TNoeudBase *fils);
 begin
  Childs.Remove(nodefils);
 end;
//*****************************************************************************/ 
procedure TNodeBase.InsertChild(nodefils:TNodeBase; index:integer);
 begin
  Childs.insert(index,nodefils);
 end;
//*****************************************************************************/
function TNodeBase.SwapChilds : integer;
 var
  i,j,nbfils :integer;
  Node:TNodebase ;
  Pile :TList;
 begin
  result:=0;
  nbfils:=GetNbChilds;
    if (nbfils>1)
     then begin
	  result:=1;
	   Pile:=TList.Create;
           for i:=0 to nbfils-1 do
              begin
                  node:=GetChild(i);
	          Pile.add(Node);
                  node.InverseSens(node.FSens);
                  Childs.Items[i]:=nil;
              end;
	 i:=0;
         for j:=nbfils-1 downto 0  do
              begin
                  node:=TNodeBase(Pile.items[j]);
                  Childs.Items[i]:=node;
                  i:=i+1;
              end;
          Pile.free;
      end;
 end;
 //*****************************************************************************/
procedure TNodeBase.InverseSens(sens:TypeSens);
 begin
 if (sens=ssRight) then FSens:=ssLeft
 else  if (sens=ssLeft) then FSens:=ssRight
       else FSens:=ssNull;
  end;
//*******************************************************************************/
function TNodeBase.IsLChild : boolean;
 begin
 if (Sens=ssLeft)then result:=true else result:=false;
end;
//*******************************************************************************/
function TNodeBase.IsRChild :boolean;
  begin
 if (Sens=ssLeft)then result:=true else result:=false;
end;

end.
