unit PhylChoi;
// Dl 9/11/99 modif FormPaint pour rafficher BarreIcones
//            modif BVerifierClick, singulier pour 0 et 1 erreur
//            modif Initialise et BVerifierClick pour encadrement correct des cases errones
// DL 30/04/00 ajout d'une tolrance dans TabGrid1MouseMove
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, StdCtrls, Menus,MyNewgrid, Buttons, ExtCtrls, 
  ComCtrls, listarray, TabGridMark, CompCadreIma2;

type
                                         
  TFormChoisir = class(TForm)
  
    ListBox1: TListBox;
    ListeEtats: TListBox;
    Label1: TLabel;
    BVerifier: TBitBtn;

    RichEdit1: TRichEdit;

    BEffacer: TBitBtn;
    TabGrid1: TTabGridMark;
    CadreImage1: TCadreImage2;
    TabGridRef: TTabGridMark;
 
    procedure FormCreate(Sender: TObject);
    procedure TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ListBox1Click(Sender: TObject);
    procedure ListeEtatsClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure BVerifierClick(Sender: TObject);
    procedure BEffacerClick(Sender: TObject);
    procedure TabGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure TabGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RichEdit1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
  private
    { Dclarations prives }
    B:Tbitmap;
    FSelection:TStringList;
    procedure FrameCell(color :TColor ; ARow, ACol : longint);
    procedure AjouteEspece(Nom: string);
    procedure RetireEspece(NumLigne: integer);
    function GetSelection:TStringList;
  public
    { Dclarations publiques }
    procedure ChargeTabGrid(Fichier:string);
    procedure AfficheEspece(NumEsp:integer);
    procedure MajEspeces(L:TStringList);
    procedure Initialise;
    property Selection:TStringList read GetSelection;
end;

var
  FormChoisir: TFormChoisir;

implementation

{$R *.DFM}

uses Donnees, PhylMain, BarreIc, PhylGlo, PhylDef;
var
  ReferenceDisponible: boolean;


procedure TFormChoisir.FormCreate(Sender: TObject);
var
   hmax:integer;
begin
   FormPrinc.Fille(Self);
   Self.Visible:=false;
   with TabGrid1 do
   begin
      Align:=alTop;
      Cells[0,0]:=' ';
      DefaultColWidth:=80;
      DefaultRowHeight:=24;
      Width:=(Self.ClientWidth div DefaultColWidth)* DefaultColWidth;
      Height:=(Self.ClientHeight * 2) div 3;
      hmax:= Self.ClientHeight - Top - HauteurPetiteImage;
      if Height > hmax  then Height:=hmax;
      ClientHeight:=(ClientHeight div DefaultRowHeight) * DefaultRowHeight;
   end;

  //Barre d'icones en bas  gauche
  with BarreIcones do
  begin
     Parent:=Self;
     Top:=Self.Height-Height;
     Left:=0;
     Show;
  end;

  // ListBox  gauche sous la matrice
  with ListBox1 do
  begin
     Left:=TabGrid1.Left;
     Top:=TabGrid1.Top+TabGrid1.Height+5;
     Height:=BarreIcones.Top-Top-5;
  end;

  // CadreImage et texte en dessous de la matrice,  gauche de la barre des icones
  with CadreImage1 do begin
    Top:=TabGrid1.Top+TabGrid1.Height+5;
    Height:=HauteurPetiteImage;
    Width:=LargeurPetiteImage;
    Left:=Self.Width-Width;
  end;
  RichEdit1.BoundsRect:=CadreImage1.BoundsRect;
  BVerifier.Left:=ListBox1.Left+ListBox1.Width+20;
  BVerifier.Top:=ListBox1.Top;
  BEffacer.Left:=BVerifier.Left+BVerifier.Width+10;
  BEffacer.Top:=BVerifier.Top;

  FSelection:=TStringList.Create;
//  Initialise;
end;

procedure TFormChoisir.Initialise;
// (r)initialise la fiche avec les donnes courantes :
// listbox des caractres "dtaills" et matrice de rfrence
var
   NumCarD:integer;
   NomFicRef,Nombis:string;
  i,j: integer;

begin
// remise  blanc du tableau
// a marche mais c'est lourd,  revoir avec JFR
  with TabGrid1 do
  begin

    for i:=0 to ColCount-1 do
    for j:=0 to RowCount-1 do
    begin
      Cells[i,j]:='';
      MarkTab.StrItems[j,i]:='V';
    end;
    Cells[0,0]:=' ';
    RowCount:=1;
    ColCount:=1;
  end;
// chargement de la liste des caractres (dtaills)
    ListBox1.Clear;
    ListBox1.Sorted:=true;
     for NumCarD:=0 to Caracteres.CarD.Count-1 do
       ListBox1.Items.Add(Caracteres.GetNomCarD(NumCarD));

// illustration et liste des etats non visibles
    CadreImage1.Visible:=false;
    RichEdit1.Visible:=false;
    ListeEtats.Visible:=False;

// lecture de la matrice de rfrence  (Ex: Vertebrs.tab)
    TabGridRef.Visible:=false;
    NomFicRef:=FormPrinc.NomFicSansExt+ExtFicMat;
    ReferenceDisponible:=false;

    if not FileExists(NomFicRef) then                 // jfr modifie le 27/05/02
    begin
    Nombis:= ExtractFileName(NomFicRef);
    NomFicRef:=searchFile(GetCurrentDir,Nombis,'');
    end;

       TabGridRef.LoadFromFile(NomFicRef);
       ReferenceDisponible:=true;

    BarreIcones.Selection:=Selection;
end;

procedure TFormChoisir.ChargeTabGrid(Fichier:string);
begin
   with TabGrid1 do
   begin
      Initialise;
      LoadFromFile(Fichier);
      if (RowCount > 1) then FixedRows:=1;
      if (ColCount > 1) then FixedCols:=1;
   end;
end;

procedure TFormChoisir.AjouteEspece(Nom:string);
// Ajoute une espce dans TabGrid1
begin
   with TabGrid1 do
   begin
      RowCount:=RowCount+1;
      Cols[0].Add(Nom);
   end;
end;

procedure TFormChoisir.RetireEspece(NumLigne:integer);
// RSupprime NumLigne et resserre le tableau
var
  i:integer;
begin
   with TabGrid1 do
   begin
      for i:=NumLigne+1 to RowCount do Rows[i-1]:=Rows[i];
      RowCount:=RowCount-1;
   end;
end;

procedure TFormChoisir.AfficheEspece(NumEsp:integer);
// affiche le nom de l'espce choisie dans le tableau
// ou l'efface et resserre les lignes s'il est dj prsent
var
   NomTaxon:string;
   ind : integer;
begin
   NomTaxon:= Taxons.GetNom(NumEsp);
   with TabGrid1 do
   begin
      ind:= Cols[0].IndexOf(NomTaxon);
      if (ind=-1) then AjouteEspece(NomTaxon)
                  else RetireEspece(ind);
      if (RowCount > 1) then FixedRows:=1;
      SetFocus;
   end;  
end;

procedure TFormChoisir.ListBox1Click(Sender: TObject);
// analogue  AfficheEspece avec les caractres
var
   NomCarSel: string;
   ind,i:integer;
begin
   FormPrinc.TableauModifie:=true;

   with FormPrinc do
       begin
         Arbre1.Enabled:=false;
         Classer1.Enabled:=false;
        end;

   NomCarSel:= ListBox1.Items[ListBox1.ItemIndex];
   with TabGrid1 do
   begin
      ind:= Rows[0].IndexOf(NomCarSel);
      if (ind=-1) then
        begin
         ColCount:=ColCount+1;
         Rows[0].Add(NomCarSel);
        end
      else
        begin
          for i:=ind+1 to ColCount-1 do Cols[i-1]:=Cols[i];
          Cols[ColCount-1].Text:='';
          ColCount:=ColCount-1;
        end;
       if (ColCount > 1) then FixedCols:=1;
       AdjustColWidths;
       SetFocus;
   end;
end;

procedure TFormChoisir.TabGrid1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
// affiche la liste des tats possibles pour le caractre de la colonne dans
// laquelle pointe la souris et une image permettant de choisir
var
  Colonne,Ligne : longint; // plutt que Col et Row pour viter que ListeEtats
                           // ne s'affiche qd on clique en dehors de la grille
  R:TRect;
  NumTaxon,NumCaract:integer;
  NomImage,NomTexte: string;
begin
   FormPrinc.TableauModifie:=true;
   ListeEtats.Visible:=false;
   RichEdit1.Visible:=false;
   CadreImage1.Visible:=false;
   with TabGrid1 do
   begin
      TabGrid1.MouseToCell(X, Y, Colonne, Ligne);
      if (Colonne < ColCount) and (Colonne > 0) and (Ligne < RowCount) and (Ligne > 0) then
      with ListeEtats do
      begin
         Clear;
         Items:=Caracteres.GetEtats(Caracteres.GetNumCarD(Cells[Colonne,0]));
         Left:=X;
         Top:=Y;
         Height:=ItemHeight*(Items.Count+1); // pour afficher ts les tats
         R:=BoundsRect;
         B:=TBitmap.Create;
         B.Canvas.copyrect(Rect(0,0,ListeEtats.Width,ListeEtats.Height),Canvas,BoundsRect);
         Visible:=True;
        // Affichage de l'image ou du texte correspondant
         NumTaxon:= Taxons.GetNumTaxon(Cells[0,Ligne]);
         NumCaract:= Caracteres.GetNumCarParent(Caracteres.GetNumCarD(Cells[Colonne,0]));
         if (NumCaract=-1) then // car parent non trouv
            NomImage:=Taxons.GetImage(NumTaxon) // on affiche l'image de l'animal
         else                                   // sinon
            NomImage:=Taxons.GetImageCar(NumTaxon,NumCaract);  // on affiche le car parent
         if FileExists(NomImage) then
            begin
               CadreImage1.Affiche(NomImage,'');
               CadreImage1.Visible:=true;
            end
         else
         begin
            NomTexte:= Taxons.GetTexteCar(NumTaxon,NumCaract);
            if FileExists(NomTexte) then
            begin
               RichEdit1.Lines.LoadFromFile(NomTexte);
               RichEdit1.Visible:=True;
            end;
         end;
      end;
   end;
end;

procedure TFormChoisir.FrameCell(color :TColor ; ARow, ACol : longint);
// devrait normalement tre ds TTabGrid (MyNewGrid)
// o une mthode analogue existe en priv (FillCell)
var
 OldPstyle: TPenStyle;
 OldBstyle :TBrushStyle;
 OldPenColor :TColor;
 OldBrushColor :TColor;
 Rect :TRect;
begin
 Rect:=TabGrid1.CellRect(ACol,ARow);
 with TabGrid1.canvas do begin

    OldPstyle:=Pen.Style;
    OldBstyle:=Brush.style;
    OldPenColor:=Pen.color;
    OldBrushColor:=Brush.color;

    Pen.Style:=psclear;
    Brush.Style:=bssolid;

    brush.color:=Color;
//    Rectangle(Rect.Left,Rect.top,Rect.Right+1,Rect.Bottom+1);
    FrameRect(Rect);

    Pen.Style:=OldPstyle;
    Brush.style:=OldBstyle;
    Pen.color:=OldPenColor;
    Brush.color:=OldBrushColor;
  end;
end;

procedure TFormChoisir.ListeEtatsClick(Sender: TObject);
// transfre la valeur choisie dans la cellule courante et efface la liste des
//  tats possibles
begin
   with TabGrid1 do
   begin
      Cells[Col,Row]:=ListeEtats.Items[ListeEtats.ItemIndex];
      ListeEtats.Visible:=False;
      Canvas.CopyRect(ListeEtats.BoundsRect,B.Canvas,Rect(0,0,ListeEtats.Width,ListeEtats.Height));
      SetFocus;
   end;
end;

procedure TFormChoisir.FormPaint(Sender: TObject);
begin
// un BarreIcones.Show devrait suffire, mais si on enlve la squence suivante
// la barre d'icones n'est pas raffiche
  with BarreIcones do
  begin
     Parent:=Self;
     Top:=Self.Height-Height -10;
     Left:=0;
     Show;
  end;
  BarreIcones.Show;
  if FormGlossaire.Visible then FormGlossaire.Show;
end;

procedure TFormChoisir.BVerifierClick(Sender: TObject);
var                                    // jfr modifie septembre 2001
 NbErr:integer;                        // le test de la prsence de cellules vides a t rajout
 i,j:integer;                          // afin de valider ou non les options de menu "classer" et "arbre"
 RowRef, ColRef : integer;
 nbcellvide:integer;

begin
 nbcellvide:=0;

 for i:=1 to TabGrid1.RowCount-1 do
  begin
   for j:=1 to TabGrid1.ColCount-1 do
     begin
     if ((TabGrid1.Cells[j,i]='') or (trim(TabGrid1.Cells[j,i])='')) then inc(nbcellvide);
     end;
  end;

   if (nbcellvide>0) then              // Si une cellule est vide alors les
    begin                             // options de menu "classer" et "arbre" restent invalides
     with FormPrinc do
       begin
         Arbre1.Enabled:=false;
         Classer1.Enabled:=false;
        end;
     end
     else
      begin
        with FormPrinc do
       begin
         if (AfficherArbre = 'oui') then Arbre1.Enabled:=true;
         Classer1.Enabled:=true;
         end;
      end;   


 if not ReferenceDisponible then
 begin
    ShowMessage('Tableau de rfrence non disponible');
     exit;
 end;   
 NbErr:=0;
  TabGrid1.SetFocus;
 for i:=1 to TabGrid1.RowCount-1 do
 begin
   // recherche de la ligne contenant l'espece dans TabGridRef
   RowRef:=TabGridRef.Cols[0].IndexOf(TabGrid1.Cells[0,i]);
   for j:=1 to TabGrid1.ColCount-1 do
   begin
   // recherche de la colonne contenant le caractre dans TabGridRef
     ColRef:=TabGridRef.Rows[0].IndexOf(TabGrid1.Cells[j,0]);
    if TabGrid1.Cells[j,i] <> TabGridRef.Cells[ColRef,RowRef] then
     begin
        NbErr:=NbErr+1;
        TabGrid1.MarkTab.StrItems[j,i]:='F';
     end
     else TabGrid1.MarkTab.StrItems[j,i]:='V';
   end;
   TabGrid1.Invalidate;
 end;
 case NbErr of
   0 : ShowMessage('Le tableau est correct');
   1 : ShowMessage('1 erreur');
   else ShowMessage(inttostr(NbErr)+' erreurs');
 end;
 if (nbErr>0) then           // jfr modifie octobre 2001
    begin
     with FormPrinc do
       begin
         Arbre1.Enabled:=false;
         Classer1.Enabled:=false;
        end;
 end;

end;

procedure TFormChoisir.BEffacerClick(Sender: TObject);
begin
   Initialise;
end;

procedure TFormChoisir.TabGrid1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
   if TabGrid1.MarkTab.StrItems[ACol,ARow]='F' then
        FrameCell(clRed,ARow,ACol)
   else FrameCell(clWhite,ARow,ACol) ;
end;

procedure TFormChoisir.TabGrid1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
const
  Tolerance=40; // vite que la liste ne s'efface tout de suite 
                //  si le curseur se dplace lgrement  gauche ou au-dessus
begin
  with ListeEtats do
  if ((X < Left-Tolerance) or (X > Left+Width) or (Y < Top-Tolerance) or (Y > Top+Height)) then
        Visible:=false;
end;

procedure TFormChoisir.RichEdit1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Terme:string;
begin
  Terme:= TRichEdit(Sender).SelText;
  if Terme <> '' then FormDefinition.AfficheDefinition(Terme);
end;

function TFormChoisir.GetSelection: TStringList;
// renvoie la liste des noms d'espces du tableau
var
   i:integer;
begin
   FSelection.Clear;
   for i:=1 to TabGrid1.RowCount-1 do
     FSelection.Add(TabGrid1.Cells[0,i]);
   GetSelection:=FSelection;
end;

procedure TFormChoisir.MajEspeces(L: TStringList);
// met  jour la colonne des espces en fonction d'une liste de noms d'espces
var
   i:integer;
   NomEspece: string;
   ind: integer;
   Liste:TStringList;
begin
  // Liste est une copie de L (pour protger L)
   Liste:=TStringList.Create;
   Liste.Text:=L.Text;
   for i:=TabGrid1.RowCount-1 downto 1 do
   begin
      NomEspece:= TabGrid1.Cells[0,i];
      ind:= Liste.IndexOf(NomEspece);
      if (ind = -1) then
           RetireEspece(i)
      else
           Liste.Delete(ind);
   end;
   for i:=0 to Liste.Count-1 do AjouteEspece(Liste.Strings[i]);
   Liste.Free;
end;

procedure TFormChoisir.FormShow(Sender: TObject);
begin
     BarreIcones.Selection:=Selection;;
end;

end.
