unit PhylComp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, jpeg, CompCadreIma2,ListInteger;

const
  ImgDonneeAbsente='Absent.jpg';    // doit tre dans Prog
//  CoulLegendes=clLtGray;

type
  TFormComp = class(TForm)
    Image1: TCadreImage2;
    Image2: TCadreImage2;
    Image3: TCadreImage2;
    Image4: TCadreImage2;
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure ImageClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormHide(Sender: TObject);

  private
    { Dclarations prives }
    NbImages: integer;      // Nb de TImages ds la fentre (4 ou 9)
    ImageActive : integer; // Numro du TImage ds lequel l'image sera affiche
    NumCarCourant : integer; // Numero du car courant (0 pour l'image du taxon)
    FSelection : TStringList;
    procedure AfficheImage(NumEsp: integer);
    procedure EffaceImage(N:integer);
    procedure AfficheImages;
    function NumImage(NumEsp: integer): integer;
    function GetSelection: TStringList; // renvoie la liste des noms des espces compares
  public
    { Dclarations publiques }
    procedure AfficheEspece(NumEsp:integer);
    // affiche l'image d'un nouveau taxon ou l'image du car courant pour ce taxon
    procedure AfficheEspeces;
    procedure AfficheCaract(NumCar:integer);
    // change le caractre courant et affiche les images correspondantes
    procedure MajEspeces(Liste: TStringList);
    property Selection:TStringList read GetSelection;
  end;

var
  FormComp: TFormComp;

implementation

uses PhylMain, BarreIc, BarreCar, Donnees, PhylPlch;

{$R *.DFM}
const
   NbImagesMax=9;
var
   Images: array[1..NbImagesMax] of TCadreImage2;

procedure TFormComp.FormCreate(Sender: TObject);
var
   i: integer;
begin
   FormPrinc.Fille(Self);
   Self.Visible:=false;
   NbImages:=4; // provisoire
   ImageActive:=0;
   NumCarCourant:=0;
   Images[1]:=Image1;
   Images[2]:=Image2;
   Images[3]:=Image3;
   Images[4]:=Image4;
   for i:=1 to NbImages do with Images[i] do
   begin
      Tag:=-1;            // le numro de Taxon sera dans Tag
      OnClick:=ImageClick;
      Visible:=false;
      Width:=LargeurPetiteImage;
      Height:=HauteurPetiteImage;
      Left:=((i-1) mod 2)*Width;
      if (i < 3) then Top:=0 else Top:=Height;
   end;
   FSelection:=TStringList.Create;
end;

procedure TFormComp.FormPaint(Sender: TObject);
begin

//Barre d'icones en bas  gauche
  with BarreIcones do
  begin
     Parent:=Self;
//     if Screen.Height=480 then Height:=38;
     Top:=Self.ClientHeight-Height-10;
     Left:=0;
     Show;
  end;
// Barre des caractres  ct, en bas
  with BarreCaract do
  begin
     Parent:=Self;
     Top:=  BarreIcones.Top  + BarreIcones.Height - Height;
     Left:= BarreIcones.Left + BarreIcones.Width + 10;
     Show;
  end;
end;

procedure TFormComp.ImageClick(Sender: TObject);
// met le numro de l'image clique dans ImageActive
var
   i: integer;
begin
   i:=1;
   while (TCadreImage2(Sender) <> Images[i]) and (i < NbImages) do inc(i);
   EffaceImage(i);
   BarreIcones.Selection:=Selection; // jfr modifie 16 octobre 2001
   BarreIcones.AfficheIcones;        // jfr modifie 16 octobre 2001
end;

function TFormComp.NumImage(NumEsp:integer):integer;
// Renvoie l'indice de l'Image dans laquelle l'espece de numero NumEsp est affiche
//         -1 sinon
var
   i:integer;
begin
   NumImage:=-1;
   for i:=1 to NbImages do
   if (NumEsp=Images[i].Tag) then NumImage:=i;
end;

procedure TFormComp.AfficheEspece(NumEsp:integer);
// Affiche (ou efface si elle tait affiche) l'image correspondant  une espece
var
  N:integer;
begin
  N:=NumImage(NumEsp);
  if N = -1 then
      AfficheImage(NumEsp)
  else
      EffaceImage(N);
end;

procedure TFormComp.AfficheImage(NumEsp:integer);
// incrmente ImageActive ou la remet  1
// affiche l'image d'un nouveau taxon ou l'image du car courant pour ce taxon
// ds le TCadreImage de numro ImageActive
var
  NomImageTaxon,NomEsp: string;
begin
  //if (ImageActive < NbImages) then inc(ImageActive) else ImageActive:=1;
  //Images[ImageActive].Tag:=NumEsp;  // charger l'image du taxon
  // jfr modifie octobre 2001  Les deux lignes  ci-dessus ont t vires
  // Pour palier un pb li  l'absence d'un fichier image
  
  if  NumCarCourant=0 then
  begin
    NomImageTaxon:= Taxons.GetImage(NumEsp);
    if FileExists(NomImageTaxon) then
    begin
       if (ImageActive < NbImages) then inc(ImageActive) else ImageActive:=1;
       Images[ImageActive].Tag:=NumEsp;  // charger l'image du taxon
        // jfr modifie octobre 2001  Les deux lignes  ci-dessus ont t rajoutes
       Images[ImageActive].Affiche(NomImageTaxon,Taxons.GetNom(NumEsp));
       Images[ImageActive].Visible:=true;
    end
    else
    begin
       ShowMessage('Le fichier '+ NomImageTaxon +' n''existe pas');
       NomEsp:= Taxons.GetNom(NumEsp);
       BarreIcones.Selection.Add(NomEsp);
       exit;    // jfr modifie 16 octobre 2001
     end;  
  end
  else
     begin
     if (ImageActive < NbImages) then inc(ImageActive) else ImageActive:=1;
       Images[ImageActive].Tag:=NumEsp;

   // jfr modifie octobre 2001  Les deux lignes  ci-dessus ont t rajoutes
   // charger l'image du car courant (toutes pour l'instant)

      AfficheCaract(NumCarCourant);
      end;
end;

procedure TFormComp.EffaceImage(N:integer);
// Efface l'image en position N, resserre les suivantes
var
   i:integer;
begin
   for i:=N+1 to NbImages do Images[i-1].Tag:=Images[i].Tag;
   Images[NbImages].Tag:=-1;
   AfficheImages;
  // if ImageActive > 1 then ImageActive:=ImageActive-1;
  // jfr modifie octobre 2001 : la ligne du dessus a t supprime.
  // Car la prochaine image   s'affichait sur une des images encore en place
end;

procedure TFormComp.AfficheCaract(NumCar:integer);
// change le caractre courant et affiche les images correspondantes
var
  i : integer;
  NomImageCar : string;
  NomTaxon : string;
begin
  NumCarCourant:=NumCar;
  for i:=1 to NbImages do
  with Images[i] do
  if (Tag <> -1) then
  begin
     NomImageCar:= Taxons.GetImageCar(Tag,NumCar);
     NomTaxon:= Taxons.GetNom(Tag);

     if FileExists(NomImageCar) then
       Affiche(NomImageCar,NomTaxon)
     else
       if FileExists(ImgDonneeAbsente) then
           Affiche(ImgDonneeAbsente,NomTaxon)
       else
         begin   // le fichier Absent.jpg n'est pas dans Prog
           Affiche('',MsgdonneeAbsente);
         end;
     Visible:=true;
  end;
end;

procedure TFormComp.AfficheImages;
// raffiche les images  partir du tag
var
   i:integer;
begin
   ImageActive:=0;
   for i:=1 to NbImages do
     if (Images[i].Tag <> -1) then AfficheImage(Images[i].Tag)
                              else Images[i].Visible:=false;
end;

procedure TFormComp.AfficheEspeces;
// raffiche toutes les images d'espces
begin
  NumCarCourant:=0;
  AfficheImages;
end;

function TFormComp.GetSelection: TStringList;
var
  i:integer;
begin
  FSelection.Clear;
  for i:=1 to NbImages do with Images[i] do
    if (Tag <> -1) then FSelection.Add(Taxons.GetNom(Tag));
  GetSelection:=FSelection;
end;

procedure TFormComp.MajEspeces(Liste:TStringList);
// affiche les images correspondant  une liste d'espces
var
   i:integer;
   N:integer;
begin
   N:=Liste.Count;
   if (N > NbImages) then N:=NbImages;
   ImageActive:=0;
   for i:=0 to N-1 do
     AfficheImage(Taxons.GetNumTaxon(Liste[i]));
   for i:=Liste.Count+1 to NbImages do
   begin
     Images[i].Visible:=false;
     Images[i].Tag:=-1;
   end;
end;

procedure TFormComp.FormShow(Sender: TObject);
begin
   FormPrinc.Comparer1.Enabled:=false;
   BarreIcones.Selection:=GetSelection;
   BarreIcones.Show;
end;

procedure TFormComp.FormHide(Sender: TObject);
begin
   FormPrinc.Comparer1.Enabled:=true;

end;

procedure TFormComp.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i:integer;
begin
  for i:=1 to NbImages do with Images[i] do Tag:=-1;
  FSelection.Clear;
  MajEspeces(FSelection);
end;

end.
