unit PhylObs;

// DL 17/07/01 modif FormClose pour corriger bug sur ouverture successive de 2
//             fichiers d'images diffrents

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, BarreIc, jpeg, ComCtrls, CompCadreIma2;

type
  TFormObs = class(TForm)
    NomEsp: TLabel;
    NomCar: TLabel;
    TexteCar: TRichEdit;
    ImageEsp: TCadreImage2;
    ImageCar: TCadreImage2;
    procedure AfficheEspece(NumEsp:integer);
    procedure AfficheCaract(NumEsp,NumCar:integer);
    procedure FormCreate(Sender: TObject);
    procedure ImageClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure TexteCarMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Dclarations prives }
    FSelection:TStringList;     // Pour compatibilit avec PhylComp et PhylChoi
    function GetSelection: TStringList;
  public
    { Dclarations publiques }
    property Selection:TStringList read GetSelection;
  end;

var
  FormObs: TFormObs;

implementation

uses Donnees, PhylMain, BarreCar,PhylBig, PhylGlo, PhylDef;
{$R *.DFM}


procedure TFormObs.FormCreate(Sender: TObject);
begin
   FormPrinc.Fille(Self);
   Self.Visible:=false;
   with ImageEsp do
   begin
      Width:=LargeurPetiteImage;
      Height:=HauteurPetiteImage;
      Tag:=-1;
   end;   
   with ImageCar do
   begin
      Visible:=false;
      Left:=ImageEsp.Left+ImageEsp.Width+50;
      Width:=ImageEsp.Width;
      Tag:=-1; // numero du car courant, 0 correspond au 1er caractre
   end;
   with TexteCar do
   begin
      Visible:=false;
      Top:=ImageEsp.Top;
      Left:=ImageCar.Left;
      Width:=ImageCar.Width;
   end;
   FSelection:=TStringList.Create; 
end;

procedure TFormObs.FormPaint(Sender: TObject);
begin
//Barre d'icones en bas  gauche
  with BarreIcones do
  begin
     Parent:=Self;
//     if Screen.Height=480 then Top:=400 else Top:=410;
     Left:=0;
     Top:=Self.ClientHeight-Height-10;
     Show;
  end;   
// Barre des caractres  ct, en bas
  with BarreCaract do
  begin
     Parent:=Self;
     Top:=  BarreIcones.Top  + BarreIcones.Height - Height;
     Left:= BarreIcones.Left + BarreIcones.Width + 10;
     Show;
  end;
end;

procedure TFormObs.AfficheEspece(NumEsp:integer);
var
  NumCar: integer;
  NomImageTaxon: string;
begin
  NomImageTaxon:= Taxons.GetImage(NumEsp);
  if FileExists(NomImageTaxon) then
   begin
    ImageEsp.Affiche(NomImageTaxon,'');
    ImageEsp.Visible:=true;
   end
  else
   begin
    ImageEsp.Visible:=false;
    ShowMessage('Le fichier '+ NomImageTaxon +' n''existe pas');
   end;
  NomEsp.Caption:=Taxons.GetNom(NumEsp);
  ImageEsp.Tag:=NumEsp;
  NumCar:=ImageCar.Tag;
  if NumCar<>-1 then AfficheCaract(NumEsp,NumCar);   // jfr modifie 16 octobre 2001
end;

procedure TFormObs.AfficheCaract(NumEsp,NumCar:integer);
// affiche un texte et ventuellement une petite image
// ou une grande image s'il n'y a pas de texte
var
  NomTexteCar:string;
  NomImageCar:string;
  NomImageCarBig:string;
begin
  if ImageEsp.Tag=-1 then exit;
  NomTexteCar:= Taxons.GetTexteCar(NumEsp,NumCar);
  if FileExists(NomTexteCar) then
  begin
     // Affichage du texte
     TexteCar.Lines.LoadFromFile(NomTexteCar);
     TexteCar.Visible:=true;
     
     NomImageCar:= Taxons.GetImageCar(NumEsp,NumCar);
     if FileExists(NomImageCar) then
     begin
        // Affichage d'une petite image  en-dessous
        ImageCar.Top:=TexteCar.Top+TexteCar.Height;
        ImageCar.Height:=HauteurPetiteImage;
        ImageCar.Affiche(NomImageCar,'');
        ImageCar.Visible:=True;
     end
     else
       begin
        ImageCar.Visible:=false;
       end;
  end
  else
   begin
      TexteCar.Visible:=false;
      NomImageCarBig:= Taxons.GetImageCarBig(NumEsp,NumCar);
      if FileExists(NomImageCarBig) then
       begin // Affichage d'une grande image
        ImageCar.Top:=ImageEsp.Top;
        ImageCar.Height:=2*HauteurPetiteImage;
        ImageCar.Affiche(NomImageCarBig,'');
        ImageCar.Visible:=True;
       end
       else
        begin                // texte indiquant l'absence de donnee
          ImageCar.Visible:=false;
          TexteCar.Text:=MsgDonneeAbsente;
          TexteCar.Visible:=true;
        end;
   end;
       
  ImageCar.Tag:=NumCar;
end;

procedure TFormObs.ImageClick(Sender: TObject);
begin
  Application.CreateForm(TFormBig, FormBig);
  FormBig.Parent:=Self;
  FormBig.AgrandirImage(Sender);
end;

procedure TFormObs.TexteCarMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Terme:string;
begin
  Terme:= TRichEdit(Sender).SelText;
  if Terme <> '' then FormDefinition.AfficheDefinition(Terme);
end;

function TFormObs.GetSelection: TStringList;
begin
  FSelection.Clear;
  if (Assigned(Taxons)) and (ImageEsp.Tag <> -1) then FSelection.Add(Taxons.GetNom(ImageEsp.Tag));
  GetSelection:=FSelection;
end;

procedure TFormObs.FormShow(Sender: TObject);
begin
  FormPrinc.Observer1.Enabled:=false;  // jfr modifie 16 octobre 2001
  BarreIcones.Show;

end;

procedure TFormObs.FormHide(Sender: TObject);
begin
FormPrinc.Observer1.Enabled:=true;   // jfr modifie 16 octobre 2001
   BarreIcones.Hide;
end;

procedure TFormObs.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   ImageEsp.Tag:=-1;
   ImageCar.Tag:=-1;
   ImageCar.Visible:=false;
   ImageEsp.Visible:=false;
   FSelection.Clear;
end;

end.
