unit scroldem;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, ExtCtrls;

type
  TScrollForm1 = class(TForm)
    Bevel1: TBevel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label1: TLabel;
    Vertical: TLabel;
    ImgPanel: TPanel;
    Image: TImage;
    HScrollb: TScrollBar;
    VScrollb: TScrollBar;
    HUnits: TEdit;
    HPage: TEdit;
    HMax: TEdit;
    VUnits: TEdit;

    VPage: TEdit;
    VMax: TEdit;
    HUnitsUpDown: TUpDown;
    HPageUpDown: TUpDown;
    HMaxUpDown: TUpDown;
    VUnitsUpDown: TUpDown;
    VMaxUpDown: TUpDown;
    VPageUpDown: TUpDown;
    DefaultBtn: TButton;
    ApplyBtn: TButton;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    View1: TMenuItem;
    VScrollMenu: TMenuItem;
    HScrollMenu: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;

    OpenDialog: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure View1Click(Sender: TObject);
    procedure VScrollMenuClick(Sender: TObject);
    procedure HScrollMenuClick(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure VScrollbChange(Sender: TObject);
    procedure HScrollbScroll(Sender: TObject; ScrollCode: TScrollCode; var ScrollPos: Integer);
    procedure ImgPanelResize(Sender: TObject);

//    procedure About1Click(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure DefaultBtnClick(Sender: TObject);
    procedure UpDownClick(Sender: TObject; Button: TUDBtnType);

  private
    { dclarations prives }
    Units: TPoint;
    FDirty: Boolean;

    procedure SetDirty(d: Boolean);
    procedure ImageLoad(filename: string);
    procedure ScrollAdjust(update: Boolean);
    procedure ScrollReset;
    procedure UpdateDisplay;

    property Dirty: Boolean read FDirty write SetDirty;

  public
    //constructor Create(Owner: TComponent); override;
    { dclarations publiques }
  end;

var
  ScrollForm1: TScrollForm1;

implementation

uses ScrolAbout;


{$R *.DFM}

const
  DEF_SCROLL_UNITS = 8;

procedure TScrollForm1.FormCreate(Sender: TObject);
begin
  ScrollReset;
end;

procedure TScrollForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TScrollForm1.View1Click(Sender: TObject);

begin
  HScrollMenu.Checked := HScrollb.Visible;
  VScrollMenu.Checked := VScrollb.Visible;
end;
  
procedure TScrollForm1.VScrollMenuClick(Sender: TObject);
begin
  VScrollb.Visible := not VScrollb.Visible;
end;

procedure TScrollForm1.HScrollMenuClick(Sender: TObject);
begin
  HScrollb.Visible := not HScrollb.Visible;
end;

procedure TScrollForm1.Open1Click(Sender: TObject);
begin
  if OpenDialog.Execute then
    ImageLoad(OpenDialog.FileName);
end;


//
// Intercepter l'vnement OnChange est le moyen le plus simple de grer
// la notification de barre de dfilement. Remarquez la vrification pour 
// s'assurer que l'expditeur est la barre de dfilement verticale.
// Bien que ne s'appliquant pas  cet exemple, certaines fiches peuvent 
// avoir besoin de faire la diffrence entre plusieurs barres de 
// dfilement.
//
procedure TScrollForm1.VScrollbChange(Sender: TObject);
begin
  if Sender as TScrollBar = VScrollb then

    Image.Top := -Units.y * VScrollb.Position;
end;

//
// Intercepter l'vnement OnScroll est un autre moyen de grer les 
// notifications de barre de dfilement. Cela est ncessaire pour plusieurs
// raisons:
//   1) Vous voulez faire quelque chose de particulier
//      avec un vnement de dfilement spcifique
//   2) L'amplitude de la barre de dfilement dpasse [0, 65535]. Dans
//      ce cas, l'lment ScrollPos est incorrect et l'essentiel du
//      dfilement doit tre effectu manuellement.

//
procedure TScrollForm1.HScrollbScroll(Sender: TObject; ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
  if HScrollb.Max <= 65535 then
    Image.Left := -Units.x * ScrollPos
  else
    ShowMessage('Scrollbar ranges > 65535 not supported');
end;

//
// La taille du volet ne change pas dans cet exemple, donc
// cet vnement ne peut se produire qu'une seule fois. En gnral, l'amplitude
// de la barre de dfilement doit tre modifie quand la taille de la

// fentre visible est modifie.
//
procedure TScrollForm1.ImgPanelResize(Sender: TObject);
begin
  ScrollAdjust(True);
end;

function scale(n, u: Integer): Integer;
begin
  Result := (n + u - 1) div u;
end;

function maxval(a, b: Integer): Integer;
begin
  if a >= b then
    Result := a
  else
    Result := b;
end;

//
// Rajuste l'amplitude des barres de dfilement pour correspondre  la nouvelle
// taille de la fentre visible. Appele galement par ScrollReset pour viter

// de dupliquer le code.
//
procedure TScrollForm1.ScrollAdjust(update: Boolean);
begin
  // Dfinit un dfilement maximum suffisamment grand pour faire dfiler toute
  // l'image, mais pas suffisamment pour dfiler hors de la fentre.  La 
  // division par le nombre de Units (>1) est effectue, car dfiler d'un pixel 
  //  la fois est beaucoup trop lent pour la plupart des images.

  if Image.Picture <> nil then
  begin
    HScrollb.Max := maxval(0, scale(Image.Width - ImgPanel.Width, Units.x));

    VScrollb.Max := maxval(0, scale(Image.Height - ImgPanel.Height, Units.y));
  end;

  if update then
    UpdateDisplay;
end;

//
// ScrollReset() est utilise pour placer les barres de dfilement  l'tat
// "initial" correct. Il faut le faire  chaque fois que l'image est modifie,
// puisque la quantit de dfilement dpend de la taille de l'image. Par souci
// de simplicit, le cas de figure "nouvelle taille" == "ancienne taille"
// n'est pas envisag.
//

procedure TScrollForm1.ScrollReset;
begin
  // Cette taille fixe fonctionne bien mme si, dans certains cas, baser
  // l'unit de dfilement sur la taille de l'image fonctionne aussi.
  Units.x := DEF_SCROLL_UNITS;
  Units.y := DEF_SCROLL_UNITS;

  if Image.Picture <> nil then
  begin
    // Dplacer l'image et les barres de dfilement  l'emplacement initial
    Image.Top := 0;
    Image.Left := 0;
    HScrollb.Position := 0;
    VScrollb.Position := 0;

    // Les amplitudes de dfilement ngatives ne posent pas problme,

    // on dfinit donc l'amplitude [0, M]. Voir 'ScrollAdjust'
    // pour le calcul de M.
    HScrollb.Min := 0;
    VScrollb.Min := 0;
    ScrollAdjust(False);

    HScrollb.LargeChange := scale(HScrollb.Max, Units.x);
    VScrollb.LargeChange := scale(VScrollb.Max, Units.y);

    HScrollb.Visible := True;
    VScrollb.Visible := True;
  end;

  UpdateDisplay;
end;


procedure TScrollForm1.SetDirty(d: Boolean);
begin
  if d <> FDirty then
  begin
    FDirty := d;

    ApplyBtn.Enabled := FDirty;
  end;
end;


procedure TScrollForm1.ImageLoad(filename: string);
begin
  Image.Picture.LoadFromFile(filename);
  ScrollReset;
end;

{procedure TScrollForm1.About1Click(Sender: TObject);
var
  about: TAboutBox;
begin
  about := TAboutBox.Create(Self);
  try
    about.ShowModal;
  finally
    about.Free;
  end;
end;
}

procedure TScrollForm1.ApplyBtnClick(Sender: TObject);
begin
  Units.x := HUnitsUpDown.Position;
  HScrollb.LargeChange := HPageUpDown.Position;

  HScrollb.Max := HMaxUpDown.Position;

  Units.y := VUnitsUpDown.Position;
  VScrollb.LargeChange := VPageUpDown.Position;
  VScrollb.Max := VMaxUpDown.Position;

  Dirty := False;
end;

procedure TScrollForm1.DefaultBtnClick(Sender: TObject);
begin
  ScrollReset;
  Dirty := False;
end;

procedure TScrollForm1.UpDownClick(Sender: TObject; Button: TUDBtnType);
begin
  Dirty := True;
end;

procedure TScrollForm1.UpdateDisplay;
begin
  HUnitsUpDown.Position := Units.x;

  HPageUpDown.Position := HScrollb.LargeChange;
  HMaxUpDown.Position := HScrollb.Max;

  VUnitsUpDown.Position := Units.y;
  VPageUpDown.Position := VScrollb.LargeChange;
  VMaxUpDown.Position := VScrollb.Max;

  Dirty := False;
end;

end.
