unit boite;

interface

uses
  SysUtils,Classes,listarray2,GraphObject,controls,graphics,windows,node  ;

const NodeColor : array[0..17] of TColor =(clBlack ,clBlue, clYellow,clFuchsia,clRed, clGreen,
                                      clNavy,clLime, clPurple ,clTeal ,clGray, clSilver,
                                      clMaroon ,  clOlive ,
                                      clAqua , clLtGray ,clDkGray ,  clWhite );

    Color_No_Select      : TColor = 16748945;

   clSilver  = TColor($00C0C0C0 );
   clLavender =   TColor($00FAE6E6);
   clWheat = TColor($00B3DEF5);
   clPink    =  TColor($00CBC0FF);
   clCoral  =  TColor($00507FFF);
   clDarkorange  =   TColor($00008CFF);
   clSalmon  =   TColor($007280FA);
   clPalegoldenrod  = TColor($00AAE8EE);
   clTan    = TColor($008CB4D2);
   clPalegreen   = TColor($0098FB98);
   clMediumaquamarine = TColor($00AACD66);
   clAqua = TColor($00FFFF00);
   clMediumturquoise  = TColor($00CCD148);
   clLightsteelblue = TColor($00DEC4B0);
   clOrchid  = TColor($00D670DA);
   clWhistle  = TColor($00D8BFD8);
   clPalevioletred = TColor($009370DB);
   clCadetblue  = TColor($00A09E5F);

const NodeColorbis : array[0..17] of TColor =(clPalevioletred ,clLavender ,clSalmon  ,clWheat,clLightsteelblue,clCadetblue , clDarkorange,
                                      clMediumturquoise,clPalegoldenrod, clTan ,clPalegreen ,clMediumaquamarine, clAqua,
                                      clSilver, clPink  ,
                                      clOrchid , clWhistle , clCoral );
type
TNodeBoiteG =class;

TNodeBoite = class(TObject)                // le modle de donnes : la boite. Elle appartient  une structure arborescente et est donc
  public                                   // un noeud de l'arbre

 nodeAssocG : TnodeBoiteG;                // l'objet graphique associ  la boite
 nodeChilds : TList;                      // une boite  un "noeud" parent et des "noeuds" enfants
 nodeParent : TNodeBoite ;
 niveau : integer ;                      // dfinit le niveau du noeud dans l'arborescence

 taxons : TStringList;                  // Une boite contient une liste de taxons
 taxonsLibres : TStringList;            // Parmi les taxons contenus dans une boite, il y en a qui sont contenus dans des boites
                                        // filles : ils ne sont pas "libres".
                                        //Seuls les taxons libres sont susceptibles d'tre "tris"

 caracteres : TStringList;              // Une boite est dfinie par au moins un caractre, mais plusieurs caractres peuvent ensuite
                                        //correspondre aux mmes tris : ils constituent une liste de caractres
 premier_caractere : String ;           // Le caractre qui a servi  dfinir pour la premire fois une boite

 constructor create ;
 destructor Destroy; override;
 function Inclut(nodep : TNodeBoite) : boolean;
 function IntersectIncomplet(nodef : TNodeBoite) : boolean;
 function getIndex(): integer;
 function defineNiveau() : integer;
 function getChild(index:integer):TNodeBoite;
 function getFrereGauche(): TNodeBoite;
 function ChildsIntersectIncomplet(nodep : TNodeBoite) : boolean;
 function  egal(nodep : TNodeBoite) : boolean;
 procedure  arrangeFilsDuPere(nodePere :TNodeBoite) ;
 procedure  CreerTaxonsLibres();
 procedure CreerNodeG(AParent:TCustomControl);
 procedure DeleteNodeG();

 end;

//*****************************************************************************/
 TTreeBoite = class(TObject)    // la structure arborescente qui contient les boites
  public

 root:TNodeBoite;
 lastNode : TnodeBoite;
 tabdata :TStrListArray;         // le tableau de donnes qui contient les taxons et les caractres issus de TTabgrid
 nodeTemp :TNodeBoite;

 niveauxDefinis :boolean ;
 niveauxDefinisG :boolean ;

constructor createBoite;

procedure  defineNodelevelG(aNodeG : TNodeBoiteG);
procedure  defineNodelevel(aNode : TNodeBoite);

procedure  annuleNodelevel(aNode : TNodeBoite);
procedure  annulerNiveaux();

procedure  annuleNodelevelG(aNodeG : TNodeBoiteG);
procedure  annulerNiveauxG();

procedure definirNiveaux()  ;
procedure definirNiveauxG()  ;

procedure  CreerNodeG(AParent:TCustomControl);
procedure  CreerNodeGraphique( aNode:TNodeBoite ; AParent:TCustomControl);

procedure  DeleteNodeG();
procedure  DeleteNodeGraphique( aNode:TNodeBoite);

procedure  DeleteTaxonsLibres();
procedure  DeleteNodeTaxonsLibres(aNode : TNodeBoite);

procedure CreerNodeTaxonsLibres( aNode:TNodeBoite );
procedure  CreerTaxonsLibres();
function ajouter_un_tri(caractere : String ; etatderive : String):String  ;
function enlever_un_tri(caractere : String):boolean ;

// Fonction qui retourne le dernier noeud qui inclut le nouveau noeud cr
 // Elle initialise une varaiable globale qui est ensuite utilise dans la fonction suivante
 function dernier_noeud_qui_inclut(newnode : TNodeBoite): TNodeBoite;
 procedure dni( nodep : TNodeBoite ; newnode : TNodeBoite);

 // Fonction qui retourne le premier noeud qui contient le caractere "caractere"
 // Elle initialise une varaiable globale qui est ensuite utilise dans la fonction suivante
 function   getFirstNode(aNode:TNodeBoite ; caractere :String): TNodeBoite;
 // fonction rcursive
 function   FirstNode( aNode :TNodeBoite ; caractere: String  ): TNodeBoite;

 function  getNbNiveaux():integer  ;

 procedure testNodeLevelG(anode :TnodeBoiteG ; level : integer ; liste : TList) ;
 procedure creerListeNodeLevel (level : integer ; liste : TList)  ;

end;


//*****************************************************************************/
// Les noeuds graphiques sont des structures qui sont mapes sur les noeuds (nodeboite) avec
// une redondance au niveau caracteresG (caracteres du nodeBoite) et taxonsG (taxons du nodeBoite) : peu efficace...
// mais aux noeuds (nodeBoite) correspondent en plus des noeuds graphiques qui contiennent les taxons libres des nodeBoite
// donc  un nodeBoite correspond au minimum un noeud graphique plus le noeud qui englobe les taxons libres

TNodeBoiteG = class (TGraphObject)

   public
    nodeAssoc : TnodeBoite;
    nodeCLAssoc : TNodeCL;
    larg : integer;
    haut : integer;

    nodeChildsG : TList;
    nodeParentG : TNodeBoiteG ;
    niveauG : integer ;
    taxonsG :TStringList;
    caracteresG : TStringList;

    constructor CreateObject(AParent:TCustomControl);override;
    destructor Destroy; override;

    function  getIndex():integer;
    function getFrereGaucheG(): TNodeBoiteG;
    function GetShadowColor(BaseColor: TColor; delta:Byte): TColor;
    function defineNiveauG() : integer;
    procedure Draw(ACanvas:TCanvas);override;
   end;

//*****************************************************************************/
//*****************************************************************************/

implementation

function TranslateColorName(value: integer): Integer;

begin
  Result := 0;

      // return RGB colors
      Result :=
        Byte( Value shr 16) +
        Byte( Value shr 8) shl 8 +
        Byte( Value) shl 16;

end;

function HTML2Color(const HTML: String): Integer;
var
  Offset: Integer;
begin

    // check for leading '#'
    if Copy(HTML, 1, 1) = '#' then
      Offset := 1
    else
      Offset := 0;
    // convert hexa-decimal values to RGB
    Result :=
      Integer(StrToInt('$' + Copy(HTML, Offset + 1, 2))) +
      Integer(StrToInt('$' + Copy(HTML, Offset + 3, 2))) shl 8 +
      Integer(StrToInt('$' + Copy(HTML, Offset + 5, 2))) shl 16;

  end;
 

  function Min(a, b: Longint): Longint;
begin
  if a > b then Result := b else Result := a;
end;

function Max(a, b: Longint): Longint;
begin
  if a > b then Result := a else Result := b;
end;
constructor TNodeBoite.create;
 begin
  nodeChilds:=Tlist.Create;
  taxons :=TStringList.Create;
  taxonslibres:= TStringList.Create;
  premier_caractere:='';
  caracteres := TStringList.Create;

  nodeparent:=nil ;
  niveau := 0;
  end;

destructor TNodeBoite.Destroy;
begin
 nodeChilds.free;

 taxons.Free;
 taxonsLibres.Free;
 caracteres.Free;
 inherited destroy;
 end;


 // jusqu' prsent les boites ont t dfinies uniquement  partir des taxons qui prsentaient l'tat volu du caractre
 procedure TNodeBoite.CreerTaxonsLibres();
  var
   taxon, taxonf:  string;
   nodef :TNodeBoite;
   i,j,k  :integer;
   trouve : boolean;
   taxLibres :TStringList;
   begin
      taxLibres := TStringList.Create;          // liste de chaines de caractres correspondant  tous les taxons
      for i:=0 to taxons.count-1 do
         taxLibres.Add(taxons[i]);
       for i:=0 to taxLibres.count-1 do
          begin
           taxon:= taxLibres[i];                 // on cherche les taxons libres c.a.d ceux qui ne sont pas inclus dans des boites filles
               for j:=0 to nodechilds.count-1 do
                  begin
                    nodef := TNodeBoite( nodeChilds.Items[j])  ;
                     for k:=0 to nodef.taxons.count-1 do
                       begin
                           taxonf := nodef.taxons[k] ;
                           if ((taxon <> '') and (taxonf <> '') and (taxon = taxonf))then   // si un taxon est compris dans une boite fille, il est retir de la liste
                               begin
                                taxLibres[i]:= '';
                                break;
                               end;
                        end;
                    end;
           end;
         taxonsLibres.Clear;     // la variable taxonsLibres est rinitialise puis re-rempli avec les taxons qui restent libres c.a.d ceux qui n'ont pas t enlevs
         for i:=0 to taxLibres.count-1 do
          begin
            taxon:= taxLibres[i];
            if (taxon <> '') then taxonsLibres.add(taxon);
           end;
     taxLibres.Free;      
    end;

function TNodeBoite.IntersectIncomplet(nodef : TNodeBoite) : boolean;
var
 taxon, taxonf:  string;
 nb, nbf :integer;
 i,j,nbIntersect :integer;
 trouve : boolean;
 begin
  result:=true;
  nb:=taxons.Count;
  nbf := nodef.taxons.Count;
  nbIntersect :=0;

    for j:=0 to nbf-1 do
        begin
         taxonf := nodef.taxons[j] ;
         trouve :=false;
           for i:=0 to nb-1 do
             begin
               taxon := taxons[i] ;
               if ((taxon <> '') and (taxonf <> '') and (taxon = taxonf))then
                   begin
                    trouve := true ;
                    break;
                   end;
             end;
           if (trouve = true) then
                 begin
                   nbIntersect := nbIntersect +1;
                 end;
        end;
   if (nbIntersect = nbf) or (nbIntersect = 0) then result :=false
 end;

 // on a cr un noeud provisoire qui est totalement inclu dans son noeud pere mais
 // il n'est pas encore le fils de son pre
 // et on vrifie que ce noeud n'a pas d'intersection incomplete avec des noeuds fils dj existant

 function TNodeBoite.ChildsIntersectIncomplet(nodep : TNodeBoite) : boolean;
var

 nb  :integer;
 i   :integer;
 trouve : boolean;
 nodef : TNodeBoite   ;
 begin
      result := false;
      nb := nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                    nodef := TNodeBoite( nodeChilds.Items[i])  ;
                       if (nodef <> nil)  then
                        begin
                           trouve:=nodep.IntersectIncomplet(nodef)  ;
                              if (trouve = true) then
                                 begin
                                   result := true;
                                   break;
                                  end;
                         end;

                 end;
           end;
 end;

function TNodeBoite.egal(nodep : TNodeBoite) : boolean;
var
 taxon, taxonp:  string;
 nb, nbp :integer;
 i,j :integer;
 trouve : boolean;
 begin
  result:=true;
  nb:=taxons.Count;
  nbp := nodep.taxons.Count;
  if (nb <> nbp)then   result := false 
  else
    begin
    result := true;
      for j:=0 to nbp-1 do
        begin
         taxonp := nodep.taxons[j] ;
         trouve :=false;
          for i:=0 to nb-1 do
            begin
              taxon := taxons[i] ;
              if ((taxon <> '') and (taxonp <> '') and (taxon = taxonp))
                 then begin trouve :=true ;  break; end;
            end;
         if (trouve = false) then begin result:=false ; break; end;
        end;
     end;
 end;

// fonction qui  
 function TNodeBoite.Inclut(nodep : TNodeBoite) : boolean;
var
 taxon, taxonp:  string;
 nb, nbp :integer;
 i,j :integer;
 trouve : boolean;
 begin
   result:=false;
  nb:=taxons.Count;
  nbp := nodep.taxons.Count;
  if ((nb >= nbp) and (nb>0)) then
    begin
    result := true;
      for j:=0 to nbp-1 do
        begin
         taxonp := nodep.taxons[j] ;
         trouve :=false;
          for i:=0 to nb-1 do
            begin
              taxon := taxons[i] ;
              if ((taxon <> '') and (taxonp <> '') and (taxon = taxonp))
                 then trouve :=true ;
            end;
         if (trouve = false) then begin result:=false ; break; end;
        end;
     end;
 end;


procedure TNodeBoite.arrangeFilsDuPere(nodePere :TNodeBoite) ;
var
nodef :  TNodeBoite;
 nb,i: integer;
begin
 
  nb := nodePere.nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                   nodef := TNodeBoite( nodePere.nodeChilds.Items[i])  ;
                   if (self.inclut(nodef)=true) then
                     begin
                       nodePere.nodeChilds.Items[i]:=nil;
                       nodef.nodeParent :=self;
                       self.nodeChilds.add(nodef)
                     end;
                  end;
            end;
nodePere.nodeChilds.pack;
end;

function TNodeBoite.defineNiveau() : integer;
var
node :  TNodeBoite;
niveauT,nb,i: integer;
begin
 result:=0;
 niveauT := 0;

   nb := nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                   node := TNodeBoite( nodeChilds.Items[i])  ;
                    if ((node <> nil) and (node.niveau <> 0)) then
                      begin
                      if (nb=1) then  niveauT := niveauT + node.niveau +1
                      else niveauT := niveauT + node.niveau ;
                      end
                    else begin niveauT := 0 ; break; end;
                 end;
           end ;
          result := niveauT;
end;

function TNodeBoiteG.defineNiveauG() : integer;
var
nodeG :  TNodeBoiteG;
niveauT,nb,i: integer;

begin
 result:=0;
 niveauT := 0;

   nb := nodeChildsG.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
                 begin
                   nodeG := TNodeBoiteG( nodeChildsG.Items[i])  ;
                    if ((nodeG <> nil) and (nodeG.niveauG <> 0)) then
                      begin
                       niveauT := niveauT + nodeG.niveauG ;
                      end
                    else begin niveauT := 0 ; break; end;
                 end;
           end ;
          result := niveauT;
end;

function TNodeBoite.getIndex():integer;
var
   parent :TNodeBoite;
   node :  TNodeBoite;
   nb,i:integer;
begin
  result:=-1;
     if  nodeParent <> NIL   then
        begin
        nb:=nodeParent.nodeChilds.count ;
        if nb>0  then
          begin
           for i:=0 to nb-1 do
              begin
               node:=TNodeBoite(nodeParent.nodeChilds.Items[i]);
               if (node <> nil) and (node = Self) then
                 begin
                   result := i;
                   break;
                 end;
               end;
           end;
         end;
end;


function TNodeBoite.getChild(index:integer): TNodeBoite;
var
  node :  TNodeBoite;
   nb :integer;
begin
  result:=nil;
  nb := nodeChilds.count ;
        if (nb>0) and (index<nb)  then
         result:=TNodeBoite( nodeChilds.Items[index]);
end;

function TNodeBoite.getFrereGauche(): TNodeBoite;
var
  node :  TNodeBoite;
   index,nb :integer;
begin
  result:=nil;
  index :=getIndex();
  if (index > 0) then
   begin
      if  nodeParent <> NIL   then
         result:=nodeParent.getChild(index-1);
   end;      
end;

//**********************************************************************************/

procedure TnodeBoite.DeleteNodeG();
var
 nodeG, nodeGF : TNodeBoiteG ;
   begin

     nodeG :=  nodeAssocG ;
     if (nodeG <> nil) then
     begin
       if ( taxonsLibres.count>0) and (nodeChilds.count >0) then
         begin
           nodeGF := nodeG.nodeChildsG.Items[0];
            nodeGF.Free ;
        end;
      nodeG.Free;
     end;
     nodeAssocG := nil ;
 end;

 //Cration des noeuds graphiques : elle se fait  partir des noeuds normaux. Si un noeud a des taxons libres
// alors un noeud graphique est cr en plus sans quivalent

procedure TnodeBoite.CreerNodeG(AParent:TCustomControl);
var
 nodeG, nodeP, nodeGF : TNodeBoiteG ;
   begin

     nodeG := TNodeBoiteG.CreateObject(AParent);    // constructeur

     nodeAssocG := nodeG;
     nodeG.nodeAssoc :=self ;

      if (nodeParent = nil) then      // root n'est pas associ  des caracteres
        begin
        nodeG.caracteresG := TStringList.create ;
         //  nodeG.caracteresG.add('');
          // modifi par jfr 06/07
          nodeG.caracteresG := caracteres ;
        end;

     if (nodeParent <> nil) then
        begin
           nodeG.nodeParentG :=  nodeParent.nodeAssocG;
           nodeG.nodeParentG.nodeChildsG.add(nodeG);   // un noeud graphique s'ajoute  son parent graphique
           nodeG.caracteresG := caracteres ;
        end;

     if ((taxonsLibres.count>0)and (nodeChilds.Count <> 0)) then
         begin
           nodeGF := TNodeBoiteG.CreateObject(AParent);     // on cre un nouveau noeud graphique qui correspond aux taxons libres
           nodeGF.nodeParentG := nodeG   ;                  // et qui va tre le fils de celui qui a t cr
           nodeGF.taxonsG := taxonsLibres ;
           nodeGF.niveauG := 1;
           nodeGF.nodeAssoc :=nil;
           nodeGF.caracteresG := TStringList.create ;
           nodeGF.caracteresG.add('');

           nodeG.nodeChildsG.Add(nodeGF);
        end
     else if (nodeChilds.Count = 0) then
         begin
          nodeG.taxonsG := taxons ;
         if  (nodeParent <>nil ) then nodeG.niveauG := 1;
         end;
 end;

//*****************************************************************************/
//**********************************************************************************/


constructor TTreeBoite.createBoite;
 begin

 root:=nil ;
 lastNode:=nil;
 niveauxDefinis:=false;
end;
// Pour un noeud (nodeBoite) de l'arborescence (treeBoite), correspond
procedure TTreeBoite.CreerNodeG(AParent:TCustomControl);
begin
  // fonction rcursive qui part de "root" pour ensuite descendre toute la structure arborescente
 CreerNodeGraphique(root, AParent );
 end;

procedure TTreeBoite.DeleteNodeG();
begin
 // DeleteNodeGraphique(root);
 end;

procedure TTreeBoite.DeleteNodeGraphique( aNode:TNodeBoite);
 var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.deleteNodeG();
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
          if (nodef<>nil) then DeleteNodeGraphique(nodef);
      end;
  end;

// fonction rcursive qui parcourt tout l'arbre  partir de "root"
procedure TTreeBoite.CreerNodeGraphique( aNode:TNodeBoite ; AParent:TCustomControl);
 var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.creerNodeG(Aparent);
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
          if (nodef<>nil) then CreerNodeGraphique(nodef,AParent);
      end;
  end;

procedure TTreeBoite.CreerTaxonsLibres();
begin
 CreerNodeTaxonsLibres(root);
 end;



procedure TTreeBoite.DeleteTaxonsLibres();
begin
// DeleteNodeTaxonsLibres(root);
 end;

procedure TTreeBoite.DeleteNodeTaxonsLibres(aNode : TNodeBoite);
var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.taxonsLibres.clear;
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
          if (nodef<>nil) then CreerNodeTaxonsLibres(nodef);
      end;
  end;


procedure TTreeBoite.CreerNodeTaxonsLibres(aNode : TNodeBoite);
var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.creerTaxonsLibres();
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
          if (nodef<>nil) then CreerNodeTaxonsLibres(nodef);
      end;
  end;

procedure TTreeBoite.annuleNodelevel(aNode : TNodeBoite);
var
  j :integer;
  nodef :TNodeBoite;
  begin
  anode.Niveau:=0;
   for j:=0 to anode.nodechilds.Count-1 do
      begin
         nodef := TnodeBoite(anode.nodechilds.items[j]) ;
         annuleNodelevel(nodef);
      end;
  end;

procedure TTreeBoite.annulerNiveaux();
 begin
  niveauxDefinis:=false;
  annuleNodeLevel(root);
 end;

procedure TTreeBoite.annuleNodelevelG(aNodeG : TNodeBoiteG);
var
  j :integer;
  nodefG :TNodeBoiteG;
  begin
  anodeG.NiveauG:=0;
   for j:=0 to anodeG.nodechildsG.Count-1 do
      begin
         nodefG := TnodeBoiteG(anodeG.nodechildsG.items[j]) ;
         annuleNodelevelG(nodefG);
      end;
  end;

procedure TTreeBoite.annulerNiveauxG();
 begin
  niveauxDefinisG:=false;
  annuleNodeLevelG(root.nodeAssocG);
 end;

procedure TTreeBoite.defineNodelevel(aNode : TNodeBoite);
var
  ret,j :integer;
  nodef :TNodeBoite;
 begin
   if (aNode.niveau=0) then
    begin
       if (anode.nodeChilds.count=0) then anode.niveau:=1
       else
         begin
           ret:=anode.defineNiveau();
           if (ret>0) then
             anode.niveau:=ret
           else begin
             niveauxDefinis:=false;
             for j:=0 to anode.nodechilds.Count-1 do
               begin
                nodef := TnodeBoite(anode.nodechilds.items[j]) ;
                defineNodelevel(nodef);
                end;
            end;
          end;
      end;
 end;

procedure TTreeBoite.defineNodelevelG(aNodeG : TNodeBoiteG);
var
  ret,j :integer;
  nodefG :TNodeBoiteG;
 begin
   if (aNodeG.niveauG=0) then
    begin
       if (anodeG.nodeChildsG.count=0) then anodeG.niveauG:=1
       else
         begin
           ret:=anodeG.defineNiveauG();
           if (ret>0) then
             anodeG.niveauG:=ret
           else begin
             niveauxDefinisG:=false;
             for j:=0 to anodeG.nodechildsG.Count-1 do
               begin
                nodefG := TnodeBoiteG(anodeG.nodechildsG.items[j]) ;
                defineNodelevelG(nodefG);
                end;
            end;
          end;
      end;
 end;

procedure TTreeBoite.definirNiveaux();
 begin
  niveauxDefinis:=false ;
   while(niveauxDefinis=false) do
     begin
       niveauxDefinis:= true;
       defineNodelevel(root);
     end;
end;

procedure TTreeBoite.definirNiveauxG();
 begin
  niveauxDefinisG:=false ;
   while(niveauxDefinisG=false) do
     begin
       niveauxDefinisG:= true;
       defineNodelevelG(root.nodeAssocG);
     end;
end;

procedure TTreeBoite.testNodeLevelG(anode :TnodeBoiteG ; level : integer ; liste : TList)   ;
   var
   i : integer ;
   nodefg : TNodeboiteG ;
   
    begin
      if (anode.niveauG=level)then liste.add(anode);
        for   i:=0 to  anode.nodeChildsG.count-1 do
         begin
          nodefg :=anode.nodechildsG.items[i] ;
          testNodeLevelG(nodefg,level,liste);
         end;
    end;

//***************************************************************************************/
function TTreeBoite. getNbNiveaux():integer  ;
 begin
  result:=root.nodeAssocG.niveauG ;
 end;

procedure TTreeBoite.creerListeNodeLevel (level : integer ; liste : TList)  ;
begin
     testNodeLevelG(root.nodeAssocG ,level,liste);

end;
//***************************************************************************************/
// Fonction qui retourne le premier noeud qui contient le caractere "caractere"
 function  TTreeBoite.getFirstNode(aNode:TNodeBoite ; caractere :String): TNodeBoite;
   begin
     nodeTemp:=nil;
     FirstNode(aNode, caractere);
     result:= nodeTemp;
   end;

// Utilise pour la rcursion
 function  TTreeBoite. FirstNode( aNode :TNodeBoite ; caractere: String  ): TNodeBoite;
  var
  nodename :String  ;
  index ,j :integer;
  NodeF :TNodeBoite ;
    begin
       index:= aNode.caracteres.indexof(caractere);
               if (index>=0) then
                 begin
                  if (nodeTemp=nil) then begin nodeTemp :=aNode;
                                               result:= nodeTemp;
                                          end ;
                  end
               else
               begin
                 for  j := 0 to aNode.nodeChilds.count-1 do
                   begin
                     if (nodeTemp<> nil)then break;
                      nodeF := TNodeBoite( aNode.nodeChilds.Items[j]);;
                      FirstNode(nodeF,caractere);
                     end;
                end;
  result:=nodeTemp;
  end;

function TTreeBoite.enlever_un_tri(caractere : String):boolean ;
var
node, nodeP, nodeF : TnodeBoite ;
index,i : integer;
begin
result := false;
  node := getFirstNode(root, caractere);
  if (node <> nil) then
    begin
    result := true;
    // pour tenir comptes des boites qui ont plusieurs "caractres"
      if (node.caracteres.count >1) then
        begin
         index:=node.caracteres.indexof(caractere)  ;
         node.caracteres.Delete(index);
         end
      else
      begin
      nodeP := node.nodeParent;
      if (nodeP <> nil) then
        begin
          try
            index := nodeP.nodeChilds.Remove(node);
              for i:=0 to node.nodechilds.count-1 do
                begin
                  nodeF := node.nodechilds.items[i];
                  nodeP.nodeChilds.Insert(index+i,nodeF);
                  nodeF.nodeParent:=nodeP;
                 end;
                except
               result := false;
           end;
           node.Free;
        end
       else   begin node.caracteres.Clear ; node.caracteres.add('');    end;
       end;

    end;
  
end;

function TTreeBoite.ajouter_un_tri(caractere : String ; etatderive :string) :  String;
var
row,col, nb, i :integer;
taxon ,carac,etat: String ;
node, nodeP : TNodeBoite ;
aResult : String ;
begin
aResult :='false';
node := TNodeBoite.create;                 // on cre un nodeboite vide
col :=  tabdata.IndexOfCol(caractere);    // index de la colonne qui contient le caractre slectionn dans la grille des donnes
nb := tabdata.rowcount;
etat:= lowercase(trim(etatderive));

 for i:=1 to nb-1 do
    begin
        aResult :='primitif';
        carac := tabdata.strItems[ i,col];
        if (carac <> '') then begin
           carac := lowercase(trim(carac));
           if ( carac = etat) then  begin  aResult :='false';break; end;   // On rajoute  la liste des taxons du nodeboite tous ceux qui prsentent l'tat driv
        end;                                                                // dans la grille des donnes
    end;
 if ( aResult = 'primitif') then begin result := aResult ; exit ;end; 
  for i:=1 to nb-1 do
    begin
        carac := tabdata.strItems[ i,col];
        if (carac <> '') then begin
         carac := lowercase(trim(carac));
         if ( carac = etat) then node.taxons.add(tabdata.strItems[ i,0]) ;    // On rajoute  la liste des taxons du nodeboite tous ceux qui prsentent l'tat driv
          end;                                                                // dans la grille des donnes
    end;
 if (node.taxons.Count>0) then
    begin                                                                      // On rajoute au nodeboite le caractre
     node.caracteres.Add(caractere);
     nodeP :=  dernier_noeud_qui_inclut(node);
     // le dernier noeud qui inclut peut tre gal en "taxon" au noeud pere
     // si un des fils du futur pere contient en partie le nouveau noeud, il y a erreur
     if (nodeP.childsintersectIncomplet(node) = true) then  aResult:='false'
     else begin
          aResult:='true';
          if   (node.egal(nodeP) = true )
          then
            if(nodeP <> self.root)   then
               begin
                  if (nodeP.caracteres.IndexOf(caractere)= -1)
                      then nodeP.caracteres.Add(caractere)
                   else aResult:='false'
               end
             else
                 begin
                    nodeP.premier_caractere:=caractere ;
                   if (nodeP.caracteres[0]='') then  nodeP.caracteres.Clear;
                    nodeP.caracteres.Add(caractere);
                   end
          else
             begin
                 node.premier_caractere:=caractere;
                 // On regarde si les fils du futur pere ne sont pas inclus dans le nouveau noeud
                 // auquel cas on modifie la hirarchie
                 node.arrangeFilsDuPere(nodeP);
                 nodeP.nodeChilds.Add(node);
                 node.nodeParent := nodeP ;
              end;
          end;
     end;
     result:=aResult;
end;



function TTreeBoite.dernier_noeud_qui_inclut(newnode : TNodeBoite): TNodeBoite;
begin
 lastNode := nil;
 dni(root,newnode);
 result:= lastNode;
end;

// parcourt rcursif de l'arbre tant  qu'on trouve un noeud qui inclut le nouveau noeud  : revient donc
//  trouver le dernier noeud qui inclut le nouveau noeud
procedure TTreeBoite.dni( nodep : TNodeBoite ; newnode : TNodeBoite);
 var
 i,nb:integer;
 nodefils : TNodeBoite;
 begin
  if (nodep.Inclut(newnode)) then
   begin
   lastNode:=nodep;
    nb := nodep.nodeChilds.count ;
        if nb>0  then
           begin
              for i:=0 to nb-1 do
               begin
                 nodefils := TNodeBoite( nodep.nodeChilds.Items[i])  ;
                 if (nodefils <> nil)  then dni(nodefils,newnode);
               end;
            end;
   end;
 end;

//****************************************************************************/
constructor TNodeBoiteG.CreateObject(AParent:TcustomControl);
 begin
  inherited CreateObject(AParent);
  nodeChildsG:=Tlist.Create;
  nodeparentG:=nil ;
  niveauG := 0;
  taxonsG := nil ;
  end;

//****************************************************************************/
function TNodeBoiteG.getIndex():integer;
var
   parent :TNodeBoiteG;
   node :  TNodeBoiteG;
   nb,i:integer;
begin
  result:=-1;
     if  nodeParentG <> NIL   then
        begin
        nb:=nodeParentG.nodeChildsG.count ;
        if nb>0  then
          begin
           for i:=0 to nb-1 do
              begin
               node:=TNodeBoiteG(nodeParentG.nodeChildsG.Items[i]);
               if (node <> nil) and (node = Self) then
                 begin
                   result := i;
                   break;
                 end;
               end;
           end;
         end;
end;

function TNodeBoiteG.getFrereGaucheG(): TNodeBoiteG;
var
  node :  TNodeBoiteG;
   index,nb :integer;
begin
  result:=nil;
  index :=getIndex();
  if (index > 0) then
   begin
      if  nodeParentG <> NIL   then
         result:=nodeParentG.nodeChildsG.items[index-1];
   end;      
end;


destructor TNodeBoiteG.Destroy;
begin
 nodeChildsG.free;
 inherited destroy;
 end;

 function BoxCoordwidth (Atext :string; ACanvas:TCanvas; Top :TPoint; intX:integer):integer;
var
widthText  :integer;
 begin
   widthText:=ACanvas.TextWidth(Atext);
  result:=Top.X+widthText+intX;
end;

function BoxCoordHeight (Atext :string; ACanvas:TCanvas; Top :TPoint;intY :integer):integer;
var
heightText  :integer;

 begin
   heightText:=ACanvas.Textheight(AText);
  result:=Top.Y+ heightText+intY;
end;

function BoxDrawbis(Atext :string; niveau:integer; ACanvas:TCanvas; IsRect :boolean;
                  Top :TPoint; EndX,intY :integer):integer;
var
widthText, heightText, width, height,OrgXText,OrgYText :integer;
Bottom:TPoint;
chaine :String;
 begin
   widthText:=ACanvas.TextWidth(Atext);
   heightText:=ACanvas.Textheight(Atext);

   Bottom.X:=EndX;
   Bottom.Y:=Top.Y+heightText+ intY ;

   width:=Bottom.X-Top.X+1;
   height:=Bottom.Y-Top.Y+1;

  OrgXText:=Top.X+(width-widthText) div 2;
  OrgYText:=Top.Y+(height-heightText) div 2;

  if IsRect=true then  ACanvas.Rectangle(Top.X-1,Top.Y-1,Bottom.X+2,Bottom.Y+2);
   chaine :=intToStr(niveau);
  ACanvas.TextOut(OrgXText,OrgYText-1,AText+chaine);

  Result :=Bottom.Y;
end;

function BoxDraw(Atext :string; ACanvas:TCanvas; IsRect :boolean;
                  Top :TPoint; EndX,intY :integer):integer;
var
widthText, heightText, width, height,OrgXText,OrgYText :integer;
Bottom:TPoint;

 begin
   widthText:=ACanvas.TextWidth(Atext);
   heightText:=ACanvas.Textheight(Atext);

   Bottom.X:=EndX;
   Bottom.Y:=Top.Y+heightText+ intY ;

   width:=Bottom.X-Top.X+1;
   height:=Bottom.Y-Top.Y+1;

  OrgXText:=Top.X+(width-widthText) div 2;
  OrgYText:=Top.Y+(height-heightText) div 2;

  if IsRect=true then  ACanvas.Rectangle(Top.X-1,Top.Y-1,Bottom.X+2,Bottom.Y+2);

  ACanvas.TextOut(OrgXText,OrgYText-1,AText);

  Result :=Bottom.Y;
end;

function TNodeBoiteG.GetShadowColor(BaseColor: TColor; delta:Byte): TColor;
var r,g,b : integer;
begin
r:=GetRValue(ColorToRGB(BaseColor))-delta;
g:=GetGValue(ColorToRGB(BaseColor))-delta;
b:=GetBValue(ColorToRGB(BaseColor))-delta;
if (r>0) and (g>0) and (b>0) then
Result := RGB(r,g,b)
else Result:=BaseColor;
{begin
  Result := RGB(Max(GetRValue(ColorToRGB(BaseColor)) - Value, 0),
                Max(GetGValue(ColorToRGB(BaseColor)) - Value, 0),
                Max(GetBValue(ColorToRGB(BaseColor)) - Value, 0) );  }
end;
procedure TNodeBoiteG.draw(ACanvas:TCanvas);
var
 OldColor: TColor ;
 OldStyle: TBrushStyle;
 ListText:TStringList;

 Pt1 :TPoint;
 index ,caracX, caracY,bottom, diff:integer;
 EndX, EndY:integer;
 i :integer;
begin
  // varaiables  redclarer dans le graphtri3

  caracX  :=2  ;
  CaracY :=1  ;

  Pt1.x:=OrgX;
  Pt1.y:=OrgY;


OldColor:= ACanvas.brush.color;
OldStyle:= ACanvas.brush.style;

ACanvas.brush.style:=bssolid;
ACanvas.brush.Color:=clLtgray;
EndX := OrgX + larg;
EndY:=  OrgY + haut;

if ( caracteresG<>nil) and (caracteresG[0]<>'') then
 begin
   bottom:= BoxCoordHeight(caracteresG[0],ACanvas,Pt1,caracY);
   ACanvas.brush.Color:=clLtgray;
   ACanvas.Rectangle(OrgX-1,OrgY-1,EndX+2,bottom);
   // jfr modifie le 07/07 pour faire apparaitre les caractres en gras
   ACanvas.Font.Style := [fsBold];

   // manire inlgante de rsoudre le problme de l'affichage de
   // plusieurs en ttes
   for i:=0 to caracteresG.Count-1 do
      Pt1.y:=BoxDraw (caracteresG[i], ACanvas,false,Pt1,EndX,caracY)+1;
     //ACanvas.brush.color:=NodeColor[Color_No_Select]   ;
     if (niveauG >= 17) then   ACanvas.brush.color:=clWhite 
     else ACanvas.brush.color:=NodeColorbis[niveauG];
     //ACanvas.brush.color:=GetShadowColor( ACanvas.brush.color,niveauG);
     //ACanvas.brush.Color:=clLtgray;
     ACanvas.Rectangle(OrgX-1,OrgY-1,EndX+2,Pt1.y-1);
   Pt1.y:=OrgY;
    for i:=0 to caracteresG.Count-1 do
      Pt1.y:=BoxDraw (caracteresG[i], ACanvas,false,Pt1,EndX,caracY)+1;      
  end ;
//else
bottom:=Pt1.y-1;

diff:=bottom-Pt1.y+1;

ACanvas.brush.Color:=clwhite;

if ( caracteresG<>nil) and (caracteresG[0]<>'') then
  Acanvas.pen.style :=   psSolid
 else
// Acanvas.pen.style := psDot ;
Acanvas.pen.style := psClear ;

//ACanvas.Rectangle(OrgX-1,bottom,EndX+2,EndY+2+diff);
 ACanvas.Font.Style := [];
ACanvas.Rectangle(OrgX-1,bottom,EndX+2,EndY);
if ( taxonsG<>nil) and (taxonsG.Count > 0) then
 begin
  for index:=0 to taxonsG.Count-1 do
    Pt1.y:=BoxDraw(taxonsG[index],ACanvas,false,Pt1,EndX,caracY);
  end;


 ACanvas.brush.color:= OldColor;
 ACanvas.brush.style:=OldStyle ;

end;


end.
 