unit phylClasser;

interface


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CustomGraph2, GraphTri, StdCtrls, Grids, MyNewgrid,listarray2,group2,
  TreeCLGR,ExtCtrls,boite, GraphTri3,typedef,Donnees;

type
  TFormClasser = class(TForm)
    TabGrid1: TTabGrid;

    Panel1: TPanel;
    Splitter1: TSplitter;
    GraphTri21: TGraphTri2;
    procedure TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
//    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ChargeTabGrid(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

    procedure GraphTri21MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure TabGrid1DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
      {procedure afficherNode (node :TNodeBoite)    ;
      procedure afficherNodeG (nodeG :TNodeBoiteG)  ;  }
  private
    { Dclarations prives}
  public
     TabCod : TStrListArray;
     function  rechercherEtatDerive( caractere :String): string;
    { Dclarations publiques}
  end;

var
  FormClasser: TFormClasser;

implementation

uses PhylChoi, PhylMain;

{$R *.DFM}

{procedure TFormClasser.afficherNode (node :TNodeBoite)  ;
var
i,j:integer;
nbfils, nbtaxons :integer;
nodefils : TNodeBoite;
begin
    nbfils := node.nodeChilds.count;
    memo1.Lines.Clear;
    memo1.Lines.Add(node.caracteres[0]) ;
    memo1.lines.Add('niveau du noeud : '+ intToStr(node.niveau));
    memo1.Lines.add(' nombre de noeuds fils ' + intToStr(nbfils)) ;
    nbtaxons := node.taxons.count;
    memo1.Lines.add (' nombre de taxons ' + intToStr(nbtaxons) );

    for i:=0 to nbtaxons-1 do
         memo1.Lines.add (' taxons (' + intToStr(i)+')' + node.taxons[i])  ;
    memo1.Lines.add('');     
     for i:=0 to nbfils-1 do
      begin
        nodefils := node.nodechilds.items[i];
        afficherNode (nodefils) ;
      end;
end;

procedure TFormClasser.afficherNodeG (nodeG :TNodeBoiteG)  ;
var
i,j:integer;
nbfils, nbtaxons :integer;
nodefils : TNodeBoiteG;
begin
    nbfils := nodeG.nodeChildsG.count;
    memo1.Lines.Add(nodeG.caracteresG[0]) ;
    memo1.lines.Add('niveau du noeud : '+ intToStr(nodeG.niveauG));
    memo1.Lines.add(' nombre de noeuds fils ' + intToStr(nbfils)) ;
    if (nodeG.taxonsG <> nil) then nbtaxons := nodeG.taxonsG.count
    else nbtaxons :=0 ;

    memo1.Lines.add (' nombre de taxons ' + intToStr(nbtaxons) );

    for i:=0 to nbtaxons-1 do
         memo1.Lines.add (' taxons (' + intToStr(i)+')' + nodeG.taxonsG[i])  ;
    memo1.Lines.add('');     
     for i:=0 to nbfils-1 do
      begin
        nodefils := nodeG.nodechildsG.items[i];
        afficherNodeG (nodefils) ;
      end;
end;

}

function TFormClasser.rechercherEtatDerive( caractere :String): string;
 var
  noRow,compt,max,code:integer;
  AName:string;
  etat,codeStr: string ;
 begin

  noRow:=  TabCod.IndexOfRow(caractere);
  compt:=2;
  max:=0;
  result:='';
 while (compt <=  TabCod.ColCount[noRow]) do      // par principe l'tat driv est celui dont le code est le plus lv
  begin                                           // on le recherche donc...
   etat:= TabCod.StrItems[noRow,compt];
   if ((etat<>'') and (Trim(etat)<>''))     then
    begin
     codeStr:=TabCod.StrItems[noRow,compt+1];
     code:=StrToInt(codeStr);
     if (code > max ) then begin  max:=code; result:= etat; end;
    end;
   compt:=compt+2;
  end;
end;

procedure TFormClasser.TabGrid1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
col,row,noRow,compt,max:integer;
AName:string;
node : TNodeBoite ;
aRet: String;
etat: string ;
ret:boolean;

begin
TabGrid1.MouseToCell(X,Y,col,row);
if (row=0) and (col<>0) and (button=mbleft) then   // (button=mbleft) rajout le 12/01
 begin
 if(pos('Arbre',FormPrinc.Activite)<>0) or (pos('Classer',FormPrinc.Activite)<>0)
     then FormPrinc.Activite:='Classer';

 if TabGrid1.SelectCol[col]=false then    // La fonction selfMouseDown met  false une cellule
  begin                                   // sur laquelle on a cliqu : c'est parce que pour les
  AName:=TabGrid1.Cells[col,row];         // arbres les cellules sont slectionnes d'emble
  etat:=rechercherEtatDerive( AName);

  aRet:=graphtri21.treeBoite.ajouter_un_tri(AName,etat);      // On ajoute un tri si c'est possible

   if (aRet='true') then
     begin
      GraphTri21.ChangeGraphObjects;
      GraphTri21.invalidate;
      TabGrid1.SelectCol[col]:=true;  // jfr modifie le 06/09/00
      TabGrid1.invalidate;            // jfr modifie le 06/09/00
     end
   else  begin
         if (aRet='primitif')
         then ShowMessage('Cration d''une nouvelle boite impossible car tous les taxons prsentent l''tat primitif du caractre')
         else if (aRet='false') then ShowMessage('Cration d''une nouvelle boite impossible car les taxons qu''elle contiendrait appartiennent dj  des boites diffrentes');
         end;
 end else                        // Tout se passe comme si le caractre tait dj slectionn et donc avait dj particip  la construction de boites
       begin
         AName:=TabGrid1.Cells[col,row];
         
         ret:=graphtri21.treeBoite.enlever_un_tri(AName);       // On enlve un tri
         GraphTri21.ChangeGraphObjects;
         GraphTri21.invalidate;


          if (ret=true) then
           begin
              TabGrid1.SelectCol[col]:=false;  // jfr modifie le 06/09/00
              TabGrid1.invalidate;            // jfr modifie le 06/09/00
            end ;

       end;   
  end;
 if (row=0) and (col<>0) and (button=mbright) then   // (button=mbright) rajout le 10/09/00
  begin
 if(FormPrinc.Activite='Classer-Arbre')then FormPrinc.Activite:='Classer';
    if TabGrid1.SelectCol[col]=false then TabGrid1.SelectCol[col]:=true
      else TabGrid1.SelectCol[col]:=false;
  end;
end;

procedure TFormClasser.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 FormPrinc.AClasse:=nil;
 GraphTri21.ChangeGraphObjects;
 TabGrid1.SelectAllCol(false);
end;

procedure TFormClasser.ChargeTabGrid(Sender: TObject);
var
  ListArray: TStrListArray;
  node : TNodeBoite;
   row :integer;
  taxon :string;
begin
  if FormPrinc.AClasse = nil then
  begin
    ListArray:=TStrListArray.createlistArray;
     FormChoisir.TabGrid1.CopyToAlistArray(0,0,ListArray);


// ajout DL 20/02/98
   TabGrid1.RowCount:=FormChoisir.TabGrid1.RowCount;
   TabGrid1.ColCount:=FormChoisir.TabGrid1.ColCount;

    TabGrid1.copyFromAlistArray(0,0,ListArray);
    FormChoisir.Tabgrid1.CopyToAListArray(0,0,FormPrinc.Adata);

   FormPrinc.AClasse:= graphtri21.treeBoite;

   graphtri21.treeBoite.tabData := TStrListArray.createlistArray;
   FormChoisir.TabGrid1.CopyToAlistArray(0,0,graphtri21.treeBoite.tabData);

  { if (tabcod=nil)
    then TabCod:=TStrListArray.createListArray
    else Tabcod.ClearListArray(nodelete);   }

   TabCod:=TStrListArray.createListArray ;
   TTabGrid(TabGrid1).CreateTabCod(TabCod);

   node := TNodeBoite.create ;

   for row:=1 to graphtri21.treeBoite.TabData.RowCount-1 do
    begin
    taxon:=graphtri21.treeBoite.TabData.StrItems[row,0];
    if trim(taxon)<>'' then node.taxons.Add(Taxon);
    end;
   // node.caracteres.Add(' ')  ;
    node.caracteres.Add('')  ;
    graphtri21.treeBoite.root := node ;

      graphtri21.treeBoite.CreerTaxonsLibres();
      graphtri21.treeBoite.creerNodeG(GraphTri21);
      graphtri21.treeBoite.definirNiveauxG();
      graphtri21.ActivePage.Items[0,0]:=node.nodeassocG;
      graphtri21.invalidate;
 end;

   
end;

procedure TFormClasser.FormCreate(Sender: TObject);
begin
   FormPrinc.Fille(Self);
end;

 // jfr modifie le 07/03/02    fonction rajoute
procedure TFormClasser.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
if button=mbright       then application.messagebox('Activer la fonction Arbre' , 'Option',mb_ok);
end;

// jfr modifie le 07/03/02    fonction rajoute    Attention  modifier le fichier dfm en appellant cette fonction  travers l'inspecteur d'objet et la proprit on
// onMouseUp de graphtri
procedure TFormClasser.GraphTri21MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

begin
if button=mbright then
  begin
  if application.messagebox('Activer la fonction Arbre ?' , 'Option',mb_okcancel)=IDOK
  
    then if (AfficherArbre = 'oui') then FormPrinc.Arbre1.Enabled:=true;
  end;
end;

procedure TFormClasser.TabGrid1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
  var
  AName,AEtat,etat :String;

  begin
if (Acol >= 1) then begin
AName:=TabGrid1.Cells[ACol,0];         // arbres les cellules sont slectionnes d'emble
if  (AName <> '') then
 begin
   etat:=rechercherEtatDerive( AName);
   if (ARow >=1) then
              begin
                AEtat := TabGrid1.Cells[ACol,ARow];
                if  (AEtat=etat) then            // Pour colorer le fond du texte correspondant  une cellule dont l'tat est volu
                    begin
                      
                      TabGrid1.DrawCellTextbis(ACol,ARow,Rect,ETO_CLIPPED);
                    end;
               end;
  end;                    

 end;

 
end;

end.
